/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothProfile;
import android.bluetooth.IBluetoothHeadset;
import android.bluetooth.IBluetoothManager;
import android.bluetooth.IBluetoothProfileServiceConnection;
import android.bluetooth.IBluetoothStateChangeCallback;
import android.content.ComponentName;
import android.content.Context;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.util.Log;
import com.google.errorprone.annotations.DoNotMock;
import java.util.ArrayList;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class BluetoothHeadset
implements BluetoothProfile,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "BluetoothHeadset";
    private static boolean DBG = true;
    private static boolean VDBG = false;
    public static String ACTION_CONNECTION_STATE_CHANGED = "android.bluetooth.headset.profile.action.CONNECTION_STATE_CHANGED";
    public static String ACTION_AUDIO_STATE_CHANGED = "android.bluetooth.headset.profile.action.AUDIO_STATE_CHANGED";
    public static String ACTION_VENDOR_SPECIFIC_HEADSET_EVENT = "android.bluetooth.headset.action.VENDOR_SPECIFIC_HEADSET_EVENT";
    public static String EXTRA_VENDOR_SPECIFIC_HEADSET_EVENT_CMD = "android.bluetooth.headset.extra.VENDOR_SPECIFIC_HEADSET_EVENT_CMD";
    public static String EXTRA_VENDOR_SPECIFIC_HEADSET_EVENT_CMD_TYPE = "android.bluetooth.headset.extra.VENDOR_SPECIFIC_HEADSET_EVENT_CMD_TYPE";
    public static int AT_CMD_TYPE_READ = 0;
    public static int AT_CMD_TYPE_TEST = 1;
    public static int AT_CMD_TYPE_SET = 2;
    public static int AT_CMD_TYPE_BASIC = 3;
    public static int AT_CMD_TYPE_ACTION = 4;
    public static String EXTRA_VENDOR_SPECIFIC_HEADSET_EVENT_ARGS = "android.bluetooth.headset.extra.VENDOR_SPECIFIC_HEADSET_EVENT_ARGS";
    public static String VENDOR_SPECIFIC_HEADSET_EVENT_COMPANY_ID_CATEGORY = "android.bluetooth.headset.intent.category.companyid";
    public static String VENDOR_RESULT_CODE_COMMAND_ANDROID = "+ANDROID";
    public static int STATE_AUDIO_DISCONNECTED = 10;
    public static int STATE_AUDIO_CONNECTING = 11;
    public static String ACTION_HF_INDICATORS_VALUE_CHANGED = "android.bluetooth.headset.action.HF_INDICATORS_VALUE_CHANGED";
    public static String EXTRA_HF_INDICATORS_IND_ID = "android.bluetooth.headset.extra.HF_INDICATORS_IND_ID";
    public static String EXTRA_HF_INDICATORS_IND_VALUE = "android.bluetooth.headset.extra.HF_INDICATORS_IND_VALUE";
    public static int STATE_AUDIO_CONNECTED = 12;
    private static int MESSAGE_HEADSET_SERVICE_CONNECTED = 100;
    private static int MESSAGE_HEADSET_SERVICE_DISCONNECTED = 101;
    private Context mContext;
    private BluetoothProfile.ServiceListener mServiceListener;
    private IBluetoothHeadset mService;
    private BluetoothAdapter mAdapter;
    private IBluetoothStateChangeCallback mBluetoothStateChangeCallback;
    private IBluetoothProfileServiceConnection mConnection;
    private Handler mHandler;

    private void $$robo$$android_bluetooth_BluetoothHeadset$__constructor__(Context context, BluetoothProfile.ServiceListener l) {
        this.mBluetoothStateChangeCallback = new ShadowedObject(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ BluetoothHeadset this$0;

            private void $$robo$$android_bluetooth_BluetoothHeadset_1$__constructor__(BluetoothHeadset this$0) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_bluetooth_BluetoothHeadset_1$onBluetoothStateChange(boolean up) {
                Log.d("BluetoothHeadset", "onBluetoothStateChange: up=" + up);
                if (!up) {
                    this.this$0.doUnbind();
                } else {
                    IBluetoothProfileServiceConnection iBluetoothProfileServiceConnection = this.this$0.mConnection;
                    synchronized (iBluetoothProfileServiceConnection) {
                        try {
                            if (this.this$0.mService == null) {
                                this.this$0.doBind();
                            }
                        }
                        catch (Exception re) {
                            Log.e("BluetoothHeadset", "", re);
                        }
                    }
                }
            }

            private void __constructor__(BluetoothHeadset bluetoothHeadset) {
                this.$$robo$$android_bluetooth_BluetoothHeadset_1$__constructor__(bluetoothHeadset);
            }
            {
                this.this$0 = bluetoothHeadset;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_BluetoothHeadset_1$__constructor__(android.bluetooth.BluetoothHeadset ), this, bluetoothHeadset);
            }

            @Override
            public void onBluetoothStateChange(boolean bl) {
                InvokeDynamicSupport.bootstrap("onBluetoothStateChange", $$robo$$android_bluetooth_BluetoothHeadset_1$onBluetoothStateChange(boolean ), this, bl);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mConnection = new ShadowedObject(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ BluetoothHeadset this$0;

            private void $$robo$$android_bluetooth_BluetoothHeadset_2$__constructor__(BluetoothHeadset this$0) {
            }

            private final void $$robo$$android_bluetooth_BluetoothHeadset_2$onServiceConnected(ComponentName className, IBinder service) {
                Log.d("BluetoothHeadset", "Proxy object connected");
                this.this$0.mService = IBluetoothHeadset.Stub.asInterface(Binder.allowBlocking(service));
                this.this$0.mHandler.sendMessage(this.this$0.mHandler.obtainMessage(100));
            }

            private final void $$robo$$android_bluetooth_BluetoothHeadset_2$onServiceDisconnected(ComponentName className) {
                Log.d("BluetoothHeadset", "Proxy object disconnected");
                this.this$0.mService = null;
                this.this$0.mHandler.sendMessage(this.this$0.mHandler.obtainMessage(101));
            }

            private void __constructor__(BluetoothHeadset bluetoothHeadset) {
                this.$$robo$$android_bluetooth_BluetoothHeadset_2$__constructor__(bluetoothHeadset);
            }
            {
                this.this$0 = bluetoothHeadset;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_BluetoothHeadset_2$__constructor__(android.bluetooth.BluetoothHeadset ), this, bluetoothHeadset);
            }

            @Override
            public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
                InvokeDynamicSupport.bootstrap("onServiceConnected", $$robo$$android_bluetooth_BluetoothHeadset_2$onServiceConnected(android.content.ComponentName android.os.IBinder ), this, componentName, iBinder);
            }

            @Override
            public void onServiceDisconnected(ComponentName componentName) {
                InvokeDynamicSupport.bootstrap("onServiceDisconnected", $$robo$$android_bluetooth_BluetoothHeadset_2$onServiceDisconnected(android.content.ComponentName ), this, componentName);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mHandler = new ShadowedObject(this, Looper.getMainLooper()){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ BluetoothHeadset this$0;

            private void $$robo$$android_bluetooth_BluetoothHeadset_3$__constructor__(BluetoothHeadset this$0, Looper looper) {
            }

            private final void $$robo$$android_bluetooth_BluetoothHeadset_3$handleMessage(Message msg) {
                switch (msg.what) {
                    case 100: {
                        if (this.this$0.mServiceListener == null) break;
                        this.this$0.mServiceListener.onServiceConnected(1, this.this$0);
                        break;
                    }
                    case 101: {
                        if (this.this$0.mServiceListener == null) break;
                        this.this$0.mServiceListener.onServiceDisconnected(1);
                    }
                }
            }

            private void __constructor__(BluetoothHeadset bluetoothHeadset, Looper looper) {
                this.$$robo$$android_bluetooth_BluetoothHeadset_3$__constructor__(bluetoothHeadset, looper);
            }
            {
                this.this$0 = bluetoothHeadset;
                super(looper);
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_BluetoothHeadset_3$__constructor__(android.bluetooth.BluetoothHeadset android.os.Looper ), this, bluetoothHeadset, looper);
            }

            @Override
            public void handleMessage(Message message) {
                InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_bluetooth_BluetoothHeadset_3$handleMessage(android.os.Message ), this, message);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mContext = context;
        this.mServiceListener = l;
        this.mAdapter = BluetoothAdapter.getDefaultAdapter();
        IBluetoothManager mgr = this.mAdapter.getBluetoothManager();
        if (mgr != null) {
            try {
                mgr.registerStateChangeCallback(this.mBluetoothStateChangeCallback);
            }
            catch (RemoteException e) {
                Log.e("BluetoothHeadset", "", e);
            }
        }
        this.doBind();
    }

    private final boolean $$robo$$android_bluetooth_BluetoothHeadset$doBind() {
        try {
            return this.mAdapter.getBluetoothManager().bindBluetoothProfileService(1, this.mConnection);
        }
        catch (RemoteException e) {
            Log.e("BluetoothHeadset", "Unable to bind HeadsetService", e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_bluetooth_BluetoothHeadset$doUnbind() {
        IBluetoothProfileServiceConnection iBluetoothProfileServiceConnection = this.mConnection;
        synchronized (iBluetoothProfileServiceConnection) {
            if (this.mService != null) {
                try {
                    this.mAdapter.getBluetoothManager().unbindBluetoothProfileService(1, this.mConnection);
                }
                catch (RemoteException e) {
                    Log.e("BluetoothHeadset", "Unable to unbind HeadsetService", e);
                }
            }
        }
    }

    private final void $$robo$$android_bluetooth_BluetoothHeadset$close() {
        IBluetoothManager mgr = this.mAdapter.getBluetoothManager();
        if (mgr != null) {
            try {
                mgr.unregisterStateChangeCallback(this.mBluetoothStateChangeCallback);
            }
            catch (Exception e) {
                Log.e("BluetoothHeadset", "", e);
            }
        }
        this.mServiceListener = null;
        this.doUnbind();
    }

    private final boolean $$robo$$android_bluetooth_BluetoothHeadset$connect(BluetoothDevice device) {
        BluetoothHeadset.log("connect(" + device + ")");
        if (this.mService != null && this.isEnabled() && this.isValidDevice(device)) {
            try {
                return this.mService.connect(device);
            }
            catch (RemoteException e) {
                Log.e("BluetoothHeadset", Log.getStackTraceString(new Throwable()));
                return false;
            }
        }
        if (this.mService == null) {
            Log.w("BluetoothHeadset", "Proxy not attached to service");
        }
        return false;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothHeadset$disconnect(BluetoothDevice device) {
        BluetoothHeadset.log("disconnect(" + device + ")");
        if (this.mService != null && this.isEnabled() && this.isValidDevice(device)) {
            try {
                return this.mService.disconnect(device);
            }
            catch (RemoteException e) {
                Log.e("BluetoothHeadset", Log.getStackTraceString(new Throwable()));
                return false;
            }
        }
        if (this.mService == null) {
            Log.w("BluetoothHeadset", "Proxy not attached to service");
        }
        return false;
    }

    private final List<BluetoothDevice> $$robo$$android_bluetooth_BluetoothHeadset$getConnectedDevices() {
        if (this.mService != null && this.isEnabled()) {
            try {
                return this.mService.getConnectedDevices();
            }
            catch (RemoteException e) {
                Log.e("BluetoothHeadset", Log.getStackTraceString(new Throwable()));
                return new ArrayList<BluetoothDevice>();
            }
        }
        if (this.mService == null) {
            Log.w("BluetoothHeadset", "Proxy not attached to service");
        }
        return new ArrayList<BluetoothDevice>();
    }

    private final List<BluetoothDevice> $$robo$$android_bluetooth_BluetoothHeadset$getDevicesMatchingConnectionStates(int[] states) {
        if (this.mService != null && this.isEnabled()) {
            try {
                return this.mService.getDevicesMatchingConnectionStates(states);
            }
            catch (RemoteException e) {
                Log.e("BluetoothHeadset", Log.getStackTraceString(new Throwable()));
                return new ArrayList<BluetoothDevice>();
            }
        }
        if (this.mService == null) {
            Log.w("BluetoothHeadset", "Proxy not attached to service");
        }
        return new ArrayList<BluetoothDevice>();
    }

    private final int $$robo$$android_bluetooth_BluetoothHeadset$getConnectionState(BluetoothDevice device) {
        if (this.mService != null && this.isEnabled() && this.isValidDevice(device)) {
            try {
                return this.mService.getConnectionState(device);
            }
            catch (RemoteException e) {
                Log.e("BluetoothHeadset", Log.getStackTraceString(new Throwable()));
                return 0;
            }
        }
        if (this.mService == null) {
            Log.w("BluetoothHeadset", "Proxy not attached to service");
        }
        return 0;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothHeadset$setPriority(BluetoothDevice device, int priority) {
        BluetoothHeadset.log("setPriority(" + device + ", " + priority + ")");
        if (this.mService != null && this.isEnabled() && this.isValidDevice(device)) {
            if (priority != 0 && priority != 100) {
                return false;
            }
            try {
                return this.mService.setPriority(device, priority);
            }
            catch (RemoteException e) {
                Log.e("BluetoothHeadset", Log.getStackTraceString(new Throwable()));
                return false;
            }
        }
        if (this.mService == null) {
            Log.w("BluetoothHeadset", "Proxy not attached to service");
        }
        return false;
    }

    private final int $$robo$$android_bluetooth_BluetoothHeadset$getPriority(BluetoothDevice device) {
        if (this.mService != null && this.isEnabled() && this.isValidDevice(device)) {
            try {
                return this.mService.getPriority(device);
            }
            catch (RemoteException e) {
                Log.e("BluetoothHeadset", Log.getStackTraceString(new Throwable()));
                return 0;
            }
        }
        if (this.mService == null) {
            Log.w("BluetoothHeadset", "Proxy not attached to service");
        }
        return 0;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothHeadset$startVoiceRecognition(BluetoothDevice device) {
        BluetoothHeadset.log("startVoiceRecognition()");
        if (this.mService != null && this.isEnabled() && this.isValidDevice(device)) {
            try {
                return this.mService.startVoiceRecognition(device);
            }
            catch (RemoteException e) {
                Log.e("BluetoothHeadset", Log.getStackTraceString(new Throwable()));
            }
        }
        if (this.mService == null) {
            Log.w("BluetoothHeadset", "Proxy not attached to service");
        }
        return false;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothHeadset$stopVoiceRecognition(BluetoothDevice device) {
        BluetoothHeadset.log("stopVoiceRecognition()");
        if (this.mService != null && this.isEnabled() && this.isValidDevice(device)) {
            try {
                return this.mService.stopVoiceRecognition(device);
            }
            catch (RemoteException e) {
                Log.e("BluetoothHeadset", Log.getStackTraceString(new Throwable()));
            }
        }
        if (this.mService == null) {
            Log.w("BluetoothHeadset", "Proxy not attached to service");
        }
        return false;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothHeadset$isAudioConnected(BluetoothDevice device) {
        if (this.mService != null && this.isEnabled() && this.isValidDevice(device)) {
            try {
                return this.mService.isAudioConnected(device);
            }
            catch (RemoteException e) {
                Log.e("BluetoothHeadset", Log.getStackTraceString(new Throwable()));
            }
        }
        if (this.mService == null) {
            Log.w("BluetoothHeadset", "Proxy not attached to service");
        }
        return false;
    }

    private final int $$robo$$android_bluetooth_BluetoothHeadset$getBatteryUsageHint(BluetoothDevice device) {
        if (this.mService != null && this.isEnabled() && this.isValidDevice(device)) {
            try {
                return this.mService.getBatteryUsageHint(device);
            }
            catch (RemoteException e) {
                Log.e("BluetoothHeadset", Log.getStackTraceString(new Throwable()));
            }
        }
        if (this.mService == null) {
            Log.w("BluetoothHeadset", "Proxy not attached to service");
        }
        return -1;
    }

    private static final boolean $$robo$$android_bluetooth_BluetoothHeadset$isBluetoothVoiceDialingEnabled(Context context) {
        return context.getResources().getBoolean(17956902);
    }

    private final boolean $$robo$$android_bluetooth_BluetoothHeadset$acceptIncomingConnect(BluetoothDevice device) {
        BluetoothHeadset.log("acceptIncomingConnect");
        if (this.mService != null && this.isEnabled()) {
            try {
                return this.mService.acceptIncomingConnect(device);
            }
            catch (RemoteException e) {
                Log.e("BluetoothHeadset", e.toString());
            }
        } else {
            Log.w("BluetoothHeadset", "Proxy not attached to service");
            Log.d("BluetoothHeadset", Log.getStackTraceString(new Throwable()));
        }
        return false;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothHeadset$rejectIncomingConnect(BluetoothDevice device) {
        BluetoothHeadset.log("rejectIncomingConnect");
        if (this.mService != null) {
            try {
                return this.mService.rejectIncomingConnect(device);
            }
            catch (RemoteException e) {
                Log.e("BluetoothHeadset", e.toString());
            }
        } else {
            Log.w("BluetoothHeadset", "Proxy not attached to service");
            Log.d("BluetoothHeadset", Log.getStackTraceString(new Throwable()));
        }
        return false;
    }

    private final int $$robo$$android_bluetooth_BluetoothHeadset$getAudioState(BluetoothDevice device) {
        if (this.mService != null && !this.isDisabled()) {
            try {
                return this.mService.getAudioState(device);
            }
            catch (RemoteException e) {
                Log.e("BluetoothHeadset", e.toString());
            }
        } else {
            Log.w("BluetoothHeadset", "Proxy not attached to service");
            Log.d("BluetoothHeadset", Log.getStackTraceString(new Throwable()));
        }
        return 10;
    }

    private final void $$robo$$android_bluetooth_BluetoothHeadset$setAudioRouteAllowed(boolean allowed) {
        if (this.mService != null && this.isEnabled()) {
            try {
                this.mService.setAudioRouteAllowed(allowed);
            }
            catch (RemoteException e) {
                Log.e("BluetoothHeadset", e.toString());
            }
        } else {
            Log.w("BluetoothHeadset", "Proxy not attached to service");
            Log.d("BluetoothHeadset", Log.getStackTraceString(new Throwable()));
        }
    }

    private final boolean $$robo$$android_bluetooth_BluetoothHeadset$getAudioRouteAllowed() {
        if (this.mService != null && this.isEnabled()) {
            try {
                return this.mService.getAudioRouteAllowed();
            }
            catch (RemoteException e) {
                Log.e("BluetoothHeadset", e.toString());
            }
        } else {
            Log.w("BluetoothHeadset", "Proxy not attached to service");
            Log.d("BluetoothHeadset", Log.getStackTraceString(new Throwable()));
        }
        return false;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothHeadset$isAudioOn() {
        if (this.mService != null && this.isEnabled()) {
            try {
                return this.mService.isAudioOn();
            }
            catch (RemoteException e) {
                Log.e("BluetoothHeadset", Log.getStackTraceString(new Throwable()));
            }
        }
        if (this.mService == null) {
            Log.w("BluetoothHeadset", "Proxy not attached to service");
        }
        return false;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothHeadset$connectAudio() {
        if (this.mService != null && this.isEnabled()) {
            try {
                return this.mService.connectAudio();
            }
            catch (RemoteException e) {
                Log.e("BluetoothHeadset", e.toString());
            }
        } else {
            Log.w("BluetoothHeadset", "Proxy not attached to service");
            Log.d("BluetoothHeadset", Log.getStackTraceString(new Throwable()));
        }
        return false;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothHeadset$disconnectAudio() {
        if (this.mService != null && this.isEnabled()) {
            try {
                return this.mService.disconnectAudio();
            }
            catch (RemoteException e) {
                Log.e("BluetoothHeadset", e.toString());
            }
        } else {
            Log.w("BluetoothHeadset", "Proxy not attached to service");
            Log.d("BluetoothHeadset", Log.getStackTraceString(new Throwable()));
        }
        return false;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothHeadset$startScoUsingVirtualVoiceCall(BluetoothDevice device) {
        BluetoothHeadset.log("startScoUsingVirtualVoiceCall()");
        if (this.mService != null && this.isEnabled() && this.isValidDevice(device)) {
            try {
                return this.mService.startScoUsingVirtualVoiceCall(device);
            }
            catch (RemoteException e) {
                Log.e("BluetoothHeadset", e.toString());
            }
        } else {
            Log.w("BluetoothHeadset", "Proxy not attached to service");
            Log.d("BluetoothHeadset", Log.getStackTraceString(new Throwable()));
        }
        return false;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothHeadset$stopScoUsingVirtualVoiceCall(BluetoothDevice device) {
        BluetoothHeadset.log("stopScoUsingVirtualVoiceCall()");
        if (this.mService != null && this.isEnabled() && this.isValidDevice(device)) {
            try {
                return this.mService.stopScoUsingVirtualVoiceCall(device);
            }
            catch (RemoteException e) {
                Log.e("BluetoothHeadset", e.toString());
            }
        } else {
            Log.w("BluetoothHeadset", "Proxy not attached to service");
            Log.d("BluetoothHeadset", Log.getStackTraceString(new Throwable()));
        }
        return false;
    }

    private final void $$robo$$android_bluetooth_BluetoothHeadset$phoneStateChanged(int numActive, int numHeld, int callState, String number, int type) {
        if (this.mService != null && this.isEnabled()) {
            try {
                this.mService.phoneStateChanged(numActive, numHeld, callState, number, type);
            }
            catch (RemoteException e) {
                Log.e("BluetoothHeadset", e.toString());
            }
        } else {
            Log.w("BluetoothHeadset", "Proxy not attached to service");
            Log.d("BluetoothHeadset", Log.getStackTraceString(new Throwable()));
        }
    }

    private final void $$robo$$android_bluetooth_BluetoothHeadset$clccResponse(int index, int direction, int status, int mode, boolean mpty, String number, int type) {
        if (this.mService != null && this.isEnabled()) {
            try {
                this.mService.clccResponse(index, direction, status, mode, mpty, number, type);
            }
            catch (RemoteException e) {
                Log.e("BluetoothHeadset", e.toString());
            }
        } else {
            Log.w("BluetoothHeadset", "Proxy not attached to service");
            Log.d("BluetoothHeadset", Log.getStackTraceString(new Throwable()));
        }
    }

    private final boolean $$robo$$android_bluetooth_BluetoothHeadset$sendVendorSpecificResultCode(BluetoothDevice device, String command, String arg) {
        BluetoothHeadset.log("sendVendorSpecificResultCode()");
        if (command == null) {
            throw new IllegalArgumentException("command is null");
        }
        if (this.mService != null && this.isEnabled() && this.isValidDevice(device)) {
            try {
                return this.mService.sendVendorSpecificResultCode(device, command, arg);
            }
            catch (RemoteException e) {
                Log.e("BluetoothHeadset", Log.getStackTraceString(new Throwable()));
            }
        }
        if (this.mService == null) {
            Log.w("BluetoothHeadset", "Proxy not attached to service");
        }
        return false;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothHeadset$enableWBS() {
        if (this.mService != null && this.isEnabled()) {
            try {
                return this.mService.enableWBS();
            }
            catch (RemoteException e) {
                Log.e("BluetoothHeadset", e.toString());
            }
        } else {
            Log.w("BluetoothHeadset", "Proxy not attached to service");
            Log.d("BluetoothHeadset", Log.getStackTraceString(new Throwable()));
        }
        return false;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothHeadset$disableWBS() {
        if (this.mService != null && this.isEnabled()) {
            try {
                return this.mService.disableWBS();
            }
            catch (RemoteException e) {
                Log.e("BluetoothHeadset", e.toString());
            }
        } else {
            Log.w("BluetoothHeadset", "Proxy not attached to service");
            Log.d("BluetoothHeadset", Log.getStackTraceString(new Throwable()));
        }
        return false;
    }

    private static final boolean $$robo$$android_bluetooth_BluetoothHeadset$isInbandRingingSupported(Context context) {
        return context.getResources().getBoolean(0x1120022);
    }

    private final void $$robo$$android_bluetooth_BluetoothHeadset$bindResponse(int ind_id, boolean ind_status) {
        if (this.mService != null && this.isEnabled()) {
            try {
                this.mService.bindResponse(ind_id, ind_status);
            }
            catch (RemoteException e) {
                Log.e("BluetoothHeadset", e.toString());
            }
        } else {
            Log.w("BluetoothHeadset", "Proxy not attached to service");
            Log.d("BluetoothHeadset", Log.getStackTraceString(new Throwable()));
        }
    }

    private final boolean $$robo$$android_bluetooth_BluetoothHeadset$isEnabled() {
        return this.mAdapter.getState() == 12;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothHeadset$isDisabled() {
        return this.mAdapter.getState() == 10;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothHeadset$isValidDevice(BluetoothDevice device) {
        if (device == null) {
            return false;
        }
        return BluetoothAdapter.checkBluetoothAddress(device.getAddress());
    }

    private static final void $$robo$$android_bluetooth_BluetoothHeadset$log(String msg) {
        Log.d("BluetoothHeadset", msg);
    }

    private void __constructor__(Context context, BluetoothProfile.ServiceListener serviceListener) {
        this.$$robo$$android_bluetooth_BluetoothHeadset$__constructor__(context, serviceListener);
    }

    public BluetoothHeadset(Context context, BluetoothProfile.ServiceListener serviceListener) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_BluetoothHeadset$__constructor__(android.content.Context android.bluetooth.BluetoothProfile$ServiceListener ), this, context, serviceListener);
    }

    boolean doBind() {
        return (boolean)InvokeDynamicSupport.bootstrap("doBind", $$robo$$android_bluetooth_BluetoothHeadset$doBind(), this);
    }

    void doUnbind() {
        InvokeDynamicSupport.bootstrap("doUnbind", $$robo$$android_bluetooth_BluetoothHeadset$doUnbind(), this);
    }

    void close() {
        InvokeDynamicSupport.bootstrap("close", $$robo$$android_bluetooth_BluetoothHeadset$close(), this);
    }

    public boolean connect(BluetoothDevice bluetoothDevice) {
        return (boolean)InvokeDynamicSupport.bootstrap("connect", $$robo$$android_bluetooth_BluetoothHeadset$connect(android.bluetooth.BluetoothDevice ), this, bluetoothDevice);
    }

    public boolean disconnect(BluetoothDevice bluetoothDevice) {
        return (boolean)InvokeDynamicSupport.bootstrap("disconnect", $$robo$$android_bluetooth_BluetoothHeadset$disconnect(android.bluetooth.BluetoothDevice ), this, bluetoothDevice);
    }

    @Override
    public List<BluetoothDevice> getConnectedDevices() {
        return InvokeDynamicSupport.bootstrap("getConnectedDevices", $$robo$$android_bluetooth_BluetoothHeadset$getConnectedDevices(), this);
    }

    @Override
    public List<BluetoothDevice> getDevicesMatchingConnectionStates(int[] nArray) {
        return InvokeDynamicSupport.bootstrap("getDevicesMatchingConnectionStates", $$robo$$android_bluetooth_BluetoothHeadset$getDevicesMatchingConnectionStates(int[] ), this, nArray);
    }

    @Override
    public int getConnectionState(BluetoothDevice bluetoothDevice) {
        return (int)InvokeDynamicSupport.bootstrap("getConnectionState", $$robo$$android_bluetooth_BluetoothHeadset$getConnectionState(android.bluetooth.BluetoothDevice ), this, bluetoothDevice);
    }

    public boolean setPriority(BluetoothDevice bluetoothDevice, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("setPriority", $$robo$$android_bluetooth_BluetoothHeadset$setPriority(android.bluetooth.BluetoothDevice int ), this, bluetoothDevice, n);
    }

    public int getPriority(BluetoothDevice bluetoothDevice) {
        return (int)InvokeDynamicSupport.bootstrap("getPriority", $$robo$$android_bluetooth_BluetoothHeadset$getPriority(android.bluetooth.BluetoothDevice ), this, bluetoothDevice);
    }

    public boolean startVoiceRecognition(BluetoothDevice bluetoothDevice) {
        return (boolean)InvokeDynamicSupport.bootstrap("startVoiceRecognition", $$robo$$android_bluetooth_BluetoothHeadset$startVoiceRecognition(android.bluetooth.BluetoothDevice ), this, bluetoothDevice);
    }

    public boolean stopVoiceRecognition(BluetoothDevice bluetoothDevice) {
        return (boolean)InvokeDynamicSupport.bootstrap("stopVoiceRecognition", $$robo$$android_bluetooth_BluetoothHeadset$stopVoiceRecognition(android.bluetooth.BluetoothDevice ), this, bluetoothDevice);
    }

    public boolean isAudioConnected(BluetoothDevice bluetoothDevice) {
        return (boolean)InvokeDynamicSupport.bootstrap("isAudioConnected", $$robo$$android_bluetooth_BluetoothHeadset$isAudioConnected(android.bluetooth.BluetoothDevice ), this, bluetoothDevice);
    }

    public int getBatteryUsageHint(BluetoothDevice bluetoothDevice) {
        return (int)InvokeDynamicSupport.bootstrap("getBatteryUsageHint", $$robo$$android_bluetooth_BluetoothHeadset$getBatteryUsageHint(android.bluetooth.BluetoothDevice ), this, bluetoothDevice);
    }

    public static boolean isBluetoothVoiceDialingEnabled(Context context) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isBluetoothVoiceDialingEnabled", $$robo$$android_bluetooth_BluetoothHeadset$isBluetoothVoiceDialingEnabled(android.content.Context ), (Context)context);
    }

    public boolean acceptIncomingConnect(BluetoothDevice bluetoothDevice) {
        return (boolean)InvokeDynamicSupport.bootstrap("acceptIncomingConnect", $$robo$$android_bluetooth_BluetoothHeadset$acceptIncomingConnect(android.bluetooth.BluetoothDevice ), this, bluetoothDevice);
    }

    public boolean rejectIncomingConnect(BluetoothDevice bluetoothDevice) {
        return (boolean)InvokeDynamicSupport.bootstrap("rejectIncomingConnect", $$robo$$android_bluetooth_BluetoothHeadset$rejectIncomingConnect(android.bluetooth.BluetoothDevice ), this, bluetoothDevice);
    }

    public int getAudioState(BluetoothDevice bluetoothDevice) {
        return (int)InvokeDynamicSupport.bootstrap("getAudioState", $$robo$$android_bluetooth_BluetoothHeadset$getAudioState(android.bluetooth.BluetoothDevice ), this, bluetoothDevice);
    }

    public void setAudioRouteAllowed(boolean bl) {
        InvokeDynamicSupport.bootstrap("setAudioRouteAllowed", $$robo$$android_bluetooth_BluetoothHeadset$setAudioRouteAllowed(boolean ), this, bl);
    }

    public boolean getAudioRouteAllowed() {
        return (boolean)InvokeDynamicSupport.bootstrap("getAudioRouteAllowed", $$robo$$android_bluetooth_BluetoothHeadset$getAudioRouteAllowed(), this);
    }

    public boolean isAudioOn() {
        return (boolean)InvokeDynamicSupport.bootstrap("isAudioOn", $$robo$$android_bluetooth_BluetoothHeadset$isAudioOn(), this);
    }

    public boolean connectAudio() {
        return (boolean)InvokeDynamicSupport.bootstrap("connectAudio", $$robo$$android_bluetooth_BluetoothHeadset$connectAudio(), this);
    }

    public boolean disconnectAudio() {
        return (boolean)InvokeDynamicSupport.bootstrap("disconnectAudio", $$robo$$android_bluetooth_BluetoothHeadset$disconnectAudio(), this);
    }

    public boolean startScoUsingVirtualVoiceCall(BluetoothDevice bluetoothDevice) {
        return (boolean)InvokeDynamicSupport.bootstrap("startScoUsingVirtualVoiceCall", $$robo$$android_bluetooth_BluetoothHeadset$startScoUsingVirtualVoiceCall(android.bluetooth.BluetoothDevice ), this, bluetoothDevice);
    }

    public boolean stopScoUsingVirtualVoiceCall(BluetoothDevice bluetoothDevice) {
        return (boolean)InvokeDynamicSupport.bootstrap("stopScoUsingVirtualVoiceCall", $$robo$$android_bluetooth_BluetoothHeadset$stopScoUsingVirtualVoiceCall(android.bluetooth.BluetoothDevice ), this, bluetoothDevice);
    }

    public void phoneStateChanged(int n, int n2, int n3, String string2, int n4) {
        InvokeDynamicSupport.bootstrap("phoneStateChanged", $$robo$$android_bluetooth_BluetoothHeadset$phoneStateChanged(int int int java.lang.String int ), this, n, n2, n3, string2, n4);
    }

    public void clccResponse(int n, int n2, int n3, int n4, boolean bl, String string2, int n5) {
        InvokeDynamicSupport.bootstrap("clccResponse", $$robo$$android_bluetooth_BluetoothHeadset$clccResponse(int int int int boolean java.lang.String int ), this, n, n2, n3, n4, bl, string2, n5);
    }

    public boolean sendVendorSpecificResultCode(BluetoothDevice bluetoothDevice, String string2, String string3) {
        return (boolean)InvokeDynamicSupport.bootstrap("sendVendorSpecificResultCode", $$robo$$android_bluetooth_BluetoothHeadset$sendVendorSpecificResultCode(android.bluetooth.BluetoothDevice java.lang.String java.lang.String ), this, bluetoothDevice, string2, string3);
    }

    public boolean enableWBS() {
        return (boolean)InvokeDynamicSupport.bootstrap("enableWBS", $$robo$$android_bluetooth_BluetoothHeadset$enableWBS(), this);
    }

    public boolean disableWBS() {
        return (boolean)InvokeDynamicSupport.bootstrap("disableWBS", $$robo$$android_bluetooth_BluetoothHeadset$disableWBS(), this);
    }

    public static boolean isInbandRingingSupported(Context context) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isInbandRingingSupported", $$robo$$android_bluetooth_BluetoothHeadset$isInbandRingingSupported(android.content.Context ), (Context)context);
    }

    public void bindResponse(int n, boolean bl) {
        InvokeDynamicSupport.bootstrap("bindResponse", $$robo$$android_bluetooth_BluetoothHeadset$bindResponse(int boolean ), this, n, bl);
    }

    private boolean isEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isEnabled", $$robo$$android_bluetooth_BluetoothHeadset$isEnabled(), this);
    }

    private boolean isDisabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isDisabled", $$robo$$android_bluetooth_BluetoothHeadset$isDisabled(), this);
    }

    private boolean isValidDevice(BluetoothDevice bluetoothDevice) {
        return (boolean)InvokeDynamicSupport.bootstrap("isValidDevice", $$robo$$android_bluetooth_BluetoothHeadset$isValidDevice(android.bluetooth.BluetoothDevice ), this, bluetoothDevice);
    }

    private static void log(String string2) {
        InvokeDynamicSupport.bootstrapStatic("log", $$robo$$android_bluetooth_BluetoothHeadset$log(java.lang.String ), (String)string2);
    }

    public /* synthetic */ BluetoothHeadset() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BluetoothHeadset)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

