/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm;

import android.annotation.IntDef;
import android.appwidget.AppWidgetProviderInfo;
import android.content.ActivityNotFoundException;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentSender;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.pm.ILauncherApps;
import android.content.pm.IOnAppsChangedListener;
import android.content.pm.IPinItemRequest;
import android.content.pm.LauncherActivityInfo;
import android.content.pm.PackageManager;
import android.content.pm.ParceledListSlice;
import android.content.pm.ResolveInfo;
import android.content.pm.ShortcutInfo;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Rect;
import android.graphics.drawable.AdaptiveIconDrawable;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.Icon;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.os.Process;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.UserHandle;
import android.os.UserManager;
import android.util.Log;
import com.android.internal.util.Preconditions;
import com.google.errorprone.annotations.DoNotMock;
import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class LauncherApps
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    static String TAG = "LauncherApps";
    static boolean DEBUG = false;
    public static String ACTION_CONFIRM_PIN_SHORTCUT = "android.content.pm.action.CONFIRM_PIN_SHORTCUT";
    public static String ACTION_CONFIRM_PIN_APPWIDGET = "android.content.pm.action.CONFIRM_PIN_APPWIDGET";
    public static String EXTRA_PIN_ITEM_REQUEST = "android.content.pm.extra.PIN_ITEM_REQUEST";
    private Context mContext;
    private ILauncherApps mService;
    private PackageManager mPm;
    private UserManager mUserManager;
    private List<CallbackMessageHandler> mCallbacks;
    private IOnAppsChangedListener.Stub mAppsChangedListener;

    private void $$robo$$android_content_pm_LauncherApps$__constructor__(Context context, ILauncherApps service) {
        this.mCallbacks = new ArrayList<CallbackMessageHandler>();
        this.mAppsChangedListener = new ShadowedObject(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ LauncherApps this$0;

            private void $$robo$$android_content_pm_LauncherApps_1$__constructor__(LauncherApps this$0) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_content_pm_LauncherApps_1$onPackageRemoved(UserHandle user, String packageName) throws RemoteException {
                LauncherApps launcherApps = this.this$0;
                synchronized (launcherApps) {
                    for (CallbackMessageHandler callback : this.this$0.mCallbacks) {
                        callback.postOnPackageRemoved(packageName, user);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_content_pm_LauncherApps_1$onPackageChanged(UserHandle user, String packageName) throws RemoteException {
                LauncherApps launcherApps = this.this$0;
                synchronized (launcherApps) {
                    for (CallbackMessageHandler callback : this.this$0.mCallbacks) {
                        callback.postOnPackageChanged(packageName, user);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_content_pm_LauncherApps_1$onPackageAdded(UserHandle user, String packageName) throws RemoteException {
                LauncherApps launcherApps = this.this$0;
                synchronized (launcherApps) {
                    for (CallbackMessageHandler callback : this.this$0.mCallbacks) {
                        callback.postOnPackageAdded(packageName, user);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_content_pm_LauncherApps_1$onPackagesAvailable(UserHandle user, String[] packageNames, boolean replacing) throws RemoteException {
                LauncherApps launcherApps = this.this$0;
                synchronized (launcherApps) {
                    for (CallbackMessageHandler callback : this.this$0.mCallbacks) {
                        callback.postOnPackagesAvailable(packageNames, user, replacing);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_content_pm_LauncherApps_1$onPackagesUnavailable(UserHandle user, String[] packageNames, boolean replacing) throws RemoteException {
                LauncherApps launcherApps = this.this$0;
                synchronized (launcherApps) {
                    for (CallbackMessageHandler callback : this.this$0.mCallbacks) {
                        callback.postOnPackagesUnavailable(packageNames, user, replacing);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_content_pm_LauncherApps_1$onPackagesSuspended(UserHandle user, String[] packageNames) throws RemoteException {
                LauncherApps launcherApps = this.this$0;
                synchronized (launcherApps) {
                    for (CallbackMessageHandler callback : this.this$0.mCallbacks) {
                        callback.postOnPackagesSuspended(packageNames, user);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_content_pm_LauncherApps_1$onPackagesUnsuspended(UserHandle user, String[] packageNames) throws RemoteException {
                LauncherApps launcherApps = this.this$0;
                synchronized (launcherApps) {
                    for (CallbackMessageHandler callback : this.this$0.mCallbacks) {
                        callback.postOnPackagesUnsuspended(packageNames, user);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_content_pm_LauncherApps_1$onShortcutChanged(UserHandle user, String packageName, ParceledListSlice shortcuts) {
                List list = shortcuts.getList();
                LauncherApps launcherApps = this.this$0;
                synchronized (launcherApps) {
                    for (CallbackMessageHandler callback : this.this$0.mCallbacks) {
                        callback.postOnShortcutChanged(packageName, user, list);
                    }
                }
            }

            private void __constructor__(LauncherApps launcherApps) {
                this.$$robo$$android_content_pm_LauncherApps_1$__constructor__(launcherApps);
            }
            {
                this.this$0 = launcherApps;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_LauncherApps_1$__constructor__(android.content.pm.LauncherApps ), this, launcherApps);
            }

            @Override
            public void onPackageRemoved(UserHandle userHandle, String string2) throws RemoteException {
                InvokeDynamicSupport.bootstrap("onPackageRemoved", $$robo$$android_content_pm_LauncherApps_1$onPackageRemoved(android.os.UserHandle java.lang.String ), this, userHandle, string2);
            }

            @Override
            public void onPackageChanged(UserHandle userHandle, String string2) throws RemoteException {
                InvokeDynamicSupport.bootstrap("onPackageChanged", $$robo$$android_content_pm_LauncherApps_1$onPackageChanged(android.os.UserHandle java.lang.String ), this, userHandle, string2);
            }

            @Override
            public void onPackageAdded(UserHandle userHandle, String string2) throws RemoteException {
                InvokeDynamicSupport.bootstrap("onPackageAdded", $$robo$$android_content_pm_LauncherApps_1$onPackageAdded(android.os.UserHandle java.lang.String ), this, userHandle, string2);
            }

            @Override
            public void onPackagesAvailable(UserHandle userHandle, String[] stringArray, boolean bl) throws RemoteException {
                InvokeDynamicSupport.bootstrap("onPackagesAvailable", $$robo$$android_content_pm_LauncherApps_1$onPackagesAvailable(android.os.UserHandle java.lang.String[] boolean ), this, userHandle, stringArray, bl);
            }

            @Override
            public void onPackagesUnavailable(UserHandle userHandle, String[] stringArray, boolean bl) throws RemoteException {
                InvokeDynamicSupport.bootstrap("onPackagesUnavailable", $$robo$$android_content_pm_LauncherApps_1$onPackagesUnavailable(android.os.UserHandle java.lang.String[] boolean ), this, userHandle, stringArray, bl);
            }

            @Override
            public void onPackagesSuspended(UserHandle userHandle, String[] stringArray) throws RemoteException {
                InvokeDynamicSupport.bootstrap("onPackagesSuspended", $$robo$$android_content_pm_LauncherApps_1$onPackagesSuspended(android.os.UserHandle java.lang.String[] ), this, userHandle, stringArray);
            }

            @Override
            public void onPackagesUnsuspended(UserHandle userHandle, String[] stringArray) throws RemoteException {
                InvokeDynamicSupport.bootstrap("onPackagesUnsuspended", $$robo$$android_content_pm_LauncherApps_1$onPackagesUnsuspended(android.os.UserHandle java.lang.String[] ), this, userHandle, stringArray);
            }

            @Override
            public void onShortcutChanged(UserHandle userHandle, String string2, ParceledListSlice parceledListSlice) {
                InvokeDynamicSupport.bootstrap("onShortcutChanged", $$robo$$android_content_pm_LauncherApps_1$onShortcutChanged(android.os.UserHandle java.lang.String android.content.pm.ParceledListSlice ), this, userHandle, string2, parceledListSlice);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mContext = context;
        this.mService = service;
        this.mPm = context.getPackageManager();
        this.mUserManager = context.getSystemService(UserManager.class);
    }

    private void $$robo$$android_content_pm_LauncherApps$__constructor__(Context context) {
    }

    private final void $$robo$$android_content_pm_LauncherApps$logErrorForInvalidProfileAccess(UserHandle target) {
        if (UserHandle.myUserId() != target.getIdentifier() && this.mUserManager.isManagedProfile()) {
            Log.w("LauncherApps", "Accessing other profiles/users from managed profile is no longer allowed.");
        }
    }

    private final List<UserHandle> $$robo$$android_content_pm_LauncherApps$getProfiles() {
        if (this.mUserManager.isManagedProfile()) {
            ArrayList<UserHandle> result = new ArrayList<UserHandle>(1);
            result.add(Process.myUserHandle());
            return result;
        }
        return this.mUserManager.getUserProfiles();
    }

    private final List<LauncherActivityInfo> $$robo$$android_content_pm_LauncherApps$getActivityList(String packageName, UserHandle user) {
        this.logErrorForInvalidProfileAccess(user);
        try {
            return this.convertToActivityList(this.mService.getLauncherActivities(this.mContext.getPackageName(), packageName, user), user);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    private final LauncherActivityInfo $$robo$$android_content_pm_LauncherApps$resolveActivity(Intent intent, UserHandle user) {
        this.logErrorForInvalidProfileAccess(user);
        try {
            ActivityInfo ai = this.mService.resolveActivity(this.mContext.getPackageName(), intent.getComponent(), user);
            if (ai != null) {
                LauncherActivityInfo info = new LauncherActivityInfo(this.mContext, ai, user);
                return info;
            }
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
        return null;
    }

    private final void $$robo$$android_content_pm_LauncherApps$startMainActivity(ComponentName component, UserHandle user, Rect sourceBounds, Bundle opts) {
        this.logErrorForInvalidProfileAccess(user);
        try {
            this.mService.startActivityAsUser(this.mContext.getPackageName(), component, sourceBounds, opts, user);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_content_pm_LauncherApps$startAppDetailsActivity(ComponentName component, UserHandle user, Rect sourceBounds, Bundle opts) {
        this.logErrorForInvalidProfileAccess(user);
        try {
            this.mService.showAppDetailsAsUser(this.mContext.getPackageName(), component, sourceBounds, opts, user);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    private final List<LauncherActivityInfo> $$robo$$android_content_pm_LauncherApps$getShortcutConfigActivityList(String packageName, UserHandle user) {
        this.logErrorForInvalidProfileAccess(user);
        try {
            return this.convertToActivityList(this.mService.getShortcutConfigActivities(this.mContext.getPackageName(), packageName, user), user);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    private final List<LauncherActivityInfo> $$robo$$android_content_pm_LauncherApps$convertToActivityList(ParceledListSlice<ResolveInfo> activities, UserHandle user) {
        if (activities == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<LauncherActivityInfo> lais = new ArrayList<LauncherActivityInfo>();
        for (ResolveInfo ri : activities.getList()) {
            LauncherActivityInfo lai = new LauncherActivityInfo(this.mContext, ri.activityInfo, user);
            lais.add(lai);
        }
        return lais;
    }

    private final IntentSender $$robo$$android_content_pm_LauncherApps$getShortcutConfigActivityIntent(LauncherActivityInfo info) {
        try {
            return this.mService.getShortcutConfigActivityIntent(this.mContext.getPackageName(), info.getComponentName(), info.getUser());
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_content_pm_LauncherApps$isPackageEnabled(String packageName, UserHandle user) {
        this.logErrorForInvalidProfileAccess(user);
        try {
            return this.mService.isPackageEnabled(this.mContext.getPackageName(), packageName, user);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    private final ApplicationInfo $$robo$$android_content_pm_LauncherApps$getApplicationInfo(String packageName, int flags, UserHandle user) throws PackageManager.NameNotFoundException {
        Preconditions.checkNotNull(packageName, "packageName");
        Preconditions.checkNotNull(packageName, "user");
        this.logErrorForInvalidProfileAccess(user);
        try {
            ApplicationInfo ai = this.mService.getApplicationInfo(this.mContext.getPackageName(), packageName, flags, user);
            if (ai == null) {
                throw new PackageManager.NameNotFoundException("Package " + packageName + " not found for user " + user.getIdentifier());
            }
            return ai;
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_content_pm_LauncherApps$isActivityEnabled(ComponentName component, UserHandle user) {
        this.logErrorForInvalidProfileAccess(user);
        try {
            return this.mService.isActivityEnabled(this.mContext.getPackageName(), component, user);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_content_pm_LauncherApps$hasShortcutHostPermission() {
        try {
            return this.mService.hasShortcutHostPermission(this.mContext.getPackageName());
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    private final List<ShortcutInfo> $$robo$$android_content_pm_LauncherApps$getShortcuts(ShortcutQuery query, UserHandle user) {
        this.logErrorForInvalidProfileAccess(user);
        try {
            return this.mService.getShortcuts(this.mContext.getPackageName(), query.mChangedSince, query.mPackage, query.mShortcutIds, query.mActivity, query.mQueryFlags, user).getList();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    private final List<ShortcutInfo> $$robo$$android_content_pm_LauncherApps$getShortcutInfo(String packageName, List<String> ids, UserHandle user) {
        ShortcutQuery q = new ShortcutQuery();
        q.setPackage(packageName);
        q.setShortcutIds(ids);
        q.setQueryFlags(11);
        return this.getShortcuts(q, user);
    }

    private final void $$robo$$android_content_pm_LauncherApps$pinShortcuts(String packageName, List<String> shortcutIds, UserHandle user) {
        this.logErrorForInvalidProfileAccess(user);
        try {
            this.mService.pinShortcuts(this.mContext.getPackageName(), packageName, shortcutIds, user);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    private final int $$robo$$android_content_pm_LauncherApps$getShortcutIconResId(ShortcutInfo shortcut) {
        return shortcut.getIconResourceId();
    }

    @Deprecated
    private final int $$robo$$android_content_pm_LauncherApps$getShortcutIconResId(String packageName, String shortcutId, UserHandle user) {
        ShortcutQuery q = new ShortcutQuery();
        q.setPackage(packageName);
        q.setShortcutIds(Arrays.asList(shortcutId));
        q.setQueryFlags(11);
        List<ShortcutInfo> shortcuts = this.getShortcuts(q, user);
        return shortcuts.size() > 0 ? shortcuts.get(0).getIconResourceId() : 0;
    }

    private final ParcelFileDescriptor $$robo$$android_content_pm_LauncherApps$getShortcutIconFd(ShortcutInfo shortcut) {
        return this.getShortcutIconFd(shortcut.getPackage(), shortcut.getId(), shortcut.getUserId());
    }

    private final ParcelFileDescriptor $$robo$$android_content_pm_LauncherApps$getShortcutIconFd(String packageName, String shortcutId, UserHandle user) {
        return this.getShortcutIconFd(packageName, shortcutId, user.getIdentifier());
    }

    private final ParcelFileDescriptor $$robo$$android_content_pm_LauncherApps$getShortcutIconFd(String packageName, String shortcutId, int userId) {
        try {
            return this.mService.getShortcutIconFd(this.mContext.getPackageName(), packageName, shortcutId, userId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Drawable $$robo$$android_content_pm_LauncherApps$getShortcutIconDrawable(ShortcutInfo shortcut, int density) {
        if (shortcut.hasIconFile()) {
            ParcelFileDescriptor pfd = this.getShortcutIconFd(shortcut);
            if (pfd == null) {
                return null;
            }
            try {
                Bitmap bmp = BitmapFactory.decodeFileDescriptor(pfd.getFileDescriptor());
                if (bmp != null) {
                    BitmapDrawable dr = new BitmapDrawable(this.mContext.getResources(), bmp);
                    if (shortcut.hasAdaptiveBitmap()) {
                        AdaptiveIconDrawable adaptiveIconDrawable = new AdaptiveIconDrawable(null, dr);
                        return adaptiveIconDrawable;
                    }
                    BitmapDrawable bitmapDrawable = dr;
                    return bitmapDrawable;
                }
                Drawable drawable2 = null;
                return drawable2;
            }
            finally {
                try {
                    pfd.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (shortcut.hasIconResource()) {
            return this.loadDrawableResourceFromPackage(shortcut.getPackage(), shortcut.getIconResourceId(), shortcut.getUserHandle(), density);
        }
        if (shortcut.getIcon() != null) {
            Icon icon = shortcut.getIcon();
            switch (icon.getType()) {
                case 2: {
                    return this.loadDrawableResourceFromPackage(shortcut.getPackage(), icon.getResId(), shortcut.getUserHandle(), density);
                }
                case 1: 
                case 5: {
                    return icon.loadDrawable(this.mContext);
                }
            }
            return null;
        }
        return null;
    }

    private final Drawable $$robo$$android_content_pm_LauncherApps$loadDrawableResourceFromPackage(String packageName, int resId, UserHandle user, int density) {
        try {
            if (resId == 0) {
                return null;
            }
            ApplicationInfo ai = this.getApplicationInfo(packageName, 0, user);
            Resources res = this.mContext.getPackageManager().getResourcesForApplication(ai);
            return res.getDrawableForDensity(resId, density);
        }
        catch (PackageManager.NameNotFoundException | Resources.NotFoundException e) {
            return null;
        }
    }

    private final Drawable $$robo$$android_content_pm_LauncherApps$getShortcutBadgedIconDrawable(ShortcutInfo shortcut, int density) {
        Drawable originalIcon = this.getShortcutIconDrawable(shortcut, density);
        return originalIcon == null ? null : this.mContext.getPackageManager().getUserBadgedIcon(originalIcon, shortcut.getUserHandle());
    }

    private final void $$robo$$android_content_pm_LauncherApps$startShortcut(String packageName, String shortcutId, Rect sourceBounds, Bundle startActivityOptions, UserHandle user) {
        this.logErrorForInvalidProfileAccess(user);
        this.startShortcut(packageName, shortcutId, sourceBounds, startActivityOptions, user.getIdentifier());
    }

    private final void $$robo$$android_content_pm_LauncherApps$startShortcut(ShortcutInfo shortcut, Rect sourceBounds, Bundle startActivityOptions) {
        this.startShortcut(shortcut.getPackage(), shortcut.getId(), sourceBounds, startActivityOptions, shortcut.getUserId());
    }

    private final void $$robo$$android_content_pm_LauncherApps$startShortcut(String packageName, String shortcutId, Rect sourceBounds, Bundle startActivityOptions, int userId) {
        try {
            boolean success = this.mService.startShortcut(this.mContext.getPackageName(), packageName, shortcutId, sourceBounds, startActivityOptions, userId);
            if (!success) {
                throw new ActivityNotFoundException("Shortcut could not be started");
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_content_pm_LauncherApps$registerCallback(Callback callback) {
        this.registerCallback(callback, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_content_pm_LauncherApps$registerCallback(Callback callback, Handler handler) {
        LauncherApps launcherApps = this;
        synchronized (launcherApps) {
            if (callback != null && this.findCallbackLocked(callback) < 0) {
                boolean addedFirstCallback = this.mCallbacks.size() == 0;
                this.addCallbackLocked(callback, handler);
                if (addedFirstCallback) {
                    try {
                        this.mService.addOnAppsChangedListener(this.mContext.getPackageName(), this.mAppsChangedListener);
                    }
                    catch (RemoteException re) {
                        throw re.rethrowFromSystemServer();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_content_pm_LauncherApps$unregisterCallback(Callback callback) {
        LauncherApps launcherApps = this;
        synchronized (launcherApps) {
            this.removeCallbackLocked(callback);
            if (this.mCallbacks.size() == 0) {
                try {
                    this.mService.removeOnAppsChangedListener(this.mAppsChangedListener);
                }
                catch (RemoteException re) {
                    throw re.rethrowFromSystemServer();
                }
            }
        }
    }

    private final int $$robo$$android_content_pm_LauncherApps$findCallbackLocked(Callback callback) {
        if (callback == null) {
            throw new IllegalArgumentException("Callback cannot be null");
        }
        int size = this.mCallbacks.size();
        for (int i = 0; i < size; ++i) {
            if (this.mCallbacks.get(i).mCallback != callback) continue;
            return i;
        }
        return -1;
    }

    private final void $$robo$$android_content_pm_LauncherApps$removeCallbackLocked(Callback callback) {
        int pos = this.findCallbackLocked(callback);
        if (pos >= 0) {
            this.mCallbacks.remove(pos);
        }
    }

    private final void $$robo$$android_content_pm_LauncherApps$addCallbackLocked(Callback callback, Handler handler) {
        this.removeCallbackLocked(callback);
        if (handler == null) {
            handler = new Handler();
        }
        CallbackMessageHandler toAdd = new CallbackMessageHandler(handler.getLooper(), callback);
        this.mCallbacks.add(toAdd);
    }

    private final PinItemRequest $$robo$$android_content_pm_LauncherApps$getPinItemRequest(Intent intent) {
        return (PinItemRequest)intent.getParcelableExtra("android.content.pm.extra.PIN_ITEM_REQUEST");
    }

    private void __constructor__(Context context, ILauncherApps iLauncherApps) {
        this.$$robo$$android_content_pm_LauncherApps$__constructor__(context, iLauncherApps);
    }

    public LauncherApps(Context context, ILauncherApps iLauncherApps) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_LauncherApps$__constructor__(android.content.Context android.content.pm.ILauncherApps ), this, context, iLauncherApps);
    }

    private void __constructor__(Context context) {
        this.$$robo$$android_content_pm_LauncherApps$__constructor__(context);
    }

    public LauncherApps(Context context) {
        this(context, ILauncherApps.Stub.asInterface(ServiceManager.getService("launcherapps")));
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_LauncherApps$__constructor__(android.content.Context ), this, context);
    }

    private void logErrorForInvalidProfileAccess(UserHandle userHandle) {
        InvokeDynamicSupport.bootstrap("logErrorForInvalidProfileAccess", $$robo$$android_content_pm_LauncherApps$logErrorForInvalidProfileAccess(android.os.UserHandle ), this, userHandle);
    }

    public List<UserHandle> getProfiles() {
        return InvokeDynamicSupport.bootstrap("getProfiles", $$robo$$android_content_pm_LauncherApps$getProfiles(), this);
    }

    public List<LauncherActivityInfo> getActivityList(String string2, UserHandle userHandle) {
        return InvokeDynamicSupport.bootstrap("getActivityList", $$robo$$android_content_pm_LauncherApps$getActivityList(java.lang.String android.os.UserHandle ), this, string2, userHandle);
    }

    public LauncherActivityInfo resolveActivity(Intent intent, UserHandle userHandle) {
        return InvokeDynamicSupport.bootstrap("resolveActivity", $$robo$$android_content_pm_LauncherApps$resolveActivity(android.content.Intent android.os.UserHandle ), this, intent, userHandle);
    }

    public void startMainActivity(ComponentName componentName, UserHandle userHandle, Rect rect, Bundle bundle) {
        InvokeDynamicSupport.bootstrap("startMainActivity", $$robo$$android_content_pm_LauncherApps$startMainActivity(android.content.ComponentName android.os.UserHandle android.graphics.Rect android.os.Bundle ), this, componentName, userHandle, rect, bundle);
    }

    public void startAppDetailsActivity(ComponentName componentName, UserHandle userHandle, Rect rect, Bundle bundle) {
        InvokeDynamicSupport.bootstrap("startAppDetailsActivity", $$robo$$android_content_pm_LauncherApps$startAppDetailsActivity(android.content.ComponentName android.os.UserHandle android.graphics.Rect android.os.Bundle ), this, componentName, userHandle, rect, bundle);
    }

    public List<LauncherActivityInfo> getShortcutConfigActivityList(String string2, UserHandle userHandle) {
        return InvokeDynamicSupport.bootstrap("getShortcutConfigActivityList", $$robo$$android_content_pm_LauncherApps$getShortcutConfigActivityList(java.lang.String android.os.UserHandle ), this, string2, userHandle);
    }

    private List<LauncherActivityInfo> convertToActivityList(ParceledListSlice<ResolveInfo> parceledListSlice, UserHandle userHandle) {
        return InvokeDynamicSupport.bootstrap("convertToActivityList", $$robo$$android_content_pm_LauncherApps$convertToActivityList(android.content.pm.ParceledListSlice<android.content.pm.ResolveInfo> android.os.UserHandle ), this, parceledListSlice, userHandle);
    }

    public IntentSender getShortcutConfigActivityIntent(LauncherActivityInfo launcherActivityInfo) {
        return InvokeDynamicSupport.bootstrap("getShortcutConfigActivityIntent", $$robo$$android_content_pm_LauncherApps$getShortcutConfigActivityIntent(android.content.pm.LauncherActivityInfo ), this, launcherActivityInfo);
    }

    public boolean isPackageEnabled(String string2, UserHandle userHandle) {
        return (boolean)InvokeDynamicSupport.bootstrap("isPackageEnabled", $$robo$$android_content_pm_LauncherApps$isPackageEnabled(java.lang.String android.os.UserHandle ), this, string2, userHandle);
    }

    public ApplicationInfo getApplicationInfo(String string2, int n, UserHandle userHandle) throws PackageManager.NameNotFoundException {
        return InvokeDynamicSupport.bootstrap("getApplicationInfo", $$robo$$android_content_pm_LauncherApps$getApplicationInfo(java.lang.String int android.os.UserHandle ), this, string2, n, userHandle);
    }

    public boolean isActivityEnabled(ComponentName componentName, UserHandle userHandle) {
        return (boolean)InvokeDynamicSupport.bootstrap("isActivityEnabled", $$robo$$android_content_pm_LauncherApps$isActivityEnabled(android.content.ComponentName android.os.UserHandle ), this, componentName, userHandle);
    }

    public boolean hasShortcutHostPermission() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasShortcutHostPermission", $$robo$$android_content_pm_LauncherApps$hasShortcutHostPermission(), this);
    }

    public List<ShortcutInfo> getShortcuts(ShortcutQuery shortcutQuery, UserHandle userHandle) {
        return InvokeDynamicSupport.bootstrap("getShortcuts", $$robo$$android_content_pm_LauncherApps$getShortcuts(android.content.pm.LauncherApps$ShortcutQuery android.os.UserHandle ), this, shortcutQuery, userHandle);
    }

    @Deprecated
    public List<ShortcutInfo> getShortcutInfo(String string2, List<String> list, UserHandle userHandle) {
        return InvokeDynamicSupport.bootstrap("getShortcutInfo", $$robo$$android_content_pm_LauncherApps$getShortcutInfo(java.lang.String java.util.List<java.lang.String> android.os.UserHandle ), this, string2, list, userHandle);
    }

    public void pinShortcuts(String string2, List<String> list, UserHandle userHandle) {
        InvokeDynamicSupport.bootstrap("pinShortcuts", $$robo$$android_content_pm_LauncherApps$pinShortcuts(java.lang.String java.util.List<java.lang.String> android.os.UserHandle ), this, string2, list, userHandle);
    }

    @Deprecated
    public int getShortcutIconResId(ShortcutInfo shortcutInfo) {
        return (int)InvokeDynamicSupport.bootstrap("getShortcutIconResId", $$robo$$android_content_pm_LauncherApps$getShortcutIconResId(android.content.pm.ShortcutInfo ), this, shortcutInfo);
    }

    @Deprecated
    public int getShortcutIconResId(String string2, String string3, UserHandle userHandle) {
        return (int)InvokeDynamicSupport.bootstrap("getShortcutIconResId", $$robo$$android_content_pm_LauncherApps$getShortcutIconResId(java.lang.String java.lang.String android.os.UserHandle ), this, string2, string3, userHandle);
    }

    public ParcelFileDescriptor getShortcutIconFd(ShortcutInfo shortcutInfo) {
        return InvokeDynamicSupport.bootstrap("getShortcutIconFd", $$robo$$android_content_pm_LauncherApps$getShortcutIconFd(android.content.pm.ShortcutInfo ), this, shortcutInfo);
    }

    public ParcelFileDescriptor getShortcutIconFd(String string2, String string3, UserHandle userHandle) {
        return InvokeDynamicSupport.bootstrap("getShortcutIconFd", $$robo$$android_content_pm_LauncherApps$getShortcutIconFd(java.lang.String java.lang.String android.os.UserHandle ), this, string2, string3, userHandle);
    }

    private ParcelFileDescriptor getShortcutIconFd(String string2, String string3, int n) {
        return InvokeDynamicSupport.bootstrap("getShortcutIconFd", $$robo$$android_content_pm_LauncherApps$getShortcutIconFd(java.lang.String java.lang.String int ), this, string2, string3, n);
    }

    public Drawable getShortcutIconDrawable(ShortcutInfo shortcutInfo, int n) {
        return InvokeDynamicSupport.bootstrap("getShortcutIconDrawable", $$robo$$android_content_pm_LauncherApps$getShortcutIconDrawable(android.content.pm.ShortcutInfo int ), this, shortcutInfo, n);
    }

    private Drawable loadDrawableResourceFromPackage(String string2, int n, UserHandle userHandle, int n2) {
        return InvokeDynamicSupport.bootstrap("loadDrawableResourceFromPackage", $$robo$$android_content_pm_LauncherApps$loadDrawableResourceFromPackage(java.lang.String int android.os.UserHandle int ), this, string2, n, userHandle, n2);
    }

    public Drawable getShortcutBadgedIconDrawable(ShortcutInfo shortcutInfo, int n) {
        return InvokeDynamicSupport.bootstrap("getShortcutBadgedIconDrawable", $$robo$$android_content_pm_LauncherApps$getShortcutBadgedIconDrawable(android.content.pm.ShortcutInfo int ), this, shortcutInfo, n);
    }

    public void startShortcut(String string2, String string3, Rect rect, Bundle bundle, UserHandle userHandle) {
        InvokeDynamicSupport.bootstrap("startShortcut", $$robo$$android_content_pm_LauncherApps$startShortcut(java.lang.String java.lang.String android.graphics.Rect android.os.Bundle android.os.UserHandle ), this, string2, string3, rect, bundle, userHandle);
    }

    public void startShortcut(ShortcutInfo shortcutInfo, Rect rect, Bundle bundle) {
        InvokeDynamicSupport.bootstrap("startShortcut", $$robo$$android_content_pm_LauncherApps$startShortcut(android.content.pm.ShortcutInfo android.graphics.Rect android.os.Bundle ), this, shortcutInfo, rect, bundle);
    }

    private void startShortcut(String string2, String string3, Rect rect, Bundle bundle, int n) {
        InvokeDynamicSupport.bootstrap("startShortcut", $$robo$$android_content_pm_LauncherApps$startShortcut(java.lang.String java.lang.String android.graphics.Rect android.os.Bundle int ), this, string2, string3, rect, bundle, n);
    }

    public void registerCallback(Callback callback) {
        InvokeDynamicSupport.bootstrap("registerCallback", $$robo$$android_content_pm_LauncherApps$registerCallback(android.content.pm.LauncherApps$Callback ), this, callback);
    }

    public void registerCallback(Callback callback, Handler handler) {
        InvokeDynamicSupport.bootstrap("registerCallback", $$robo$$android_content_pm_LauncherApps$registerCallback(android.content.pm.LauncherApps$Callback android.os.Handler ), this, callback, handler);
    }

    public void unregisterCallback(Callback callback) {
        InvokeDynamicSupport.bootstrap("unregisterCallback", $$robo$$android_content_pm_LauncherApps$unregisterCallback(android.content.pm.LauncherApps$Callback ), this, callback);
    }

    private int findCallbackLocked(Callback callback) {
        return (int)InvokeDynamicSupport.bootstrap("findCallbackLocked", $$robo$$android_content_pm_LauncherApps$findCallbackLocked(android.content.pm.LauncherApps$Callback ), this, callback);
    }

    private void removeCallbackLocked(Callback callback) {
        InvokeDynamicSupport.bootstrap("removeCallbackLocked", $$robo$$android_content_pm_LauncherApps$removeCallbackLocked(android.content.pm.LauncherApps$Callback ), this, callback);
    }

    private void addCallbackLocked(Callback callback, Handler handler) {
        InvokeDynamicSupport.bootstrap("addCallbackLocked", $$robo$$android_content_pm_LauncherApps$addCallbackLocked(android.content.pm.LauncherApps$Callback android.os.Handler ), this, callback, handler);
    }

    public PinItemRequest getPinItemRequest(Intent intent) {
        return InvokeDynamicSupport.bootstrap("getPinItemRequest", $$robo$$android_content_pm_LauncherApps$getPinItemRequest(android.content.Intent ), this, intent);
    }

    public /* synthetic */ LauncherApps() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LauncherApps)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class PinItemRequest
    implements Parcelable,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public static int REQUEST_TYPE_SHORTCUT = 1;
        public static int REQUEST_TYPE_APPWIDGET = 2;
        private int mRequestType;
        private IPinItemRequest mInner;
        public static Parcelable.Creator<PinItemRequest> CREATOR;

        private void $$robo$$android_content_pm_LauncherApps_PinItemRequest$__constructor__(IPinItemRequest inner, int type) {
            this.mInner = inner;
            this.mRequestType = type;
        }

        private final int $$robo$$android_content_pm_LauncherApps_PinItemRequest$getRequestType() {
            return this.mRequestType;
        }

        private final ShortcutInfo $$robo$$android_content_pm_LauncherApps_PinItemRequest$getShortcutInfo() {
            try {
                return this.mInner.getShortcutInfo();
            }
            catch (RemoteException e) {
                throw e.rethrowAsRuntimeException();
            }
        }

        private final AppWidgetProviderInfo $$robo$$android_content_pm_LauncherApps_PinItemRequest$getAppWidgetProviderInfo(Context context) {
            try {
                AppWidgetProviderInfo info = this.mInner.getAppWidgetProviderInfo();
                if (info == null) {
                    return null;
                }
                info.updateDimensions(context.getResources().getDisplayMetrics());
                return info;
            }
            catch (RemoteException e) {
                throw e.rethrowAsRuntimeException();
            }
        }

        private final Bundle $$robo$$android_content_pm_LauncherApps_PinItemRequest$getExtras() {
            try {
                return this.mInner.getExtras();
            }
            catch (RemoteException e) {
                throw e.rethrowAsRuntimeException();
            }
        }

        private final boolean $$robo$$android_content_pm_LauncherApps_PinItemRequest$isValid() {
            try {
                return this.mInner.isValid();
            }
            catch (RemoteException e) {
                return false;
            }
        }

        private final boolean $$robo$$android_content_pm_LauncherApps_PinItemRequest$accept(Bundle options) {
            try {
                return this.mInner.accept(options);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }

        private final boolean $$robo$$android_content_pm_LauncherApps_PinItemRequest$accept() {
            return this.accept(null);
        }

        private void $$robo$$android_content_pm_LauncherApps_PinItemRequest$__constructor__(Parcel source) {
            ClassLoader cl = this.getClass().getClassLoader();
            this.mRequestType = source.readInt();
            this.mInner = IPinItemRequest.Stub.asInterface(source.readStrongBinder());
        }

        private final void $$robo$$android_content_pm_LauncherApps_PinItemRequest$writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.mRequestType);
            dest.writeStrongBinder(this.mInner.asBinder());
        }

        private final int $$robo$$android_content_pm_LauncherApps_PinItemRequest$describeContents() {
            return 0;
        }

        private /* synthetic */ void $$robo$$android_content_pm_LauncherApps_PinItemRequest$__constructor__(Parcel x0, 1 x1) {
        }

        static void __staticInitializer__() {
            CREATOR = new Parcelable.Creator<PinItemRequest>(){
                public /* synthetic */ Object __robo_data__;

                private void $$robo$$android_content_pm_LauncherApps_PinItemRequest_1$__constructor__() {
                }

                private final PinItemRequest $$robo$$android_content_pm_LauncherApps_PinItemRequest_1$createFromParcel(Parcel source) {
                    return new PinItemRequest(source, null);
                }

                private final PinItemRequest[] $$robo$$android_content_pm_LauncherApps_PinItemRequest_1$newArray(int size) {
                    return new PinItemRequest[size];
                }

                private void __constructor__() {
                    this.$$robo$$android_content_pm_LauncherApps_PinItemRequest_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_LauncherApps_PinItemRequest_1$__constructor__(), this);
                }

                @Override
                public PinItemRequest createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_content_pm_LauncherApps_PinItemRequest_1$createFromParcel(android.os.Parcel ), this, parcel);
                }

                public PinItemRequest[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_content_pm_LauncherApps_PinItemRequest_1$newArray(int ), this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private void __constructor__(IPinItemRequest iPinItemRequest, int n) {
            this.$$robo$$android_content_pm_LauncherApps_PinItemRequest$__constructor__(iPinItemRequest, n);
        }

        public PinItemRequest(IPinItemRequest iPinItemRequest, int n) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_LauncherApps_PinItemRequest$__constructor__(android.content.pm.IPinItemRequest int ), this, iPinItemRequest, n);
        }

        public int getRequestType() {
            return (int)InvokeDynamicSupport.bootstrap("getRequestType", $$robo$$android_content_pm_LauncherApps_PinItemRequest$getRequestType(), this);
        }

        public ShortcutInfo getShortcutInfo() {
            return InvokeDynamicSupport.bootstrap("getShortcutInfo", $$robo$$android_content_pm_LauncherApps_PinItemRequest$getShortcutInfo(), this);
        }

        public AppWidgetProviderInfo getAppWidgetProviderInfo(Context context) {
            return InvokeDynamicSupport.bootstrap("getAppWidgetProviderInfo", $$robo$$android_content_pm_LauncherApps_PinItemRequest$getAppWidgetProviderInfo(android.content.Context ), this, context);
        }

        public Bundle getExtras() {
            return InvokeDynamicSupport.bootstrap("getExtras", $$robo$$android_content_pm_LauncherApps_PinItemRequest$getExtras(), this);
        }

        public boolean isValid() {
            return (boolean)InvokeDynamicSupport.bootstrap("isValid", $$robo$$android_content_pm_LauncherApps_PinItemRequest$isValid(), this);
        }

        public boolean accept(Bundle bundle) {
            return (boolean)InvokeDynamicSupport.bootstrap("accept", $$robo$$android_content_pm_LauncherApps_PinItemRequest$accept(android.os.Bundle ), this, bundle);
        }

        public boolean accept() {
            return (boolean)InvokeDynamicSupport.bootstrap("accept", $$robo$$android_content_pm_LauncherApps_PinItemRequest$accept(), this);
        }

        private void __constructor__(Parcel parcel) {
            this.$$robo$$android_content_pm_LauncherApps_PinItemRequest$__constructor__(parcel);
        }

        public PinItemRequest(Parcel parcel) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_LauncherApps_PinItemRequest$__constructor__(android.os.Parcel ), this, parcel);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_content_pm_LauncherApps_PinItemRequest$writeToParcel(android.os.Parcel int ), this, parcel, n);
        }

        @Override
        public int describeContents() {
            return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_content_pm_LauncherApps_PinItemRequest$describeContents(), this);
        }

        private /* synthetic */ void __constructor__(Parcel parcel, 1 var2_2) {
            this.$$robo$$android_content_pm_LauncherApps_PinItemRequest$__constructor__(parcel, var2_2);
        }

        public /* synthetic */ PinItemRequest(Parcel parcel, 1 var2_2) {
            this(parcel);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_LauncherApps_PinItemRequest$__constructor__(android.os.Parcel android.content.pm.LauncherApps$1 ), this, parcel, var2_2);
        }

        static {
            RobolectricInternals.classInitializing(PinItemRequest.class);
        }

        public /* synthetic */ PinItemRequest() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PinItemRequest)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        @Retention(value=RetentionPolicy.SOURCE)
        @IntDef(value={1L})
        public static @interface RequestType {
        }
    }

    private static class CallbackMessageHandler
    extends Handler
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private static int MSG_ADDED = 1;
        private static int MSG_REMOVED = 2;
        private static int MSG_CHANGED = 3;
        private static int MSG_AVAILABLE = 4;
        private static int MSG_UNAVAILABLE = 5;
        private static int MSG_SUSPENDED = 6;
        private static int MSG_UNSUSPENDED = 7;
        private static int MSG_SHORTCUT_CHANGED = 8;
        private Callback mCallback;

        private void $$robo$$android_content_pm_LauncherApps_CallbackMessageHandler$__constructor__(Looper looper, Callback callback) {
            this.mCallback = callback;
        }

        private final void $$robo$$android_content_pm_LauncherApps_CallbackMessageHandler$handleMessage(Message msg) {
            if (this.mCallback == null || !(msg.obj instanceof CallbackInfo)) {
                return;
            }
            CallbackInfo info = (CallbackInfo)msg.obj;
            switch (msg.what) {
                case 1: {
                    this.mCallback.onPackageAdded(info.packageName, info.user);
                    break;
                }
                case 2: {
                    this.mCallback.onPackageRemoved(info.packageName, info.user);
                    break;
                }
                case 3: {
                    this.mCallback.onPackageChanged(info.packageName, info.user);
                    break;
                }
                case 4: {
                    this.mCallback.onPackagesAvailable(info.packageNames, info.user, info.replacing);
                    break;
                }
                case 5: {
                    this.mCallback.onPackagesUnavailable(info.packageNames, info.user, info.replacing);
                    break;
                }
                case 6: {
                    this.mCallback.onPackagesSuspended(info.packageNames, info.user);
                    break;
                }
                case 7: {
                    this.mCallback.onPackagesUnsuspended(info.packageNames, info.user);
                    break;
                }
                case 8: {
                    this.mCallback.onShortcutsChanged(info.packageName, info.shortcuts, info.user);
                }
            }
        }

        private final void $$robo$$android_content_pm_LauncherApps_CallbackMessageHandler$postOnPackageAdded(String packageName, UserHandle user) {
            CallbackInfo info = new CallbackInfo(null);
            info.packageName = packageName;
            info.user = user;
            this.obtainMessage(1, info).sendToTarget();
        }

        private final void $$robo$$android_content_pm_LauncherApps_CallbackMessageHandler$postOnPackageRemoved(String packageName, UserHandle user) {
            CallbackInfo info = new CallbackInfo(null);
            info.packageName = packageName;
            info.user = user;
            this.obtainMessage(2, info).sendToTarget();
        }

        private final void $$robo$$android_content_pm_LauncherApps_CallbackMessageHandler$postOnPackageChanged(String packageName, UserHandle user) {
            CallbackInfo info = new CallbackInfo(null);
            info.packageName = packageName;
            info.user = user;
            this.obtainMessage(3, info).sendToTarget();
        }

        private final void $$robo$$android_content_pm_LauncherApps_CallbackMessageHandler$postOnPackagesAvailable(String[] packageNames, UserHandle user, boolean replacing) {
            CallbackInfo info = new CallbackInfo(null);
            info.packageNames = packageNames;
            info.replacing = replacing;
            info.user = user;
            this.obtainMessage(4, info).sendToTarget();
        }

        private final void $$robo$$android_content_pm_LauncherApps_CallbackMessageHandler$postOnPackagesUnavailable(String[] packageNames, UserHandle user, boolean replacing) {
            CallbackInfo info = new CallbackInfo(null);
            info.packageNames = packageNames;
            info.replacing = replacing;
            info.user = user;
            this.obtainMessage(5, info).sendToTarget();
        }

        private final void $$robo$$android_content_pm_LauncherApps_CallbackMessageHandler$postOnPackagesSuspended(String[] packageNames, UserHandle user) {
            CallbackInfo info = new CallbackInfo(null);
            info.packageNames = packageNames;
            info.user = user;
            this.obtainMessage(6, info).sendToTarget();
        }

        private final void $$robo$$android_content_pm_LauncherApps_CallbackMessageHandler$postOnPackagesUnsuspended(String[] packageNames, UserHandle user) {
            CallbackInfo info = new CallbackInfo(null);
            info.packageNames = packageNames;
            info.user = user;
            this.obtainMessage(7, info).sendToTarget();
        }

        private final void $$robo$$android_content_pm_LauncherApps_CallbackMessageHandler$postOnShortcutChanged(String packageName, UserHandle user, List<ShortcutInfo> shortcuts) {
            CallbackInfo info = new CallbackInfo(null);
            info.packageName = packageName;
            info.user = user;
            info.shortcuts = shortcuts;
            this.obtainMessage(8, info).sendToTarget();
        }

        private void __constructor__(Looper looper, Callback callback) {
            this.$$robo$$android_content_pm_LauncherApps_CallbackMessageHandler$__constructor__(looper, callback);
        }

        public CallbackMessageHandler(Looper looper, Callback callback) {
            super(looper, null, true);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_LauncherApps_CallbackMessageHandler$__constructor__(android.os.Looper android.content.pm.LauncherApps$Callback ), this, looper, callback);
        }

        @Override
        public void handleMessage(Message message) {
            InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_content_pm_LauncherApps_CallbackMessageHandler$handleMessage(android.os.Message ), this, message);
        }

        public void postOnPackageAdded(String string2, UserHandle userHandle) {
            InvokeDynamicSupport.bootstrap("postOnPackageAdded", $$robo$$android_content_pm_LauncherApps_CallbackMessageHandler$postOnPackageAdded(java.lang.String android.os.UserHandle ), this, string2, userHandle);
        }

        public void postOnPackageRemoved(String string2, UserHandle userHandle) {
            InvokeDynamicSupport.bootstrap("postOnPackageRemoved", $$robo$$android_content_pm_LauncherApps_CallbackMessageHandler$postOnPackageRemoved(java.lang.String android.os.UserHandle ), this, string2, userHandle);
        }

        public void postOnPackageChanged(String string2, UserHandle userHandle) {
            InvokeDynamicSupport.bootstrap("postOnPackageChanged", $$robo$$android_content_pm_LauncherApps_CallbackMessageHandler$postOnPackageChanged(java.lang.String android.os.UserHandle ), this, string2, userHandle);
        }

        public void postOnPackagesAvailable(String[] stringArray, UserHandle userHandle, boolean bl) {
            InvokeDynamicSupport.bootstrap("postOnPackagesAvailable", $$robo$$android_content_pm_LauncherApps_CallbackMessageHandler$postOnPackagesAvailable(java.lang.String[] android.os.UserHandle boolean ), this, stringArray, userHandle, bl);
        }

        public void postOnPackagesUnavailable(String[] stringArray, UserHandle userHandle, boolean bl) {
            InvokeDynamicSupport.bootstrap("postOnPackagesUnavailable", $$robo$$android_content_pm_LauncherApps_CallbackMessageHandler$postOnPackagesUnavailable(java.lang.String[] android.os.UserHandle boolean ), this, stringArray, userHandle, bl);
        }

        public void postOnPackagesSuspended(String[] stringArray, UserHandle userHandle) {
            InvokeDynamicSupport.bootstrap("postOnPackagesSuspended", $$robo$$android_content_pm_LauncherApps_CallbackMessageHandler$postOnPackagesSuspended(java.lang.String[] android.os.UserHandle ), this, stringArray, userHandle);
        }

        public void postOnPackagesUnsuspended(String[] stringArray, UserHandle userHandle) {
            InvokeDynamicSupport.bootstrap("postOnPackagesUnsuspended", $$robo$$android_content_pm_LauncherApps_CallbackMessageHandler$postOnPackagesUnsuspended(java.lang.String[] android.os.UserHandle ), this, stringArray, userHandle);
        }

        public void postOnShortcutChanged(String string2, UserHandle userHandle, List<ShortcutInfo> list) {
            InvokeDynamicSupport.bootstrap("postOnShortcutChanged", $$robo$$android_content_pm_LauncherApps_CallbackMessageHandler$postOnShortcutChanged(java.lang.String android.os.UserHandle java.util.List<android.content.pm.ShortcutInfo> ), this, string2, userHandle, list);
        }

        public /* synthetic */ CallbackMessageHandler() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CallbackMessageHandler)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        private static class CallbackInfo
        implements ShadowedObject {
            public /* synthetic */ Object __robo_data__;
            String[] packageNames;
            String packageName;
            boolean replacing;
            UserHandle user;
            List<ShortcutInfo> shortcuts;

            private void $$robo$$android_content_pm_LauncherApps_CallbackMessageHandler_CallbackInfo$__constructor__() {
            }

            private /* synthetic */ void $$robo$$android_content_pm_LauncherApps_CallbackMessageHandler_CallbackInfo$__constructor__(1 x0) {
            }

            private void __constructor__() {
                this.$$robo$$android_content_pm_LauncherApps_CallbackMessageHandler_CallbackInfo$__constructor__();
            }

            public CallbackInfo() {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_LauncherApps_CallbackMessageHandler_CallbackInfo$__constructor__(), this);
            }

            private /* synthetic */ void __constructor__(1 var1_1) {
                this.$$robo$$android_content_pm_LauncherApps_CallbackMessageHandler_CallbackInfo$__constructor__(var1_1);
            }

            public /* synthetic */ CallbackInfo(1 var1_1) {
                this();
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_LauncherApps_CallbackMessageHandler_CallbackInfo$__constructor__(android.content.pm.LauncherApps$1 ), this, var1_1);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CallbackInfo)this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }
    }

    public static class ShortcutQuery
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public static int FLAG_MATCH_DYNAMIC = 1;
        @Deprecated
        public static int FLAG_GET_DYNAMIC = 1;
        public static int FLAG_MATCH_PINNED = 2;
        @Deprecated
        public static int FLAG_GET_PINNED = 2;
        public static int FLAG_MATCH_MANIFEST = 8;
        @Deprecated
        public static int FLAG_GET_MANIFEST = 8;
        public static int FLAG_MATCH_ALL_KINDS = 11;
        @Deprecated
        public static int FLAG_GET_ALL_KINDS = 11;
        public static int FLAG_GET_KEY_FIELDS_ONLY = 4;
        long mChangedSince;
        String mPackage;
        List<String> mShortcutIds;
        ComponentName mActivity;
        int mQueryFlags;

        private void $$robo$$android_content_pm_LauncherApps_ShortcutQuery$__constructor__() {
        }

        private final ShortcutQuery $$robo$$android_content_pm_LauncherApps_ShortcutQuery$setChangedSince(long changedSince) {
            this.mChangedSince = changedSince;
            return this;
        }

        private final ShortcutQuery $$robo$$android_content_pm_LauncherApps_ShortcutQuery$setPackage(String packageName) {
            this.mPackage = packageName;
            return this;
        }

        private final ShortcutQuery $$robo$$android_content_pm_LauncherApps_ShortcutQuery$setShortcutIds(List<String> shortcutIds) {
            this.mShortcutIds = shortcutIds;
            return this;
        }

        private final ShortcutQuery $$robo$$android_content_pm_LauncherApps_ShortcutQuery$setActivity(ComponentName activity) {
            this.mActivity = activity;
            return this;
        }

        private final ShortcutQuery $$robo$$android_content_pm_LauncherApps_ShortcutQuery$setQueryFlags(int queryFlags) {
            this.mQueryFlags = queryFlags;
            return this;
        }

        private void __constructor__() {
            this.$$robo$$android_content_pm_LauncherApps_ShortcutQuery$__constructor__();
        }

        public ShortcutQuery() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_LauncherApps_ShortcutQuery$__constructor__(), this);
        }

        public ShortcutQuery setChangedSince(long l) {
            return InvokeDynamicSupport.bootstrap("setChangedSince", $$robo$$android_content_pm_LauncherApps_ShortcutQuery$setChangedSince(long ), this, l);
        }

        public ShortcutQuery setPackage(String string2) {
            return InvokeDynamicSupport.bootstrap("setPackage", $$robo$$android_content_pm_LauncherApps_ShortcutQuery$setPackage(java.lang.String ), this, string2);
        }

        public ShortcutQuery setShortcutIds(List<String> list) {
            return InvokeDynamicSupport.bootstrap("setShortcutIds", $$robo$$android_content_pm_LauncherApps_ShortcutQuery$setShortcutIds(java.util.List<java.lang.String> ), this, list);
        }

        public ShortcutQuery setActivity(ComponentName componentName) {
            return InvokeDynamicSupport.bootstrap("setActivity", $$robo$$android_content_pm_LauncherApps_ShortcutQuery$setActivity(android.content.ComponentName ), this, componentName);
        }

        public ShortcutQuery setQueryFlags(int n) {
            return InvokeDynamicSupport.bootstrap("setQueryFlags", $$robo$$android_content_pm_LauncherApps_ShortcutQuery$setQueryFlags(int ), this, n);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ShortcutQuery)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        @Retention(value=RetentionPolicy.SOURCE)
        @IntDef(flag=true, value={1L, 2L, 8L, 4L})
        public static @interface QueryFlags {
        }
    }

    public static abstract class Callback
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;

        private void $$robo$$android_content_pm_LauncherApps_Callback$__constructor__() {
        }

        public abstract void onPackageRemoved(String var1, UserHandle var2);

        public abstract void onPackageAdded(String var1, UserHandle var2);

        public abstract void onPackageChanged(String var1, UserHandle var2);

        public abstract void onPackagesAvailable(String[] var1, UserHandle var2, boolean var3);

        public abstract void onPackagesUnavailable(String[] var1, UserHandle var2, boolean var3);

        private final void $$robo$$android_content_pm_LauncherApps_Callback$onPackagesSuspended(String[] packageNames, UserHandle user) {
        }

        private final void $$robo$$android_content_pm_LauncherApps_Callback$onPackagesUnsuspended(String[] packageNames, UserHandle user) {
        }

        private final void $$robo$$android_content_pm_LauncherApps_Callback$onShortcutsChanged(String packageName, List<ShortcutInfo> shortcuts, UserHandle user) {
        }

        private void __constructor__() {
            this.$$robo$$android_content_pm_LauncherApps_Callback$__constructor__();
        }

        public Callback() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_LauncherApps_Callback$__constructor__(), this);
        }

        public void onPackagesSuspended(String[] stringArray, UserHandle userHandle) {
            InvokeDynamicSupport.bootstrap("onPackagesSuspended", $$robo$$android_content_pm_LauncherApps_Callback$onPackagesSuspended(java.lang.String[] android.os.UserHandle ), this, stringArray, userHandle);
        }

        public void onPackagesUnsuspended(String[] stringArray, UserHandle userHandle) {
            InvokeDynamicSupport.bootstrap("onPackagesUnsuspended", $$robo$$android_content_pm_LauncherApps_Callback$onPackagesUnsuspended(java.lang.String[] android.os.UserHandle ), this, stringArray, userHandle);
        }

        public void onShortcutsChanged(String string2, List<ShortcutInfo> list, UserHandle userHandle) {
            InvokeDynamicSupport.bootstrap("onShortcutsChanged", $$robo$$android_content_pm_LauncherApps_Callback$onShortcutsChanged(java.lang.String java.util.List<android.content.pm.ShortcutInfo> android.os.UserHandle ), this, string2, list, userHandle);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Callback)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

