/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm;

import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ApplicationInfo;
import android.content.pm.ComponentInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.RegisteredServicesCacheListener;
import android.content.pm.ResolveInfo;
import android.content.pm.UserInfo;
import android.content.pm.XmlSerializerAndParser;
import android.content.res.Resources;
import android.content.res.XmlResourceParser;
import android.os.Environment;
import android.os.Handler;
import android.os.UserHandle;
import android.os.UserManager;
import android.util.AtomicFile;
import android.util.AttributeSet;
import android.util.IntArray;
import android.util.Log;
import android.util.SparseArray;
import android.util.Xml;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.FastXmlSerializer;
import com.google.android.collect.Lists;
import com.google.android.collect.Maps;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import libcore.io.IoUtils;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public abstract class RegisteredServicesCache<V> {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "PackageManager";
    private static boolean DEBUG = false;
    protected static String REGISTERED_SERVICES_DIR = "registered_services";
    public Context mContext;
    private String mInterfaceName;
    private String mMetaDataName;
    private String mAttributesName;
    private XmlSerializerAndParser<V> mSerializerAndParser;
    protected Object mServicesLock;
    @GuardedBy(value="mServicesLock")
    private SparseArray<UserServices<V>> mUserServices;
    private RegisteredServicesCacheListener<V> mListener;
    private Handler mHandler;
    private BroadcastReceiver mPackageReceiver;
    private BroadcastReceiver mExternalReceiver;
    private BroadcastReceiver mUserRemovedReceiver;

    @GuardedBy(value="mServicesLock")
    private final UserServices<V> $$robo$$android_content_pm_RegisteredServicesCache$findOrCreateUserLocked(int userId) {
        return this.findOrCreateUserLocked(userId, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GuardedBy(value="mServicesLock")
    private final UserServices<V> $$robo$$android_content_pm_RegisteredServicesCache$findOrCreateUserLocked(int userId, boolean loadFromFileIfNew) {
        UserServices<V> services = this.mUserServices.get(userId);
        if (services == null) {
            AtomicFile file;
            UserInfo user;
            services = new UserServices(null);
            this.mUserServices.put(userId, services);
            if (loadFromFileIfNew && this.mSerializerAndParser != null && (user = this.getUser(userId)) != null && (file = this.createFileForUser(user.id)).getBaseFile().exists()) {
                FileInputStream is = null;
                try {
                    is = file.openRead();
                    this.readPersistentServicesLocked(is);
                }
                catch (Exception e) {
                    Log.w("PackageManager", "Error reading persistent services for user " + user.id, e);
                }
                finally {
                    IoUtils.closeQuietly(is);
                }
            }
        }
        return services;
    }

    private void $$robo$$android_content_pm_RegisteredServicesCache$__constructor__(Context context, String interfaceName, String metaDataName, String attributeName, XmlSerializerAndParser<V> serializerAndParser) {
        this.mServicesLock = new Object();
        this.mUserServices = new SparseArray(2);
        this.mPackageReceiver = new ShadowedObject(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ RegisteredServicesCache this$0;

            private void $$robo$$android_content_pm_RegisteredServicesCache_1$__constructor__(RegisteredServicesCache this$0) {
            }

            private final void $$robo$$android_content_pm_RegisteredServicesCache_1$onReceive(Context context, Intent intent) {
                int uid = intent.getIntExtra("android.intent.extra.UID", -1);
                if (uid != -1) {
                    this.this$0.handlePackageEvent(intent, UserHandle.getUserId(uid));
                }
            }

            private void __constructor__(RegisteredServicesCache registeredServicesCache) {
                this.$$robo$$android_content_pm_RegisteredServicesCache_1$__constructor__(registeredServicesCache);
            }
            {
                this.this$0 = registeredServicesCache;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_RegisteredServicesCache_1$__constructor__(android.content.pm.RegisteredServicesCache ), this, registeredServicesCache);
            }

            @Override
            public void onReceive(Context context, Intent intent) {
                InvokeDynamicSupport.bootstrap("onReceive", $$robo$$android_content_pm_RegisteredServicesCache_1$onReceive(android.content.Context android.content.Intent ), this, context, intent);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mExternalReceiver = new ShadowedObject(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ RegisteredServicesCache this$0;

            private void $$robo$$android_content_pm_RegisteredServicesCache_2$__constructor__(RegisteredServicesCache this$0) {
            }

            private final void $$robo$$android_content_pm_RegisteredServicesCache_2$onReceive(Context context, Intent intent) {
                this.this$0.handlePackageEvent(intent, 0);
            }

            private void __constructor__(RegisteredServicesCache registeredServicesCache) {
                this.$$robo$$android_content_pm_RegisteredServicesCache_2$__constructor__(registeredServicesCache);
            }
            {
                this.this$0 = registeredServicesCache;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_RegisteredServicesCache_2$__constructor__(android.content.pm.RegisteredServicesCache ), this, registeredServicesCache);
            }

            @Override
            public void onReceive(Context context, Intent intent) {
                InvokeDynamicSupport.bootstrap("onReceive", $$robo$$android_content_pm_RegisteredServicesCache_2$onReceive(android.content.Context android.content.Intent ), this, context, intent);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mUserRemovedReceiver = new ShadowedObject(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ RegisteredServicesCache this$0;

            private void $$robo$$android_content_pm_RegisteredServicesCache_3$__constructor__(RegisteredServicesCache this$0) {
            }

            private final void $$robo$$android_content_pm_RegisteredServicesCache_3$onReceive(Context context, Intent intent) {
                int userId = intent.getIntExtra("android.intent.extra.user_handle", -1);
                this.this$0.onUserRemoved(userId);
            }

            private void __constructor__(RegisteredServicesCache registeredServicesCache) {
                this.$$robo$$android_content_pm_RegisteredServicesCache_3$__constructor__(registeredServicesCache);
            }
            {
                this.this$0 = registeredServicesCache;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_RegisteredServicesCache_3$__constructor__(android.content.pm.RegisteredServicesCache ), this, registeredServicesCache);
            }

            @Override
            public void onReceive(Context context, Intent intent) {
                InvokeDynamicSupport.bootstrap("onReceive", $$robo$$android_content_pm_RegisteredServicesCache_3$onReceive(android.content.Context android.content.Intent ), this, context, intent);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mContext = context;
        this.mInterfaceName = interfaceName;
        this.mMetaDataName = metaDataName;
        this.mAttributesName = attributeName;
        this.mSerializerAndParser = serializerAndParser;
        this.migrateIfNecessaryLocked();
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.PACKAGE_ADDED");
        intentFilter.addAction("android.intent.action.PACKAGE_CHANGED");
        intentFilter.addAction("android.intent.action.PACKAGE_REMOVED");
        intentFilter.addDataScheme("package");
        this.mContext.registerReceiverAsUser(this.mPackageReceiver, UserHandle.ALL, intentFilter, null, null);
        IntentFilter sdFilter = new IntentFilter();
        sdFilter.addAction("android.intent.action.EXTERNAL_APPLICATIONS_AVAILABLE");
        sdFilter.addAction("android.intent.action.EXTERNAL_APPLICATIONS_UNAVAILABLE");
        this.mContext.registerReceiver(this.mExternalReceiver, sdFilter);
        IntentFilter userFilter = new IntentFilter();
        sdFilter.addAction("android.intent.action.USER_REMOVED");
        this.mContext.registerReceiver(this.mUserRemovedReceiver, userFilter);
    }

    private final void $$robo$$android_content_pm_RegisteredServicesCache$handlePackageEvent(Intent intent, int userId) {
        String action = intent.getAction();
        boolean isRemoval = "android.intent.action.PACKAGE_REMOVED".equals(action) || "android.intent.action.EXTERNAL_APPLICATIONS_UNAVAILABLE".equals(action);
        boolean replacing = intent.getBooleanExtra("android.intent.extra.REPLACING", false);
        if (!isRemoval || !replacing) {
            int[] uids = null;
            if ("android.intent.action.EXTERNAL_APPLICATIONS_AVAILABLE".equals(action) || "android.intent.action.EXTERNAL_APPLICATIONS_UNAVAILABLE".equals(action)) {
                uids = intent.getIntArrayExtra("android.intent.extra.changed_uid_list");
            } else {
                int uid = intent.getIntExtra("android.intent.extra.UID", -1);
                if (uid > 0) {
                    uids = new int[]{uid};
                }
            }
            this.generateServicesMap(uids, userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_content_pm_RegisteredServicesCache$invalidateCache(int userId) {
        Object object = this.mServicesLock;
        synchronized (object) {
            UserServices<V> user = this.findOrCreateUserLocked(userId);
            user.services = null;
            this.onServicesChangedLocked(userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_content_pm_RegisteredServicesCache$dump(FileDescriptor fd, PrintWriter fout, String[] args, int userId) {
        Object object = this.mServicesLock;
        synchronized (object) {
            UserServices<V> user = this.findOrCreateUserLocked(userId);
            if (user.services != null) {
                fout.println("RegisteredServicesCache: " + user.services.size() + " services");
                for (ServiceInfo info : user.services.values()) {
                    fout.println("  " + info);
                }
            } else {
                fout.println("RegisteredServicesCache: services not loaded");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final RegisteredServicesCacheListener<V> $$robo$$android_content_pm_RegisteredServicesCache$getListener() {
        RegisteredServicesCache registeredServicesCache = this;
        synchronized (registeredServicesCache) {
            return this.mListener;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_content_pm_RegisteredServicesCache$setListener(RegisteredServicesCacheListener<V> listener, Handler handler) {
        if (handler == null) {
            handler = new Handler(this.mContext.getMainLooper());
        }
        RegisteredServicesCache registeredServicesCache = this;
        synchronized (registeredServicesCache) {
            this.mHandler = handler;
            this.mListener = listener;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_content_pm_RegisteredServicesCache$notifyListener(V type, int userId, boolean removed) {
        Handler handler;
        RegisteredServicesCacheListener<V> listener;
        RegisteredServicesCache registeredServicesCache = this;
        synchronized (registeredServicesCache) {
            listener = this.mListener;
            handler = this.mHandler;
        }
        if (listener == null) {
            return;
        }
        RegisteredServicesCacheListener<V> listener2 = listener;
        handler.post(new Runnable(this, listener2, type, userId, removed){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ RegisteredServicesCacheListener val$listener2;
            /* synthetic */ Object val$type;
            /* synthetic */ int val$userId;
            /* synthetic */ boolean val$removed;
            /* synthetic */ RegisteredServicesCache this$0;

            private void $$robo$$android_content_pm_RegisteredServicesCache_4$__constructor__(RegisteredServicesCache this$0, RegisteredServicesCacheListener registeredServicesCacheListener, Object object, int n, boolean bl) {
                this.val$listener2 = registeredServicesCacheListener;
                this.val$type = object;
                this.val$userId = n;
                this.val$removed = bl;
            }

            private final void $$robo$$android_content_pm_RegisteredServicesCache_4$run() {
                this.val$listener2.onServiceChanged(this.val$type, this.val$userId, this.val$removed);
            }

            private void __constructor__(RegisteredServicesCache registeredServicesCache, RegisteredServicesCacheListener registeredServicesCacheListener, Object object, int n, boolean bl) {
                this.$$robo$$android_content_pm_RegisteredServicesCache_4$__constructor__(registeredServicesCache, registeredServicesCacheListener, object, n, bl);
            }
            {
                this.this$0 = registeredServicesCache;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_RegisteredServicesCache_4$__constructor__(android.content.pm.RegisteredServicesCache android.content.pm.RegisteredServicesCacheListener java.lang.Object int boolean ), this, registeredServicesCache, registeredServicesCacheListener, object, n, bl);
            }

            @Override
            public void run() {
                InvokeDynamicSupport.bootstrap("run", $$robo$$android_content_pm_RegisteredServicesCache_4$run(), this);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ServiceInfo<V> $$robo$$android_content_pm_RegisteredServicesCache$getServiceInfo(V type, int userId) {
        Object object = this.mServicesLock;
        synchronized (object) {
            UserServices<V> user = this.findOrCreateUserLocked(userId);
            if (user.services == null) {
                this.generateServicesMap(null, userId);
            }
            return user.services.get(type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Collection<ServiceInfo<V>> $$robo$$android_content_pm_RegisteredServicesCache$getAllServices(int userId) {
        Object object = this.mServicesLock;
        synchronized (object) {
            UserServices<V> user = this.findOrCreateUserLocked(userId);
            if (user.services == null) {
                this.generateServicesMap(null, userId);
            }
            return Collections.unmodifiableCollection(new ArrayList(user.services.values()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_content_pm_RegisteredServicesCache$updateServices(int userId) {
        ArrayList allServices;
        Object object = this.mServicesLock;
        synchronized (object) {
            UserServices<V> user = this.findOrCreateUserLocked(userId);
            if (user.services == null) {
                return;
            }
            allServices = new ArrayList(user.services.values());
        }
        IntArray updatedUids = null;
        for (ServiceInfo serviceInfo : allServices) {
            int versionCode = serviceInfo.componentInfo.applicationInfo.versionCode;
            String pkg = serviceInfo.componentInfo.packageName;
            ApplicationInfo newAppInfo = null;
            try {
                newAppInfo = this.mContext.getPackageManager().getApplicationInfoAsUser(pkg, 0, userId);
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                // empty catch block
            }
            if (newAppInfo != null && newAppInfo.versionCode == versionCode) continue;
            if (updatedUids == null) {
                updatedUids = new IntArray();
            }
            updatedUids.add(serviceInfo.uid);
        }
        if (updatedUids != null && updatedUids.size() > 0) {
            int[] updatedUidsArray = updatedUids.toArray();
            this.generateServicesMap(updatedUidsArray, userId);
        }
    }

    private final boolean $$robo$$android_content_pm_RegisteredServicesCache$inSystemImage(int callerUid) {
        String[] packages = this.mContext.getPackageManager().getPackagesForUid(callerUid);
        if (packages != null) {
            for (String name : packages) {
                try {
                    PackageInfo packageInfo = this.mContext.getPackageManager().getPackageInfo(name, 0);
                    if ((packageInfo.applicationInfo.flags & 1) == 0) continue;
                    return true;
                }
                catch (PackageManager.NameNotFoundException e) {
                    return false;
                }
            }
        }
        return false;
    }

    private final List<ResolveInfo> $$robo$$android_content_pm_RegisteredServicesCache$queryIntentServices(int userId) {
        PackageManager pm = this.mContext.getPackageManager();
        return pm.queryIntentServicesAsUser(new Intent(this.mInterfaceName), 786560, userId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_content_pm_RegisteredServicesCache$generateServicesMap(int[] changedUids, int userId) {
        ArrayList<ServiceInfo<V>> serviceInfos = new ArrayList<ServiceInfo<V>>();
        List<ResolveInfo> resolveInfos = this.queryIntentServices(userId);
        for (ResolveInfo resolveInfo : resolveInfos) {
            try {
                ServiceInfo<V> info = this.parseServiceInfo(resolveInfo);
                if (info == null) {
                    Log.w("PackageManager", "Unable to load service info " + resolveInfo.toString());
                    continue;
                }
                serviceInfos.add(info);
            }
            catch (IOException | XmlPullParserException e) {
                Log.w("PackageManager", "Unable to load service info " + resolveInfo.toString(), e);
            }
        }
        Object object = this.mServicesLock;
        synchronized (object) {
            boolean firstScan;
            UserServices<V> user = this.findOrCreateUserLocked(userId);
            boolean bl = firstScan = user.services == null;
            if (firstScan) {
                user.services = Maps.newHashMap();
            }
            StringBuilder changes = new StringBuilder();
            boolean changed = false;
            for (ServiceInfo serviceInfo : serviceInfos) {
                Integer previousUid = user.persistentServices.get(serviceInfo.type);
                if (previousUid == null) {
                    changed = true;
                    user.services.put((ServiceInfo)serviceInfo.type, serviceInfo);
                    user.persistentServices.put((Integer)serviceInfo.type, serviceInfo.uid);
                    if (user.mPersistentServicesFileDidNotExist && firstScan) continue;
                    this.notifyListener(serviceInfo.type, userId, false);
                    continue;
                }
                if (previousUid == serviceInfo.uid) {
                    user.services.put((ServiceInfo)serviceInfo.type, serviceInfo);
                    continue;
                }
                if (!this.inSystemImage(serviceInfo.uid) && this.containsTypeAndUid(serviceInfos, serviceInfo.type, previousUid)) continue;
                changed = true;
                user.services.put((ServiceInfo)serviceInfo.type, serviceInfo);
                user.persistentServices.put((Integer)serviceInfo.type, serviceInfo.uid);
                this.notifyListener(serviceInfo.type, userId, false);
            }
            ArrayList toBeRemoved = Lists.newArrayList();
            for (Object v1 : user.persistentServices.keySet()) {
                if (this.containsType(serviceInfos, v1) || !this.containsUid(changedUids, user.persistentServices.get(v1))) continue;
                toBeRemoved.add(v1);
            }
            for (Object v1 : toBeRemoved) {
                changed = true;
                user.persistentServices.remove(v1);
                user.services.remove(v1);
                this.notifyListener(v1, userId, true);
            }
            if (changed) {
                this.onServicesChangedLocked(userId);
                this.writePersistentServicesLocked(user, userId);
            }
        }
    }

    private final void $$robo$$android_content_pm_RegisteredServicesCache$onServicesChangedLocked(int userId) {
    }

    private final boolean $$robo$$android_content_pm_RegisteredServicesCache$containsUid(int[] changedUids, int uid) {
        return changedUids == null || ArrayUtils.contains(changedUids, uid);
    }

    private final boolean $$robo$$android_content_pm_RegisteredServicesCache$containsType(ArrayList<ServiceInfo<V>> serviceInfos, V type) {
        int N = serviceInfos.size();
        for (int i = 0; i < N; ++i) {
            if (!serviceInfos.get((int)i).type.equals(type)) continue;
            return true;
        }
        return false;
    }

    private final boolean $$robo$$android_content_pm_RegisteredServicesCache$containsTypeAndUid(ArrayList<ServiceInfo<V>> serviceInfos, V type, int uid) {
        int N = serviceInfos.size();
        for (int i = 0; i < N; ++i) {
            ServiceInfo<V> serviceInfo = serviceInfos.get(i);
            if (!serviceInfo.type.equals(type) || serviceInfo.uid != uid) continue;
            return true;
        }
        return false;
    }

    private final ServiceInfo<V> $$robo$$android_content_pm_RegisteredServicesCache$parseServiceInfo(ResolveInfo service) throws XmlPullParserException, IOException {
        android.content.pm.ServiceInfo si = service.serviceInfo;
        ComponentName componentName = new ComponentName(si.packageName, si.name);
        PackageManager pm = this.mContext.getPackageManager();
        try (XmlResourceParser parser = null;){
            int type;
            parser = si.loadXmlMetaData(pm, this.mMetaDataName);
            if (parser == null) {
                throw new XmlPullParserException("No " + this.mMetaDataName + " meta-data");
            }
            AttributeSet attrs = Xml.asAttributeSet(parser);
            while ((type = parser.next()) != 1 && type != 2) {
            }
            String nodeName = parser.getName();
            if (!this.mAttributesName.equals(nodeName)) {
                throw new XmlPullParserException("Meta-data does not start with " + this.mAttributesName + " tag");
            }
            V v = this.parseServiceAttributes(pm.getResourcesForApplication(si.applicationInfo), si.packageName, attrs);
            if (v == null) {
                ServiceInfo<V> serviceInfo = null;
                return serviceInfo;
            }
            android.content.pm.ServiceInfo serviceInfo = service.serviceInfo;
            ServiceInfo<V> serviceInfo2 = new ServiceInfo<V>(v, serviceInfo, componentName);
            return serviceInfo2;
        }
    }

    private final void $$robo$$android_content_pm_RegisteredServicesCache$readPersistentServicesLocked(InputStream is) throws XmlPullParserException, IOException {
        XmlPullParser parser = Xml.newPullParser();
        parser.setInput(is, StandardCharsets.UTF_8.name());
        int eventType = parser.getEventType();
        while (eventType != 2 && eventType != 1) {
            eventType = parser.next();
        }
        String tagName = parser.getName();
        if ("services".equals(tagName)) {
            eventType = parser.next();
            do {
                if (eventType != 2 || parser.getDepth() != 2 || !"service".equals(tagName = parser.getName())) continue;
                V service = this.mSerializerAndParser.createFromXml(parser);
                if (service == null) break;
                String uidString = parser.getAttributeValue(null, "uid");
                int uid = Integer.parseInt(uidString);
                int userId = UserHandle.getUserId(uid);
                UserServices<V> user = this.findOrCreateUserLocked(userId, false);
                user.persistentServices.put((Integer)service, uid);
            } while ((eventType = parser.next()) != 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_content_pm_RegisteredServicesCache$migrateIfNecessaryLocked() {
        File marker;
        if (this.mSerializerAndParser == null) {
            return;
        }
        File systemDir = new File(this.getDataDirectory(), "system");
        File syncDir = new File(systemDir, "registered_services");
        AtomicFile oldFile = new AtomicFile(new File(syncDir, this.mInterfaceName + ".xml"));
        boolean oldFileExists = oldFile.getBaseFile().exists();
        if (oldFileExists && !(marker = new File(syncDir, this.mInterfaceName + ".xml.migrated")).exists()) {
            FileInputStream is = null;
            try {
                is = oldFile.openRead();
                this.mUserServices.clear();
                this.readPersistentServicesLocked(is);
            }
            catch (Exception e) {
                Log.w("PackageManager", "Error reading persistent services, starting from scratch", e);
            }
            finally {
                IoUtils.closeQuietly(is);
            }
            try {
                for (UserInfo user : this.getUsers()) {
                    UserServices<V> userServices = this.mUserServices.get(user.id);
                    if (userServices == null) continue;
                    this.writePersistentServicesLocked(userServices, user.id);
                }
                marker.createNewFile();
            }
            catch (Exception e) {
                Log.w("PackageManager", "Migration failed", e);
            }
            this.mUserServices.clear();
        }
    }

    private final void $$robo$$android_content_pm_RegisteredServicesCache$writePersistentServicesLocked(UserServices<V> user, int userId) {
        block4: {
            if (this.mSerializerAndParser == null) {
                return;
            }
            AtomicFile atomicFile = this.createFileForUser(userId);
            FileOutputStream fos = null;
            try {
                fos = atomicFile.startWrite();
                FastXmlSerializer out = new FastXmlSerializer();
                out.setOutput(fos, StandardCharsets.UTF_8.name());
                out.startDocument(null, true);
                out.setFeature("http://xmlpull.org/v1/doc/features.html#indent-output", true);
                out.startTag(null, "services");
                for (Map.Entry service : user.persistentServices.entrySet()) {
                    out.startTag(null, "service");
                    out.attribute(null, "uid", Integer.toString(service.getValue()));
                    this.mSerializerAndParser.writeAsXml(service.getKey(), out);
                    out.endTag(null, "service");
                }
                out.endTag(null, "services");
                out.endDocument();
                atomicFile.finishWrite(fos);
            }
            catch (IOException e1) {
                Log.w("PackageManager", "Error writing accounts", e1);
                if (fos == null) break block4;
                atomicFile.failWrite(fos);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_content_pm_RegisteredServicesCache$onUserRemoved(int userId) {
        Object object = this.mServicesLock;
        synchronized (object) {
            this.mUserServices.remove(userId);
        }
    }

    private final List<UserInfo> $$robo$$android_content_pm_RegisteredServicesCache$getUsers() {
        return UserManager.get(this.mContext).getUsers(true);
    }

    private final UserInfo $$robo$$android_content_pm_RegisteredServicesCache$getUser(int userId) {
        return UserManager.get(this.mContext).getUserInfo(userId);
    }

    private final AtomicFile $$robo$$android_content_pm_RegisteredServicesCache$createFileForUser(int userId) {
        File userDir = this.getUserSystemDirectory(userId);
        File userFile = new File(userDir, "registered_services/" + this.mInterfaceName + ".xml");
        return new AtomicFile(userFile);
    }

    private final File $$robo$$android_content_pm_RegisteredServicesCache$getUserSystemDirectory(int userId) {
        return Environment.getUserSystemDirectory(userId);
    }

    private final File $$robo$$android_content_pm_RegisteredServicesCache$getDataDirectory() {
        return Environment.getDataDirectory();
    }

    private final Map<V, Integer> $$robo$$android_content_pm_RegisteredServicesCache$getPersistentServices(int userId) {
        return this.findOrCreateUserLocked((int)userId).persistentServices;
    }

    public abstract V parseServiceAttributes(Resources var1, String var2, AttributeSet var3);

    private UserServices<V> findOrCreateUserLocked(int n) {
        return InvokeDynamicSupport.bootstrap("findOrCreateUserLocked", $$robo$$android_content_pm_RegisteredServicesCache$findOrCreateUserLocked(int ), this, n);
    }

    private UserServices<V> findOrCreateUserLocked(int n, boolean bl) {
        return InvokeDynamicSupport.bootstrap("findOrCreateUserLocked", $$robo$$android_content_pm_RegisteredServicesCache$findOrCreateUserLocked(int boolean ), this, n, bl);
    }

    private void __constructor__(Context context, String string2, String string3, String string4, XmlSerializerAndParser<V> xmlSerializerAndParser) {
        this.$$robo$$android_content_pm_RegisteredServicesCache$__constructor__(context, string2, string3, string4, xmlSerializerAndParser);
    }

    public RegisteredServicesCache(Context context, String string2, String string3, String string4, XmlSerializerAndParser<V> xmlSerializerAndParser) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_RegisteredServicesCache$__constructor__(android.content.Context java.lang.String java.lang.String java.lang.String android.content.pm.XmlSerializerAndParser<V> ), this, context, string2, string3, string4, xmlSerializerAndParser);
    }

    private void handlePackageEvent(Intent intent, int n) {
        InvokeDynamicSupport.bootstrap("handlePackageEvent", $$robo$$android_content_pm_RegisteredServicesCache$handlePackageEvent(android.content.Intent int ), this, intent, n);
    }

    public void invalidateCache(int n) {
        InvokeDynamicSupport.bootstrap("invalidateCache", $$robo$$android_content_pm_RegisteredServicesCache$invalidateCache(int ), this, n);
    }

    public void dump(FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray, int n) {
        InvokeDynamicSupport.bootstrap("dump", $$robo$$android_content_pm_RegisteredServicesCache$dump(java.io.FileDescriptor java.io.PrintWriter java.lang.String[] int ), this, fileDescriptor, printWriter, stringArray, n);
    }

    public RegisteredServicesCacheListener<V> getListener() {
        return InvokeDynamicSupport.bootstrap("getListener", $$robo$$android_content_pm_RegisteredServicesCache$getListener(), this);
    }

    public void setListener(RegisteredServicesCacheListener<V> registeredServicesCacheListener, Handler handler) {
        InvokeDynamicSupport.bootstrap("setListener", $$robo$$android_content_pm_RegisteredServicesCache$setListener(android.content.pm.RegisteredServicesCacheListener<V> android.os.Handler ), this, registeredServicesCacheListener, handler);
    }

    private void notifyListener(V v, int n, boolean bl) {
        InvokeDynamicSupport.bootstrap("notifyListener", $$robo$$android_content_pm_RegisteredServicesCache$notifyListener(V int boolean ), this, v, n, bl);
    }

    public ServiceInfo<V> getServiceInfo(V v, int n) {
        return InvokeDynamicSupport.bootstrap("getServiceInfo", $$robo$$android_content_pm_RegisteredServicesCache$getServiceInfo(V int ), this, v, n);
    }

    public Collection<ServiceInfo<V>> getAllServices(int n) {
        return InvokeDynamicSupport.bootstrap("getAllServices", $$robo$$android_content_pm_RegisteredServicesCache$getAllServices(int ), this, n);
    }

    public void updateServices(int n) {
        InvokeDynamicSupport.bootstrap("updateServices", $$robo$$android_content_pm_RegisteredServicesCache$updateServices(int ), this, n);
    }

    protected boolean inSystemImage(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("inSystemImage", $$robo$$android_content_pm_RegisteredServicesCache$inSystemImage(int ), this, n);
    }

    protected List<ResolveInfo> queryIntentServices(int n) {
        return InvokeDynamicSupport.bootstrap("queryIntentServices", $$robo$$android_content_pm_RegisteredServicesCache$queryIntentServices(int ), this, n);
    }

    private void generateServicesMap(int[] nArray, int n) {
        InvokeDynamicSupport.bootstrap("generateServicesMap", $$robo$$android_content_pm_RegisteredServicesCache$generateServicesMap(int[] int ), this, nArray, n);
    }

    protected void onServicesChangedLocked(int n) {
        InvokeDynamicSupport.bootstrap("onServicesChangedLocked", $$robo$$android_content_pm_RegisteredServicesCache$onServicesChangedLocked(int ), this, n);
    }

    private boolean containsUid(int[] nArray, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("containsUid", $$robo$$android_content_pm_RegisteredServicesCache$containsUid(int[] int ), this, nArray, n);
    }

    private boolean containsType(ArrayList<ServiceInfo<V>> arrayList, V v) {
        return (boolean)InvokeDynamicSupport.bootstrap("containsType", $$robo$$android_content_pm_RegisteredServicesCache$containsType(java.util.ArrayList<android.content.pm.RegisteredServicesCache$ServiceInfo<V>> V ), this, arrayList, v);
    }

    private boolean containsTypeAndUid(ArrayList<ServiceInfo<V>> arrayList, V v, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("containsTypeAndUid", $$robo$$android_content_pm_RegisteredServicesCache$containsTypeAndUid(java.util.ArrayList<android.content.pm.RegisteredServicesCache$ServiceInfo<V>> V int ), this, arrayList, v, n);
    }

    protected ServiceInfo<V> parseServiceInfo(ResolveInfo resolveInfo) throws XmlPullParserException, IOException {
        return InvokeDynamicSupport.bootstrap("parseServiceInfo", $$robo$$android_content_pm_RegisteredServicesCache$parseServiceInfo(android.content.pm.ResolveInfo ), this, resolveInfo);
    }

    private void readPersistentServicesLocked(InputStream inputStream) throws XmlPullParserException, IOException {
        InvokeDynamicSupport.bootstrap("readPersistentServicesLocked", $$robo$$android_content_pm_RegisteredServicesCache$readPersistentServicesLocked(java.io.InputStream ), this, inputStream);
    }

    private void migrateIfNecessaryLocked() {
        InvokeDynamicSupport.bootstrap("migrateIfNecessaryLocked", $$robo$$android_content_pm_RegisteredServicesCache$migrateIfNecessaryLocked(), this);
    }

    private void writePersistentServicesLocked(UserServices<V> userServices, int n) {
        InvokeDynamicSupport.bootstrap("writePersistentServicesLocked", $$robo$$android_content_pm_RegisteredServicesCache$writePersistentServicesLocked(android.content.pm.RegisteredServicesCache$UserServices<V> int ), this, userServices, n);
    }

    protected void onUserRemoved(int n) {
        InvokeDynamicSupport.bootstrap("onUserRemoved", $$robo$$android_content_pm_RegisteredServicesCache$onUserRemoved(int ), this, n);
    }

    protected List<UserInfo> getUsers() {
        return InvokeDynamicSupport.bootstrap("getUsers", $$robo$$android_content_pm_RegisteredServicesCache$getUsers(), this);
    }

    protected UserInfo getUser(int n) {
        return InvokeDynamicSupport.bootstrap("getUser", $$robo$$android_content_pm_RegisteredServicesCache$getUser(int ), this, n);
    }

    private AtomicFile createFileForUser(int n) {
        return InvokeDynamicSupport.bootstrap("createFileForUser", $$robo$$android_content_pm_RegisteredServicesCache$createFileForUser(int ), this, n);
    }

    protected File getUserSystemDirectory(int n) {
        return InvokeDynamicSupport.bootstrap("getUserSystemDirectory", $$robo$$android_content_pm_RegisteredServicesCache$getUserSystemDirectory(int ), this, n);
    }

    protected File getDataDirectory() {
        return InvokeDynamicSupport.bootstrap("getDataDirectory", $$robo$$android_content_pm_RegisteredServicesCache$getDataDirectory(), this);
    }

    protected Map<V, Integer> getPersistentServices(int n) {
        return InvokeDynamicSupport.bootstrap("getPersistentServices", $$robo$$android_content_pm_RegisteredServicesCache$getPersistentServices(int ), this, n);
    }

    public /* synthetic */ RegisteredServicesCache() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RegisteredServicesCache)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class ServiceInfo<V> {
        public /* synthetic */ Object __robo_data__;
        public V type;
        public ComponentInfo componentInfo;
        public ComponentName componentName;
        public int uid;

        private void $$robo$$android_content_pm_RegisteredServicesCache_ServiceInfo$__constructor__(V type, ComponentInfo componentInfo, ComponentName componentName) {
            this.type = type;
            this.componentInfo = componentInfo;
            this.componentName = componentName;
            this.uid = componentInfo != null ? componentInfo.applicationInfo.uid : -1;
        }

        private final String $$robo$$android_content_pm_RegisteredServicesCache_ServiceInfo$toString() {
            return "ServiceInfo: " + this.type + ", " + this.componentName + ", uid " + this.uid;
        }

        private void __constructor__(V v, ComponentInfo componentInfo, ComponentName componentName) {
            this.$$robo$$android_content_pm_RegisteredServicesCache_ServiceInfo$__constructor__(v, componentInfo, componentName);
        }

        public ServiceInfo(V v, ComponentInfo componentInfo, ComponentName componentName) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_RegisteredServicesCache_ServiceInfo$__constructor__(V android.content.pm.ComponentInfo android.content.ComponentName ), this, v, componentInfo, componentName);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_content_pm_RegisteredServicesCache_ServiceInfo$toString(), this);
        }

        public /* synthetic */ ServiceInfo() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ServiceInfo)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class UserServices<V> {
        public /* synthetic */ Object __robo_data__;
        @GuardedBy(value="mServicesLock")
        Map<V, Integer> persistentServices;
        @GuardedBy(value="mServicesLock")
        Map<V, ServiceInfo<V>> services;
        @GuardedBy(value="mServicesLock")
        boolean mPersistentServicesFileDidNotExist;

        private void $$robo$$android_content_pm_RegisteredServicesCache_UserServices$__constructor__() {
            this.persistentServices = Maps.newHashMap();
            this.services = null;
            this.mPersistentServicesFileDidNotExist = true;
        }

        private /* synthetic */ void $$robo$$android_content_pm_RegisteredServicesCache_UserServices$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$android_content_pm_RegisteredServicesCache_UserServices$__constructor__();
        }

        public UserServices() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_RegisteredServicesCache_UserServices$__constructor__(), this);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_content_pm_RegisteredServicesCache_UserServices$__constructor__(var1_1);
        }

        public /* synthetic */ UserServices(1 var1_1) {
            this();
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_RegisteredServicesCache_UserServices$__constructor__(android.content.pm.RegisteredServicesCache$1 ), this, var1_1);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (UserServices)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

