/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm.split;

import android.content.pm.PackageParser;
import android.content.pm.split.SplitAssetLoader;
import android.content.pm.split.SplitDependencyLoader;
import android.content.res.AssetManager;
import android.os.Build;
import android.util.SparseArray;
import java.util.ArrayList;
import java.util.Collections;
import libcore.io.IoUtils;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;

public class SplitAssetDependencyLoader
extends SplitDependencyLoader<PackageParser.PackageParserException>
implements SplitAssetLoader {
    public /* synthetic */ Object __robo_data__;
    private String[] mSplitPaths;
    private int mFlags;
    private String[][] mCachedPaths;
    private AssetManager[] mCachedAssetManagers;

    private void $$robo$$android_content_pm_split_SplitAssetDependencyLoader$__constructor__(PackageParser.PackageLite pkg, SparseArray<int[]> dependencies, int flags) {
        this.mSplitPaths = new String[pkg.splitCodePaths.length + 1];
        this.mSplitPaths[0] = pkg.baseCodePath;
        InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)pkg.splitCodePaths, (int)0, (Object)this.mSplitPaths, (int)1, (int)pkg.splitCodePaths.length);
        this.mFlags = flags;
        this.mCachedPaths = new String[this.mSplitPaths.length][];
        this.mCachedAssetManagers = new AssetManager[this.mSplitPaths.length];
    }

    private final boolean $$robo$$android_content_pm_split_SplitAssetDependencyLoader$isSplitCached(int splitIdx) {
        return this.mCachedAssetManagers[splitIdx] != null;
    }

    private static final AssetManager $$robo$$android_content_pm_split_SplitAssetDependencyLoader$createAssetManagerWithPaths(String[] assetPaths, int flags) throws PackageParser.PackageParserException {
        AssetManager assets = new AssetManager();
        try {
            assets.setConfiguration(0, 0, null, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, Build.VERSION.RESOURCES_SDK_INT);
            for (String assetPath : assetPaths) {
                if ((flags & 4) != 0 && !PackageParser.isApkPath(assetPath)) {
                    throw new PackageParser.PackageParserException(-100, "Invalid package file: " + assetPath);
                }
                if (assets.addAssetPath(assetPath) != 0) continue;
                throw new PackageParser.PackageParserException(-101, "Failed adding asset path: " + assetPath);
            }
            return assets;
        }
        catch (Throwable e) {
            IoUtils.closeQuietly(assets);
            throw e;
        }
    }

    private final void $$robo$$android_content_pm_split_SplitAssetDependencyLoader$constructSplit(int splitIdx, int[] configSplitIndices, int parentSplitIdx) throws PackageParser.PackageParserException {
        ArrayList<String> assetPaths = new ArrayList<String>();
        if (parentSplitIdx >= 0) {
            Collections.addAll(assetPaths, this.mCachedPaths[parentSplitIdx]);
        }
        assetPaths.add(this.mSplitPaths[splitIdx]);
        for (int configSplitIdx : configSplitIndices) {
            assetPaths.add(this.mSplitPaths[configSplitIdx]);
        }
        this.mCachedPaths[splitIdx] = assetPaths.toArray(new String[assetPaths.size()]);
        this.mCachedAssetManagers[splitIdx] = SplitAssetDependencyLoader.createAssetManagerWithPaths(this.mCachedPaths[splitIdx], this.mFlags);
    }

    private final AssetManager $$robo$$android_content_pm_split_SplitAssetDependencyLoader$getBaseAssetManager() throws PackageParser.PackageParserException {
        this.loadDependenciesForSplit(0);
        return this.mCachedAssetManagers[0];
    }

    private final AssetManager $$robo$$android_content_pm_split_SplitAssetDependencyLoader$getSplitAssetManager(int idx) throws PackageParser.PackageParserException {
        this.loadDependenciesForSplit(idx + 1);
        return this.mCachedAssetManagers[idx + 1];
    }

    private final void $$robo$$android_content_pm_split_SplitAssetDependencyLoader$close() throws Exception {
        for (AssetManager assets : this.mCachedAssetManagers) {
            IoUtils.closeQuietly(assets);
        }
    }

    private void __constructor__(PackageParser.PackageLite packageLite, SparseArray<int[]> sparseArray, int n) {
        this.$$robo$$android_content_pm_split_SplitAssetDependencyLoader$__constructor__(packageLite, sparseArray, n);
    }

    public SplitAssetDependencyLoader(PackageParser.PackageLite packageLite, SparseArray<int[]> sparseArray, int n) {
        super(sparseArray);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_split_SplitAssetDependencyLoader$__constructor__(android.content.pm.PackageParser$PackageLite android.util.SparseArray<int[]> int ), this, packageLite, sparseArray, n);
    }

    @Override
    protected boolean isSplitCached(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isSplitCached", $$robo$$android_content_pm_split_SplitAssetDependencyLoader$isSplitCached(int ), this, n);
    }

    private static AssetManager createAssetManagerWithPaths(String[] stringArray, int n) throws PackageParser.PackageParserException {
        return InvokeDynamicSupport.bootstrapStatic("createAssetManagerWithPaths", $$robo$$android_content_pm_split_SplitAssetDependencyLoader$createAssetManagerWithPaths(java.lang.String[] int ), (String[])stringArray, (int)n);
    }

    @Override
    protected void constructSplit(int n, int[] nArray, int n2) throws PackageParser.PackageParserException {
        InvokeDynamicSupport.bootstrap("constructSplit", $$robo$$android_content_pm_split_SplitAssetDependencyLoader$constructSplit(int int[] int ), this, n, nArray, n2);
    }

    @Override
    public AssetManager getBaseAssetManager() throws PackageParser.PackageParserException {
        return InvokeDynamicSupport.bootstrap("getBaseAssetManager", $$robo$$android_content_pm_split_SplitAssetDependencyLoader$getBaseAssetManager(), this);
    }

    @Override
    public AssetManager getSplitAssetManager(int n) throws PackageParser.PackageParserException {
        return InvokeDynamicSupport.bootstrap("getSplitAssetManager", $$robo$$android_content_pm_split_SplitAssetDependencyLoader$getSplitAssetManager(int ), this, n);
    }

    @Override
    public void close() throws Exception {
        InvokeDynamicSupport.bootstrap("close", $$robo$$android_content_pm_split_SplitAssetDependencyLoader$close(), this);
    }

    public /* synthetic */ SplitAssetDependencyLoader() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SplitAssetDependencyLoader)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

