/*
 * Decompiled with CFR 0.152.
 */
package android.content.res;

import android.animation.Animator;
import android.animation.StateListAnimator;
import android.content.pm.ActivityInfo;
import android.content.res.AssetFileDescriptor;
import android.content.res.AssetManager;
import android.content.res.ColorStateList;
import android.content.res.CompatibilityInfo;
import android.content.res.ComplexColor;
import android.content.res.Configuration;
import android.content.res.ConfigurationBoundResourceCache;
import android.content.res.ConstantState;
import android.content.res.DrawableCache;
import android.content.res.FontResourcesParser;
import android.content.res.GradientColor;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlBlock;
import android.content.res.XmlResourceParser;
import android.graphics.Typeface;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.DrawableContainer;
import android.icu.text.PluralRules;
import android.os.Build;
import android.os.LocaleList;
import android.os.Trace;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.LongSparseArray;
import android.util.TypedValue;
import android.util.Xml;
import android.view.DisplayAdjustments;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Locale;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;
import org.xmlpull.v1.XmlPullParserException;

public class ResourcesImpl
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    static String TAG = "Resources";
    private static boolean DEBUG_LOAD = false;
    private static boolean DEBUG_CONFIG = false;
    private static boolean TRACE_FOR_PRELOAD = false;
    private static boolean TRACE_FOR_MISS_PRELOAD = false;
    private static int ID_OTHER = 0x1000004;
    private static Object sSync;
    private static boolean sPreloaded;
    private boolean mPreloading;
    private static LongSparseArray<Drawable.ConstantState>[] sPreloadedDrawables;
    private static LongSparseArray<Drawable.ConstantState> sPreloadedColorDrawables;
    private static LongSparseArray<ConstantState<ComplexColor>> sPreloadedComplexColors;
    private Object mAccessLock;
    private Configuration mTmpConfig;
    private DrawableCache mDrawableCache;
    private DrawableCache mColorDrawableCache;
    private ConfigurationBoundResourceCache<ComplexColor> mComplexColorCache;
    private ConfigurationBoundResourceCache<Animator> mAnimatorCache;
    private ConfigurationBoundResourceCache<StateListAnimator> mStateListAnimatorCache;
    private static int XML_BLOCK_CACHE_SIZE = 4;
    private int mLastCachedXmlBlockIndex;
    private int[] mCachedXmlBlockCookies;
    private String[] mCachedXmlBlockFiles;
    private XmlBlock[] mCachedXmlBlocks;
    AssetManager mAssets;
    private DisplayMetrics mMetrics;
    private DisplayAdjustments mDisplayAdjustments;
    private PluralRules mPluralRule;
    private Configuration mConfiguration;

    private void $$robo$$android_content_res_ResourcesImpl$__constructor__(AssetManager assets, DisplayMetrics metrics, Configuration config, DisplayAdjustments displayAdjustments) {
        this.mAccessLock = new Object();
        this.mTmpConfig = new Configuration();
        this.mDrawableCache = new DrawableCache();
        this.mColorDrawableCache = new DrawableCache();
        this.mComplexColorCache = new ConfigurationBoundResourceCache();
        this.mAnimatorCache = new ConfigurationBoundResourceCache();
        this.mStateListAnimatorCache = new ConfigurationBoundResourceCache();
        this.mLastCachedXmlBlockIndex = -1;
        this.mCachedXmlBlockCookies = new int[4];
        this.mCachedXmlBlockFiles = new String[4];
        this.mCachedXmlBlocks = new XmlBlock[4];
        this.mMetrics = new DisplayMetrics();
        this.mConfiguration = new Configuration();
        this.mAssets = assets;
        this.mMetrics.setToDefaults();
        this.mDisplayAdjustments = displayAdjustments;
        this.mConfiguration.setToDefaults();
        this.updateConfiguration(config, metrics, displayAdjustments.getCompatibilityInfo());
        this.mAssets.ensureStringBlocks();
    }

    private final DisplayAdjustments $$robo$$android_content_res_ResourcesImpl$getDisplayAdjustments() {
        return this.mDisplayAdjustments;
    }

    private final AssetManager $$robo$$android_content_res_ResourcesImpl$getAssets() {
        return this.mAssets;
    }

    private final DisplayMetrics $$robo$$android_content_res_ResourcesImpl$getDisplayMetrics() {
        return this.mMetrics;
    }

    private final Configuration $$robo$$android_content_res_ResourcesImpl$getConfiguration() {
        return this.mConfiguration;
    }

    private final Configuration[] $$robo$$android_content_res_ResourcesImpl$getSizeConfigurations() {
        return this.mAssets.getSizeConfigurations();
    }

    private final CompatibilityInfo $$robo$$android_content_res_ResourcesImpl$getCompatibilityInfo() {
        return this.mDisplayAdjustments.getCompatibilityInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final PluralRules $$robo$$android_content_res_ResourcesImpl$getPluralRule() {
        Object object = sSync;
        synchronized (object) {
            if (this.mPluralRule == null) {
                this.mPluralRule = PluralRules.forLocale(this.mConfiguration.getLocales().get(0));
            }
            return this.mPluralRule;
        }
    }

    private final void $$robo$$android_content_res_ResourcesImpl$getValue(int id2, TypedValue outValue, boolean resolveRefs) throws Resources.NotFoundException {
        boolean found = this.mAssets.getResourceValue(id2, 0, outValue, resolveRefs);
        if (found) {
            return;
        }
        throw new Resources.NotFoundException("Resource ID #0x" + Integer.toHexString(id2));
    }

    private final void $$robo$$android_content_res_ResourcesImpl$getValueForDensity(int id2, int density, TypedValue outValue, boolean resolveRefs) throws Resources.NotFoundException {
        boolean found = this.mAssets.getResourceValue(id2, density, outValue, resolveRefs);
        if (found) {
            return;
        }
        throw new Resources.NotFoundException("Resource ID #0x" + Integer.toHexString(id2));
    }

    private final void $$robo$$android_content_res_ResourcesImpl$getValue(String name, TypedValue outValue, boolean resolveRefs) throws Resources.NotFoundException {
        int id2 = this.getIdentifier(name, "string", null);
        if (id2 != 0) {
            this.getValue(id2, outValue, resolveRefs);
            return;
        }
        throw new Resources.NotFoundException("String resource name " + name);
    }

    private final int $$robo$$android_content_res_ResourcesImpl$getIdentifier(String name, String defType, String defPackage) {
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        try {
            return Integer.parseInt(name);
        }
        catch (Exception exception) {
            return this.mAssets.getResourceIdentifier(name, defType, defPackage);
        }
    }

    private final String $$robo$$android_content_res_ResourcesImpl$getResourceName(int resid) throws Resources.NotFoundException {
        String str = this.mAssets.getResourceName(resid);
        if (str != null) {
            return str;
        }
        throw new Resources.NotFoundException("Unable to find resource ID #0x" + Integer.toHexString(resid));
    }

    private final String $$robo$$android_content_res_ResourcesImpl$getResourcePackageName(int resid) throws Resources.NotFoundException {
        String str = this.mAssets.getResourcePackageName(resid);
        if (str != null) {
            return str;
        }
        throw new Resources.NotFoundException("Unable to find resource ID #0x" + Integer.toHexString(resid));
    }

    private final String $$robo$$android_content_res_ResourcesImpl$getResourceTypeName(int resid) throws Resources.NotFoundException {
        String str = this.mAssets.getResourceTypeName(resid);
        if (str != null) {
            return str;
        }
        throw new Resources.NotFoundException("Unable to find resource ID #0x" + Integer.toHexString(resid));
    }

    private final String $$robo$$android_content_res_ResourcesImpl$getResourceEntryName(int resid) throws Resources.NotFoundException {
        String str = this.mAssets.getResourceEntryName(resid);
        if (str != null) {
            return str;
        }
        throw new Resources.NotFoundException("Unable to find resource ID #0x" + Integer.toHexString(resid));
    }

    private final CharSequence $$robo$$android_content_res_ResourcesImpl$getQuantityText(int id2, int quantity) throws Resources.NotFoundException {
        PluralRules rule = this.getPluralRule();
        CharSequence res = this.mAssets.getResourceBagText(id2, ResourcesImpl.attrForQuantityCode(rule.select(quantity)));
        if (res != null) {
            return res;
        }
        res = this.mAssets.getResourceBagText(id2, 0x1000004);
        if (res != null) {
            return res;
        }
        throw new Resources.NotFoundException("Plural resource ID #0x" + Integer.toHexString(id2) + " quantity=" + quantity + " item=" + rule.select(quantity));
    }

    private static final int $$robo$$android_content_res_ResourcesImpl$attrForQuantityCode(String quantityCode) {
        switch (quantityCode) {
            case "zero": {
                return 0x1000005;
            }
            case "one": {
                return 0x1000006;
            }
            case "two": {
                return 0x1000007;
            }
            case "few": {
                return 0x1000008;
            }
            case "many": {
                return 0x1000009;
            }
        }
        return 0x1000004;
    }

    private final AssetFileDescriptor $$robo$$android_content_res_ResourcesImpl$openRawResourceFd(int id2, TypedValue tempValue) throws Resources.NotFoundException {
        this.getValue(id2, tempValue, true);
        try {
            return this.mAssets.openNonAssetFd(tempValue.assetCookie, tempValue.string.toString());
        }
        catch (Exception e) {
            throw new Resources.NotFoundException("File " + tempValue.string.toString() + " from drawable resource ID #0x" + Integer.toHexString(id2), e);
        }
    }

    private final InputStream $$robo$$android_content_res_ResourcesImpl$openRawResource(int id2, TypedValue value) throws Resources.NotFoundException {
        this.getValue(id2, value, true);
        try {
            return this.mAssets.openNonAsset(value.assetCookie, value.string.toString(), 2);
        }
        catch (Exception e) {
            Resources.NotFoundException rnf = new Resources.NotFoundException("File " + (value.string == null ? "(null)" : value.string.toString()) + " from drawable resource ID #0x" + Integer.toHexString(id2));
            rnf.initCause(e);
            throw rnf;
        }
    }

    private final ConfigurationBoundResourceCache<Animator> $$robo$$android_content_res_ResourcesImpl$getAnimatorCache() {
        return this.mAnimatorCache;
    }

    private final ConfigurationBoundResourceCache<StateListAnimator> $$robo$$android_content_res_ResourcesImpl$getStateListAnimatorCache() {
        return this.mStateListAnimatorCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_content_res_ResourcesImpl$updateConfiguration(Configuration config, DisplayMetrics metrics, CompatibilityInfo compat) {
        Trace.traceBegin(8192L, "ResourcesImpl#updateConfiguration");
        try {
            Object object = this.mAccessLock;
            synchronized (object) {
                int height;
                int width;
                if (compat != null) {
                    this.mDisplayAdjustments.setCompatibilityInfo(compat);
                }
                if (metrics != null) {
                    this.mMetrics.setTo(metrics);
                }
                this.mDisplayAdjustments.getCompatibilityInfo().applyToDisplayMetrics(this.mMetrics);
                int configChanges = this.calcConfigChanges(config);
                LocaleList locales = this.mConfiguration.getLocales();
                if (locales.isEmpty()) {
                    locales = LocaleList.getDefault();
                    this.mConfiguration.setLocales(locales);
                }
                if ((configChanges & 4) != 0 && locales.size() > 1) {
                    Locale bestLocale;
                    String[] availableLocales = this.mAssets.getNonSystemLocales();
                    if (LocaleList.isPseudoLocalesOnly(availableLocales) && LocaleList.isPseudoLocalesOnly(availableLocales = this.mAssets.getLocales())) {
                        availableLocales = null;
                    }
                    if (availableLocales != null && (bestLocale = locales.getFirstMatchWithEnglishSupported(availableLocales)) != null && bestLocale != locales.get(0)) {
                        this.mConfiguration.setLocales(new LocaleList(bestLocale, locales));
                    }
                }
                if (this.mConfiguration.densityDpi != 0) {
                    this.mMetrics.densityDpi = this.mConfiguration.densityDpi;
                    this.mMetrics.density = (float)this.mConfiguration.densityDpi * 0.00625f;
                }
                this.mMetrics.scaledDensity = this.mMetrics.density * (this.mConfiguration.fontScale != 0.0f ? this.mConfiguration.fontScale : 1.0f);
                if (this.mMetrics.widthPixels >= this.mMetrics.heightPixels) {
                    width = this.mMetrics.widthPixels;
                    height = this.mMetrics.heightPixels;
                } else {
                    width = this.mMetrics.heightPixels;
                    height = this.mMetrics.widthPixels;
                }
                int keyboardHidden = this.mConfiguration.keyboardHidden == 1 && this.mConfiguration.hardKeyboardHidden == 2 ? 3 : this.mConfiguration.keyboardHidden;
                this.mAssets.setConfiguration(this.mConfiguration.mcc, this.mConfiguration.mnc, ResourcesImpl.adjustLanguageTag(this.mConfiguration.getLocales().get(0).toLanguageTag()), this.mConfiguration.orientation, this.mConfiguration.touchscreen, this.mConfiguration.densityDpi, this.mConfiguration.keyboard, keyboardHidden, this.mConfiguration.navigation, width, height, this.mConfiguration.smallestScreenWidthDp, this.mConfiguration.screenWidthDp, this.mConfiguration.screenHeightDp, this.mConfiguration.screenLayout, this.mConfiguration.uiMode, this.mConfiguration.colorMode, Build.VERSION.RESOURCES_SDK_INT);
                this.mDrawableCache.onConfigurationChange(configChanges);
                this.mColorDrawableCache.onConfigurationChange(configChanges);
                this.mComplexColorCache.onConfigurationChange(configChanges);
                this.mAnimatorCache.onConfigurationChange(configChanges);
                this.mStateListAnimatorCache.onConfigurationChange(configChanges);
                this.flushLayoutCache();
            }
            object = sSync;
            synchronized (object) {
                if (this.mPluralRule != null) {
                    this.mPluralRule = PluralRules.forLocale(this.mConfiguration.getLocales().get(0));
                }
            }
        }
        finally {
            Trace.traceEnd(8192L);
        }
    }

    private final int $$robo$$android_content_res_ResourcesImpl$calcConfigChanges(Configuration config) {
        if (config == null) {
            return -1;
        }
        this.mTmpConfig.setTo(config);
        int density = config.densityDpi;
        if (density == 0) {
            density = this.mMetrics.noncompatDensityDpi;
        }
        this.mDisplayAdjustments.getCompatibilityInfo().applyToConfiguration(density, this.mTmpConfig);
        if (this.mTmpConfig.getLocales().isEmpty()) {
            this.mTmpConfig.setLocales(LocaleList.getDefault());
        }
        return this.mConfiguration.updateFrom(this.mTmpConfig);
    }

    private static final String $$robo$$android_content_res_ResourcesImpl$adjustLanguageTag(String languageTag) {
        String remainder;
        String language;
        int separator = languageTag.indexOf(45);
        if (separator == -1) {
            language = languageTag;
            remainder = "";
        } else {
            language = languageTag.substring(0, separator);
            remainder = languageTag.substring(separator);
        }
        return (String)((Object)InvokeDynamicSupport.bootstrapIntrinsic("adjustLanguageCode", "java.util.Locale", (String)language)) + remainder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_content_res_ResourcesImpl$flushLayoutCache() {
        XmlBlock[] xmlBlockArray = this.mCachedXmlBlocks;
        synchronized (this.mCachedXmlBlocks) {
            Arrays.fill(this.mCachedXmlBlockCookies, 0);
            Arrays.fill(this.mCachedXmlBlockFiles, null);
            Object[] cachedXmlBlocks = this.mCachedXmlBlocks;
            for (int i = 0; i < 4; ++i) {
                XmlBlock oldBlock = cachedXmlBlocks[i];
                if (oldBlock == null) continue;
                oldBlock.close();
            }
            Arrays.fill(cachedXmlBlocks, null);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private final Drawable $$robo$$android_content_res_ResourcesImpl$loadDrawable(Resources wrapper, TypedValue value, int id2, int density, Resources.Theme theme) throws Resources.NotFoundException {
        boolean useCache;
        boolean bl = useCache = density == 0 || value.density == this.mMetrics.densityDpi;
        if (density > 0 && value.density > 0 && value.density != 65535) {
            value.density = value.density == density ? this.mMetrics.densityDpi : value.density * this.mMetrics.densityDpi / density;
        }
        try {
            boolean canApplyTheme;
            Drawable cachedDrawable;
            long key;
            DrawableCache caches;
            boolean isColorDrawable;
            if (value.type >= 28 && value.type <= 31) {
                isColorDrawable = true;
                caches = this.mColorDrawableCache;
                key = value.data;
            } else {
                isColorDrawable = false;
                caches = this.mDrawableCache;
                key = (long)value.assetCookie << 32 | (long)value.data;
            }
            if (!this.mPreloading && useCache && (cachedDrawable = caches.getInstance(key, wrapper, theme)) != null) {
                cachedDrawable.setChangingConfigurations(value.changingConfigurations);
                return cachedDrawable;
            }
            Drawable.ConstantState cs = isColorDrawable ? sPreloadedColorDrawables.get(key) : sPreloadedDrawables[this.mConfiguration.getLayoutDirection()].get(key);
            boolean needsNewDrawableAfterCache = false;
            Drawable dr = cs != null ? cs.newDrawable(wrapper) : (isColorDrawable ? new ColorDrawable(value.data) : this.loadDrawableForCookie(wrapper, value, id2, density, null));
            if (dr instanceof DrawableContainer) {
                needsNewDrawableAfterCache = true;
            }
            boolean bl2 = canApplyTheme = dr != null && dr.canApplyTheme();
            if (canApplyTheme && theme != null) {
                dr = dr.mutate();
                dr.applyTheme(theme);
                dr.clearMutated();
            }
            if (dr != null) {
                dr.setChangingConfigurations(value.changingConfigurations);
                if (useCache) {
                    Drawable.ConstantState state;
                    this.cacheDrawable(value, isColorDrawable, caches, theme, canApplyTheme, key, dr);
                    if (needsNewDrawableAfterCache && (state = dr.getConstantState()) != null) {
                        dr = state.newDrawable(wrapper);
                    }
                }
            }
            return dr;
        }
        catch (Exception e) {
            String name;
            try {
                name = this.getResourceName(id2);
            }
            catch (Resources.NotFoundException e2) {
                name = "(missing name)";
            }
            Resources.NotFoundException nfe = new Resources.NotFoundException("Drawable " + name + " with resource ID #0x" + Integer.toHexString(id2), e);
            nfe.setStackTrace(new StackTraceElement[0]);
            throw nfe;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_content_res_ResourcesImpl$cacheDrawable(TypedValue value, boolean isColorDrawable, DrawableCache caches, Resources.Theme theme, boolean usesTheme, long key, Drawable dr) {
        Drawable.ConstantState cs = dr.getConstantState();
        if (cs == null) {
            return;
        }
        if (this.mPreloading) {
            int changingConfigs = cs.getChangingConfigurations();
            if (isColorDrawable) {
                if (this.verifyPreloadConfig(changingConfigs, 0, value.resourceId, "drawable")) {
                    sPreloadedColorDrawables.put(key, cs);
                }
            } else if (this.verifyPreloadConfig(changingConfigs, 8192, value.resourceId, "drawable")) {
                if ((changingConfigs & 0x2000) == 0) {
                    sPreloadedDrawables[0].put(key, cs);
                    sPreloadedDrawables[1].put(key, cs);
                } else {
                    sPreloadedDrawables[this.mConfiguration.getLayoutDirection()].put(key, cs);
                }
            }
        } else {
            Object object = this.mAccessLock;
            synchronized (object) {
                caches.put(key, theme, cs, usesTheme);
            }
        }
    }

    private final boolean $$robo$$android_content_res_ResourcesImpl$verifyPreloadConfig(int changingConfigurations, int allowVarying, int resourceId, String name) {
        if ((changingConfigurations & 0xBFFFEFFF & ~allowVarying) != 0) {
            String resName;
            try {
                resName = this.getResourceName(resourceId);
            }
            catch (Resources.NotFoundException e) {
                resName = "?";
            }
            Log.w("Resources", "Preloaded " + name + " resource #0x" + Integer.toHexString(resourceId) + " (" + resName + ") that varies with configuration!!");
            return false;
        }
        return true;
    }

    private final Drawable $$robo$$android_content_res_ResourcesImpl$loadDrawableForCookie(Resources wrapper, TypedValue value, int id2, int density, Resources.Theme theme) {
        Drawable dr;
        if (value.string == null) {
            throw new Resources.NotFoundException("Resource \"" + this.getResourceName(id2) + "\" (" + Integer.toHexString(id2) + ") is not a Drawable (color or path): " + value);
        }
        String file = value.string.toString();
        Trace.traceBegin(8192L, file);
        try {
            if (file.endsWith(".xml")) {
                XmlResourceParser rp = this.loadXmlResourceParser(file, id2, value.assetCookie, "drawable");
                dr = Drawable.createFromXmlForDensity(wrapper, rp, density, theme);
                rp.close();
            } else {
                InputStream is = this.mAssets.openNonAsset(value.assetCookie, file, 2);
                dr = Drawable.createFromResourceStream(wrapper, value, is, file, null);
                is.close();
            }
        }
        catch (Exception e) {
            Trace.traceEnd(8192L);
            Resources.NotFoundException rnf = new Resources.NotFoundException("File " + file + " from drawable resource ID #0x" + Integer.toHexString(id2));
            rnf.initCause(e);
            throw rnf;
        }
        Trace.traceEnd(8192L);
        return dr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Typeface $$robo$$android_content_res_ResourcesImpl$loadFont(Resources wrapper, TypedValue value, int id2) {
        if (value.string == null) {
            throw new Resources.NotFoundException("Resource \"" + this.getResourceName(id2) + "\" (" + Integer.toHexString(id2) + ") is not a Font: " + value);
        }
        String file = value.string.toString();
        if (!file.startsWith("res/")) {
            return null;
        }
        Typeface cached = Typeface.findFromCache(this.mAssets, file);
        if (cached != null) {
            return cached;
        }
        Trace.traceBegin(8192L, file);
        try {
            if (file.endsWith("xml")) {
                XmlResourceParser rp = this.loadXmlResourceParser(file, id2, value.assetCookie, "font");
                FontResourcesParser.FamilyResourceEntry familyEntry = FontResourcesParser.parse(rp, wrapper);
                if (familyEntry == null) {
                    Typeface typeface = null;
                    return typeface;
                }
                Typeface typeface = Typeface.createFromResources(familyEntry, this.mAssets, file);
                return typeface;
            }
            Typeface rp = Typeface.createFromResources(this.mAssets, file, value.assetCookie);
            return rp;
        }
        catch (XmlPullParserException e) {
            Log.e("Resources", "Failed to parse xml resource " + file, e);
        }
        catch (IOException e) {
            Log.e("Resources", "Failed to read xml resource " + file, e);
        }
        finally {
            Trace.traceEnd(8192L);
        }
        return null;
    }

    private final ComplexColor $$robo$$android_content_res_ResourcesImpl$loadComplexColorFromName(Resources wrapper, Resources.Theme theme, TypedValue value, int id2) {
        ConfigurationBoundResourceCache<ComplexColor> cache = this.mComplexColorCache;
        long key = (long)value.assetCookie << 32 | (long)value.data;
        ComplexColor complexColor = cache.getInstance(key, wrapper, theme);
        if (complexColor != null) {
            return complexColor;
        }
        ConstantState<ComplexColor> factory = sPreloadedComplexColors.get(key);
        if (factory != null) {
            complexColor = factory.newInstance(wrapper, theme);
        }
        if (complexColor == null) {
            complexColor = this.loadComplexColorForCookie(wrapper, value, id2, theme);
        }
        if (complexColor != null) {
            complexColor.setBaseChangingConfigurations(value.changingConfigurations);
            if (this.mPreloading) {
                if (this.verifyPreloadConfig(complexColor.getChangingConfigurations(), 0, value.resourceId, "color")) {
                    sPreloadedComplexColors.put(key, complexColor.getConstantState());
                }
            } else {
                cache.put(key, theme, (ComplexColor)((Object)complexColor.getConstantState()));
            }
        }
        return complexColor;
    }

    private final ComplexColor $$robo$$android_content_res_ResourcesImpl$loadComplexColor(Resources wrapper, TypedValue value, int id2, Resources.Theme theme) {
        ComplexColor complexColor;
        long key = (long)value.assetCookie << 32 | (long)value.data;
        if (value.type >= 28 && value.type <= 31) {
            return this.getColorStateListFromInt(value, key);
        }
        String file = value.string.toString();
        if (file.endsWith(".xml")) {
            try {
                complexColor = this.loadComplexColorFromName(wrapper, theme, value, id2);
            }
            catch (Exception e) {
                Resources.NotFoundException rnf = new Resources.NotFoundException("File " + file + " from complex color resource ID #0x" + Integer.toHexString(id2));
                rnf.initCause(e);
                throw rnf;
            }
        } else {
            throw new Resources.NotFoundException("File " + file + " from drawable resource ID #0x" + Integer.toHexString(id2) + ": .xml extension required");
        }
        return complexColor;
    }

    private final ColorStateList $$robo$$android_content_res_ResourcesImpl$loadColorStateList(Resources wrapper, TypedValue value, int id2, Resources.Theme theme) throws Resources.NotFoundException {
        long key = (long)value.assetCookie << 32 | (long)value.data;
        if (value.type >= 28 && value.type <= 31) {
            return this.getColorStateListFromInt(value, key);
        }
        ComplexColor complexColor = this.loadComplexColorFromName(wrapper, theme, value, id2);
        if (complexColor != null && complexColor instanceof ColorStateList) {
            return (ColorStateList)complexColor;
        }
        throw new Resources.NotFoundException("Can't find ColorStateList from drawable resource ID #0x" + Integer.toHexString(id2));
    }

    private final ColorStateList $$robo$$android_content_res_ResourcesImpl$getColorStateListFromInt(TypedValue value, long key) {
        ConstantState<ComplexColor> factory = sPreloadedComplexColors.get(key);
        if (factory != null) {
            return (ColorStateList)factory.newInstance();
        }
        ColorStateList csl = ColorStateList.valueOf(value.data);
        if (this.mPreloading && this.verifyPreloadConfig(value.changingConfigurations, 0, value.resourceId, "color")) {
            sPreloadedComplexColors.put(key, csl.getConstantState());
        }
        return csl;
    }

    private final ComplexColor $$robo$$android_content_res_ResourcesImpl$loadComplexColorForCookie(Resources wrapper, TypedValue value, int id2, Resources.Theme theme) {
        if (value.string == null) {
            throw new UnsupportedOperationException("Can't convert to ComplexColor: type=0x" + value.type);
        }
        String file = value.string.toString();
        ComplexColor complexColor = null;
        Trace.traceBegin(8192L, file);
        if (file.endsWith(".xml")) {
            try {
                int type;
                XmlResourceParser parser = this.loadXmlResourceParser(file, id2, value.assetCookie, "ComplexColor");
                AttributeSet attrs = Xml.asAttributeSet(parser);
                while ((type = parser.next()) != 2 && type != 1) {
                }
                if (type != 2) {
                    throw new XmlPullParserException("No start tag found");
                }
                String name = parser.getName();
                if (name.equals("gradient")) {
                    complexColor = GradientColor.createFromXmlInner(wrapper, parser, attrs, theme);
                } else if (name.equals("selector")) {
                    complexColor = ColorStateList.createFromXmlInner(wrapper, parser, attrs, theme);
                }
                parser.close();
            }
            catch (Exception e) {
                Trace.traceEnd(8192L);
                Resources.NotFoundException rnf = new Resources.NotFoundException("File " + file + " from ComplexColor resource ID #0x" + Integer.toHexString(id2));
                rnf.initCause(e);
                throw rnf;
            }
        } else {
            Trace.traceEnd(8192L);
            throw new Resources.NotFoundException("File " + file + " from drawable resource ID #0x" + Integer.toHexString(id2) + ": .xml extension required");
        }
        Trace.traceEnd(8192L);
        return complexColor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final XmlResourceParser $$robo$$android_content_res_ResourcesImpl$loadXmlResourceParser(String file, int id2, int assetCookie, String type) throws Resources.NotFoundException {
        if (id2 != 0) {
            try {
                XmlBlock[] xmlBlockArray = this.mCachedXmlBlocks;
                synchronized (this.mCachedXmlBlocks) {
                    int[] cachedXmlBlockCookies = this.mCachedXmlBlockCookies;
                    String[] cachedXmlBlockFiles = this.mCachedXmlBlockFiles;
                    XmlBlock[] cachedXmlBlocks = this.mCachedXmlBlocks;
                    int num = cachedXmlBlockFiles.length;
                    for (int i = 0; i < num; ++i) {
                        if (cachedXmlBlockCookies[i] != assetCookie || cachedXmlBlockFiles[i] == null || !cachedXmlBlockFiles[i].equals(file)) continue;
                        // ** MonitorExit[var5_5] (shouldn't be in output)
                        return cachedXmlBlocks[i].newParser();
                    }
                    XmlBlock block = this.mAssets.openXmlBlockAsset(assetCookie, file);
                    if (block != null) {
                        int pos;
                        this.mLastCachedXmlBlockIndex = pos = (this.mLastCachedXmlBlockIndex + 1) % num;
                        XmlBlock oldBlock = cachedXmlBlocks[pos];
                        if (oldBlock != null) {
                            oldBlock.close();
                        }
                        cachedXmlBlockCookies[pos] = assetCookie;
                        cachedXmlBlockFiles[pos] = file;
                        cachedXmlBlocks[pos] = block;
                        // ** MonitorExit[var5_5] (shouldn't be in output)
                        return block.newParser();
                    }
                    // ** MonitorExit[var5_5] (shouldn't be in output)
                }
            }
            catch (Exception e) {
                Resources.NotFoundException rnf = new Resources.NotFoundException("File " + file + " from xml type " + type + " resource ID #0x" + Integer.toHexString(id2));
                rnf.initCause(e);
                throw rnf;
            }
        }
        {
            throw new Resources.NotFoundException("File " + file + " from xml type " + type + " resource ID #0x" + Integer.toHexString(id2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_content_res_ResourcesImpl$startPreloading() {
        Object object = sSync;
        synchronized (object) {
            if (sPreloaded) {
                throw new IllegalStateException("Resources already preloaded");
            }
            sPreloaded = true;
            this.mPreloading = true;
            this.mConfiguration.densityDpi = DisplayMetrics.DENSITY_DEVICE;
            this.updateConfiguration(null, null, null);
        }
    }

    private final void $$robo$$android_content_res_ResourcesImpl$finishPreloading() {
        if (this.mPreloading) {
            this.mPreloading = false;
            this.flushLayoutCache();
        }
    }

    private final LongSparseArray<Drawable.ConstantState> $$robo$$android_content_res_ResourcesImpl$getPreloadedDrawables() {
        return sPreloadedDrawables[0];
    }

    private final ThemeImpl $$robo$$android_content_res_ResourcesImpl$newThemeImpl() {
        return new ThemeImpl(this);
    }

    private final ThemeImpl $$robo$$android_content_res_ResourcesImpl$newThemeImpl(Resources.ThemeKey key) {
        ThemeImpl impl = new ThemeImpl(this);
        impl.mKey.setTo(key);
        impl.rebase();
        return impl;
    }

    static void __staticInitializer__() {
        sSync = new Object();
        sPreloadedColorDrawables = new LongSparseArray();
        sPreloadedComplexColors = new LongSparseArray();
        sPreloadedDrawables = new LongSparseArray[2];
        ResourcesImpl.sPreloadedDrawables[0] = new LongSparseArray();
        ResourcesImpl.sPreloadedDrawables[1] = new LongSparseArray();
    }

    private void __constructor__(AssetManager assetManager, DisplayMetrics displayMetrics, Configuration configuration, DisplayAdjustments displayAdjustments) {
        this.$$robo$$android_content_res_ResourcesImpl$__constructor__(assetManager, displayMetrics, configuration, displayAdjustments);
    }

    public ResourcesImpl(AssetManager assetManager, DisplayMetrics displayMetrics, Configuration configuration, DisplayAdjustments displayAdjustments) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_res_ResourcesImpl$__constructor__(android.content.res.AssetManager android.util.DisplayMetrics android.content.res.Configuration android.view.DisplayAdjustments ), this, assetManager, displayMetrics, configuration, displayAdjustments);
    }

    public DisplayAdjustments getDisplayAdjustments() {
        return InvokeDynamicSupport.bootstrap("getDisplayAdjustments", $$robo$$android_content_res_ResourcesImpl$getDisplayAdjustments(), this);
    }

    public AssetManager getAssets() {
        return InvokeDynamicSupport.bootstrap("getAssets", $$robo$$android_content_res_ResourcesImpl$getAssets(), this);
    }

    DisplayMetrics getDisplayMetrics() {
        return InvokeDynamicSupport.bootstrap("getDisplayMetrics", $$robo$$android_content_res_ResourcesImpl$getDisplayMetrics(), this);
    }

    Configuration getConfiguration() {
        return InvokeDynamicSupport.bootstrap("getConfiguration", $$robo$$android_content_res_ResourcesImpl$getConfiguration(), this);
    }

    Configuration[] getSizeConfigurations() {
        return InvokeDynamicSupport.bootstrap("getSizeConfigurations", $$robo$$android_content_res_ResourcesImpl$getSizeConfigurations(), this);
    }

    CompatibilityInfo getCompatibilityInfo() {
        return InvokeDynamicSupport.bootstrap("getCompatibilityInfo", $$robo$$android_content_res_ResourcesImpl$getCompatibilityInfo(), this);
    }

    private PluralRules getPluralRule() {
        return InvokeDynamicSupport.bootstrap("getPluralRule", $$robo$$android_content_res_ResourcesImpl$getPluralRule(), this);
    }

    void getValue(int n, TypedValue typedValue, boolean bl) throws Resources.NotFoundException {
        InvokeDynamicSupport.bootstrap("getValue", $$robo$$android_content_res_ResourcesImpl$getValue(int android.util.TypedValue boolean ), this, n, typedValue, bl);
    }

    void getValueForDensity(int n, int n2, TypedValue typedValue, boolean bl) throws Resources.NotFoundException {
        InvokeDynamicSupport.bootstrap("getValueForDensity", $$robo$$android_content_res_ResourcesImpl$getValueForDensity(int int android.util.TypedValue boolean ), this, n, n2, typedValue, bl);
    }

    void getValue(String string2, TypedValue typedValue, boolean bl) throws Resources.NotFoundException {
        InvokeDynamicSupport.bootstrap("getValue", $$robo$$android_content_res_ResourcesImpl$getValue(java.lang.String android.util.TypedValue boolean ), this, string2, typedValue, bl);
    }

    int getIdentifier(String string2, String string3, String string4) {
        return (int)InvokeDynamicSupport.bootstrap("getIdentifier", $$robo$$android_content_res_ResourcesImpl$getIdentifier(java.lang.String java.lang.String java.lang.String ), this, string2, string3, string4);
    }

    String getResourceName(int n) throws Resources.NotFoundException {
        return InvokeDynamicSupport.bootstrap("getResourceName", $$robo$$android_content_res_ResourcesImpl$getResourceName(int ), this, n);
    }

    String getResourcePackageName(int n) throws Resources.NotFoundException {
        return InvokeDynamicSupport.bootstrap("getResourcePackageName", $$robo$$android_content_res_ResourcesImpl$getResourcePackageName(int ), this, n);
    }

    String getResourceTypeName(int n) throws Resources.NotFoundException {
        return InvokeDynamicSupport.bootstrap("getResourceTypeName", $$robo$$android_content_res_ResourcesImpl$getResourceTypeName(int ), this, n);
    }

    String getResourceEntryName(int n) throws Resources.NotFoundException {
        return InvokeDynamicSupport.bootstrap("getResourceEntryName", $$robo$$android_content_res_ResourcesImpl$getResourceEntryName(int ), this, n);
    }

    CharSequence getQuantityText(int n, int n2) throws Resources.NotFoundException {
        return InvokeDynamicSupport.bootstrap("getQuantityText", $$robo$$android_content_res_ResourcesImpl$getQuantityText(int int ), this, n, n2);
    }

    private static int attrForQuantityCode(String string2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("attrForQuantityCode", $$robo$$android_content_res_ResourcesImpl$attrForQuantityCode(java.lang.String ), (String)string2);
    }

    AssetFileDescriptor openRawResourceFd(int n, TypedValue typedValue) throws Resources.NotFoundException {
        return InvokeDynamicSupport.bootstrap("openRawResourceFd", $$robo$$android_content_res_ResourcesImpl$openRawResourceFd(int android.util.TypedValue ), this, n, typedValue);
    }

    InputStream openRawResource(int n, TypedValue typedValue) throws Resources.NotFoundException {
        return InvokeDynamicSupport.bootstrap("openRawResource", $$robo$$android_content_res_ResourcesImpl$openRawResource(int android.util.TypedValue ), this, n, typedValue);
    }

    ConfigurationBoundResourceCache<Animator> getAnimatorCache() {
        return InvokeDynamicSupport.bootstrap("getAnimatorCache", $$robo$$android_content_res_ResourcesImpl$getAnimatorCache(), this);
    }

    ConfigurationBoundResourceCache<StateListAnimator> getStateListAnimatorCache() {
        return InvokeDynamicSupport.bootstrap("getStateListAnimatorCache", $$robo$$android_content_res_ResourcesImpl$getStateListAnimatorCache(), this);
    }

    public void updateConfiguration(Configuration configuration, DisplayMetrics displayMetrics, CompatibilityInfo compatibilityInfo) {
        InvokeDynamicSupport.bootstrap("updateConfiguration", $$robo$$android_content_res_ResourcesImpl$updateConfiguration(android.content.res.Configuration android.util.DisplayMetrics android.content.res.CompatibilityInfo ), this, configuration, displayMetrics, compatibilityInfo);
    }

    public int calcConfigChanges(Configuration configuration) {
        return (int)InvokeDynamicSupport.bootstrap("calcConfigChanges", $$robo$$android_content_res_ResourcesImpl$calcConfigChanges(android.content.res.Configuration ), this, configuration);
    }

    private static String adjustLanguageTag(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("adjustLanguageTag", $$robo$$android_content_res_ResourcesImpl$adjustLanguageTag(java.lang.String ), (String)string2);
    }

    public void flushLayoutCache() {
        InvokeDynamicSupport.bootstrap("flushLayoutCache", $$robo$$android_content_res_ResourcesImpl$flushLayoutCache(), this);
    }

    Drawable loadDrawable(Resources resources, TypedValue typedValue, int n, int n2, Resources.Theme theme) throws Resources.NotFoundException {
        return InvokeDynamicSupport.bootstrap("loadDrawable", $$robo$$android_content_res_ResourcesImpl$loadDrawable(android.content.res.Resources android.util.TypedValue int int android.content.res.Resources$Theme ), this, resources, typedValue, n, n2, theme);
    }

    private void cacheDrawable(TypedValue typedValue, boolean bl, DrawableCache drawableCache, Resources.Theme theme, boolean bl2, long l, Drawable drawable2) {
        InvokeDynamicSupport.bootstrap("cacheDrawable", $$robo$$android_content_res_ResourcesImpl$cacheDrawable(android.util.TypedValue boolean android.content.res.DrawableCache android.content.res.Resources$Theme boolean long android.graphics.drawable.Drawable ), this, typedValue, bl, drawableCache, theme, bl2, l, drawable2);
    }

    private boolean verifyPreloadConfig(int n, int n2, int n3, String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("verifyPreloadConfig", $$robo$$android_content_res_ResourcesImpl$verifyPreloadConfig(int int int java.lang.String ), this, n, n2, n3, string2);
    }

    private Drawable loadDrawableForCookie(Resources resources, TypedValue typedValue, int n, int n2, Resources.Theme theme) {
        return InvokeDynamicSupport.bootstrap("loadDrawableForCookie", $$robo$$android_content_res_ResourcesImpl$loadDrawableForCookie(android.content.res.Resources android.util.TypedValue int int android.content.res.Resources$Theme ), this, resources, typedValue, n, n2, theme);
    }

    public Typeface loadFont(Resources resources, TypedValue typedValue, int n) {
        return InvokeDynamicSupport.bootstrap("loadFont", $$robo$$android_content_res_ResourcesImpl$loadFont(android.content.res.Resources android.util.TypedValue int ), this, resources, typedValue, n);
    }

    private ComplexColor loadComplexColorFromName(Resources resources, Resources.Theme theme, TypedValue typedValue, int n) {
        return InvokeDynamicSupport.bootstrap("loadComplexColorFromName", $$robo$$android_content_res_ResourcesImpl$loadComplexColorFromName(android.content.res.Resources android.content.res.Resources$Theme android.util.TypedValue int ), this, resources, theme, typedValue, n);
    }

    ComplexColor loadComplexColor(Resources resources, TypedValue typedValue, int n, Resources.Theme theme) {
        return InvokeDynamicSupport.bootstrap("loadComplexColor", $$robo$$android_content_res_ResourcesImpl$loadComplexColor(android.content.res.Resources android.util.TypedValue int android.content.res.Resources$Theme ), this, resources, typedValue, n, theme);
    }

    ColorStateList loadColorStateList(Resources resources, TypedValue typedValue, int n, Resources.Theme theme) throws Resources.NotFoundException {
        return InvokeDynamicSupport.bootstrap("loadColorStateList", $$robo$$android_content_res_ResourcesImpl$loadColorStateList(android.content.res.Resources android.util.TypedValue int android.content.res.Resources$Theme ), this, resources, typedValue, n, theme);
    }

    private ColorStateList getColorStateListFromInt(TypedValue typedValue, long l) {
        return InvokeDynamicSupport.bootstrap("getColorStateListFromInt", $$robo$$android_content_res_ResourcesImpl$getColorStateListFromInt(android.util.TypedValue long ), this, typedValue, l);
    }

    private ComplexColor loadComplexColorForCookie(Resources resources, TypedValue typedValue, int n, Resources.Theme theme) {
        return InvokeDynamicSupport.bootstrap("loadComplexColorForCookie", $$robo$$android_content_res_ResourcesImpl$loadComplexColorForCookie(android.content.res.Resources android.util.TypedValue int android.content.res.Resources$Theme ), this, resources, typedValue, n, theme);
    }

    XmlResourceParser loadXmlResourceParser(String string2, int n, int n2, String string3) throws Resources.NotFoundException {
        return InvokeDynamicSupport.bootstrap("loadXmlResourceParser", $$robo$$android_content_res_ResourcesImpl$loadXmlResourceParser(java.lang.String int int java.lang.String ), this, string2, n, n2, string3);
    }

    public void startPreloading() {
        InvokeDynamicSupport.bootstrap("startPreloading", $$robo$$android_content_res_ResourcesImpl$startPreloading(), this);
    }

    void finishPreloading() {
        InvokeDynamicSupport.bootstrap("finishPreloading", $$robo$$android_content_res_ResourcesImpl$finishPreloading(), this);
    }

    LongSparseArray<Drawable.ConstantState> getPreloadedDrawables() {
        return InvokeDynamicSupport.bootstrap("getPreloadedDrawables", $$robo$$android_content_res_ResourcesImpl$getPreloadedDrawables(), this);
    }

    ThemeImpl newThemeImpl() {
        return InvokeDynamicSupport.bootstrap("newThemeImpl", $$robo$$android_content_res_ResourcesImpl$newThemeImpl(), this);
    }

    ThemeImpl newThemeImpl(Resources.ThemeKey themeKey) {
        return InvokeDynamicSupport.bootstrap("newThemeImpl", $$robo$$android_content_res_ResourcesImpl$newThemeImpl(android.content.res.Resources$ThemeKey ), this, themeKey);
    }

    static {
        RobolectricInternals.classInitializing(ResourcesImpl.class);
    }

    public /* synthetic */ ResourcesImpl() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ResourcesImpl)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public class ThemeImpl
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private Resources.ThemeKey mKey;
        private AssetManager mAssets;
        private long mTheme;
        private int mThemeResId;
        /* synthetic */ ResourcesImpl this$0;

        private void $$robo$$android_content_res_ResourcesImpl_ThemeImpl$__constructor__(ResourcesImpl this$0) {
            this.mKey = new Resources.ThemeKey();
            this.mThemeResId = 0;
            this.mAssets = this$0.mAssets;
            this.mTheme = this.mAssets.createTheme();
        }

        private final void $$robo$$android_content_res_ResourcesImpl_ThemeImpl$finalize() throws Throwable {
            super.finalize();
            this.mAssets.releaseTheme(this.mTheme);
        }

        private final Resources.ThemeKey $$robo$$android_content_res_ResourcesImpl_ThemeImpl$getKey() {
            return this.mKey;
        }

        private final long $$robo$$android_content_res_ResourcesImpl_ThemeImpl$getNativeTheme() {
            return this.mTheme;
        }

        private final int $$robo$$android_content_res_ResourcesImpl_ThemeImpl$getAppliedStyleResId() {
            return this.mThemeResId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_content_res_ResourcesImpl_ThemeImpl$applyStyle(int resId, boolean force) {
            Resources.ThemeKey themeKey = this.mKey;
            synchronized (themeKey) {
                AssetManager.applyThemeStyle(this.mTheme, resId, force);
                this.mThemeResId = resId;
                this.mKey.append(resId, force);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_content_res_ResourcesImpl_ThemeImpl$setTo(ThemeImpl other) {
            Resources.ThemeKey themeKey = this.mKey;
            synchronized (themeKey) {
                Resources.ThemeKey themeKey2 = other.mKey;
                synchronized (themeKey2) {
                    AssetManager.copyTheme(this.mTheme, other.mTheme);
                    this.mThemeResId = other.mThemeResId;
                    this.mKey.setTo(other.getKey());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final TypedArray $$robo$$android_content_res_ResourcesImpl_ThemeImpl$obtainStyledAttributes(Resources.Theme wrapper, AttributeSet set, int[] attrs, int defStyleAttr, int defStyleRes) {
            Resources.ThemeKey themeKey = this.mKey;
            synchronized (themeKey) {
                int len = attrs.length;
                TypedArray array2 = TypedArray.obtain(wrapper.getResources(), len);
                XmlBlock.Parser parser = (XmlBlock.Parser)set;
                AssetManager.applyStyle(this.mTheme, defStyleAttr, defStyleRes, parser != null ? parser.mParseState : 0L, attrs, attrs.length, array2.mDataAddress, array2.mIndicesAddress);
                array2.mTheme = wrapper;
                array2.mXml = parser;
                return array2;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final TypedArray $$robo$$android_content_res_ResourcesImpl_ThemeImpl$resolveAttributes(Resources.Theme wrapper, int[] values, int[] attrs) {
            Resources.ThemeKey themeKey = this.mKey;
            synchronized (themeKey) {
                int len = attrs.length;
                if (values == null || len != values.length) {
                    throw new IllegalArgumentException("Base attribute values must the same length as attrs");
                }
                TypedArray array2 = TypedArray.obtain(wrapper.getResources(), len);
                AssetManager.resolveAttrs(this.mTheme, 0, 0, values, attrs, array2.mData, array2.mIndices);
                array2.mTheme = wrapper;
                array2.mXml = null;
                return array2;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final boolean $$robo$$android_content_res_ResourcesImpl_ThemeImpl$resolveAttribute(int resid, TypedValue outValue, boolean resolveRefs) {
            Resources.ThemeKey themeKey = this.mKey;
            synchronized (themeKey) {
                return this.mAssets.getThemeValue(this.mTheme, resid, outValue, resolveRefs);
            }
        }

        private final int[] $$robo$$android_content_res_ResourcesImpl_ThemeImpl$getAllAttributes() {
            return this.mAssets.getStyleAttributes(this.getAppliedStyleResId());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final int $$robo$$android_content_res_ResourcesImpl_ThemeImpl$getChangingConfigurations() {
            Resources.ThemeKey themeKey = this.mKey;
            synchronized (themeKey) {
                int nativeChangingConfig = AssetManager.getThemeChangingConfigurations(this.mTheme);
                return ActivityInfo.activityInfoConfigNativeToJava(nativeChangingConfig);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_content_res_ResourcesImpl_ThemeImpl$dump(int priority, String tag, String prefix) {
            Resources.ThemeKey themeKey = this.mKey;
            synchronized (themeKey) {
                AssetManager.dumpTheme(this.mTheme, priority, tag, prefix);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final String[] $$robo$$android_content_res_ResourcesImpl_ThemeImpl$getTheme() {
            Resources.ThemeKey themeKey = this.mKey;
            synchronized (themeKey) {
                int N = this.mKey.mCount;
                String[] themes = new String[N * 2];
                int i = 0;
                int j = N - 1;
                while (i < themes.length) {
                    int resId = this.mKey.mResId[j];
                    boolean forced = this.mKey.mForce[j];
                    try {
                        themes[i] = this.this$0.getResourceName(resId);
                    }
                    catch (Resources.NotFoundException e) {
                        themes[i] = Integer.toHexString(i);
                    }
                    themes[i + 1] = forced ? "forced" : "not forced";
                    i += 2;
                    --j;
                }
                return themes;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_content_res_ResourcesImpl_ThemeImpl$rebase() {
            Resources.ThemeKey themeKey = this.mKey;
            synchronized (themeKey) {
                AssetManager.clearTheme(this.mTheme);
                for (int i = 0; i < this.mKey.mCount; ++i) {
                    int resId = this.mKey.mResId[i];
                    boolean force = this.mKey.mForce[i];
                    AssetManager.applyThemeStyle(this.mTheme, resId, force);
                }
            }
        }

        private void __constructor__(ResourcesImpl resourcesImpl) {
            this.$$robo$$android_content_res_ResourcesImpl_ThemeImpl$__constructor__(resourcesImpl);
        }

        public ThemeImpl(ResourcesImpl resourcesImpl) {
            this.this$0 = resourcesImpl;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_res_ResourcesImpl_ThemeImpl$__constructor__(android.content.res.ResourcesImpl ), this, resourcesImpl);
        }

        protected void finalize() throws Throwable {
            InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_content_res_ResourcesImpl_ThemeImpl$finalize(), this);
        }

        Resources.ThemeKey getKey() {
            return InvokeDynamicSupport.bootstrap("getKey", $$robo$$android_content_res_ResourcesImpl_ThemeImpl$getKey(), this);
        }

        long getNativeTheme() {
            return (long)InvokeDynamicSupport.bootstrap("getNativeTheme", $$robo$$android_content_res_ResourcesImpl_ThemeImpl$getNativeTheme(), this);
        }

        int getAppliedStyleResId() {
            return (int)InvokeDynamicSupport.bootstrap("getAppliedStyleResId", $$robo$$android_content_res_ResourcesImpl_ThemeImpl$getAppliedStyleResId(), this);
        }

        void applyStyle(int n, boolean bl) {
            InvokeDynamicSupport.bootstrap("applyStyle", $$robo$$android_content_res_ResourcesImpl_ThemeImpl$applyStyle(int boolean ), this, n, bl);
        }

        void setTo(ThemeImpl themeImpl) {
            InvokeDynamicSupport.bootstrap("setTo", $$robo$$android_content_res_ResourcesImpl_ThemeImpl$setTo(android.content.res.ResourcesImpl$ThemeImpl ), this, themeImpl);
        }

        TypedArray obtainStyledAttributes(Resources.Theme theme, AttributeSet attributeSet, int[] nArray, int n, int n2) {
            return InvokeDynamicSupport.bootstrap("obtainStyledAttributes", $$robo$$android_content_res_ResourcesImpl_ThemeImpl$obtainStyledAttributes(android.content.res.Resources$Theme android.util.AttributeSet int[] int int ), this, theme, attributeSet, nArray, n, n2);
        }

        TypedArray resolveAttributes(Resources.Theme theme, int[] nArray, int[] nArray2) {
            return InvokeDynamicSupport.bootstrap("resolveAttributes", $$robo$$android_content_res_ResourcesImpl_ThemeImpl$resolveAttributes(android.content.res.Resources$Theme int[] int[] ), this, theme, nArray, nArray2);
        }

        boolean resolveAttribute(int n, TypedValue typedValue, boolean bl) {
            return (boolean)InvokeDynamicSupport.bootstrap("resolveAttribute", $$robo$$android_content_res_ResourcesImpl_ThemeImpl$resolveAttribute(int android.util.TypedValue boolean ), this, n, typedValue, bl);
        }

        int[] getAllAttributes() {
            return InvokeDynamicSupport.bootstrap("getAllAttributes", $$robo$$android_content_res_ResourcesImpl_ThemeImpl$getAllAttributes(), this);
        }

        int getChangingConfigurations() {
            return (int)InvokeDynamicSupport.bootstrap("getChangingConfigurations", $$robo$$android_content_res_ResourcesImpl_ThemeImpl$getChangingConfigurations(), this);
        }

        public void dump(int n, String string2, String string3) {
            InvokeDynamicSupport.bootstrap("dump", $$robo$$android_content_res_ResourcesImpl_ThemeImpl$dump(int java.lang.String java.lang.String ), this, n, string2, string3);
        }

        String[] getTheme() {
            return InvokeDynamicSupport.bootstrap("getTheme", $$robo$$android_content_res_ResourcesImpl_ThemeImpl$getTheme(), this);
        }

        void rebase() {
            InvokeDynamicSupport.bootstrap("rebase", $$robo$$android_content_res_ResourcesImpl_ThemeImpl$rebase(), this);
        }

        public /* synthetic */ ThemeImpl() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ThemeImpl)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

