/*
 * Decompiled with CFR 0.152.
 */
package android.database.sqlite;

import android.database.DatabaseUtils;
import android.database.sqlite.SQLiteClosable;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteSession;
import android.database.sqlite.SQLiteStatementInfo;
import android.os.CancellationSignal;
import java.util.Arrays;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class SQLiteProgram
extends SQLiteClosable
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String[] EMPTY_STRING_ARRAY;
    private SQLiteDatabase mDatabase;
    private String mSql;
    private boolean mReadOnly;
    private String[] mColumnNames;
    private int mNumParameters;
    private Object[] mBindArgs;

    private void $$robo$$android_database_sqlite_SQLiteProgram$__constructor__(SQLiteDatabase db, String sql, Object[] bindArgs, CancellationSignal cancellationSignalForPrepare) {
        this.mDatabase = db;
        this.mSql = sql.trim();
        int n = DatabaseUtils.getSqlStatementType(this.mSql);
        switch (n) {
            case 4: 
            case 5: 
            case 6: {
                this.mReadOnly = false;
                this.mColumnNames = EMPTY_STRING_ARRAY;
                this.mNumParameters = 0;
                break;
            }
            default: {
                boolean assumeReadOnly = n == 1;
                SQLiteStatementInfo info = new SQLiteStatementInfo();
                db.getThreadSession().prepare(this.mSql, db.getThreadDefaultConnectionFlags(assumeReadOnly), cancellationSignalForPrepare, info);
                this.mReadOnly = info.readOnly;
                this.mColumnNames = info.columnNames;
                this.mNumParameters = info.numParameters;
            }
        }
        if (bindArgs != null && bindArgs.length > this.mNumParameters) {
            throw new IllegalArgumentException("Too many bind arguments.  " + bindArgs.length + " arguments were provided but the statement needs " + this.mNumParameters + " arguments.");
        }
        if (this.mNumParameters != 0) {
            this.mBindArgs = new Object[this.mNumParameters];
            if (bindArgs != null) {
                InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)bindArgs, (int)0, (Object)this.mBindArgs, (int)0, (int)bindArgs.length);
            }
        } else {
            this.mBindArgs = null;
        }
    }

    private final SQLiteDatabase $$robo$$android_database_sqlite_SQLiteProgram$getDatabase() {
        return this.mDatabase;
    }

    private final String $$robo$$android_database_sqlite_SQLiteProgram$getSql() {
        return this.mSql;
    }

    private final Object[] $$robo$$android_database_sqlite_SQLiteProgram$getBindArgs() {
        return this.mBindArgs;
    }

    private final String[] $$robo$$android_database_sqlite_SQLiteProgram$getColumnNames() {
        return this.mColumnNames;
    }

    private final SQLiteSession $$robo$$android_database_sqlite_SQLiteProgram$getSession() {
        return this.mDatabase.getThreadSession();
    }

    private final int $$robo$$android_database_sqlite_SQLiteProgram$getConnectionFlags() {
        return this.mDatabase.getThreadDefaultConnectionFlags(this.mReadOnly);
    }

    private final void $$robo$$android_database_sqlite_SQLiteProgram$onCorruption() {
        this.mDatabase.onCorruption();
    }

    @Deprecated
    private final int $$robo$$android_database_sqlite_SQLiteProgram$getUniqueId() {
        return -1;
    }

    private final void $$robo$$android_database_sqlite_SQLiteProgram$bindNull(int index) {
        this.bind(index, null);
    }

    private final void $$robo$$android_database_sqlite_SQLiteProgram$bindLong(int index, long value) {
        this.bind(index, value);
    }

    private final void $$robo$$android_database_sqlite_SQLiteProgram$bindDouble(int index, double value) {
        this.bind(index, value);
    }

    private final void $$robo$$android_database_sqlite_SQLiteProgram$bindString(int index, String value) {
        if (value == null) {
            throw new IllegalArgumentException("the bind value at index " + index + " is null");
        }
        this.bind(index, value);
    }

    private final void $$robo$$android_database_sqlite_SQLiteProgram$bindBlob(int index, byte[] value) {
        if (value == null) {
            throw new IllegalArgumentException("the bind value at index " + index + " is null");
        }
        this.bind(index, value);
    }

    private final void $$robo$$android_database_sqlite_SQLiteProgram$clearBindings() {
        if (this.mBindArgs != null) {
            Arrays.fill(this.mBindArgs, null);
        }
    }

    private final void $$robo$$android_database_sqlite_SQLiteProgram$bindAllArgsAsStrings(String[] bindArgs) {
        if (bindArgs != null) {
            for (int i = bindArgs.length; i != 0; --i) {
                this.bindString(i, bindArgs[i - 1]);
            }
        }
    }

    private final void $$robo$$android_database_sqlite_SQLiteProgram$onAllReferencesReleased() {
        this.clearBindings();
    }

    private final void $$robo$$android_database_sqlite_SQLiteProgram$bind(int index, Object value) {
        if (index < 1 || index > this.mNumParameters) {
            throw new IllegalArgumentException("Cannot bind argument at index " + index + " because the index is out of range.  The statement has " + this.mNumParameters + " parameters.");
        }
        this.mBindArgs[index - 1] = value;
    }

    static void __staticInitializer__() {
        EMPTY_STRING_ARRAY = new String[0];
    }

    private void __constructor__(SQLiteDatabase sQLiteDatabase, String string2, Object[] objectArray, CancellationSignal cancellationSignal) {
        this.$$robo$$android_database_sqlite_SQLiteProgram$__constructor__(sQLiteDatabase, string2, objectArray, cancellationSignal);
    }

    public SQLiteProgram(SQLiteDatabase sQLiteDatabase, String string2, Object[] objectArray, CancellationSignal cancellationSignal) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_database_sqlite_SQLiteProgram$__constructor__(android.database.sqlite.SQLiteDatabase java.lang.String java.lang.Object[] android.os.CancellationSignal ), this, sQLiteDatabase, string2, objectArray, cancellationSignal);
    }

    SQLiteDatabase getDatabase() {
        return InvokeDynamicSupport.bootstrap("getDatabase", $$robo$$android_database_sqlite_SQLiteProgram$getDatabase(), this);
    }

    String getSql() {
        return InvokeDynamicSupport.bootstrap("getSql", $$robo$$android_database_sqlite_SQLiteProgram$getSql(), this);
    }

    Object[] getBindArgs() {
        return InvokeDynamicSupport.bootstrap("getBindArgs", $$robo$$android_database_sqlite_SQLiteProgram$getBindArgs(), this);
    }

    String[] getColumnNames() {
        return InvokeDynamicSupport.bootstrap("getColumnNames", $$robo$$android_database_sqlite_SQLiteProgram$getColumnNames(), this);
    }

    protected SQLiteSession getSession() {
        return InvokeDynamicSupport.bootstrap("getSession", $$robo$$android_database_sqlite_SQLiteProgram$getSession(), this);
    }

    protected int getConnectionFlags() {
        return (int)InvokeDynamicSupport.bootstrap("getConnectionFlags", $$robo$$android_database_sqlite_SQLiteProgram$getConnectionFlags(), this);
    }

    protected void onCorruption() {
        InvokeDynamicSupport.bootstrap("onCorruption", $$robo$$android_database_sqlite_SQLiteProgram$onCorruption(), this);
    }

    @Deprecated
    public int getUniqueId() {
        return (int)InvokeDynamicSupport.bootstrap("getUniqueId", $$robo$$android_database_sqlite_SQLiteProgram$getUniqueId(), this);
    }

    public void bindNull(int n) {
        InvokeDynamicSupport.bootstrap("bindNull", $$robo$$android_database_sqlite_SQLiteProgram$bindNull(int ), this, n);
    }

    public void bindLong(int n, long l) {
        InvokeDynamicSupport.bootstrap("bindLong", $$robo$$android_database_sqlite_SQLiteProgram$bindLong(int long ), this, n, l);
    }

    public void bindDouble(int n, double d) {
        InvokeDynamicSupport.bootstrap("bindDouble", $$robo$$android_database_sqlite_SQLiteProgram$bindDouble(int double ), this, n, d);
    }

    public void bindString(int n, String string2) {
        InvokeDynamicSupport.bootstrap("bindString", $$robo$$android_database_sqlite_SQLiteProgram$bindString(int java.lang.String ), this, n, string2);
    }

    public void bindBlob(int n, byte[] byArray) {
        InvokeDynamicSupport.bootstrap("bindBlob", $$robo$$android_database_sqlite_SQLiteProgram$bindBlob(int byte[] ), this, n, byArray);
    }

    public void clearBindings() {
        InvokeDynamicSupport.bootstrap("clearBindings", $$robo$$android_database_sqlite_SQLiteProgram$clearBindings(), this);
    }

    public void bindAllArgsAsStrings(String[] stringArray) {
        InvokeDynamicSupport.bootstrap("bindAllArgsAsStrings", $$robo$$android_database_sqlite_SQLiteProgram$bindAllArgsAsStrings(java.lang.String[] ), this, stringArray);
    }

    @Override
    protected void onAllReferencesReleased() {
        InvokeDynamicSupport.bootstrap("onAllReferencesReleased", $$robo$$android_database_sqlite_SQLiteProgram$onAllReferencesReleased(), this);
    }

    private void bind(int n, Object object) {
        InvokeDynamicSupport.bootstrap("bind", $$robo$$android_database_sqlite_SQLiteProgram$bind(int java.lang.Object ), this, n, object);
    }

    static {
        RobolectricInternals.classInitializing(SQLiteProgram.class);
    }

    public /* synthetic */ SQLiteProgram() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SQLiteProgram)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

