/*
 * Decompiled with CFR 0.152.
 */
package android.filterpacks.imageproc;

import android.filterfw.core.Filter;
import android.filterfw.core.FilterContext;
import android.filterfw.core.Frame;
import android.filterfw.core.FrameFormat;
import android.filterfw.core.GenerateFieldPort;
import android.filterfw.core.Program;
import android.filterfw.core.ShaderProgram;
import android.filterfw.format.ImageFormat;
import android.util.Log;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class FillLightFilter
extends Filter
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    @GenerateFieldPort(name="tile_size", hasDefault=true)
    private int mTileSize;
    @GenerateFieldPort(name="strength", hasDefault=true)
    private float mBacklight;
    private Program mProgram;
    private int mTarget;
    private String mFillLightShader = "precision mediump float;\nuniform sampler2D tex_sampler_0;\nuniform float mult;\nuniform float igamma;\nvarying vec2 v_texcoord;\nvoid main()\n{\n  const vec3 color_weights = vec3(0.25, 0.5, 0.25);\n  vec4 color = texture2D(tex_sampler_0, v_texcoord);\n  float lightmask = dot(color.rgb, color_weights);\n  float backmask = (1.0 - lightmask);\n  vec3 ones = vec3(1.0, 1.0, 1.0);\n  vec3 diff = pow(mult * color.rgb, igamma * ones) - color.rgb;\n  diff = min(diff, 1.0);\n  vec3 new_color = min(color.rgb + diff * backmask, 1.0);\n  gl_FragColor = vec4(new_color, color.a);\n}\n";

    private void $$robo$$android_filterpacks_imageproc_FillLightFilter$__constructor__(String name) {
        this.mTileSize = 640;
        this.mBacklight = 0.0f;
        this.mTarget = 0;
        this.mFillLightShader = "precision mediump float;\nuniform sampler2D tex_sampler_0;\nuniform float mult;\nuniform float igamma;\nvarying vec2 v_texcoord;\nvoid main()\n{\n  const vec3 color_weights = vec3(0.25, 0.5, 0.25);\n  vec4 color = texture2D(tex_sampler_0, v_texcoord);\n  float lightmask = dot(color.rgb, color_weights);\n  float backmask = (1.0 - lightmask);\n  vec3 ones = vec3(1.0, 1.0, 1.0);\n  vec3 diff = pow(mult * color.rgb, igamma * ones) - color.rgb;\n  diff = min(diff, 1.0);\n  vec3 new_color = min(color.rgb + diff * backmask, 1.0);\n  gl_FragColor = vec4(new_color, color.a);\n}\n";
    }

    private final void $$robo$$android_filterpacks_imageproc_FillLightFilter$setupPorts() {
        this.addMaskedInputPort("image", ImageFormat.create(3));
        this.addOutputBasedOnInput("image", "image");
    }

    private final FrameFormat $$robo$$android_filterpacks_imageproc_FillLightFilter$getOutputFormat(String portName, FrameFormat inputFormat) {
        return inputFormat;
    }

    private final void $$robo$$android_filterpacks_imageproc_FillLightFilter$initProgram(FilterContext context, int target) {
        switch (target) {
            case 3: {
                ShaderProgram shaderProgram = new ShaderProgram(context, "precision mediump float;\nuniform sampler2D tex_sampler_0;\nuniform float mult;\nuniform float igamma;\nvarying vec2 v_texcoord;\nvoid main()\n{\n  const vec3 color_weights = vec3(0.25, 0.5, 0.25);\n  vec4 color = texture2D(tex_sampler_0, v_texcoord);\n  float lightmask = dot(color.rgb, color_weights);\n  float backmask = (1.0 - lightmask);\n  vec3 ones = vec3(1.0, 1.0, 1.0);\n  vec3 diff = pow(mult * color.rgb, igamma * ones) - color.rgb;\n  diff = min(diff, 1.0);\n  vec3 new_color = min(color.rgb + diff * backmask, 1.0);\n  gl_FragColor = vec4(new_color, color.a);\n}\n");
                Log.e("FillLight", "tile size: " + this.mTileSize);
                shaderProgram.setMaximumTileSize(this.mTileSize);
                this.mProgram = shaderProgram;
                break;
            }
            default: {
                throw new RuntimeException("Filter FillLight does not support frames of target " + target + "!");
            }
        }
        this.mTarget = target;
    }

    private final void $$robo$$android_filterpacks_imageproc_FillLightFilter$process(FilterContext context) {
        Frame input = this.pullInput("image");
        FrameFormat inputFormat = input.getFormat();
        Frame output = context.getFrameManager().newFrame(inputFormat);
        if (this.mProgram == null || inputFormat.getTarget() != this.mTarget) {
            this.initProgram(context, inputFormat.getTarget());
            this.updateParameters();
        }
        this.mProgram.process(input, output);
        this.pushOutput("image", output);
        output.release();
    }

    private final void $$robo$$android_filterpacks_imageproc_FillLightFilter$fieldPortValueUpdated(String name, FilterContext context) {
        if (this.mProgram != null) {
            this.updateParameters();
        }
    }

    private final void $$robo$$android_filterpacks_imageproc_FillLightFilter$updateParameters() {
        float fade_gamma = 0.3f;
        float amt = 1.0f - this.mBacklight;
        float mult = 1.0f / (amt * 0.7f + 0.3f);
        float faded = fade_gamma + (1.0f - fade_gamma) * mult;
        float igamma = 1.0f / faded;
        this.mProgram.setHostValue("mult", Float.valueOf(mult));
        this.mProgram.setHostValue("igamma", Float.valueOf(igamma));
    }

    private void __constructor__(String string2) {
        this.$$robo$$android_filterpacks_imageproc_FillLightFilter$__constructor__(string2);
    }

    public FillLightFilter(String string2) {
        super(string2);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_filterpacks_imageproc_FillLightFilter$__constructor__(java.lang.String ), this, string2);
    }

    @Override
    public void setupPorts() {
        InvokeDynamicSupport.bootstrap("setupPorts", $$robo$$android_filterpacks_imageproc_FillLightFilter$setupPorts(), this);
    }

    @Override
    public FrameFormat getOutputFormat(String string2, FrameFormat frameFormat) {
        return InvokeDynamicSupport.bootstrap("getOutputFormat", $$robo$$android_filterpacks_imageproc_FillLightFilter$getOutputFormat(java.lang.String android.filterfw.core.FrameFormat ), this, string2, frameFormat);
    }

    public void initProgram(FilterContext filterContext, int n) {
        InvokeDynamicSupport.bootstrap("initProgram", $$robo$$android_filterpacks_imageproc_FillLightFilter$initProgram(android.filterfw.core.FilterContext int ), this, filterContext, n);
    }

    @Override
    public void process(FilterContext filterContext) {
        InvokeDynamicSupport.bootstrap("process", $$robo$$android_filterpacks_imageproc_FillLightFilter$process(android.filterfw.core.FilterContext ), this, filterContext);
    }

    @Override
    public void fieldPortValueUpdated(String string2, FilterContext filterContext) {
        InvokeDynamicSupport.bootstrap("fieldPortValueUpdated", $$robo$$android_filterpacks_imageproc_FillLightFilter$fieldPortValueUpdated(java.lang.String android.filterfw.core.FilterContext ), this, string2, filterContext);
    }

    private void updateParameters() {
        InvokeDynamicSupport.bootstrap("updateParameters", $$robo$$android_filterpacks_imageproc_FillLightFilter$updateParameters(), this);
    }

    public /* synthetic */ FillLightFilter() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (FillLightFilter)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

