/*
 * Decompiled with CFR 0.152.
 */
package android.filterpacks.imageproc;

import android.filterfw.core.Filter;
import android.filterfw.core.FilterContext;
import android.filterfw.core.Frame;
import android.filterfw.core.FrameFormat;
import android.filterfw.core.GenerateFieldPort;
import android.filterfw.core.MutableFrameFormat;
import android.filterfw.core.Program;
import android.filterfw.core.ShaderProgram;
import android.filterfw.format.ImageFormat;
import android.filterfw.geometry.Point;
import android.filterfw.geometry.Quad;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class RotateFilter
extends Filter
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    @GenerateFieldPort(name="angle")
    private int mAngle;
    @GenerateFieldPort(name="tile_size", hasDefault=true)
    private int mTileSize;
    private Program mProgram;
    private int mWidth;
    private int mHeight;
    private int mTarget;
    private int mOutputWidth;
    private int mOutputHeight;

    private void $$robo$$android_filterpacks_imageproc_RotateFilter$__constructor__(String name) {
        this.mTileSize = 640;
        this.mWidth = 0;
        this.mHeight = 0;
        this.mTarget = 0;
    }

    private final void $$robo$$android_filterpacks_imageproc_RotateFilter$setupPorts() {
        this.addMaskedInputPort("image", ImageFormat.create(3));
        this.addOutputBasedOnInput("image", "image");
    }

    private final void $$robo$$android_filterpacks_imageproc_RotateFilter$initProgram(FilterContext context, int target) {
        switch (target) {
            case 3: {
                ShaderProgram shaderProgram = ShaderProgram.createIdentity(context);
                shaderProgram.setMaximumTileSize(this.mTileSize);
                shaderProgram.setClearsOutput(true);
                this.mProgram = shaderProgram;
                break;
            }
            default: {
                throw new RuntimeException("Filter Sharpen does not support frames of target " + target + "!");
            }
        }
        this.mTarget = target;
    }

    private final void $$robo$$android_filterpacks_imageproc_RotateFilter$fieldPortValueUpdated(String name, FilterContext context) {
        if (this.mProgram != null) {
            this.updateParameters();
        }
    }

    private final void $$robo$$android_filterpacks_imageproc_RotateFilter$process(FilterContext context) {
        Frame input = this.pullInput("image");
        FrameFormat inputFormat = input.getFormat();
        if (this.mProgram == null || inputFormat.getTarget() != this.mTarget) {
            this.initProgram(context, inputFormat.getTarget());
        }
        if (inputFormat.getWidth() != this.mWidth || inputFormat.getHeight() != this.mHeight) {
            this.mWidth = inputFormat.getWidth();
            this.mHeight = inputFormat.getHeight();
            this.mOutputWidth = this.mWidth;
            this.mOutputHeight = this.mHeight;
            this.updateParameters();
        }
        MutableFrameFormat outputFormat = ImageFormat.create(this.mOutputWidth, this.mOutputHeight, 3, 3);
        Frame output = context.getFrameManager().newFrame(outputFormat);
        this.mProgram.process(input, output);
        this.pushOutput("image", output);
        output.release();
    }

    private final void $$robo$$android_filterpacks_imageproc_RotateFilter$updateParameters() {
        float cosTheta;
        float sinTheta;
        if (this.mAngle % 90 == 0) {
            if (this.mAngle % 180 == 0) {
                sinTheta = 0.0f;
                cosTheta = this.mAngle % 360 == 0 ? 1.0f : -1.0f;
            } else {
                cosTheta = 0.0f;
                sinTheta = (this.mAngle + 90) % 360 == 0 ? -1.0f : 1.0f;
                this.mOutputWidth = this.mHeight;
                this.mOutputHeight = this.mWidth;
            }
        } else {
            throw new RuntimeException("degree has to be multiply of 90.");
        }
        Point x0 = new Point(0.5f * (-cosTheta + sinTheta + 1.0f), 0.5f * (-sinTheta - cosTheta + 1.0f));
        Point x1 = new Point(0.5f * (cosTheta + sinTheta + 1.0f), 0.5f * (sinTheta - cosTheta + 1.0f));
        Point x2 = new Point(0.5f * (-cosTheta - sinTheta + 1.0f), 0.5f * (-sinTheta + cosTheta + 1.0f));
        Point x3 = new Point(0.5f * (cosTheta - sinTheta + 1.0f), 0.5f * (sinTheta + cosTheta + 1.0f));
        Quad quad = new Quad(x0, x1, x2, x3);
        ((ShaderProgram)this.mProgram).setTargetRegion(quad);
    }

    private void __constructor__(String string2) {
        this.$$robo$$android_filterpacks_imageproc_RotateFilter$__constructor__(string2);
    }

    public RotateFilter(String string2) {
        super(string2);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_filterpacks_imageproc_RotateFilter$__constructor__(java.lang.String ), this, string2);
    }

    @Override
    public void setupPorts() {
        InvokeDynamicSupport.bootstrap("setupPorts", $$robo$$android_filterpacks_imageproc_RotateFilter$setupPorts(), this);
    }

    public void initProgram(FilterContext filterContext, int n) {
        InvokeDynamicSupport.bootstrap("initProgram", $$robo$$android_filterpacks_imageproc_RotateFilter$initProgram(android.filterfw.core.FilterContext int ), this, filterContext, n);
    }

    @Override
    public void fieldPortValueUpdated(String string2, FilterContext filterContext) {
        InvokeDynamicSupport.bootstrap("fieldPortValueUpdated", $$robo$$android_filterpacks_imageproc_RotateFilter$fieldPortValueUpdated(java.lang.String android.filterfw.core.FilterContext ), this, string2, filterContext);
    }

    @Override
    public void process(FilterContext filterContext) {
        InvokeDynamicSupport.bootstrap("process", $$robo$$android_filterpacks_imageproc_RotateFilter$process(android.filterfw.core.FilterContext ), this, filterContext);
    }

    private void updateParameters() {
        InvokeDynamicSupport.bootstrap("updateParameters", $$robo$$android_filterpacks_imageproc_RotateFilter$updateParameters(), this);
    }

    public /* synthetic */ RotateFilter() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RotateFilter)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

