/*
 * Decompiled with CFR 0.152.
 */
package android.filterpacks.videosrc;

import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.filterfw.core.Filter;
import android.filterfw.core.FilterContext;
import android.filterfw.core.Frame;
import android.filterfw.core.GLFrame;
import android.filterfw.core.GenerateFieldPort;
import android.filterfw.core.GenerateFinalPort;
import android.filterfw.core.MutableFrameFormat;
import android.filterfw.core.ShaderProgram;
import android.filterfw.format.ImageFormat;
import android.graphics.SurfaceTexture;
import android.media.MediaPlayer;
import android.net.Uri;
import android.opengl.Matrix;
import android.util.Log;
import android.view.Surface;
import java.io.IOException;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class MediaSource
extends Filter
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    @GenerateFieldPort(name="sourceUrl", hasDefault=true)
    private String mSourceUrl;
    @GenerateFieldPort(name="sourceAsset", hasDefault=true)
    private AssetFileDescriptor mSourceAsset;
    @GenerateFieldPort(name="context", hasDefault=true)
    private Context mContext;
    @GenerateFieldPort(name="sourceIsUrl", hasDefault=true)
    private boolean mSelectedIsUrl;
    @GenerateFinalPort(name="waitForNewFrame", hasDefault=true)
    private boolean mWaitForNewFrame;
    @GenerateFieldPort(name="loop", hasDefault=true)
    private boolean mLooping;
    @GenerateFieldPort(name="volume", hasDefault=true)
    private float mVolume;
    @GenerateFieldPort(name="orientation", hasDefault=true)
    private int mOrientation;
    private MediaPlayer mMediaPlayer;
    private GLFrame mMediaFrame;
    private SurfaceTexture mSurfaceTexture;
    private ShaderProgram mFrameExtractor;
    private MutableFrameFormat mOutputFormat;
    private int mWidth;
    private int mHeight;
    private static int PREP_TIMEOUT = 100;
    private static int PREP_TIMEOUT_REPEAT = 100;
    private static int NEWFRAME_TIMEOUT = 100;
    private static int NEWFRAME_TIMEOUT_REPEAT = 10;
    private String mFrameShader = "#extension GL_OES_EGL_image_external : require\nprecision mediump float;\nuniform samplerExternalOES tex_sampler_0;\nvarying vec2 v_texcoord;\nvoid main() {\n  gl_FragColor = texture2D(tex_sampler_0, v_texcoord);\n}\n";
    private static float[] mSourceCoords_0;
    private static float[] mSourceCoords_270;
    private static float[] mSourceCoords_180;
    private static float[] mSourceCoords_90;
    private boolean mGotSize;
    private boolean mPrepared;
    private boolean mPlaying;
    private boolean mNewFrameAvailable;
    private boolean mOrientationUpdated;
    private boolean mPaused;
    private boolean mCompleted;
    private boolean mLogVerbose;
    private static String TAG = "MediaSource";
    private MediaPlayer.OnVideoSizeChangedListener onVideoSizeChangedListener;
    private MediaPlayer.OnPreparedListener onPreparedListener;
    private MediaPlayer.OnCompletionListener onCompletionListener;
    private SurfaceTexture.OnFrameAvailableListener onMediaFrameAvailableListener;

    private void $$robo$$android_filterpacks_videosrc_MediaSource$__constructor__(String name) {
        this.mSourceUrl = "";
        this.mSourceAsset = null;
        this.mContext = null;
        this.mSelectedIsUrl = false;
        this.mWaitForNewFrame = true;
        this.mLooping = true;
        this.mVolume = 0.0f;
        this.mOrientation = 0;
        this.mFrameShader = "#extension GL_OES_EGL_image_external : require\nprecision mediump float;\nuniform samplerExternalOES tex_sampler_0;\nvarying vec2 v_texcoord;\nvoid main() {\n  gl_FragColor = texture2D(tex_sampler_0, v_texcoord);\n}\n";
        this.onVideoSizeChangedListener = new MediaPlayer.OnVideoSizeChangedListener(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ MediaSource this$0;

            private void $$robo$$android_filterpacks_videosrc_MediaSource_1$__constructor__(MediaSource this$0) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_filterpacks_videosrc_MediaSource_1$onVideoSizeChanged(MediaPlayer mp, int width, int height) {
                if (this.this$0.mLogVerbose) {
                    Log.v("MediaSource", "MediaPlayer sent dimensions: " + width + " x " + height);
                }
                if (!this.this$0.mGotSize) {
                    if (this.this$0.mOrientation == 0 || this.this$0.mOrientation == 180) {
                        this.this$0.mOutputFormat.setDimensions(width, height);
                    } else {
                        this.this$0.mOutputFormat.setDimensions(height, width);
                    }
                    this.this$0.mWidth = width;
                    this.this$0.mHeight = height;
                } else if (this.this$0.mOutputFormat.getWidth() != width || this.this$0.mOutputFormat.getHeight() != height) {
                    Log.e("MediaSource", "Multiple video size change events received!");
                }
                MediaSource mediaSource = this.this$0;
                synchronized (mediaSource) {
                    this.this$0.mGotSize = true;
                    this.this$0.notify();
                }
            }

            private void __constructor__(MediaSource mediaSource) {
                this.$$robo$$android_filterpacks_videosrc_MediaSource_1$__constructor__(mediaSource);
            }
            {
                this.this$0 = mediaSource;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_filterpacks_videosrc_MediaSource_1$__constructor__(android.filterpacks.videosrc.MediaSource ), this, mediaSource);
            }

            @Override
            public void onVideoSizeChanged(MediaPlayer mediaPlayer, int n, int n2) {
                InvokeDynamicSupport.bootstrap("onVideoSizeChanged", $$robo$$android_filterpacks_videosrc_MediaSource_1$onVideoSizeChanged(android.media.MediaPlayer int int ), this, mediaPlayer, n, n2);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.onPreparedListener = new MediaPlayer.OnPreparedListener(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ MediaSource this$0;

            private void $$robo$$android_filterpacks_videosrc_MediaSource_2$__constructor__(MediaSource this$0) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_filterpacks_videosrc_MediaSource_2$onPrepared(MediaPlayer mp) {
                if (this.this$0.mLogVerbose) {
                    Log.v("MediaSource", "MediaPlayer is prepared");
                }
                MediaSource mediaSource = this.this$0;
                synchronized (mediaSource) {
                    this.this$0.mPrepared = true;
                    this.this$0.notify();
                }
            }

            private void __constructor__(MediaSource mediaSource) {
                this.$$robo$$android_filterpacks_videosrc_MediaSource_2$__constructor__(mediaSource);
            }
            {
                this.this$0 = mediaSource;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_filterpacks_videosrc_MediaSource_2$__constructor__(android.filterpacks.videosrc.MediaSource ), this, mediaSource);
            }

            @Override
            public void onPrepared(MediaPlayer mediaPlayer) {
                InvokeDynamicSupport.bootstrap("onPrepared", $$robo$$android_filterpacks_videosrc_MediaSource_2$onPrepared(android.media.MediaPlayer ), this, mediaPlayer);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.onCompletionListener = new MediaPlayer.OnCompletionListener(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ MediaSource this$0;

            private void $$robo$$android_filterpacks_videosrc_MediaSource_3$__constructor__(MediaSource this$0) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_filterpacks_videosrc_MediaSource_3$onCompletion(MediaPlayer mp) {
                if (this.this$0.mLogVerbose) {
                    Log.v("MediaSource", "MediaPlayer has completed playback");
                }
                MediaSource mediaSource = this.this$0;
                synchronized (mediaSource) {
                    this.this$0.mCompleted = true;
                }
            }

            private void __constructor__(MediaSource mediaSource) {
                this.$$robo$$android_filterpacks_videosrc_MediaSource_3$__constructor__(mediaSource);
            }
            {
                this.this$0 = mediaSource;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_filterpacks_videosrc_MediaSource_3$__constructor__(android.filterpacks.videosrc.MediaSource ), this, mediaSource);
            }

            @Override
            public void onCompletion(MediaPlayer mediaPlayer) {
                InvokeDynamicSupport.bootstrap("onCompletion", $$robo$$android_filterpacks_videosrc_MediaSource_3$onCompletion(android.media.MediaPlayer ), this, mediaPlayer);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.onMediaFrameAvailableListener = new SurfaceTexture.OnFrameAvailableListener(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ MediaSource this$0;

            private void $$robo$$android_filterpacks_videosrc_MediaSource_4$__constructor__(MediaSource this$0) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_filterpacks_videosrc_MediaSource_4$onFrameAvailable(SurfaceTexture surfaceTexture) {
                if (this.this$0.mLogVerbose) {
                    Log.v("MediaSource", "New frame from media player");
                }
                MediaSource mediaSource = this.this$0;
                synchronized (mediaSource) {
                    if (this.this$0.mLogVerbose) {
                        Log.v("MediaSource", "New frame: notify");
                    }
                    this.this$0.mNewFrameAvailable = true;
                    this.this$0.notify();
                    if (this.this$0.mLogVerbose) {
                        Log.v("MediaSource", "New frame: notify done");
                    }
                }
            }

            private void __constructor__(MediaSource mediaSource) {
                this.$$robo$$android_filterpacks_videosrc_MediaSource_4$__constructor__(mediaSource);
            }
            {
                this.this$0 = mediaSource;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_filterpacks_videosrc_MediaSource_4$__constructor__(android.filterpacks.videosrc.MediaSource ), this, mediaSource);
            }

            @Override
            public void onFrameAvailable(SurfaceTexture surfaceTexture) {
                InvokeDynamicSupport.bootstrap("onFrameAvailable", $$robo$$android_filterpacks_videosrc_MediaSource_4$onFrameAvailable(android.graphics.SurfaceTexture ), this, surfaceTexture);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mNewFrameAvailable = false;
        this.mLogVerbose = Log.isLoggable("MediaSource", 2);
    }

    private final void $$robo$$android_filterpacks_videosrc_MediaSource$setupPorts() {
        this.addOutputPort("video", ImageFormat.create(3, 3));
    }

    private final void $$robo$$android_filterpacks_videosrc_MediaSource$createFormats() {
        this.mOutputFormat = ImageFormat.create(3, 3);
    }

    private final void $$robo$$android_filterpacks_videosrc_MediaSource$prepare(FilterContext context) {
        if (this.mLogVerbose) {
            Log.v("MediaSource", "Preparing MediaSource");
        }
        this.mFrameExtractor = new ShaderProgram(context, "#extension GL_OES_EGL_image_external : require\nprecision mediump float;\nuniform samplerExternalOES tex_sampler_0;\nvarying vec2 v_texcoord;\nvoid main() {\n  gl_FragColor = texture2D(tex_sampler_0, v_texcoord);\n}\n");
        this.mFrameExtractor.setSourceRect(0.0f, 1.0f, 1.0f, -1.0f);
        this.createFormats();
    }

    private final void $$robo$$android_filterpacks_videosrc_MediaSource$open(FilterContext context) {
        if (this.mLogVerbose) {
            Log.v("MediaSource", "Opening MediaSource");
            if (this.mSelectedIsUrl) {
                Log.v("MediaSource", "Current URL is " + this.mSourceUrl);
            } else {
                Log.v("MediaSource", "Current source is Asset!");
            }
        }
        this.mMediaFrame = (GLFrame)context.getFrameManager().newBoundFrame(this.mOutputFormat, 104, 0L);
        this.mSurfaceTexture = new SurfaceTexture(this.mMediaFrame.getTextureId());
        if (!this.setupMediaPlayer(this.mSelectedIsUrl)) {
            throw new RuntimeException("Error setting up MediaPlayer!");
        }
    }

    private final void $$robo$$android_filterpacks_videosrc_MediaSource$process(FilterContext context) {
        int waitCount;
        if (this.mLogVerbose) {
            Log.v("MediaSource", "Processing new frame");
        }
        if (this.mMediaPlayer == null) {
            throw new NullPointerException("Unexpected null media player!");
        }
        if (this.mCompleted) {
            this.closeOutputPort("video");
            return;
        }
        if (!this.mPlaying) {
            waitCount = 0;
            if (this.mLogVerbose) {
                Log.v("MediaSource", "Waiting for preparation to complete");
            }
            while (!this.mGotSize || !this.mPrepared) {
                try {
                    this.wait(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (this.mCompleted) {
                    this.closeOutputPort("video");
                    return;
                }
                if (++waitCount != 100) continue;
                this.mMediaPlayer.release();
                throw new RuntimeException("MediaPlayer timed out while preparing!");
            }
            if (this.mLogVerbose) {
                Log.v("MediaSource", "Starting playback");
            }
            this.mMediaPlayer.start();
        }
        if (!this.mPaused || !this.mPlaying) {
            if (this.mWaitForNewFrame) {
                if (this.mLogVerbose) {
                    Log.v("MediaSource", "Waiting for new frame");
                }
                waitCount = 0;
                while (!this.mNewFrameAvailable) {
                    block27: {
                        if (waitCount == 10) {
                            if (this.mCompleted) {
                                this.closeOutputPort("video");
                                return;
                            }
                            throw new RuntimeException("Timeout waiting for new frame!");
                        }
                        try {
                            this.wait(100L);
                        }
                        catch (InterruptedException e) {
                            if (!this.mLogVerbose) break block27;
                            Log.v("MediaSource", "interrupted");
                        }
                    }
                    ++waitCount;
                }
                this.mNewFrameAvailable = false;
                if (this.mLogVerbose) {
                    Log.v("MediaSource", "Got new frame");
                }
            }
            this.mSurfaceTexture.updateTexImage();
            this.mOrientationUpdated = true;
        }
        if (this.mOrientationUpdated) {
            float[] surfaceTransform = new float[16];
            this.mSurfaceTexture.getTransformMatrix(surfaceTransform);
            float[] sourceCoords = new float[16];
            switch (this.mOrientation) {
                default: {
                    Matrix.multiplyMM(sourceCoords, 0, surfaceTransform, 0, mSourceCoords_0, 0);
                    break;
                }
                case 90: {
                    Matrix.multiplyMM(sourceCoords, 0, surfaceTransform, 0, mSourceCoords_90, 0);
                    break;
                }
                case 180: {
                    Matrix.multiplyMM(sourceCoords, 0, surfaceTransform, 0, mSourceCoords_180, 0);
                    break;
                }
                case 270: {
                    Matrix.multiplyMM(sourceCoords, 0, surfaceTransform, 0, mSourceCoords_270, 0);
                }
            }
            if (this.mLogVerbose) {
                Log.v("MediaSource", "OrientationHint = " + this.mOrientation);
                String temp = String.format("SetSourceRegion: %.2f, %.2f, %.2f, %.2f, %.2f, %.2f, %.2f, %.2f", Float.valueOf(sourceCoords[4]), Float.valueOf(sourceCoords[5]), Float.valueOf(sourceCoords[0]), Float.valueOf(sourceCoords[1]), Float.valueOf(sourceCoords[12]), Float.valueOf(sourceCoords[13]), Float.valueOf(sourceCoords[8]), Float.valueOf(sourceCoords[9]));
                Log.v("MediaSource", temp);
            }
            this.mFrameExtractor.setSourceRegion(sourceCoords[4], sourceCoords[5], sourceCoords[0], sourceCoords[1], sourceCoords[12], sourceCoords[13], sourceCoords[8], sourceCoords[9]);
            this.mOrientationUpdated = false;
        }
        Frame output = context.getFrameManager().newFrame(this.mOutputFormat);
        this.mFrameExtractor.process(this.mMediaFrame, output);
        long timestamp = this.mSurfaceTexture.getTimestamp();
        if (this.mLogVerbose) {
            Log.v("MediaSource", "Timestamp: " + (double)timestamp / 1.0E9 + " s");
        }
        output.setTimestamp(timestamp);
        this.pushOutput("video", output);
        output.release();
        this.mPlaying = true;
    }

    private final void $$robo$$android_filterpacks_videosrc_MediaSource$close(FilterContext context) {
        if (this.mMediaPlayer.isPlaying()) {
            this.mMediaPlayer.stop();
        }
        this.mPrepared = false;
        this.mGotSize = false;
        this.mPlaying = false;
        this.mPaused = false;
        this.mCompleted = false;
        this.mNewFrameAvailable = false;
        this.mMediaPlayer.release();
        this.mMediaPlayer = null;
        this.mSurfaceTexture.release();
        this.mSurfaceTexture = null;
        if (this.mLogVerbose) {
            Log.v("MediaSource", "MediaSource closed");
        }
    }

    private final void $$robo$$android_filterpacks_videosrc_MediaSource$tearDown(FilterContext context) {
        if (this.mMediaFrame != null) {
            this.mMediaFrame.release();
        }
    }

    private final void $$robo$$android_filterpacks_videosrc_MediaSource$fieldPortValueUpdated(String name, FilterContext context) {
        if (this.mLogVerbose) {
            Log.v("MediaSource", "Parameter update");
        }
        if (name.equals("sourceUrl")) {
            if (this.isOpen()) {
                if (this.mLogVerbose) {
                    Log.v("MediaSource", "Opening new source URL");
                }
                if (this.mSelectedIsUrl) {
                    this.setupMediaPlayer(this.mSelectedIsUrl);
                }
            }
        } else if (name.equals("sourceAsset")) {
            if (this.isOpen()) {
                if (this.mLogVerbose) {
                    Log.v("MediaSource", "Opening new source FD");
                }
                if (!this.mSelectedIsUrl) {
                    this.setupMediaPlayer(this.mSelectedIsUrl);
                }
            }
        } else if (name.equals("loop")) {
            if (this.isOpen()) {
                this.mMediaPlayer.setLooping(this.mLooping);
            }
        } else if (name.equals("sourceIsUrl")) {
            if (this.isOpen()) {
                if (this.mSelectedIsUrl) {
                    if (this.mLogVerbose) {
                        Log.v("MediaSource", "Opening new source URL");
                    }
                } else if (this.mLogVerbose) {
                    Log.v("MediaSource", "Opening new source Asset");
                }
                this.setupMediaPlayer(this.mSelectedIsUrl);
            }
        } else if (name.equals("volume")) {
            if (this.isOpen()) {
                this.mMediaPlayer.setVolume(this.mVolume, this.mVolume);
            }
        } else if (name.equals("orientation") && this.mGotSize) {
            if (this.mOrientation == 0 || this.mOrientation == 180) {
                this.mOutputFormat.setDimensions(this.mWidth, this.mHeight);
            } else {
                this.mOutputFormat.setDimensions(this.mHeight, this.mWidth);
            }
            this.mOrientationUpdated = true;
        }
    }

    private final synchronized void $$robo$$android_filterpacks_videosrc_MediaSource$pauseVideo(boolean pauseState) {
        if (this.isOpen()) {
            if (pauseState && !this.mPaused) {
                this.mMediaPlayer.pause();
            } else if (!pauseState && this.mPaused) {
                this.mMediaPlayer.start();
            }
        }
        this.mPaused = pauseState;
    }

    private final synchronized boolean $$robo$$android_filterpacks_videosrc_MediaSource$setupMediaPlayer(boolean useUrl) {
        this.mPrepared = false;
        this.mGotSize = false;
        this.mPlaying = false;
        this.mPaused = false;
        this.mCompleted = false;
        this.mNewFrameAvailable = false;
        if (this.mLogVerbose) {
            Log.v("MediaSource", "Setting up playback.");
        }
        if (this.mMediaPlayer != null) {
            if (this.mLogVerbose) {
                Log.v("MediaSource", "Resetting existing MediaPlayer.");
            }
            this.mMediaPlayer.reset();
        } else {
            if (this.mLogVerbose) {
                Log.v("MediaSource", "Creating new MediaPlayer.");
            }
            this.mMediaPlayer = new MediaPlayer();
        }
        if (this.mMediaPlayer == null) {
            throw new RuntimeException("Unable to create a MediaPlayer!");
        }
        try {
            if (useUrl) {
                if (this.mLogVerbose) {
                    Log.v("MediaSource", "Setting MediaPlayer source to URI " + this.mSourceUrl);
                }
                if (this.mContext == null) {
                    this.mMediaPlayer.setDataSource(this.mSourceUrl);
                } else {
                    this.mMediaPlayer.setDataSource(this.mContext, Uri.parse(this.mSourceUrl.toString()));
                }
            } else {
                if (this.mLogVerbose) {
                    Log.v("MediaSource", "Setting MediaPlayer source to asset " + this.mSourceAsset);
                }
                this.mMediaPlayer.setDataSource(this.mSourceAsset.getFileDescriptor(), this.mSourceAsset.getStartOffset(), this.mSourceAsset.getLength());
            }
        }
        catch (IOException e) {
            this.mMediaPlayer.release();
            this.mMediaPlayer = null;
            if (useUrl) {
                throw new RuntimeException(String.format("Unable to set MediaPlayer to URL %s!", this.mSourceUrl), e);
            }
            throw new RuntimeException(String.format("Unable to set MediaPlayer to asset %s!", this.mSourceAsset), e);
        }
        catch (IllegalArgumentException e) {
            this.mMediaPlayer.release();
            this.mMediaPlayer = null;
            if (useUrl) {
                throw new RuntimeException(String.format("Unable to set MediaPlayer to URL %s!", this.mSourceUrl), e);
            }
            throw new RuntimeException(String.format("Unable to set MediaPlayer to asset %s!", this.mSourceAsset), e);
        }
        this.mMediaPlayer.setLooping(this.mLooping);
        this.mMediaPlayer.setVolume(this.mVolume, this.mVolume);
        Surface surface = new Surface(this.mSurfaceTexture);
        this.mMediaPlayer.setSurface(surface);
        surface.release();
        this.mMediaPlayer.setOnVideoSizeChangedListener(this.onVideoSizeChangedListener);
        this.mMediaPlayer.setOnPreparedListener(this.onPreparedListener);
        this.mMediaPlayer.setOnCompletionListener(this.onCompletionListener);
        this.mSurfaceTexture.setOnFrameAvailableListener(this.onMediaFrameAvailableListener);
        if (this.mLogVerbose) {
            Log.v("MediaSource", "Preparing MediaPlayer.");
        }
        this.mMediaPlayer.prepareAsync();
        return true;
    }

    static void __staticInitializer__() {
        mSourceCoords_0 = new float[]{1.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f};
        mSourceCoords_270 = new float[]{0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f};
        mSourceCoords_180 = new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 1.0f};
        mSourceCoords_90 = new float[]{1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f};
    }

    private void __constructor__(String string2) {
        this.$$robo$$android_filterpacks_videosrc_MediaSource$__constructor__(string2);
    }

    public MediaSource(String string2) {
        super(string2);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_filterpacks_videosrc_MediaSource$__constructor__(java.lang.String ), this, string2);
    }

    @Override
    public void setupPorts() {
        InvokeDynamicSupport.bootstrap("setupPorts", $$robo$$android_filterpacks_videosrc_MediaSource$setupPorts(), this);
    }

    private void createFormats() {
        InvokeDynamicSupport.bootstrap("createFormats", $$robo$$android_filterpacks_videosrc_MediaSource$createFormats(), this);
    }

    @Override
    protected void prepare(FilterContext filterContext) {
        InvokeDynamicSupport.bootstrap("prepare", $$robo$$android_filterpacks_videosrc_MediaSource$prepare(android.filterfw.core.FilterContext ), this, filterContext);
    }

    @Override
    public void open(FilterContext filterContext) {
        InvokeDynamicSupport.bootstrap("open", $$robo$$android_filterpacks_videosrc_MediaSource$open(android.filterfw.core.FilterContext ), this, filterContext);
    }

    @Override
    public void process(FilterContext filterContext) {
        InvokeDynamicSupport.bootstrap("process", $$robo$$android_filterpacks_videosrc_MediaSource$process(android.filterfw.core.FilterContext ), this, filterContext);
    }

    @Override
    public void close(FilterContext filterContext) {
        InvokeDynamicSupport.bootstrap("close", $$robo$$android_filterpacks_videosrc_MediaSource$close(android.filterfw.core.FilterContext ), this, filterContext);
    }

    @Override
    public void tearDown(FilterContext filterContext) {
        InvokeDynamicSupport.bootstrap("tearDown", $$robo$$android_filterpacks_videosrc_MediaSource$tearDown(android.filterfw.core.FilterContext ), this, filterContext);
    }

    @Override
    public void fieldPortValueUpdated(String string2, FilterContext filterContext) {
        InvokeDynamicSupport.bootstrap("fieldPortValueUpdated", $$robo$$android_filterpacks_videosrc_MediaSource$fieldPortValueUpdated(java.lang.String android.filterfw.core.FilterContext ), this, string2, filterContext);
    }

    public synchronized void pauseVideo(boolean bl) {
        InvokeDynamicSupport.bootstrap("pauseVideo", $$robo$$android_filterpacks_videosrc_MediaSource$pauseVideo(boolean ), this, bl);
    }

    private synchronized boolean setupMediaPlayer(boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("setupMediaPlayer", $$robo$$android_filterpacks_videosrc_MediaSource$setupMediaPlayer(boolean ), this, bl);
    }

    static {
        RobolectricInternals.classInitializing(MediaSource.class);
    }

    public /* synthetic */ MediaSource() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MediaSource)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

