/*
 * Decompiled with CFR 0.152.
 */
package android.filterpacks.videosrc;

import android.filterfw.core.Filter;
import android.filterfw.core.FilterContext;
import android.filterfw.core.Frame;
import android.filterfw.core.GLEnvironment;
import android.filterfw.core.GLFrame;
import android.filterfw.core.GenerateFieldPort;
import android.filterfw.core.GenerateFinalPort;
import android.filterfw.core.MutableFrameFormat;
import android.filterfw.core.ShaderProgram;
import android.filterfw.format.ImageFormat;
import android.filterfw.geometry.Point;
import android.filterfw.geometry.Quad;
import android.graphics.SurfaceTexture;
import android.util.Log;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class SurfaceTextureTarget
extends Filter
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private int RENDERMODE_STRETCH = 0;
    private int RENDERMODE_FIT = 1;
    private int RENDERMODE_FILL_CROP = 2;
    private int RENDERMODE_CUSTOMIZE = 3;
    @GenerateFinalPort(name="surfaceTexture")
    private SurfaceTexture mSurfaceTexture;
    @GenerateFinalPort(name="width")
    private int mScreenWidth;
    @GenerateFinalPort(name="height")
    private int mScreenHeight;
    @GenerateFieldPort(name="renderMode", hasDefault=true)
    private String mRenderModeString;
    @GenerateFieldPort(name="sourceQuad", hasDefault=true)
    private Quad mSourceQuad;
    @GenerateFieldPort(name="targetQuad", hasDefault=true)
    private Quad mTargetQuad;
    private int mSurfaceId;
    private ShaderProgram mProgram;
    private GLFrame mScreen;
    private int mRenderMode;
    private float mAspectRatio;
    private boolean mLogVerbose;
    private static String TAG = "SurfaceTextureTarget";

    private void $$robo$$android_filterpacks_videosrc_SurfaceTextureTarget$__constructor__(String name) {
        this.RENDERMODE_STRETCH = 0;
        this.RENDERMODE_FIT = 1;
        this.RENDERMODE_FILL_CROP = 2;
        this.RENDERMODE_CUSTOMIZE = 3;
        this.mSourceQuad = new Quad(new Point(0.0f, 1.0f), new Point(1.0f, 1.0f), new Point(0.0f, 0.0f), new Point(1.0f, 0.0f));
        this.mTargetQuad = new Quad(new Point(0.0f, 0.0f), new Point(1.0f, 0.0f), new Point(0.0f, 1.0f), new Point(1.0f, 1.0f));
        this.mRenderMode = 1;
        this.mAspectRatio = 1.0f;
        this.mLogVerbose = Log.isLoggable("SurfaceTextureTarget", 2);
    }

    private final synchronized void $$robo$$android_filterpacks_videosrc_SurfaceTextureTarget$setupPorts() {
        if (this.mSurfaceTexture == null) {
            throw new RuntimeException("Null SurfaceTexture passed to SurfaceTextureTarget");
        }
        this.addMaskedInputPort("frame", ImageFormat.create(3));
    }

    private final void $$robo$$android_filterpacks_videosrc_SurfaceTextureTarget$updateRenderMode() {
        if (this.mLogVerbose) {
            Log.v("SurfaceTextureTarget", "updateRenderMode. Thread: " + Thread.currentThread());
        }
        if (this.mRenderModeString != null) {
            if (this.mRenderModeString.equals("stretch")) {
                this.mRenderMode = 0;
            } else if (this.mRenderModeString.equals("fit")) {
                this.mRenderMode = 1;
            } else if (this.mRenderModeString.equals("fill_crop")) {
                this.mRenderMode = 2;
            } else if (this.mRenderModeString.equals("customize")) {
                this.mRenderMode = 3;
            } else {
                throw new RuntimeException("Unknown render mode '" + this.mRenderModeString + "'!");
            }
        }
        this.updateTargetRect();
    }

    private final void $$robo$$android_filterpacks_videosrc_SurfaceTextureTarget$prepare(FilterContext context) {
        if (this.mLogVerbose) {
            Log.v("SurfaceTextureTarget", "Prepare. Thread: " + Thread.currentThread());
        }
        this.mProgram = ShaderProgram.createIdentity(context);
        this.mProgram.setSourceRect(0.0f, 1.0f, 1.0f, -1.0f);
        this.mProgram.setClearColor(0.0f, 0.0f, 0.0f);
        this.updateRenderMode();
        MutableFrameFormat screenFormat = new MutableFrameFormat(2, 3);
        screenFormat.setBytesPerSample(4);
        screenFormat.setDimensions(this.mScreenWidth, this.mScreenHeight);
        this.mScreen = (GLFrame)context.getFrameManager().newBoundFrame(screenFormat, 101, 0L);
    }

    private final synchronized void $$robo$$android_filterpacks_videosrc_SurfaceTextureTarget$open(FilterContext context) {
        if (this.mSurfaceTexture == null) {
            Log.e("SurfaceTextureTarget", "SurfaceTexture is null!!");
            throw new RuntimeException("Could not register SurfaceTexture: " + this.mSurfaceTexture);
        }
        this.mSurfaceId = context.getGLEnvironment().registerSurfaceTexture(this.mSurfaceTexture, this.mScreenWidth, this.mScreenHeight);
        if (this.mSurfaceId <= 0) {
            throw new RuntimeException("Could not register SurfaceTexture: " + this.mSurfaceTexture);
        }
    }

    private final synchronized void $$robo$$android_filterpacks_videosrc_SurfaceTextureTarget$close(FilterContext context) {
        if (this.mSurfaceId > 0) {
            context.getGLEnvironment().unregisterSurfaceId(this.mSurfaceId);
            this.mSurfaceId = -1;
        }
    }

    private final synchronized void $$robo$$android_filterpacks_videosrc_SurfaceTextureTarget$disconnect(FilterContext context) {
        if (this.mLogVerbose) {
            Log.v("SurfaceTextureTarget", "disconnect");
        }
        if (this.mSurfaceTexture == null) {
            Log.d("SurfaceTextureTarget", "SurfaceTexture is already null. Nothing to disconnect.");
            return;
        }
        this.mSurfaceTexture = null;
        if (this.mSurfaceId > 0) {
            context.getGLEnvironment().unregisterSurfaceId(this.mSurfaceId);
            this.mSurfaceId = -1;
        }
    }

    private final synchronized void $$robo$$android_filterpacks_videosrc_SurfaceTextureTarget$process(FilterContext context) {
        if (this.mSurfaceId <= 0) {
            return;
        }
        GLEnvironment glEnv = context.getGLEnvironment();
        Frame input = this.pullInput("frame");
        boolean createdFrame = false;
        float currentAspectRatio = (float)input.getFormat().getWidth() / (float)input.getFormat().getHeight();
        if (currentAspectRatio != this.mAspectRatio) {
            if (this.mLogVerbose) {
                Log.v("SurfaceTextureTarget", "Process. New aspect ratio: " + currentAspectRatio + ", previously: " + this.mAspectRatio + ". Thread: " + Thread.currentThread());
            }
            this.mAspectRatio = currentAspectRatio;
            this.updateTargetRect();
        }
        Frame gpuFrame = null;
        int target = input.getFormat().getTarget();
        if (target != 3) {
            gpuFrame = context.getFrameManager().duplicateFrameToTarget(input, 3);
            createdFrame = true;
        } else {
            gpuFrame = input;
        }
        glEnv.activateSurfaceWithId(this.mSurfaceId);
        this.mProgram.process(gpuFrame, (Frame)this.mScreen);
        glEnv.setSurfaceTimestamp(input.getTimestamp());
        glEnv.swapBuffers();
        if (createdFrame) {
            gpuFrame.release();
        }
    }

    private final void $$robo$$android_filterpacks_videosrc_SurfaceTextureTarget$fieldPortValueUpdated(String name, FilterContext context) {
        if (this.mLogVerbose) {
            Log.v("SurfaceTextureTarget", "FPVU. Thread: " + Thread.currentThread());
        }
        this.updateRenderMode();
    }

    private final void $$robo$$android_filterpacks_videosrc_SurfaceTextureTarget$tearDown(FilterContext context) {
        if (this.mScreen != null) {
            this.mScreen.release();
        }
    }

    private final void $$robo$$android_filterpacks_videosrc_SurfaceTextureTarget$updateTargetRect() {
        if (this.mLogVerbose) {
            Log.v("SurfaceTextureTarget", "updateTargetRect. Thread: " + Thread.currentThread());
        }
        if (this.mScreenWidth > 0 && this.mScreenHeight > 0 && this.mProgram != null) {
            float screenAspectRatio = (float)this.mScreenWidth / (float)this.mScreenHeight;
            float relativeAspectRatio = screenAspectRatio / this.mAspectRatio;
            if (this.mLogVerbose) {
                Log.v("SurfaceTextureTarget", "UTR. screen w = " + (float)this.mScreenWidth + " x screen h = " + (float)this.mScreenHeight + " Screen AR: " + screenAspectRatio + ", frame AR: " + this.mAspectRatio + ", relative AR: " + relativeAspectRatio);
            }
            if (relativeAspectRatio == 1.0f && this.mRenderMode != 3) {
                this.mProgram.setTargetRect(0.0f, 0.0f, 1.0f, 1.0f);
                this.mProgram.setClearsOutput(false);
            } else {
                switch (this.mRenderMode) {
                    case 0: {
                        this.mTargetQuad.p0.set(0.0f, 0.0f);
                        this.mTargetQuad.p1.set(1.0f, 0.0f);
                        this.mTargetQuad.p2.set(0.0f, 1.0f);
                        this.mTargetQuad.p3.set(1.0f, 1.0f);
                        this.mProgram.setClearsOutput(false);
                        break;
                    }
                    case 1: {
                        if (relativeAspectRatio > 1.0f) {
                            this.mTargetQuad.p0.set(0.5f - 0.5f / relativeAspectRatio, 0.0f);
                            this.mTargetQuad.p1.set(0.5f + 0.5f / relativeAspectRatio, 0.0f);
                            this.mTargetQuad.p2.set(0.5f - 0.5f / relativeAspectRatio, 1.0f);
                            this.mTargetQuad.p3.set(0.5f + 0.5f / relativeAspectRatio, 1.0f);
                        } else {
                            this.mTargetQuad.p0.set(0.0f, 0.5f - 0.5f * relativeAspectRatio);
                            this.mTargetQuad.p1.set(1.0f, 0.5f - 0.5f * relativeAspectRatio);
                            this.mTargetQuad.p2.set(0.0f, 0.5f + 0.5f * relativeAspectRatio);
                            this.mTargetQuad.p3.set(1.0f, 0.5f + 0.5f * relativeAspectRatio);
                        }
                        this.mProgram.setClearsOutput(true);
                        break;
                    }
                    case 2: {
                        if (relativeAspectRatio > 1.0f) {
                            this.mTargetQuad.p0.set(0.0f, 0.5f - 0.5f * relativeAspectRatio);
                            this.mTargetQuad.p1.set(1.0f, 0.5f - 0.5f * relativeAspectRatio);
                            this.mTargetQuad.p2.set(0.0f, 0.5f + 0.5f * relativeAspectRatio);
                            this.mTargetQuad.p3.set(1.0f, 0.5f + 0.5f * relativeAspectRatio);
                        } else {
                            this.mTargetQuad.p0.set(0.5f - 0.5f / relativeAspectRatio, 0.0f);
                            this.mTargetQuad.p1.set(0.5f + 0.5f / relativeAspectRatio, 0.0f);
                            this.mTargetQuad.p2.set(0.5f - 0.5f / relativeAspectRatio, 1.0f);
                            this.mTargetQuad.p3.set(0.5f + 0.5f / relativeAspectRatio, 1.0f);
                        }
                        this.mProgram.setClearsOutput(true);
                        break;
                    }
                    case 3: {
                        this.mProgram.setSourceRegion(this.mSourceQuad);
                    }
                }
                if (this.mLogVerbose) {
                    Log.v("SurfaceTextureTarget", "UTR. quad: " + this.mTargetQuad);
                }
                this.mProgram.setTargetRegion(this.mTargetQuad);
            }
        }
    }

    private void __constructor__(String string2) {
        this.$$robo$$android_filterpacks_videosrc_SurfaceTextureTarget$__constructor__(string2);
    }

    public SurfaceTextureTarget(String string2) {
        super(string2);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_filterpacks_videosrc_SurfaceTextureTarget$__constructor__(java.lang.String ), this, string2);
    }

    @Override
    public synchronized void setupPorts() {
        InvokeDynamicSupport.bootstrap("setupPorts", $$robo$$android_filterpacks_videosrc_SurfaceTextureTarget$setupPorts(), this);
    }

    public void updateRenderMode() {
        InvokeDynamicSupport.bootstrap("updateRenderMode", $$robo$$android_filterpacks_videosrc_SurfaceTextureTarget$updateRenderMode(), this);
    }

    @Override
    public void prepare(FilterContext filterContext) {
        InvokeDynamicSupport.bootstrap("prepare", $$robo$$android_filterpacks_videosrc_SurfaceTextureTarget$prepare(android.filterfw.core.FilterContext ), this, filterContext);
    }

    @Override
    public synchronized void open(FilterContext filterContext) {
        InvokeDynamicSupport.bootstrap("open", $$robo$$android_filterpacks_videosrc_SurfaceTextureTarget$open(android.filterfw.core.FilterContext ), this, filterContext);
    }

    @Override
    public synchronized void close(FilterContext filterContext) {
        InvokeDynamicSupport.bootstrap("close", $$robo$$android_filterpacks_videosrc_SurfaceTextureTarget$close(android.filterfw.core.FilterContext ), this, filterContext);
    }

    public synchronized void disconnect(FilterContext filterContext) {
        InvokeDynamicSupport.bootstrap("disconnect", $$robo$$android_filterpacks_videosrc_SurfaceTextureTarget$disconnect(android.filterfw.core.FilterContext ), this, filterContext);
    }

    @Override
    public synchronized void process(FilterContext filterContext) {
        InvokeDynamicSupport.bootstrap("process", $$robo$$android_filterpacks_videosrc_SurfaceTextureTarget$process(android.filterfw.core.FilterContext ), this, filterContext);
    }

    @Override
    public void fieldPortValueUpdated(String string2, FilterContext filterContext) {
        InvokeDynamicSupport.bootstrap("fieldPortValueUpdated", $$robo$$android_filterpacks_videosrc_SurfaceTextureTarget$fieldPortValueUpdated(java.lang.String android.filterfw.core.FilterContext ), this, string2, filterContext);
    }

    @Override
    public void tearDown(FilterContext filterContext) {
        InvokeDynamicSupport.bootstrap("tearDown", $$robo$$android_filterpacks_videosrc_SurfaceTextureTarget$tearDown(android.filterfw.core.FilterContext ), this, filterContext);
    }

    private void updateTargetRect() {
        InvokeDynamicSupport.bootstrap("updateTargetRect", $$robo$$android_filterpacks_videosrc_SurfaceTextureTarget$updateTargetRect(), this);
    }

    public /* synthetic */ SurfaceTextureTarget() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SurfaceTextureTarget)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

