/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.content.res.AssetManager;
import android.content.res.FontResourcesParser;
import android.graphics.FontFamily;
import android.graphics.FontListParser;
import android.graphics.fonts.FontVariationAxis;
import android.net.Uri;
import android.provider.FontRequest;
import android.provider.FontsContract;
import android.text.FontConfig;
import android.util.Base64;
import android.util.Log;
import android.util.LongSparseArray;
import android.util.LruCache;
import android.util.SparseArray;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.util.Preconditions;
import com.google.errorprone.annotations.DoNotMock;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;
import org.xmlpull.v1.XmlPullParserException;

public class Typeface
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG;
    public static Typeface DEFAULT;
    public static Typeface DEFAULT_BOLD;
    public static Typeface SANS_SERIF;
    public static Typeface SERIF;
    public static Typeface MONOSPACE;
    static Typeface[] sDefaults;
    private static LongSparseArray<SparseArray<Typeface>> sTypefaceCache;
    @GuardedBy(value="sLock")
    private static LruCache<String, Typeface> sDynamicTypefaceCache;
    static Typeface sDefaultTypeface;
    static Map<String, Typeface> sSystemFontMap;
    static FontFamily[] sFallbackFonts;
    private static Object sLock;
    static String FONTS_CONFIG = "fonts.xml";
    public long native_instance;
    public static int NORMAL = 0;
    public static int BOLD = 1;
    public static int ITALIC = 2;
    public static int BOLD_ITALIC = 3;
    private int mStyle;
    private int mWeight;
    public static int RESOLVE_BY_FONT_TABLE = -1;
    private static int STYLE_NORMAL = 0;
    private static int STYLE_ITALIC = 1;
    private int[] mSupportedAxes;
    private static int[] EMPTY_AXES;

    private static final void $$robo$$android_graphics_Typeface$setDefault(Typeface t) {
        sDefaultTypeface = t;
        Typeface.nativeSetDefault(t.native_instance);
    }

    private final int $$robo$$android_graphics_Typeface$getStyle() {
        return this.mStyle;
    }

    private final boolean $$robo$$android_graphics_Typeface$isBold() {
        return (this.mStyle & 1) != 0;
    }

    private final boolean $$robo$$android_graphics_Typeface$isItalic() {
        return (this.mStyle & 2) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Typeface $$robo$$android_graphics_Typeface$createFromResources(AssetManager mgr, String path, int cookie) {
        if (sFallbackFonts != null) {
            LruCache<String, Typeface> lruCache = sDynamicTypefaceCache;
            synchronized (lruCache) {
                String key = Builder.createAssetUid(mgr, path, 0, null, -1, -1);
                Typeface typeface = sDynamicTypefaceCache.get(key);
                if (typeface != null) {
                    return typeface;
                }
                FontFamily fontFamily = new FontFamily();
                if (fontFamily.addFontFromAssetManager(mgr, path, cookie, false, 0, -1, -1, null)) {
                    if (!fontFamily.freeze()) {
                        return null;
                    }
                    FontFamily[] families = new FontFamily[]{fontFamily};
                    typeface = Typeface.createFromFamiliesWithDefault(families, -1, -1);
                    sDynamicTypefaceCache.put(key, typeface);
                    return typeface;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Typeface $$robo$$android_graphics_Typeface$createFromResources(FontResourcesParser.FamilyResourceEntry entry, AssetManager mgr, String path) {
        if (sFallbackFonts != null) {
            if (entry instanceof FontResourcesParser.ProviderResourceEntry) {
                FontRequest request;
                Typeface typeface;
                FontResourcesParser.ProviderResourceEntry providerEntry = (FontResourcesParser.ProviderResourceEntry)entry;
                List<List<String>> givenCerts = providerEntry.getCerts();
                ArrayList<List<byte[]>> certs = new ArrayList<List<byte[]>>();
                if (givenCerts != null) {
                    for (int i = 0; i < givenCerts.size(); ++i) {
                        List<String> certSet = givenCerts.get(i);
                        ArrayList<byte[]> byteArraySet = new ArrayList<byte[]>();
                        for (int j = 0; j < certSet.size(); ++j) {
                            byteArraySet.add(Base64.decode(certSet.get(j), 0));
                        }
                        certs.add(byteArraySet);
                    }
                }
                return (typeface = FontsContract.getFontSync(request = new FontRequest(providerEntry.getAuthority(), providerEntry.getPackage(), providerEntry.getQuery(), certs))) == null ? DEFAULT : typeface;
            }
            Typeface typeface = Typeface.findFromCache(mgr, path);
            if (typeface != null) {
                return typeface;
            }
            FontResourcesParser.FontFamilyFilesResourceEntry filesEntry = (FontResourcesParser.FontFamilyFilesResourceEntry)entry;
            FontFamily fontFamily = new FontFamily();
            for (FontResourcesParser.FontFileResourceEntry fontFile : filesEntry.getEntries()) {
                if (fontFamily.addFontFromAssetManager(mgr, fontFile.getFileName(), 0, false, 0, fontFile.getWeight(), fontFile.getItalic(), null)) continue;
                return null;
            }
            if (!fontFamily.freeze()) {
                return null;
            }
            FontFamily[] familyChain = new FontFamily[]{fontFamily};
            typeface = Typeface.createFromFamiliesWithDefault(familyChain, -1, -1);
            LruCache<String, Typeface> lruCache = sDynamicTypefaceCache;
            synchronized (lruCache) {
                String key = Builder.createAssetUid(mgr, path, 0, null, -1, -1);
                sDynamicTypefaceCache.put(key, typeface);
            }
            return typeface;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Typeface $$robo$$android_graphics_Typeface$findFromCache(AssetManager mgr, String path) {
        LruCache<String, Typeface> lruCache = sDynamicTypefaceCache;
        synchronized (lruCache) {
            String key = Builder.createAssetUid(mgr, path, 0, null, -1, -1);
            Typeface typeface = sDynamicTypefaceCache.get(key);
            if (typeface != null) {
                return typeface;
            }
        }
        return null;
    }

    private static final Typeface $$robo$$android_graphics_Typeface$create(String familyName, int style2) {
        if (sSystemFontMap != null) {
            return Typeface.create(sSystemFontMap.get(familyName), style2);
        }
        return null;
    }

    private static final Typeface $$robo$$android_graphics_Typeface$create(Typeface family, int style2) {
        Typeface typeface;
        SparseArray<Typeface> styles;
        if (style2 < 0 || style2 > 3) {
            style2 = 0;
        }
        long ni = 0L;
        if (family != null) {
            if (family.mStyle == style2) {
                return family;
            }
            ni = family.native_instance;
        }
        if ((styles = sTypefaceCache.get(ni)) != null && (typeface = styles.get(style2)) != null) {
            return typeface;
        }
        typeface = new Typeface(Typeface.nativeCreateFromTypeface(ni, style2));
        if (styles == null) {
            styles = new SparseArray(4);
            sTypefaceCache.put(ni, styles);
        }
        styles.put(style2, typeface);
        return typeface;
    }

    private static final Typeface $$robo$$android_graphics_Typeface$createFromTypefaceWithVariation(Typeface family, List<FontVariationAxis> axes) {
        long ni = family == null ? 0L : family.native_instance;
        return new Typeface(Typeface.nativeCreateFromTypefaceWithVariation(ni, axes));
    }

    private static final Typeface $$robo$$android_graphics_Typeface$defaultFromStyle(int style2) {
        return sDefaults[style2];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Typeface $$robo$$android_graphics_Typeface$createFromAsset(AssetManager mgr, String path) {
        if (path == null) {
            throw new NullPointerException();
        }
        if (sFallbackFonts != null) {
            Object object = sLock;
            synchronized (object) {
                Typeface typeface = new Builder(mgr, path).build();
                if (typeface != null) {
                    return typeface;
                }
                String key = Builder.createAssetUid(mgr, path, 0, null, -1, -1);
                typeface = sDynamicTypefaceCache.get(key);
                if (typeface != null) {
                    return typeface;
                }
                FontFamily fontFamily = new FontFamily();
                if (fontFamily.addFontFromAssetManager(mgr, path, 0, true, 0, -1, -1, null)) {
                    fontFamily.allowUnsupportedFont();
                    fontFamily.freeze();
                    FontFamily[] families = new FontFamily[]{fontFamily};
                    typeface = Typeface.createFromFamiliesWithDefault(families, -1, -1);
                    sDynamicTypefaceCache.put(key, typeface);
                    return typeface;
                }
                fontFamily.abortCreation();
            }
        }
        throw new RuntimeException("Font asset not found " + path);
    }

    private static final String $$robo$$android_graphics_Typeface$createProviderUid(String authority, String query) {
        StringBuilder builder = new StringBuilder();
        builder.append("provider:");
        builder.append(authority);
        builder.append("-");
        builder.append(query);
        return builder.toString();
    }

    private static final Typeface $$robo$$android_graphics_Typeface$createFromFile(File path) {
        return Typeface.createFromFile(path.getAbsolutePath());
    }

    private static final Typeface $$robo$$android_graphics_Typeface$createFromFile(String path) {
        if (sFallbackFonts != null) {
            FontFamily fontFamily = new FontFamily();
            if (fontFamily.addFont(path, 0, null, -1, -1)) {
                fontFamily.allowUnsupportedFont();
                fontFamily.freeze();
                FontFamily[] families = new FontFamily[]{fontFamily};
                return Typeface.createFromFamiliesWithDefault(families, -1, -1);
            }
            fontFamily.abortCreation();
        }
        throw new RuntimeException("Font not found " + path);
    }

    private static final Typeface $$robo$$android_graphics_Typeface$createFromFamilies(FontFamily[] families) {
        long[] ptrArray = new long[families.length];
        for (int i = 0; i < families.length; ++i) {
            ptrArray[i] = families[i].mNativePtr;
        }
        return new Typeface(Typeface.nativeCreateFromArray(ptrArray, -1, -1));
    }

    private static final Typeface $$robo$$android_graphics_Typeface$createFromFamiliesWithDefault(FontFamily[] families, int weight, int italic) {
        int i;
        long[] ptrArray = new long[families.length + sFallbackFonts.length];
        for (i = 0; i < families.length; ++i) {
            ptrArray[i] = families[i].mNativePtr;
        }
        for (i = 0; i < sFallbackFonts.length; ++i) {
            ptrArray[i + families.length] = Typeface.sFallbackFonts[i].mNativePtr;
        }
        return new Typeface(Typeface.nativeCreateFromArray(ptrArray, weight, italic));
    }

    private void $$robo$$android_graphics_Typeface$__constructor__(long ni) {
        this.mStyle = 0;
        this.mWeight = 0;
        if (ni == 0L) {
            throw new RuntimeException("native typeface cannot be made");
        }
        this.native_instance = ni;
        this.mStyle = Typeface.nativeGetStyle(ni);
        this.mWeight = Typeface.nativeGetWeight(ni);
    }

    private static final FontFamily $$robo$$android_graphics_Typeface$makeFamilyFromParsed(FontConfig.Family family, Map<String, ByteBuffer> bufferForPath) {
        FontFamily fontFamily = new FontFamily(family.getLanguage(), family.getVariant());
        for (FontConfig.Font font : family.getFonts()) {
            String fullPathName = "/system/fonts/" + font.getFontName();
            ByteBuffer fontBuffer = bufferForPath.get(fullPathName);
            if (fontBuffer == null) {
                try (FileInputStream file = new FileInputStream(fullPathName);){
                    FileChannel fileChannel = file.getChannel();
                    long fontSize = fileChannel.size();
                    fontBuffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, fontSize);
                    bufferForPath.put(fullPathName, fontBuffer);
                }
                catch (IOException e) {
                    Log.e(TAG, "Error mapping font file " + fullPathName);
                    continue;
                }
            }
            if (fontFamily.addFontFromBuffer(fontBuffer, font.getTtcIndex(), font.getAxes(), font.getWeight(), font.isItalic() ? 1 : 0)) continue;
            Log.e(TAG, "Error creating font " + fullPathName + "#" + font.getTtcIndex());
        }
        if (!fontFamily.freeze()) {
            Log.e(TAG, "Unable to load Family: " + family.getName() + ":" + family.getLanguage());
            return null;
        }
        return fontFamily;
    }

    private static final void $$robo$$android_graphics_Typeface$init() {
        File systemFontConfigLocation = Typeface.getSystemFontConfigLocation();
        File configFilename = new File(systemFontConfigLocation, "fonts.xml");
        try {
            FileInputStream fontsIn = new FileInputStream(configFilename);
            FontConfig fontConfig = FontListParser.parse(fontsIn);
            HashMap<String, ByteBuffer> bufferForPath = new HashMap<String, ByteBuffer>();
            ArrayList<FontFamily> familyList = new ArrayList<FontFamily>();
            for (int i = 0; i < fontConfig.getFamilies().length; ++i) {
                FontFamily family;
                FontConfig.Family f = fontConfig.getFamilies()[i];
                if (i != 0 && f.getName() != null || (family = Typeface.makeFamilyFromParsed(f, bufferForPath)) == null) continue;
                familyList.add(family);
            }
            sFallbackFonts = familyList.toArray(new FontFamily[familyList.size()]);
            Typeface.setDefault(Typeface.createFromFamilies(sFallbackFonts));
            HashMap<String, Typeface> systemFonts = new HashMap<String, Typeface>();
            for (int i = 0; i < fontConfig.getFamilies().length; ++i) {
                Typeface typeface;
                FontConfig.Family f = fontConfig.getFamilies()[i];
                if (f.getName() == null) continue;
                if (i == 0) {
                    typeface = sDefaultTypeface;
                } else {
                    FontFamily fontFamily = Typeface.makeFamilyFromParsed(f, bufferForPath);
                    if (fontFamily == null) continue;
                    FontFamily[] families = new FontFamily[]{fontFamily};
                    typeface = Typeface.createFromFamiliesWithDefault(families, -1, -1);
                }
                systemFonts.put(f.getName(), typeface);
            }
            for (FontConfig.Alias alias : fontConfig.getAliases()) {
                Typeface base;
                Typeface newFace = base = (Typeface)systemFonts.get(alias.getToName());
                int weight = alias.getWeight();
                if (weight != 400) {
                    newFace = new Typeface(Typeface.nativeCreateWeightAlias(base.native_instance, weight));
                }
                systemFonts.put(alias.getName(), newFace);
            }
            sSystemFontMap = systemFonts;
        }
        catch (RuntimeException e) {
            Log.w(TAG, "Didn't create default family (most likely, non-Minikin build)", e);
        }
        catch (FileNotFoundException e) {
            Log.e(TAG, "Error opening " + configFilename, e);
        }
        catch (IOException e) {
            Log.e(TAG, "Error reading " + configFilename, e);
        }
        catch (XmlPullParserException e) {
            Log.e(TAG, "XML parse exception for " + configFilename, e);
        }
    }

    private static final File $$robo$$android_graphics_Typeface$getSystemFontConfigLocation() {
        return new File("/system/etc/");
    }

    private final void $$robo$$android_graphics_Typeface$finalize() throws Throwable {
        try {
            Typeface.nativeUnref(this.native_instance);
            this.native_instance = 0L;
        }
        finally {
            super.finalize();
        }
    }

    private final boolean $$robo$$android_graphics_Typeface$equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Typeface typeface = (Typeface)o;
        return this.mStyle == typeface.mStyle && this.native_instance == typeface.native_instance;
    }

    private final int $$robo$$android_graphics_Typeface$hashCode() {
        int result = 17;
        result = 31 * result + (int)(this.native_instance ^ this.native_instance >>> 32);
        result = 31 * result + this.mStyle;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_graphics_Typeface$isSupportedAxes(int axis) {
        if (this.mSupportedAxes == null) {
            Typeface typeface = this;
            synchronized (typeface) {
                if (this.mSupportedAxes == null) {
                    this.mSupportedAxes = Typeface.nativeGetSupportedAxes(this.native_instance);
                    if (this.mSupportedAxes == null) {
                        this.mSupportedAxes = EMPTY_AXES;
                    }
                }
            }
        }
        return Arrays.binarySearch(this.mSupportedAxes, axis) >= 0;
    }

    private static final long $$robo$$android_graphics_Typeface$nativeCreateFromTypeface(long l, int n) {
        return 0L;
    }

    private static final long $$robo$$android_graphics_Typeface$nativeCreateFromTypefaceWithExactStyle(long l, int n, boolean bl) {
        return 0L;
    }

    private static final long $$robo$$android_graphics_Typeface$nativeCreateFromTypefaceWithVariation(long l, List<FontVariationAxis> list) {
        return 0L;
    }

    private static final long $$robo$$android_graphics_Typeface$nativeCreateWeightAlias(long l, int n) {
        return 0L;
    }

    private static final void $$robo$$android_graphics_Typeface$nativeUnref(long l) {
    }

    private static final int $$robo$$android_graphics_Typeface$nativeGetStyle(long l) {
        return 0;
    }

    private static final int $$robo$$android_graphics_Typeface$nativeGetWeight(long l) {
        return 0;
    }

    private static final long $$robo$$android_graphics_Typeface$nativeCreateFromArray(long[] lArray, int n, int n2) {
        return 0L;
    }

    private static final void $$robo$$android_graphics_Typeface$nativeSetDefault(long l) {
    }

    private static final int[] $$robo$$android_graphics_Typeface$nativeGetSupportedAxes(long l) {
        return null;
    }

    private /* synthetic */ void $$robo$$android_graphics_Typeface$__constructor__(long x0, 1 x1) {
    }

    static void __staticInitializer__() {
        TAG = "Typeface";
        sTypefaceCache = new LongSparseArray(3);
        sDynamicTypefaceCache = new LruCache(16);
        sLock = new Object();
        EMPTY_AXES = new int[0];
        Typeface.init();
        DEFAULT = Typeface.create((String)null, 0);
        DEFAULT_BOLD = Typeface.create((String)null, 1);
        SANS_SERIF = Typeface.create("sans-serif", 0);
        SERIF = Typeface.create("serif", 0);
        MONOSPACE = Typeface.create("monospace", 0);
        sDefaults = new Typeface[]{DEFAULT, DEFAULT_BOLD, Typeface.create((String)null, 2), Typeface.create((String)null, 3)};
    }

    private static void setDefault(Typeface typeface) {
        InvokeDynamicSupport.bootstrapStatic("setDefault", $$robo$$android_graphics_Typeface$setDefault(android.graphics.Typeface ), (Typeface)typeface);
    }

    public int getStyle() {
        return (int)InvokeDynamicSupport.bootstrap("getStyle", $$robo$$android_graphics_Typeface$getStyle(), this);
    }

    public boolean isBold() {
        return (boolean)InvokeDynamicSupport.bootstrap("isBold", $$robo$$android_graphics_Typeface$isBold(), this);
    }

    public boolean isItalic() {
        return (boolean)InvokeDynamicSupport.bootstrap("isItalic", $$robo$$android_graphics_Typeface$isItalic(), this);
    }

    public static Typeface createFromResources(AssetManager assetManager, String string2, int n) {
        return InvokeDynamicSupport.bootstrapStatic("createFromResources", $$robo$$android_graphics_Typeface$createFromResources(android.content.res.AssetManager java.lang.String int ), (AssetManager)assetManager, (String)string2, (int)n);
    }

    public static Typeface createFromResources(FontResourcesParser.FamilyResourceEntry familyResourceEntry, AssetManager assetManager, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("createFromResources", $$robo$$android_graphics_Typeface$createFromResources(android.content.res.FontResourcesParser$FamilyResourceEntry android.content.res.AssetManager java.lang.String ), (FontResourcesParser.FamilyResourceEntry)familyResourceEntry, (AssetManager)assetManager, (String)string2);
    }

    public static Typeface findFromCache(AssetManager assetManager, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("findFromCache", $$robo$$android_graphics_Typeface$findFromCache(android.content.res.AssetManager java.lang.String ), (AssetManager)assetManager, (String)string2);
    }

    public static Typeface create(String string2, int n) {
        return InvokeDynamicSupport.bootstrapStatic("create", $$robo$$android_graphics_Typeface$create(java.lang.String int ), (String)string2, (int)n);
    }

    public static Typeface create(Typeface typeface, int n) {
        return InvokeDynamicSupport.bootstrapStatic("create", $$robo$$android_graphics_Typeface$create(android.graphics.Typeface int ), (Typeface)typeface, (int)n);
    }

    public static Typeface createFromTypefaceWithVariation(Typeface typeface, List<FontVariationAxis> list) {
        return InvokeDynamicSupport.bootstrapStatic("createFromTypefaceWithVariation", $$robo$$android_graphics_Typeface$createFromTypefaceWithVariation(android.graphics.Typeface java.util.List<android.graphics.fonts.FontVariationAxis> ), (Typeface)typeface, list);
    }

    public static Typeface defaultFromStyle(int n) {
        return InvokeDynamicSupport.bootstrapStatic("defaultFromStyle", $$robo$$android_graphics_Typeface$defaultFromStyle(int ), (int)n);
    }

    public static Typeface createFromAsset(AssetManager assetManager, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("createFromAsset", $$robo$$android_graphics_Typeface$createFromAsset(android.content.res.AssetManager java.lang.String ), (AssetManager)assetManager, (String)string2);
    }

    private static String createProviderUid(String string2, String string3) {
        return InvokeDynamicSupport.bootstrapStatic("createProviderUid", $$robo$$android_graphics_Typeface$createProviderUid(java.lang.String java.lang.String ), (String)string2, (String)string3);
    }

    public static Typeface createFromFile(File file) {
        return InvokeDynamicSupport.bootstrapStatic("createFromFile", $$robo$$android_graphics_Typeface$createFromFile(java.io.File ), (File)file);
    }

    public static Typeface createFromFile(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("createFromFile", $$robo$$android_graphics_Typeface$createFromFile(java.lang.String ), (String)string2);
    }

    private static Typeface createFromFamilies(FontFamily[] fontFamilyArray) {
        return InvokeDynamicSupport.bootstrapStatic("createFromFamilies", $$robo$$android_graphics_Typeface$createFromFamilies(android.graphics.FontFamily[] ), (FontFamily[])fontFamilyArray);
    }

    private static Typeface createFromFamiliesWithDefault(FontFamily[] fontFamilyArray, int n, int n2) {
        return InvokeDynamicSupport.bootstrapStatic("createFromFamiliesWithDefault", $$robo$$android_graphics_Typeface$createFromFamiliesWithDefault(android.graphics.FontFamily[] int int ), (FontFamily[])fontFamilyArray, (int)n, (int)n2);
    }

    private void __constructor__(long l) {
        this.$$robo$$android_graphics_Typeface$__constructor__(l);
    }

    public Typeface(long l) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_Typeface$__constructor__(long ), this, l);
    }

    private static FontFamily makeFamilyFromParsed(FontConfig.Family family, Map<String, ByteBuffer> map) {
        return InvokeDynamicSupport.bootstrapStatic("makeFamilyFromParsed", $$robo$$android_graphics_Typeface$makeFamilyFromParsed(android.text.FontConfig$Family java.util.Map<java.lang.String, java.nio.ByteBuffer> ), (FontConfig.Family)family, map);
    }

    private static void init() {
        InvokeDynamicSupport.bootstrapStatic("init", $$robo$$android_graphics_Typeface$init());
    }

    private static File getSystemFontConfigLocation() {
        return InvokeDynamicSupport.bootstrapStatic("getSystemFontConfigLocation", $$robo$$android_graphics_Typeface$getSystemFontConfigLocation());
    }

    protected void finalize() throws Throwable {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_graphics_Typeface$finalize(), this);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_graphics_Typeface$equals(java.lang.Object ), this, object);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_graphics_Typeface$hashCode(), this);
    }

    public boolean isSupportedAxes(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isSupportedAxes", $$robo$$android_graphics_Typeface$isSupportedAxes(int ), this, n);
    }

    private static long nativeCreateFromTypeface(long l, int n) {
        return (long)InvokeDynamicSupport.bootstrapStatic("nativeCreateFromTypeface", $$robo$$android_graphics_Typeface$nativeCreateFromTypeface(long int ), (long)l, (int)n);
    }

    private static long nativeCreateFromTypefaceWithExactStyle(long l, int n, boolean bl) {
        return (long)InvokeDynamicSupport.bootstrapStatic("nativeCreateFromTypefaceWithExactStyle", $$robo$$android_graphics_Typeface$nativeCreateFromTypefaceWithExactStyle(long int boolean ), (long)l, (int)n, (boolean)bl);
    }

    private static long nativeCreateFromTypefaceWithVariation(long l, List<FontVariationAxis> list) {
        return (long)InvokeDynamicSupport.bootstrapStatic("nativeCreateFromTypefaceWithVariation", $$robo$$android_graphics_Typeface$nativeCreateFromTypefaceWithVariation(long java.util.List<android.graphics.fonts.FontVariationAxis> ), (long)l, list);
    }

    private static long nativeCreateWeightAlias(long l, int n) {
        return (long)InvokeDynamicSupport.bootstrapStatic("nativeCreateWeightAlias", $$robo$$android_graphics_Typeface$nativeCreateWeightAlias(long int ), (long)l, (int)n);
    }

    private static void nativeUnref(long l) {
        InvokeDynamicSupport.bootstrapStatic("nativeUnref", $$robo$$android_graphics_Typeface$nativeUnref(long ), (long)l);
    }

    private static int nativeGetStyle(long l) {
        return (int)InvokeDynamicSupport.bootstrapStatic("nativeGetStyle", $$robo$$android_graphics_Typeface$nativeGetStyle(long ), (long)l);
    }

    private static int nativeGetWeight(long l) {
        return (int)InvokeDynamicSupport.bootstrapStatic("nativeGetWeight", $$robo$$android_graphics_Typeface$nativeGetWeight(long ), (long)l);
    }

    private static long nativeCreateFromArray(long[] lArray, int n, int n2) {
        return (long)InvokeDynamicSupport.bootstrapStatic("nativeCreateFromArray", $$robo$$android_graphics_Typeface$nativeCreateFromArray(long[] int int ), (long[])lArray, (int)n, (int)n2);
    }

    private static void nativeSetDefault(long l) {
        InvokeDynamicSupport.bootstrapStatic("nativeSetDefault", $$robo$$android_graphics_Typeface$nativeSetDefault(long ), (long)l);
    }

    private static int[] nativeGetSupportedAxes(long l) {
        return InvokeDynamicSupport.bootstrapStatic("nativeGetSupportedAxes", $$robo$$android_graphics_Typeface$nativeGetSupportedAxes(long ), (long)l);
    }

    private /* synthetic */ void __constructor__(long l, 1 var3_2) {
        this.$$robo$$android_graphics_Typeface$__constructor__(l, var3_2);
    }

    public /* synthetic */ Typeface(long l, 1 var3_2) {
        this(l);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_Typeface$__constructor__(long android.graphics.Typeface$1 ), this, l, var3_2);
    }

    static {
        RobolectricInternals.classInitializing(Typeface.class);
    }

    public /* synthetic */ Typeface() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Typeface)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class Builder
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public static int NORMAL_WEIGHT = 400;
        public static int BOLD_WEIGHT = 700;
        private int mTtcIndex;
        private FontVariationAxis[] mAxes;
        private AssetManager mAssetManager;
        private String mPath;
        private FileDescriptor mFd;
        private FontsContract.FontInfo[] mFonts;
        private Map<Uri, ByteBuffer> mFontBuffers;
        private String mFallbackFamilyName;
        private int mWeight;
        private int mItalic;
        private static Object sLock;
        @GuardedBy(value="sLock")
        private static LongSparseArray<SparseArray<Typeface>> sTypefaceCache;

        private void $$robo$$android_graphics_Typeface_Builder$__constructor__(File path) {
            this.mWeight = -1;
            this.mItalic = -1;
            this.mPath = path.getAbsolutePath();
        }

        private void $$robo$$android_graphics_Typeface_Builder$__constructor__(FileDescriptor fd) {
            this.mWeight = -1;
            this.mItalic = -1;
            this.mFd = fd;
        }

        private void $$robo$$android_graphics_Typeface_Builder$__constructor__(String path) {
            this.mWeight = -1;
            this.mItalic = -1;
            this.mPath = path;
        }

        private void $$robo$$android_graphics_Typeface_Builder$__constructor__(AssetManager assetManager, String path) {
            this.mWeight = -1;
            this.mItalic = -1;
            this.mAssetManager = Preconditions.checkNotNull(assetManager);
            this.mPath = Preconditions.checkStringNotEmpty(path);
        }

        private void $$robo$$android_graphics_Typeface_Builder$__constructor__(FontsContract.FontInfo[] fonts, Map<Uri, ByteBuffer> buffers) {
            this.mWeight = -1;
            this.mItalic = -1;
            this.mFonts = fonts;
            this.mFontBuffers = buffers;
        }

        private final Builder $$robo$$android_graphics_Typeface_Builder$setWeight(int weight) {
            this.mWeight = weight;
            return this;
        }

        private final Builder $$robo$$android_graphics_Typeface_Builder$setItalic(boolean italic) {
            this.mItalic = italic ? 1 : 0;
            return this;
        }

        private final Builder $$robo$$android_graphics_Typeface_Builder$setTtcIndex(int ttcIndex) {
            if (this.mFonts != null) {
                throw new IllegalArgumentException("TTC index can not be specified for FontResult source.");
            }
            this.mTtcIndex = ttcIndex;
            return this;
        }

        private final Builder $$robo$$android_graphics_Typeface_Builder$setFontVariationSettings(String variationSettings) {
            if (this.mFonts != null) {
                throw new IllegalArgumentException("Font variation settings can not be specified for FontResult source.");
            }
            if (this.mAxes != null) {
                throw new IllegalStateException("Font variation settings are already set.");
            }
            this.mAxes = FontVariationAxis.fromFontVariationSettings(variationSettings);
            return this;
        }

        private final Builder $$robo$$android_graphics_Typeface_Builder$setFontVariationSettings(FontVariationAxis[] axes) {
            if (this.mFonts != null) {
                throw new IllegalArgumentException("Font variation settings can not be specified for FontResult source.");
            }
            if (this.mAxes != null) {
                throw new IllegalStateException("Font variation settings are already set.");
            }
            this.mAxes = axes;
            return this;
        }

        private final Builder $$robo$$android_graphics_Typeface_Builder$setFallback(String familyName) {
            this.mFallbackFamilyName = familyName;
            return this;
        }

        private static final String $$robo$$android_graphics_Typeface_Builder$createAssetUid(AssetManager mgr, String path, int ttcIndex, FontVariationAxis[] axes, int weight, int italic) {
            SparseArray<String> pkgs = mgr.getAssignedPackageIdentifiers();
            StringBuilder builder = new StringBuilder();
            int size = pkgs.size();
            for (int i = 0; i < size; ++i) {
                builder.append(pkgs.valueAt(i));
                builder.append("-");
            }
            builder.append(path);
            builder.append("-");
            builder.append(Integer.toString(ttcIndex));
            builder.append("-");
            builder.append(Integer.toString(weight));
            builder.append("-");
            builder.append(Integer.toString(italic));
            builder.append("-");
            if (axes != null) {
                for (FontVariationAxis axis : axes) {
                    builder.append(axis.getTag());
                    builder.append("-");
                    builder.append(Float.toString(axis.getStyleValue()));
                }
            }
            return builder.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final Typeface $$robo$$android_graphics_Typeface_Builder$resolveFallbackTypeface() {
            Typeface typeface;
            int weight;
            if (this.mFallbackFamilyName == null) {
                return null;
            }
            Typeface base = sSystemFontMap.get(this.mFallbackFamilyName);
            if (base == null) {
                base = sDefaultTypeface;
            }
            if (this.mWeight == -1 && this.mItalic == -1) {
                return base;
            }
            int n = weight = this.mWeight == -1 ? base.mWeight : this.mWeight;
            boolean italic = this.mItalic == -1 ? (base.mStyle & 2) != 0 : this.mItalic == 1;
            int key = weight << 1 | (italic ? 1 : 0);
            Object object = sLock;
            synchronized (object) {
                SparseArray<Typeface> innerCache = sTypefaceCache.get(base.native_instance);
                if (innerCache != null && (typeface = innerCache.get(key)) != null) {
                    return typeface;
                }
                typeface = new Typeface(Typeface.nativeCreateFromTypefaceWithExactStyle(base.native_instance, weight, italic), null);
                if (innerCache == null) {
                    innerCache = new SparseArray(4);
                    sTypefaceCache.put(base.native_instance, innerCache);
                }
                innerCache.put(key, typeface);
            }
            return typeface;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private final Typeface $$robo$$android_graphics_Typeface_Builder$build() {
            if (this.mFd != null) {
                try (FileInputStream fis = new FileInputStream(this.mFd);){
                    FileChannel channel = fis.getChannel();
                    long size = channel.size();
                    MappedByteBuffer buffer = channel.map(FileChannel.MapMode.READ_ONLY, 0L, size);
                    FontFamily fontFamily = new FontFamily();
                    if (!fontFamily.addFontFromBuffer(buffer, this.mTtcIndex, this.mAxes, this.mWeight, this.mItalic)) {
                        fontFamily.abortCreation();
                        Typeface typeface = this.resolveFallbackTypeface();
                        return typeface;
                    }
                    if (!fontFamily.freeze()) {
                        Typeface typeface = this.resolveFallbackTypeface();
                        return typeface;
                    }
                    FontFamily[] families = new FontFamily[]{fontFamily};
                    Typeface typeface = Typeface.createFromFamiliesWithDefault(families, this.mWeight, this.mItalic);
                    return typeface;
                }
                catch (IOException e) {
                    return this.resolveFallbackTypeface();
                }
            }
            if (this.mAssetManager != null) {
                String key = Builder.createAssetUid(this.mAssetManager, this.mPath, this.mTtcIndex, this.mAxes, this.mWeight, this.mItalic);
                Object object = sLock;
                synchronized (object) {
                    Typeface typeface = (Typeface)sDynamicTypefaceCache.get(key);
                    if (typeface != null) {
                        return typeface;
                    }
                    FontFamily fontFamily = new FontFamily();
                    if (!fontFamily.addFontFromAssetManager(this.mAssetManager, this.mPath, this.mTtcIndex, true, this.mTtcIndex, this.mWeight, this.mItalic, this.mAxes)) {
                        fontFamily.abortCreation();
                        return this.resolveFallbackTypeface();
                    }
                    if (!fontFamily.freeze()) {
                        return this.resolveFallbackTypeface();
                    }
                    FontFamily[] families = new FontFamily[]{fontFamily};
                    typeface = Typeface.createFromFamiliesWithDefault(families, this.mWeight, this.mItalic);
                    sDynamicTypefaceCache.put(key, typeface);
                    return typeface;
                }
            }
            if (this.mPath != null) {
                FontFamily fontFamily = new FontFamily();
                if (!fontFamily.addFont(this.mPath, this.mTtcIndex, this.mAxes, this.mWeight, this.mItalic)) {
                    fontFamily.abortCreation();
                    return this.resolveFallbackTypeface();
                }
                if (!fontFamily.freeze()) {
                    return this.resolveFallbackTypeface();
                }
                FontFamily[] families = new FontFamily[]{fontFamily};
                return Typeface.createFromFamiliesWithDefault(families, this.mWeight, this.mItalic);
            }
            if (this.mFonts == null) throw new IllegalArgumentException("No source was set.");
            FontFamily fontFamily = new FontFamily();
            boolean atLeastOneFont = false;
            for (FontsContract.FontInfo font : this.mFonts) {
                ByteBuffer fontBuffer = this.mFontBuffers.get(font.getUri());
                if (fontBuffer == null) continue;
                boolean success = fontFamily.addFontFromBuffer(fontBuffer, font.getTtcIndex(), font.getAxes(), font.getWeight(), font.isItalic() ? 1 : 0);
                if (!success) {
                    fontFamily.abortCreation();
                    return null;
                }
                atLeastOneFont = true;
            }
            if (!atLeastOneFont) {
                fontFamily.abortCreation();
                return null;
            }
            fontFamily.freeze();
            FontFamily[] families = new FontFamily[]{fontFamily};
            return Typeface.createFromFamiliesWithDefault(families, this.mWeight, this.mItalic);
        }

        static void __staticInitializer__() {
            sLock = new Object();
            sTypefaceCache = new LongSparseArray(3);
        }

        private void __constructor__(File file) {
            this.$$robo$$android_graphics_Typeface_Builder$__constructor__(file);
        }

        public Builder(File file) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_Typeface_Builder$__constructor__(java.io.File ), this, file);
        }

        private void __constructor__(FileDescriptor fileDescriptor) {
            this.$$robo$$android_graphics_Typeface_Builder$__constructor__(fileDescriptor);
        }

        public Builder(FileDescriptor fileDescriptor) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_Typeface_Builder$__constructor__(java.io.FileDescriptor ), this, fileDescriptor);
        }

        private void __constructor__(String string2) {
            this.$$robo$$android_graphics_Typeface_Builder$__constructor__(string2);
        }

        public Builder(String string2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_Typeface_Builder$__constructor__(java.lang.String ), this, string2);
        }

        private void __constructor__(AssetManager assetManager, String string2) {
            this.$$robo$$android_graphics_Typeface_Builder$__constructor__(assetManager, string2);
        }

        public Builder(AssetManager assetManager, String string2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_Typeface_Builder$__constructor__(android.content.res.AssetManager java.lang.String ), this, assetManager, string2);
        }

        private void __constructor__(FontsContract.FontInfo[] fontInfoArray, Map<Uri, ByteBuffer> map) {
            this.$$robo$$android_graphics_Typeface_Builder$__constructor__(fontInfoArray, map);
        }

        public Builder(FontsContract.FontInfo[] fontInfoArray, Map<Uri, ByteBuffer> map) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_Typeface_Builder$__constructor__(android.provider.FontsContract$FontInfo[] java.util.Map<android.net.Uri, java.nio.ByteBuffer> ), this, fontInfoArray, map);
        }

        public Builder setWeight(int n) {
            return InvokeDynamicSupport.bootstrap("setWeight", $$robo$$android_graphics_Typeface_Builder$setWeight(int ), this, n);
        }

        public Builder setItalic(boolean bl) {
            return InvokeDynamicSupport.bootstrap("setItalic", $$robo$$android_graphics_Typeface_Builder$setItalic(boolean ), this, bl);
        }

        public Builder setTtcIndex(int n) {
            return InvokeDynamicSupport.bootstrap("setTtcIndex", $$robo$$android_graphics_Typeface_Builder$setTtcIndex(int ), this, n);
        }

        public Builder setFontVariationSettings(String string2) {
            return InvokeDynamicSupport.bootstrap("setFontVariationSettings", $$robo$$android_graphics_Typeface_Builder$setFontVariationSettings(java.lang.String ), this, string2);
        }

        public Builder setFontVariationSettings(FontVariationAxis[] fontVariationAxisArray) {
            return InvokeDynamicSupport.bootstrap("setFontVariationSettings", $$robo$$android_graphics_Typeface_Builder$setFontVariationSettings(android.graphics.fonts.FontVariationAxis[] ), this, fontVariationAxisArray);
        }

        public Builder setFallback(String string2) {
            return InvokeDynamicSupport.bootstrap("setFallback", $$robo$$android_graphics_Typeface_Builder$setFallback(java.lang.String ), this, string2);
        }

        private static String createAssetUid(AssetManager assetManager, String string2, int n, FontVariationAxis[] fontVariationAxisArray, int n2, int n3) {
            return InvokeDynamicSupport.bootstrapStatic("createAssetUid", $$robo$$android_graphics_Typeface_Builder$createAssetUid(android.content.res.AssetManager java.lang.String int android.graphics.fonts.FontVariationAxis[] int int ), (AssetManager)assetManager, (String)string2, (int)n, (FontVariationAxis[])fontVariationAxisArray, (int)n2, (int)n3);
        }

        private Typeface resolveFallbackTypeface() {
            return InvokeDynamicSupport.bootstrap("resolveFallbackTypeface", $$robo$$android_graphics_Typeface_Builder$resolveFallbackTypeface(), this);
        }

        public Typeface build() {
            return InvokeDynamicSupport.bootstrap("build", $$robo$$android_graphics_Typeface_Builder$build(), this);
        }

        static {
            RobolectricInternals.classInitializing(Builder.class);
        }

        public /* synthetic */ Builder() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Builder)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

