/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.AnimatedVectorDrawable;
import android.graphics.drawable.AnimationDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.DrawableContainer;
import android.graphics.drawable.StateListDrawable;
import android.util.AttributeSet;
import android.util.Log;
import android.util.LongSparseLongArray;
import android.util.SparseIntArray;
import android.util.StateSet;
import com.android.internal.R;
import java.io.IOException;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class AnimatedStateListDrawable
extends StateListDrawable
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String LOGTAG;
    private static String ELEMENT_TRANSITION = "transition";
    private static String ELEMENT_ITEM = "item";
    private AnimatedStateListState mState;
    private Transition mTransition;
    private int mTransitionToIndex;
    private int mTransitionFromIndex;
    private boolean mMutated;

    private void $$robo$$android_graphics_drawable_AnimatedStateListDrawable$__constructor__() {
    }

    private final boolean $$robo$$android_graphics_drawable_AnimatedStateListDrawable$setVisible(boolean visible, boolean restart) {
        boolean changed = super.setVisible(visible, restart);
        if (this.mTransition != null && (changed || restart)) {
            if (visible) {
                this.mTransition.start();
            } else {
                this.jumpToCurrentState();
            }
        }
        return changed;
    }

    private final void $$robo$$android_graphics_drawable_AnimatedStateListDrawable$addState(int[] stateSet, Drawable drawable2, int id2) {
        if (drawable2 == null) {
            throw new IllegalArgumentException("Drawable must not be null");
        }
        this.mState.addStateSet(stateSet, drawable2, id2);
        this.onStateChange(this.getState());
    }

    private final <T extends Drawable> void $$robo$$android_graphics_drawable_AnimatedStateListDrawable$addTransition(int fromId, int toId, T transition2, boolean reversible) {
        if (transition2 == null) {
            throw new IllegalArgumentException("Transition drawable must not be null");
        }
        this.mState.addTransition(fromId, toId, transition2, reversible);
    }

    private final boolean $$robo$$android_graphics_drawable_AnimatedStateListDrawable$isStateful() {
        return true;
    }

    private final boolean $$robo$$android_graphics_drawable_AnimatedStateListDrawable$onStateChange(int[] stateSet) {
        int targetIndex = this.mState.indexOfKeyframe(stateSet);
        boolean changed = targetIndex != this.getCurrentIndex() && (this.selectTransition(targetIndex) || this.selectDrawable(targetIndex));
        Drawable current = this.getCurrent();
        if (current != null) {
            changed |= current.setState(stateSet);
        }
        return changed;
    }

    private final boolean $$robo$$android_graphics_drawable_AnimatedStateListDrawable$selectTransition(int toIndex) {
        Transition transition2;
        int fromIndex;
        Transition currentTransition = this.mTransition;
        if (currentTransition != null) {
            if (toIndex == this.mTransitionToIndex) {
                return true;
            }
            if (toIndex == this.mTransitionFromIndex && currentTransition.canReverse()) {
                currentTransition.reverse();
                this.mTransitionToIndex = this.mTransitionFromIndex;
                this.mTransitionFromIndex = toIndex;
                return true;
            }
            fromIndex = this.mTransitionToIndex;
            currentTransition.stop();
        } else {
            fromIndex = this.getCurrentIndex();
        }
        this.mTransition = null;
        this.mTransitionFromIndex = -1;
        this.mTransitionToIndex = -1;
        AnimatedStateListState state = this.mState;
        int fromId = state.getKeyframeIdAt(fromIndex);
        int toId = state.getKeyframeIdAt(toIndex);
        if (toId == 0 || fromId == 0) {
            return false;
        }
        int transitionIndex = state.indexOfTransition(fromId, toId);
        if (transitionIndex < 0) {
            return false;
        }
        boolean hasReversibleFlag = state.transitionHasReversibleFlag(fromId, toId);
        this.selectDrawable(transitionIndex);
        Drawable d = this.getCurrent();
        if (d instanceof AnimationDrawable) {
            boolean reversed = state.isTransitionReversed(fromId, toId);
            transition2 = new AnimationDrawableTransition((AnimationDrawable)d, reversed, hasReversibleFlag);
        } else if (d instanceof AnimatedVectorDrawable) {
            boolean reversed = state.isTransitionReversed(fromId, toId);
            transition2 = new AnimatedVectorDrawableTransition((AnimatedVectorDrawable)d, reversed, hasReversibleFlag);
        } else if (d instanceof Animatable) {
            transition2 = new AnimatableTransition((Animatable)((Object)d));
        } else {
            return false;
        }
        transition2.start();
        this.mTransition = transition2;
        this.mTransitionFromIndex = fromIndex;
        this.mTransitionToIndex = toIndex;
        return true;
    }

    private final void $$robo$$android_graphics_drawable_AnimatedStateListDrawable$jumpToCurrentState() {
        super.jumpToCurrentState();
        if (this.mTransition != null) {
            this.mTransition.stop();
            this.mTransition = null;
            this.selectDrawable(this.mTransitionToIndex);
            this.mTransitionToIndex = -1;
            this.mTransitionFromIndex = -1;
        }
    }

    private final void $$robo$$android_graphics_drawable_AnimatedStateListDrawable$inflate(Resources r, XmlPullParser parser, AttributeSet attrs, Resources.Theme theme) throws XmlPullParserException, IOException {
        TypedArray a = AnimatedStateListDrawable.obtainAttributes(r, theme, attrs, R.styleable.AnimatedStateListDrawable);
        super.inflateWithAttributes(r, parser, a, 1);
        this.updateStateFromTypedArray(a);
        this.updateDensity(r);
        a.recycle();
        this.inflateChildElements(r, parser, attrs, theme);
        this.init();
    }

    private final void $$robo$$android_graphics_drawable_AnimatedStateListDrawable$applyTheme(Resources.Theme theme) {
        super.applyTheme(theme);
        AnimatedStateListState state = this.mState;
        if (state == null || state.mAnimThemeAttrs == null) {
            return;
        }
        TypedArray a = theme.resolveAttributes(state.mAnimThemeAttrs, R.styleable.AnimatedRotateDrawable);
        this.updateStateFromTypedArray(a);
        a.recycle();
        this.init();
    }

    private final void $$robo$$android_graphics_drawable_AnimatedStateListDrawable$updateStateFromTypedArray(TypedArray a) {
        AnimatedStateListState state = this.mState;
        state.mChangingConfigurations |= a.getChangingConfigurations();
        state.mAnimThemeAttrs = a.extractThemeAttrs();
        state.setVariablePadding(a.getBoolean(2, state.mVariablePadding));
        state.setConstantSize(a.getBoolean(3, state.mConstantSize));
        state.setEnterFadeDuration(a.getInt(4, state.mEnterFadeDuration));
        state.setExitFadeDuration(a.getInt(5, state.mExitFadeDuration));
        this.setDither(a.getBoolean(0, state.mDither));
        this.setAutoMirrored(a.getBoolean(6, state.mAutoMirrored));
    }

    private final void $$robo$$android_graphics_drawable_AnimatedStateListDrawable$init() {
        this.onStateChange(this.getState());
    }

    private final void $$robo$$android_graphics_drawable_AnimatedStateListDrawable$inflateChildElements(Resources r, XmlPullParser parser, AttributeSet attrs, Resources.Theme theme) throws XmlPullParserException, IOException {
        int depth;
        int type;
        int innerDepth = parser.getDepth() + 1;
        while ((type = parser.next()) != 1 && ((depth = parser.getDepth()) >= innerDepth || type != 3)) {
            if (type != 2 || depth > innerDepth) continue;
            if (parser.getName().equals("item")) {
                this.parseItem(r, parser, attrs, theme);
                continue;
            }
            if (!parser.getName().equals("transition")) continue;
            this.parseTransition(r, parser, attrs, theme);
        }
    }

    private final int $$robo$$android_graphics_drawable_AnimatedStateListDrawable$parseTransition(Resources r, XmlPullParser parser, AttributeSet attrs, Resources.Theme theme) throws XmlPullParserException, IOException {
        TypedArray a = AnimatedStateListDrawable.obtainAttributes(r, theme, attrs, R.styleable.AnimatedStateListDrawableTransition);
        int fromId = a.getResourceId(2, 0);
        int toId = a.getResourceId(1, 0);
        boolean reversible = a.getBoolean(3, false);
        Drawable dr = a.getDrawable(0);
        a.recycle();
        if (dr == null) {
            int type;
            while ((type = parser.next()) == 4) {
            }
            if (type != 2) {
                throw new XmlPullParserException(parser.getPositionDescription() + ": <transition> tag requires a 'drawable' attribute or child tag defining a drawable");
            }
            dr = Drawable.createFromXmlInner(r, parser, attrs, theme);
        }
        return this.mState.addTransition(fromId, toId, dr, reversible);
    }

    private final int $$robo$$android_graphics_drawable_AnimatedStateListDrawable$parseItem(Resources r, XmlPullParser parser, AttributeSet attrs, Resources.Theme theme) throws XmlPullParserException, IOException {
        TypedArray a = AnimatedStateListDrawable.obtainAttributes(r, theme, attrs, R.styleable.AnimatedStateListDrawableItem);
        int keyframeId = a.getResourceId(0, 0);
        Drawable dr = a.getDrawable(1);
        a.recycle();
        int[] states = this.extractStateSet(attrs);
        if (dr == null) {
            int type;
            while ((type = parser.next()) == 4) {
            }
            if (type != 2) {
                throw new XmlPullParserException(parser.getPositionDescription() + ": <item> tag requires a 'drawable' attribute or child tag defining a drawable");
            }
            dr = Drawable.createFromXmlInner(r, parser, attrs, theme);
        }
        return this.mState.addStateSet(states, dr, keyframeId);
    }

    private final Drawable $$robo$$android_graphics_drawable_AnimatedStateListDrawable$mutate() {
        if (!this.mMutated && super.mutate() == this) {
            this.mState.mutate();
            this.mMutated = true;
        }
        return this;
    }

    private final AnimatedStateListState $$robo$$android_graphics_drawable_AnimatedStateListDrawable$cloneConstantState() {
        return new AnimatedStateListState(this.mState, this, null);
    }

    private final void $$robo$$android_graphics_drawable_AnimatedStateListDrawable$clearMutated() {
        super.clearMutated();
        this.mMutated = false;
    }

    private final void $$robo$$android_graphics_drawable_AnimatedStateListDrawable$setConstantState(DrawableContainer.DrawableContainerState state) {
        super.setConstantState(state);
        if (state instanceof AnimatedStateListState) {
            this.mState = (AnimatedStateListState)state;
        }
    }

    private void $$robo$$android_graphics_drawable_AnimatedStateListDrawable$__constructor__(AnimatedStateListState state, Resources res) {
        this.mTransitionToIndex = -1;
        this.mTransitionFromIndex = -1;
        AnimatedStateListState newState = new AnimatedStateListState(state, this, res);
        this.setConstantState(newState);
        this.onStateChange(this.getState());
        this.jumpToCurrentState();
    }

    private /* synthetic */ void $$robo$$android_graphics_drawable_AnimatedStateListDrawable$__constructor__(AnimatedStateListState x0, Resources x1, 1 x2) {
    }

    static void __staticInitializer__() {
        LOGTAG = AnimatedStateListDrawable.class.getSimpleName();
    }

    private void __constructor__() {
        this.$$robo$$android_graphics_drawable_AnimatedStateListDrawable$__constructor__();
    }

    public AnimatedStateListDrawable() {
        this(null, null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_AnimatedStateListDrawable$__constructor__(), this);
    }

    @Override
    public boolean setVisible(boolean bl, boolean bl2) {
        return (boolean)InvokeDynamicSupport.bootstrap("setVisible", $$robo$$android_graphics_drawable_AnimatedStateListDrawable$setVisible(boolean boolean ), this, bl, bl2);
    }

    public void addState(int[] nArray, Drawable drawable2, int n) {
        InvokeDynamicSupport.bootstrap("addState", $$robo$$android_graphics_drawable_AnimatedStateListDrawable$addState(int[] android.graphics.drawable.Drawable int ), this, nArray, drawable2, n);
    }

    public <T extends Drawable> void addTransition(int n, int n2, T t, boolean bl) {
        InvokeDynamicSupport.bootstrap("addTransition", $$robo$$android_graphics_drawable_AnimatedStateListDrawable$addTransition(int int T boolean ), this, n, n2, t, bl);
    }

    @Override
    public boolean isStateful() {
        return (boolean)InvokeDynamicSupport.bootstrap("isStateful", $$robo$$android_graphics_drawable_AnimatedStateListDrawable$isStateful(), this);
    }

    @Override
    protected boolean onStateChange(int[] nArray) {
        return (boolean)InvokeDynamicSupport.bootstrap("onStateChange", $$robo$$android_graphics_drawable_AnimatedStateListDrawable$onStateChange(int[] ), this, nArray);
    }

    private boolean selectTransition(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("selectTransition", $$robo$$android_graphics_drawable_AnimatedStateListDrawable$selectTransition(int ), this, n);
    }

    @Override
    public void jumpToCurrentState() {
        InvokeDynamicSupport.bootstrap("jumpToCurrentState", $$robo$$android_graphics_drawable_AnimatedStateListDrawable$jumpToCurrentState(), this);
    }

    @Override
    public void inflate(Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, Resources.Theme theme) throws XmlPullParserException, IOException {
        InvokeDynamicSupport.bootstrap("inflate", $$robo$$android_graphics_drawable_AnimatedStateListDrawable$inflate(android.content.res.Resources org.xmlpull.v1.XmlPullParser android.util.AttributeSet android.content.res.Resources$Theme ), this, resources, xmlPullParser, attributeSet, theme);
    }

    @Override
    public void applyTheme(Resources.Theme theme) {
        InvokeDynamicSupport.bootstrap("applyTheme", $$robo$$android_graphics_drawable_AnimatedStateListDrawable$applyTheme(android.content.res.Resources$Theme ), this, theme);
    }

    private void updateStateFromTypedArray(TypedArray typedArray) {
        InvokeDynamicSupport.bootstrap("updateStateFromTypedArray", $$robo$$android_graphics_drawable_AnimatedStateListDrawable$updateStateFromTypedArray(android.content.res.TypedArray ), this, typedArray);
    }

    private void init() {
        InvokeDynamicSupport.bootstrap("init", $$robo$$android_graphics_drawable_AnimatedStateListDrawable$init(), this);
    }

    private void inflateChildElements(Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, Resources.Theme theme) throws XmlPullParserException, IOException {
        InvokeDynamicSupport.bootstrap("inflateChildElements", $$robo$$android_graphics_drawable_AnimatedStateListDrawable$inflateChildElements(android.content.res.Resources org.xmlpull.v1.XmlPullParser android.util.AttributeSet android.content.res.Resources$Theme ), this, resources, xmlPullParser, attributeSet, theme);
    }

    private int parseTransition(Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, Resources.Theme theme) throws XmlPullParserException, IOException {
        return (int)InvokeDynamicSupport.bootstrap("parseTransition", $$robo$$android_graphics_drawable_AnimatedStateListDrawable$parseTransition(android.content.res.Resources org.xmlpull.v1.XmlPullParser android.util.AttributeSet android.content.res.Resources$Theme ), this, resources, xmlPullParser, attributeSet, theme);
    }

    private int parseItem(Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, Resources.Theme theme) throws XmlPullParserException, IOException {
        return (int)InvokeDynamicSupport.bootstrap("parseItem", $$robo$$android_graphics_drawable_AnimatedStateListDrawable$parseItem(android.content.res.Resources org.xmlpull.v1.XmlPullParser android.util.AttributeSet android.content.res.Resources$Theme ), this, resources, xmlPullParser, attributeSet, theme);
    }

    @Override
    public Drawable mutate() {
        return InvokeDynamicSupport.bootstrap("mutate", $$robo$$android_graphics_drawable_AnimatedStateListDrawable$mutate(), this);
    }

    @Override
    AnimatedStateListState cloneConstantState() {
        return InvokeDynamicSupport.bootstrap("cloneConstantState", $$robo$$android_graphics_drawable_AnimatedStateListDrawable$cloneConstantState(), this);
    }

    @Override
    public void clearMutated() {
        InvokeDynamicSupport.bootstrap("clearMutated", $$robo$$android_graphics_drawable_AnimatedStateListDrawable$clearMutated(), this);
    }

    @Override
    protected void setConstantState(DrawableContainer.DrawableContainerState drawableContainerState) {
        InvokeDynamicSupport.bootstrap("setConstantState", $$robo$$android_graphics_drawable_AnimatedStateListDrawable$setConstantState(android.graphics.drawable.DrawableContainer$DrawableContainerState ), this, drawableContainerState);
    }

    private void __constructor__(AnimatedStateListState animatedStateListState, Resources resources) {
        this.$$robo$$android_graphics_drawable_AnimatedStateListDrawable$__constructor__(animatedStateListState, resources);
    }

    public AnimatedStateListDrawable(AnimatedStateListState animatedStateListState, Resources resources) {
        super(null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_AnimatedStateListDrawable$__constructor__(android.graphics.drawable.AnimatedStateListDrawable$AnimatedStateListState android.content.res.Resources ), this, animatedStateListState, resources);
    }

    private /* synthetic */ void __constructor__(AnimatedStateListState animatedStateListState, Resources resources, 1 var3_3) {
        this.$$robo$$android_graphics_drawable_AnimatedStateListDrawable$__constructor__(animatedStateListState, resources, var3_3);
    }

    public /* synthetic */ AnimatedStateListDrawable(AnimatedStateListState animatedStateListState, Resources resources, 1 var3_3) {
        this(animatedStateListState, resources);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_AnimatedStateListDrawable$__constructor__(android.graphics.drawable.AnimatedStateListDrawable$AnimatedStateListState android.content.res.Resources android.graphics.drawable.AnimatedStateListDrawable$1 ), this, animatedStateListState, resources, var3_3);
    }

    static {
        RobolectricInternals.classInitializing(AnimatedStateListDrawable.class);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AnimatedStateListDrawable)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class FrameInterpolator
    implements TimeInterpolator,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private int[] mFrameTimes;
        private int mFrames;
        private int mTotalDuration;

        private void $$robo$$android_graphics_drawable_AnimatedStateListDrawable_FrameInterpolator$__constructor__(AnimationDrawable d, boolean reversed) {
            this.updateFrames(d, reversed);
        }

        private final int $$robo$$android_graphics_drawable_AnimatedStateListDrawable_FrameInterpolator$updateFrames(AnimationDrawable d, boolean reversed) {
            int N;
            this.mFrames = N = d.getNumberOfFrames();
            if (this.mFrameTimes == null || this.mFrameTimes.length < N) {
                this.mFrameTimes = new int[N];
            }
            int[] frameTimes = this.mFrameTimes;
            int totalDuration = 0;
            for (int i = 0; i < N; ++i) {
                int duration;
                frameTimes[i] = duration = d.getDuration(reversed ? N - i - 1 : i);
                totalDuration += duration;
            }
            this.mTotalDuration = totalDuration;
            return totalDuration;
        }

        private final int $$robo$$android_graphics_drawable_AnimatedStateListDrawable_FrameInterpolator$getTotalDuration() {
            return this.mTotalDuration;
        }

        private final float $$robo$$android_graphics_drawable_AnimatedStateListDrawable_FrameInterpolator$getInterpolation(float input) {
            int i;
            int elapsed = (int)(input * (float)this.mTotalDuration + 0.5f);
            int N = this.mFrames;
            int[] frameTimes = this.mFrameTimes;
            int remaining = elapsed;
            for (i = 0; i < N && remaining >= frameTimes[i]; remaining -= frameTimes[i], ++i) {
            }
            float frameElapsed = i < N ? (float)remaining / (float)this.mTotalDuration : 0.0f;
            return (float)i / (float)N + frameElapsed;
        }

        private void __constructor__(AnimationDrawable animationDrawable, boolean bl) {
            this.$$robo$$android_graphics_drawable_AnimatedStateListDrawable_FrameInterpolator$__constructor__(animationDrawable, bl);
        }

        public FrameInterpolator(AnimationDrawable animationDrawable, boolean bl) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_AnimatedStateListDrawable_FrameInterpolator$__constructor__(android.graphics.drawable.AnimationDrawable boolean ), this, animationDrawable, bl);
        }

        public int updateFrames(AnimationDrawable animationDrawable, boolean bl) {
            return (int)InvokeDynamicSupport.bootstrap("updateFrames", $$robo$$android_graphics_drawable_AnimatedStateListDrawable_FrameInterpolator$updateFrames(android.graphics.drawable.AnimationDrawable boolean ), this, animationDrawable, bl);
        }

        public int getTotalDuration() {
            return (int)InvokeDynamicSupport.bootstrap("getTotalDuration", $$robo$$android_graphics_drawable_AnimatedStateListDrawable_FrameInterpolator$getTotalDuration(), this);
        }

        @Override
        public float getInterpolation(float f) {
            return (float)InvokeDynamicSupport.bootstrap("getInterpolation", $$robo$$android_graphics_drawable_AnimatedStateListDrawable_FrameInterpolator$getInterpolation(float ), this, f);
        }

        public /* synthetic */ FrameInterpolator() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (FrameInterpolator)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class AnimatedStateListState
    extends StateListDrawable.StateListState
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private static long REVERSED_BIT = 0x100000000L;
        private static long REVERSIBLE_FLAG_BIT = 0x200000000L;
        int[] mAnimThemeAttrs;
        LongSparseLongArray mTransitions;
        SparseIntArray mStateIds;

        private void $$robo$$android_graphics_drawable_AnimatedStateListDrawable_AnimatedStateListState$__constructor__(AnimatedStateListState orig, AnimatedStateListDrawable owner, Resources res) {
            if (orig != null) {
                this.mAnimThemeAttrs = orig.mAnimThemeAttrs;
                this.mTransitions = orig.mTransitions;
                this.mStateIds = orig.mStateIds;
            } else {
                this.mTransitions = new LongSparseLongArray();
                this.mStateIds = new SparseIntArray();
            }
        }

        private final void $$robo$$android_graphics_drawable_AnimatedStateListDrawable_AnimatedStateListState$mutate() {
            this.mTransitions = this.mTransitions.clone();
            this.mStateIds = this.mStateIds.clone();
        }

        private final int $$robo$$android_graphics_drawable_AnimatedStateListDrawable_AnimatedStateListState$addTransition(int fromId, int toId, Drawable anim2, boolean reversible) {
            int pos = super.addChild(anim2);
            long keyFromTo = AnimatedStateListState.generateTransitionKey(fromId, toId);
            long reversibleBit = 0L;
            if (reversible) {
                reversibleBit = 0x200000000L;
            }
            this.mTransitions.append(keyFromTo, (long)pos | reversibleBit);
            if (reversible) {
                long keyToFrom = AnimatedStateListState.generateTransitionKey(toId, fromId);
                this.mTransitions.append(keyToFrom, (long)pos | 0x100000000L | reversibleBit);
            }
            return pos;
        }

        private final int $$robo$$android_graphics_drawable_AnimatedStateListDrawable_AnimatedStateListState$addStateSet(int[] stateSet, Drawable drawable2, int id2) {
            int index = super.addStateSet(stateSet, drawable2);
            this.mStateIds.put(index, id2);
            return index;
        }

        private final int $$robo$$android_graphics_drawable_AnimatedStateListDrawable_AnimatedStateListState$indexOfKeyframe(int[] stateSet) {
            int index = super.indexOfStateSet(stateSet);
            if (index >= 0) {
                return index;
            }
            return super.indexOfStateSet(StateSet.WILD_CARD);
        }

        private final int $$robo$$android_graphics_drawable_AnimatedStateListDrawable_AnimatedStateListState$getKeyframeIdAt(int index) {
            return index < 0 ? 0 : this.mStateIds.get(index, 0);
        }

        private final int $$robo$$android_graphics_drawable_AnimatedStateListDrawable_AnimatedStateListState$indexOfTransition(int fromId, int toId) {
            long keyFromTo = AnimatedStateListState.generateTransitionKey(fromId, toId);
            return (int)this.mTransitions.get(keyFromTo, -1L);
        }

        private final boolean $$robo$$android_graphics_drawable_AnimatedStateListDrawable_AnimatedStateListState$isTransitionReversed(int fromId, int toId) {
            long keyFromTo = AnimatedStateListState.generateTransitionKey(fromId, toId);
            return (this.mTransitions.get(keyFromTo, -1L) & 0x100000000L) != 0L;
        }

        private final boolean $$robo$$android_graphics_drawable_AnimatedStateListDrawable_AnimatedStateListState$transitionHasReversibleFlag(int fromId, int toId) {
            long keyFromTo = AnimatedStateListState.generateTransitionKey(fromId, toId);
            return (this.mTransitions.get(keyFromTo, -1L) & 0x200000000L) != 0L;
        }

        private final boolean $$robo$$android_graphics_drawable_AnimatedStateListDrawable_AnimatedStateListState$canApplyTheme() {
            return this.mAnimThemeAttrs != null || super.canApplyTheme();
        }

        private final Drawable $$robo$$android_graphics_drawable_AnimatedStateListDrawable_AnimatedStateListState$newDrawable() {
            return new AnimatedStateListDrawable(this, null, null);
        }

        private final Drawable $$robo$$android_graphics_drawable_AnimatedStateListDrawable_AnimatedStateListState$newDrawable(Resources res) {
            return new AnimatedStateListDrawable(this, res, null);
        }

        private static final long $$robo$$android_graphics_drawable_AnimatedStateListDrawable_AnimatedStateListState$generateTransitionKey(int fromId, int toId) {
            return (long)fromId << 32 | (long)toId;
        }

        private void __constructor__(AnimatedStateListState animatedStateListState, AnimatedStateListDrawable animatedStateListDrawable, Resources resources) {
            this.$$robo$$android_graphics_drawable_AnimatedStateListDrawable_AnimatedStateListState$__constructor__(animatedStateListState, animatedStateListDrawable, resources);
        }

        public AnimatedStateListState(AnimatedStateListState animatedStateListState, AnimatedStateListDrawable animatedStateListDrawable, Resources resources) {
            super(animatedStateListState, animatedStateListDrawable, resources);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_AnimatedStateListDrawable_AnimatedStateListState$__constructor__(android.graphics.drawable.AnimatedStateListDrawable$AnimatedStateListState android.graphics.drawable.AnimatedStateListDrawable android.content.res.Resources ), this, animatedStateListState, animatedStateListDrawable, resources);
        }

        @Override
        void mutate() {
            InvokeDynamicSupport.bootstrap("mutate", $$robo$$android_graphics_drawable_AnimatedStateListDrawable_AnimatedStateListState$mutate(), this);
        }

        int addTransition(int n, int n2, Drawable drawable2, boolean bl) {
            return (int)InvokeDynamicSupport.bootstrap("addTransition", $$robo$$android_graphics_drawable_AnimatedStateListDrawable_AnimatedStateListState$addTransition(int int android.graphics.drawable.Drawable boolean ), this, n, n2, drawable2, bl);
        }

        int addStateSet(int[] nArray, Drawable drawable2, int n) {
            return (int)InvokeDynamicSupport.bootstrap("addStateSet", $$robo$$android_graphics_drawable_AnimatedStateListDrawable_AnimatedStateListState$addStateSet(int[] android.graphics.drawable.Drawable int ), this, nArray, drawable2, n);
        }

        int indexOfKeyframe(int[] nArray) {
            return (int)InvokeDynamicSupport.bootstrap("indexOfKeyframe", $$robo$$android_graphics_drawable_AnimatedStateListDrawable_AnimatedStateListState$indexOfKeyframe(int[] ), this, nArray);
        }

        int getKeyframeIdAt(int n) {
            return (int)InvokeDynamicSupport.bootstrap("getKeyframeIdAt", $$robo$$android_graphics_drawable_AnimatedStateListDrawable_AnimatedStateListState$getKeyframeIdAt(int ), this, n);
        }

        int indexOfTransition(int n, int n2) {
            return (int)InvokeDynamicSupport.bootstrap("indexOfTransition", $$robo$$android_graphics_drawable_AnimatedStateListDrawable_AnimatedStateListState$indexOfTransition(int int ), this, n, n2);
        }

        boolean isTransitionReversed(int n, int n2) {
            return (boolean)InvokeDynamicSupport.bootstrap("isTransitionReversed", $$robo$$android_graphics_drawable_AnimatedStateListDrawable_AnimatedStateListState$isTransitionReversed(int int ), this, n, n2);
        }

        boolean transitionHasReversibleFlag(int n, int n2) {
            return (boolean)InvokeDynamicSupport.bootstrap("transitionHasReversibleFlag", $$robo$$android_graphics_drawable_AnimatedStateListDrawable_AnimatedStateListState$transitionHasReversibleFlag(int int ), this, n, n2);
        }

        @Override
        public boolean canApplyTheme() {
            return (boolean)InvokeDynamicSupport.bootstrap("canApplyTheme", $$robo$$android_graphics_drawable_AnimatedStateListDrawable_AnimatedStateListState$canApplyTheme(), this);
        }

        @Override
        public Drawable newDrawable() {
            return InvokeDynamicSupport.bootstrap("newDrawable", $$robo$$android_graphics_drawable_AnimatedStateListDrawable_AnimatedStateListState$newDrawable(), this);
        }

        @Override
        public Drawable newDrawable(Resources resources) {
            return InvokeDynamicSupport.bootstrap("newDrawable", $$robo$$android_graphics_drawable_AnimatedStateListDrawable_AnimatedStateListState$newDrawable(android.content.res.Resources ), this, resources);
        }

        private static long generateTransitionKey(int n, int n2) {
            return (long)InvokeDynamicSupport.bootstrapStatic("generateTransitionKey", $$robo$$android_graphics_drawable_AnimatedStateListDrawable_AnimatedStateListState$generateTransitionKey(int int ), (int)n, (int)n2);
        }

        public /* synthetic */ AnimatedStateListState() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AnimatedStateListState)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class AnimatedVectorDrawableTransition
    extends Transition
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private AnimatedVectorDrawable mAvd;
        private boolean mReversed;
        private boolean mHasReversibleFlag;

        private void $$robo$$android_graphics_drawable_AnimatedStateListDrawable_AnimatedVectorDrawableTransition$__constructor__(AnimatedVectorDrawable avd, boolean reversed, boolean hasReversibleFlag) {
            this.mAvd = avd;
            this.mReversed = reversed;
            this.mHasReversibleFlag = hasReversibleFlag;
        }

        private final boolean $$robo$$android_graphics_drawable_AnimatedStateListDrawable_AnimatedVectorDrawableTransition$canReverse() {
            return this.mAvd.canReverse() && this.mHasReversibleFlag;
        }

        private final void $$robo$$android_graphics_drawable_AnimatedStateListDrawable_AnimatedVectorDrawableTransition$start() {
            if (this.mReversed) {
                this.reverse();
            } else {
                this.mAvd.start();
            }
        }

        private final void $$robo$$android_graphics_drawable_AnimatedStateListDrawable_AnimatedVectorDrawableTransition$reverse() {
            if (this.canReverse()) {
                this.mAvd.reverse();
            } else {
                Log.w(LOGTAG, "Can't reverse, either the reversible is set to false, or the AnimatedVectorDrawable can't reverse");
            }
        }

        private final void $$robo$$android_graphics_drawable_AnimatedStateListDrawable_AnimatedVectorDrawableTransition$stop() {
            this.mAvd.stop();
        }

        private void __constructor__(AnimatedVectorDrawable animatedVectorDrawable, boolean bl, boolean bl2) {
            this.$$robo$$android_graphics_drawable_AnimatedStateListDrawable_AnimatedVectorDrawableTransition$__constructor__(animatedVectorDrawable, bl, bl2);
        }

        public AnimatedVectorDrawableTransition(AnimatedVectorDrawable animatedVectorDrawable, boolean bl, boolean bl2) {
            super(null);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_AnimatedStateListDrawable_AnimatedVectorDrawableTransition$__constructor__(android.graphics.drawable.AnimatedVectorDrawable boolean boolean ), this, animatedVectorDrawable, bl, bl2);
        }

        @Override
        public boolean canReverse() {
            return (boolean)InvokeDynamicSupport.bootstrap("canReverse", $$robo$$android_graphics_drawable_AnimatedStateListDrawable_AnimatedVectorDrawableTransition$canReverse(), this);
        }

        @Override
        public void start() {
            InvokeDynamicSupport.bootstrap("start", $$robo$$android_graphics_drawable_AnimatedStateListDrawable_AnimatedVectorDrawableTransition$start(), this);
        }

        @Override
        public void reverse() {
            InvokeDynamicSupport.bootstrap("reverse", $$robo$$android_graphics_drawable_AnimatedStateListDrawable_AnimatedVectorDrawableTransition$reverse(), this);
        }

        @Override
        public void stop() {
            InvokeDynamicSupport.bootstrap("stop", $$robo$$android_graphics_drawable_AnimatedStateListDrawable_AnimatedVectorDrawableTransition$stop(), this);
        }

        public /* synthetic */ AnimatedVectorDrawableTransition() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AnimatedVectorDrawableTransition)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class AnimationDrawableTransition
    extends Transition
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private ObjectAnimator mAnim;
        private boolean mHasReversibleFlag;

        private void $$robo$$android_graphics_drawable_AnimatedStateListDrawable_AnimationDrawableTransition$__constructor__(AnimationDrawable ad, boolean reversed, boolean hasReversibleFlag) {
            int frameCount = ad.getNumberOfFrames();
            int fromFrame = reversed ? frameCount - 1 : 0;
            int toFrame = reversed ? 0 : frameCount - 1;
            FrameInterpolator interp = new FrameInterpolator(ad, reversed);
            ObjectAnimator anim2 = ObjectAnimator.ofInt((Object)ad, "currentIndex", fromFrame, toFrame);
            anim2.setAutoCancel(true);
            anim2.setDuration(interp.getTotalDuration());
            anim2.setInterpolator(interp);
            this.mHasReversibleFlag = hasReversibleFlag;
            this.mAnim = anim2;
        }

        private final boolean $$robo$$android_graphics_drawable_AnimatedStateListDrawable_AnimationDrawableTransition$canReverse() {
            return this.mHasReversibleFlag;
        }

        private final void $$robo$$android_graphics_drawable_AnimatedStateListDrawable_AnimationDrawableTransition$start() {
            this.mAnim.start();
        }

        private final void $$robo$$android_graphics_drawable_AnimatedStateListDrawable_AnimationDrawableTransition$reverse() {
            this.mAnim.reverse();
        }

        private final void $$robo$$android_graphics_drawable_AnimatedStateListDrawable_AnimationDrawableTransition$stop() {
            this.mAnim.cancel();
        }

        private void __constructor__(AnimationDrawable animationDrawable, boolean bl, boolean bl2) {
            this.$$robo$$android_graphics_drawable_AnimatedStateListDrawable_AnimationDrawableTransition$__constructor__(animationDrawable, bl, bl2);
        }

        public AnimationDrawableTransition(AnimationDrawable animationDrawable, boolean bl, boolean bl2) {
            super(null);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_AnimatedStateListDrawable_AnimationDrawableTransition$__constructor__(android.graphics.drawable.AnimationDrawable boolean boolean ), this, animationDrawable, bl, bl2);
        }

        @Override
        public boolean canReverse() {
            return (boolean)InvokeDynamicSupport.bootstrap("canReverse", $$robo$$android_graphics_drawable_AnimatedStateListDrawable_AnimationDrawableTransition$canReverse(), this);
        }

        @Override
        public void start() {
            InvokeDynamicSupport.bootstrap("start", $$robo$$android_graphics_drawable_AnimatedStateListDrawable_AnimationDrawableTransition$start(), this);
        }

        @Override
        public void reverse() {
            InvokeDynamicSupport.bootstrap("reverse", $$robo$$android_graphics_drawable_AnimatedStateListDrawable_AnimationDrawableTransition$reverse(), this);
        }

        @Override
        public void stop() {
            InvokeDynamicSupport.bootstrap("stop", $$robo$$android_graphics_drawable_AnimatedStateListDrawable_AnimationDrawableTransition$stop(), this);
        }

        public /* synthetic */ AnimationDrawableTransition() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AnimationDrawableTransition)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class AnimatableTransition
    extends Transition
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private Animatable mA;

        private void $$robo$$android_graphics_drawable_AnimatedStateListDrawable_AnimatableTransition$__constructor__(Animatable a) {
            this.mA = a;
        }

        private final void $$robo$$android_graphics_drawable_AnimatedStateListDrawable_AnimatableTransition$start() {
            this.mA.start();
        }

        private final void $$robo$$android_graphics_drawable_AnimatedStateListDrawable_AnimatableTransition$stop() {
            this.mA.stop();
        }

        private void __constructor__(Animatable animatable) {
            this.$$robo$$android_graphics_drawable_AnimatedStateListDrawable_AnimatableTransition$__constructor__(animatable);
        }

        public AnimatableTransition(Animatable animatable) {
            super(null);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_AnimatedStateListDrawable_AnimatableTransition$__constructor__(android.graphics.drawable.Animatable ), this, animatable);
        }

        @Override
        public void start() {
            InvokeDynamicSupport.bootstrap("start", $$robo$$android_graphics_drawable_AnimatedStateListDrawable_AnimatableTransition$start(), this);
        }

        @Override
        public void stop() {
            InvokeDynamicSupport.bootstrap("stop", $$robo$$android_graphics_drawable_AnimatedStateListDrawable_AnimatableTransition$stop(), this);
        }

        public /* synthetic */ AnimatableTransition() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AnimatableTransition)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static abstract class Transition
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;

        private void $$robo$$android_graphics_drawable_AnimatedStateListDrawable_Transition$__constructor__() {
        }

        public abstract void start();

        public abstract void stop();

        private final void $$robo$$android_graphics_drawable_AnimatedStateListDrawable_Transition$reverse() {
        }

        private final boolean $$robo$$android_graphics_drawable_AnimatedStateListDrawable_Transition$canReverse() {
            return false;
        }

        private /* synthetic */ void $$robo$$android_graphics_drawable_AnimatedStateListDrawable_Transition$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$android_graphics_drawable_AnimatedStateListDrawable_Transition$__constructor__();
        }

        public Transition() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_AnimatedStateListDrawable_Transition$__constructor__(), this);
        }

        public void reverse() {
            InvokeDynamicSupport.bootstrap("reverse", $$robo$$android_graphics_drawable_AnimatedStateListDrawable_Transition$reverse(), this);
        }

        public boolean canReverse() {
            return (boolean)InvokeDynamicSupport.bootstrap("canReverse", $$robo$$android_graphics_drawable_AnimatedStateListDrawable_Transition$canReverse(), this);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_graphics_drawable_AnimatedStateListDrawable_Transition$__constructor__(var1_1);
        }

        public /* synthetic */ Transition(1 var1_1) {
            this();
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_AnimatedStateListDrawable_Transition$__constructor__(android.graphics.drawable.AnimatedStateListDrawable$1 ), this, var1_1);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Transition)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

