/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.graphics.Canvas;
import android.graphics.CanvasProperty;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.RippleComponent;
import android.graphics.drawable.RippleDrawable;
import android.util.FloatProperty;
import android.util.MathUtils;
import android.view.DisplayListCanvas;
import android.view.RenderNodeAnimator;
import android.view.animation.LinearInterpolator;
import com.google.errorprone.annotations.DoNotMock;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class RippleForeground
extends RippleComponent
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static TimeInterpolator LINEAR_INTERPOLATOR;
    private static TimeInterpolator DECELERATE_INTERPOLATOR;
    private static float WAVE_TOUCH_DOWN_ACCELERATION = 1024.0f;
    private static float WAVE_TOUCH_UP_ACCELERATION = 3400.0f;
    private static float WAVE_OPACITY_DECAY_VELOCITY = 3.0f;
    private static int BOUNDED_ORIGIN_EXIT_DURATION = 300;
    private static int BOUNDED_RADIUS_EXIT_DURATION = 800;
    private static int BOUNDED_OPACITY_EXIT_DURATION = 400;
    private static float MAX_BOUNDED_RADIUS = 350.0f;
    private static int RIPPLE_ENTER_DELAY = 80;
    private static int OPACITY_ENTER_DURATION_FAST = 120;
    private float mStartingX;
    private float mStartingY;
    private float mClampedStartingX;
    private float mClampedStartingY;
    private CanvasProperty<Paint> mPropPaint;
    private CanvasProperty<Float> mPropRadius;
    private CanvasProperty<Float> mPropX;
    private CanvasProperty<Float> mPropY;
    private float mTargetX;
    private float mTargetY;
    private float mBoundedRadius;
    private float mOpacity;
    private float mTweenRadius;
    private float mTweenX;
    private float mTweenY;
    private boolean mIsBounded;
    private boolean mHasFinishedExit;
    private AnimatorListenerAdapter mAnimationListener;
    private static FloatProperty<RippleForeground> TWEEN_RADIUS;
    private static FloatProperty<RippleForeground> TWEEN_ORIGIN;
    private static FloatProperty<RippleForeground> OPACITY;

    private void $$robo$$android_graphics_drawable_RippleForeground$__constructor__(RippleDrawable owner, Rect bounds, float startingX, float startingY, boolean isBounded, boolean forceSoftware) {
        this.mTargetX = 0.0f;
        this.mTargetY = 0.0f;
        this.mBoundedRadius = 0.0f;
        this.mOpacity = 1.0f;
        this.mTweenRadius = 0.0f;
        this.mTweenX = 0.0f;
        this.mTweenY = 0.0f;
        this.mAnimationListener = new ShadowedObject(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ RippleForeground this$0;

            private void $$robo$$android_graphics_drawable_RippleForeground_1$__constructor__(RippleForeground this$0) {
            }

            private final void $$robo$$android_graphics_drawable_RippleForeground_1$onAnimationEnd(Animator animator2) {
                this.this$0.mHasFinishedExit = true;
            }

            private void __constructor__(RippleForeground rippleForeground) {
                this.$$robo$$android_graphics_drawable_RippleForeground_1$__constructor__(rippleForeground);
            }
            {
                this.this$0 = rippleForeground;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_RippleForeground_1$__constructor__(android.graphics.drawable.RippleForeground ), this, rippleForeground);
            }

            @Override
            public void onAnimationEnd(Animator animator2) {
                InvokeDynamicSupport.bootstrap("onAnimationEnd", $$robo$$android_graphics_drawable_RippleForeground_1$onAnimationEnd(android.animation.Animator ), this, animator2);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mIsBounded = isBounded;
        this.mStartingX = startingX;
        this.mStartingY = startingY;
        this.mBoundedRadius = isBounded ? 315.0f + (float)(350.0 * Math.random() * 0.1) : 0.0f;
    }

    private final void $$robo$$android_graphics_drawable_RippleForeground$onTargetRadiusChanged(float targetRadius) {
        this.clampStartingPosition();
    }

    private final boolean $$robo$$android_graphics_drawable_RippleForeground$drawSoftware(Canvas c, Paint p) {
        boolean hasContent = false;
        int origAlpha = p.getAlpha();
        int alpha = (int)((float)origAlpha * this.mOpacity + 0.5f);
        float radius = this.getCurrentRadius();
        if (alpha > 0 && radius > 0.0f) {
            float x = this.getCurrentX();
            float y = this.getCurrentY();
            p.setAlpha(alpha);
            c.drawCircle(x, y, radius, p);
            p.setAlpha(origAlpha);
            hasContent = true;
        }
        return hasContent;
    }

    private final boolean $$robo$$android_graphics_drawable_RippleForeground$drawHardware(DisplayListCanvas c) {
        c.drawCircle(this.mPropX, this.mPropY, this.mPropRadius, this.mPropPaint);
        return true;
    }

    private final void $$robo$$android_graphics_drawable_RippleForeground$getBounds(Rect bounds) {
        int outerX = (int)this.mTargetX;
        int outerY = (int)this.mTargetY;
        int r = (int)this.mTargetRadius + 1;
        bounds.set(outerX - r, outerY - r, outerX + r, outerY + r);
    }

    private final void $$robo$$android_graphics_drawable_RippleForeground$move(float x, float y) {
        this.mStartingX = x;
        this.mStartingY = y;
        this.clampStartingPosition();
    }

    private final boolean $$robo$$android_graphics_drawable_RippleForeground$hasFinishedExit() {
        return this.mHasFinishedExit;
    }

    private final Animator $$robo$$android_graphics_drawable_RippleForeground$createSoftwareEnter(boolean fast) {
        if (this.mIsBounded) {
            return null;
        }
        int duration = (int)(1000.0 * Math.sqrt(this.mTargetRadius / 1024.0f * this.mDensityScale) + 0.5);
        ObjectAnimator tweenRadius = ObjectAnimator.ofFloat(this, TWEEN_RADIUS, 1.0f);
        tweenRadius.setAutoCancel(true);
        tweenRadius.setDuration(duration);
        tweenRadius.setInterpolator(LINEAR_INTERPOLATOR);
        tweenRadius.setStartDelay(80L);
        ObjectAnimator tweenOrigin = ObjectAnimator.ofFloat(this, TWEEN_ORIGIN, 1.0f);
        tweenOrigin.setAutoCancel(true);
        tweenOrigin.setDuration(duration);
        tweenOrigin.setInterpolator(LINEAR_INTERPOLATOR);
        tweenOrigin.setStartDelay(80L);
        ObjectAnimator opacity = ObjectAnimator.ofFloat(this, OPACITY, 1.0f);
        opacity.setAutoCancel(true);
        opacity.setDuration(120L);
        opacity.setInterpolator(LINEAR_INTERPOLATOR);
        AnimatorSet set = new AnimatorSet();
        set.play(tweenOrigin).with(tweenRadius).with(opacity);
        return set;
    }

    private final float $$robo$$android_graphics_drawable_RippleForeground$getCurrentX() {
        return MathUtils.lerp(this.mClampedStartingX - this.mBounds.exactCenterX(), this.mTargetX, this.mTweenX);
    }

    private final float $$robo$$android_graphics_drawable_RippleForeground$getCurrentY() {
        return MathUtils.lerp(this.mClampedStartingY - this.mBounds.exactCenterY(), this.mTargetY, this.mTweenY);
    }

    private final int $$robo$$android_graphics_drawable_RippleForeground$getRadiusExitDuration() {
        float remainingRadius = this.mTargetRadius - this.getCurrentRadius();
        return (int)(1000.0 * Math.sqrt(remainingRadius / 4424.0f * this.mDensityScale) + 0.5);
    }

    private final float $$robo$$android_graphics_drawable_RippleForeground$getCurrentRadius() {
        return MathUtils.lerp(0.0f, this.mTargetRadius, this.mTweenRadius);
    }

    private final int $$robo$$android_graphics_drawable_RippleForeground$getOpacityExitDuration() {
        return (int)(1000.0f * this.mOpacity / 3.0f + 0.5f);
    }

    private final void $$robo$$android_graphics_drawable_RippleForeground$computeBoundedTargetValues() {
        this.mTargetX = (this.mClampedStartingX - this.mBounds.exactCenterX()) * 0.7f;
        this.mTargetY = (this.mClampedStartingY - this.mBounds.exactCenterY()) * 0.7f;
        this.mTargetRadius = this.mBoundedRadius;
    }

    private final Animator $$robo$$android_graphics_drawable_RippleForeground$createSoftwareExit() {
        int opacityDuration;
        int originDuration;
        int radiusDuration;
        if (this.mIsBounded) {
            this.computeBoundedTargetValues();
            radiusDuration = 800;
            originDuration = 300;
            opacityDuration = 400;
        } else {
            originDuration = radiusDuration = this.getRadiusExitDuration();
            opacityDuration = this.getOpacityExitDuration();
        }
        ObjectAnimator tweenRadius = ObjectAnimator.ofFloat(this, TWEEN_RADIUS, 1.0f);
        tweenRadius.setAutoCancel(true);
        tweenRadius.setDuration(radiusDuration);
        tweenRadius.setInterpolator(DECELERATE_INTERPOLATOR);
        ObjectAnimator tweenOrigin = ObjectAnimator.ofFloat(this, TWEEN_ORIGIN, 1.0f);
        tweenOrigin.setAutoCancel(true);
        tweenOrigin.setDuration(originDuration);
        tweenOrigin.setInterpolator(DECELERATE_INTERPOLATOR);
        ObjectAnimator opacity = ObjectAnimator.ofFloat(this, OPACITY, 0.0f);
        opacity.setAutoCancel(true);
        opacity.setDuration(opacityDuration);
        opacity.setInterpolator(LINEAR_INTERPOLATOR);
        AnimatorSet set = new AnimatorSet();
        set.play(tweenOrigin).with(tweenRadius).with(opacity);
        set.addListener(this.mAnimationListener);
        return set;
    }

    private final RippleComponent.RenderNodeAnimatorSet $$robo$$android_graphics_drawable_RippleForeground$createHardwareExit(Paint p) {
        int opacityDuration;
        int originDuration;
        int radiusDuration;
        if (this.mIsBounded) {
            this.computeBoundedTargetValues();
            radiusDuration = 800;
            originDuration = 300;
            opacityDuration = 400;
        } else {
            originDuration = radiusDuration = this.getRadiusExitDuration();
            opacityDuration = this.getOpacityExitDuration();
        }
        float startX = this.getCurrentX();
        float startY = this.getCurrentY();
        float startRadius = this.getCurrentRadius();
        p.setAlpha((int)((float)p.getAlpha() * this.mOpacity + 0.5f));
        this.mPropPaint = CanvasProperty.createPaint(p);
        this.mPropRadius = CanvasProperty.createFloat(startRadius);
        this.mPropX = CanvasProperty.createFloat(startX);
        this.mPropY = CanvasProperty.createFloat(startY);
        RenderNodeAnimator radius = new RenderNodeAnimator(this.mPropRadius, this.mTargetRadius);
        radius.setDuration(radiusDuration);
        radius.setInterpolator(DECELERATE_INTERPOLATOR);
        RenderNodeAnimator x = new RenderNodeAnimator(this.mPropX, this.mTargetX);
        x.setDuration(originDuration);
        x.setInterpolator(DECELERATE_INTERPOLATOR);
        RenderNodeAnimator y = new RenderNodeAnimator(this.mPropY, this.mTargetY);
        y.setDuration(originDuration);
        y.setInterpolator(DECELERATE_INTERPOLATOR);
        RenderNodeAnimator opacity = new RenderNodeAnimator(this.mPropPaint, 1, 0.0f);
        opacity.setDuration(opacityDuration);
        opacity.setInterpolator(LINEAR_INTERPOLATOR);
        opacity.addListener(this.mAnimationListener);
        RippleComponent.RenderNodeAnimatorSet set = new RippleComponent.RenderNodeAnimatorSet();
        set.add(radius);
        set.add(opacity);
        set.add(x);
        set.add(y);
        return set;
    }

    private final void $$robo$$android_graphics_drawable_RippleForeground$jumpValuesToExit() {
        this.mOpacity = 0.0f;
        this.mTweenX = 1.0f;
        this.mTweenY = 1.0f;
        this.mTweenRadius = 1.0f;
    }

    private final void $$robo$$android_graphics_drawable_RippleForeground$clampStartingPosition() {
        float r;
        float cY;
        float dY;
        float cX = this.mBounds.exactCenterX();
        float dX = this.mStartingX - cX;
        if (dX * dX + (dY = this.mStartingY - (cY = this.mBounds.exactCenterY())) * dY > (r = this.mTargetRadius) * r) {
            double angle = Math.atan2(dY, dX);
            this.mClampedStartingX = cX + (float)(Math.cos(angle) * (double)r);
            this.mClampedStartingY = cY + (float)(Math.sin(angle) * (double)r);
        } else {
            this.mClampedStartingX = this.mStartingX;
            this.mClampedStartingY = this.mStartingY;
        }
    }

    static void __staticInitializer__() {
        LINEAR_INTERPOLATOR = new LinearInterpolator();
        DECELERATE_INTERPOLATOR = new LogDecelerateInterpolator(400.0f, 1.4f, 0.0f);
        TWEEN_RADIUS = new FloatProperty<RippleForeground>("tweenRadius"){
            public /* synthetic */ Object __robo_data__;

            private void $$robo$$android_graphics_drawable_RippleForeground_2$__constructor__(String name) {
            }

            private final void $$robo$$android_graphics_drawable_RippleForeground_2$setValue(RippleForeground object, float value) {
                object.mTweenRadius = value;
                object.invalidateSelf();
            }

            private final Float $$robo$$android_graphics_drawable_RippleForeground_2$get(RippleForeground object) {
                return Float.valueOf(object.mTweenRadius);
            }

            private void __constructor__(String string2) {
                this.$$robo$$android_graphics_drawable_RippleForeground_2$__constructor__(string2);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_RippleForeground_2$__constructor__(java.lang.String ), this, string2);
            }

            @Override
            public void setValue(RippleForeground rippleForeground, float f) {
                InvokeDynamicSupport.bootstrap("setValue", $$robo$$android_graphics_drawable_RippleForeground_2$setValue(android.graphics.drawable.RippleForeground float ), this, rippleForeground, f);
            }

            @Override
            public Float get(RippleForeground rippleForeground) {
                return InvokeDynamicSupport.bootstrap("get", $$robo$$android_graphics_drawable_RippleForeground_2$get(android.graphics.drawable.RippleForeground ), this, rippleForeground);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        TWEEN_ORIGIN = new FloatProperty<RippleForeground>("tweenOrigin"){
            public /* synthetic */ Object __robo_data__;

            private void $$robo$$android_graphics_drawable_RippleForeground_3$__constructor__(String name) {
            }

            private final void $$robo$$android_graphics_drawable_RippleForeground_3$setValue(RippleForeground object, float value) {
                object.mTweenX = value;
                object.mTweenY = value;
                object.invalidateSelf();
            }

            private final Float $$robo$$android_graphics_drawable_RippleForeground_3$get(RippleForeground object) {
                return Float.valueOf(object.mTweenX);
            }

            private void __constructor__(String string2) {
                this.$$robo$$android_graphics_drawable_RippleForeground_3$__constructor__(string2);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_RippleForeground_3$__constructor__(java.lang.String ), this, string2);
            }

            @Override
            public void setValue(RippleForeground rippleForeground, float f) {
                InvokeDynamicSupport.bootstrap("setValue", $$robo$$android_graphics_drawable_RippleForeground_3$setValue(android.graphics.drawable.RippleForeground float ), this, rippleForeground, f);
            }

            @Override
            public Float get(RippleForeground rippleForeground) {
                return InvokeDynamicSupport.bootstrap("get", $$robo$$android_graphics_drawable_RippleForeground_3$get(android.graphics.drawable.RippleForeground ), this, rippleForeground);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        OPACITY = new FloatProperty<RippleForeground>("opacity"){
            public /* synthetic */ Object __robo_data__;

            private void $$robo$$android_graphics_drawable_RippleForeground_4$__constructor__(String name) {
            }

            private final void $$robo$$android_graphics_drawable_RippleForeground_4$setValue(RippleForeground object, float value) {
                object.mOpacity = value;
                object.invalidateSelf();
            }

            private final Float $$robo$$android_graphics_drawable_RippleForeground_4$get(RippleForeground object) {
                return Float.valueOf(object.mOpacity);
            }

            private void __constructor__(String string2) {
                this.$$robo$$android_graphics_drawable_RippleForeground_4$__constructor__(string2);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_RippleForeground_4$__constructor__(java.lang.String ), this, string2);
            }

            @Override
            public void setValue(RippleForeground rippleForeground, float f) {
                InvokeDynamicSupport.bootstrap("setValue", $$robo$$android_graphics_drawable_RippleForeground_4$setValue(android.graphics.drawable.RippleForeground float ), this, rippleForeground, f);
            }

            @Override
            public Float get(RippleForeground rippleForeground) {
                return InvokeDynamicSupport.bootstrap("get", $$robo$$android_graphics_drawable_RippleForeground_4$get(android.graphics.drawable.RippleForeground ), this, rippleForeground);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__(RippleDrawable rippleDrawable, Rect rect, float f, float f2, boolean bl, boolean bl2) {
        this.$$robo$$android_graphics_drawable_RippleForeground$__constructor__(rippleDrawable, rect, f, f2, bl, bl2);
    }

    public RippleForeground(RippleDrawable rippleDrawable, Rect rect, float f, float f2, boolean bl, boolean bl2) {
        super(rippleDrawable, rect, bl2);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_RippleForeground$__constructor__(android.graphics.drawable.RippleDrawable android.graphics.Rect float float boolean boolean ), this, rippleDrawable, rect, f, f2, bl, bl2);
    }

    @Override
    protected void onTargetRadiusChanged(float f) {
        InvokeDynamicSupport.bootstrap("onTargetRadiusChanged", $$robo$$android_graphics_drawable_RippleForeground$onTargetRadiusChanged(float ), this, f);
    }

    @Override
    protected boolean drawSoftware(Canvas canvas, Paint paint) {
        return (boolean)InvokeDynamicSupport.bootstrap("drawSoftware", $$robo$$android_graphics_drawable_RippleForeground$drawSoftware(android.graphics.Canvas android.graphics.Paint ), this, canvas, paint);
    }

    @Override
    protected boolean drawHardware(DisplayListCanvas displayListCanvas) {
        return (boolean)InvokeDynamicSupport.bootstrap("drawHardware", $$robo$$android_graphics_drawable_RippleForeground$drawHardware(android.view.DisplayListCanvas ), this, displayListCanvas);
    }

    @Override
    public void getBounds(Rect rect) {
        InvokeDynamicSupport.bootstrap("getBounds", $$robo$$android_graphics_drawable_RippleForeground$getBounds(android.graphics.Rect ), this, rect);
    }

    public void move(float f, float f2) {
        InvokeDynamicSupport.bootstrap("move", $$robo$$android_graphics_drawable_RippleForeground$move(float float ), this, f, f2);
    }

    public boolean hasFinishedExit() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasFinishedExit", $$robo$$android_graphics_drawable_RippleForeground$hasFinishedExit(), this);
    }

    @Override
    protected Animator createSoftwareEnter(boolean bl) {
        return InvokeDynamicSupport.bootstrap("createSoftwareEnter", $$robo$$android_graphics_drawable_RippleForeground$createSoftwareEnter(boolean ), this, bl);
    }

    private float getCurrentX() {
        return (float)InvokeDynamicSupport.bootstrap("getCurrentX", $$robo$$android_graphics_drawable_RippleForeground$getCurrentX(), this);
    }

    private float getCurrentY() {
        return (float)InvokeDynamicSupport.bootstrap("getCurrentY", $$robo$$android_graphics_drawable_RippleForeground$getCurrentY(), this);
    }

    private int getRadiusExitDuration() {
        return (int)InvokeDynamicSupport.bootstrap("getRadiusExitDuration", $$robo$$android_graphics_drawable_RippleForeground$getRadiusExitDuration(), this);
    }

    private float getCurrentRadius() {
        return (float)InvokeDynamicSupport.bootstrap("getCurrentRadius", $$robo$$android_graphics_drawable_RippleForeground$getCurrentRadius(), this);
    }

    private int getOpacityExitDuration() {
        return (int)InvokeDynamicSupport.bootstrap("getOpacityExitDuration", $$robo$$android_graphics_drawable_RippleForeground$getOpacityExitDuration(), this);
    }

    private void computeBoundedTargetValues() {
        InvokeDynamicSupport.bootstrap("computeBoundedTargetValues", $$robo$$android_graphics_drawable_RippleForeground$computeBoundedTargetValues(), this);
    }

    @Override
    protected Animator createSoftwareExit() {
        return InvokeDynamicSupport.bootstrap("createSoftwareExit", $$robo$$android_graphics_drawable_RippleForeground$createSoftwareExit(), this);
    }

    @Override
    protected RippleComponent.RenderNodeAnimatorSet createHardwareExit(Paint paint) {
        return InvokeDynamicSupport.bootstrap("createHardwareExit", $$robo$$android_graphics_drawable_RippleForeground$createHardwareExit(android.graphics.Paint ), this, paint);
    }

    @Override
    protected void jumpValuesToExit() {
        InvokeDynamicSupport.bootstrap("jumpValuesToExit", $$robo$$android_graphics_drawable_RippleForeground$jumpValuesToExit(), this);
    }

    private void clampStartingPosition() {
        InvokeDynamicSupport.bootstrap("clampStartingPosition", $$robo$$android_graphics_drawable_RippleForeground$clampStartingPosition(), this);
    }

    static {
        RobolectricInternals.classInitializing(RippleForeground.class);
    }

    public /* synthetic */ RippleForeground() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RippleForeground)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class LogDecelerateInterpolator
    implements TimeInterpolator,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private float mBase;
        private float mDrift;
        private float mTimeScale;
        private float mOutputScale;

        private void $$robo$$android_graphics_drawable_RippleForeground_LogDecelerateInterpolator$__constructor__(float base, float timeScale, float drift) {
            this.mBase = base;
            this.mDrift = drift;
            this.mTimeScale = 1.0f / timeScale;
            this.mOutputScale = 1.0f / this.computeLog(1.0f);
        }

        private final float $$robo$$android_graphics_drawable_RippleForeground_LogDecelerateInterpolator$computeLog(float t) {
            return 1.0f - (float)Math.pow(this.mBase, -t * this.mTimeScale) + this.mDrift * t;
        }

        private final float $$robo$$android_graphics_drawable_RippleForeground_LogDecelerateInterpolator$getInterpolation(float t) {
            return this.computeLog(t) * this.mOutputScale;
        }

        private void __constructor__(float f, float f2, float f3) {
            this.$$robo$$android_graphics_drawable_RippleForeground_LogDecelerateInterpolator$__constructor__(f, f2, f3);
        }

        public LogDecelerateInterpolator(float f, float f2, float f3) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_RippleForeground_LogDecelerateInterpolator$__constructor__(float float float ), this, f, f2, f3);
        }

        private float computeLog(float f) {
            return (float)InvokeDynamicSupport.bootstrap("computeLog", $$robo$$android_graphics_drawable_RippleForeground_LogDecelerateInterpolator$computeLog(float ), this, f);
        }

        @Override
        public float getInterpolation(float f) {
            return (float)InvokeDynamicSupport.bootstrap("getInterpolation", $$robo$$android_graphics_drawable_RippleForeground_LogDecelerateInterpolator$getInterpolation(float ), this, f);
        }

        public /* synthetic */ LogDecelerateInterpolator() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LogDecelerateInterpolator)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

