/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.content.res.ColorStateList;
import android.content.res.ComplexColor;
import android.content.res.GradientColor;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Insets;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.Rect;
import android.graphics.Shader;
import android.graphics.drawable.Drawable;
import android.util.ArrayMap;
import android.util.AttributeSet;
import android.util.FloatProperty;
import android.util.IntProperty;
import android.util.Log;
import android.util.PathParser;
import android.util.Property;
import android.util.Xml;
import com.android.internal.R;
import com.android.internal.util.VirtualRefBasePtr;
import dalvik.annotation.optimization.FastNative;
import dalvik.system.VMRuntime;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Stack;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class VectorDrawable
extends Drawable
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String LOGTAG;
    private static String SHAPE_CLIP_PATH = "clip-path";
    private static String SHAPE_GROUP = "group";
    private static String SHAPE_PATH = "path";
    private static String SHAPE_VECTOR = "vector";
    private VectorDrawableState mVectorState;
    private PorterDuffColorFilter mTintFilter;
    private ColorFilter mColorFilter;
    private boolean mMutated;
    private int mTargetDensity;
    private int mDpiScaledWidth;
    private int mDpiScaledHeight;
    private Insets mDpiScaledInsets;
    private boolean mDpiScaledDirty;
    private Rect mTmpBounds;

    private void $$robo$$android_graphics_drawable_VectorDrawable$__constructor__() {
    }

    private void $$robo$$android_graphics_drawable_VectorDrawable$__constructor__(VectorDrawableState state, Resources res) {
        this.mDpiScaledWidth = 0;
        this.mDpiScaledHeight = 0;
        this.mDpiScaledInsets = Insets.NONE;
        this.mDpiScaledDirty = true;
        this.mTmpBounds = new Rect();
        this.mVectorState = state;
        this.updateLocalState(res);
    }

    private final void $$robo$$android_graphics_drawable_VectorDrawable$updateLocalState(Resources res) {
        int density = Drawable.resolveDensity(res, this.mVectorState.mDensity);
        if (this.mTargetDensity != density) {
            this.mTargetDensity = density;
            this.mDpiScaledDirty = true;
        }
        this.mTintFilter = this.updateTintFilter(this.mTintFilter, this.mVectorState.mTint, this.mVectorState.mTintMode);
    }

    private final Drawable $$robo$$android_graphics_drawable_VectorDrawable$mutate() {
        if (!this.mMutated && super.mutate() == this) {
            this.mVectorState = new VectorDrawableState(this.mVectorState);
            this.mMutated = true;
        }
        return this;
    }

    private final void $$robo$$android_graphics_drawable_VectorDrawable$clearMutated() {
        super.clearMutated();
        this.mMutated = false;
    }

    private final Object $$robo$$android_graphics_drawable_VectorDrawable$getTargetByName(String name) {
        return this.mVectorState.mVGTargetsMap.get(name);
    }

    private final Drawable.ConstantState $$robo$$android_graphics_drawable_VectorDrawable$getConstantState() {
        this.mVectorState.mChangingConfigurations = this.getChangingConfigurations();
        return this.mVectorState;
    }

    private final void $$robo$$android_graphics_drawable_VectorDrawable$draw(Canvas canvas) {
        int deltaInBytes;
        this.copyBounds(this.mTmpBounds);
        if (this.mTmpBounds.width() <= 0 || this.mTmpBounds.height() <= 0) {
            return;
        }
        ColorFilter colorFilter = this.mColorFilter == null ? this.mTintFilter : this.mColorFilter;
        long colorFilterNativeInstance = colorFilter == null ? 0L : colorFilter.getNativeInstance();
        boolean canReuseCache = this.mVectorState.canReuseCache();
        int pixelCount = VectorDrawable.nDraw(this.mVectorState.getNativeRenderer(), canvas.getNativeCanvasWrapper(), colorFilterNativeInstance, this.mTmpBounds, this.needMirroring(), canReuseCache);
        if (pixelCount == 0) {
            return;
        }
        if (canvas.isHardwareAccelerated()) {
            deltaInBytes = (pixelCount - this.mVectorState.mLastHWCachePixelCount) * 4;
            this.mVectorState.mLastHWCachePixelCount = pixelCount;
        } else {
            deltaInBytes = (pixelCount - this.mVectorState.mLastSWCachePixelCount) * 4;
            this.mVectorState.mLastSWCachePixelCount = pixelCount;
        }
        if (deltaInBytes > 0) {
            VMRuntime.getRuntime().registerNativeAllocation(deltaInBytes);
        } else if (deltaInBytes < 0) {
            VMRuntime.getRuntime().registerNativeFree(-deltaInBytes);
        }
    }

    private final int $$robo$$android_graphics_drawable_VectorDrawable$getAlpha() {
        return (int)(this.mVectorState.getAlpha() * 255.0f);
    }

    private final void $$robo$$android_graphics_drawable_VectorDrawable$setAlpha(int alpha) {
        if (this.mVectorState.setAlpha((float)alpha / 255.0f)) {
            this.invalidateSelf();
        }
    }

    private final void $$robo$$android_graphics_drawable_VectorDrawable$setColorFilter(ColorFilter colorFilter) {
        this.mColorFilter = colorFilter;
        this.invalidateSelf();
    }

    private final ColorFilter $$robo$$android_graphics_drawable_VectorDrawable$getColorFilter() {
        return this.mColorFilter;
    }

    private final void $$robo$$android_graphics_drawable_VectorDrawable$setTintList(ColorStateList tint) {
        VectorDrawableState state = this.mVectorState;
        if (state.mTint != tint) {
            state.mTint = tint;
            this.mTintFilter = this.updateTintFilter(this.mTintFilter, tint, state.mTintMode);
            this.invalidateSelf();
        }
    }

    private final void $$robo$$android_graphics_drawable_VectorDrawable$setTintMode(PorterDuff.Mode tintMode) {
        VectorDrawableState state = this.mVectorState;
        if (state.mTintMode != tintMode) {
            state.mTintMode = tintMode;
            this.mTintFilter = this.updateTintFilter(this.mTintFilter, state.mTint, tintMode);
            this.invalidateSelf();
        }
    }

    private final boolean $$robo$$android_graphics_drawable_VectorDrawable$isStateful() {
        return super.isStateful() || this.mVectorState != null && this.mVectorState.isStateful();
    }

    private final boolean $$robo$$android_graphics_drawable_VectorDrawable$hasFocusStateSpecified() {
        return this.mVectorState != null && this.mVectorState.hasFocusStateSpecified();
    }

    private final boolean $$robo$$android_graphics_drawable_VectorDrawable$onStateChange(int[] stateSet) {
        VectorDrawableState state;
        boolean changed = false;
        if (this.isStateful()) {
            this.mutate();
        }
        if ((state = this.mVectorState).onStateChange(stateSet)) {
            changed = true;
            state.mCacheDirty = true;
        }
        if (state.mTint != null && state.mTintMode != null) {
            this.mTintFilter = this.updateTintFilter(this.mTintFilter, state.mTint, state.mTintMode);
            changed = true;
        }
        return changed;
    }

    private final int $$robo$$android_graphics_drawable_VectorDrawable$getOpacity() {
        return this.getAlpha() == 0 ? -2 : -3;
    }

    private final int $$robo$$android_graphics_drawable_VectorDrawable$getIntrinsicWidth() {
        if (this.mDpiScaledDirty) {
            this.computeVectorSize();
        }
        return this.mDpiScaledWidth;
    }

    private final int $$robo$$android_graphics_drawable_VectorDrawable$getIntrinsicHeight() {
        if (this.mDpiScaledDirty) {
            this.computeVectorSize();
        }
        return this.mDpiScaledHeight;
    }

    private final Insets $$robo$$android_graphics_drawable_VectorDrawable$getOpticalInsets() {
        if (this.mDpiScaledDirty) {
            this.computeVectorSize();
        }
        return this.mDpiScaledInsets;
    }

    private final void $$robo$$android_graphics_drawable_VectorDrawable$computeVectorSize() {
        Insets opticalInsets = this.mVectorState.mOpticalInsets;
        int targetDensity = this.mTargetDensity;
        int sourceDensity = this.mVectorState.mDensity;
        if (targetDensity != sourceDensity) {
            this.mDpiScaledWidth = Drawable.scaleFromDensity(this.mVectorState.mBaseWidth, sourceDensity, targetDensity, true);
            this.mDpiScaledHeight = Drawable.scaleFromDensity(this.mVectorState.mBaseHeight, sourceDensity, targetDensity, true);
            int left = Drawable.scaleFromDensity(opticalInsets.left, sourceDensity, targetDensity, false);
            int right = Drawable.scaleFromDensity(opticalInsets.right, sourceDensity, targetDensity, false);
            int top = Drawable.scaleFromDensity(opticalInsets.top, sourceDensity, targetDensity, false);
            int bottom = Drawable.scaleFromDensity(opticalInsets.bottom, sourceDensity, targetDensity, false);
            this.mDpiScaledInsets = Insets.of(left, top, right, bottom);
        } else {
            this.mDpiScaledWidth = this.mVectorState.mBaseWidth;
            this.mDpiScaledHeight = this.mVectorState.mBaseHeight;
            this.mDpiScaledInsets = opticalInsets;
        }
        this.mDpiScaledDirty = false;
    }

    private final boolean $$robo$$android_graphics_drawable_VectorDrawable$canApplyTheme() {
        return this.mVectorState != null && this.mVectorState.canApplyTheme() || super.canApplyTheme();
    }

    private final void $$robo$$android_graphics_drawable_VectorDrawable$applyTheme(Resources.Theme t) {
        super.applyTheme(t);
        VectorDrawableState state = this.mVectorState;
        if (state == null) {
            return;
        }
        boolean changedDensity = this.mVectorState.setDensity(Drawable.resolveDensity(t.getResources(), 0));
        this.mDpiScaledDirty |= changedDensity;
        if (state.mThemeAttrs != null) {
            TypedArray a = t.resolveAttributes(state.mThemeAttrs, R.styleable.VectorDrawable);
            try {
                state.mCacheDirty = true;
                this.updateStateFromTypedArray(a);
            }
            catch (XmlPullParserException e) {
                throw new RuntimeException(e);
            }
            finally {
                a.recycle();
            }
            this.mDpiScaledDirty = true;
        }
        if (state.mTint != null && state.mTint.canApplyTheme()) {
            state.mTint = state.mTint.obtainForTheme(t);
        }
        if (this.mVectorState != null && this.mVectorState.canApplyTheme()) {
            this.mVectorState.applyTheme(t);
        }
        this.updateLocalState(t.getResources());
    }

    private final float $$robo$$android_graphics_drawable_VectorDrawable$getPixelSize() {
        if (this.mVectorState == null || this.mVectorState.mBaseWidth == 0 || this.mVectorState.mBaseHeight == 0 || this.mVectorState.mViewportHeight == 0.0f || this.mVectorState.mViewportWidth == 0.0f) {
            return 1.0f;
        }
        float intrinsicWidth = this.mVectorState.mBaseWidth;
        float intrinsicHeight = this.mVectorState.mBaseHeight;
        float viewportWidth = this.mVectorState.mViewportWidth;
        float viewportHeight = this.mVectorState.mViewportHeight;
        float scaleX = viewportWidth / intrinsicWidth;
        float scaleY = viewportHeight / intrinsicHeight;
        return Math.min(scaleX, scaleY);
    }

    private static final VectorDrawable $$robo$$android_graphics_drawable_VectorDrawable$create(Resources resources, int rid) {
        try {
            int type;
            XmlResourceParser parser = resources.getXml(rid);
            AttributeSet attrs = Xml.asAttributeSet(parser);
            while ((type = parser.next()) != 2 && type != 1) {
            }
            if (type != 2) {
                throw new XmlPullParserException("No start tag found");
            }
            VectorDrawable drawable2 = new VectorDrawable();
            drawable2.inflate(resources, parser, attrs);
            return drawable2;
        }
        catch (XmlPullParserException e) {
            Log.e(LOGTAG, "parser error", e);
        }
        catch (IOException e) {
            Log.e(LOGTAG, "parser error", e);
        }
        return null;
    }

    private final void $$robo$$android_graphics_drawable_VectorDrawable$inflate(Resources r, XmlPullParser parser, AttributeSet attrs, Resources.Theme theme) throws XmlPullParserException, IOException {
        if (this.mVectorState.mRootGroup != null || this.mVectorState.mNativeTree != null) {
            if (this.mVectorState.mRootGroup != null) {
                VMRuntime.getRuntime().registerNativeFree(this.mVectorState.mRootGroup.getNativeSize());
                this.mVectorState.mRootGroup.setTree(null);
            }
            this.mVectorState.mRootGroup = new VGroup();
            if (this.mVectorState.mNativeTree != null) {
                VMRuntime.getRuntime().registerNativeFree(316);
                this.mVectorState.mNativeTree.release();
            }
            this.mVectorState.createNativeTree(this.mVectorState.mRootGroup);
        }
        VectorDrawableState state = this.mVectorState;
        state.setDensity(Drawable.resolveDensity(r, 0));
        TypedArray a = VectorDrawable.obtainAttributes(r, theme, attrs, R.styleable.VectorDrawable);
        this.updateStateFromTypedArray(a);
        a.recycle();
        this.mDpiScaledDirty = true;
        state.mCacheDirty = true;
        this.inflateChildElements(r, parser, attrs, theme);
        state.onTreeConstructionFinished();
        this.updateLocalState(r);
    }

    private final void $$robo$$android_graphics_drawable_VectorDrawable$updateStateFromTypedArray(TypedArray a) throws XmlPullParserException {
        ColorStateList tint;
        VectorDrawableState state = this.mVectorState;
        state.mChangingConfigurations |= a.getChangingConfigurations();
        state.mThemeAttrs = a.extractThemeAttrs();
        int tintMode = a.getInt(6, -1);
        if (tintMode != -1) {
            state.mTintMode = Drawable.parseTintMode(tintMode, PorterDuff.Mode.SRC_IN);
        }
        if ((tint = a.getColorStateList(1)) != null) {
            state.mTint = tint;
        }
        state.mAutoMirrored = a.getBoolean(5, state.mAutoMirrored);
        float viewportWidth = a.getFloat(7, state.mViewportWidth);
        float viewportHeight = a.getFloat(8, state.mViewportHeight);
        state.setViewportSize(viewportWidth, viewportHeight);
        if (state.mViewportWidth <= 0.0f) {
            throw new XmlPullParserException(a.getPositionDescription() + "<vector> tag requires viewportWidth > 0");
        }
        if (state.mViewportHeight <= 0.0f) {
            throw new XmlPullParserException(a.getPositionDescription() + "<vector> tag requires viewportHeight > 0");
        }
        state.mBaseWidth = a.getDimensionPixelSize(3, state.mBaseWidth);
        state.mBaseHeight = a.getDimensionPixelSize(2, state.mBaseHeight);
        if (state.mBaseWidth <= 0) {
            throw new XmlPullParserException(a.getPositionDescription() + "<vector> tag requires width > 0");
        }
        if (state.mBaseHeight <= 0) {
            throw new XmlPullParserException(a.getPositionDescription() + "<vector> tag requires height > 0");
        }
        int insetLeft = a.getDimensionPixelOffset(10, state.mOpticalInsets.left);
        int insetTop = a.getDimensionPixelOffset(12, state.mOpticalInsets.top);
        int insetRight = a.getDimensionPixelOffset(11, state.mOpticalInsets.right);
        int insetBottom = a.getDimensionPixelOffset(9, state.mOpticalInsets.bottom);
        state.mOpticalInsets = Insets.of(insetLeft, insetTop, insetRight, insetBottom);
        float alphaInFloat = a.getFloat(4, state.getAlpha());
        state.setAlpha(alphaInFloat);
        String name = a.getString(0);
        if (name != null) {
            state.mRootName = name;
            state.mVGTargetsMap.put(name, state);
        }
    }

    private final void $$robo$$android_graphics_drawable_VectorDrawable$inflateChildElements(Resources res, XmlPullParser parser, AttributeSet attrs, Resources.Theme theme) throws XmlPullParserException, IOException {
        VectorDrawableState state = this.mVectorState;
        boolean noPathTag = true;
        Stack<VGroup> groupStack = new Stack<VGroup>();
        groupStack.push(state.mRootGroup);
        int eventType = parser.getEventType();
        int innerDepth = parser.getDepth() + 1;
        while (eventType != 1 && (parser.getDepth() >= innerDepth || eventType != 3)) {
            String tagName;
            if (eventType == 2) {
                VPath path;
                tagName = parser.getName();
                VGroup currentGroup = (VGroup)groupStack.peek();
                if ("path".equals(tagName)) {
                    path = new VFullPath();
                    ((VFullPath)path).inflate(res, attrs, theme);
                    currentGroup.addChild(path);
                    if (path.getPathName() != null) {
                        state.mVGTargetsMap.put(path.getPathName(), path);
                    }
                    noPathTag = false;
                    state.mChangingConfigurations |= ((VFullPath)path).mChangingConfigurations;
                } else if ("clip-path".equals(tagName)) {
                    path = new VClipPath();
                    ((VClipPath)path).inflate(res, attrs, theme);
                    currentGroup.addChild(path);
                    if (path.getPathName() != null) {
                        state.mVGTargetsMap.put(path.getPathName(), path);
                    }
                    state.mChangingConfigurations |= ((VClipPath)path).mChangingConfigurations;
                } else if ("group".equals(tagName)) {
                    VGroup newChildGroup = new VGroup();
                    newChildGroup.inflate(res, attrs, theme);
                    currentGroup.addChild(newChildGroup);
                    groupStack.push(newChildGroup);
                    if (newChildGroup.getGroupName() != null) {
                        state.mVGTargetsMap.put(newChildGroup.getGroupName(), newChildGroup);
                    }
                    state.mChangingConfigurations |= newChildGroup.mChangingConfigurations;
                }
            } else if (eventType == 3 && "group".equals(tagName = parser.getName())) {
                groupStack.pop();
            }
            eventType = parser.next();
        }
        if (noPathTag) {
            StringBuffer tag = new StringBuffer();
            if (tag.length() > 0) {
                tag.append(" or ");
            }
            tag.append("path");
            throw new XmlPullParserException("no " + tag + " defined");
        }
    }

    private final int $$robo$$android_graphics_drawable_VectorDrawable$getChangingConfigurations() {
        return super.getChangingConfigurations() | this.mVectorState.getChangingConfigurations();
    }

    private final void $$robo$$android_graphics_drawable_VectorDrawable$setAllowCaching(boolean allowCaching) {
        VectorDrawable.nSetAllowCaching(this.mVectorState.getNativeRenderer(), allowCaching);
    }

    private final boolean $$robo$$android_graphics_drawable_VectorDrawable$needMirroring() {
        return this.isAutoMirrored() && this.getLayoutDirection() == 1;
    }

    private final void $$robo$$android_graphics_drawable_VectorDrawable$setAutoMirrored(boolean mirrored) {
        if (this.mVectorState.mAutoMirrored != mirrored) {
            this.mVectorState.mAutoMirrored = mirrored;
            this.invalidateSelf();
        }
    }

    private final boolean $$robo$$android_graphics_drawable_VectorDrawable$isAutoMirrored() {
        return this.mVectorState.mAutoMirrored;
    }

    private final long $$robo$$android_graphics_drawable_VectorDrawable$getNativeTree() {
        return this.mVectorState.getNativeRenderer();
    }

    private static final int $$robo$$android_graphics_drawable_VectorDrawable$nDraw(long l, long l2, long l3, Rect rect, boolean bl, boolean bl2) {
        return 0;
    }

    private static final boolean $$robo$$android_graphics_drawable_VectorDrawable$nGetFullPathProperties(long l, byte[] byArray, int n) {
        return false;
    }

    private static final void $$robo$$android_graphics_drawable_VectorDrawable$nSetName(long l, String string2) {
    }

    private static final boolean $$robo$$android_graphics_drawable_VectorDrawable$nGetGroupProperties(long l, float[] fArray, int n) {
        return false;
    }

    private static final void $$robo$$android_graphics_drawable_VectorDrawable$nSetPathString(long l, String string2, int n) {
    }

    @FastNative
    private static final long $$robo$$android_graphics_drawable_VectorDrawable$nCreateTree(long l) {
        return 0L;
    }

    @FastNative
    private static final long $$robo$$android_graphics_drawable_VectorDrawable$nCreateTreeFromCopy(long l, long l2) {
        return 0L;
    }

    @FastNative
    private static final void $$robo$$android_graphics_drawable_VectorDrawable$nSetRendererViewportSize(long l, float f, float f2) {
    }

    @FastNative
    private static final boolean $$robo$$android_graphics_drawable_VectorDrawable$nSetRootAlpha(long l, float f) {
        return false;
    }

    @FastNative
    private static final float $$robo$$android_graphics_drawable_VectorDrawable$nGetRootAlpha(long l) {
        return 0.0f;
    }

    @FastNative
    private static final void $$robo$$android_graphics_drawable_VectorDrawable$nSetAllowCaching(long l, boolean bl) {
    }

    @FastNative
    private static final long $$robo$$android_graphics_drawable_VectorDrawable$nCreateFullPath() {
        return 0L;
    }

    @FastNative
    private static final long $$robo$$android_graphics_drawable_VectorDrawable$nCreateFullPath(long l) {
        return 0L;
    }

    @FastNative
    private static final void $$robo$$android_graphics_drawable_VectorDrawable$nUpdateFullPathProperties(long l, float f, int n, float f2, int n2, float f3, float f4, float f5, float f6, float f7, int n3, int n4, int n5) {
    }

    @FastNative
    private static final void $$robo$$android_graphics_drawable_VectorDrawable$nUpdateFullPathFillGradient(long l, long l2) {
    }

    @FastNative
    private static final void $$robo$$android_graphics_drawable_VectorDrawable$nUpdateFullPathStrokeGradient(long l, long l2) {
    }

    @FastNative
    private static final long $$robo$$android_graphics_drawable_VectorDrawable$nCreateClipPath() {
        return 0L;
    }

    @FastNative
    private static final long $$robo$$android_graphics_drawable_VectorDrawable$nCreateClipPath(long l) {
        return 0L;
    }

    @FastNative
    private static final long $$robo$$android_graphics_drawable_VectorDrawable$nCreateGroup() {
        return 0L;
    }

    @FastNative
    private static final long $$robo$$android_graphics_drawable_VectorDrawable$nCreateGroup(long l) {
        return 0L;
    }

    @FastNative
    private static final void $$robo$$android_graphics_drawable_VectorDrawable$nUpdateGroupProperties(long l, float f, float f2, float f3, float f4, float f5, float f6, float f7) {
    }

    @FastNative
    private static final void $$robo$$android_graphics_drawable_VectorDrawable$nAddChild(long l, long l2) {
    }

    @FastNative
    private static final float $$robo$$android_graphics_drawable_VectorDrawable$nGetRotation(long l) {
        return 0.0f;
    }

    @FastNative
    private static final void $$robo$$android_graphics_drawable_VectorDrawable$nSetRotation(long l, float f) {
    }

    @FastNative
    private static final float $$robo$$android_graphics_drawable_VectorDrawable$nGetPivotX(long l) {
        return 0.0f;
    }

    @FastNative
    private static final void $$robo$$android_graphics_drawable_VectorDrawable$nSetPivotX(long l, float f) {
    }

    @FastNative
    private static final float $$robo$$android_graphics_drawable_VectorDrawable$nGetPivotY(long l) {
        return 0.0f;
    }

    @FastNative
    private static final void $$robo$$android_graphics_drawable_VectorDrawable$nSetPivotY(long l, float f) {
    }

    @FastNative
    private static final float $$robo$$android_graphics_drawable_VectorDrawable$nGetScaleX(long l) {
        return 0.0f;
    }

    @FastNative
    private static final void $$robo$$android_graphics_drawable_VectorDrawable$nSetScaleX(long l, float f) {
    }

    @FastNative
    private static final float $$robo$$android_graphics_drawable_VectorDrawable$nGetScaleY(long l) {
        return 0.0f;
    }

    @FastNative
    private static final void $$robo$$android_graphics_drawable_VectorDrawable$nSetScaleY(long l, float f) {
    }

    @FastNative
    private static final float $$robo$$android_graphics_drawable_VectorDrawable$nGetTranslateX(long l) {
        return 0.0f;
    }

    @FastNative
    private static final void $$robo$$android_graphics_drawable_VectorDrawable$nSetTranslateX(long l, float f) {
    }

    @FastNative
    private static final float $$robo$$android_graphics_drawable_VectorDrawable$nGetTranslateY(long l) {
        return 0.0f;
    }

    @FastNative
    private static final void $$robo$$android_graphics_drawable_VectorDrawable$nSetTranslateY(long l, float f) {
    }

    @FastNative
    private static final void $$robo$$android_graphics_drawable_VectorDrawable$nSetPathData(long l, long l2) {
    }

    @FastNative
    private static final float $$robo$$android_graphics_drawable_VectorDrawable$nGetStrokeWidth(long l) {
        return 0.0f;
    }

    @FastNative
    private static final void $$robo$$android_graphics_drawable_VectorDrawable$nSetStrokeWidth(long l, float f) {
    }

    @FastNative
    private static final int $$robo$$android_graphics_drawable_VectorDrawable$nGetStrokeColor(long l) {
        return 0;
    }

    @FastNative
    private static final void $$robo$$android_graphics_drawable_VectorDrawable$nSetStrokeColor(long l, int n) {
    }

    @FastNative
    private static final float $$robo$$android_graphics_drawable_VectorDrawable$nGetStrokeAlpha(long l) {
        return 0.0f;
    }

    @FastNative
    private static final void $$robo$$android_graphics_drawable_VectorDrawable$nSetStrokeAlpha(long l, float f) {
    }

    @FastNative
    private static final int $$robo$$android_graphics_drawable_VectorDrawable$nGetFillColor(long l) {
        return 0;
    }

    @FastNative
    private static final void $$robo$$android_graphics_drawable_VectorDrawable$nSetFillColor(long l, int n) {
    }

    @FastNative
    private static final float $$robo$$android_graphics_drawable_VectorDrawable$nGetFillAlpha(long l) {
        return 0.0f;
    }

    @FastNative
    private static final void $$robo$$android_graphics_drawable_VectorDrawable$nSetFillAlpha(long l, float f) {
    }

    @FastNative
    private static final float $$robo$$android_graphics_drawable_VectorDrawable$nGetTrimPathStart(long l) {
        return 0.0f;
    }

    @FastNative
    private static final void $$robo$$android_graphics_drawable_VectorDrawable$nSetTrimPathStart(long l, float f) {
    }

    @FastNative
    private static final float $$robo$$android_graphics_drawable_VectorDrawable$nGetTrimPathEnd(long l) {
        return 0.0f;
    }

    @FastNative
    private static final void $$robo$$android_graphics_drawable_VectorDrawable$nSetTrimPathEnd(long l, float f) {
    }

    @FastNative
    private static final float $$robo$$android_graphics_drawable_VectorDrawable$nGetTrimPathOffset(long l) {
        return 0.0f;
    }

    @FastNative
    private static final void $$robo$$android_graphics_drawable_VectorDrawable$nSetTrimPathOffset(long l, float f) {
    }

    private /* synthetic */ void $$robo$$android_graphics_drawable_VectorDrawable$__constructor__(VectorDrawableState x0, Resources x1, 1 x2) {
    }

    static void __staticInitializer__() {
        LOGTAG = VectorDrawable.class.getSimpleName();
    }

    private void __constructor__() {
        this.$$robo$$android_graphics_drawable_VectorDrawable$__constructor__();
    }

    public VectorDrawable() {
        this(new VectorDrawableState(null), null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_VectorDrawable$__constructor__(), this);
    }

    private void __constructor__(VectorDrawableState vectorDrawableState, Resources resources) {
        this.$$robo$$android_graphics_drawable_VectorDrawable$__constructor__(vectorDrawableState, resources);
    }

    public VectorDrawable(VectorDrawableState vectorDrawableState, Resources resources) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_VectorDrawable$__constructor__(android.graphics.drawable.VectorDrawable$VectorDrawableState android.content.res.Resources ), this, vectorDrawableState, resources);
    }

    private void updateLocalState(Resources resources) {
        InvokeDynamicSupport.bootstrap("updateLocalState", $$robo$$android_graphics_drawable_VectorDrawable$updateLocalState(android.content.res.Resources ), this, resources);
    }

    @Override
    public Drawable mutate() {
        return InvokeDynamicSupport.bootstrap("mutate", $$robo$$android_graphics_drawable_VectorDrawable$mutate(), this);
    }

    @Override
    public void clearMutated() {
        InvokeDynamicSupport.bootstrap("clearMutated", $$robo$$android_graphics_drawable_VectorDrawable$clearMutated(), this);
    }

    Object getTargetByName(String string2) {
        return InvokeDynamicSupport.bootstrap("getTargetByName", $$robo$$android_graphics_drawable_VectorDrawable$getTargetByName(java.lang.String ), this, string2);
    }

    @Override
    public Drawable.ConstantState getConstantState() {
        return InvokeDynamicSupport.bootstrap("getConstantState", $$robo$$android_graphics_drawable_VectorDrawable$getConstantState(), this);
    }

    @Override
    public void draw(Canvas canvas) {
        InvokeDynamicSupport.bootstrap("draw", $$robo$$android_graphics_drawable_VectorDrawable$draw(android.graphics.Canvas ), this, canvas);
    }

    @Override
    public int getAlpha() {
        return (int)InvokeDynamicSupport.bootstrap("getAlpha", $$robo$$android_graphics_drawable_VectorDrawable$getAlpha(), this);
    }

    @Override
    public void setAlpha(int n) {
        InvokeDynamicSupport.bootstrap("setAlpha", $$robo$$android_graphics_drawable_VectorDrawable$setAlpha(int ), this, n);
    }

    @Override
    public void setColorFilter(ColorFilter colorFilter) {
        InvokeDynamicSupport.bootstrap("setColorFilter", $$robo$$android_graphics_drawable_VectorDrawable$setColorFilter(android.graphics.ColorFilter ), this, colorFilter);
    }

    @Override
    public ColorFilter getColorFilter() {
        return InvokeDynamicSupport.bootstrap("getColorFilter", $$robo$$android_graphics_drawable_VectorDrawable$getColorFilter(), this);
    }

    @Override
    public void setTintList(ColorStateList colorStateList) {
        InvokeDynamicSupport.bootstrap("setTintList", $$robo$$android_graphics_drawable_VectorDrawable$setTintList(android.content.res.ColorStateList ), this, colorStateList);
    }

    @Override
    public void setTintMode(PorterDuff.Mode mode) {
        InvokeDynamicSupport.bootstrap("setTintMode", $$robo$$android_graphics_drawable_VectorDrawable$setTintMode(android.graphics.PorterDuff$Mode ), this, mode);
    }

    @Override
    public boolean isStateful() {
        return (boolean)InvokeDynamicSupport.bootstrap("isStateful", $$robo$$android_graphics_drawable_VectorDrawable$isStateful(), this);
    }

    @Override
    public boolean hasFocusStateSpecified() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasFocusStateSpecified", $$robo$$android_graphics_drawable_VectorDrawable$hasFocusStateSpecified(), this);
    }

    @Override
    protected boolean onStateChange(int[] nArray) {
        return (boolean)InvokeDynamicSupport.bootstrap("onStateChange", $$robo$$android_graphics_drawable_VectorDrawable$onStateChange(int[] ), this, nArray);
    }

    @Override
    public int getOpacity() {
        return (int)InvokeDynamicSupport.bootstrap("getOpacity", $$robo$$android_graphics_drawable_VectorDrawable$getOpacity(), this);
    }

    @Override
    public int getIntrinsicWidth() {
        return (int)InvokeDynamicSupport.bootstrap("getIntrinsicWidth", $$robo$$android_graphics_drawable_VectorDrawable$getIntrinsicWidth(), this);
    }

    @Override
    public int getIntrinsicHeight() {
        return (int)InvokeDynamicSupport.bootstrap("getIntrinsicHeight", $$robo$$android_graphics_drawable_VectorDrawable$getIntrinsicHeight(), this);
    }

    @Override
    public Insets getOpticalInsets() {
        return InvokeDynamicSupport.bootstrap("getOpticalInsets", $$robo$$android_graphics_drawable_VectorDrawable$getOpticalInsets(), this);
    }

    void computeVectorSize() {
        InvokeDynamicSupport.bootstrap("computeVectorSize", $$robo$$android_graphics_drawable_VectorDrawable$computeVectorSize(), this);
    }

    @Override
    public boolean canApplyTheme() {
        return (boolean)InvokeDynamicSupport.bootstrap("canApplyTheme", $$robo$$android_graphics_drawable_VectorDrawable$canApplyTheme(), this);
    }

    @Override
    public void applyTheme(Resources.Theme theme) {
        InvokeDynamicSupport.bootstrap("applyTheme", $$robo$$android_graphics_drawable_VectorDrawable$applyTheme(android.content.res.Resources$Theme ), this, theme);
    }

    public float getPixelSize() {
        return (float)InvokeDynamicSupport.bootstrap("getPixelSize", $$robo$$android_graphics_drawable_VectorDrawable$getPixelSize(), this);
    }

    public static VectorDrawable create(Resources resources, int n) {
        return InvokeDynamicSupport.bootstrapStatic("create", $$robo$$android_graphics_drawable_VectorDrawable$create(android.content.res.Resources int ), (Resources)resources, (int)n);
    }

    @Override
    public void inflate(Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, Resources.Theme theme) throws XmlPullParserException, IOException {
        InvokeDynamicSupport.bootstrap("inflate", $$robo$$android_graphics_drawable_VectorDrawable$inflate(android.content.res.Resources org.xmlpull.v1.XmlPullParser android.util.AttributeSet android.content.res.Resources$Theme ), this, resources, xmlPullParser, attributeSet, theme);
    }

    private void updateStateFromTypedArray(TypedArray typedArray) throws XmlPullParserException {
        InvokeDynamicSupport.bootstrap("updateStateFromTypedArray", $$robo$$android_graphics_drawable_VectorDrawable$updateStateFromTypedArray(android.content.res.TypedArray ), this, typedArray);
    }

    private void inflateChildElements(Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, Resources.Theme theme) throws XmlPullParserException, IOException {
        InvokeDynamicSupport.bootstrap("inflateChildElements", $$robo$$android_graphics_drawable_VectorDrawable$inflateChildElements(android.content.res.Resources org.xmlpull.v1.XmlPullParser android.util.AttributeSet android.content.res.Resources$Theme ), this, resources, xmlPullParser, attributeSet, theme);
    }

    @Override
    public int getChangingConfigurations() {
        return (int)InvokeDynamicSupport.bootstrap("getChangingConfigurations", $$robo$$android_graphics_drawable_VectorDrawable$getChangingConfigurations(), this);
    }

    void setAllowCaching(boolean bl) {
        InvokeDynamicSupport.bootstrap("setAllowCaching", $$robo$$android_graphics_drawable_VectorDrawable$setAllowCaching(boolean ), this, bl);
    }

    private boolean needMirroring() {
        return (boolean)InvokeDynamicSupport.bootstrap("needMirroring", $$robo$$android_graphics_drawable_VectorDrawable$needMirroring(), this);
    }

    @Override
    public void setAutoMirrored(boolean bl) {
        InvokeDynamicSupport.bootstrap("setAutoMirrored", $$robo$$android_graphics_drawable_VectorDrawable$setAutoMirrored(boolean ), this, bl);
    }

    @Override
    public boolean isAutoMirrored() {
        return (boolean)InvokeDynamicSupport.bootstrap("isAutoMirrored", $$robo$$android_graphics_drawable_VectorDrawable$isAutoMirrored(), this);
    }

    public long getNativeTree() {
        return (long)InvokeDynamicSupport.bootstrap("getNativeTree", $$robo$$android_graphics_drawable_VectorDrawable$getNativeTree(), this);
    }

    private static int nDraw(long l, long l2, long l3, Rect rect, boolean bl, boolean bl2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("nDraw", $$robo$$android_graphics_drawable_VectorDrawable$nDraw(long long long android.graphics.Rect boolean boolean ), (long)l, (long)l2, (long)l3, (Rect)rect, (boolean)bl, (boolean)bl2);
    }

    private static boolean nGetFullPathProperties(long l, byte[] byArray, int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("nGetFullPathProperties", $$robo$$android_graphics_drawable_VectorDrawable$nGetFullPathProperties(long byte[] int ), (long)l, (byte[])byArray, (int)n);
    }

    private static void nSetName(long l, String string2) {
        InvokeDynamicSupport.bootstrapStatic("nSetName", $$robo$$android_graphics_drawable_VectorDrawable$nSetName(long java.lang.String ), (long)l, (String)string2);
    }

    private static boolean nGetGroupProperties(long l, float[] fArray, int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("nGetGroupProperties", $$robo$$android_graphics_drawable_VectorDrawable$nGetGroupProperties(long float[] int ), (long)l, (float[])fArray, (int)n);
    }

    private static void nSetPathString(long l, String string2, int n) {
        InvokeDynamicSupport.bootstrapStatic("nSetPathString", $$robo$$android_graphics_drawable_VectorDrawable$nSetPathString(long java.lang.String int ), (long)l, (String)string2, (int)n);
    }

    private static long nCreateTree(long l) {
        return (long)InvokeDynamicSupport.bootstrapStatic("nCreateTree", $$robo$$android_graphics_drawable_VectorDrawable$nCreateTree(long ), (long)l);
    }

    private static long nCreateTreeFromCopy(long l, long l2) {
        return (long)InvokeDynamicSupport.bootstrapStatic("nCreateTreeFromCopy", $$robo$$android_graphics_drawable_VectorDrawable$nCreateTreeFromCopy(long long ), (long)l, (long)l2);
    }

    private static void nSetRendererViewportSize(long l, float f, float f2) {
        InvokeDynamicSupport.bootstrapStatic("nSetRendererViewportSize", $$robo$$android_graphics_drawable_VectorDrawable$nSetRendererViewportSize(long float float ), (long)l, (float)f, (float)f2);
    }

    private static boolean nSetRootAlpha(long l, float f) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("nSetRootAlpha", $$robo$$android_graphics_drawable_VectorDrawable$nSetRootAlpha(long float ), (long)l, (float)f);
    }

    private static float nGetRootAlpha(long l) {
        return (float)InvokeDynamicSupport.bootstrapStatic("nGetRootAlpha", $$robo$$android_graphics_drawable_VectorDrawable$nGetRootAlpha(long ), (long)l);
    }

    private static void nSetAllowCaching(long l, boolean bl) {
        InvokeDynamicSupport.bootstrapStatic("nSetAllowCaching", $$robo$$android_graphics_drawable_VectorDrawable$nSetAllowCaching(long boolean ), (long)l, (boolean)bl);
    }

    private static long nCreateFullPath() {
        return (long)InvokeDynamicSupport.bootstrapStatic("nCreateFullPath", $$robo$$android_graphics_drawable_VectorDrawable$nCreateFullPath());
    }

    private static long nCreateFullPath(long l) {
        return (long)InvokeDynamicSupport.bootstrapStatic("nCreateFullPath", $$robo$$android_graphics_drawable_VectorDrawable$nCreateFullPath(long ), (long)l);
    }

    private static void nUpdateFullPathProperties(long l, float f, int n, float f2, int n2, float f3, float f4, float f5, float f6, float f7, int n3, int n4, int n5) {
        InvokeDynamicSupport.bootstrapStatic("nUpdateFullPathProperties", $$robo$$android_graphics_drawable_VectorDrawable$nUpdateFullPathProperties(long float int float int float float float float float int int int ), (long)l, (float)f, (int)n, (float)f2, (int)n2, (float)f3, (float)f4, (float)f5, (float)f6, (float)f7, (int)n3, (int)n4, (int)n5);
    }

    private static void nUpdateFullPathFillGradient(long l, long l2) {
        InvokeDynamicSupport.bootstrapStatic("nUpdateFullPathFillGradient", $$robo$$android_graphics_drawable_VectorDrawable$nUpdateFullPathFillGradient(long long ), (long)l, (long)l2);
    }

    private static void nUpdateFullPathStrokeGradient(long l, long l2) {
        InvokeDynamicSupport.bootstrapStatic("nUpdateFullPathStrokeGradient", $$robo$$android_graphics_drawable_VectorDrawable$nUpdateFullPathStrokeGradient(long long ), (long)l, (long)l2);
    }

    private static long nCreateClipPath() {
        return (long)InvokeDynamicSupport.bootstrapStatic("nCreateClipPath", $$robo$$android_graphics_drawable_VectorDrawable$nCreateClipPath());
    }

    private static long nCreateClipPath(long l) {
        return (long)InvokeDynamicSupport.bootstrapStatic("nCreateClipPath", $$robo$$android_graphics_drawable_VectorDrawable$nCreateClipPath(long ), (long)l);
    }

    private static long nCreateGroup() {
        return (long)InvokeDynamicSupport.bootstrapStatic("nCreateGroup", $$robo$$android_graphics_drawable_VectorDrawable$nCreateGroup());
    }

    private static long nCreateGroup(long l) {
        return (long)InvokeDynamicSupport.bootstrapStatic("nCreateGroup", $$robo$$android_graphics_drawable_VectorDrawable$nCreateGroup(long ), (long)l);
    }

    private static void nUpdateGroupProperties(long l, float f, float f2, float f3, float f4, float f5, float f6, float f7) {
        InvokeDynamicSupport.bootstrapStatic("nUpdateGroupProperties", $$robo$$android_graphics_drawable_VectorDrawable$nUpdateGroupProperties(long float float float float float float float ), (long)l, (float)f, (float)f2, (float)f3, (float)f4, (float)f5, (float)f6, (float)f7);
    }

    private static void nAddChild(long l, long l2) {
        InvokeDynamicSupport.bootstrapStatic("nAddChild", $$robo$$android_graphics_drawable_VectorDrawable$nAddChild(long long ), (long)l, (long)l2);
    }

    private static float nGetRotation(long l) {
        return (float)InvokeDynamicSupport.bootstrapStatic("nGetRotation", $$robo$$android_graphics_drawable_VectorDrawable$nGetRotation(long ), (long)l);
    }

    private static void nSetRotation(long l, float f) {
        InvokeDynamicSupport.bootstrapStatic("nSetRotation", $$robo$$android_graphics_drawable_VectorDrawable$nSetRotation(long float ), (long)l, (float)f);
    }

    private static float nGetPivotX(long l) {
        return (float)InvokeDynamicSupport.bootstrapStatic("nGetPivotX", $$robo$$android_graphics_drawable_VectorDrawable$nGetPivotX(long ), (long)l);
    }

    private static void nSetPivotX(long l, float f) {
        InvokeDynamicSupport.bootstrapStatic("nSetPivotX", $$robo$$android_graphics_drawable_VectorDrawable$nSetPivotX(long float ), (long)l, (float)f);
    }

    private static float nGetPivotY(long l) {
        return (float)InvokeDynamicSupport.bootstrapStatic("nGetPivotY", $$robo$$android_graphics_drawable_VectorDrawable$nGetPivotY(long ), (long)l);
    }

    private static void nSetPivotY(long l, float f) {
        InvokeDynamicSupport.bootstrapStatic("nSetPivotY", $$robo$$android_graphics_drawable_VectorDrawable$nSetPivotY(long float ), (long)l, (float)f);
    }

    private static float nGetScaleX(long l) {
        return (float)InvokeDynamicSupport.bootstrapStatic("nGetScaleX", $$robo$$android_graphics_drawable_VectorDrawable$nGetScaleX(long ), (long)l);
    }

    private static void nSetScaleX(long l, float f) {
        InvokeDynamicSupport.bootstrapStatic("nSetScaleX", $$robo$$android_graphics_drawable_VectorDrawable$nSetScaleX(long float ), (long)l, (float)f);
    }

    private static float nGetScaleY(long l) {
        return (float)InvokeDynamicSupport.bootstrapStatic("nGetScaleY", $$robo$$android_graphics_drawable_VectorDrawable$nGetScaleY(long ), (long)l);
    }

    private static void nSetScaleY(long l, float f) {
        InvokeDynamicSupport.bootstrapStatic("nSetScaleY", $$robo$$android_graphics_drawable_VectorDrawable$nSetScaleY(long float ), (long)l, (float)f);
    }

    private static float nGetTranslateX(long l) {
        return (float)InvokeDynamicSupport.bootstrapStatic("nGetTranslateX", $$robo$$android_graphics_drawable_VectorDrawable$nGetTranslateX(long ), (long)l);
    }

    private static void nSetTranslateX(long l, float f) {
        InvokeDynamicSupport.bootstrapStatic("nSetTranslateX", $$robo$$android_graphics_drawable_VectorDrawable$nSetTranslateX(long float ), (long)l, (float)f);
    }

    private static float nGetTranslateY(long l) {
        return (float)InvokeDynamicSupport.bootstrapStatic("nGetTranslateY", $$robo$$android_graphics_drawable_VectorDrawable$nGetTranslateY(long ), (long)l);
    }

    private static void nSetTranslateY(long l, float f) {
        InvokeDynamicSupport.bootstrapStatic("nSetTranslateY", $$robo$$android_graphics_drawable_VectorDrawable$nSetTranslateY(long float ), (long)l, (float)f);
    }

    private static void nSetPathData(long l, long l2) {
        InvokeDynamicSupport.bootstrapStatic("nSetPathData", $$robo$$android_graphics_drawable_VectorDrawable$nSetPathData(long long ), (long)l, (long)l2);
    }

    private static float nGetStrokeWidth(long l) {
        return (float)InvokeDynamicSupport.bootstrapStatic("nGetStrokeWidth", $$robo$$android_graphics_drawable_VectorDrawable$nGetStrokeWidth(long ), (long)l);
    }

    private static void nSetStrokeWidth(long l, float f) {
        InvokeDynamicSupport.bootstrapStatic("nSetStrokeWidth", $$robo$$android_graphics_drawable_VectorDrawable$nSetStrokeWidth(long float ), (long)l, (float)f);
    }

    private static int nGetStrokeColor(long l) {
        return (int)InvokeDynamicSupport.bootstrapStatic("nGetStrokeColor", $$robo$$android_graphics_drawable_VectorDrawable$nGetStrokeColor(long ), (long)l);
    }

    private static void nSetStrokeColor(long l, int n) {
        InvokeDynamicSupport.bootstrapStatic("nSetStrokeColor", $$robo$$android_graphics_drawable_VectorDrawable$nSetStrokeColor(long int ), (long)l, (int)n);
    }

    private static float nGetStrokeAlpha(long l) {
        return (float)InvokeDynamicSupport.bootstrapStatic("nGetStrokeAlpha", $$robo$$android_graphics_drawable_VectorDrawable$nGetStrokeAlpha(long ), (long)l);
    }

    private static void nSetStrokeAlpha(long l, float f) {
        InvokeDynamicSupport.bootstrapStatic("nSetStrokeAlpha", $$robo$$android_graphics_drawable_VectorDrawable$nSetStrokeAlpha(long float ), (long)l, (float)f);
    }

    private static int nGetFillColor(long l) {
        return (int)InvokeDynamicSupport.bootstrapStatic("nGetFillColor", $$robo$$android_graphics_drawable_VectorDrawable$nGetFillColor(long ), (long)l);
    }

    private static void nSetFillColor(long l, int n) {
        InvokeDynamicSupport.bootstrapStatic("nSetFillColor", $$robo$$android_graphics_drawable_VectorDrawable$nSetFillColor(long int ), (long)l, (int)n);
    }

    private static float nGetFillAlpha(long l) {
        return (float)InvokeDynamicSupport.bootstrapStatic("nGetFillAlpha", $$robo$$android_graphics_drawable_VectorDrawable$nGetFillAlpha(long ), (long)l);
    }

    private static void nSetFillAlpha(long l, float f) {
        InvokeDynamicSupport.bootstrapStatic("nSetFillAlpha", $$robo$$android_graphics_drawable_VectorDrawable$nSetFillAlpha(long float ), (long)l, (float)f);
    }

    private static float nGetTrimPathStart(long l) {
        return (float)InvokeDynamicSupport.bootstrapStatic("nGetTrimPathStart", $$robo$$android_graphics_drawable_VectorDrawable$nGetTrimPathStart(long ), (long)l);
    }

    private static void nSetTrimPathStart(long l, float f) {
        InvokeDynamicSupport.bootstrapStatic("nSetTrimPathStart", $$robo$$android_graphics_drawable_VectorDrawable$nSetTrimPathStart(long float ), (long)l, (float)f);
    }

    private static float nGetTrimPathEnd(long l) {
        return (float)InvokeDynamicSupport.bootstrapStatic("nGetTrimPathEnd", $$robo$$android_graphics_drawable_VectorDrawable$nGetTrimPathEnd(long ), (long)l);
    }

    private static void nSetTrimPathEnd(long l, float f) {
        InvokeDynamicSupport.bootstrapStatic("nSetTrimPathEnd", $$robo$$android_graphics_drawable_VectorDrawable$nSetTrimPathEnd(long float ), (long)l, (float)f);
    }

    private static float nGetTrimPathOffset(long l) {
        return (float)InvokeDynamicSupport.bootstrapStatic("nGetTrimPathOffset", $$robo$$android_graphics_drawable_VectorDrawable$nGetTrimPathOffset(long ), (long)l);
    }

    private static void nSetTrimPathOffset(long l, float f) {
        InvokeDynamicSupport.bootstrapStatic("nSetTrimPathOffset", $$robo$$android_graphics_drawable_VectorDrawable$nSetTrimPathOffset(long float ), (long)l, (float)f);
    }

    private /* synthetic */ void __constructor__(VectorDrawableState vectorDrawableState, Resources resources, 1 var3_3) {
        this.$$robo$$android_graphics_drawable_VectorDrawable$__constructor__(vectorDrawableState, resources, var3_3);
    }

    public /* synthetic */ VectorDrawable(VectorDrawableState vectorDrawableState, Resources resources, 1 var3_3) {
        this(vectorDrawableState, resources);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_VectorDrawable$__constructor__(android.graphics.drawable.VectorDrawable$VectorDrawableState android.content.res.Resources android.graphics.drawable.VectorDrawable$1 ), this, vectorDrawableState, resources, var3_3);
    }

    static {
        RobolectricInternals.classInitializing(VectorDrawable.class);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (VectorDrawable)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static abstract class VObject
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        VirtualRefBasePtr mTreePtr;

        private void $$robo$$android_graphics_drawable_VectorDrawable_VObject$__constructor__() {
            this.mTreePtr = null;
        }

        private final boolean $$robo$$android_graphics_drawable_VectorDrawable_VObject$isTreeValid() {
            return this.mTreePtr != null && this.mTreePtr.get() != 0L;
        }

        private final void $$robo$$android_graphics_drawable_VectorDrawable_VObject$setTree(VirtualRefBasePtr ptr) {
            this.mTreePtr = ptr;
        }

        abstract long getNativePtr();

        abstract void inflate(Resources var1, AttributeSet var2, Resources.Theme var3);

        abstract boolean canApplyTheme();

        abstract void applyTheme(Resources.Theme var1);

        abstract boolean onStateChange(int[] var1);

        abstract boolean isStateful();

        abstract boolean hasFocusStateSpecified();

        abstract int getNativeSize();

        abstract Property getProperty(String var1);

        private void __constructor__() {
            this.$$robo$$android_graphics_drawable_VectorDrawable_VObject$__constructor__();
        }

        public VObject() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_VectorDrawable_VObject$__constructor__(), this);
        }

        boolean isTreeValid() {
            return (boolean)InvokeDynamicSupport.bootstrap("isTreeValid", $$robo$$android_graphics_drawable_VectorDrawable_VObject$isTreeValid(), this);
        }

        void setTree(VirtualRefBasePtr virtualRefBasePtr) {
            InvokeDynamicSupport.bootstrap("setTree", $$robo$$android_graphics_drawable_VectorDrawable_VObject$setTree(com.android.internal.util.VirtualRefBasePtr ), this, virtualRefBasePtr);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (VObject)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class VFullPath
    extends VPath
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private static int STROKE_WIDTH_INDEX = 0;
        private static int STROKE_COLOR_INDEX = 1;
        private static int STROKE_ALPHA_INDEX = 2;
        private static int FILL_COLOR_INDEX = 3;
        private static int FILL_ALPHA_INDEX = 4;
        private static int TRIM_PATH_START_INDEX = 5;
        private static int TRIM_PATH_END_INDEX = 6;
        private static int TRIM_PATH_OFFSET_INDEX = 7;
        private static int STROKE_LINE_CAP_INDEX = 8;
        private static int STROKE_LINE_JOIN_INDEX = 9;
        private static int STROKE_MITER_LIMIT_INDEX = 10;
        private static int FILL_TYPE_INDEX = 11;
        private static int TOTAL_PROPERTY_COUNT = 12;
        private static int NATIVE_ALLOCATION_SIZE = 264;
        private static HashMap<String, Integer> sPropertyIndexMap;
        private static Property<VFullPath, Float> STROKE_WIDTH;
        private static Property<VFullPath, Integer> STROKE_COLOR;
        private static Property<VFullPath, Float> STROKE_ALPHA;
        private static Property<VFullPath, Integer> FILL_COLOR;
        private static Property<VFullPath, Float> FILL_ALPHA;
        private static Property<VFullPath, Float> TRIM_PATH_START;
        private static Property<VFullPath, Float> TRIM_PATH_END;
        private static Property<VFullPath, Float> TRIM_PATH_OFFSET;
        private static HashMap<String, Property> sPropertyMap;
        private byte[] mPropertyData;
        private int[] mThemeAttrs;
        ComplexColor mStrokeColors;
        ComplexColor mFillColors;
        private long mNativePtr;

        private void $$robo$$android_graphics_drawable_VectorDrawable_VFullPath$__constructor__() {
            this.mStrokeColors = null;
            this.mFillColors = null;
            this.mNativePtr = VectorDrawable.nCreateFullPath();
        }

        private void $$robo$$android_graphics_drawable_VectorDrawable_VFullPath$__constructor__(VFullPath copy) {
            this.mStrokeColors = null;
            this.mFillColors = null;
            this.mNativePtr = VectorDrawable.nCreateFullPath(copy.mNativePtr);
            this.mThemeAttrs = copy.mThemeAttrs;
            this.mStrokeColors = copy.mStrokeColors;
            this.mFillColors = copy.mFillColors;
        }

        private final Property $$robo$$android_graphics_drawable_VectorDrawable_VFullPath$getProperty(String propertyName) {
            Property p = super.getProperty(propertyName);
            if (p != null) {
                return p;
            }
            if (sPropertyMap.containsKey(propertyName)) {
                return sPropertyMap.get(propertyName);
            }
            return null;
        }

        private final int $$robo$$android_graphics_drawable_VectorDrawable_VFullPath$getPropertyIndex(String propertyName) {
            if (!sPropertyIndexMap.containsKey(propertyName)) {
                return -1;
            }
            return sPropertyIndexMap.get(propertyName);
        }

        private final boolean $$robo$$android_graphics_drawable_VectorDrawable_VFullPath$onStateChange(int[] stateSet) {
            boolean changed = false;
            if (this.mStrokeColors != null && this.mStrokeColors instanceof ColorStateList) {
                int newStrokeColor;
                int oldStrokeColor = this.getStrokeColor();
                changed |= oldStrokeColor != (newStrokeColor = ((ColorStateList)this.mStrokeColors).getColorForState(stateSet, oldStrokeColor));
                if (oldStrokeColor != newStrokeColor) {
                    VectorDrawable.nSetStrokeColor(this.mNativePtr, newStrokeColor);
                }
            }
            if (this.mFillColors != null && this.mFillColors instanceof ColorStateList) {
                int newFillColor;
                int oldFillColor = this.getFillColor();
                changed |= oldFillColor != (newFillColor = ((ColorStateList)this.mFillColors).getColorForState(stateSet, oldFillColor));
                if (oldFillColor != newFillColor) {
                    VectorDrawable.nSetFillColor(this.mNativePtr, newFillColor);
                }
            }
            return changed;
        }

        private final boolean $$robo$$android_graphics_drawable_VectorDrawable_VFullPath$isStateful() {
            return this.mStrokeColors != null || this.mFillColors != null;
        }

        private final boolean $$robo$$android_graphics_drawable_VectorDrawable_VFullPath$hasFocusStateSpecified() {
            return this.mStrokeColors != null && this.mStrokeColors instanceof ColorStateList && ((ColorStateList)this.mStrokeColors).hasFocusStateSpecified() && this.mFillColors != null && this.mFillColors instanceof ColorStateList && ((ColorStateList)this.mFillColors).hasFocusStateSpecified();
        }

        private final int $$robo$$android_graphics_drawable_VectorDrawable_VFullPath$getNativeSize() {
            return 264;
        }

        private final long $$robo$$android_graphics_drawable_VectorDrawable_VFullPath$getNativePtr() {
            return this.mNativePtr;
        }

        private final void $$robo$$android_graphics_drawable_VectorDrawable_VFullPath$inflate(Resources r, AttributeSet attrs, Resources.Theme theme) {
            TypedArray a = Drawable.obtainAttributes(r, theme, attrs, R.styleable.VectorDrawablePath);
            this.updateStateFromTypedArray(a);
            a.recycle();
        }

        private final void $$robo$$android_graphics_drawable_VectorDrawable_VFullPath$updateStateFromTypedArray(TypedArray a) {
            ComplexColor strokeColors;
            ComplexColor fillColors;
            String pathString;
            boolean success;
            int byteCount = 48;
            if (this.mPropertyData == null) {
                this.mPropertyData = new byte[byteCount];
            }
            if (!(success = VectorDrawable.nGetFullPathProperties(this.mNativePtr, this.mPropertyData, byteCount))) {
                throw new RuntimeException("Error: inconsistent property count");
            }
            ByteBuffer properties = ByteBuffer.wrap(this.mPropertyData);
            properties.order(ByteOrder.nativeOrder());
            float strokeWidth = properties.getFloat(0);
            int strokeColor = properties.getInt(4);
            float strokeAlpha = properties.getFloat(8);
            int fillColor = properties.getInt(12);
            float fillAlpha = properties.getFloat(16);
            float trimPathStart = properties.getFloat(20);
            float trimPathEnd = properties.getFloat(24);
            float trimPathOffset = properties.getFloat(28);
            int strokeLineCap = properties.getInt(32);
            int strokeLineJoin = properties.getInt(36);
            float strokeMiterLimit = properties.getFloat(40);
            int fillType = properties.getInt(44);
            Shader fillGradient = null;
            Shader strokeGradient = null;
            this.mChangingConfigurations |= a.getChangingConfigurations();
            this.mThemeAttrs = a.extractThemeAttrs();
            String pathName = a.getString(0);
            if (pathName != null) {
                this.mPathName = pathName;
                VectorDrawable.nSetName(this.mNativePtr, this.mPathName);
            }
            if ((pathString = a.getString(2)) != null) {
                this.mPathData = new PathParser.PathData(pathString);
                VectorDrawable.nSetPathString(this.mNativePtr, pathString, pathString.length());
            }
            if ((fillColors = a.getComplexColor(1)) != null) {
                if (fillColors instanceof GradientColor) {
                    this.mFillColors = fillColors;
                    fillGradient = ((GradientColor)fillColors).getShader();
                } else {
                    this.mFillColors = fillColors.isStateful() ? fillColors : null;
                }
                fillColor = fillColors.getDefaultColor();
            }
            if ((strokeColors = a.getComplexColor(3)) != null) {
                if (strokeColors instanceof GradientColor) {
                    this.mStrokeColors = strokeColors;
                    strokeGradient = ((GradientColor)strokeColors).getShader();
                } else {
                    this.mStrokeColors = strokeColors.isStateful() ? strokeColors : null;
                }
                strokeColor = strokeColors.getDefaultColor();
            }
            VectorDrawable.nUpdateFullPathFillGradient(this.mNativePtr, fillGradient != null ? fillGradient.getNativeInstance() : 0L);
            VectorDrawable.nUpdateFullPathStrokeGradient(this.mNativePtr, strokeGradient != null ? strokeGradient.getNativeInstance() : 0L);
            fillAlpha = a.getFloat(12, fillAlpha);
            strokeLineCap = a.getInt(8, strokeLineCap);
            strokeLineJoin = a.getInt(9, strokeLineJoin);
            strokeMiterLimit = a.getFloat(10, strokeMiterLimit);
            strokeAlpha = a.getFloat(11, strokeAlpha);
            strokeWidth = a.getFloat(4, strokeWidth);
            trimPathEnd = a.getFloat(6, trimPathEnd);
            trimPathOffset = a.getFloat(7, trimPathOffset);
            trimPathStart = a.getFloat(5, trimPathStart);
            fillType = a.getInt(13, fillType);
            VectorDrawable.nUpdateFullPathProperties(this.mNativePtr, strokeWidth, strokeColor, strokeAlpha, fillColor, fillAlpha, trimPathStart, trimPathEnd, trimPathOffset, strokeMiterLimit, strokeLineCap, strokeLineJoin, fillType);
        }

        private final boolean $$robo$$android_graphics_drawable_VectorDrawable_VFullPath$canApplyTheme() {
            if (this.mThemeAttrs != null) {
                return true;
            }
            boolean fillCanApplyTheme = this.canComplexColorApplyTheme(this.mFillColors);
            boolean strokeCanApplyTheme = this.canComplexColorApplyTheme(this.mStrokeColors);
            return fillCanApplyTheme || strokeCanApplyTheme;
        }

        private final void $$robo$$android_graphics_drawable_VectorDrawable_VFullPath$applyTheme(Resources.Theme t) {
            if (this.mThemeAttrs != null) {
                TypedArray a = t.resolveAttributes(this.mThemeAttrs, R.styleable.VectorDrawablePath);
                this.updateStateFromTypedArray(a);
                a.recycle();
            }
            boolean fillCanApplyTheme = this.canComplexColorApplyTheme(this.mFillColors);
            boolean strokeCanApplyTheme = this.canComplexColorApplyTheme(this.mStrokeColors);
            if (fillCanApplyTheme) {
                this.mFillColors = this.mFillColors.obtainForTheme(t);
                if (this.mFillColors instanceof GradientColor) {
                    VectorDrawable.nUpdateFullPathFillGradient(this.mNativePtr, ((GradientColor)this.mFillColors).getShader().getNativeInstance());
                } else if (this.mFillColors instanceof ColorStateList) {
                    VectorDrawable.nSetFillColor(this.mNativePtr, this.mFillColors.getDefaultColor());
                }
            }
            if (strokeCanApplyTheme) {
                this.mStrokeColors = this.mStrokeColors.obtainForTheme(t);
                if (this.mStrokeColors instanceof GradientColor) {
                    VectorDrawable.nUpdateFullPathStrokeGradient(this.mNativePtr, ((GradientColor)this.mStrokeColors).getShader().getNativeInstance());
                } else if (this.mStrokeColors instanceof ColorStateList) {
                    VectorDrawable.nSetStrokeColor(this.mNativePtr, this.mStrokeColors.getDefaultColor());
                }
            }
        }

        private final boolean $$robo$$android_graphics_drawable_VectorDrawable_VFullPath$canComplexColorApplyTheme(ComplexColor complexColor) {
            return complexColor != null && complexColor.canApplyTheme();
        }

        private final int $$robo$$android_graphics_drawable_VectorDrawable_VFullPath$getStrokeColor() {
            return this.isTreeValid() ? VectorDrawable.nGetStrokeColor(this.mNativePtr) : 0;
        }

        private final void $$robo$$android_graphics_drawable_VectorDrawable_VFullPath$setStrokeColor(int strokeColor) {
            this.mStrokeColors = null;
            if (this.isTreeValid()) {
                VectorDrawable.nSetStrokeColor(this.mNativePtr, strokeColor);
            }
        }

        private final float $$robo$$android_graphics_drawable_VectorDrawable_VFullPath$getStrokeWidth() {
            return this.isTreeValid() ? VectorDrawable.nGetStrokeWidth(this.mNativePtr) : 0.0f;
        }

        private final void $$robo$$android_graphics_drawable_VectorDrawable_VFullPath$setStrokeWidth(float strokeWidth) {
            if (this.isTreeValid()) {
                VectorDrawable.nSetStrokeWidth(this.mNativePtr, strokeWidth);
            }
        }

        private final float $$robo$$android_graphics_drawable_VectorDrawable_VFullPath$getStrokeAlpha() {
            return this.isTreeValid() ? VectorDrawable.nGetStrokeAlpha(this.mNativePtr) : 0.0f;
        }

        private final void $$robo$$android_graphics_drawable_VectorDrawable_VFullPath$setStrokeAlpha(float strokeAlpha) {
            if (this.isTreeValid()) {
                VectorDrawable.nSetStrokeAlpha(this.mNativePtr, strokeAlpha);
            }
        }

        private final int $$robo$$android_graphics_drawable_VectorDrawable_VFullPath$getFillColor() {
            return this.isTreeValid() ? VectorDrawable.nGetFillColor(this.mNativePtr) : 0;
        }

        private final void $$robo$$android_graphics_drawable_VectorDrawable_VFullPath$setFillColor(int fillColor) {
            this.mFillColors = null;
            if (this.isTreeValid()) {
                VectorDrawable.nSetFillColor(this.mNativePtr, fillColor);
            }
        }

        private final float $$robo$$android_graphics_drawable_VectorDrawable_VFullPath$getFillAlpha() {
            return this.isTreeValid() ? VectorDrawable.nGetFillAlpha(this.mNativePtr) : 0.0f;
        }

        private final void $$robo$$android_graphics_drawable_VectorDrawable_VFullPath$setFillAlpha(float fillAlpha) {
            if (this.isTreeValid()) {
                VectorDrawable.nSetFillAlpha(this.mNativePtr, fillAlpha);
            }
        }

        private final float $$robo$$android_graphics_drawable_VectorDrawable_VFullPath$getTrimPathStart() {
            return this.isTreeValid() ? VectorDrawable.nGetTrimPathStart(this.mNativePtr) : 0.0f;
        }

        private final void $$robo$$android_graphics_drawable_VectorDrawable_VFullPath$setTrimPathStart(float trimPathStart) {
            if (this.isTreeValid()) {
                VectorDrawable.nSetTrimPathStart(this.mNativePtr, trimPathStart);
            }
        }

        private final float $$robo$$android_graphics_drawable_VectorDrawable_VFullPath$getTrimPathEnd() {
            return this.isTreeValid() ? VectorDrawable.nGetTrimPathEnd(this.mNativePtr) : 0.0f;
        }

        private final void $$robo$$android_graphics_drawable_VectorDrawable_VFullPath$setTrimPathEnd(float trimPathEnd) {
            if (this.isTreeValid()) {
                VectorDrawable.nSetTrimPathEnd(this.mNativePtr, trimPathEnd);
            }
        }

        private final float $$robo$$android_graphics_drawable_VectorDrawable_VFullPath$getTrimPathOffset() {
            return this.isTreeValid() ? VectorDrawable.nGetTrimPathOffset(this.mNativePtr) : 0.0f;
        }

        private final void $$robo$$android_graphics_drawable_VectorDrawable_VFullPath$setTrimPathOffset(float trimPathOffset) {
            if (this.isTreeValid()) {
                VectorDrawable.nSetTrimPathOffset(this.mNativePtr, trimPathOffset);
            }
        }

        static void __staticInitializer__() {
            sPropertyIndexMap = new HashMap<String, Integer>(){
                public /* synthetic */ Object __robo_data__;

                private void $$robo$$android_graphics_drawable_VectorDrawable_VFullPath_1$__constructor__() {
                    this.put("strokeWidth", 0);
                    this.put("strokeColor", 1);
                    this.put("strokeAlpha", 2);
                    this.put("fillColor", 3);
                    this.put("fillAlpha", 4);
                    this.put("trimPathStart", 5);
                    this.put("trimPathEnd", 6);
                    this.put("trimPathOffset", 7);
                }

                private void __constructor__() {
                    this.$$robo$$android_graphics_drawable_VectorDrawable_VFullPath_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_VectorDrawable_VFullPath_1$__constructor__(), this);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
            STROKE_WIDTH = new FloatProperty<VFullPath>("strokeWidth"){
                public /* synthetic */ Object __robo_data__;

                private void $$robo$$android_graphics_drawable_VectorDrawable_VFullPath_2$__constructor__(String name) {
                }

                private final void $$robo$$android_graphics_drawable_VectorDrawable_VFullPath_2$setValue(VFullPath object, float value) {
                    object.setStrokeWidth(value);
                }

                private final Float $$robo$$android_graphics_drawable_VectorDrawable_VFullPath_2$get(VFullPath object) {
                    return Float.valueOf(object.getStrokeWidth());
                }

                private void __constructor__(String string2) {
                    this.$$robo$$android_graphics_drawable_VectorDrawable_VFullPath_2$__constructor__(string2);
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_VectorDrawable_VFullPath_2$__constructor__(java.lang.String ), this, string2);
                }

                @Override
                public void setValue(VFullPath vFullPath, float f) {
                    InvokeDynamicSupport.bootstrap("setValue", $$robo$$android_graphics_drawable_VectorDrawable_VFullPath_2$setValue(android.graphics.drawable.VectorDrawable$VFullPath float ), this, vFullPath, f);
                }

                @Override
                public Float get(VFullPath vFullPath) {
                    return InvokeDynamicSupport.bootstrap("get", $$robo$$android_graphics_drawable_VectorDrawable_VFullPath_2$get(android.graphics.drawable.VectorDrawable$VFullPath ), this, vFullPath);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
            STROKE_COLOR = new IntProperty<VFullPath>("strokeColor"){
                public /* synthetic */ Object __robo_data__;

                private void $$robo$$android_graphics_drawable_VectorDrawable_VFullPath_3$__constructor__(String name) {
                }

                private final void $$robo$$android_graphics_drawable_VectorDrawable_VFullPath_3$setValue(VFullPath object, int value) {
                    object.setStrokeColor(value);
                }

                private final Integer $$robo$$android_graphics_drawable_VectorDrawable_VFullPath_3$get(VFullPath object) {
                    return object.getStrokeColor();
                }

                private void __constructor__(String string2) {
                    this.$$robo$$android_graphics_drawable_VectorDrawable_VFullPath_3$__constructor__(string2);
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_VectorDrawable_VFullPath_3$__constructor__(java.lang.String ), this, string2);
                }

                @Override
                public void setValue(VFullPath vFullPath, int n) {
                    InvokeDynamicSupport.bootstrap("setValue", $$robo$$android_graphics_drawable_VectorDrawable_VFullPath_3$setValue(android.graphics.drawable.VectorDrawable$VFullPath int ), this, vFullPath, n);
                }

                @Override
                public Integer get(VFullPath vFullPath) {
                    return InvokeDynamicSupport.bootstrap("get", $$robo$$android_graphics_drawable_VectorDrawable_VFullPath_3$get(android.graphics.drawable.VectorDrawable$VFullPath ), this, vFullPath);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
            STROKE_ALPHA = new FloatProperty<VFullPath>("strokeAlpha"){
                public /* synthetic */ Object __robo_data__;

                private void $$robo$$android_graphics_drawable_VectorDrawable_VFullPath_4$__constructor__(String name) {
                }

                private final void $$robo$$android_graphics_drawable_VectorDrawable_VFullPath_4$setValue(VFullPath object, float value) {
                    object.setStrokeAlpha(value);
                }

                private final Float $$robo$$android_graphics_drawable_VectorDrawable_VFullPath_4$get(VFullPath object) {
                    return Float.valueOf(object.getStrokeAlpha());
                }

                private void __constructor__(String string2) {
                    this.$$robo$$android_graphics_drawable_VectorDrawable_VFullPath_4$__constructor__(string2);
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_VectorDrawable_VFullPath_4$__constructor__(java.lang.String ), this, string2);
                }

                @Override
                public void setValue(VFullPath vFullPath, float f) {
                    InvokeDynamicSupport.bootstrap("setValue", $$robo$$android_graphics_drawable_VectorDrawable_VFullPath_4$setValue(android.graphics.drawable.VectorDrawable$VFullPath float ), this, vFullPath, f);
                }

                @Override
                public Float get(VFullPath vFullPath) {
                    return InvokeDynamicSupport.bootstrap("get", $$robo$$android_graphics_drawable_VectorDrawable_VFullPath_4$get(android.graphics.drawable.VectorDrawable$VFullPath ), this, vFullPath);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
            FILL_COLOR = new IntProperty<VFullPath>("fillColor"){
                public /* synthetic */ Object __robo_data__;

                private void $$robo$$android_graphics_drawable_VectorDrawable_VFullPath_5$__constructor__(String name) {
                }

                private final void $$robo$$android_graphics_drawable_VectorDrawable_VFullPath_5$setValue(VFullPath object, int value) {
                    object.setFillColor(value);
                }

                private final Integer $$robo$$android_graphics_drawable_VectorDrawable_VFullPath_5$get(VFullPath object) {
                    return object.getFillColor();
                }

                private void __constructor__(String string2) {
                    this.$$robo$$android_graphics_drawable_VectorDrawable_VFullPath_5$__constructor__(string2);
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_VectorDrawable_VFullPath_5$__constructor__(java.lang.String ), this, string2);
                }

                @Override
                public void setValue(VFullPath vFullPath, int n) {
                    InvokeDynamicSupport.bootstrap("setValue", $$robo$$android_graphics_drawable_VectorDrawable_VFullPath_5$setValue(android.graphics.drawable.VectorDrawable$VFullPath int ), this, vFullPath, n);
                }

                @Override
                public Integer get(VFullPath vFullPath) {
                    return InvokeDynamicSupport.bootstrap("get", $$robo$$android_graphics_drawable_VectorDrawable_VFullPath_5$get(android.graphics.drawable.VectorDrawable$VFullPath ), this, vFullPath);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
            FILL_ALPHA = new FloatProperty<VFullPath>("fillAlpha"){
                public /* synthetic */ Object __robo_data__;

                private void $$robo$$android_graphics_drawable_VectorDrawable_VFullPath_6$__constructor__(String name) {
                }

                private final void $$robo$$android_graphics_drawable_VectorDrawable_VFullPath_6$setValue(VFullPath object, float value) {
                    object.setFillAlpha(value);
                }

                private final Float $$robo$$android_graphics_drawable_VectorDrawable_VFullPath_6$get(VFullPath object) {
                    return Float.valueOf(object.getFillAlpha());
                }

                private void __constructor__(String string2) {
                    this.$$robo$$android_graphics_drawable_VectorDrawable_VFullPath_6$__constructor__(string2);
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_VectorDrawable_VFullPath_6$__constructor__(java.lang.String ), this, string2);
                }

                @Override
                public void setValue(VFullPath vFullPath, float f) {
                    InvokeDynamicSupport.bootstrap("setValue", $$robo$$android_graphics_drawable_VectorDrawable_VFullPath_6$setValue(android.graphics.drawable.VectorDrawable$VFullPath float ), this, vFullPath, f);
                }

                @Override
                public Float get(VFullPath vFullPath) {
                    return InvokeDynamicSupport.bootstrap("get", $$robo$$android_graphics_drawable_VectorDrawable_VFullPath_6$get(android.graphics.drawable.VectorDrawable$VFullPath ), this, vFullPath);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
            TRIM_PATH_START = new FloatProperty<VFullPath>("trimPathStart"){
                public /* synthetic */ Object __robo_data__;

                private void $$robo$$android_graphics_drawable_VectorDrawable_VFullPath_7$__constructor__(String name) {
                }

                private final void $$robo$$android_graphics_drawable_VectorDrawable_VFullPath_7$setValue(VFullPath object, float value) {
                    object.setTrimPathStart(value);
                }

                private final Float $$robo$$android_graphics_drawable_VectorDrawable_VFullPath_7$get(VFullPath object) {
                    return Float.valueOf(object.getTrimPathStart());
                }

                private void __constructor__(String string2) {
                    this.$$robo$$android_graphics_drawable_VectorDrawable_VFullPath_7$__constructor__(string2);
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_VectorDrawable_VFullPath_7$__constructor__(java.lang.String ), this, string2);
                }

                @Override
                public void setValue(VFullPath vFullPath, float f) {
                    InvokeDynamicSupport.bootstrap("setValue", $$robo$$android_graphics_drawable_VectorDrawable_VFullPath_7$setValue(android.graphics.drawable.VectorDrawable$VFullPath float ), this, vFullPath, f);
                }

                @Override
                public Float get(VFullPath vFullPath) {
                    return InvokeDynamicSupport.bootstrap("get", $$robo$$android_graphics_drawable_VectorDrawable_VFullPath_7$get(android.graphics.drawable.VectorDrawable$VFullPath ), this, vFullPath);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
            TRIM_PATH_END = new FloatProperty<VFullPath>("trimPathEnd"){
                public /* synthetic */ Object __robo_data__;

                private void $$robo$$android_graphics_drawable_VectorDrawable_VFullPath_8$__constructor__(String name) {
                }

                private final void $$robo$$android_graphics_drawable_VectorDrawable_VFullPath_8$setValue(VFullPath object, float value) {
                    object.setTrimPathEnd(value);
                }

                private final Float $$robo$$android_graphics_drawable_VectorDrawable_VFullPath_8$get(VFullPath object) {
                    return Float.valueOf(object.getTrimPathEnd());
                }

                private void __constructor__(String string2) {
                    this.$$robo$$android_graphics_drawable_VectorDrawable_VFullPath_8$__constructor__(string2);
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_VectorDrawable_VFullPath_8$__constructor__(java.lang.String ), this, string2);
                }

                @Override
                public void setValue(VFullPath vFullPath, float f) {
                    InvokeDynamicSupport.bootstrap("setValue", $$robo$$android_graphics_drawable_VectorDrawable_VFullPath_8$setValue(android.graphics.drawable.VectorDrawable$VFullPath float ), this, vFullPath, f);
                }

                @Override
                public Float get(VFullPath vFullPath) {
                    return InvokeDynamicSupport.bootstrap("get", $$robo$$android_graphics_drawable_VectorDrawable_VFullPath_8$get(android.graphics.drawable.VectorDrawable$VFullPath ), this, vFullPath);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
            TRIM_PATH_OFFSET = new FloatProperty<VFullPath>("trimPathOffset"){
                public /* synthetic */ Object __robo_data__;

                private void $$robo$$android_graphics_drawable_VectorDrawable_VFullPath_9$__constructor__(String name) {
                }

                private final void $$robo$$android_graphics_drawable_VectorDrawable_VFullPath_9$setValue(VFullPath object, float value) {
                    object.setTrimPathOffset(value);
                }

                private final Float $$robo$$android_graphics_drawable_VectorDrawable_VFullPath_9$get(VFullPath object) {
                    return Float.valueOf(object.getTrimPathOffset());
                }

                private void __constructor__(String string2) {
                    this.$$robo$$android_graphics_drawable_VectorDrawable_VFullPath_9$__constructor__(string2);
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_VectorDrawable_VFullPath_9$__constructor__(java.lang.String ), this, string2);
                }

                @Override
                public void setValue(VFullPath vFullPath, float f) {
                    InvokeDynamicSupport.bootstrap("setValue", $$robo$$android_graphics_drawable_VectorDrawable_VFullPath_9$setValue(android.graphics.drawable.VectorDrawable$VFullPath float ), this, vFullPath, f);
                }

                @Override
                public Float get(VFullPath vFullPath) {
                    return InvokeDynamicSupport.bootstrap("get", $$robo$$android_graphics_drawable_VectorDrawable_VFullPath_9$get(android.graphics.drawable.VectorDrawable$VFullPath ), this, vFullPath);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
            sPropertyMap = new HashMap<String, Property>(){
                public /* synthetic */ Object __robo_data__;

                private void $$robo$$android_graphics_drawable_VectorDrawable_VFullPath_10$__constructor__() {
                    this.put("strokeWidth", STROKE_WIDTH);
                    this.put("strokeColor", STROKE_COLOR);
                    this.put("strokeAlpha", STROKE_ALPHA);
                    this.put("fillColor", FILL_COLOR);
                    this.put("fillAlpha", FILL_ALPHA);
                    this.put("trimPathStart", TRIM_PATH_START);
                    this.put("trimPathEnd", TRIM_PATH_END);
                    this.put("trimPathOffset", TRIM_PATH_OFFSET);
                }

                private void __constructor__() {
                    this.$$robo$$android_graphics_drawable_VectorDrawable_VFullPath_10$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_VectorDrawable_VFullPath_10$__constructor__(), this);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private void __constructor__() {
            this.$$robo$$android_graphics_drawable_VectorDrawable_VFullPath$__constructor__();
        }

        public VFullPath() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_VectorDrawable_VFullPath$__constructor__(), this);
        }

        private void __constructor__(VFullPath vFullPath) {
            this.$$robo$$android_graphics_drawable_VectorDrawable_VFullPath$__constructor__(vFullPath);
        }

        public VFullPath(VFullPath vFullPath) {
            super(vFullPath);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_VectorDrawable_VFullPath$__constructor__(android.graphics.drawable.VectorDrawable$VFullPath ), this, vFullPath);
        }

        @Override
        Property getProperty(String string2) {
            return InvokeDynamicSupport.bootstrap("getProperty", $$robo$$android_graphics_drawable_VectorDrawable_VFullPath$getProperty(java.lang.String ), this, string2);
        }

        int getPropertyIndex(String string2) {
            return (int)InvokeDynamicSupport.bootstrap("getPropertyIndex", $$robo$$android_graphics_drawable_VectorDrawable_VFullPath$getPropertyIndex(java.lang.String ), this, string2);
        }

        @Override
        public boolean onStateChange(int[] nArray) {
            return (boolean)InvokeDynamicSupport.bootstrap("onStateChange", $$robo$$android_graphics_drawable_VectorDrawable_VFullPath$onStateChange(int[] ), this, nArray);
        }

        @Override
        public boolean isStateful() {
            return (boolean)InvokeDynamicSupport.bootstrap("isStateful", $$robo$$android_graphics_drawable_VectorDrawable_VFullPath$isStateful(), this);
        }

        @Override
        public boolean hasFocusStateSpecified() {
            return (boolean)InvokeDynamicSupport.bootstrap("hasFocusStateSpecified", $$robo$$android_graphics_drawable_VectorDrawable_VFullPath$hasFocusStateSpecified(), this);
        }

        @Override
        int getNativeSize() {
            return (int)InvokeDynamicSupport.bootstrap("getNativeSize", $$robo$$android_graphics_drawable_VectorDrawable_VFullPath$getNativeSize(), this);
        }

        @Override
        public long getNativePtr() {
            return (long)InvokeDynamicSupport.bootstrap("getNativePtr", $$robo$$android_graphics_drawable_VectorDrawable_VFullPath$getNativePtr(), this);
        }

        @Override
        public void inflate(Resources resources, AttributeSet attributeSet, Resources.Theme theme) {
            InvokeDynamicSupport.bootstrap("inflate", $$robo$$android_graphics_drawable_VectorDrawable_VFullPath$inflate(android.content.res.Resources android.util.AttributeSet android.content.res.Resources$Theme ), this, resources, attributeSet, theme);
        }

        private void updateStateFromTypedArray(TypedArray typedArray) {
            InvokeDynamicSupport.bootstrap("updateStateFromTypedArray", $$robo$$android_graphics_drawable_VectorDrawable_VFullPath$updateStateFromTypedArray(android.content.res.TypedArray ), this, typedArray);
        }

        @Override
        public boolean canApplyTheme() {
            return (boolean)InvokeDynamicSupport.bootstrap("canApplyTheme", $$robo$$android_graphics_drawable_VectorDrawable_VFullPath$canApplyTheme(), this);
        }

        @Override
        public void applyTheme(Resources.Theme theme) {
            InvokeDynamicSupport.bootstrap("applyTheme", $$robo$$android_graphics_drawable_VectorDrawable_VFullPath$applyTheme(android.content.res.Resources$Theme ), this, theme);
        }

        private boolean canComplexColorApplyTheme(ComplexColor complexColor) {
            return (boolean)InvokeDynamicSupport.bootstrap("canComplexColorApplyTheme", $$robo$$android_graphics_drawable_VectorDrawable_VFullPath$canComplexColorApplyTheme(android.content.res.ComplexColor ), this, complexColor);
        }

        int getStrokeColor() {
            return (int)InvokeDynamicSupport.bootstrap("getStrokeColor", $$robo$$android_graphics_drawable_VectorDrawable_VFullPath$getStrokeColor(), this);
        }

        void setStrokeColor(int n) {
            InvokeDynamicSupport.bootstrap("setStrokeColor", $$robo$$android_graphics_drawable_VectorDrawable_VFullPath$setStrokeColor(int ), this, n);
        }

        float getStrokeWidth() {
            return (float)InvokeDynamicSupport.bootstrap("getStrokeWidth", $$robo$$android_graphics_drawable_VectorDrawable_VFullPath$getStrokeWidth(), this);
        }

        void setStrokeWidth(float f) {
            InvokeDynamicSupport.bootstrap("setStrokeWidth", $$robo$$android_graphics_drawable_VectorDrawable_VFullPath$setStrokeWidth(float ), this, f);
        }

        float getStrokeAlpha() {
            return (float)InvokeDynamicSupport.bootstrap("getStrokeAlpha", $$robo$$android_graphics_drawable_VectorDrawable_VFullPath$getStrokeAlpha(), this);
        }

        void setStrokeAlpha(float f) {
            InvokeDynamicSupport.bootstrap("setStrokeAlpha", $$robo$$android_graphics_drawable_VectorDrawable_VFullPath$setStrokeAlpha(float ), this, f);
        }

        int getFillColor() {
            return (int)InvokeDynamicSupport.bootstrap("getFillColor", $$robo$$android_graphics_drawable_VectorDrawable_VFullPath$getFillColor(), this);
        }

        void setFillColor(int n) {
            InvokeDynamicSupport.bootstrap("setFillColor", $$robo$$android_graphics_drawable_VectorDrawable_VFullPath$setFillColor(int ), this, n);
        }

        float getFillAlpha() {
            return (float)InvokeDynamicSupport.bootstrap("getFillAlpha", $$robo$$android_graphics_drawable_VectorDrawable_VFullPath$getFillAlpha(), this);
        }

        void setFillAlpha(float f) {
            InvokeDynamicSupport.bootstrap("setFillAlpha", $$robo$$android_graphics_drawable_VectorDrawable_VFullPath$setFillAlpha(float ), this, f);
        }

        float getTrimPathStart() {
            return (float)InvokeDynamicSupport.bootstrap("getTrimPathStart", $$robo$$android_graphics_drawable_VectorDrawable_VFullPath$getTrimPathStart(), this);
        }

        void setTrimPathStart(float f) {
            InvokeDynamicSupport.bootstrap("setTrimPathStart", $$robo$$android_graphics_drawable_VectorDrawable_VFullPath$setTrimPathStart(float ), this, f);
        }

        float getTrimPathEnd() {
            return (float)InvokeDynamicSupport.bootstrap("getTrimPathEnd", $$robo$$android_graphics_drawable_VectorDrawable_VFullPath$getTrimPathEnd(), this);
        }

        void setTrimPathEnd(float f) {
            InvokeDynamicSupport.bootstrap("setTrimPathEnd", $$robo$$android_graphics_drawable_VectorDrawable_VFullPath$setTrimPathEnd(float ), this, f);
        }

        float getTrimPathOffset() {
            return (float)InvokeDynamicSupport.bootstrap("getTrimPathOffset", $$robo$$android_graphics_drawable_VectorDrawable_VFullPath$getTrimPathOffset(), this);
        }

        void setTrimPathOffset(float f) {
            InvokeDynamicSupport.bootstrap("setTrimPathOffset", $$robo$$android_graphics_drawable_VectorDrawable_VFullPath$setTrimPathOffset(float ), this, f);
        }

        static {
            RobolectricInternals.classInitializing(VFullPath.class);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (VFullPath)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class VClipPath
    extends VPath
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private long mNativePtr;
        private static int NATIVE_ALLOCATION_SIZE = 120;

        private void $$robo$$android_graphics_drawable_VectorDrawable_VClipPath$__constructor__() {
            this.mNativePtr = VectorDrawable.nCreateClipPath();
        }

        private void $$robo$$android_graphics_drawable_VectorDrawable_VClipPath$__constructor__(VClipPath copy) {
            this.mNativePtr = VectorDrawable.nCreateClipPath(copy.mNativePtr);
        }

        private final long $$robo$$android_graphics_drawable_VectorDrawable_VClipPath$getNativePtr() {
            return this.mNativePtr;
        }

        private final void $$robo$$android_graphics_drawable_VectorDrawable_VClipPath$inflate(Resources r, AttributeSet attrs, Resources.Theme theme) {
            TypedArray a = Drawable.obtainAttributes(r, theme, attrs, R.styleable.VectorDrawableClipPath);
            this.updateStateFromTypedArray(a);
            a.recycle();
        }

        private final boolean $$robo$$android_graphics_drawable_VectorDrawable_VClipPath$canApplyTheme() {
            return false;
        }

        private final void $$robo$$android_graphics_drawable_VectorDrawable_VClipPath$applyTheme(Resources.Theme theme) {
        }

        private final boolean $$robo$$android_graphics_drawable_VectorDrawable_VClipPath$onStateChange(int[] stateSet) {
            return false;
        }

        private final boolean $$robo$$android_graphics_drawable_VectorDrawable_VClipPath$isStateful() {
            return false;
        }

        private final boolean $$robo$$android_graphics_drawable_VectorDrawable_VClipPath$hasFocusStateSpecified() {
            return false;
        }

        private final int $$robo$$android_graphics_drawable_VectorDrawable_VClipPath$getNativeSize() {
            return 120;
        }

        private final void $$robo$$android_graphics_drawable_VectorDrawable_VClipPath$updateStateFromTypedArray(TypedArray a) {
            String pathDataString;
            this.mChangingConfigurations |= a.getChangingConfigurations();
            String pathName = a.getString(0);
            if (pathName != null) {
                this.mPathName = pathName;
                VectorDrawable.nSetName(this.mNativePtr, this.mPathName);
            }
            if ((pathDataString = a.getString(1)) != null) {
                this.mPathData = new PathParser.PathData(pathDataString);
                VectorDrawable.nSetPathString(this.mNativePtr, pathDataString, pathDataString.length());
            }
        }

        private void __constructor__() {
            this.$$robo$$android_graphics_drawable_VectorDrawable_VClipPath$__constructor__();
        }

        public VClipPath() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_VectorDrawable_VClipPath$__constructor__(), this);
        }

        private void __constructor__(VClipPath vClipPath) {
            this.$$robo$$android_graphics_drawable_VectorDrawable_VClipPath$__constructor__(vClipPath);
        }

        public VClipPath(VClipPath vClipPath) {
            super(vClipPath);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_VectorDrawable_VClipPath$__constructor__(android.graphics.drawable.VectorDrawable$VClipPath ), this, vClipPath);
        }

        @Override
        public long getNativePtr() {
            return (long)InvokeDynamicSupport.bootstrap("getNativePtr", $$robo$$android_graphics_drawable_VectorDrawable_VClipPath$getNativePtr(), this);
        }

        @Override
        public void inflate(Resources resources, AttributeSet attributeSet, Resources.Theme theme) {
            InvokeDynamicSupport.bootstrap("inflate", $$robo$$android_graphics_drawable_VectorDrawable_VClipPath$inflate(android.content.res.Resources android.util.AttributeSet android.content.res.Resources$Theme ), this, resources, attributeSet, theme);
        }

        @Override
        public boolean canApplyTheme() {
            return (boolean)InvokeDynamicSupport.bootstrap("canApplyTheme", $$robo$$android_graphics_drawable_VectorDrawable_VClipPath$canApplyTheme(), this);
        }

        @Override
        public void applyTheme(Resources.Theme theme) {
            InvokeDynamicSupport.bootstrap("applyTheme", $$robo$$android_graphics_drawable_VectorDrawable_VClipPath$applyTheme(android.content.res.Resources$Theme ), this, theme);
        }

        @Override
        public boolean onStateChange(int[] nArray) {
            return (boolean)InvokeDynamicSupport.bootstrap("onStateChange", $$robo$$android_graphics_drawable_VectorDrawable_VClipPath$onStateChange(int[] ), this, nArray);
        }

        @Override
        public boolean isStateful() {
            return (boolean)InvokeDynamicSupport.bootstrap("isStateful", $$robo$$android_graphics_drawable_VectorDrawable_VClipPath$isStateful(), this);
        }

        @Override
        public boolean hasFocusStateSpecified() {
            return (boolean)InvokeDynamicSupport.bootstrap("hasFocusStateSpecified", $$robo$$android_graphics_drawable_VectorDrawable_VClipPath$hasFocusStateSpecified(), this);
        }

        @Override
        int getNativeSize() {
            return (int)InvokeDynamicSupport.bootstrap("getNativeSize", $$robo$$android_graphics_drawable_VectorDrawable_VClipPath$getNativeSize(), this);
        }

        private void updateStateFromTypedArray(TypedArray typedArray) {
            InvokeDynamicSupport.bootstrap("updateStateFromTypedArray", $$robo$$android_graphics_drawable_VectorDrawable_VClipPath$updateStateFromTypedArray(android.content.res.TypedArray ), this, typedArray);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (VClipPath)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static abstract class VPath
    extends VObject
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        protected PathParser.PathData mPathData;
        String mPathName;
        int mChangingConfigurations;
        private static Property<VPath, PathParser.PathData> PATH_DATA;

        private final Property $$robo$$android_graphics_drawable_VectorDrawable_VPath$getProperty(String propertyName) {
            if (PATH_DATA.getName().equals(propertyName)) {
                return PATH_DATA;
            }
            return null;
        }

        private void $$robo$$android_graphics_drawable_VectorDrawable_VPath$__constructor__() {
            this.mPathData = null;
        }

        private void $$robo$$android_graphics_drawable_VectorDrawable_VPath$__constructor__(VPath copy) {
            this.mPathData = null;
            this.mPathName = copy.mPathName;
            this.mChangingConfigurations = copy.mChangingConfigurations;
            this.mPathData = copy.mPathData == null ? null : new PathParser.PathData(copy.mPathData);
        }

        private final String $$robo$$android_graphics_drawable_VectorDrawable_VPath$getPathName() {
            return this.mPathName;
        }

        private final PathParser.PathData $$robo$$android_graphics_drawable_VectorDrawable_VPath$getPathData() {
            return this.mPathData;
        }

        private final void $$robo$$android_graphics_drawable_VectorDrawable_VPath$setPathData(PathParser.PathData pathData) {
            this.mPathData.setPathData(pathData);
            if (this.isTreeValid()) {
                VectorDrawable.nSetPathData(this.getNativePtr(), this.mPathData.getNativePtr());
            }
        }

        static void __staticInitializer__() {
            PATH_DATA = new Property<VPath, PathParser.PathData>(PathParser.PathData.class, "pathData"){
                public /* synthetic */ Object __robo_data__;

                private void $$robo$$android_graphics_drawable_VectorDrawable_VPath_1$__constructor__(Class type, String name) {
                }

                private final void $$robo$$android_graphics_drawable_VectorDrawable_VPath_1$set(VPath object, PathParser.PathData data) {
                    object.setPathData(data);
                }

                private final PathParser.PathData $$robo$$android_graphics_drawable_VectorDrawable_VPath_1$get(VPath object) {
                    return object.getPathData();
                }

                private void __constructor__(Class clazz, String string2) {
                    this.$$robo$$android_graphics_drawable_VectorDrawable_VPath_1$__constructor__(clazz, string2);
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_VectorDrawable_VPath_1$__constructor__(java.lang.Class java.lang.String ), this, clazz, string2);
                }

                @Override
                public void set(VPath vPath, PathParser.PathData pathData) {
                    InvokeDynamicSupport.bootstrap("set", $$robo$$android_graphics_drawable_VectorDrawable_VPath_1$set(android.graphics.drawable.VectorDrawable$VPath android.util.PathParser$PathData ), this, vPath, pathData);
                }

                @Override
                public PathParser.PathData get(VPath vPath) {
                    return InvokeDynamicSupport.bootstrap("get", $$robo$$android_graphics_drawable_VectorDrawable_VPath_1$get(android.graphics.drawable.VectorDrawable$VPath ), this, vPath);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        @Override
        Property getProperty(String string2) {
            return InvokeDynamicSupport.bootstrap("getProperty", $$robo$$android_graphics_drawable_VectorDrawable_VPath$getProperty(java.lang.String ), this, string2);
        }

        private void __constructor__() {
            this.$$robo$$android_graphics_drawable_VectorDrawable_VPath$__constructor__();
        }

        public VPath() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_VectorDrawable_VPath$__constructor__(), this);
        }

        private void __constructor__(VPath vPath) {
            this.$$robo$$android_graphics_drawable_VectorDrawable_VPath$__constructor__(vPath);
        }

        public VPath(VPath vPath) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_VectorDrawable_VPath$__constructor__(android.graphics.drawable.VectorDrawable$VPath ), this, vPath);
        }

        public String getPathName() {
            return InvokeDynamicSupport.bootstrap("getPathName", $$robo$$android_graphics_drawable_VectorDrawable_VPath$getPathName(), this);
        }

        public PathParser.PathData getPathData() {
            return InvokeDynamicSupport.bootstrap("getPathData", $$robo$$android_graphics_drawable_VectorDrawable_VPath$getPathData(), this);
        }

        public void setPathData(PathParser.PathData pathData) {
            InvokeDynamicSupport.bootstrap("setPathData", $$robo$$android_graphics_drawable_VectorDrawable_VPath$setPathData(android.util.PathParser$PathData ), this, pathData);
        }

        static {
            RobolectricInternals.classInitializing(VPath.class);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (VPath)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class VGroup
    extends VObject
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private static int ROTATION_INDEX = 0;
        private static int PIVOT_X_INDEX = 1;
        private static int PIVOT_Y_INDEX = 2;
        private static int SCALE_X_INDEX = 3;
        private static int SCALE_Y_INDEX = 4;
        private static int TRANSLATE_X_INDEX = 5;
        private static int TRANSLATE_Y_INDEX = 6;
        private static int TRANSFORM_PROPERTY_COUNT = 7;
        private static int NATIVE_ALLOCATION_SIZE = 100;
        private static HashMap<String, Integer> sPropertyIndexMap;
        private static Property<VGroup, Float> TRANSLATE_X;
        private static Property<VGroup, Float> TRANSLATE_Y;
        private static Property<VGroup, Float> SCALE_X;
        private static Property<VGroup, Float> SCALE_Y;
        private static Property<VGroup, Float> PIVOT_X;
        private static Property<VGroup, Float> PIVOT_Y;
        private static Property<VGroup, Float> ROTATION;
        private static HashMap<String, Property> sPropertyMap;
        private float[] mTransform;
        private ArrayList<VObject> mChildren;
        private boolean mIsStateful;
        private int mChangingConfigurations;
        private int[] mThemeAttrs;
        private String mGroupName;
        private long mNativePtr;

        private static final int $$robo$$android_graphics_drawable_VectorDrawable_VGroup$getPropertyIndex(String propertyName) {
            if (sPropertyIndexMap.containsKey(propertyName)) {
                return sPropertyIndexMap.get(propertyName);
            }
            return -1;
        }

        private void $$robo$$android_graphics_drawable_VectorDrawable_VGroup$__constructor__(VGroup copy, ArrayMap<String, Object> targetsMap) {
            this.mChildren = new ArrayList();
            this.mGroupName = null;
            this.mIsStateful = copy.mIsStateful;
            this.mThemeAttrs = copy.mThemeAttrs;
            this.mGroupName = copy.mGroupName;
            this.mChangingConfigurations = copy.mChangingConfigurations;
            if (this.mGroupName != null) {
                targetsMap.put(this.mGroupName, this);
            }
            this.mNativePtr = VectorDrawable.nCreateGroup(copy.mNativePtr);
            ArrayList<VObject> children = copy.mChildren;
            for (int i = 0; i < children.size(); ++i) {
                VPath newPath;
                VObject copyChild = children.get(i);
                if (copyChild instanceof VGroup) {
                    VGroup copyGroup = (VGroup)copyChild;
                    this.addChild(new VGroup(copyGroup, targetsMap));
                    continue;
                }
                if (copyChild instanceof VFullPath) {
                    newPath = new VFullPath((VFullPath)copyChild);
                } else if (copyChild instanceof VClipPath) {
                    newPath = new VClipPath((VClipPath)copyChild);
                } else {
                    throw new IllegalStateException("Unknown object in the tree!");
                }
                this.addChild(newPath);
                if (newPath.mPathName == null) continue;
                targetsMap.put(newPath.mPathName, newPath);
            }
        }

        private void $$robo$$android_graphics_drawable_VectorDrawable_VGroup$__constructor__() {
            this.mChildren = new ArrayList();
            this.mGroupName = null;
            this.mNativePtr = VectorDrawable.nCreateGroup();
        }

        private final Property $$robo$$android_graphics_drawable_VectorDrawable_VGroup$getProperty(String propertyName) {
            if (sPropertyMap.containsKey(propertyName)) {
                return sPropertyMap.get(propertyName);
            }
            return null;
        }

        private final String $$robo$$android_graphics_drawable_VectorDrawable_VGroup$getGroupName() {
            return this.mGroupName;
        }

        private final void $$robo$$android_graphics_drawable_VectorDrawable_VGroup$addChild(VObject child) {
            VectorDrawable.nAddChild(this.mNativePtr, child.getNativePtr());
            this.mChildren.add(child);
            this.mIsStateful |= child.isStateful();
        }

        private final void $$robo$$android_graphics_drawable_VectorDrawable_VGroup$setTree(VirtualRefBasePtr treeRoot) {
            super.setTree(treeRoot);
            for (int i = 0; i < this.mChildren.size(); ++i) {
                this.mChildren.get(i).setTree(treeRoot);
            }
        }

        private final long $$robo$$android_graphics_drawable_VectorDrawable_VGroup$getNativePtr() {
            return this.mNativePtr;
        }

        private final void $$robo$$android_graphics_drawable_VectorDrawable_VGroup$inflate(Resources res, AttributeSet attrs, Resources.Theme theme) {
            TypedArray a = Drawable.obtainAttributes(res, theme, attrs, R.styleable.VectorDrawableGroup);
            this.updateStateFromTypedArray(a);
            a.recycle();
        }

        private final void $$robo$$android_graphics_drawable_VectorDrawable_VGroup$updateStateFromTypedArray(TypedArray a) {
            boolean success;
            this.mChangingConfigurations |= a.getChangingConfigurations();
            this.mThemeAttrs = a.extractThemeAttrs();
            if (this.mTransform == null) {
                this.mTransform = new float[7];
            }
            if (!(success = VectorDrawable.nGetGroupProperties(this.mNativePtr, this.mTransform, 7))) {
                throw new RuntimeException("Error: inconsistent property count");
            }
            float rotate = a.getFloat(5, this.mTransform[0]);
            float pivotX = a.getFloat(1, this.mTransform[1]);
            float pivotY = a.getFloat(2, this.mTransform[2]);
            float scaleX = a.getFloat(3, this.mTransform[3]);
            float scaleY = a.getFloat(4, this.mTransform[4]);
            float translateX = a.getFloat(6, this.mTransform[5]);
            float translateY = a.getFloat(7, this.mTransform[6]);
            String groupName = a.getString(0);
            if (groupName != null) {
                this.mGroupName = groupName;
                VectorDrawable.nSetName(this.mNativePtr, this.mGroupName);
            }
            VectorDrawable.nUpdateGroupProperties(this.mNativePtr, rotate, pivotX, pivotY, scaleX, scaleY, translateX, translateY);
        }

        private final boolean $$robo$$android_graphics_drawable_VectorDrawable_VGroup$onStateChange(int[] stateSet) {
            boolean changed = false;
            ArrayList<VObject> children = this.mChildren;
            int count = children.size();
            for (int i = 0; i < count; ++i) {
                VObject child = children.get(i);
                if (!child.isStateful()) continue;
                changed |= child.onStateChange(stateSet);
            }
            return changed;
        }

        private final boolean $$robo$$android_graphics_drawable_VectorDrawable_VGroup$isStateful() {
            return this.mIsStateful;
        }

        private final boolean $$robo$$android_graphics_drawable_VectorDrawable_VGroup$hasFocusStateSpecified() {
            boolean result = false;
            ArrayList<VObject> children = this.mChildren;
            int count = children.size();
            for (int i = 0; i < count; ++i) {
                VObject child = children.get(i);
                if (!child.isStateful()) continue;
                result |= child.hasFocusStateSpecified();
            }
            return result;
        }

        private final int $$robo$$android_graphics_drawable_VectorDrawable_VGroup$getNativeSize() {
            int size = 100;
            for (int i = 0; i < this.mChildren.size(); ++i) {
                size += this.mChildren.get(i).getNativeSize();
            }
            return size;
        }

        private final boolean $$robo$$android_graphics_drawable_VectorDrawable_VGroup$canApplyTheme() {
            if (this.mThemeAttrs != null) {
                return true;
            }
            ArrayList<VObject> children = this.mChildren;
            int count = children.size();
            for (int i = 0; i < count; ++i) {
                VObject child = children.get(i);
                if (!child.canApplyTheme()) continue;
                return true;
            }
            return false;
        }

        private final void $$robo$$android_graphics_drawable_VectorDrawable_VGroup$applyTheme(Resources.Theme t) {
            if (this.mThemeAttrs != null) {
                TypedArray a = t.resolveAttributes(this.mThemeAttrs, R.styleable.VectorDrawableGroup);
                this.updateStateFromTypedArray(a);
                a.recycle();
            }
            ArrayList<VObject> children = this.mChildren;
            int count = children.size();
            for (int i = 0; i < count; ++i) {
                VObject child = children.get(i);
                if (!child.canApplyTheme()) continue;
                child.applyTheme(t);
                this.mIsStateful |= child.isStateful();
            }
        }

        private final float $$robo$$android_graphics_drawable_VectorDrawable_VGroup$getRotation() {
            return this.isTreeValid() ? VectorDrawable.nGetRotation(this.mNativePtr) : 0.0f;
        }

        private final void $$robo$$android_graphics_drawable_VectorDrawable_VGroup$setRotation(float rotation) {
            if (this.isTreeValid()) {
                VectorDrawable.nSetRotation(this.mNativePtr, rotation);
            }
        }

        private final float $$robo$$android_graphics_drawable_VectorDrawable_VGroup$getPivotX() {
            return this.isTreeValid() ? VectorDrawable.nGetPivotX(this.mNativePtr) : 0.0f;
        }

        private final void $$robo$$android_graphics_drawable_VectorDrawable_VGroup$setPivotX(float pivotX) {
            if (this.isTreeValid()) {
                VectorDrawable.nSetPivotX(this.mNativePtr, pivotX);
            }
        }

        private final float $$robo$$android_graphics_drawable_VectorDrawable_VGroup$getPivotY() {
            return this.isTreeValid() ? VectorDrawable.nGetPivotY(this.mNativePtr) : 0.0f;
        }

        private final void $$robo$$android_graphics_drawable_VectorDrawable_VGroup$setPivotY(float pivotY) {
            if (this.isTreeValid()) {
                VectorDrawable.nSetPivotY(this.mNativePtr, pivotY);
            }
        }

        private final float $$robo$$android_graphics_drawable_VectorDrawable_VGroup$getScaleX() {
            return this.isTreeValid() ? VectorDrawable.nGetScaleX(this.mNativePtr) : 0.0f;
        }

        private final void $$robo$$android_graphics_drawable_VectorDrawable_VGroup$setScaleX(float scaleX) {
            if (this.isTreeValid()) {
                VectorDrawable.nSetScaleX(this.mNativePtr, scaleX);
            }
        }

        private final float $$robo$$android_graphics_drawable_VectorDrawable_VGroup$getScaleY() {
            return this.isTreeValid() ? VectorDrawable.nGetScaleY(this.mNativePtr) : 0.0f;
        }

        private final void $$robo$$android_graphics_drawable_VectorDrawable_VGroup$setScaleY(float scaleY) {
            if (this.isTreeValid()) {
                VectorDrawable.nSetScaleY(this.mNativePtr, scaleY);
            }
        }

        private final float $$robo$$android_graphics_drawable_VectorDrawable_VGroup$getTranslateX() {
            return this.isTreeValid() ? VectorDrawable.nGetTranslateX(this.mNativePtr) : 0.0f;
        }

        private final void $$robo$$android_graphics_drawable_VectorDrawable_VGroup$setTranslateX(float translateX) {
            if (this.isTreeValid()) {
                VectorDrawable.nSetTranslateX(this.mNativePtr, translateX);
            }
        }

        private final float $$robo$$android_graphics_drawable_VectorDrawable_VGroup$getTranslateY() {
            return this.isTreeValid() ? VectorDrawable.nGetTranslateY(this.mNativePtr) : 0.0f;
        }

        private final void $$robo$$android_graphics_drawable_VectorDrawable_VGroup$setTranslateY(float translateY) {
            if (this.isTreeValid()) {
                VectorDrawable.nSetTranslateY(this.mNativePtr, translateY);
            }
        }

        static void __staticInitializer__() {
            sPropertyIndexMap = new HashMap<String, Integer>(){
                public /* synthetic */ Object __robo_data__;

                private void $$robo$$android_graphics_drawable_VectorDrawable_VGroup_1$__constructor__() {
                    this.put("translateX", 5);
                    this.put("translateY", 6);
                    this.put("scaleX", 3);
                    this.put("scaleY", 4);
                    this.put("pivotX", 1);
                    this.put("pivotY", 2);
                    this.put("rotation", 0);
                }

                private void __constructor__() {
                    this.$$robo$$android_graphics_drawable_VectorDrawable_VGroup_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_VectorDrawable_VGroup_1$__constructor__(), this);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
            TRANSLATE_X = new FloatProperty<VGroup>("translateX"){
                public /* synthetic */ Object __robo_data__;

                private void $$robo$$android_graphics_drawable_VectorDrawable_VGroup_2$__constructor__(String name) {
                }

                private final void $$robo$$android_graphics_drawable_VectorDrawable_VGroup_2$setValue(VGroup object, float value) {
                    object.setTranslateX(value);
                }

                private final Float $$robo$$android_graphics_drawable_VectorDrawable_VGroup_2$get(VGroup object) {
                    return Float.valueOf(object.getTranslateX());
                }

                private void __constructor__(String string2) {
                    this.$$robo$$android_graphics_drawable_VectorDrawable_VGroup_2$__constructor__(string2);
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_VectorDrawable_VGroup_2$__constructor__(java.lang.String ), this, string2);
                }

                @Override
                public void setValue(VGroup vGroup, float f) {
                    InvokeDynamicSupport.bootstrap("setValue", $$robo$$android_graphics_drawable_VectorDrawable_VGroup_2$setValue(android.graphics.drawable.VectorDrawable$VGroup float ), this, vGroup, f);
                }

                @Override
                public Float get(VGroup vGroup) {
                    return InvokeDynamicSupport.bootstrap("get", $$robo$$android_graphics_drawable_VectorDrawable_VGroup_2$get(android.graphics.drawable.VectorDrawable$VGroup ), this, vGroup);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
            TRANSLATE_Y = new FloatProperty<VGroup>("translateY"){
                public /* synthetic */ Object __robo_data__;

                private void $$robo$$android_graphics_drawable_VectorDrawable_VGroup_3$__constructor__(String name) {
                }

                private final void $$robo$$android_graphics_drawable_VectorDrawable_VGroup_3$setValue(VGroup object, float value) {
                    object.setTranslateY(value);
                }

                private final Float $$robo$$android_graphics_drawable_VectorDrawable_VGroup_3$get(VGroup object) {
                    return Float.valueOf(object.getTranslateY());
                }

                private void __constructor__(String string2) {
                    this.$$robo$$android_graphics_drawable_VectorDrawable_VGroup_3$__constructor__(string2);
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_VectorDrawable_VGroup_3$__constructor__(java.lang.String ), this, string2);
                }

                @Override
                public void setValue(VGroup vGroup, float f) {
                    InvokeDynamicSupport.bootstrap("setValue", $$robo$$android_graphics_drawable_VectorDrawable_VGroup_3$setValue(android.graphics.drawable.VectorDrawable$VGroup float ), this, vGroup, f);
                }

                @Override
                public Float get(VGroup vGroup) {
                    return InvokeDynamicSupport.bootstrap("get", $$robo$$android_graphics_drawable_VectorDrawable_VGroup_3$get(android.graphics.drawable.VectorDrawable$VGroup ), this, vGroup);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
            SCALE_X = new FloatProperty<VGroup>("scaleX"){
                public /* synthetic */ Object __robo_data__;

                private void $$robo$$android_graphics_drawable_VectorDrawable_VGroup_4$__constructor__(String name) {
                }

                private final void $$robo$$android_graphics_drawable_VectorDrawable_VGroup_4$setValue(VGroup object, float value) {
                    object.setScaleX(value);
                }

                private final Float $$robo$$android_graphics_drawable_VectorDrawable_VGroup_4$get(VGroup object) {
                    return Float.valueOf(object.getScaleX());
                }

                private void __constructor__(String string2) {
                    this.$$robo$$android_graphics_drawable_VectorDrawable_VGroup_4$__constructor__(string2);
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_VectorDrawable_VGroup_4$__constructor__(java.lang.String ), this, string2);
                }

                @Override
                public void setValue(VGroup vGroup, float f) {
                    InvokeDynamicSupport.bootstrap("setValue", $$robo$$android_graphics_drawable_VectorDrawable_VGroup_4$setValue(android.graphics.drawable.VectorDrawable$VGroup float ), this, vGroup, f);
                }

                @Override
                public Float get(VGroup vGroup) {
                    return InvokeDynamicSupport.bootstrap("get", $$robo$$android_graphics_drawable_VectorDrawable_VGroup_4$get(android.graphics.drawable.VectorDrawable$VGroup ), this, vGroup);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
            SCALE_Y = new FloatProperty<VGroup>("scaleY"){
                public /* synthetic */ Object __robo_data__;

                private void $$robo$$android_graphics_drawable_VectorDrawable_VGroup_5$__constructor__(String name) {
                }

                private final void $$robo$$android_graphics_drawable_VectorDrawable_VGroup_5$setValue(VGroup object, float value) {
                    object.setScaleY(value);
                }

                private final Float $$robo$$android_graphics_drawable_VectorDrawable_VGroup_5$get(VGroup object) {
                    return Float.valueOf(object.getScaleY());
                }

                private void __constructor__(String string2) {
                    this.$$robo$$android_graphics_drawable_VectorDrawable_VGroup_5$__constructor__(string2);
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_VectorDrawable_VGroup_5$__constructor__(java.lang.String ), this, string2);
                }

                @Override
                public void setValue(VGroup vGroup, float f) {
                    InvokeDynamicSupport.bootstrap("setValue", $$robo$$android_graphics_drawable_VectorDrawable_VGroup_5$setValue(android.graphics.drawable.VectorDrawable$VGroup float ), this, vGroup, f);
                }

                @Override
                public Float get(VGroup vGroup) {
                    return InvokeDynamicSupport.bootstrap("get", $$robo$$android_graphics_drawable_VectorDrawable_VGroup_5$get(android.graphics.drawable.VectorDrawable$VGroup ), this, vGroup);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
            PIVOT_X = new FloatProperty<VGroup>("pivotX"){
                public /* synthetic */ Object __robo_data__;

                private void $$robo$$android_graphics_drawable_VectorDrawable_VGroup_6$__constructor__(String name) {
                }

                private final void $$robo$$android_graphics_drawable_VectorDrawable_VGroup_6$setValue(VGroup object, float value) {
                    object.setPivotX(value);
                }

                private final Float $$robo$$android_graphics_drawable_VectorDrawable_VGroup_6$get(VGroup object) {
                    return Float.valueOf(object.getPivotX());
                }

                private void __constructor__(String string2) {
                    this.$$robo$$android_graphics_drawable_VectorDrawable_VGroup_6$__constructor__(string2);
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_VectorDrawable_VGroup_6$__constructor__(java.lang.String ), this, string2);
                }

                @Override
                public void setValue(VGroup vGroup, float f) {
                    InvokeDynamicSupport.bootstrap("setValue", $$robo$$android_graphics_drawable_VectorDrawable_VGroup_6$setValue(android.graphics.drawable.VectorDrawable$VGroup float ), this, vGroup, f);
                }

                @Override
                public Float get(VGroup vGroup) {
                    return InvokeDynamicSupport.bootstrap("get", $$robo$$android_graphics_drawable_VectorDrawable_VGroup_6$get(android.graphics.drawable.VectorDrawable$VGroup ), this, vGroup);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
            PIVOT_Y = new FloatProperty<VGroup>("pivotY"){
                public /* synthetic */ Object __robo_data__;

                private void $$robo$$android_graphics_drawable_VectorDrawable_VGroup_7$__constructor__(String name) {
                }

                private final void $$robo$$android_graphics_drawable_VectorDrawable_VGroup_7$setValue(VGroup object, float value) {
                    object.setPivotY(value);
                }

                private final Float $$robo$$android_graphics_drawable_VectorDrawable_VGroup_7$get(VGroup object) {
                    return Float.valueOf(object.getPivotY());
                }

                private void __constructor__(String string2) {
                    this.$$robo$$android_graphics_drawable_VectorDrawable_VGroup_7$__constructor__(string2);
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_VectorDrawable_VGroup_7$__constructor__(java.lang.String ), this, string2);
                }

                @Override
                public void setValue(VGroup vGroup, float f) {
                    InvokeDynamicSupport.bootstrap("setValue", $$robo$$android_graphics_drawable_VectorDrawable_VGroup_7$setValue(android.graphics.drawable.VectorDrawable$VGroup float ), this, vGroup, f);
                }

                @Override
                public Float get(VGroup vGroup) {
                    return InvokeDynamicSupport.bootstrap("get", $$robo$$android_graphics_drawable_VectorDrawable_VGroup_7$get(android.graphics.drawable.VectorDrawable$VGroup ), this, vGroup);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
            ROTATION = new FloatProperty<VGroup>("rotation"){
                public /* synthetic */ Object __robo_data__;

                private void $$robo$$android_graphics_drawable_VectorDrawable_VGroup_8$__constructor__(String name) {
                }

                private final void $$robo$$android_graphics_drawable_VectorDrawable_VGroup_8$setValue(VGroup object, float value) {
                    object.setRotation(value);
                }

                private final Float $$robo$$android_graphics_drawable_VectorDrawable_VGroup_8$get(VGroup object) {
                    return Float.valueOf(object.getRotation());
                }

                private void __constructor__(String string2) {
                    this.$$robo$$android_graphics_drawable_VectorDrawable_VGroup_8$__constructor__(string2);
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_VectorDrawable_VGroup_8$__constructor__(java.lang.String ), this, string2);
                }

                @Override
                public void setValue(VGroup vGroup, float f) {
                    InvokeDynamicSupport.bootstrap("setValue", $$robo$$android_graphics_drawable_VectorDrawable_VGroup_8$setValue(android.graphics.drawable.VectorDrawable$VGroup float ), this, vGroup, f);
                }

                @Override
                public Float get(VGroup vGroup) {
                    return InvokeDynamicSupport.bootstrap("get", $$robo$$android_graphics_drawable_VectorDrawable_VGroup_8$get(android.graphics.drawable.VectorDrawable$VGroup ), this, vGroup);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
            sPropertyMap = new HashMap<String, Property>(){
                public /* synthetic */ Object __robo_data__;

                private void $$robo$$android_graphics_drawable_VectorDrawable_VGroup_9$__constructor__() {
                    this.put("translateX", TRANSLATE_X);
                    this.put("translateY", TRANSLATE_Y);
                    this.put("scaleX", SCALE_X);
                    this.put("scaleY", SCALE_Y);
                    this.put("pivotX", PIVOT_X);
                    this.put("pivotY", PIVOT_Y);
                    this.put("rotation", ROTATION);
                }

                private void __constructor__() {
                    this.$$robo$$android_graphics_drawable_VectorDrawable_VGroup_9$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_VectorDrawable_VGroup_9$__constructor__(), this);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        static int getPropertyIndex(String string2) {
            return (int)InvokeDynamicSupport.bootstrapStatic("getPropertyIndex", $$robo$$android_graphics_drawable_VectorDrawable_VGroup$getPropertyIndex(java.lang.String ), (String)string2);
        }

        private void __constructor__(VGroup vGroup, ArrayMap<String, Object> arrayMap) {
            this.$$robo$$android_graphics_drawable_VectorDrawable_VGroup$__constructor__(vGroup, arrayMap);
        }

        public VGroup(VGroup vGroup, ArrayMap<String, Object> arrayMap) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_VectorDrawable_VGroup$__constructor__(android.graphics.drawable.VectorDrawable$VGroup android.util.ArrayMap<java.lang.String, java.lang.Object> ), this, vGroup, arrayMap);
        }

        private void __constructor__() {
            this.$$robo$$android_graphics_drawable_VectorDrawable_VGroup$__constructor__();
        }

        public VGroup() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_VectorDrawable_VGroup$__constructor__(), this);
        }

        @Override
        Property getProperty(String string2) {
            return InvokeDynamicSupport.bootstrap("getProperty", $$robo$$android_graphics_drawable_VectorDrawable_VGroup$getProperty(java.lang.String ), this, string2);
        }

        public String getGroupName() {
            return InvokeDynamicSupport.bootstrap("getGroupName", $$robo$$android_graphics_drawable_VectorDrawable_VGroup$getGroupName(), this);
        }

        public void addChild(VObject vObject) {
            InvokeDynamicSupport.bootstrap("addChild", $$robo$$android_graphics_drawable_VectorDrawable_VGroup$addChild(android.graphics.drawable.VectorDrawable$VObject ), this, vObject);
        }

        @Override
        public void setTree(VirtualRefBasePtr virtualRefBasePtr) {
            InvokeDynamicSupport.bootstrap("setTree", $$robo$$android_graphics_drawable_VectorDrawable_VGroup$setTree(com.android.internal.util.VirtualRefBasePtr ), this, virtualRefBasePtr);
        }

        @Override
        public long getNativePtr() {
            return (long)InvokeDynamicSupport.bootstrap("getNativePtr", $$robo$$android_graphics_drawable_VectorDrawable_VGroup$getNativePtr(), this);
        }

        @Override
        public void inflate(Resources resources, AttributeSet attributeSet, Resources.Theme theme) {
            InvokeDynamicSupport.bootstrap("inflate", $$robo$$android_graphics_drawable_VectorDrawable_VGroup$inflate(android.content.res.Resources android.util.AttributeSet android.content.res.Resources$Theme ), this, resources, attributeSet, theme);
        }

        void updateStateFromTypedArray(TypedArray typedArray) {
            InvokeDynamicSupport.bootstrap("updateStateFromTypedArray", $$robo$$android_graphics_drawable_VectorDrawable_VGroup$updateStateFromTypedArray(android.content.res.TypedArray ), this, typedArray);
        }

        @Override
        public boolean onStateChange(int[] nArray) {
            return (boolean)InvokeDynamicSupport.bootstrap("onStateChange", $$robo$$android_graphics_drawable_VectorDrawable_VGroup$onStateChange(int[] ), this, nArray);
        }

        @Override
        public boolean isStateful() {
            return (boolean)InvokeDynamicSupport.bootstrap("isStateful", $$robo$$android_graphics_drawable_VectorDrawable_VGroup$isStateful(), this);
        }

        @Override
        public boolean hasFocusStateSpecified() {
            return (boolean)InvokeDynamicSupport.bootstrap("hasFocusStateSpecified", $$robo$$android_graphics_drawable_VectorDrawable_VGroup$hasFocusStateSpecified(), this);
        }

        @Override
        int getNativeSize() {
            return (int)InvokeDynamicSupport.bootstrap("getNativeSize", $$robo$$android_graphics_drawable_VectorDrawable_VGroup$getNativeSize(), this);
        }

        @Override
        public boolean canApplyTheme() {
            return (boolean)InvokeDynamicSupport.bootstrap("canApplyTheme", $$robo$$android_graphics_drawable_VectorDrawable_VGroup$canApplyTheme(), this);
        }

        @Override
        public void applyTheme(Resources.Theme theme) {
            InvokeDynamicSupport.bootstrap("applyTheme", $$robo$$android_graphics_drawable_VectorDrawable_VGroup$applyTheme(android.content.res.Resources$Theme ), this, theme);
        }

        public float getRotation() {
            return (float)InvokeDynamicSupport.bootstrap("getRotation", $$robo$$android_graphics_drawable_VectorDrawable_VGroup$getRotation(), this);
        }

        public void setRotation(float f) {
            InvokeDynamicSupport.bootstrap("setRotation", $$robo$$android_graphics_drawable_VectorDrawable_VGroup$setRotation(float ), this, f);
        }

        public float getPivotX() {
            return (float)InvokeDynamicSupport.bootstrap("getPivotX", $$robo$$android_graphics_drawable_VectorDrawable_VGroup$getPivotX(), this);
        }

        public void setPivotX(float f) {
            InvokeDynamicSupport.bootstrap("setPivotX", $$robo$$android_graphics_drawable_VectorDrawable_VGroup$setPivotX(float ), this, f);
        }

        public float getPivotY() {
            return (float)InvokeDynamicSupport.bootstrap("getPivotY", $$robo$$android_graphics_drawable_VectorDrawable_VGroup$getPivotY(), this);
        }

        public void setPivotY(float f) {
            InvokeDynamicSupport.bootstrap("setPivotY", $$robo$$android_graphics_drawable_VectorDrawable_VGroup$setPivotY(float ), this, f);
        }

        public float getScaleX() {
            return (float)InvokeDynamicSupport.bootstrap("getScaleX", $$robo$$android_graphics_drawable_VectorDrawable_VGroup$getScaleX(), this);
        }

        public void setScaleX(float f) {
            InvokeDynamicSupport.bootstrap("setScaleX", $$robo$$android_graphics_drawable_VectorDrawable_VGroup$setScaleX(float ), this, f);
        }

        public float getScaleY() {
            return (float)InvokeDynamicSupport.bootstrap("getScaleY", $$robo$$android_graphics_drawable_VectorDrawable_VGroup$getScaleY(), this);
        }

        public void setScaleY(float f) {
            InvokeDynamicSupport.bootstrap("setScaleY", $$robo$$android_graphics_drawable_VectorDrawable_VGroup$setScaleY(float ), this, f);
        }

        public float getTranslateX() {
            return (float)InvokeDynamicSupport.bootstrap("getTranslateX", $$robo$$android_graphics_drawable_VectorDrawable_VGroup$getTranslateX(), this);
        }

        public void setTranslateX(float f) {
            InvokeDynamicSupport.bootstrap("setTranslateX", $$robo$$android_graphics_drawable_VectorDrawable_VGroup$setTranslateX(float ), this, f);
        }

        public float getTranslateY() {
            return (float)InvokeDynamicSupport.bootstrap("getTranslateY", $$robo$$android_graphics_drawable_VectorDrawable_VGroup$getTranslateY(), this);
        }

        public void setTranslateY(float f) {
            InvokeDynamicSupport.bootstrap("setTranslateY", $$robo$$android_graphics_drawable_VectorDrawable_VGroup$setTranslateY(float ), this, f);
        }

        static {
            RobolectricInternals.classInitializing(VGroup.class);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (VGroup)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class VectorDrawableState
    extends Drawable.ConstantState
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        int[] mThemeAttrs;
        int mChangingConfigurations;
        ColorStateList mTint;
        PorterDuff.Mode mTintMode;
        boolean mAutoMirrored;
        int mBaseWidth;
        int mBaseHeight;
        float mViewportWidth;
        float mViewportHeight;
        Insets mOpticalInsets;
        String mRootName;
        VGroup mRootGroup;
        VirtualRefBasePtr mNativeTree;
        int mDensity;
        ArrayMap<String, Object> mVGTargetsMap;
        int[] mCachedThemeAttrs;
        ColorStateList mCachedTint;
        PorterDuff.Mode mCachedTintMode;
        boolean mCachedAutoMirrored;
        boolean mCacheDirty;
        int mLastSWCachePixelCount;
        int mLastHWCachePixelCount;
        static Property<VectorDrawableState, Float> ALPHA;
        private int mAllocationOfAllNodes;
        private static int NATIVE_ALLOCATION_SIZE = 316;

        private final Property $$robo$$android_graphics_drawable_VectorDrawable_VectorDrawableState$getProperty(String propertyName) {
            if (ALPHA.getName().equals(propertyName)) {
                return ALPHA;
            }
            return null;
        }

        private void $$robo$$android_graphics_drawable_VectorDrawable_VectorDrawableState$__constructor__(VectorDrawableState copy) {
            this.mTint = null;
            this.mTintMode = Drawable.DEFAULT_TINT_MODE;
            this.mBaseWidth = 0;
            this.mBaseHeight = 0;
            this.mViewportWidth = 0.0f;
            this.mViewportHeight = 0.0f;
            this.mOpticalInsets = Insets.NONE;
            this.mRootName = null;
            this.mNativeTree = null;
            this.mDensity = 160;
            this.mVGTargetsMap = new ArrayMap();
            this.mLastSWCachePixelCount = 0;
            this.mLastHWCachePixelCount = 0;
            this.mAllocationOfAllNodes = 0;
            if (copy != null) {
                this.mThemeAttrs = copy.mThemeAttrs;
                this.mChangingConfigurations = copy.mChangingConfigurations;
                this.mTint = copy.mTint;
                this.mTintMode = copy.mTintMode;
                this.mAutoMirrored = copy.mAutoMirrored;
                this.mRootGroup = new VGroup(copy.mRootGroup, this.mVGTargetsMap);
                this.createNativeTreeFromCopy(copy, this.mRootGroup);
                this.mBaseWidth = copy.mBaseWidth;
                this.mBaseHeight = copy.mBaseHeight;
                this.setViewportSize(copy.mViewportWidth, copy.mViewportHeight);
                this.mOpticalInsets = copy.mOpticalInsets;
                this.mRootName = copy.mRootName;
                this.mDensity = copy.mDensity;
                if (copy.mRootName != null) {
                    this.mVGTargetsMap.put(copy.mRootName, this);
                }
            } else {
                this.mRootGroup = new VGroup();
                this.createNativeTree(this.mRootGroup);
            }
            this.onTreeConstructionFinished();
        }

        private final void $$robo$$android_graphics_drawable_VectorDrawable_VectorDrawableState$createNativeTree(VGroup rootGroup) {
            this.mNativeTree = new VirtualRefBasePtr(VectorDrawable.nCreateTree(rootGroup.mNativePtr));
            VMRuntime.getRuntime().registerNativeAllocation(316);
        }

        private final void $$robo$$android_graphics_drawable_VectorDrawable_VectorDrawableState$createNativeTreeFromCopy(VectorDrawableState copy, VGroup rootGroup) {
            this.mNativeTree = new VirtualRefBasePtr(VectorDrawable.nCreateTreeFromCopy(copy.mNativeTree.get(), rootGroup.mNativePtr));
            VMRuntime.getRuntime().registerNativeAllocation(316);
        }

        private final void $$robo$$android_graphics_drawable_VectorDrawable_VectorDrawableState$onTreeConstructionFinished() {
            this.mRootGroup.setTree(this.mNativeTree);
            this.mAllocationOfAllNodes = this.mRootGroup.getNativeSize();
            VMRuntime.getRuntime().registerNativeAllocation(this.mAllocationOfAllNodes);
        }

        private final long $$robo$$android_graphics_drawable_VectorDrawable_VectorDrawableState$getNativeRenderer() {
            if (this.mNativeTree == null) {
                return 0L;
            }
            return this.mNativeTree.get();
        }

        private final boolean $$robo$$android_graphics_drawable_VectorDrawable_VectorDrawableState$canReuseCache() {
            if (!this.mCacheDirty && this.mCachedThemeAttrs == this.mThemeAttrs && this.mCachedTint == this.mTint && this.mCachedTintMode == this.mTintMode && this.mCachedAutoMirrored == this.mAutoMirrored) {
                return true;
            }
            this.updateCacheStates();
            return false;
        }

        private final void $$robo$$android_graphics_drawable_VectorDrawable_VectorDrawableState$updateCacheStates() {
            this.mCachedThemeAttrs = this.mThemeAttrs;
            this.mCachedTint = this.mTint;
            this.mCachedTintMode = this.mTintMode;
            this.mCachedAutoMirrored = this.mAutoMirrored;
            this.mCacheDirty = false;
        }

        private final void $$robo$$android_graphics_drawable_VectorDrawable_VectorDrawableState$applyTheme(Resources.Theme t) {
            this.mRootGroup.applyTheme(t);
        }

        private final boolean $$robo$$android_graphics_drawable_VectorDrawable_VectorDrawableState$canApplyTheme() {
            return this.mThemeAttrs != null || this.mRootGroup != null && this.mRootGroup.canApplyTheme() || this.mTint != null && this.mTint.canApplyTheme() || super.canApplyTheme();
        }

        private final Drawable $$robo$$android_graphics_drawable_VectorDrawable_VectorDrawableState$newDrawable() {
            return new VectorDrawable(this, null, null);
        }

        private final Drawable $$robo$$android_graphics_drawable_VectorDrawable_VectorDrawableState$newDrawable(Resources res) {
            return new VectorDrawable(this, res, null);
        }

        private final int $$robo$$android_graphics_drawable_VectorDrawable_VectorDrawableState$getChangingConfigurations() {
            return this.mChangingConfigurations | (this.mTint != null ? this.mTint.getChangingConfigurations() : 0);
        }

        private final boolean $$robo$$android_graphics_drawable_VectorDrawable_VectorDrawableState$isStateful() {
            return this.mTint != null && this.mTint.isStateful() || this.mRootGroup != null && this.mRootGroup.isStateful();
        }

        private final boolean $$robo$$android_graphics_drawable_VectorDrawable_VectorDrawableState$hasFocusStateSpecified() {
            return this.mTint != null && this.mTint.hasFocusStateSpecified() || this.mRootGroup != null && this.mRootGroup.hasFocusStateSpecified();
        }

        private final void $$robo$$android_graphics_drawable_VectorDrawable_VectorDrawableState$setViewportSize(float viewportWidth, float viewportHeight) {
            this.mViewportWidth = viewportWidth;
            this.mViewportHeight = viewportHeight;
            VectorDrawable.nSetRendererViewportSize(this.getNativeRenderer(), viewportWidth, viewportHeight);
        }

        private final boolean $$robo$$android_graphics_drawable_VectorDrawable_VectorDrawableState$setDensity(int targetDensity) {
            if (this.mDensity != targetDensity) {
                int sourceDensity = this.mDensity;
                this.mDensity = targetDensity;
                this.applyDensityScaling(sourceDensity, targetDensity);
                return true;
            }
            return false;
        }

        private final void $$robo$$android_graphics_drawable_VectorDrawable_VectorDrawableState$applyDensityScaling(int sourceDensity, int targetDensity) {
            this.mBaseWidth = Drawable.scaleFromDensity(this.mBaseWidth, sourceDensity, targetDensity, true);
            this.mBaseHeight = Drawable.scaleFromDensity(this.mBaseHeight, sourceDensity, targetDensity, true);
            int insetLeft = Drawable.scaleFromDensity(this.mOpticalInsets.left, sourceDensity, targetDensity, false);
            int insetTop = Drawable.scaleFromDensity(this.mOpticalInsets.top, sourceDensity, targetDensity, false);
            int insetRight = Drawable.scaleFromDensity(this.mOpticalInsets.right, sourceDensity, targetDensity, false);
            int insetBottom = Drawable.scaleFromDensity(this.mOpticalInsets.bottom, sourceDensity, targetDensity, false);
            this.mOpticalInsets = Insets.of(insetLeft, insetTop, insetRight, insetBottom);
        }

        private final boolean $$robo$$android_graphics_drawable_VectorDrawable_VectorDrawableState$onStateChange(int[] stateSet) {
            return this.mRootGroup.onStateChange(stateSet);
        }

        private final void $$robo$$android_graphics_drawable_VectorDrawable_VectorDrawableState$finalize() throws Throwable {
            super.finalize();
            int bitmapCacheSize = this.mLastHWCachePixelCount * 4 + this.mLastSWCachePixelCount * 4;
            VMRuntime.getRuntime().registerNativeFree(316 + this.mAllocationOfAllNodes + bitmapCacheSize);
        }

        private final boolean $$robo$$android_graphics_drawable_VectorDrawable_VectorDrawableState$setAlpha(float alpha) {
            return VectorDrawable.nSetRootAlpha(this.mNativeTree.get(), alpha);
        }

        private final float $$robo$$android_graphics_drawable_VectorDrawable_VectorDrawableState$getAlpha() {
            return VectorDrawable.nGetRootAlpha(this.mNativeTree.get());
        }

        static void __staticInitializer__() {
            ALPHA = new FloatProperty<VectorDrawableState>("alpha"){
                public /* synthetic */ Object __robo_data__;

                private void $$robo$$android_graphics_drawable_VectorDrawable_VectorDrawableState_1$__constructor__(String name) {
                }

                private final void $$robo$$android_graphics_drawable_VectorDrawable_VectorDrawableState_1$setValue(VectorDrawableState state, float value) {
                    state.setAlpha(value);
                }

                private final Float $$robo$$android_graphics_drawable_VectorDrawable_VectorDrawableState_1$get(VectorDrawableState state) {
                    return Float.valueOf(state.getAlpha());
                }

                private void __constructor__(String string2) {
                    this.$$robo$$android_graphics_drawable_VectorDrawable_VectorDrawableState_1$__constructor__(string2);
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_VectorDrawable_VectorDrawableState_1$__constructor__(java.lang.String ), this, string2);
                }

                @Override
                public void setValue(VectorDrawableState vectorDrawableState, float f) {
                    InvokeDynamicSupport.bootstrap("setValue", $$robo$$android_graphics_drawable_VectorDrawable_VectorDrawableState_1$setValue(android.graphics.drawable.VectorDrawable$VectorDrawableState float ), this, vectorDrawableState, f);
                }

                @Override
                public Float get(VectorDrawableState vectorDrawableState) {
                    return InvokeDynamicSupport.bootstrap("get", $$robo$$android_graphics_drawable_VectorDrawable_VectorDrawableState_1$get(android.graphics.drawable.VectorDrawable$VectorDrawableState ), this, vectorDrawableState);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        Property getProperty(String string2) {
            return InvokeDynamicSupport.bootstrap("getProperty", $$robo$$android_graphics_drawable_VectorDrawable_VectorDrawableState$getProperty(java.lang.String ), this, string2);
        }

        private void __constructor__(VectorDrawableState vectorDrawableState) {
            this.$$robo$$android_graphics_drawable_VectorDrawable_VectorDrawableState$__constructor__(vectorDrawableState);
        }

        public VectorDrawableState(VectorDrawableState vectorDrawableState) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_VectorDrawable_VectorDrawableState$__constructor__(android.graphics.drawable.VectorDrawable$VectorDrawableState ), this, vectorDrawableState);
        }

        private void createNativeTree(VGroup vGroup) {
            InvokeDynamicSupport.bootstrap("createNativeTree", $$robo$$android_graphics_drawable_VectorDrawable_VectorDrawableState$createNativeTree(android.graphics.drawable.VectorDrawable$VGroup ), this, vGroup);
        }

        private void createNativeTreeFromCopy(VectorDrawableState vectorDrawableState, VGroup vGroup) {
            InvokeDynamicSupport.bootstrap("createNativeTreeFromCopy", $$robo$$android_graphics_drawable_VectorDrawable_VectorDrawableState$createNativeTreeFromCopy(android.graphics.drawable.VectorDrawable$VectorDrawableState android.graphics.drawable.VectorDrawable$VGroup ), this, vectorDrawableState, vGroup);
        }

        void onTreeConstructionFinished() {
            InvokeDynamicSupport.bootstrap("onTreeConstructionFinished", $$robo$$android_graphics_drawable_VectorDrawable_VectorDrawableState$onTreeConstructionFinished(), this);
        }

        long getNativeRenderer() {
            return (long)InvokeDynamicSupport.bootstrap("getNativeRenderer", $$robo$$android_graphics_drawable_VectorDrawable_VectorDrawableState$getNativeRenderer(), this);
        }

        public boolean canReuseCache() {
            return (boolean)InvokeDynamicSupport.bootstrap("canReuseCache", $$robo$$android_graphics_drawable_VectorDrawable_VectorDrawableState$canReuseCache(), this);
        }

        public void updateCacheStates() {
            InvokeDynamicSupport.bootstrap("updateCacheStates", $$robo$$android_graphics_drawable_VectorDrawable_VectorDrawableState$updateCacheStates(), this);
        }

        public void applyTheme(Resources.Theme theme) {
            InvokeDynamicSupport.bootstrap("applyTheme", $$robo$$android_graphics_drawable_VectorDrawable_VectorDrawableState$applyTheme(android.content.res.Resources$Theme ), this, theme);
        }

        @Override
        public boolean canApplyTheme() {
            return (boolean)InvokeDynamicSupport.bootstrap("canApplyTheme", $$robo$$android_graphics_drawable_VectorDrawable_VectorDrawableState$canApplyTheme(), this);
        }

        @Override
        public Drawable newDrawable() {
            return InvokeDynamicSupport.bootstrap("newDrawable", $$robo$$android_graphics_drawable_VectorDrawable_VectorDrawableState$newDrawable(), this);
        }

        @Override
        public Drawable newDrawable(Resources resources) {
            return InvokeDynamicSupport.bootstrap("newDrawable", $$robo$$android_graphics_drawable_VectorDrawable_VectorDrawableState$newDrawable(android.content.res.Resources ), this, resources);
        }

        @Override
        public int getChangingConfigurations() {
            return (int)InvokeDynamicSupport.bootstrap("getChangingConfigurations", $$robo$$android_graphics_drawable_VectorDrawable_VectorDrawableState$getChangingConfigurations(), this);
        }

        public boolean isStateful() {
            return (boolean)InvokeDynamicSupport.bootstrap("isStateful", $$robo$$android_graphics_drawable_VectorDrawable_VectorDrawableState$isStateful(), this);
        }

        public boolean hasFocusStateSpecified() {
            return (boolean)InvokeDynamicSupport.bootstrap("hasFocusStateSpecified", $$robo$$android_graphics_drawable_VectorDrawable_VectorDrawableState$hasFocusStateSpecified(), this);
        }

        void setViewportSize(float f, float f2) {
            InvokeDynamicSupport.bootstrap("setViewportSize", $$robo$$android_graphics_drawable_VectorDrawable_VectorDrawableState$setViewportSize(float float ), this, f, f2);
        }

        public boolean setDensity(int n) {
            return (boolean)InvokeDynamicSupport.bootstrap("setDensity", $$robo$$android_graphics_drawable_VectorDrawable_VectorDrawableState$setDensity(int ), this, n);
        }

        private void applyDensityScaling(int n, int n2) {
            InvokeDynamicSupport.bootstrap("applyDensityScaling", $$robo$$android_graphics_drawable_VectorDrawable_VectorDrawableState$applyDensityScaling(int int ), this, n, n2);
        }

        public boolean onStateChange(int[] nArray) {
            return (boolean)InvokeDynamicSupport.bootstrap("onStateChange", $$robo$$android_graphics_drawable_VectorDrawable_VectorDrawableState$onStateChange(int[] ), this, nArray);
        }

        public void finalize() throws Throwable {
            InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_graphics_drawable_VectorDrawable_VectorDrawableState$finalize(), this);
        }

        public boolean setAlpha(float f) {
            return (boolean)InvokeDynamicSupport.bootstrap("setAlpha", $$robo$$android_graphics_drawable_VectorDrawable_VectorDrawableState$setAlpha(float ), this, f);
        }

        public float getAlpha() {
            return (float)InvokeDynamicSupport.bootstrap("getAlpha", $$robo$$android_graphics_drawable_VectorDrawable_VectorDrawableState$getAlpha(), this);
        }

        static {
            RobolectricInternals.classInitializing(VectorDrawableState.class);
        }

        public /* synthetic */ VectorDrawableState() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (VectorDrawableState)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

