/*
 * Decompiled with CFR 0.152.
 */
package android.hardware;

import android.app.ActivityThread;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.SurfaceTexture;
import android.media.IAudioService;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.renderscript.Allocation;
import android.renderscript.Element;
import android.renderscript.RSIllegalArgumentException;
import android.renderscript.RenderScript;
import android.renderscript.Type;
import android.system.OsConstants;
import android.text.TextUtils;
import android.util.Log;
import android.view.Surface;
import android.view.SurfaceHolder;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@Deprecated
public class Camera
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "Camera";
    private static int CAMERA_MSG_ERROR = 1;
    private static int CAMERA_MSG_SHUTTER = 2;
    private static int CAMERA_MSG_FOCUS = 4;
    private static int CAMERA_MSG_ZOOM = 8;
    private static int CAMERA_MSG_PREVIEW_FRAME = 16;
    private static int CAMERA_MSG_VIDEO_FRAME = 32;
    private static int CAMERA_MSG_POSTVIEW_FRAME = 64;
    private static int CAMERA_MSG_RAW_IMAGE = 128;
    private static int CAMERA_MSG_COMPRESSED_IMAGE = 256;
    private static int CAMERA_MSG_RAW_IMAGE_NOTIFY = 512;
    private static int CAMERA_MSG_PREVIEW_METADATA = 1024;
    private static int CAMERA_MSG_FOCUS_MOVE = 2048;
    private long mNativeContext;
    private EventHandler mEventHandler;
    private ShutterCallback mShutterCallback;
    private PictureCallback mRawImageCallback;
    private PictureCallback mJpegCallback;
    private PreviewCallback mPreviewCallback;
    private boolean mUsingPreviewAllocation;
    private PictureCallback mPostviewCallback;
    private AutoFocusCallback mAutoFocusCallback;
    private AutoFocusMoveCallback mAutoFocusMoveCallback;
    private OnZoomChangeListener mZoomListener;
    private FaceDetectionListener mFaceListener;
    private ErrorCallback mErrorCallback;
    private boolean mOneShot;
    private boolean mWithBuffer;
    private boolean mFaceDetectionRunning;
    private Object mAutoFocusCallbackLock;
    private static int NO_ERROR = 0;
    public static String ACTION_NEW_PICTURE = "android.hardware.action.NEW_PICTURE";
    public static String ACTION_NEW_VIDEO = "android.hardware.action.NEW_VIDEO";
    public static int CAMERA_HAL_API_VERSION_1_0 = 256;
    private static int CAMERA_HAL_API_VERSION_NORMAL_CONNECT = -2;
    private static int CAMERA_HAL_API_VERSION_UNSPECIFIED = -1;
    private static int CAMERA_FACE_DETECTION_HW = 0;
    private static int CAMERA_FACE_DETECTION_SW = 1;
    public static int CAMERA_ERROR_UNKNOWN = 1;
    public static int CAMERA_ERROR_EVICTED = 2;
    public static int CAMERA_ERROR_SERVER_DIED = 100;

    private static final int $$robo$$android_hardware_Camera$getNumberOfCameras() {
        return 0;
    }

    private static final void $$robo$$android_hardware_Camera$getCameraInfo(int cameraId, CameraInfo cameraInfo) {
        Camera._getCameraInfo(cameraId, cameraInfo);
        IBinder b = ServiceManager.getService("audio");
        IAudioService audioService = IAudioService.Stub.asInterface(b);
        try {
            if (audioService.isCameraSoundForced()) {
                cameraInfo.canDisableShutterSound = false;
            }
        }
        catch (RemoteException e) {
            Log.e("Camera", "Audio service is unavailable for queries");
        }
    }

    private static final void $$robo$$android_hardware_Camera$_getCameraInfo(int n, CameraInfo cameraInfo) {
    }

    private static final Camera $$robo$$android_hardware_Camera$open(int cameraId) {
        return new Camera(cameraId);
    }

    private static final Camera $$robo$$android_hardware_Camera$open() {
        int numberOfCameras = Camera.getNumberOfCameras();
        CameraInfo cameraInfo = new CameraInfo();
        for (int i = 0; i < numberOfCameras; ++i) {
            Camera.getCameraInfo(i, cameraInfo);
            if (cameraInfo.facing != 0) continue;
            return new Camera(i);
        }
        return null;
    }

    private static final Camera $$robo$$android_hardware_Camera$openLegacy(int cameraId, int halVersion) {
        if (halVersion < 256) {
            throw new IllegalArgumentException("Invalid HAL version " + halVersion);
        }
        return new Camera(cameraId, halVersion);
    }

    private void $$robo$$android_hardware_Camera$__constructor__(int cameraId, int halVersion) {
        this.mFaceDetectionRunning = false;
        this.mAutoFocusCallbackLock = new Object();
        int err = this.cameraInitVersion(cameraId, halVersion);
        if (Camera.checkInitErrors(err)) {
            if (err == -OsConstants.EACCES) {
                throw new RuntimeException("Fail to connect to camera service");
            }
            if (err == -OsConstants.ENODEV) {
                throw new RuntimeException("Camera initialization failed");
            }
            if (err == -OsConstants.ENOSYS) {
                throw new RuntimeException("Camera initialization failed because some methods are not implemented");
            }
            if (err == -OsConstants.EOPNOTSUPP) {
                throw new RuntimeException("Camera initialization failed because the hal version is not supported by this device");
            }
            if (err == -OsConstants.EINVAL) {
                throw new RuntimeException("Camera initialization failed because the input arugments are invalid");
            }
            if (err == -OsConstants.EBUSY) {
                throw new RuntimeException("Camera initialization failed because the camera device was already opened");
            }
            if (err == -OsConstants.EUSERS) {
                throw new RuntimeException("Camera initialization failed because the max number of camera devices were already opened");
            }
            throw new RuntimeException("Unknown camera error");
        }
    }

    private final int $$robo$$android_hardware_Camera$cameraInitVersion(int cameraId, int halVersion) {
        this.mShutterCallback = null;
        this.mRawImageCallback = null;
        this.mJpegCallback = null;
        this.mPreviewCallback = null;
        this.mPostviewCallback = null;
        this.mUsingPreviewAllocation = false;
        this.mZoomListener = null;
        Looper looper = Looper.myLooper();
        this.mEventHandler = looper != null ? new EventHandler(this, this, looper) : ((looper = Looper.getMainLooper()) != null ? new EventHandler(this, this, looper) : null);
        return this.native_setup(new WeakReference<Camera>(this), cameraId, halVersion, ActivityThread.currentOpPackageName());
    }

    private final int $$robo$$android_hardware_Camera$cameraInitNormal(int cameraId) {
        return this.cameraInitVersion(cameraId, -2);
    }

    private final int $$robo$$android_hardware_Camera$cameraInitUnspecified(int cameraId) {
        return this.cameraInitVersion(cameraId, -1);
    }

    private void $$robo$$android_hardware_Camera$__constructor__(int cameraId) {
        this.mFaceDetectionRunning = false;
        this.mAutoFocusCallbackLock = new Object();
        int err = this.cameraInitNormal(cameraId);
        if (Camera.checkInitErrors(err)) {
            if (err == -OsConstants.EACCES) {
                throw new RuntimeException("Fail to connect to camera service");
            }
            if (err == -OsConstants.ENODEV) {
                throw new RuntimeException("Camera initialization failed");
            }
            throw new RuntimeException("Unknown camera error");
        }
    }

    private static final boolean $$robo$$android_hardware_Camera$checkInitErrors(int err) {
        return err != 0;
    }

    private static final Camera $$robo$$android_hardware_Camera$openUninitialized() {
        return new Camera();
    }

    private void $$robo$$android_hardware_Camera$__constructor__() {
        this.mFaceDetectionRunning = false;
        this.mAutoFocusCallbackLock = new Object();
    }

    private final void $$robo$$android_hardware_Camera$finalize() {
        this.release();
    }

    private final int $$robo$$android_hardware_Camera$native_setup(Object object, int n, int n2, String string2) {
        return 0;
    }

    private final void $$robo$$android_hardware_Camera$native_release() {
    }

    private final void $$robo$$android_hardware_Camera$release() {
        this.native_release();
        this.mFaceDetectionRunning = false;
    }

    private final void $$robo$$android_hardware_Camera$unlock() {
    }

    private final void $$robo$$android_hardware_Camera$lock() {
    }

    private final void $$robo$$android_hardware_Camera$reconnect() throws IOException {
    }

    private final void $$robo$$android_hardware_Camera$setPreviewDisplay(SurfaceHolder holder) throws IOException {
        if (holder != null) {
            this.setPreviewSurface(holder.getSurface());
        } else {
            this.setPreviewSurface(null);
        }
    }

    private final void $$robo$$android_hardware_Camera$setPreviewSurface(Surface surface) throws IOException {
    }

    private final void $$robo$$android_hardware_Camera$setPreviewTexture(SurfaceTexture surfaceTexture) throws IOException {
    }

    private final void $$robo$$android_hardware_Camera$startPreview() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_hardware_Camera$stopPreview() {
        this._stopPreview();
        this.mFaceDetectionRunning = false;
        this.mShutterCallback = null;
        this.mRawImageCallback = null;
        this.mPostviewCallback = null;
        this.mJpegCallback = null;
        Object object = this.mAutoFocusCallbackLock;
        synchronized (object) {
            this.mAutoFocusCallback = null;
        }
        this.mAutoFocusMoveCallback = null;
    }

    private final void $$robo$$android_hardware_Camera$_stopPreview() {
    }

    private final boolean $$robo$$android_hardware_Camera$previewEnabled() {
        return false;
    }

    private final void $$robo$$android_hardware_Camera$setPreviewCallback(PreviewCallback cb) {
        this.mPreviewCallback = cb;
        this.mOneShot = false;
        this.mWithBuffer = false;
        if (cb != null) {
            this.mUsingPreviewAllocation = false;
        }
        this.setHasPreviewCallback(cb != null, false);
    }

    private final void $$robo$$android_hardware_Camera$setOneShotPreviewCallback(PreviewCallback cb) {
        this.mPreviewCallback = cb;
        this.mOneShot = true;
        this.mWithBuffer = false;
        if (cb != null) {
            this.mUsingPreviewAllocation = false;
        }
        this.setHasPreviewCallback(cb != null, false);
    }

    private final void $$robo$$android_hardware_Camera$setHasPreviewCallback(boolean bl, boolean bl2) {
    }

    private final void $$robo$$android_hardware_Camera$setPreviewCallbackWithBuffer(PreviewCallback cb) {
        this.mPreviewCallback = cb;
        this.mOneShot = false;
        this.mWithBuffer = true;
        if (cb != null) {
            this.mUsingPreviewAllocation = false;
        }
        this.setHasPreviewCallback(cb != null, true);
    }

    private final void $$robo$$android_hardware_Camera$addCallbackBuffer(byte[] callbackBuffer) {
        this._addCallbackBuffer(callbackBuffer, 16);
    }

    private final void $$robo$$android_hardware_Camera$addRawImageCallbackBuffer(byte[] callbackBuffer) {
        this.addCallbackBuffer(callbackBuffer, 128);
    }

    private final void $$robo$$android_hardware_Camera$addCallbackBuffer(byte[] callbackBuffer, int msgType) {
        if (msgType != 16 && msgType != 128) {
            throw new IllegalArgumentException("Unsupported message type: " + msgType);
        }
        this._addCallbackBuffer(callbackBuffer, msgType);
    }

    private final void $$robo$$android_hardware_Camera$_addCallbackBuffer(byte[] byArray, int n) {
    }

    private final Allocation $$robo$$android_hardware_Camera$createPreviewAllocation(RenderScript rs, int usage) throws RSIllegalArgumentException {
        Parameters p = this.getParameters();
        Size previewSize = p.getPreviewSize();
        Type.Builder yuvBuilder = new Type.Builder(rs, Element.createPixel(rs, Element.DataType.UNSIGNED_8, Element.DataKind.PIXEL_YUV));
        yuvBuilder.setYuvFormat(842094169);
        yuvBuilder.setX(previewSize.width);
        yuvBuilder.setY(previewSize.height);
        Allocation a = Allocation.createTyped(rs, yuvBuilder.create(), usage | 0x20);
        return a;
    }

    private final void $$robo$$android_hardware_Camera$setPreviewCallbackAllocation(Allocation previewAllocation) throws IOException {
        Surface previewSurface = null;
        if (previewAllocation != null) {
            Parameters p = this.getParameters();
            Size previewSize = p.getPreviewSize();
            if (previewSize.width != previewAllocation.getType().getX() || previewSize.height != previewAllocation.getType().getY()) {
                throw new IllegalArgumentException("Allocation dimensions don't match preview dimensions: Allocation is " + previewAllocation.getType().getX() + ", " + previewAllocation.getType().getY() + ". Preview is " + previewSize.width + ", " + previewSize.height);
            }
            if ((previewAllocation.getUsage() & 0x20) == 0) {
                throw new IllegalArgumentException("Allocation usage does not include USAGE_IO_INPUT");
            }
            if (previewAllocation.getType().getElement().getDataKind() != Element.DataKind.PIXEL_YUV) {
                throw new IllegalArgumentException("Allocation is not of a YUV type");
            }
            previewSurface = previewAllocation.getSurface();
            this.mUsingPreviewAllocation = true;
        } else {
            this.mUsingPreviewAllocation = false;
        }
        this.setPreviewCallbackSurface(previewSurface);
    }

    private final void $$robo$$android_hardware_Camera$setPreviewCallbackSurface(Surface surface) {
    }

    private static final void $$robo$$android_hardware_Camera$postEventFromNative(Object camera_ref, int what, int arg1, int arg2, Object obj) {
        Camera c = (Camera)((WeakReference)camera_ref).get();
        if (c == null) {
            return;
        }
        if (c.mEventHandler != null) {
            Message m = c.mEventHandler.obtainMessage(what, arg1, arg2, obj);
            c.mEventHandler.sendMessage(m);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_hardware_Camera$autoFocus(AutoFocusCallback cb) {
        Object object = this.mAutoFocusCallbackLock;
        synchronized (object) {
            this.mAutoFocusCallback = cb;
        }
        this.native_autoFocus();
    }

    private final void $$robo$$android_hardware_Camera$native_autoFocus() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_hardware_Camera$cancelAutoFocus() {
        Object object = this.mAutoFocusCallbackLock;
        synchronized (object) {
            this.mAutoFocusCallback = null;
        }
        this.native_cancelAutoFocus();
        this.mEventHandler.removeMessages(4);
    }

    private final void $$robo$$android_hardware_Camera$native_cancelAutoFocus() {
    }

    private final void $$robo$$android_hardware_Camera$setAutoFocusMoveCallback(AutoFocusMoveCallback cb) {
        this.mAutoFocusMoveCallback = cb;
        this.enableFocusMoveCallback(this.mAutoFocusMoveCallback != null ? 1 : 0);
    }

    private final void $$robo$$android_hardware_Camera$enableFocusMoveCallback(int n) {
    }

    private final void $$robo$$android_hardware_Camera$takePicture(ShutterCallback shutter, PictureCallback raw2, PictureCallback jpeg) {
        this.takePicture(shutter, raw2, null, jpeg);
    }

    private final void $$robo$$android_hardware_Camera$native_takePicture(int n) {
    }

    private final void $$robo$$android_hardware_Camera$takePicture(ShutterCallback shutter, PictureCallback raw2, PictureCallback postview, PictureCallback jpeg) {
        this.mShutterCallback = shutter;
        this.mRawImageCallback = raw2;
        this.mPostviewCallback = postview;
        this.mJpegCallback = jpeg;
        int msgType = 0;
        if (this.mShutterCallback != null) {
            msgType |= 2;
        }
        if (this.mRawImageCallback != null) {
            msgType |= 0x80;
        }
        if (this.mPostviewCallback != null) {
            msgType |= 0x40;
        }
        if (this.mJpegCallback != null) {
            msgType |= 0x100;
        }
        this.native_takePicture(msgType);
        this.mFaceDetectionRunning = false;
    }

    private final void $$robo$$android_hardware_Camera$startSmoothZoom(int n) {
    }

    private final void $$robo$$android_hardware_Camera$stopSmoothZoom() {
    }

    private final void $$robo$$android_hardware_Camera$setDisplayOrientation(int n) {
    }

    private final boolean $$robo$$android_hardware_Camera$enableShutterSound(boolean enabled) {
        if (!enabled) {
            IBinder b = ServiceManager.getService("audio");
            IAudioService audioService = IAudioService.Stub.asInterface(b);
            try {
                if (audioService.isCameraSoundForced()) {
                    return false;
                }
            }
            catch (RemoteException e) {
                Log.e("Camera", "Audio service is unavailable for queries");
            }
        }
        return this._enableShutterSound(enabled);
    }

    private final boolean $$robo$$android_hardware_Camera$disableShutterSound() {
        return this._enableShutterSound(false);
    }

    private final boolean $$robo$$android_hardware_Camera$_enableShutterSound(boolean bl) {
        return false;
    }

    private final void $$robo$$android_hardware_Camera$setZoomChangeListener(OnZoomChangeListener listener) {
        this.mZoomListener = listener;
    }

    private final void $$robo$$android_hardware_Camera$setFaceDetectionListener(FaceDetectionListener listener) {
        this.mFaceListener = listener;
    }

    private final void $$robo$$android_hardware_Camera$startFaceDetection() {
        if (this.mFaceDetectionRunning) {
            throw new RuntimeException("Face detection is already running");
        }
        this._startFaceDetection(0);
        this.mFaceDetectionRunning = true;
    }

    private final void $$robo$$android_hardware_Camera$stopFaceDetection() {
        this._stopFaceDetection();
        this.mFaceDetectionRunning = false;
    }

    private final void $$robo$$android_hardware_Camera$_startFaceDetection(int n) {
    }

    private final void $$robo$$android_hardware_Camera$_stopFaceDetection() {
    }

    private final void $$robo$$android_hardware_Camera$setErrorCallback(ErrorCallback cb) {
        this.mErrorCallback = cb;
    }

    private final void $$robo$$android_hardware_Camera$native_setParameters(String string2) {
    }

    private final String $$robo$$android_hardware_Camera$native_getParameters() {
        return null;
    }

    private final void $$robo$$android_hardware_Camera$setParameters(Parameters params) {
        if (this.mUsingPreviewAllocation) {
            Size newPreviewSize = params.getPreviewSize();
            Size currentPreviewSize = this.getParameters().getPreviewSize();
            if (newPreviewSize.width != currentPreviewSize.width || newPreviewSize.height != currentPreviewSize.height) {
                throw new IllegalStateException("Cannot change preview size while a preview allocation is configured.");
            }
        }
        this.native_setParameters(params.flatten());
    }

    private final Parameters $$robo$$android_hardware_Camera$getParameters() {
        Parameters p = new Parameters(this, null);
        String s = this.native_getParameters();
        p.unflatten(s);
        return p;
    }

    private static final Parameters $$robo$$android_hardware_Camera$getEmptyParameters() {
        Camera camera;
        Camera camera2 = camera = new Camera();
        camera2.getClass();
        return new Parameters(camera2, null);
    }

    private static final Parameters $$robo$$android_hardware_Camera$getParametersCopy(Parameters parameters) {
        Camera camera;
        if (parameters == null) {
            throw new NullPointerException("parameters must not be null");
        }
        Camera camera2 = camera = parameters.getOuter();
        camera2.getClass();
        Parameters p = new Parameters(camera2, null);
        p.copyFrom(parameters);
        return p;
    }

    public static int getNumberOfCameras() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getNumberOfCameras", $$robo$$android_hardware_Camera$getNumberOfCameras());
    }

    public static void getCameraInfo(int n, CameraInfo cameraInfo) {
        InvokeDynamicSupport.bootstrapStatic("getCameraInfo", $$robo$$android_hardware_Camera$getCameraInfo(int android.hardware.Camera$CameraInfo ), (int)n, (CameraInfo)cameraInfo);
    }

    private static void _getCameraInfo(int n, CameraInfo cameraInfo) {
        InvokeDynamicSupport.bootstrapStatic("_getCameraInfo", $$robo$$android_hardware_Camera$_getCameraInfo(int android.hardware.Camera$CameraInfo ), (int)n, (CameraInfo)cameraInfo);
    }

    public static Camera open(int n) {
        return InvokeDynamicSupport.bootstrapStatic("open", $$robo$$android_hardware_Camera$open(int ), (int)n);
    }

    public static Camera open() {
        return InvokeDynamicSupport.bootstrapStatic("open", $$robo$$android_hardware_Camera$open());
    }

    public static Camera openLegacy(int n, int n2) {
        return InvokeDynamicSupport.bootstrapStatic("openLegacy", $$robo$$android_hardware_Camera$openLegacy(int int ), (int)n, (int)n2);
    }

    private void __constructor__(int n, int n2) {
        this.$$robo$$android_hardware_Camera$__constructor__(n, n2);
    }

    public Camera(int n, int n2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_Camera$__constructor__(int int ), this, n, n2);
    }

    private int cameraInitVersion(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("cameraInitVersion", $$robo$$android_hardware_Camera$cameraInitVersion(int int ), this, n, n2);
    }

    private int cameraInitNormal(int n) {
        return (int)InvokeDynamicSupport.bootstrap("cameraInitNormal", $$robo$$android_hardware_Camera$cameraInitNormal(int ), this, n);
    }

    public int cameraInitUnspecified(int n) {
        return (int)InvokeDynamicSupport.bootstrap("cameraInitUnspecified", $$robo$$android_hardware_Camera$cameraInitUnspecified(int ), this, n);
    }

    private void __constructor__(int n) {
        this.$$robo$$android_hardware_Camera$__constructor__(n);
    }

    public Camera(int n) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_Camera$__constructor__(int ), this, n);
    }

    public static boolean checkInitErrors(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("checkInitErrors", $$robo$$android_hardware_Camera$checkInitErrors(int ), (int)n);
    }

    public static Camera openUninitialized() {
        return InvokeDynamicSupport.bootstrapStatic("openUninitialized", $$robo$$android_hardware_Camera$openUninitialized());
    }

    private void __constructor__() {
        this.$$robo$$android_hardware_Camera$__constructor__();
    }

    public Camera() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_Camera$__constructor__(), this);
    }

    protected void finalize() {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_hardware_Camera$finalize(), this);
    }

    private int native_setup(Object object, int n, int n2, String string2) {
        return (int)InvokeDynamicSupport.bootstrap("native_setup", $$robo$$android_hardware_Camera$native_setup(java.lang.Object int int java.lang.String ), this, object, n, n2, string2);
    }

    private void native_release() {
        InvokeDynamicSupport.bootstrap("native_release", $$robo$$android_hardware_Camera$native_release(), this);
    }

    public void release() {
        InvokeDynamicSupport.bootstrap("release", $$robo$$android_hardware_Camera$release(), this);
    }

    public void unlock() {
        InvokeDynamicSupport.bootstrap("unlock", $$robo$$android_hardware_Camera$unlock(), this);
    }

    public void lock() {
        InvokeDynamicSupport.bootstrap("lock", $$robo$$android_hardware_Camera$lock(), this);
    }

    public void reconnect() throws IOException {
        InvokeDynamicSupport.bootstrap("reconnect", $$robo$$android_hardware_Camera$reconnect(), this);
    }

    public void setPreviewDisplay(SurfaceHolder surfaceHolder) throws IOException {
        InvokeDynamicSupport.bootstrap("setPreviewDisplay", $$robo$$android_hardware_Camera$setPreviewDisplay(android.view.SurfaceHolder ), this, surfaceHolder);
    }

    public void setPreviewSurface(Surface surface) throws IOException {
        InvokeDynamicSupport.bootstrap("setPreviewSurface", $$robo$$android_hardware_Camera$setPreviewSurface(android.view.Surface ), this, surface);
    }

    public void setPreviewTexture(SurfaceTexture surfaceTexture) throws IOException {
        InvokeDynamicSupport.bootstrap("setPreviewTexture", $$robo$$android_hardware_Camera$setPreviewTexture(android.graphics.SurfaceTexture ), this, surfaceTexture);
    }

    public void startPreview() {
        InvokeDynamicSupport.bootstrap("startPreview", $$robo$$android_hardware_Camera$startPreview(), this);
    }

    public void stopPreview() {
        InvokeDynamicSupport.bootstrap("stopPreview", $$robo$$android_hardware_Camera$stopPreview(), this);
    }

    private void _stopPreview() {
        InvokeDynamicSupport.bootstrap("_stopPreview", $$robo$$android_hardware_Camera$_stopPreview(), this);
    }

    public boolean previewEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("previewEnabled", $$robo$$android_hardware_Camera$previewEnabled(), this);
    }

    public void setPreviewCallback(PreviewCallback previewCallback) {
        InvokeDynamicSupport.bootstrap("setPreviewCallback", $$robo$$android_hardware_Camera$setPreviewCallback(android.hardware.Camera$PreviewCallback ), this, previewCallback);
    }

    public void setOneShotPreviewCallback(PreviewCallback previewCallback) {
        InvokeDynamicSupport.bootstrap("setOneShotPreviewCallback", $$robo$$android_hardware_Camera$setOneShotPreviewCallback(android.hardware.Camera$PreviewCallback ), this, previewCallback);
    }

    private void setHasPreviewCallback(boolean bl, boolean bl2) {
        InvokeDynamicSupport.bootstrap("setHasPreviewCallback", $$robo$$android_hardware_Camera$setHasPreviewCallback(boolean boolean ), this, bl, bl2);
    }

    public void setPreviewCallbackWithBuffer(PreviewCallback previewCallback) {
        InvokeDynamicSupport.bootstrap("setPreviewCallbackWithBuffer", $$robo$$android_hardware_Camera$setPreviewCallbackWithBuffer(android.hardware.Camera$PreviewCallback ), this, previewCallback);
    }

    public void addCallbackBuffer(byte[] byArray) {
        InvokeDynamicSupport.bootstrap("addCallbackBuffer", $$robo$$android_hardware_Camera$addCallbackBuffer(byte[] ), this, byArray);
    }

    public void addRawImageCallbackBuffer(byte[] byArray) {
        InvokeDynamicSupport.bootstrap("addRawImageCallbackBuffer", $$robo$$android_hardware_Camera$addRawImageCallbackBuffer(byte[] ), this, byArray);
    }

    private void addCallbackBuffer(byte[] byArray, int n) {
        InvokeDynamicSupport.bootstrap("addCallbackBuffer", $$robo$$android_hardware_Camera$addCallbackBuffer(byte[] int ), this, byArray, n);
    }

    private void _addCallbackBuffer(byte[] byArray, int n) {
        InvokeDynamicSupport.bootstrap("_addCallbackBuffer", $$robo$$android_hardware_Camera$_addCallbackBuffer(byte[] int ), this, byArray, n);
    }

    public Allocation createPreviewAllocation(RenderScript renderScript, int n) throws RSIllegalArgumentException {
        return InvokeDynamicSupport.bootstrap("createPreviewAllocation", $$robo$$android_hardware_Camera$createPreviewAllocation(android.renderscript.RenderScript int ), this, renderScript, n);
    }

    public void setPreviewCallbackAllocation(Allocation allocation) throws IOException {
        InvokeDynamicSupport.bootstrap("setPreviewCallbackAllocation", $$robo$$android_hardware_Camera$setPreviewCallbackAllocation(android.renderscript.Allocation ), this, allocation);
    }

    private void setPreviewCallbackSurface(Surface surface) {
        InvokeDynamicSupport.bootstrap("setPreviewCallbackSurface", $$robo$$android_hardware_Camera$setPreviewCallbackSurface(android.view.Surface ), this, surface);
    }

    private static void postEventFromNative(Object object, int n, int n2, int n3, Object object2) {
        InvokeDynamicSupport.bootstrapStatic("postEventFromNative", $$robo$$android_hardware_Camera$postEventFromNative(java.lang.Object int int int java.lang.Object ), (Object)object, (int)n, (int)n2, (int)n3, (Object)object2);
    }

    public void autoFocus(AutoFocusCallback autoFocusCallback) {
        InvokeDynamicSupport.bootstrap("autoFocus", $$robo$$android_hardware_Camera$autoFocus(android.hardware.Camera$AutoFocusCallback ), this, autoFocusCallback);
    }

    private void native_autoFocus() {
        InvokeDynamicSupport.bootstrap("native_autoFocus", $$robo$$android_hardware_Camera$native_autoFocus(), this);
    }

    public void cancelAutoFocus() {
        InvokeDynamicSupport.bootstrap("cancelAutoFocus", $$robo$$android_hardware_Camera$cancelAutoFocus(), this);
    }

    private void native_cancelAutoFocus() {
        InvokeDynamicSupport.bootstrap("native_cancelAutoFocus", $$robo$$android_hardware_Camera$native_cancelAutoFocus(), this);
    }

    public void setAutoFocusMoveCallback(AutoFocusMoveCallback autoFocusMoveCallback) {
        InvokeDynamicSupport.bootstrap("setAutoFocusMoveCallback", $$robo$$android_hardware_Camera$setAutoFocusMoveCallback(android.hardware.Camera$AutoFocusMoveCallback ), this, autoFocusMoveCallback);
    }

    private void enableFocusMoveCallback(int n) {
        InvokeDynamicSupport.bootstrap("enableFocusMoveCallback", $$robo$$android_hardware_Camera$enableFocusMoveCallback(int ), this, n);
    }

    public void takePicture(ShutterCallback shutterCallback, PictureCallback pictureCallback, PictureCallback pictureCallback2) {
        InvokeDynamicSupport.bootstrap("takePicture", $$robo$$android_hardware_Camera$takePicture(android.hardware.Camera$ShutterCallback android.hardware.Camera$PictureCallback android.hardware.Camera$PictureCallback ), this, shutterCallback, pictureCallback, pictureCallback2);
    }

    private void native_takePicture(int n) {
        InvokeDynamicSupport.bootstrap("native_takePicture", $$robo$$android_hardware_Camera$native_takePicture(int ), this, n);
    }

    public void takePicture(ShutterCallback shutterCallback, PictureCallback pictureCallback, PictureCallback pictureCallback2, PictureCallback pictureCallback3) {
        InvokeDynamicSupport.bootstrap("takePicture", $$robo$$android_hardware_Camera$takePicture(android.hardware.Camera$ShutterCallback android.hardware.Camera$PictureCallback android.hardware.Camera$PictureCallback android.hardware.Camera$PictureCallback ), this, shutterCallback, pictureCallback, pictureCallback2, pictureCallback3);
    }

    public void startSmoothZoom(int n) {
        InvokeDynamicSupport.bootstrap("startSmoothZoom", $$robo$$android_hardware_Camera$startSmoothZoom(int ), this, n);
    }

    public void stopSmoothZoom() {
        InvokeDynamicSupport.bootstrap("stopSmoothZoom", $$robo$$android_hardware_Camera$stopSmoothZoom(), this);
    }

    public void setDisplayOrientation(int n) {
        InvokeDynamicSupport.bootstrap("setDisplayOrientation", $$robo$$android_hardware_Camera$setDisplayOrientation(int ), this, n);
    }

    public boolean enableShutterSound(boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("enableShutterSound", $$robo$$android_hardware_Camera$enableShutterSound(boolean ), this, bl);
    }

    public boolean disableShutterSound() {
        return (boolean)InvokeDynamicSupport.bootstrap("disableShutterSound", $$robo$$android_hardware_Camera$disableShutterSound(), this);
    }

    private boolean _enableShutterSound(boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("_enableShutterSound", $$robo$$android_hardware_Camera$_enableShutterSound(boolean ), this, bl);
    }

    public void setZoomChangeListener(OnZoomChangeListener onZoomChangeListener) {
        InvokeDynamicSupport.bootstrap("setZoomChangeListener", $$robo$$android_hardware_Camera$setZoomChangeListener(android.hardware.Camera$OnZoomChangeListener ), this, onZoomChangeListener);
    }

    public void setFaceDetectionListener(FaceDetectionListener faceDetectionListener) {
        InvokeDynamicSupport.bootstrap("setFaceDetectionListener", $$robo$$android_hardware_Camera$setFaceDetectionListener(android.hardware.Camera$FaceDetectionListener ), this, faceDetectionListener);
    }

    public void startFaceDetection() {
        InvokeDynamicSupport.bootstrap("startFaceDetection", $$robo$$android_hardware_Camera$startFaceDetection(), this);
    }

    public void stopFaceDetection() {
        InvokeDynamicSupport.bootstrap("stopFaceDetection", $$robo$$android_hardware_Camera$stopFaceDetection(), this);
    }

    private void _startFaceDetection(int n) {
        InvokeDynamicSupport.bootstrap("_startFaceDetection", $$robo$$android_hardware_Camera$_startFaceDetection(int ), this, n);
    }

    private void _stopFaceDetection() {
        InvokeDynamicSupport.bootstrap("_stopFaceDetection", $$robo$$android_hardware_Camera$_stopFaceDetection(), this);
    }

    public void setErrorCallback(ErrorCallback errorCallback) {
        InvokeDynamicSupport.bootstrap("setErrorCallback", $$robo$$android_hardware_Camera$setErrorCallback(android.hardware.Camera$ErrorCallback ), this, errorCallback);
    }

    private void native_setParameters(String string2) {
        InvokeDynamicSupport.bootstrap("native_setParameters", $$robo$$android_hardware_Camera$native_setParameters(java.lang.String ), this, string2);
    }

    private String native_getParameters() {
        return InvokeDynamicSupport.bootstrap("native_getParameters", $$robo$$android_hardware_Camera$native_getParameters(), this);
    }

    public void setParameters(Parameters parameters) {
        InvokeDynamicSupport.bootstrap("setParameters", $$robo$$android_hardware_Camera$setParameters(android.hardware.Camera$Parameters ), this, parameters);
    }

    public Parameters getParameters() {
        return InvokeDynamicSupport.bootstrap("getParameters", $$robo$$android_hardware_Camera$getParameters(), this);
    }

    public static Parameters getEmptyParameters() {
        return InvokeDynamicSupport.bootstrapStatic("getEmptyParameters", $$robo$$android_hardware_Camera$getEmptyParameters());
    }

    public static Parameters getParametersCopy(Parameters parameters) {
        return InvokeDynamicSupport.bootstrapStatic("getParametersCopy", $$robo$$android_hardware_Camera$getParametersCopy(android.hardware.Camera$Parameters ), (Parameters)parameters);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Camera)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @Deprecated
    public class Parameters
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private static String KEY_PREVIEW_SIZE = "preview-size";
        private static String KEY_PREVIEW_FORMAT = "preview-format";
        private static String KEY_PREVIEW_FRAME_RATE = "preview-frame-rate";
        private static String KEY_PREVIEW_FPS_RANGE = "preview-fps-range";
        private static String KEY_PICTURE_SIZE = "picture-size";
        private static String KEY_PICTURE_FORMAT = "picture-format";
        private static String KEY_JPEG_THUMBNAIL_SIZE = "jpeg-thumbnail-size";
        private static String KEY_JPEG_THUMBNAIL_WIDTH = "jpeg-thumbnail-width";
        private static String KEY_JPEG_THUMBNAIL_HEIGHT = "jpeg-thumbnail-height";
        private static String KEY_JPEG_THUMBNAIL_QUALITY = "jpeg-thumbnail-quality";
        private static String KEY_JPEG_QUALITY = "jpeg-quality";
        private static String KEY_ROTATION = "rotation";
        private static String KEY_GPS_LATITUDE = "gps-latitude";
        private static String KEY_GPS_LONGITUDE = "gps-longitude";
        private static String KEY_GPS_ALTITUDE = "gps-altitude";
        private static String KEY_GPS_TIMESTAMP = "gps-timestamp";
        private static String KEY_GPS_PROCESSING_METHOD = "gps-processing-method";
        private static String KEY_WHITE_BALANCE = "whitebalance";
        private static String KEY_EFFECT = "effect";
        private static String KEY_ANTIBANDING = "antibanding";
        private static String KEY_SCENE_MODE = "scene-mode";
        private static String KEY_FLASH_MODE = "flash-mode";
        private static String KEY_FOCUS_MODE = "focus-mode";
        private static String KEY_FOCUS_AREAS = "focus-areas";
        private static String KEY_MAX_NUM_FOCUS_AREAS = "max-num-focus-areas";
        private static String KEY_FOCAL_LENGTH = "focal-length";
        private static String KEY_HORIZONTAL_VIEW_ANGLE = "horizontal-view-angle";
        private static String KEY_VERTICAL_VIEW_ANGLE = "vertical-view-angle";
        private static String KEY_EXPOSURE_COMPENSATION = "exposure-compensation";
        private static String KEY_MAX_EXPOSURE_COMPENSATION = "max-exposure-compensation";
        private static String KEY_MIN_EXPOSURE_COMPENSATION = "min-exposure-compensation";
        private static String KEY_EXPOSURE_COMPENSATION_STEP = "exposure-compensation-step";
        private static String KEY_AUTO_EXPOSURE_LOCK = "auto-exposure-lock";
        private static String KEY_AUTO_EXPOSURE_LOCK_SUPPORTED = "auto-exposure-lock-supported";
        private static String KEY_AUTO_WHITEBALANCE_LOCK = "auto-whitebalance-lock";
        private static String KEY_AUTO_WHITEBALANCE_LOCK_SUPPORTED = "auto-whitebalance-lock-supported";
        private static String KEY_METERING_AREAS = "metering-areas";
        private static String KEY_MAX_NUM_METERING_AREAS = "max-num-metering-areas";
        private static String KEY_ZOOM = "zoom";
        private static String KEY_MAX_ZOOM = "max-zoom";
        private static String KEY_ZOOM_RATIOS = "zoom-ratios";
        private static String KEY_ZOOM_SUPPORTED = "zoom-supported";
        private static String KEY_SMOOTH_ZOOM_SUPPORTED = "smooth-zoom-supported";
        private static String KEY_FOCUS_DISTANCES = "focus-distances";
        private static String KEY_VIDEO_SIZE = "video-size";
        private static String KEY_PREFERRED_PREVIEW_SIZE_FOR_VIDEO = "preferred-preview-size-for-video";
        private static String KEY_MAX_NUM_DETECTED_FACES_HW = "max-num-detected-faces-hw";
        private static String KEY_MAX_NUM_DETECTED_FACES_SW = "max-num-detected-faces-sw";
        private static String KEY_RECORDING_HINT = "recording-hint";
        private static String KEY_VIDEO_SNAPSHOT_SUPPORTED = "video-snapshot-supported";
        private static String KEY_VIDEO_STABILIZATION = "video-stabilization";
        private static String KEY_VIDEO_STABILIZATION_SUPPORTED = "video-stabilization-supported";
        private static String SUPPORTED_VALUES_SUFFIX = "-values";
        private static String TRUE = "true";
        private static String FALSE = "false";
        public static String WHITE_BALANCE_AUTO = "auto";
        public static String WHITE_BALANCE_INCANDESCENT = "incandescent";
        public static String WHITE_BALANCE_FLUORESCENT = "fluorescent";
        public static String WHITE_BALANCE_WARM_FLUORESCENT = "warm-fluorescent";
        public static String WHITE_BALANCE_DAYLIGHT = "daylight";
        public static String WHITE_BALANCE_CLOUDY_DAYLIGHT = "cloudy-daylight";
        public static String WHITE_BALANCE_TWILIGHT = "twilight";
        public static String WHITE_BALANCE_SHADE = "shade";
        public static String EFFECT_NONE = "none";
        public static String EFFECT_MONO = "mono";
        public static String EFFECT_NEGATIVE = "negative";
        public static String EFFECT_SOLARIZE = "solarize";
        public static String EFFECT_SEPIA = "sepia";
        public static String EFFECT_POSTERIZE = "posterize";
        public static String EFFECT_WHITEBOARD = "whiteboard";
        public static String EFFECT_BLACKBOARD = "blackboard";
        public static String EFFECT_AQUA = "aqua";
        public static String ANTIBANDING_AUTO = "auto";
        public static String ANTIBANDING_50HZ = "50hz";
        public static String ANTIBANDING_60HZ = "60hz";
        public static String ANTIBANDING_OFF = "off";
        public static String FLASH_MODE_OFF = "off";
        public static String FLASH_MODE_AUTO = "auto";
        public static String FLASH_MODE_ON = "on";
        public static String FLASH_MODE_RED_EYE = "red-eye";
        public static String FLASH_MODE_TORCH = "torch";
        public static String SCENE_MODE_AUTO = "auto";
        public static String SCENE_MODE_ACTION = "action";
        public static String SCENE_MODE_PORTRAIT = "portrait";
        public static String SCENE_MODE_LANDSCAPE = "landscape";
        public static String SCENE_MODE_NIGHT = "night";
        public static String SCENE_MODE_NIGHT_PORTRAIT = "night-portrait";
        public static String SCENE_MODE_THEATRE = "theatre";
        public static String SCENE_MODE_BEACH = "beach";
        public static String SCENE_MODE_SNOW = "snow";
        public static String SCENE_MODE_SUNSET = "sunset";
        public static String SCENE_MODE_STEADYPHOTO = "steadyphoto";
        public static String SCENE_MODE_FIREWORKS = "fireworks";
        public static String SCENE_MODE_SPORTS = "sports";
        public static String SCENE_MODE_PARTY = "party";
        public static String SCENE_MODE_CANDLELIGHT = "candlelight";
        public static String SCENE_MODE_BARCODE = "barcode";
        public static String SCENE_MODE_HDR = "hdr";
        public static String FOCUS_MODE_AUTO = "auto";
        public static String FOCUS_MODE_INFINITY = "infinity";
        public static String FOCUS_MODE_MACRO = "macro";
        public static String FOCUS_MODE_FIXED = "fixed";
        public static String FOCUS_MODE_EDOF = "edof";
        public static String FOCUS_MODE_CONTINUOUS_VIDEO = "continuous-video";
        public static String FOCUS_MODE_CONTINUOUS_PICTURE = "continuous-picture";
        public static int FOCUS_DISTANCE_NEAR_INDEX = 0;
        public static int FOCUS_DISTANCE_OPTIMAL_INDEX = 1;
        public static int FOCUS_DISTANCE_FAR_INDEX = 2;
        public static int PREVIEW_FPS_MIN_INDEX = 0;
        public static int PREVIEW_FPS_MAX_INDEX = 1;
        private static String PIXEL_FORMAT_YUV422SP = "yuv422sp";
        private static String PIXEL_FORMAT_YUV420SP = "yuv420sp";
        private static String PIXEL_FORMAT_YUV422I = "yuv422i-yuyv";
        private static String PIXEL_FORMAT_YUV420P = "yuv420p";
        private static String PIXEL_FORMAT_RGB565 = "rgb565";
        private static String PIXEL_FORMAT_JPEG = "jpeg";
        private static String PIXEL_FORMAT_BAYER_RGGB = "bayer-rggb";
        private LinkedHashMap<String, String> mMap;
        /* synthetic */ Camera this$0;

        private void $$robo$$android_hardware_Camera_Parameters$__constructor__(Camera this$0) {
            this.mMap = new LinkedHashMap(64);
        }

        private final void $$robo$$android_hardware_Camera_Parameters$copyFrom(Parameters other) {
            if (other == null) {
                throw new NullPointerException("other must not be null");
            }
            this.mMap.putAll(other.mMap);
        }

        private final Camera $$robo$$android_hardware_Camera_Parameters$getOuter() {
            return this.this$0;
        }

        private final boolean $$robo$$android_hardware_Camera_Parameters$same(Parameters other) {
            if (this == other) {
                return true;
            }
            return other != null && this.mMap.equals(other.mMap);
        }

        @Deprecated
        private final void $$robo$$android_hardware_Camera_Parameters$dump() {
            Log.e("Camera", "dump: size=" + this.mMap.size());
            for (String k : this.mMap.keySet()) {
                Log.e("Camera", "dump: " + k + "=" + this.mMap.get(k));
            }
        }

        private final String $$robo$$android_hardware_Camera_Parameters$flatten() {
            StringBuilder flattened = new StringBuilder(128);
            for (String k : this.mMap.keySet()) {
                flattened.append(k);
                flattened.append("=");
                flattened.append(this.mMap.get(k));
                flattened.append(";");
            }
            flattened.deleteCharAt(flattened.length() - 1);
            return flattened.toString();
        }

        private final void $$robo$$android_hardware_Camera_Parameters$unflatten(String flattened) {
            this.mMap.clear();
            TextUtils.SimpleStringSplitter splitter = new TextUtils.SimpleStringSplitter(';');
            splitter.setString(flattened);
            for (String kv : splitter) {
                int pos = kv.indexOf(61);
                if (pos == -1) continue;
                String k = kv.substring(0, pos);
                String v = kv.substring(pos + 1);
                this.mMap.put(k, v);
            }
        }

        private final void $$robo$$android_hardware_Camera_Parameters$remove(String key) {
            this.mMap.remove(key);
        }

        private final void $$robo$$android_hardware_Camera_Parameters$set(String key, String value) {
            if (key.indexOf(61) != -1 || key.indexOf(59) != -1 || key.indexOf(0) != -1) {
                Log.e("Camera", "Key \"" + key + "\" contains invalid character (= or ; or \\0)");
                return;
            }
            if (value.indexOf(61) != -1 || value.indexOf(59) != -1 || value.indexOf(0) != -1) {
                Log.e("Camera", "Value \"" + value + "\" contains invalid character (= or ; or \\0)");
                return;
            }
            this.put(key, value);
        }

        private final void $$robo$$android_hardware_Camera_Parameters$set(String key, int value) {
            this.put(key, Integer.toString(value));
        }

        private final void $$robo$$android_hardware_Camera_Parameters$put(String key, String value) {
            this.mMap.remove(key);
            this.mMap.put(key, value);
        }

        private final void $$robo$$android_hardware_Camera_Parameters$set(String key, List<Area> areas) {
            if (areas == null) {
                this.set(key, "(0,0,0,0,0)");
            } else {
                StringBuilder buffer = new StringBuilder();
                for (int i = 0; i < areas.size(); ++i) {
                    Area area = areas.get(i);
                    Rect rect = area.rect;
                    buffer.append('(');
                    buffer.append(rect.left);
                    buffer.append(',');
                    buffer.append(rect.top);
                    buffer.append(',');
                    buffer.append(rect.right);
                    buffer.append(',');
                    buffer.append(rect.bottom);
                    buffer.append(',');
                    buffer.append(area.weight);
                    buffer.append(')');
                    if (i == areas.size() - 1) continue;
                    buffer.append(',');
                }
                this.set(key, buffer.toString());
            }
        }

        private final String $$robo$$android_hardware_Camera_Parameters$get(String key) {
            return this.mMap.get(key);
        }

        private final int $$robo$$android_hardware_Camera_Parameters$getInt(String key) {
            return Integer.parseInt(this.mMap.get(key));
        }

        private final void $$robo$$android_hardware_Camera_Parameters$setPreviewSize(int width, int height) {
            String v = Integer.toString(width) + "x" + Integer.toString(height);
            this.set("preview-size", v);
        }

        private final Size $$robo$$android_hardware_Camera_Parameters$getPreviewSize() {
            String pair = this.get("preview-size");
            return this.strToSize(pair);
        }

        private final List<Size> $$robo$$android_hardware_Camera_Parameters$getSupportedPreviewSizes() {
            String str = this.get("preview-size-values");
            return this.splitSize(str);
        }

        private final List<Size> $$robo$$android_hardware_Camera_Parameters$getSupportedVideoSizes() {
            String str = this.get("video-size-values");
            return this.splitSize(str);
        }

        private final Size $$robo$$android_hardware_Camera_Parameters$getPreferredPreviewSizeForVideo() {
            String pair = this.get("preferred-preview-size-for-video");
            return this.strToSize(pair);
        }

        private final void $$robo$$android_hardware_Camera_Parameters$setJpegThumbnailSize(int width, int height) {
            this.set("jpeg-thumbnail-width", width);
            this.set("jpeg-thumbnail-height", height);
        }

        private final Size $$robo$$android_hardware_Camera_Parameters$getJpegThumbnailSize() {
            return new Size(this.this$0, this.getInt("jpeg-thumbnail-width"), this.getInt("jpeg-thumbnail-height"));
        }

        private final List<Size> $$robo$$android_hardware_Camera_Parameters$getSupportedJpegThumbnailSizes() {
            String str = this.get("jpeg-thumbnail-size-values");
            return this.splitSize(str);
        }

        private final void $$robo$$android_hardware_Camera_Parameters$setJpegThumbnailQuality(int quality) {
            this.set("jpeg-thumbnail-quality", quality);
        }

        private final int $$robo$$android_hardware_Camera_Parameters$getJpegThumbnailQuality() {
            return this.getInt("jpeg-thumbnail-quality");
        }

        private final void $$robo$$android_hardware_Camera_Parameters$setJpegQuality(int quality) {
            this.set("jpeg-quality", quality);
        }

        private final int $$robo$$android_hardware_Camera_Parameters$getJpegQuality() {
            return this.getInt("jpeg-quality");
        }

        @Deprecated
        private final void $$robo$$android_hardware_Camera_Parameters$setPreviewFrameRate(int fps) {
            this.set("preview-frame-rate", fps);
        }

        @Deprecated
        private final int $$robo$$android_hardware_Camera_Parameters$getPreviewFrameRate() {
            return this.getInt("preview-frame-rate");
        }

        @Deprecated
        private final List<Integer> $$robo$$android_hardware_Camera_Parameters$getSupportedPreviewFrameRates() {
            String str = this.get("preview-frame-rate-values");
            return this.splitInt(str);
        }

        private final void $$robo$$android_hardware_Camera_Parameters$setPreviewFpsRange(int min, int max) {
            this.set("preview-fps-range", "" + min + "," + max);
        }

        private final void $$robo$$android_hardware_Camera_Parameters$getPreviewFpsRange(int[] range) {
            if (range == null || range.length != 2) {
                throw new IllegalArgumentException("range must be an array with two elements.");
            }
            this.splitInt(this.get("preview-fps-range"), range);
        }

        private final List<int[]> $$robo$$android_hardware_Camera_Parameters$getSupportedPreviewFpsRange() {
            String str = this.get("preview-fps-range-values");
            return this.splitRange(str);
        }

        private final void $$robo$$android_hardware_Camera_Parameters$setPreviewFormat(int pixel_format) {
            String s = this.cameraFormatForPixelFormat(pixel_format);
            if (s == null) {
                throw new IllegalArgumentException("Invalid pixel_format=" + pixel_format);
            }
            this.set("preview-format", s);
        }

        private final int $$robo$$android_hardware_Camera_Parameters$getPreviewFormat() {
            return this.pixelFormatForCameraFormat(this.get("preview-format"));
        }

        private final List<Integer> $$robo$$android_hardware_Camera_Parameters$getSupportedPreviewFormats() {
            String str = this.get("preview-format-values");
            ArrayList<Integer> formats = new ArrayList<Integer>();
            for (String s : this.split(str)) {
                int f = this.pixelFormatForCameraFormat(s);
                if (f == 0) continue;
                formats.add(f);
            }
            return formats;
        }

        private final void $$robo$$android_hardware_Camera_Parameters$setPictureSize(int width, int height) {
            String v = Integer.toString(width) + "x" + Integer.toString(height);
            this.set("picture-size", v);
        }

        private final Size $$robo$$android_hardware_Camera_Parameters$getPictureSize() {
            String pair = this.get("picture-size");
            return this.strToSize(pair);
        }

        private final List<Size> $$robo$$android_hardware_Camera_Parameters$getSupportedPictureSizes() {
            String str = this.get("picture-size-values");
            return this.splitSize(str);
        }

        private final void $$robo$$android_hardware_Camera_Parameters$setPictureFormat(int pixel_format) {
            String s = this.cameraFormatForPixelFormat(pixel_format);
            if (s == null) {
                throw new IllegalArgumentException("Invalid pixel_format=" + pixel_format);
            }
            this.set("picture-format", s);
        }

        private final int $$robo$$android_hardware_Camera_Parameters$getPictureFormat() {
            return this.pixelFormatForCameraFormat(this.get("picture-format"));
        }

        private final List<Integer> $$robo$$android_hardware_Camera_Parameters$getSupportedPictureFormats() {
            String str = this.get("picture-format-values");
            ArrayList<Integer> formats = new ArrayList<Integer>();
            for (String s : this.split(str)) {
                int f = this.pixelFormatForCameraFormat(s);
                if (f == 0) continue;
                formats.add(f);
            }
            return formats;
        }

        private final String $$robo$$android_hardware_Camera_Parameters$cameraFormatForPixelFormat(int pixel_format) {
            switch (pixel_format) {
                case 16: {
                    return "yuv422sp";
                }
                case 17: {
                    return "yuv420sp";
                }
                case 20: {
                    return "yuv422i-yuyv";
                }
                case 842094169: {
                    return "yuv420p";
                }
                case 4: {
                    return "rgb565";
                }
                case 256: {
                    return "jpeg";
                }
            }
            return null;
        }

        private final int $$robo$$android_hardware_Camera_Parameters$pixelFormatForCameraFormat(String format) {
            if (format == null) {
                return 0;
            }
            if (format.equals("yuv422sp")) {
                return 16;
            }
            if (format.equals("yuv420sp")) {
                return 17;
            }
            if (format.equals("yuv422i-yuyv")) {
                return 20;
            }
            if (format.equals("yuv420p")) {
                return 842094169;
            }
            if (format.equals("rgb565")) {
                return 4;
            }
            if (format.equals("jpeg")) {
                return 256;
            }
            return 0;
        }

        private final void $$robo$$android_hardware_Camera_Parameters$setRotation(int rotation) {
            if (rotation != 0 && rotation != 90 && rotation != 180 && rotation != 270) {
                throw new IllegalArgumentException("Invalid rotation=" + rotation);
            }
            this.set("rotation", Integer.toString(rotation));
        }

        private final void $$robo$$android_hardware_Camera_Parameters$setGpsLatitude(double latitude) {
            this.set("gps-latitude", Double.toString(latitude));
        }

        private final void $$robo$$android_hardware_Camera_Parameters$setGpsLongitude(double longitude) {
            this.set("gps-longitude", Double.toString(longitude));
        }

        private final void $$robo$$android_hardware_Camera_Parameters$setGpsAltitude(double altitude) {
            this.set("gps-altitude", Double.toString(altitude));
        }

        private final void $$robo$$android_hardware_Camera_Parameters$setGpsTimestamp(long timestamp) {
            this.set("gps-timestamp", Long.toString(timestamp));
        }

        private final void $$robo$$android_hardware_Camera_Parameters$setGpsProcessingMethod(String processing_method) {
            this.set("gps-processing-method", processing_method);
        }

        private final void $$robo$$android_hardware_Camera_Parameters$removeGpsData() {
            this.remove("gps-latitude");
            this.remove("gps-longitude");
            this.remove("gps-altitude");
            this.remove("gps-timestamp");
            this.remove("gps-processing-method");
        }

        private final String $$robo$$android_hardware_Camera_Parameters$getWhiteBalance() {
            return this.get("whitebalance");
        }

        private final void $$robo$$android_hardware_Camera_Parameters$setWhiteBalance(String value) {
            String oldValue = this.get("whitebalance");
            if (this.same(value, oldValue)) {
                return;
            }
            this.set("whitebalance", value);
            this.set("auto-whitebalance-lock", "false");
        }

        private final List<String> $$robo$$android_hardware_Camera_Parameters$getSupportedWhiteBalance() {
            String str = this.get("whitebalance-values");
            return this.split(str);
        }

        private final String $$robo$$android_hardware_Camera_Parameters$getColorEffect() {
            return this.get("effect");
        }

        private final void $$robo$$android_hardware_Camera_Parameters$setColorEffect(String value) {
            this.set("effect", value);
        }

        private final List<String> $$robo$$android_hardware_Camera_Parameters$getSupportedColorEffects() {
            String str = this.get("effect-values");
            return this.split(str);
        }

        private final String $$robo$$android_hardware_Camera_Parameters$getAntibanding() {
            return this.get("antibanding");
        }

        private final void $$robo$$android_hardware_Camera_Parameters$setAntibanding(String antibanding) {
            this.set("antibanding", antibanding);
        }

        private final List<String> $$robo$$android_hardware_Camera_Parameters$getSupportedAntibanding() {
            String str = this.get("antibanding-values");
            return this.split(str);
        }

        private final String $$robo$$android_hardware_Camera_Parameters$getSceneMode() {
            return this.get("scene-mode");
        }

        private final void $$robo$$android_hardware_Camera_Parameters$setSceneMode(String value) {
            this.set("scene-mode", value);
        }

        private final List<String> $$robo$$android_hardware_Camera_Parameters$getSupportedSceneModes() {
            String str = this.get("scene-mode-values");
            return this.split(str);
        }

        private final String $$robo$$android_hardware_Camera_Parameters$getFlashMode() {
            return this.get("flash-mode");
        }

        private final void $$robo$$android_hardware_Camera_Parameters$setFlashMode(String value) {
            this.set("flash-mode", value);
        }

        private final List<String> $$robo$$android_hardware_Camera_Parameters$getSupportedFlashModes() {
            String str = this.get("flash-mode-values");
            return this.split(str);
        }

        private final String $$robo$$android_hardware_Camera_Parameters$getFocusMode() {
            return this.get("focus-mode");
        }

        private final void $$robo$$android_hardware_Camera_Parameters$setFocusMode(String value) {
            this.set("focus-mode", value);
        }

        private final List<String> $$robo$$android_hardware_Camera_Parameters$getSupportedFocusModes() {
            String str = this.get("focus-mode-values");
            return this.split(str);
        }

        private final float $$robo$$android_hardware_Camera_Parameters$getFocalLength() {
            return Float.parseFloat(this.get("focal-length"));
        }

        private final float $$robo$$android_hardware_Camera_Parameters$getHorizontalViewAngle() {
            return Float.parseFloat(this.get("horizontal-view-angle"));
        }

        private final float $$robo$$android_hardware_Camera_Parameters$getVerticalViewAngle() {
            return Float.parseFloat(this.get("vertical-view-angle"));
        }

        private final int $$robo$$android_hardware_Camera_Parameters$getExposureCompensation() {
            return this.getInt("exposure-compensation", 0);
        }

        private final void $$robo$$android_hardware_Camera_Parameters$setExposureCompensation(int value) {
            this.set("exposure-compensation", value);
        }

        private final int $$robo$$android_hardware_Camera_Parameters$getMaxExposureCompensation() {
            return this.getInt("max-exposure-compensation", 0);
        }

        private final int $$robo$$android_hardware_Camera_Parameters$getMinExposureCompensation() {
            return this.getInt("min-exposure-compensation", 0);
        }

        private final float $$robo$$android_hardware_Camera_Parameters$getExposureCompensationStep() {
            return this.getFloat("exposure-compensation-step", 0.0f);
        }

        private final void $$robo$$android_hardware_Camera_Parameters$setAutoExposureLock(boolean toggle) {
            this.set("auto-exposure-lock", toggle ? "true" : "false");
        }

        private final boolean $$robo$$android_hardware_Camera_Parameters$getAutoExposureLock() {
            String str = this.get("auto-exposure-lock");
            return "true".equals(str);
        }

        private final boolean $$robo$$android_hardware_Camera_Parameters$isAutoExposureLockSupported() {
            String str = this.get("auto-exposure-lock-supported");
            return "true".equals(str);
        }

        private final void $$robo$$android_hardware_Camera_Parameters$setAutoWhiteBalanceLock(boolean toggle) {
            this.set("auto-whitebalance-lock", toggle ? "true" : "false");
        }

        private final boolean $$robo$$android_hardware_Camera_Parameters$getAutoWhiteBalanceLock() {
            String str = this.get("auto-whitebalance-lock");
            return "true".equals(str);
        }

        private final boolean $$robo$$android_hardware_Camera_Parameters$isAutoWhiteBalanceLockSupported() {
            String str = this.get("auto-whitebalance-lock-supported");
            return "true".equals(str);
        }

        private final int $$robo$$android_hardware_Camera_Parameters$getZoom() {
            return this.getInt("zoom", 0);
        }

        private final void $$robo$$android_hardware_Camera_Parameters$setZoom(int value) {
            this.set("zoom", value);
        }

        private final boolean $$robo$$android_hardware_Camera_Parameters$isZoomSupported() {
            String str = this.get("zoom-supported");
            return "true".equals(str);
        }

        private final int $$robo$$android_hardware_Camera_Parameters$getMaxZoom() {
            return this.getInt("max-zoom", 0);
        }

        private final List<Integer> $$robo$$android_hardware_Camera_Parameters$getZoomRatios() {
            return this.splitInt(this.get("zoom-ratios"));
        }

        private final boolean $$robo$$android_hardware_Camera_Parameters$isSmoothZoomSupported() {
            String str = this.get("smooth-zoom-supported");
            return "true".equals(str);
        }

        private final void $$robo$$android_hardware_Camera_Parameters$getFocusDistances(float[] output) {
            if (output == null || output.length != 3) {
                throw new IllegalArgumentException("output must be a float array with three elements.");
            }
            this.splitFloat(this.get("focus-distances"), output);
        }

        private final int $$robo$$android_hardware_Camera_Parameters$getMaxNumFocusAreas() {
            return this.getInt("max-num-focus-areas", 0);
        }

        private final List<Area> $$robo$$android_hardware_Camera_Parameters$getFocusAreas() {
            return this.splitArea(this.get("focus-areas"));
        }

        private final void $$robo$$android_hardware_Camera_Parameters$setFocusAreas(List<Area> focusAreas) {
            this.set("focus-areas", focusAreas);
        }

        private final int $$robo$$android_hardware_Camera_Parameters$getMaxNumMeteringAreas() {
            return this.getInt("max-num-metering-areas", 0);
        }

        private final List<Area> $$robo$$android_hardware_Camera_Parameters$getMeteringAreas() {
            return this.splitArea(this.get("metering-areas"));
        }

        private final void $$robo$$android_hardware_Camera_Parameters$setMeteringAreas(List<Area> meteringAreas) {
            this.set("metering-areas", meteringAreas);
        }

        private final int $$robo$$android_hardware_Camera_Parameters$getMaxNumDetectedFaces() {
            return this.getInt("max-num-detected-faces-hw", 0);
        }

        private final void $$robo$$android_hardware_Camera_Parameters$setRecordingHint(boolean hint) {
            this.set("recording-hint", hint ? "true" : "false");
        }

        private final boolean $$robo$$android_hardware_Camera_Parameters$isVideoSnapshotSupported() {
            String str = this.get("video-snapshot-supported");
            return "true".equals(str);
        }

        private final void $$robo$$android_hardware_Camera_Parameters$setVideoStabilization(boolean toggle) {
            this.set("video-stabilization", toggle ? "true" : "false");
        }

        private final boolean $$robo$$android_hardware_Camera_Parameters$getVideoStabilization() {
            String str = this.get("video-stabilization");
            return "true".equals(str);
        }

        private final boolean $$robo$$android_hardware_Camera_Parameters$isVideoStabilizationSupported() {
            String str = this.get("video-stabilization-supported");
            return "true".equals(str);
        }

        private final ArrayList<String> $$robo$$android_hardware_Camera_Parameters$split(String str) {
            if (str == null) {
                return null;
            }
            TextUtils.SimpleStringSplitter splitter = new TextUtils.SimpleStringSplitter(',');
            splitter.setString(str);
            ArrayList<String> substrings = new ArrayList<String>();
            for (String s : splitter) {
                substrings.add(s);
            }
            return substrings;
        }

        private final ArrayList<Integer> $$robo$$android_hardware_Camera_Parameters$splitInt(String str) {
            if (str == null) {
                return null;
            }
            TextUtils.SimpleStringSplitter splitter = new TextUtils.SimpleStringSplitter(',');
            splitter.setString(str);
            ArrayList<Integer> substrings = new ArrayList<Integer>();
            for (String s : splitter) {
                substrings.add(Integer.parseInt(s));
            }
            if (substrings.size() == 0) {
                return null;
            }
            return substrings;
        }

        private final void $$robo$$android_hardware_Camera_Parameters$splitInt(String str, int[] output) {
            if (str == null) {
                return;
            }
            TextUtils.SimpleStringSplitter splitter = new TextUtils.SimpleStringSplitter(',');
            splitter.setString(str);
            int index = 0;
            for (String s : splitter) {
                output[index++] = Integer.parseInt(s);
            }
        }

        private final void $$robo$$android_hardware_Camera_Parameters$splitFloat(String str, float[] output) {
            if (str == null) {
                return;
            }
            TextUtils.SimpleStringSplitter splitter = new TextUtils.SimpleStringSplitter(',');
            splitter.setString(str);
            int index = 0;
            for (String s : splitter) {
                output[index++] = Float.parseFloat(s);
            }
        }

        private final float $$robo$$android_hardware_Camera_Parameters$getFloat(String key, float defaultValue) {
            try {
                return Float.parseFloat(this.mMap.get(key));
            }
            catch (NumberFormatException ex) {
                return defaultValue;
            }
        }

        private final int $$robo$$android_hardware_Camera_Parameters$getInt(String key, int defaultValue) {
            try {
                return Integer.parseInt(this.mMap.get(key));
            }
            catch (NumberFormatException ex) {
                return defaultValue;
            }
        }

        private final ArrayList<Size> $$robo$$android_hardware_Camera_Parameters$splitSize(String str) {
            if (str == null) {
                return null;
            }
            TextUtils.SimpleStringSplitter splitter = new TextUtils.SimpleStringSplitter(',');
            splitter.setString(str);
            ArrayList<Size> sizeList = new ArrayList<Size>();
            for (String s : splitter) {
                Size size = this.strToSize(s);
                if (size == null) continue;
                sizeList.add(size);
            }
            if (sizeList.size() == 0) {
                return null;
            }
            return sizeList;
        }

        private final Size $$robo$$android_hardware_Camera_Parameters$strToSize(String str) {
            if (str == null) {
                return null;
            }
            int pos = str.indexOf(120);
            if (pos != -1) {
                String width = str.substring(0, pos);
                String height = str.substring(pos + 1);
                return new Size(this.this$0, Integer.parseInt(width), Integer.parseInt(height));
            }
            Log.e("Camera", "Invalid size parameter string=" + str);
            return null;
        }

        private final ArrayList<int[]> $$robo$$android_hardware_Camera_Parameters$splitRange(String str) {
            int endIndex;
            if (str == null || str.charAt(0) != '(' || str.charAt(str.length() - 1) != ')') {
                Log.e("Camera", "Invalid range list string=" + str);
                return null;
            }
            ArrayList<int[]> rangeList = new ArrayList<int[]>();
            int fromIndex = 1;
            do {
                int[] range = new int[2];
                endIndex = str.indexOf("),(", fromIndex);
                if (endIndex == -1) {
                    endIndex = str.length() - 1;
                }
                this.splitInt(str.substring(fromIndex, endIndex), range);
                rangeList.add(range);
                fromIndex = endIndex + 3;
            } while (endIndex != str.length() - 1);
            if (rangeList.size() == 0) {
                return null;
            }
            return rangeList;
        }

        private final ArrayList<Area> $$robo$$android_hardware_Camera_Parameters$splitArea(String str) {
            int endIndex;
            if (str == null || str.charAt(0) != '(' || str.charAt(str.length() - 1) != ')') {
                Log.e("Camera", "Invalid area string=" + str);
                return null;
            }
            ArrayList<Area> result = new ArrayList<Area>();
            int fromIndex = 1;
            int[] array2 = new int[5];
            do {
                if ((endIndex = str.indexOf("),(", fromIndex)) == -1) {
                    endIndex = str.length() - 1;
                }
                this.splitInt(str.substring(fromIndex, endIndex), array2);
                Rect rect = new Rect(array2[0], array2[1], array2[2], array2[3]);
                result.add(new Area(rect, array2[4]));
                fromIndex = endIndex + 3;
            } while (endIndex != str.length() - 1);
            if (result.size() == 0) {
                return null;
            }
            if (result.size() == 1) {
                Area area = result.get(0);
                Rect rect = area.rect;
                if (rect.left == 0 && rect.top == 0 && rect.right == 0 && rect.bottom == 0 && area.weight == 0) {
                    return null;
                }
            }
            return result;
        }

        private final boolean $$robo$$android_hardware_Camera_Parameters$same(String s1, String s2) {
            if (s1 == null && s2 == null) {
                return true;
            }
            return s1 != null && s1.equals(s2);
        }

        private /* synthetic */ void $$robo$$android_hardware_Camera_Parameters$__constructor__(Camera x0, 1 x1) {
        }

        private void __constructor__(Camera camera) {
            this.$$robo$$android_hardware_Camera_Parameters$__constructor__(camera);
        }

        public Parameters(Camera camera) {
            this.this$0 = camera;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_Camera_Parameters$__constructor__(android.hardware.Camera ), this, camera);
        }

        public void copyFrom(Parameters parameters) {
            InvokeDynamicSupport.bootstrap("copyFrom", $$robo$$android_hardware_Camera_Parameters$copyFrom(android.hardware.Camera$Parameters ), this, parameters);
        }

        private Camera getOuter() {
            return InvokeDynamicSupport.bootstrap("getOuter", $$robo$$android_hardware_Camera_Parameters$getOuter(), this);
        }

        public boolean same(Parameters parameters) {
            return (boolean)InvokeDynamicSupport.bootstrap("same", $$robo$$android_hardware_Camera_Parameters$same(android.hardware.Camera$Parameters ), this, parameters);
        }

        @Deprecated
        public void dump() {
            InvokeDynamicSupport.bootstrap("dump", $$robo$$android_hardware_Camera_Parameters$dump(), this);
        }

        public String flatten() {
            return InvokeDynamicSupport.bootstrap("flatten", $$robo$$android_hardware_Camera_Parameters$flatten(), this);
        }

        public void unflatten(String string2) {
            InvokeDynamicSupport.bootstrap("unflatten", $$robo$$android_hardware_Camera_Parameters$unflatten(java.lang.String ), this, string2);
        }

        public void remove(String string2) {
            InvokeDynamicSupport.bootstrap("remove", $$robo$$android_hardware_Camera_Parameters$remove(java.lang.String ), this, string2);
        }

        public void set(String string2, String string3) {
            InvokeDynamicSupport.bootstrap("set", $$robo$$android_hardware_Camera_Parameters$set(java.lang.String java.lang.String ), this, string2, string3);
        }

        public void set(String string2, int n) {
            InvokeDynamicSupport.bootstrap("set", $$robo$$android_hardware_Camera_Parameters$set(java.lang.String int ), this, string2, n);
        }

        private void put(String string2, String string3) {
            InvokeDynamicSupport.bootstrap("put", $$robo$$android_hardware_Camera_Parameters$put(java.lang.String java.lang.String ), this, string2, string3);
        }

        private void set(String string2, List<Area> list) {
            InvokeDynamicSupport.bootstrap("set", $$robo$$android_hardware_Camera_Parameters$set(java.lang.String java.util.List<android.hardware.Camera$Area> ), this, string2, list);
        }

        public String get(String string2) {
            return InvokeDynamicSupport.bootstrap("get", $$robo$$android_hardware_Camera_Parameters$get(java.lang.String ), this, string2);
        }

        public int getInt(String string2) {
            return (int)InvokeDynamicSupport.bootstrap("getInt", $$robo$$android_hardware_Camera_Parameters$getInt(java.lang.String ), this, string2);
        }

        public void setPreviewSize(int n, int n2) {
            InvokeDynamicSupport.bootstrap("setPreviewSize", $$robo$$android_hardware_Camera_Parameters$setPreviewSize(int int ), this, n, n2);
        }

        public Size getPreviewSize() {
            return InvokeDynamicSupport.bootstrap("getPreviewSize", $$robo$$android_hardware_Camera_Parameters$getPreviewSize(), this);
        }

        public List<Size> getSupportedPreviewSizes() {
            return InvokeDynamicSupport.bootstrap("getSupportedPreviewSizes", $$robo$$android_hardware_Camera_Parameters$getSupportedPreviewSizes(), this);
        }

        public List<Size> getSupportedVideoSizes() {
            return InvokeDynamicSupport.bootstrap("getSupportedVideoSizes", $$robo$$android_hardware_Camera_Parameters$getSupportedVideoSizes(), this);
        }

        public Size getPreferredPreviewSizeForVideo() {
            return InvokeDynamicSupport.bootstrap("getPreferredPreviewSizeForVideo", $$robo$$android_hardware_Camera_Parameters$getPreferredPreviewSizeForVideo(), this);
        }

        public void setJpegThumbnailSize(int n, int n2) {
            InvokeDynamicSupport.bootstrap("setJpegThumbnailSize", $$robo$$android_hardware_Camera_Parameters$setJpegThumbnailSize(int int ), this, n, n2);
        }

        public Size getJpegThumbnailSize() {
            return InvokeDynamicSupport.bootstrap("getJpegThumbnailSize", $$robo$$android_hardware_Camera_Parameters$getJpegThumbnailSize(), this);
        }

        public List<Size> getSupportedJpegThumbnailSizes() {
            return InvokeDynamicSupport.bootstrap("getSupportedJpegThumbnailSizes", $$robo$$android_hardware_Camera_Parameters$getSupportedJpegThumbnailSizes(), this);
        }

        public void setJpegThumbnailQuality(int n) {
            InvokeDynamicSupport.bootstrap("setJpegThumbnailQuality", $$robo$$android_hardware_Camera_Parameters$setJpegThumbnailQuality(int ), this, n);
        }

        public int getJpegThumbnailQuality() {
            return (int)InvokeDynamicSupport.bootstrap("getJpegThumbnailQuality", $$robo$$android_hardware_Camera_Parameters$getJpegThumbnailQuality(), this);
        }

        public void setJpegQuality(int n) {
            InvokeDynamicSupport.bootstrap("setJpegQuality", $$robo$$android_hardware_Camera_Parameters$setJpegQuality(int ), this, n);
        }

        public int getJpegQuality() {
            return (int)InvokeDynamicSupport.bootstrap("getJpegQuality", $$robo$$android_hardware_Camera_Parameters$getJpegQuality(), this);
        }

        @Deprecated
        public void setPreviewFrameRate(int n) {
            InvokeDynamicSupport.bootstrap("setPreviewFrameRate", $$robo$$android_hardware_Camera_Parameters$setPreviewFrameRate(int ), this, n);
        }

        @Deprecated
        public int getPreviewFrameRate() {
            return (int)InvokeDynamicSupport.bootstrap("getPreviewFrameRate", $$robo$$android_hardware_Camera_Parameters$getPreviewFrameRate(), this);
        }

        @Deprecated
        public List<Integer> getSupportedPreviewFrameRates() {
            return InvokeDynamicSupport.bootstrap("getSupportedPreviewFrameRates", $$robo$$android_hardware_Camera_Parameters$getSupportedPreviewFrameRates(), this);
        }

        public void setPreviewFpsRange(int n, int n2) {
            InvokeDynamicSupport.bootstrap("setPreviewFpsRange", $$robo$$android_hardware_Camera_Parameters$setPreviewFpsRange(int int ), this, n, n2);
        }

        public void getPreviewFpsRange(int[] nArray) {
            InvokeDynamicSupport.bootstrap("getPreviewFpsRange", $$robo$$android_hardware_Camera_Parameters$getPreviewFpsRange(int[] ), this, nArray);
        }

        public List<int[]> getSupportedPreviewFpsRange() {
            return InvokeDynamicSupport.bootstrap("getSupportedPreviewFpsRange", $$robo$$android_hardware_Camera_Parameters$getSupportedPreviewFpsRange(), this);
        }

        public void setPreviewFormat(int n) {
            InvokeDynamicSupport.bootstrap("setPreviewFormat", $$robo$$android_hardware_Camera_Parameters$setPreviewFormat(int ), this, n);
        }

        public int getPreviewFormat() {
            return (int)InvokeDynamicSupport.bootstrap("getPreviewFormat", $$robo$$android_hardware_Camera_Parameters$getPreviewFormat(), this);
        }

        public List<Integer> getSupportedPreviewFormats() {
            return InvokeDynamicSupport.bootstrap("getSupportedPreviewFormats", $$robo$$android_hardware_Camera_Parameters$getSupportedPreviewFormats(), this);
        }

        public void setPictureSize(int n, int n2) {
            InvokeDynamicSupport.bootstrap("setPictureSize", $$robo$$android_hardware_Camera_Parameters$setPictureSize(int int ), this, n, n2);
        }

        public Size getPictureSize() {
            return InvokeDynamicSupport.bootstrap("getPictureSize", $$robo$$android_hardware_Camera_Parameters$getPictureSize(), this);
        }

        public List<Size> getSupportedPictureSizes() {
            return InvokeDynamicSupport.bootstrap("getSupportedPictureSizes", $$robo$$android_hardware_Camera_Parameters$getSupportedPictureSizes(), this);
        }

        public void setPictureFormat(int n) {
            InvokeDynamicSupport.bootstrap("setPictureFormat", $$robo$$android_hardware_Camera_Parameters$setPictureFormat(int ), this, n);
        }

        public int getPictureFormat() {
            return (int)InvokeDynamicSupport.bootstrap("getPictureFormat", $$robo$$android_hardware_Camera_Parameters$getPictureFormat(), this);
        }

        public List<Integer> getSupportedPictureFormats() {
            return InvokeDynamicSupport.bootstrap("getSupportedPictureFormats", $$robo$$android_hardware_Camera_Parameters$getSupportedPictureFormats(), this);
        }

        private String cameraFormatForPixelFormat(int n) {
            return InvokeDynamicSupport.bootstrap("cameraFormatForPixelFormat", $$robo$$android_hardware_Camera_Parameters$cameraFormatForPixelFormat(int ), this, n);
        }

        private int pixelFormatForCameraFormat(String string2) {
            return (int)InvokeDynamicSupport.bootstrap("pixelFormatForCameraFormat", $$robo$$android_hardware_Camera_Parameters$pixelFormatForCameraFormat(java.lang.String ), this, string2);
        }

        public void setRotation(int n) {
            InvokeDynamicSupport.bootstrap("setRotation", $$robo$$android_hardware_Camera_Parameters$setRotation(int ), this, n);
        }

        public void setGpsLatitude(double d) {
            InvokeDynamicSupport.bootstrap("setGpsLatitude", $$robo$$android_hardware_Camera_Parameters$setGpsLatitude(double ), this, d);
        }

        public void setGpsLongitude(double d) {
            InvokeDynamicSupport.bootstrap("setGpsLongitude", $$robo$$android_hardware_Camera_Parameters$setGpsLongitude(double ), this, d);
        }

        public void setGpsAltitude(double d) {
            InvokeDynamicSupport.bootstrap("setGpsAltitude", $$robo$$android_hardware_Camera_Parameters$setGpsAltitude(double ), this, d);
        }

        public void setGpsTimestamp(long l) {
            InvokeDynamicSupport.bootstrap("setGpsTimestamp", $$robo$$android_hardware_Camera_Parameters$setGpsTimestamp(long ), this, l);
        }

        public void setGpsProcessingMethod(String string2) {
            InvokeDynamicSupport.bootstrap("setGpsProcessingMethod", $$robo$$android_hardware_Camera_Parameters$setGpsProcessingMethod(java.lang.String ), this, string2);
        }

        public void removeGpsData() {
            InvokeDynamicSupport.bootstrap("removeGpsData", $$robo$$android_hardware_Camera_Parameters$removeGpsData(), this);
        }

        public String getWhiteBalance() {
            return InvokeDynamicSupport.bootstrap("getWhiteBalance", $$robo$$android_hardware_Camera_Parameters$getWhiteBalance(), this);
        }

        public void setWhiteBalance(String string2) {
            InvokeDynamicSupport.bootstrap("setWhiteBalance", $$robo$$android_hardware_Camera_Parameters$setWhiteBalance(java.lang.String ), this, string2);
        }

        public List<String> getSupportedWhiteBalance() {
            return InvokeDynamicSupport.bootstrap("getSupportedWhiteBalance", $$robo$$android_hardware_Camera_Parameters$getSupportedWhiteBalance(), this);
        }

        public String getColorEffect() {
            return InvokeDynamicSupport.bootstrap("getColorEffect", $$robo$$android_hardware_Camera_Parameters$getColorEffect(), this);
        }

        public void setColorEffect(String string2) {
            InvokeDynamicSupport.bootstrap("setColorEffect", $$robo$$android_hardware_Camera_Parameters$setColorEffect(java.lang.String ), this, string2);
        }

        public List<String> getSupportedColorEffects() {
            return InvokeDynamicSupport.bootstrap("getSupportedColorEffects", $$robo$$android_hardware_Camera_Parameters$getSupportedColorEffects(), this);
        }

        public String getAntibanding() {
            return InvokeDynamicSupport.bootstrap("getAntibanding", $$robo$$android_hardware_Camera_Parameters$getAntibanding(), this);
        }

        public void setAntibanding(String string2) {
            InvokeDynamicSupport.bootstrap("setAntibanding", $$robo$$android_hardware_Camera_Parameters$setAntibanding(java.lang.String ), this, string2);
        }

        public List<String> getSupportedAntibanding() {
            return InvokeDynamicSupport.bootstrap("getSupportedAntibanding", $$robo$$android_hardware_Camera_Parameters$getSupportedAntibanding(), this);
        }

        public String getSceneMode() {
            return InvokeDynamicSupport.bootstrap("getSceneMode", $$robo$$android_hardware_Camera_Parameters$getSceneMode(), this);
        }

        public void setSceneMode(String string2) {
            InvokeDynamicSupport.bootstrap("setSceneMode", $$robo$$android_hardware_Camera_Parameters$setSceneMode(java.lang.String ), this, string2);
        }

        public List<String> getSupportedSceneModes() {
            return InvokeDynamicSupport.bootstrap("getSupportedSceneModes", $$robo$$android_hardware_Camera_Parameters$getSupportedSceneModes(), this);
        }

        public String getFlashMode() {
            return InvokeDynamicSupport.bootstrap("getFlashMode", $$robo$$android_hardware_Camera_Parameters$getFlashMode(), this);
        }

        public void setFlashMode(String string2) {
            InvokeDynamicSupport.bootstrap("setFlashMode", $$robo$$android_hardware_Camera_Parameters$setFlashMode(java.lang.String ), this, string2);
        }

        public List<String> getSupportedFlashModes() {
            return InvokeDynamicSupport.bootstrap("getSupportedFlashModes", $$robo$$android_hardware_Camera_Parameters$getSupportedFlashModes(), this);
        }

        public String getFocusMode() {
            return InvokeDynamicSupport.bootstrap("getFocusMode", $$robo$$android_hardware_Camera_Parameters$getFocusMode(), this);
        }

        public void setFocusMode(String string2) {
            InvokeDynamicSupport.bootstrap("setFocusMode", $$robo$$android_hardware_Camera_Parameters$setFocusMode(java.lang.String ), this, string2);
        }

        public List<String> getSupportedFocusModes() {
            return InvokeDynamicSupport.bootstrap("getSupportedFocusModes", $$robo$$android_hardware_Camera_Parameters$getSupportedFocusModes(), this);
        }

        public float getFocalLength() {
            return (float)InvokeDynamicSupport.bootstrap("getFocalLength", $$robo$$android_hardware_Camera_Parameters$getFocalLength(), this);
        }

        public float getHorizontalViewAngle() {
            return (float)InvokeDynamicSupport.bootstrap("getHorizontalViewAngle", $$robo$$android_hardware_Camera_Parameters$getHorizontalViewAngle(), this);
        }

        public float getVerticalViewAngle() {
            return (float)InvokeDynamicSupport.bootstrap("getVerticalViewAngle", $$robo$$android_hardware_Camera_Parameters$getVerticalViewAngle(), this);
        }

        public int getExposureCompensation() {
            return (int)InvokeDynamicSupport.bootstrap("getExposureCompensation", $$robo$$android_hardware_Camera_Parameters$getExposureCompensation(), this);
        }

        public void setExposureCompensation(int n) {
            InvokeDynamicSupport.bootstrap("setExposureCompensation", $$robo$$android_hardware_Camera_Parameters$setExposureCompensation(int ), this, n);
        }

        public int getMaxExposureCompensation() {
            return (int)InvokeDynamicSupport.bootstrap("getMaxExposureCompensation", $$robo$$android_hardware_Camera_Parameters$getMaxExposureCompensation(), this);
        }

        public int getMinExposureCompensation() {
            return (int)InvokeDynamicSupport.bootstrap("getMinExposureCompensation", $$robo$$android_hardware_Camera_Parameters$getMinExposureCompensation(), this);
        }

        public float getExposureCompensationStep() {
            return (float)InvokeDynamicSupport.bootstrap("getExposureCompensationStep", $$robo$$android_hardware_Camera_Parameters$getExposureCompensationStep(), this);
        }

        public void setAutoExposureLock(boolean bl) {
            InvokeDynamicSupport.bootstrap("setAutoExposureLock", $$robo$$android_hardware_Camera_Parameters$setAutoExposureLock(boolean ), this, bl);
        }

        public boolean getAutoExposureLock() {
            return (boolean)InvokeDynamicSupport.bootstrap("getAutoExposureLock", $$robo$$android_hardware_Camera_Parameters$getAutoExposureLock(), this);
        }

        public boolean isAutoExposureLockSupported() {
            return (boolean)InvokeDynamicSupport.bootstrap("isAutoExposureLockSupported", $$robo$$android_hardware_Camera_Parameters$isAutoExposureLockSupported(), this);
        }

        public void setAutoWhiteBalanceLock(boolean bl) {
            InvokeDynamicSupport.bootstrap("setAutoWhiteBalanceLock", $$robo$$android_hardware_Camera_Parameters$setAutoWhiteBalanceLock(boolean ), this, bl);
        }

        public boolean getAutoWhiteBalanceLock() {
            return (boolean)InvokeDynamicSupport.bootstrap("getAutoWhiteBalanceLock", $$robo$$android_hardware_Camera_Parameters$getAutoWhiteBalanceLock(), this);
        }

        public boolean isAutoWhiteBalanceLockSupported() {
            return (boolean)InvokeDynamicSupport.bootstrap("isAutoWhiteBalanceLockSupported", $$robo$$android_hardware_Camera_Parameters$isAutoWhiteBalanceLockSupported(), this);
        }

        public int getZoom() {
            return (int)InvokeDynamicSupport.bootstrap("getZoom", $$robo$$android_hardware_Camera_Parameters$getZoom(), this);
        }

        public void setZoom(int n) {
            InvokeDynamicSupport.bootstrap("setZoom", $$robo$$android_hardware_Camera_Parameters$setZoom(int ), this, n);
        }

        public boolean isZoomSupported() {
            return (boolean)InvokeDynamicSupport.bootstrap("isZoomSupported", $$robo$$android_hardware_Camera_Parameters$isZoomSupported(), this);
        }

        public int getMaxZoom() {
            return (int)InvokeDynamicSupport.bootstrap("getMaxZoom", $$robo$$android_hardware_Camera_Parameters$getMaxZoom(), this);
        }

        public List<Integer> getZoomRatios() {
            return InvokeDynamicSupport.bootstrap("getZoomRatios", $$robo$$android_hardware_Camera_Parameters$getZoomRatios(), this);
        }

        public boolean isSmoothZoomSupported() {
            return (boolean)InvokeDynamicSupport.bootstrap("isSmoothZoomSupported", $$robo$$android_hardware_Camera_Parameters$isSmoothZoomSupported(), this);
        }

        public void getFocusDistances(float[] fArray) {
            InvokeDynamicSupport.bootstrap("getFocusDistances", $$robo$$android_hardware_Camera_Parameters$getFocusDistances(float[] ), this, fArray);
        }

        public int getMaxNumFocusAreas() {
            return (int)InvokeDynamicSupport.bootstrap("getMaxNumFocusAreas", $$robo$$android_hardware_Camera_Parameters$getMaxNumFocusAreas(), this);
        }

        public List<Area> getFocusAreas() {
            return InvokeDynamicSupport.bootstrap("getFocusAreas", $$robo$$android_hardware_Camera_Parameters$getFocusAreas(), this);
        }

        public void setFocusAreas(List<Area> list) {
            InvokeDynamicSupport.bootstrap("setFocusAreas", $$robo$$android_hardware_Camera_Parameters$setFocusAreas(java.util.List<android.hardware.Camera$Area> ), this, list);
        }

        public int getMaxNumMeteringAreas() {
            return (int)InvokeDynamicSupport.bootstrap("getMaxNumMeteringAreas", $$robo$$android_hardware_Camera_Parameters$getMaxNumMeteringAreas(), this);
        }

        public List<Area> getMeteringAreas() {
            return InvokeDynamicSupport.bootstrap("getMeteringAreas", $$robo$$android_hardware_Camera_Parameters$getMeteringAreas(), this);
        }

        public void setMeteringAreas(List<Area> list) {
            InvokeDynamicSupport.bootstrap("setMeteringAreas", $$robo$$android_hardware_Camera_Parameters$setMeteringAreas(java.util.List<android.hardware.Camera$Area> ), this, list);
        }

        public int getMaxNumDetectedFaces() {
            return (int)InvokeDynamicSupport.bootstrap("getMaxNumDetectedFaces", $$robo$$android_hardware_Camera_Parameters$getMaxNumDetectedFaces(), this);
        }

        public void setRecordingHint(boolean bl) {
            InvokeDynamicSupport.bootstrap("setRecordingHint", $$robo$$android_hardware_Camera_Parameters$setRecordingHint(boolean ), this, bl);
        }

        public boolean isVideoSnapshotSupported() {
            return (boolean)InvokeDynamicSupport.bootstrap("isVideoSnapshotSupported", $$robo$$android_hardware_Camera_Parameters$isVideoSnapshotSupported(), this);
        }

        public void setVideoStabilization(boolean bl) {
            InvokeDynamicSupport.bootstrap("setVideoStabilization", $$robo$$android_hardware_Camera_Parameters$setVideoStabilization(boolean ), this, bl);
        }

        public boolean getVideoStabilization() {
            return (boolean)InvokeDynamicSupport.bootstrap("getVideoStabilization", $$robo$$android_hardware_Camera_Parameters$getVideoStabilization(), this);
        }

        public boolean isVideoStabilizationSupported() {
            return (boolean)InvokeDynamicSupport.bootstrap("isVideoStabilizationSupported", $$robo$$android_hardware_Camera_Parameters$isVideoStabilizationSupported(), this);
        }

        private ArrayList<String> split(String string2) {
            return InvokeDynamicSupport.bootstrap("split", $$robo$$android_hardware_Camera_Parameters$split(java.lang.String ), this, string2);
        }

        private ArrayList<Integer> splitInt(String string2) {
            return InvokeDynamicSupport.bootstrap("splitInt", $$robo$$android_hardware_Camera_Parameters$splitInt(java.lang.String ), this, string2);
        }

        private void splitInt(String string2, int[] nArray) {
            InvokeDynamicSupport.bootstrap("splitInt", $$robo$$android_hardware_Camera_Parameters$splitInt(java.lang.String int[] ), this, string2, nArray);
        }

        private void splitFloat(String string2, float[] fArray) {
            InvokeDynamicSupport.bootstrap("splitFloat", $$robo$$android_hardware_Camera_Parameters$splitFloat(java.lang.String float[] ), this, string2, fArray);
        }

        private float getFloat(String string2, float f) {
            return (float)InvokeDynamicSupport.bootstrap("getFloat", $$robo$$android_hardware_Camera_Parameters$getFloat(java.lang.String float ), this, string2, f);
        }

        private int getInt(String string2, int n) {
            return (int)InvokeDynamicSupport.bootstrap("getInt", $$robo$$android_hardware_Camera_Parameters$getInt(java.lang.String int ), this, string2, n);
        }

        private ArrayList<Size> splitSize(String string2) {
            return InvokeDynamicSupport.bootstrap("splitSize", $$robo$$android_hardware_Camera_Parameters$splitSize(java.lang.String ), this, string2);
        }

        private Size strToSize(String string2) {
            return InvokeDynamicSupport.bootstrap("strToSize", $$robo$$android_hardware_Camera_Parameters$strToSize(java.lang.String ), this, string2);
        }

        private ArrayList<int[]> splitRange(String string2) {
            return InvokeDynamicSupport.bootstrap("splitRange", $$robo$$android_hardware_Camera_Parameters$splitRange(java.lang.String ), this, string2);
        }

        private ArrayList<Area> splitArea(String string2) {
            return InvokeDynamicSupport.bootstrap("splitArea", $$robo$$android_hardware_Camera_Parameters$splitArea(java.lang.String ), this, string2);
        }

        private boolean same(String string2, String string3) {
            return (boolean)InvokeDynamicSupport.bootstrap("same", $$robo$$android_hardware_Camera_Parameters$same(java.lang.String java.lang.String ), this, string2, string3);
        }

        private /* synthetic */ void __constructor__(Camera camera, 1 var2_2) {
            this.$$robo$$android_hardware_Camera_Parameters$__constructor__(camera, var2_2);
        }

        public /* synthetic */ Parameters(Camera camera, 1 var2_2) {
            this(camera);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_Camera_Parameters$__constructor__(android.hardware.Camera android.hardware.Camera$1 ), this, camera, var2_2);
        }

        public /* synthetic */ Parameters() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Parameters)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @Deprecated
    public static class Area
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public Rect rect;
        public int weight;

        private void $$robo$$android_hardware_Camera_Area$__constructor__(Rect rect, int weight) {
            this.rect = rect;
            this.weight = weight;
        }

        private final boolean $$robo$$android_hardware_Camera_Area$equals(Object obj) {
            if (!(obj instanceof Area)) {
                return false;
            }
            Area a = (Area)obj;
            if (this.rect == null ? a.rect != null : !this.rect.equals(a.rect)) {
                return false;
            }
            return this.weight == a.weight;
        }

        private void __constructor__(Rect rect, int n) {
            this.$$robo$$android_hardware_Camera_Area$__constructor__(rect, n);
        }

        public Area(Rect rect, int n) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_Camera_Area$__constructor__(android.graphics.Rect int ), this, rect, n);
        }

        public boolean equals(Object object) {
            return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_hardware_Camera_Area$equals(java.lang.Object ), this, object);
        }

        public /* synthetic */ Area() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Area)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @Deprecated
    public class Size
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public int width;
        public int height;
        /* synthetic */ Camera this$0;

        private void $$robo$$android_hardware_Camera_Size$__constructor__(Camera this$0, int w, int h) {
            this.width = w;
            this.height = h;
        }

        private final boolean $$robo$$android_hardware_Camera_Size$equals(Object obj) {
            if (!(obj instanceof Size)) {
                return false;
            }
            Size s = (Size)obj;
            return this.width == s.width && this.height == s.height;
        }

        private final int $$robo$$android_hardware_Camera_Size$hashCode() {
            return this.width * 32713 + this.height;
        }

        private void __constructor__(Camera camera, int n, int n2) {
            this.$$robo$$android_hardware_Camera_Size$__constructor__(camera, n, n2);
        }

        public Size(Camera camera, int n, int n2) {
            this.this$0 = camera;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_Camera_Size$__constructor__(android.hardware.Camera int int ), this, camera, n, n2);
        }

        public boolean equals(Object object) {
            return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_hardware_Camera_Size$equals(java.lang.Object ), this, object);
        }

        public int hashCode() {
            return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_hardware_Camera_Size$hashCode(), this);
        }

        public /* synthetic */ Size() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Size)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @Deprecated
    public static interface ErrorCallback
    extends InstrumentedInterface {
        public void onError(int var1, Camera var2);
    }

    @Deprecated
    public static class Face
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public Rect rect;
        public int score;
        public int id;
        public Point leftEye;
        public Point rightEye;
        public Point mouth;

        private void $$robo$$android_hardware_Camera_Face$__constructor__() {
            this.id = -1;
            this.leftEye = null;
            this.rightEye = null;
            this.mouth = null;
        }

        private void __constructor__() {
            this.$$robo$$android_hardware_Camera_Face$__constructor__();
        }

        public Face() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_Camera_Face$__constructor__(), this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Face)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @Deprecated
    public static interface FaceDetectionListener
    extends InstrumentedInterface {
        public void onFaceDetection(Face[] var1, Camera var2);
    }

    @Deprecated
    public static interface OnZoomChangeListener
    extends InstrumentedInterface {
        public void onZoomChange(int var1, boolean var2, Camera var3);
    }

    @Deprecated
    public static interface PictureCallback
    extends InstrumentedInterface {
        public void onPictureTaken(byte[] var1, Camera var2);
    }

    @Deprecated
    public static interface ShutterCallback
    extends InstrumentedInterface {
        public void onShutter();
    }

    @Deprecated
    public static interface AutoFocusMoveCallback
    extends InstrumentedInterface {
        public void onAutoFocusMoving(boolean var1, Camera var2);
    }

    @Deprecated
    public static interface AutoFocusCallback
    extends InstrumentedInterface {
        public void onAutoFocus(boolean var1, Camera var2);
    }

    private class EventHandler
    extends Handler
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private Camera mCamera;
        /* synthetic */ Camera this$0;

        private void $$robo$$android_hardware_Camera_EventHandler$__constructor__(Camera camera, Camera c, Looper looper) {
            this.mCamera = c;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_hardware_Camera_EventHandler$handleMessage(Message msg) {
            switch (msg.what) {
                case 2: {
                    if (this.this$0.mShutterCallback != null) {
                        this.this$0.mShutterCallback.onShutter();
                    }
                    return;
                }
                case 128: {
                    if (this.this$0.mRawImageCallback != null) {
                        this.this$0.mRawImageCallback.onPictureTaken((byte[])msg.obj, this.mCamera);
                    }
                    return;
                }
                case 256: {
                    if (this.this$0.mJpegCallback != null) {
                        this.this$0.mJpegCallback.onPictureTaken((byte[])msg.obj, this.mCamera);
                    }
                    return;
                }
                case 16: {
                    PreviewCallback pCb = this.this$0.mPreviewCallback;
                    if (pCb != null) {
                        if (this.this$0.mOneShot) {
                            this.this$0.mPreviewCallback = null;
                        } else if (!this.this$0.mWithBuffer) {
                            this.this$0.setHasPreviewCallback(true, false);
                        }
                        pCb.onPreviewFrame((byte[])msg.obj, this.mCamera);
                    }
                    return;
                }
                case 64: {
                    if (this.this$0.mPostviewCallback != null) {
                        this.this$0.mPostviewCallback.onPictureTaken((byte[])msg.obj, this.mCamera);
                    }
                    return;
                }
                case 4: {
                    AutoFocusCallback cb = null;
                    Object object = this.this$0.mAutoFocusCallbackLock;
                    synchronized (object) {
                        cb = this.this$0.mAutoFocusCallback;
                    }
                    if (cb != null) {
                        boolean success = msg.arg1 != 0;
                        cb.onAutoFocus(success, this.mCamera);
                    }
                    return;
                }
                case 8: {
                    if (this.this$0.mZoomListener != null) {
                        this.this$0.mZoomListener.onZoomChange(msg.arg1, msg.arg2 != 0, this.mCamera);
                    }
                    return;
                }
                case 1024: {
                    if (this.this$0.mFaceListener != null) {
                        this.this$0.mFaceListener.onFaceDetection((Face[])msg.obj, this.mCamera);
                    }
                    return;
                }
                case 1: {
                    Log.e("Camera", "Error " + msg.arg1);
                    if (this.this$0.mErrorCallback != null) {
                        this.this$0.mErrorCallback.onError(msg.arg1, this.mCamera);
                    }
                    return;
                }
                case 2048: {
                    if (this.this$0.mAutoFocusMoveCallback != null) {
                        this.this$0.mAutoFocusMoveCallback.onAutoFocusMoving(msg.arg1 != 0, this.mCamera);
                    }
                    return;
                }
            }
            Log.e("Camera", "Unknown message type " + msg.what);
        }

        private void __constructor__(Camera camera, Camera camera2, Looper looper) {
            this.$$robo$$android_hardware_Camera_EventHandler$__constructor__(camera, camera2, looper);
        }

        public EventHandler(Camera camera, Camera camera2, Looper looper) {
            this.this$0 = camera;
            super(looper);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_Camera_EventHandler$__constructor__(android.hardware.Camera android.hardware.Camera android.os.Looper ), this, camera, camera2, looper);
        }

        @Override
        public void handleMessage(Message message) {
            InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_hardware_Camera_EventHandler$handleMessage(android.os.Message ), this, message);
        }

        public /* synthetic */ EventHandler() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (EventHandler)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @Deprecated
    public static interface PreviewCallback
    extends InstrumentedInterface {
        public void onPreviewFrame(byte[] var1, Camera var2);
    }

    @Deprecated
    public static class CameraInfo
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public static int CAMERA_FACING_BACK = 0;
        public static int CAMERA_FACING_FRONT = 1;
        public int facing;
        public int orientation;
        public boolean canDisableShutterSound;

        private void $$robo$$android_hardware_Camera_CameraInfo$__constructor__() {
        }

        private void __constructor__() {
            this.$$robo$$android_hardware_Camera_CameraInfo$__constructor__();
        }

        public CameraInfo() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_Camera_CameraInfo$__constructor__(), this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CameraInfo)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

