/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2;

import android.content.Context;
import android.hardware.CameraInfo;
import android.hardware.CameraStatus;
import android.hardware.ICameraService;
import android.hardware.ICameraServiceListener;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.ICameraDeviceUser;
import android.hardware.camera2.impl.CameraDeviceImpl;
import android.hardware.camera2.impl.CameraMetadataNative;
import android.hardware.camera2.legacy.CameraDeviceUserShim;
import android.hardware.camera2.legacy.LegacyMetadataMapper;
import android.os.Binder;
import android.os.DeadObjectException;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.ServiceSpecificException;
import android.util.ArrayMap;
import android.util.Log;
import com.google.errorprone.annotations.DoNotMock;
import java.util.ArrayList;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class CameraManager
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "CameraManager";
    private boolean DEBUG = false;
    private static int USE_CALLING_UID = -1;
    private static int API_VERSION_1 = 1;
    private static int API_VERSION_2 = 2;
    private static int CAMERA_TYPE_BACKWARD_COMPATIBLE = 0;
    private static int CAMERA_TYPE_ALL = 1;
    private ArrayList<String> mDeviceIdList;
    private Context mContext;
    private Object mLock;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void $$robo$$android_hardware_camera2_CameraManager$__constructor__(Context context) {
        this.DEBUG = false;
        Object object = this.mLock = new Object();
        synchronized (object) {
            this.mContext = context;
        }
    }

    private final String[] $$robo$$android_hardware_camera2_CameraManager$getCameraIdList() throws CameraAccessException {
        return CameraManagerGlobal.get().getCameraIdList();
    }

    private final void $$robo$$android_hardware_camera2_CameraManager$registerAvailabilityCallback(AvailabilityCallback callback, Handler handler) {
        if (handler == null) {
            Looper looper = Looper.myLooper();
            if (looper == null) {
                throw new IllegalArgumentException("No handler given, and current thread has no looper!");
            }
            handler = new Handler(looper);
        }
        CameraManagerGlobal.get().registerAvailabilityCallback(callback, handler);
    }

    private final void $$robo$$android_hardware_camera2_CameraManager$unregisterAvailabilityCallback(AvailabilityCallback callback) {
        CameraManagerGlobal.get().unregisterAvailabilityCallback(callback);
    }

    private final void $$robo$$android_hardware_camera2_CameraManager$registerTorchCallback(TorchCallback callback, Handler handler) {
        if (handler == null) {
            Looper looper = Looper.myLooper();
            if (looper == null) {
                throw new IllegalArgumentException("No handler given, and current thread has no looper!");
            }
            handler = new Handler(looper);
        }
        CameraManagerGlobal.get().registerTorchCallback(callback, handler);
    }

    private final void $$robo$$android_hardware_camera2_CameraManager$unregisterTorchCallback(TorchCallback callback) {
        CameraManagerGlobal.get().unregisterTorchCallback(callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final CameraCharacteristics $$robo$$android_hardware_camera2_CameraManager$getCameraCharacteristics(String cameraId) throws CameraAccessException {
        CameraCharacteristics characteristics = null;
        Object object = this.mLock;
        synchronized (object) {
            ICameraService cameraService = CameraManagerGlobal.get().getCameraService();
            if (cameraService == null) {
                throw new CameraAccessException(2, "Camera service is currently unavailable");
            }
            try {
                if (!this.supportsCamera2ApiLocked(cameraId)) {
                    int id2 = Integer.parseInt(cameraId);
                    String parameters = cameraService.getLegacyParameters(id2);
                    CameraInfo info = cameraService.getCameraInfo(id2);
                    characteristics = LegacyMetadataMapper.createCharacteristics(parameters, info);
                } else {
                    CameraMetadataNative info = cameraService.getCameraCharacteristics(cameraId);
                    characteristics = new CameraCharacteristics(info);
                }
            }
            catch (ServiceSpecificException e) {
                CameraManager.throwAsPublicException(e);
            }
            catch (RemoteException e) {
                throw new CameraAccessException(2, "Camera service is currently unavailable", e);
            }
        }
        return characteristics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final CameraDevice $$robo$$android_hardware_camera2_CameraManager$openCameraDeviceUserAsync(String cameraId, CameraDevice.StateCallback callback, Handler handler, int uid) throws CameraAccessException {
        CameraCharacteristics characteristics = this.getCameraCharacteristics(cameraId);
        CameraDeviceImpl device = null;
        Object object = this.mLock;
        synchronized (object) {
            CameraDeviceImpl deviceImpl;
            ICameraDeviceUser cameraUser;
            block14: {
                cameraUser = null;
                deviceImpl = new CameraDeviceImpl(cameraId, callback, handler, characteristics, this.mContext.getApplicationInfo().targetSdkVersion);
                CameraDeviceImpl.CameraDeviceCallbacks callbacks = deviceImpl.getCallbacks();
                try {
                    int id2;
                    if (this.supportsCamera2ApiLocked(cameraId)) {
                        ICameraService cameraService = CameraManagerGlobal.get().getCameraService();
                        if (cameraService == null) {
                            throw new ServiceSpecificException(4, "Camera service is currently unavailable");
                        }
                        cameraUser = cameraService.connectDevice(callbacks, cameraId, this.mContext.getOpPackageName(), uid);
                        break block14;
                    }
                    try {
                        id2 = Integer.parseInt(cameraId);
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException("Expected cameraId to be numeric, but it was: " + cameraId);
                    }
                    Log.i("CameraManager", "Using legacy camera HAL.");
                    cameraUser = CameraDeviceUserShim.connectBinderShim(callbacks, id2);
                }
                catch (ServiceSpecificException e) {
                    if (e.errorCode == 9) {
                        throw new AssertionError((Object)"Should've gone down the shim path");
                    }
                    if (e.errorCode == 7 || e.errorCode == 8 || e.errorCode == 6 || e.errorCode == 4 || e.errorCode == 10) {
                        deviceImpl.setRemoteFailure(e);
                        if (e.errorCode == 6 || e.errorCode == 4 || e.errorCode == 7) {
                            CameraManager.throwAsPublicException(e);
                        }
                    } else {
                        CameraManager.throwAsPublicException(e);
                    }
                }
                catch (RemoteException e) {
                    ServiceSpecificException sse = new ServiceSpecificException(4, "Camera service is currently unavailable");
                    deviceImpl.setRemoteFailure(sse);
                    CameraManager.throwAsPublicException(sse);
                }
            }
            deviceImpl.setRemoteDevice(cameraUser);
            device = deviceImpl;
        }
        return device;
    }

    private final void $$robo$$android_hardware_camera2_CameraManager$openCamera(String cameraId, CameraDevice.StateCallback callback, Handler handler) throws CameraAccessException {
        this.openCameraForUid(cameraId, callback, handler, -1);
    }

    private final void $$robo$$android_hardware_camera2_CameraManager$openCameraForUid(String cameraId, CameraDevice.StateCallback callback, Handler handler, int clientUid) throws CameraAccessException {
        if (cameraId == null) {
            throw new IllegalArgumentException("cameraId was null");
        }
        if (callback == null) {
            throw new IllegalArgumentException("callback was null");
        }
        if (handler == null) {
            if (Looper.myLooper() != null) {
                handler = new Handler();
            } else {
                throw new IllegalArgumentException("Handler argument is null, but no looper exists in the calling thread");
            }
        }
        this.openCameraDeviceUserAsync(cameraId, callback, handler, clientUid);
    }

    private final void $$robo$$android_hardware_camera2_CameraManager$setTorchMode(String cameraId, boolean enabled) throws CameraAccessException {
        CameraManagerGlobal.get().setTorchMode(cameraId, enabled);
    }

    private static final void $$robo$$android_hardware_camera2_CameraManager$throwAsPublicException(Throwable t) throws CameraAccessException {
        if (t instanceof ServiceSpecificException) {
            ServiceSpecificException e = (ServiceSpecificException)t;
            int reason = 3;
            switch (e.errorCode) {
                case 4: {
                    reason = 2;
                    break;
                }
                case 6: {
                    reason = 1;
                    break;
                }
                case 7: {
                    reason = 4;
                    break;
                }
                case 8: {
                    reason = 5;
                    break;
                }
                case 9: {
                    reason = 1000;
                    break;
                }
                case 2: 
                case 3: {
                    throw new IllegalArgumentException(e.getMessage(), e);
                }
                case 1: {
                    throw new SecurityException(e.getMessage(), e);
                }
                default: {
                    reason = 3;
                }
            }
            throw new CameraAccessException(reason, e.getMessage(), e);
        }
        if (t instanceof DeadObjectException) {
            throw new CameraAccessException(2, "Camera service has died unexpectedly", t);
        }
        if (t instanceof RemoteException) {
            throw new UnsupportedOperationException("An unknown RemoteException was thrown which should never happen.", t);
        }
        if (t instanceof RuntimeException) {
            RuntimeException e = (RuntimeException)t;
            throw e;
        }
    }

    private final boolean $$robo$$android_hardware_camera2_CameraManager$supportsCamera2ApiLocked(String cameraId) {
        return this.supportsCameraApiLocked(cameraId, 2);
    }

    private final boolean $$robo$$android_hardware_camera2_CameraManager$supportsCameraApiLocked(String cameraId, int apiVersion) {
        try {
            ICameraService cameraService = CameraManagerGlobal.get().getCameraService();
            if (cameraService == null) {
                return false;
            }
            return cameraService.supportsCameraApi(cameraId, apiVersion);
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    private void __constructor__(Context context) {
        this.$$robo$$android_hardware_camera2_CameraManager$__constructor__(context);
    }

    public CameraManager(Context context) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_CameraManager$__constructor__(android.content.Context ), this, context);
    }

    public String[] getCameraIdList() throws CameraAccessException {
        return InvokeDynamicSupport.bootstrap("getCameraIdList", $$robo$$android_hardware_camera2_CameraManager$getCameraIdList(), this);
    }

    public void registerAvailabilityCallback(AvailabilityCallback availabilityCallback, Handler handler) {
        InvokeDynamicSupport.bootstrap("registerAvailabilityCallback", $$robo$$android_hardware_camera2_CameraManager$registerAvailabilityCallback(android.hardware.camera2.CameraManager$AvailabilityCallback android.os.Handler ), this, availabilityCallback, handler);
    }

    public void unregisterAvailabilityCallback(AvailabilityCallback availabilityCallback) {
        InvokeDynamicSupport.bootstrap("unregisterAvailabilityCallback", $$robo$$android_hardware_camera2_CameraManager$unregisterAvailabilityCallback(android.hardware.camera2.CameraManager$AvailabilityCallback ), this, availabilityCallback);
    }

    public void registerTorchCallback(TorchCallback torchCallback, Handler handler) {
        InvokeDynamicSupport.bootstrap("registerTorchCallback", $$robo$$android_hardware_camera2_CameraManager$registerTorchCallback(android.hardware.camera2.CameraManager$TorchCallback android.os.Handler ), this, torchCallback, handler);
    }

    public void unregisterTorchCallback(TorchCallback torchCallback) {
        InvokeDynamicSupport.bootstrap("unregisterTorchCallback", $$robo$$android_hardware_camera2_CameraManager$unregisterTorchCallback(android.hardware.camera2.CameraManager$TorchCallback ), this, torchCallback);
    }

    public CameraCharacteristics getCameraCharacteristics(String string2) throws CameraAccessException {
        return InvokeDynamicSupport.bootstrap("getCameraCharacteristics", $$robo$$android_hardware_camera2_CameraManager$getCameraCharacteristics(java.lang.String ), this, string2);
    }

    private CameraDevice openCameraDeviceUserAsync(String string2, CameraDevice.StateCallback stateCallback, Handler handler, int n) throws CameraAccessException {
        return InvokeDynamicSupport.bootstrap("openCameraDeviceUserAsync", $$robo$$android_hardware_camera2_CameraManager$openCameraDeviceUserAsync(java.lang.String android.hardware.camera2.CameraDevice$StateCallback android.os.Handler int ), this, string2, stateCallback, handler, n);
    }

    public void openCamera(String string2, CameraDevice.StateCallback stateCallback, Handler handler) throws CameraAccessException {
        InvokeDynamicSupport.bootstrap("openCamera", $$robo$$android_hardware_camera2_CameraManager$openCamera(java.lang.String android.hardware.camera2.CameraDevice$StateCallback android.os.Handler ), this, string2, stateCallback, handler);
    }

    public void openCameraForUid(String string2, CameraDevice.StateCallback stateCallback, Handler handler, int n) throws CameraAccessException {
        InvokeDynamicSupport.bootstrap("openCameraForUid", $$robo$$android_hardware_camera2_CameraManager$openCameraForUid(java.lang.String android.hardware.camera2.CameraDevice$StateCallback android.os.Handler int ), this, string2, stateCallback, handler, n);
    }

    public void setTorchMode(String string2, boolean bl) throws CameraAccessException {
        InvokeDynamicSupport.bootstrap("setTorchMode", $$robo$$android_hardware_camera2_CameraManager$setTorchMode(java.lang.String boolean ), this, string2, bl);
    }

    public static void throwAsPublicException(Throwable throwable) throws CameraAccessException {
        InvokeDynamicSupport.bootstrapStatic("throwAsPublicException", $$robo$$android_hardware_camera2_CameraManager$throwAsPublicException(java.lang.Throwable ), (Throwable)throwable);
    }

    private boolean supportsCamera2ApiLocked(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("supportsCamera2ApiLocked", $$robo$$android_hardware_camera2_CameraManager$supportsCamera2ApiLocked(java.lang.String ), this, string2);
    }

    private boolean supportsCameraApiLocked(String string2, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("supportsCameraApiLocked", $$robo$$android_hardware_camera2_CameraManager$supportsCameraApiLocked(java.lang.String int ), this, string2, n);
    }

    public /* synthetic */ CameraManager() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CameraManager)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class CameraManagerGlobal
    extends ICameraServiceListener.Stub
    implements IBinder.DeathRecipient,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private static String TAG = "CameraManagerGlobal";
        private boolean DEBUG = false;
        private int CAMERA_SERVICE_RECONNECT_DELAY_MS = 1000;
        private static CameraManagerGlobal gCameraManager;
        private static String CAMERA_SERVICE_BINDER_NAME = "media.camera";
        private ArrayMap<String, Integer> mDeviceStatus;
        private ArrayMap<AvailabilityCallback, Handler> mCallbackMap;
        private Binder mTorchClientBinder;
        private ArrayMap<String, Integer> mTorchStatus;
        private ArrayMap<TorchCallback, Handler> mTorchCallbackMap;
        private Object mLock;
        private ICameraService mCameraService;

        private void $$robo$$android_hardware_camera2_CameraManager_CameraManagerGlobal$__constructor__() {
            this.DEBUG = false;
            this.CAMERA_SERVICE_RECONNECT_DELAY_MS = 1000;
            this.mDeviceStatus = new ArrayMap();
            this.mCallbackMap = new ArrayMap();
            this.mTorchClientBinder = new Binder();
            this.mTorchStatus = new ArrayMap();
            this.mTorchCallbackMap = new ArrayMap();
            this.mLock = new Object();
        }

        private static final CameraManagerGlobal $$robo$$android_hardware_camera2_CameraManager_CameraManagerGlobal$get() {
            return gCameraManager;
        }

        private final IBinder $$robo$$android_hardware_camera2_CameraManager_CameraManagerGlobal$asBinder() {
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final ICameraService $$robo$$android_hardware_camera2_CameraManager_CameraManagerGlobal$getCameraService() {
            Object object = this.mLock;
            synchronized (object) {
                this.connectCameraServiceLocked();
                if (this.mCameraService == null) {
                    Log.e("CameraManagerGlobal", "Camera service is unavailable");
                }
                return this.mCameraService;
            }
        }

        private final void $$robo$$android_hardware_camera2_CameraManager_CameraManagerGlobal$connectCameraServiceLocked() {
            if (this.mCameraService != null) {
                return;
            }
            Log.i("CameraManagerGlobal", "Connecting to camera service");
            IBinder cameraServiceBinder = ServiceManager.getService("media.camera");
            if (cameraServiceBinder == null) {
                return;
            }
            try {
                cameraServiceBinder.linkToDeath(this, 0);
            }
            catch (RemoteException e) {
                return;
            }
            ICameraService cameraService = ICameraService.Stub.asInterface(cameraServiceBinder);
            try {
                CameraMetadataNative.setupGlobalVendorTagDescriptor();
            }
            catch (ServiceSpecificException e) {
                this.handleRecoverableSetupErrors(e);
            }
            try {
                CameraStatus[] cameraStatuses;
                for (CameraStatus c : cameraStatuses = cameraService.addListener(this)) {
                    this.onStatusChangedLocked(c.status, c.cameraId);
                }
                this.mCameraService = cameraService;
            }
            catch (ServiceSpecificException e) {
                throw new IllegalStateException("Failed to register a camera service listener", e);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final String[] $$robo$$android_hardware_camera2_CameraManager_CameraManagerGlobal$getCameraIdList() {
            String[] cameraIds = null;
            Object object = this.mLock;
            synchronized (object) {
                int status;
                int i;
                this.connectCameraServiceLocked();
                int idCount = 0;
                for (i = 0; i < this.mDeviceStatus.size(); ++i) {
                    status = this.mDeviceStatus.valueAt(i);
                    if (status == 0 || status == 2) continue;
                    ++idCount;
                }
                cameraIds = new String[idCount];
                idCount = 0;
                for (i = 0; i < this.mDeviceStatus.size(); ++i) {
                    status = this.mDeviceStatus.valueAt(i);
                    if (status == 0 || status == 2) continue;
                    cameraIds[idCount] = this.mDeviceStatus.keyAt(i);
                    ++idCount;
                }
            }
            return cameraIds;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_hardware_camera2_CameraManager_CameraManagerGlobal$setTorchMode(String cameraId, boolean enabled) throws CameraAccessException {
            Object object = this.mLock;
            synchronized (object) {
                if (cameraId == null) {
                    throw new IllegalArgumentException("cameraId was null");
                }
                ICameraService cameraService = this.getCameraService();
                if (cameraService == null) {
                    throw new CameraAccessException(2, "Camera service is currently unavailable");
                }
                try {
                    cameraService.setTorchMode(cameraId, enabled, this.mTorchClientBinder);
                }
                catch (ServiceSpecificException e) {
                    CameraManager.throwAsPublicException(e);
                }
                catch (RemoteException e) {
                    throw new CameraAccessException(2, "Camera service is currently unavailable");
                }
            }
        }

        private final void $$robo$$android_hardware_camera2_CameraManager_CameraManagerGlobal$handleRecoverableSetupErrors(ServiceSpecificException e) {
            switch (e.errorCode) {
                case 4: {
                    Log.w("CameraManagerGlobal", e.getMessage());
                    break;
                }
                default: {
                    throw new IllegalStateException(e);
                }
            }
        }

        private final boolean $$robo$$android_hardware_camera2_CameraManager_CameraManagerGlobal$isAvailable(int status) {
            switch (status) {
                case 1: {
                    return true;
                }
            }
            return false;
        }

        private final boolean $$robo$$android_hardware_camera2_CameraManager_CameraManagerGlobal$validStatus(int status) {
            switch (status) {
                case -2: 
                case 0: 
                case 1: 
                case 2: {
                    return true;
                }
            }
            return false;
        }

        private final boolean $$robo$$android_hardware_camera2_CameraManager_CameraManagerGlobal$validTorchStatus(int status) {
            switch (status) {
                case 0: 
                case 1: 
                case 2: {
                    return true;
                }
            }
            return false;
        }

        private final void $$robo$$android_hardware_camera2_CameraManager_CameraManagerGlobal$postSingleUpdate(AvailabilityCallback callback, Handler handler, String id2, int status) {
            if (this.isAvailable(status)) {
                handler.post(new Runnable(this, callback, id2){
                    public /* synthetic */ Object __robo_data__;
                    /* synthetic */ AvailabilityCallback val$callback;
                    /* synthetic */ String val$id;
                    /* synthetic */ CameraManagerGlobal this$0;

                    private void $$robo$$android_hardware_camera2_CameraManager_CameraManagerGlobal_1$__constructor__(CameraManagerGlobal this$0, AvailabilityCallback availabilityCallback, String string2) {
                        this.val$callback = availabilityCallback;
                        this.val$id = string2;
                    }

                    private final void $$robo$$android_hardware_camera2_CameraManager_CameraManagerGlobal_1$run() {
                        this.val$callback.onCameraAvailable(this.val$id);
                    }

                    private void __constructor__(CameraManagerGlobal cameraManagerGlobal, AvailabilityCallback availabilityCallback, String string2) {
                        this.$$robo$$android_hardware_camera2_CameraManager_CameraManagerGlobal_1$__constructor__(cameraManagerGlobal, availabilityCallback, string2);
                    }
                    {
                        this.this$0 = cameraManagerGlobal;
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_CameraManager_CameraManagerGlobal_1$__constructor__(android.hardware.camera2.CameraManager$CameraManagerGlobal android.hardware.camera2.CameraManager$AvailabilityCallback java.lang.String ), this, cameraManagerGlobal, availabilityCallback, string2);
                    }

                    @Override
                    public void run() {
                        InvokeDynamicSupport.bootstrap("run", $$robo$$android_hardware_camera2_CameraManager_CameraManagerGlobal_1$run(), this);
                    }
                    {
                        this.$$robo$init();
                    }

                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                });
            } else {
                handler.post(new Runnable(this, callback, id2){
                    public /* synthetic */ Object __robo_data__;
                    /* synthetic */ AvailabilityCallback val$callback;
                    /* synthetic */ String val$id;
                    /* synthetic */ CameraManagerGlobal this$0;

                    private void $$robo$$android_hardware_camera2_CameraManager_CameraManagerGlobal_2$__constructor__(CameraManagerGlobal this$0, AvailabilityCallback availabilityCallback, String string2) {
                        this.val$callback = availabilityCallback;
                        this.val$id = string2;
                    }

                    private final void $$robo$$android_hardware_camera2_CameraManager_CameraManagerGlobal_2$run() {
                        this.val$callback.onCameraUnavailable(this.val$id);
                    }

                    private void __constructor__(CameraManagerGlobal cameraManagerGlobal, AvailabilityCallback availabilityCallback, String string2) {
                        this.$$robo$$android_hardware_camera2_CameraManager_CameraManagerGlobal_2$__constructor__(cameraManagerGlobal, availabilityCallback, string2);
                    }
                    {
                        this.this$0 = cameraManagerGlobal;
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_CameraManager_CameraManagerGlobal_2$__constructor__(android.hardware.camera2.CameraManager$CameraManagerGlobal android.hardware.camera2.CameraManager$AvailabilityCallback java.lang.String ), this, cameraManagerGlobal, availabilityCallback, string2);
                    }

                    @Override
                    public void run() {
                        InvokeDynamicSupport.bootstrap("run", $$robo$$android_hardware_camera2_CameraManager_CameraManagerGlobal_2$run(), this);
                    }
                    {
                        this.$$robo$init();
                    }

                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                });
            }
        }

        private final void $$robo$$android_hardware_camera2_CameraManager_CameraManagerGlobal$postSingleTorchUpdate(TorchCallback callback, Handler handler, String id2, int status) {
            switch (status) {
                case 1: 
                case 2: {
                    handler.post(new Runnable(this, callback, id2, status){
                        public /* synthetic */ Object __robo_data__;
                        /* synthetic */ TorchCallback val$callback;
                        /* synthetic */ String val$id;
                        /* synthetic */ int val$status;
                        /* synthetic */ CameraManagerGlobal this$0;

                        private void $$robo$$android_hardware_camera2_CameraManager_CameraManagerGlobal_3$__constructor__(CameraManagerGlobal this$0, TorchCallback torchCallback, String string2, int n) {
                            this.val$callback = torchCallback;
                            this.val$id = string2;
                            this.val$status = n;
                        }

                        private final void $$robo$$android_hardware_camera2_CameraManager_CameraManagerGlobal_3$run() {
                            this.val$callback.onTorchModeChanged(this.val$id, this.val$status == 2);
                        }

                        private void __constructor__(CameraManagerGlobal cameraManagerGlobal, TorchCallback torchCallback, String string2, int n) {
                            this.$$robo$$android_hardware_camera2_CameraManager_CameraManagerGlobal_3$__constructor__(cameraManagerGlobal, torchCallback, string2, n);
                        }
                        {
                            this.this$0 = cameraManagerGlobal;
                            this.$$robo$init();
                            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_CameraManager_CameraManagerGlobal_3$__constructor__(android.hardware.camera2.CameraManager$CameraManagerGlobal android.hardware.camera2.CameraManager$TorchCallback java.lang.String int ), this, cameraManagerGlobal, torchCallback, string2, n);
                        }

                        @Override
                        public void run() {
                            InvokeDynamicSupport.bootstrap("run", $$robo$$android_hardware_camera2_CameraManager_CameraManagerGlobal_3$run(), this);
                        }
                        {
                            this.$$robo$init();
                        }

                        protected /* synthetic */ void $$robo$init() {
                            if (this.__robo_data__ == null) {
                                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                            }
                        }

                        public /* synthetic */ Object $$robo$getData() {
                            return this.__robo_data__;
                        }
                    });
                    break;
                }
                default: {
                    handler.post(new Runnable(this, callback, id2){
                        public /* synthetic */ Object __robo_data__;
                        /* synthetic */ TorchCallback val$callback;
                        /* synthetic */ String val$id;
                        /* synthetic */ CameraManagerGlobal this$0;

                        private void $$robo$$android_hardware_camera2_CameraManager_CameraManagerGlobal_4$__constructor__(CameraManagerGlobal this$0, TorchCallback torchCallback, String string2) {
                            this.val$callback = torchCallback;
                            this.val$id = string2;
                        }

                        private final void $$robo$$android_hardware_camera2_CameraManager_CameraManagerGlobal_4$run() {
                            this.val$callback.onTorchModeUnavailable(this.val$id);
                        }

                        private void __constructor__(CameraManagerGlobal cameraManagerGlobal, TorchCallback torchCallback, String string2) {
                            this.$$robo$$android_hardware_camera2_CameraManager_CameraManagerGlobal_4$__constructor__(cameraManagerGlobal, torchCallback, string2);
                        }
                        {
                            this.this$0 = cameraManagerGlobal;
                            this.$$robo$init();
                            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_CameraManager_CameraManagerGlobal_4$__constructor__(android.hardware.camera2.CameraManager$CameraManagerGlobal android.hardware.camera2.CameraManager$TorchCallback java.lang.String ), this, cameraManagerGlobal, torchCallback, string2);
                        }

                        @Override
                        public void run() {
                            InvokeDynamicSupport.bootstrap("run", $$robo$$android_hardware_camera2_CameraManager_CameraManagerGlobal_4$run(), this);
                        }
                        {
                            this.$$robo$init();
                        }

                        protected /* synthetic */ void $$robo$init() {
                            if (this.__robo_data__ == null) {
                                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                            }
                        }

                        public /* synthetic */ Object $$robo$getData() {
                            return this.__robo_data__;
                        }
                    });
                }
            }
        }

        private final void $$robo$$android_hardware_camera2_CameraManager_CameraManagerGlobal$updateCallbackLocked(AvailabilityCallback callback, Handler handler) {
            for (int i = 0; i < this.mDeviceStatus.size(); ++i) {
                String id2 = this.mDeviceStatus.keyAt(i);
                Integer status = this.mDeviceStatus.valueAt(i);
                this.postSingleUpdate(callback, handler, id2, status);
            }
        }

        private final void $$robo$$android_hardware_camera2_CameraManager_CameraManagerGlobal$onStatusChangedLocked(int status, String id2) {
            if (!this.validStatus(status)) {
                Log.e("CameraManagerGlobal", String.format("Ignoring invalid device %s status 0x%x", id2, status));
                return;
            }
            Integer oldStatus = this.mDeviceStatus.put(id2, status);
            if (oldStatus != null && oldStatus == status) {
                return;
            }
            if (oldStatus != null && this.isAvailable(status) == this.isAvailable(oldStatus)) {
                return;
            }
            int callbackCount = this.mCallbackMap.size();
            for (int i = 0; i < callbackCount; ++i) {
                Handler handler = this.mCallbackMap.valueAt(i);
                AvailabilityCallback callback = this.mCallbackMap.keyAt(i);
                this.postSingleUpdate(callback, handler, id2, status);
            }
        }

        private final void $$robo$$android_hardware_camera2_CameraManager_CameraManagerGlobal$updateTorchCallbackLocked(TorchCallback callback, Handler handler) {
            for (int i = 0; i < this.mTorchStatus.size(); ++i) {
                String id2 = this.mTorchStatus.keyAt(i);
                Integer status = this.mTorchStatus.valueAt(i);
                this.postSingleTorchUpdate(callback, handler, id2, status);
            }
        }

        private final void $$robo$$android_hardware_camera2_CameraManager_CameraManagerGlobal$onTorchStatusChangedLocked(int status, String id2) {
            if (!this.validTorchStatus(status)) {
                Log.e("CameraManagerGlobal", String.format("Ignoring invalid device %s torch status 0x%x", id2, status));
                return;
            }
            Integer oldStatus = this.mTorchStatus.put(id2, status);
            if (oldStatus != null && oldStatus == status) {
                return;
            }
            int callbackCount = this.mTorchCallbackMap.size();
            for (int i = 0; i < callbackCount; ++i) {
                Handler handler = this.mTorchCallbackMap.valueAt(i);
                TorchCallback callback = this.mTorchCallbackMap.keyAt(i);
                this.postSingleTorchUpdate(callback, handler, id2, status);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_hardware_camera2_CameraManager_CameraManagerGlobal$registerAvailabilityCallback(AvailabilityCallback callback, Handler handler) {
            Object object = this.mLock;
            synchronized (object) {
                this.connectCameraServiceLocked();
                Handler oldHandler = this.mCallbackMap.put(callback, handler);
                if (oldHandler == null) {
                    this.updateCallbackLocked(callback, handler);
                }
                if (this.mCameraService == null) {
                    this.scheduleCameraServiceReconnectionLocked();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_hardware_camera2_CameraManager_CameraManagerGlobal$unregisterAvailabilityCallback(AvailabilityCallback callback) {
            Object object = this.mLock;
            synchronized (object) {
                this.mCallbackMap.remove(callback);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_hardware_camera2_CameraManager_CameraManagerGlobal$registerTorchCallback(TorchCallback callback, Handler handler) {
            Object object = this.mLock;
            synchronized (object) {
                this.connectCameraServiceLocked();
                Handler oldHandler = this.mTorchCallbackMap.put(callback, handler);
                if (oldHandler == null) {
                    this.updateTorchCallbackLocked(callback, handler);
                }
                if (this.mCameraService == null) {
                    this.scheduleCameraServiceReconnectionLocked();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_hardware_camera2_CameraManager_CameraManagerGlobal$unregisterTorchCallback(TorchCallback callback) {
            Object object = this.mLock;
            synchronized (object) {
                this.mTorchCallbackMap.remove(callback);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_hardware_camera2_CameraManager_CameraManagerGlobal$onStatusChanged(int status, String cameraId) throws RemoteException {
            Object object = this.mLock;
            synchronized (object) {
                this.onStatusChangedLocked(status, cameraId);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_hardware_camera2_CameraManager_CameraManagerGlobal$onTorchStatusChanged(int status, String cameraId) throws RemoteException {
            Object object = this.mLock;
            synchronized (object) {
                this.onTorchStatusChangedLocked(status, cameraId);
            }
        }

        private final void $$robo$$android_hardware_camera2_CameraManager_CameraManagerGlobal$scheduleCameraServiceReconnectionLocked() {
            Handler handler;
            if (this.mCallbackMap.size() > 0) {
                handler = this.mCallbackMap.valueAt(0);
            } else if (this.mTorchCallbackMap.size() > 0) {
                handler = this.mTorchCallbackMap.valueAt(0);
            } else {
                return;
            }
            handler.postDelayed(new Runnable(this){
                public /* synthetic */ Object __robo_data__;
                /* synthetic */ CameraManagerGlobal this$0;

                private void $$robo$$android_hardware_camera2_CameraManager_CameraManagerGlobal_5$__constructor__(CameraManagerGlobal this$0) {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private final void $$robo$$android_hardware_camera2_CameraManager_CameraManagerGlobal_5$run() {
                    ICameraService cameraService = this.this$0.getCameraService();
                    if (cameraService == null) {
                        Object object = this.this$0.mLock;
                        synchronized (object) {
                            this.this$0.scheduleCameraServiceReconnectionLocked();
                        }
                    }
                }

                private void __constructor__(CameraManagerGlobal cameraManagerGlobal) {
                    this.$$robo$$android_hardware_camera2_CameraManager_CameraManagerGlobal_5$__constructor__(cameraManagerGlobal);
                }
                {
                    this.this$0 = cameraManagerGlobal;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_CameraManager_CameraManagerGlobal_5$__constructor__(android.hardware.camera2.CameraManager$CameraManagerGlobal ), this, cameraManagerGlobal);
                }

                @Override
                public void run() {
                    InvokeDynamicSupport.bootstrap("run", $$robo$$android_hardware_camera2_CameraManager_CameraManagerGlobal_5$run(), this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            }, 1000L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_hardware_camera2_CameraManager_CameraManagerGlobal$binderDied() {
            Object object = this.mLock;
            synchronized (object) {
                String cameraId;
                int i;
                if (this.mCameraService == null) {
                    return;
                }
                this.mCameraService = null;
                for (i = 0; i < this.mDeviceStatus.size(); ++i) {
                    cameraId = this.mDeviceStatus.keyAt(i);
                    this.onStatusChangedLocked(0, cameraId);
                }
                for (i = 0; i < this.mTorchStatus.size(); ++i) {
                    cameraId = this.mTorchStatus.keyAt(i);
                    this.onTorchStatusChangedLocked(0, cameraId);
                }
                this.scheduleCameraServiceReconnectionLocked();
            }
        }

        static void __staticInitializer__() {
            gCameraManager = new CameraManagerGlobal();
        }

        private void __constructor__() {
            this.$$robo$$android_hardware_camera2_CameraManager_CameraManagerGlobal$__constructor__();
        }

        public CameraManagerGlobal() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_CameraManager_CameraManagerGlobal$__constructor__(), this);
        }

        public static CameraManagerGlobal get() {
            return InvokeDynamicSupport.bootstrapStatic("get", $$robo$$android_hardware_camera2_CameraManager_CameraManagerGlobal$get());
        }

        @Override
        public IBinder asBinder() {
            return InvokeDynamicSupport.bootstrap("asBinder", $$robo$$android_hardware_camera2_CameraManager_CameraManagerGlobal$asBinder(), this);
        }

        public ICameraService getCameraService() {
            return InvokeDynamicSupport.bootstrap("getCameraService", $$robo$$android_hardware_camera2_CameraManager_CameraManagerGlobal$getCameraService(), this);
        }

        private void connectCameraServiceLocked() {
            InvokeDynamicSupport.bootstrap("connectCameraServiceLocked", $$robo$$android_hardware_camera2_CameraManager_CameraManagerGlobal$connectCameraServiceLocked(), this);
        }

        public String[] getCameraIdList() {
            return InvokeDynamicSupport.bootstrap("getCameraIdList", $$robo$$android_hardware_camera2_CameraManager_CameraManagerGlobal$getCameraIdList(), this);
        }

        public void setTorchMode(String string2, boolean bl) throws CameraAccessException {
            InvokeDynamicSupport.bootstrap("setTorchMode", $$robo$$android_hardware_camera2_CameraManager_CameraManagerGlobal$setTorchMode(java.lang.String boolean ), this, string2, bl);
        }

        private void handleRecoverableSetupErrors(ServiceSpecificException serviceSpecificException) {
            InvokeDynamicSupport.bootstrap("handleRecoverableSetupErrors", $$robo$$android_hardware_camera2_CameraManager_CameraManagerGlobal$handleRecoverableSetupErrors(android.os.ServiceSpecificException ), this, serviceSpecificException);
        }

        private boolean isAvailable(int n) {
            return (boolean)InvokeDynamicSupport.bootstrap("isAvailable", $$robo$$android_hardware_camera2_CameraManager_CameraManagerGlobal$isAvailable(int ), this, n);
        }

        private boolean validStatus(int n) {
            return (boolean)InvokeDynamicSupport.bootstrap("validStatus", $$robo$$android_hardware_camera2_CameraManager_CameraManagerGlobal$validStatus(int ), this, n);
        }

        private boolean validTorchStatus(int n) {
            return (boolean)InvokeDynamicSupport.bootstrap("validTorchStatus", $$robo$$android_hardware_camera2_CameraManager_CameraManagerGlobal$validTorchStatus(int ), this, n);
        }

        private void postSingleUpdate(AvailabilityCallback availabilityCallback, Handler handler, String string2, int n) {
            InvokeDynamicSupport.bootstrap("postSingleUpdate", $$robo$$android_hardware_camera2_CameraManager_CameraManagerGlobal$postSingleUpdate(android.hardware.camera2.CameraManager$AvailabilityCallback android.os.Handler java.lang.String int ), this, availabilityCallback, handler, string2, n);
        }

        private void postSingleTorchUpdate(TorchCallback torchCallback, Handler handler, String string2, int n) {
            InvokeDynamicSupport.bootstrap("postSingleTorchUpdate", $$robo$$android_hardware_camera2_CameraManager_CameraManagerGlobal$postSingleTorchUpdate(android.hardware.camera2.CameraManager$TorchCallback android.os.Handler java.lang.String int ), this, torchCallback, handler, string2, n);
        }

        private void updateCallbackLocked(AvailabilityCallback availabilityCallback, Handler handler) {
            InvokeDynamicSupport.bootstrap("updateCallbackLocked", $$robo$$android_hardware_camera2_CameraManager_CameraManagerGlobal$updateCallbackLocked(android.hardware.camera2.CameraManager$AvailabilityCallback android.os.Handler ), this, availabilityCallback, handler);
        }

        private void onStatusChangedLocked(int n, String string2) {
            InvokeDynamicSupport.bootstrap("onStatusChangedLocked", $$robo$$android_hardware_camera2_CameraManager_CameraManagerGlobal$onStatusChangedLocked(int java.lang.String ), this, n, string2);
        }

        private void updateTorchCallbackLocked(TorchCallback torchCallback, Handler handler) {
            InvokeDynamicSupport.bootstrap("updateTorchCallbackLocked", $$robo$$android_hardware_camera2_CameraManager_CameraManagerGlobal$updateTorchCallbackLocked(android.hardware.camera2.CameraManager$TorchCallback android.os.Handler ), this, torchCallback, handler);
        }

        private void onTorchStatusChangedLocked(int n, String string2) {
            InvokeDynamicSupport.bootstrap("onTorchStatusChangedLocked", $$robo$$android_hardware_camera2_CameraManager_CameraManagerGlobal$onTorchStatusChangedLocked(int java.lang.String ), this, n, string2);
        }

        public void registerAvailabilityCallback(AvailabilityCallback availabilityCallback, Handler handler) {
            InvokeDynamicSupport.bootstrap("registerAvailabilityCallback", $$robo$$android_hardware_camera2_CameraManager_CameraManagerGlobal$registerAvailabilityCallback(android.hardware.camera2.CameraManager$AvailabilityCallback android.os.Handler ), this, availabilityCallback, handler);
        }

        public void unregisterAvailabilityCallback(AvailabilityCallback availabilityCallback) {
            InvokeDynamicSupport.bootstrap("unregisterAvailabilityCallback", $$robo$$android_hardware_camera2_CameraManager_CameraManagerGlobal$unregisterAvailabilityCallback(android.hardware.camera2.CameraManager$AvailabilityCallback ), this, availabilityCallback);
        }

        public void registerTorchCallback(TorchCallback torchCallback, Handler handler) {
            InvokeDynamicSupport.bootstrap("registerTorchCallback", $$robo$$android_hardware_camera2_CameraManager_CameraManagerGlobal$registerTorchCallback(android.hardware.camera2.CameraManager$TorchCallback android.os.Handler ), this, torchCallback, handler);
        }

        public void unregisterTorchCallback(TorchCallback torchCallback) {
            InvokeDynamicSupport.bootstrap("unregisterTorchCallback", $$robo$$android_hardware_camera2_CameraManager_CameraManagerGlobal$unregisterTorchCallback(android.hardware.camera2.CameraManager$TorchCallback ), this, torchCallback);
        }

        @Override
        public void onStatusChanged(int n, String string2) throws RemoteException {
            InvokeDynamicSupport.bootstrap("onStatusChanged", $$robo$$android_hardware_camera2_CameraManager_CameraManagerGlobal$onStatusChanged(int java.lang.String ), this, n, string2);
        }

        @Override
        public void onTorchStatusChanged(int n, String string2) throws RemoteException {
            InvokeDynamicSupport.bootstrap("onTorchStatusChanged", $$robo$$android_hardware_camera2_CameraManager_CameraManagerGlobal$onTorchStatusChanged(int java.lang.String ), this, n, string2);
        }

        private void scheduleCameraServiceReconnectionLocked() {
            InvokeDynamicSupport.bootstrap("scheduleCameraServiceReconnectionLocked", $$robo$$android_hardware_camera2_CameraManager_CameraManagerGlobal$scheduleCameraServiceReconnectionLocked(), this);
        }

        @Override
        public void binderDied() {
            InvokeDynamicSupport.bootstrap("binderDied", $$robo$$android_hardware_camera2_CameraManager_CameraManagerGlobal$binderDied(), this);
        }

        static {
            RobolectricInternals.classInitializing(CameraManagerGlobal.class);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CameraManagerGlobal)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static abstract class TorchCallback
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;

        private void $$robo$$android_hardware_camera2_CameraManager_TorchCallback$__constructor__() {
        }

        private final void $$robo$$android_hardware_camera2_CameraManager_TorchCallback$onTorchModeUnavailable(String cameraId) {
        }

        private final void $$robo$$android_hardware_camera2_CameraManager_TorchCallback$onTorchModeChanged(String cameraId, boolean enabled) {
        }

        private void __constructor__() {
            this.$$robo$$android_hardware_camera2_CameraManager_TorchCallback$__constructor__();
        }

        public TorchCallback() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_CameraManager_TorchCallback$__constructor__(), this);
        }

        public void onTorchModeUnavailable(String string2) {
            InvokeDynamicSupport.bootstrap("onTorchModeUnavailable", $$robo$$android_hardware_camera2_CameraManager_TorchCallback$onTorchModeUnavailable(java.lang.String ), this, string2);
        }

        public void onTorchModeChanged(String string2, boolean bl) {
            InvokeDynamicSupport.bootstrap("onTorchModeChanged", $$robo$$android_hardware_camera2_CameraManager_TorchCallback$onTorchModeChanged(java.lang.String boolean ), this, string2, bl);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TorchCallback)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static abstract class AvailabilityCallback
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;

        private void $$robo$$android_hardware_camera2_CameraManager_AvailabilityCallback$__constructor__() {
        }

        private final void $$robo$$android_hardware_camera2_CameraManager_AvailabilityCallback$onCameraAvailable(String cameraId) {
        }

        private final void $$robo$$android_hardware_camera2_CameraManager_AvailabilityCallback$onCameraUnavailable(String cameraId) {
        }

        private void __constructor__() {
            this.$$robo$$android_hardware_camera2_CameraManager_AvailabilityCallback$__constructor__();
        }

        public AvailabilityCallback() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_CameraManager_AvailabilityCallback$__constructor__(), this);
        }

        public void onCameraAvailable(String string2) {
            InvokeDynamicSupport.bootstrap("onCameraAvailable", $$robo$$android_hardware_camera2_CameraManager_AvailabilityCallback$onCameraAvailable(java.lang.String ), this, string2);
        }

        public void onCameraUnavailable(String string2) {
            InvokeDynamicSupport.bootstrap("onCameraUnavailable", $$robo$$android_hardware_camera2_CameraManager_AvailabilityCallback$onCameraUnavailable(java.lang.String ), this, string2);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AvailabilityCallback)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

