/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.legacy;

import android.hardware.Camera;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.CaptureResult;
import android.hardware.camera2.impl.CameraMetadataNative;
import android.hardware.camera2.utils.ParamsUtils;
import android.util.Log;
import com.android.internal.util.Preconditions;
import java.util.Objects;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class LegacyFocusStateMapper
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG;
    private static boolean DEBUG = false;
    private Camera mCamera;
    private int mAfStatePrevious;
    private String mAfModePrevious;
    private Object mLock;
    private int mAfRun;
    private int mAfState;

    private void $$robo$$android_hardware_camera2_legacy_LegacyFocusStateMapper$__constructor__(Camera camera) {
        this.mAfStatePrevious = 0;
        this.mAfModePrevious = null;
        this.mLock = new Object();
        this.mAfRun = 0;
        this.mAfState = 0;
        this.mCamera = Preconditions.checkNotNull(camera, "camera must not be null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_hardware_camera2_legacy_LegacyFocusStateMapper$processRequestTriggers(CaptureRequest captureRequest, Camera.Parameters parameters) {
        int currentAfRun;
        Preconditions.checkNotNull(captureRequest, "captureRequest must not be null");
        int afTrigger = ParamsUtils.getOrDefault(captureRequest, CaptureRequest.CONTROL_AF_TRIGGER, 0);
        String afMode = parameters.getFocusMode();
        if (!Objects.equals(this.mAfModePrevious, afMode)) {
            Object object = this.mLock;
            synchronized (object) {
                ++this.mAfRun;
                this.mAfState = 0;
            }
            this.mCamera.cancelAutoFocus();
        }
        this.mAfModePrevious = afMode;
        Object object = this.mLock;
        synchronized (object) {
            currentAfRun = this.mAfRun;
        }
        Object afMoveCallback = new Camera.AutoFocusMoveCallback(this, currentAfRun, afMode){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ int val$currentAfRun;
            /* synthetic */ String val$afMode;
            /* synthetic */ LegacyFocusStateMapper this$0;

            private void $$robo$$android_hardware_camera2_legacy_LegacyFocusStateMapper_1$__constructor__(LegacyFocusStateMapper this$0, int n, String string2) {
                this.val$currentAfRun = n;
                this.val$afMode = string2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_hardware_camera2_legacy_LegacyFocusStateMapper_1$onAutoFocusMoving(boolean start, Camera camera) {
                Object object = this.this$0.mLock;
                synchronized (object) {
                    int latestAfRun = this.this$0.mAfRun;
                    if (this.val$currentAfRun != latestAfRun) {
                        Log.d(TAG, "onAutoFocusMoving - ignoring move callbacks from old af run" + this.val$currentAfRun);
                        return;
                    }
                    int newAfState = start ? 1 : 2;
                    switch (this.val$afMode) {
                        case "continuous-picture": 
                        case "continuous-video": {
                            break;
                        }
                        default: {
                            Log.w(TAG, "onAutoFocus - got unexpected onAutoFocus in mode " + this.val$afMode);
                        }
                    }
                    this.this$0.mAfState = newAfState;
                }
            }

            private void __constructor__(LegacyFocusStateMapper legacyFocusStateMapper, int n, String string2) {
                this.$$robo$$android_hardware_camera2_legacy_LegacyFocusStateMapper_1$__constructor__(legacyFocusStateMapper, n, string2);
            }
            {
                this.this$0 = legacyFocusStateMapper;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_legacy_LegacyFocusStateMapper_1$__constructor__(android.hardware.camera2.legacy.LegacyFocusStateMapper int java.lang.String ), this, legacyFocusStateMapper, n, string2);
            }

            @Override
            public void onAutoFocusMoving(boolean bl, Camera camera) {
                InvokeDynamicSupport.bootstrap("onAutoFocusMoving", $$robo$$android_hardware_camera2_legacy_LegacyFocusStateMapper_1$onAutoFocusMoving(boolean android.hardware.Camera ), this, bl, camera);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        switch (afMode) {
            case "auto": 
            case "macro": 
            case "continuous-picture": 
            case "continuous-video": {
                this.mCamera.setAutoFocusMoveCallback((Camera.AutoFocusMoveCallback)afMoveCallback);
            }
        }
        switch (afTrigger) {
            case 1: {
                int currentAfRun2;
                int afStateAfterStart;
                switch (afMode) {
                    case "auto": 
                    case "macro": {
                        afStateAfterStart = 3;
                        break;
                    }
                    case "continuous-picture": 
                    case "continuous-video": {
                        afStateAfterStart = 1;
                        break;
                    }
                    default: {
                        afStateAfterStart = 0;
                    }
                }
                Object object2 = this.mLock;
                synchronized (object2) {
                    currentAfRun2 = ++this.mAfRun;
                    this.mAfState = afStateAfterStart;
                }
                if (afStateAfterStart == 0) break;
                this.mCamera.autoFocus(new Camera.AutoFocusCallback(this, currentAfRun2, afMode){
                    public /* synthetic */ Object __robo_data__;
                    /* synthetic */ int val$currentAfRun;
                    /* synthetic */ String val$afMode;
                    /* synthetic */ LegacyFocusStateMapper this$0;

                    private void $$robo$$android_hardware_camera2_legacy_LegacyFocusStateMapper_2$__constructor__(LegacyFocusStateMapper this$0, int n, String string2) {
                        this.val$currentAfRun = n;
                        this.val$afMode = string2;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    private final void $$robo$$android_hardware_camera2_legacy_LegacyFocusStateMapper_2$onAutoFocus(boolean success, Camera camera) {
                        Object object = this.this$0.mLock;
                        synchronized (object) {
                            int latestAfRun = this.this$0.mAfRun;
                            if (latestAfRun != this.val$currentAfRun) {
                                Log.d(TAG, String.format("onAutoFocus - ignoring AF callback (old run %d, new run %d)", this.val$currentAfRun, latestAfRun));
                                return;
                            }
                            int newAfState = success ? 4 : 5;
                            switch (this.val$afMode) {
                                case "auto": 
                                case "continuous-picture": 
                                case "continuous-video": 
                                case "macro": {
                                    break;
                                }
                                default: {
                                    Log.w(TAG, "onAutoFocus - got unexpected onAutoFocus in mode " + this.val$afMode);
                                }
                            }
                            this.this$0.mAfState = newAfState;
                        }
                    }

                    private void __constructor__(LegacyFocusStateMapper legacyFocusStateMapper, int n, String string2) {
                        this.$$robo$$android_hardware_camera2_legacy_LegacyFocusStateMapper_2$__constructor__(legacyFocusStateMapper, n, string2);
                    }
                    {
                        this.this$0 = legacyFocusStateMapper;
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_legacy_LegacyFocusStateMapper_2$__constructor__(android.hardware.camera2.legacy.LegacyFocusStateMapper int java.lang.String ), this, legacyFocusStateMapper, n, string2);
                    }

                    @Override
                    public void onAutoFocus(boolean bl, Camera camera) {
                        InvokeDynamicSupport.bootstrap("onAutoFocus", $$robo$$android_hardware_camera2_legacy_LegacyFocusStateMapper_2$onAutoFocus(boolean android.hardware.Camera ), this, bl, camera);
                    }
                    {
                        this.$$robo$init();
                    }

                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                });
                break;
            }
            case 2: {
                Object object3 = this.mLock;
                synchronized (object3) {
                    Object object4 = this.mLock;
                    synchronized (object4) {
                        int updatedAfRun = ++this.mAfRun;
                        this.mAfState = 0;
                    }
                    this.mCamera.cancelAutoFocus();
                    break;
                }
            }
            case 0: {
                break;
            }
            default: {
                Log.w(TAG, "processRequestTriggers - ignoring unknown control.afTrigger = " + afTrigger);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_hardware_camera2_legacy_LegacyFocusStateMapper$mapResultTriggers(CameraMetadataNative result) {
        int newAfState;
        Preconditions.checkNotNull(result, "result must not be null");
        Object object = this.mLock;
        synchronized (object) {
            newAfState = this.mAfState;
        }
        result.set(CaptureResult.CONTROL_AF_STATE, Integer.valueOf(newAfState));
        this.mAfStatePrevious = newAfState;
    }

    private static final String $$robo$$android_hardware_camera2_legacy_LegacyFocusStateMapper$afStateToString(int afState) {
        switch (afState) {
            case 3: {
                return "ACTIVE_SCAN";
            }
            case 4: {
                return "FOCUSED_LOCKED";
            }
            case 0: {
                return "INACTIVE";
            }
            case 5: {
                return "NOT_FOCUSED_LOCKED";
            }
            case 2: {
                return "PASSIVE_FOCUSED";
            }
            case 1: {
                return "PASSIVE_SCAN";
            }
            case 6: {
                return "PASSIVE_UNFOCUSED";
            }
        }
        return "UNKNOWN(" + afState + ")";
    }

    static void __staticInitializer__() {
        TAG = "LegacyFocusStateMapper";
    }

    private void __constructor__(Camera camera) {
        this.$$robo$$android_hardware_camera2_legacy_LegacyFocusStateMapper$__constructor__(camera);
    }

    public LegacyFocusStateMapper(Camera camera) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_legacy_LegacyFocusStateMapper$__constructor__(android.hardware.Camera ), this, camera);
    }

    public void processRequestTriggers(CaptureRequest captureRequest, Camera.Parameters parameters) {
        InvokeDynamicSupport.bootstrap("processRequestTriggers", $$robo$$android_hardware_camera2_legacy_LegacyFocusStateMapper$processRequestTriggers(android.hardware.camera2.CaptureRequest android.hardware.Camera$Parameters ), this, captureRequest, parameters);
    }

    public void mapResultTriggers(CameraMetadataNative cameraMetadataNative) {
        InvokeDynamicSupport.bootstrap("mapResultTriggers", $$robo$$android_hardware_camera2_legacy_LegacyFocusStateMapper$mapResultTriggers(android.hardware.camera2.impl.CameraMetadataNative ), this, cameraMetadataNative);
    }

    private static String afStateToString(int n) {
        return InvokeDynamicSupport.bootstrapStatic("afStateToString", $$robo$$android_hardware_camera2_legacy_LegacyFocusStateMapper$afStateToString(int ), (int)n);
    }

    static {
        RobolectricInternals.classInitializing(LegacyFocusStateMapper.class);
    }

    public /* synthetic */ LegacyFocusStateMapper() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LegacyFocusStateMapper)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

