/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.legacy;

import android.graphics.Rect;
import android.hardware.Camera;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.legacy.LegacyMetadataMapper;
import android.hardware.camera2.legacy.LegacyRequest;
import android.hardware.camera2.legacy.ParameterUtils;
import android.hardware.camera2.params.MeteringRectangle;
import android.hardware.camera2.utils.ListUtils;
import android.hardware.camera2.utils.ParamsUtils;
import android.location.Location;
import android.util.Log;
import android.util.Range;
import android.util.Size;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class LegacyRequestMapper
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "LegacyRequestMapper";
    private static boolean DEBUG = false;
    private static byte DEFAULT_JPEG_QUALITY = 85;

    private void $$robo$$android_hardware_camera2_legacy_LegacyRequestMapper$__constructor__() {
    }

    private static final void $$robo$$android_hardware_camera2_legacy_LegacyRequestMapper$convertRequestMetadata(LegacyRequest legacyRequest) {
        int mode;
        Location location;
        int testPatternMode;
        Boolean awbLock;
        int compensation;
        Range<Integer> compensationRange;
        Range<Integer> aeFpsRange;
        Integer antiBandingMode;
        String legacyMode;
        int aberrationMode;
        CameraCharacteristics characteristics = legacyRequest.characteristics;
        CaptureRequest request = legacyRequest.captureRequest;
        Size previewSize = legacyRequest.previewSize;
        Camera.Parameters params = legacyRequest.parameters;
        Rect activeArray = characteristics.get(CameraCharacteristics.SENSOR_INFO_ACTIVE_ARRAY_SIZE);
        ParameterUtils.ZoomData zoomData = ParameterUtils.convertScalerCropRegion(activeArray, request.get(CaptureRequest.SCALER_CROP_REGION), previewSize, params);
        if (params.isZoomSupported()) {
            params.setZoom(zoomData.zoomIndex);
        }
        if ((aberrationMode = ParamsUtils.getOrDefault(request, CaptureRequest.COLOR_CORRECTION_ABERRATION_MODE, 1).intValue()) != 1 && aberrationMode != 2) {
            Log.w("LegacyRequestMapper", "convertRequestToMetadata - Ignoring unsupported colorCorrection.aberrationMode = " + aberrationMode);
        }
        if ((legacyMode = (antiBandingMode = request.get(CaptureRequest.CONTROL_AE_ANTIBANDING_MODE)) != null ? LegacyRequestMapper.convertAeAntiBandingModeToLegacy(antiBandingMode) : ListUtils.listSelectFirstFrom(params.getSupportedAntibanding(), new String[]{"auto", "off", "50hz", "60hz"})) != null) {
            params.setAntibanding(legacyMode);
        }
        MeteringRectangle[] aeRegions = request.get(CaptureRequest.CONTROL_AE_REGIONS);
        if (request.get(CaptureRequest.CONTROL_AWB_REGIONS) != null) {
            Log.w("LegacyRequestMapper", "convertRequestMetadata - control.awbRegions setting is not supported, ignoring value");
        }
        int maxNumMeteringAreas = params.getMaxNumMeteringAreas();
        List<Camera.Area> meteringAreaList = LegacyRequestMapper.convertMeteringRegionsToLegacy(activeArray, zoomData, aeRegions, maxNumMeteringAreas, "AE");
        if (maxNumMeteringAreas > 0) {
            params.setMeteringAreas(meteringAreaList);
        }
        MeteringRectangle[] afRegions = request.get(CaptureRequest.CONTROL_AF_REGIONS);
        int maxNumFocusAreas = params.getMaxNumFocusAreas();
        List<Camera.Area> focusAreaList = LegacyRequestMapper.convertMeteringRegionsToLegacy(activeArray, zoomData, afRegions, maxNumFocusAreas, "AF");
        if (maxNumFocusAreas > 0) {
            params.setFocusAreas(focusAreaList);
        }
        if ((aeFpsRange = request.get(CaptureRequest.CONTROL_AE_TARGET_FPS_RANGE)) != null) {
            int[] legacyFps = LegacyRequestMapper.convertAeFpsRangeToLegacy(aeFpsRange);
            int[] rangeToApply = null;
            for (int[] range : params.getSupportedPreviewFpsRange()) {
                int intRangeLow = (int)Math.floor((double)range[0] / 1000.0) * 1000;
                int intRangeHigh = (int)Math.ceil((double)range[1] / 1000.0) * 1000;
                if (legacyFps[0] != intRangeLow || legacyFps[1] != intRangeHigh) continue;
                rangeToApply = range;
                break;
            }
            if (rangeToApply != null) {
                params.setPreviewFpsRange((int)rangeToApply[0], (int)rangeToApply[1]);
            } else {
                Log.w("LegacyRequestMapper", "Unsupported FPS range set [" + legacyFps[0] + "," + legacyFps[1] + "]");
            }
        }
        if (!(compensationRange = characteristics.get(CameraCharacteristics.CONTROL_AE_COMPENSATION_RANGE)).contains(compensation = ParamsUtils.getOrDefault(request, CaptureRequest.CONTROL_AE_EXPOSURE_COMPENSATION, 0).intValue())) {
            Log.w("LegacyRequestMapper", "convertRequestMetadata - control.aeExposureCompensation is out of range, ignoring value");
            compensation = 0;
        }
        params.setExposureCompensation(compensation);
        Boolean aeLock = LegacyRequestMapper.getIfSupported(request, CaptureRequest.CONTROL_AE_LOCK, false, params.isAutoExposureLockSupported(), false);
        if (aeLock != null) {
            params.setAutoExposureLock(aeLock);
        }
        LegacyRequestMapper.mapAeAndFlashMode(request, params);
        int afMode = ParamsUtils.getOrDefault(request, CaptureRequest.CONTROL_AF_MODE, 0);
        String focusMode = LegacyMetadataMapper.convertAfModeToLegacy(afMode, params.getSupportedFocusModes());
        if (focusMode != null) {
            params.setFocusMode(focusMode);
        }
        Integer awbMode = LegacyRequestMapper.getIfSupported(request, CaptureRequest.CONTROL_AWB_MODE, 1, params.getSupportedWhiteBalance() != null, 1);
        String whiteBalanceMode = null;
        if (awbMode != null) {
            whiteBalanceMode = LegacyRequestMapper.convertAwbModeToLegacy(awbMode);
            params.setWhiteBalance(whiteBalanceMode);
        }
        if ((awbLock = LegacyRequestMapper.getIfSupported(request, CaptureRequest.CONTROL_AWB_LOCK, false, params.isAutoWhiteBalanceLockSupported(), false)) != null) {
            params.setAutoWhiteBalanceLock(awbLock);
        }
        int captureIntent = ParamsUtils.getOrDefault(request, CaptureRequest.CONTROL_CAPTURE_INTENT, 1);
        params.setRecordingHint((captureIntent = LegacyRequestMapper.filterSupportedCaptureIntent(captureIntent)) == 3 || captureIntent == 4);
        Integer stabMode = LegacyRequestMapper.getIfSupported(request, CaptureRequest.CONTROL_VIDEO_STABILIZATION_MODE, 0, params.isVideoStabilizationSupported(), 0);
        if (stabMode != null) {
            params.setVideoStabilization(stabMode == 1);
        }
        boolean infinityFocusSupported = ListUtils.listContains(params.getSupportedFocusModes(), "infinity");
        Float focusDistance = LegacyRequestMapper.getIfSupported(request, CaptureRequest.LENS_FOCUS_DISTANCE, Float.valueOf(0.0f), infinityFocusSupported, Float.valueOf(0.0f));
        if (focusDistance == null || focusDistance.floatValue() != 0.0f) {
            Log.w("LegacyRequestMapper", "convertRequestToMetadata - Ignoring android.lens.focusDistance " + infinityFocusSupported + ", only 0.0f is supported");
        }
        if (params.getSupportedSceneModes() != null) {
            String modeToSet;
            int controlMode = ParamsUtils.getOrDefault(request, CaptureRequest.CONTROL_MODE, 1);
            switch (controlMode) {
                case 2: {
                    int sceneMode = ParamsUtils.getOrDefault(request, CaptureRequest.CONTROL_SCENE_MODE, 0);
                    String legacySceneMode = LegacyMetadataMapper.convertSceneModeToLegacy(sceneMode);
                    if (legacySceneMode != null) {
                        modeToSet = legacySceneMode;
                        break;
                    }
                    modeToSet = "auto";
                    Log.w("LegacyRequestMapper", "Skipping unknown requested scene mode: " + sceneMode);
                    break;
                }
                case 1: {
                    modeToSet = "auto";
                    break;
                }
                default: {
                    Log.w("LegacyRequestMapper", "Control mode " + controlMode + " is unsupported, defaulting to AUTO");
                    modeToSet = "auto";
                }
            }
            params.setSceneMode(modeToSet);
        }
        if (params.getSupportedColorEffects() != null) {
            int effectMode = ParamsUtils.getOrDefault(request, CaptureRequest.CONTROL_EFFECT_MODE, 0);
            String legacyEffectMode = LegacyMetadataMapper.convertEffectModeToLegacy(effectMode);
            if (legacyEffectMode != null) {
                params.setColorEffect(legacyEffectMode);
            } else {
                params.setColorEffect("none");
                Log.w("LegacyRequestMapper", "Skipping unknown requested effect mode: " + effectMode);
            }
        }
        if ((testPatternMode = ParamsUtils.getOrDefault(request, CaptureRequest.SENSOR_TEST_PATTERN_MODE, 0).intValue()) != 0) {
            Log.w("LegacyRequestMapper", "convertRequestToMetadata - ignoring sensor.testPatternMode " + testPatternMode + "; only OFF is supported");
        }
        if ((location = request.get(CaptureRequest.JPEG_GPS_LOCATION)) != null) {
            if (LegacyRequestMapper.checkForCompleteGpsData(location)) {
                params.setGpsAltitude(location.getAltitude());
                params.setGpsLatitude(location.getLatitude());
                params.setGpsLongitude(location.getLongitude());
                params.setGpsProcessingMethod(location.getProvider().toUpperCase());
                params.setGpsTimestamp(location.getTime());
            } else {
                Log.w("LegacyRequestMapper", "Incomplete GPS parameters provided in location " + location);
            }
        } else {
            params.removeGpsData();
        }
        Integer orientation = request.get(CaptureRequest.JPEG_ORIENTATION);
        params.setRotation(ParamsUtils.getOrDefault(request, CaptureRequest.JPEG_ORIENTATION, orientation == null ? 0 : orientation));
        params.setJpegQuality(0xFF & ParamsUtils.getOrDefault(request, CaptureRequest.JPEG_QUALITY, (byte)85));
        params.setJpegThumbnailQuality(0xFF & ParamsUtils.getOrDefault(request, CaptureRequest.JPEG_THUMBNAIL_QUALITY, (byte)85));
        List<Camera.Size> sizes = params.getSupportedJpegThumbnailSizes();
        if (sizes != null && sizes.size() > 0) {
            boolean invalidSize;
            Size s = request.get(CaptureRequest.JPEG_THUMBNAIL_SIZE);
            boolean bl = s == null ? false : (invalidSize = !ParameterUtils.containsSize(sizes, s.getWidth(), s.getHeight()));
            if (invalidSize) {
                Log.w("LegacyRequestMapper", "Invalid JPEG thumbnail size set " + s + ", skipping thumbnail...");
            }
            if (s == null || invalidSize) {
                params.setJpegThumbnailSize(0, 0);
            } else {
                params.setJpegThumbnailSize(s.getWidth(), s.getHeight());
            }
        }
        if ((mode = ParamsUtils.getOrDefault(request, CaptureRequest.NOISE_REDUCTION_MODE, 1).intValue()) != 1 && mode != 2) {
            Log.w("LegacyRequestMapper", "convertRequestToMetadata - Ignoring unsupported noiseReduction.mode = " + mode);
        }
    }

    private static final boolean $$robo$$android_hardware_camera2_legacy_LegacyRequestMapper$checkForCompleteGpsData(Location location) {
        return location != null && location.getProvider() != null && location.getTime() != 0L;
    }

    private static final int $$robo$$android_hardware_camera2_legacy_LegacyRequestMapper$filterSupportedCaptureIntent(int captureIntent) {
        switch (captureIntent) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                captureIntent = 1;
                Log.w("LegacyRequestMapper", "Unsupported control.captureIntent value " + captureIntent + "; default to PREVIEW");
            }
            default: {
                captureIntent = 1;
                Log.w("LegacyRequestMapper", "Unknown control.captureIntent value " + captureIntent + "; default to PREVIEW");
            }
        }
        return captureIntent;
    }

    private static final List<Camera.Area> $$robo$$android_hardware_camera2_legacy_LegacyRequestMapper$convertMeteringRegionsToLegacy(Rect activeArray, ParameterUtils.ZoomData zoomData, MeteringRectangle[] meteringRegions, int maxNumMeteringAreas, String regionName) {
        if (meteringRegions == null || maxNumMeteringAreas <= 0) {
            if (maxNumMeteringAreas > 0) {
                return Arrays.asList(ParameterUtils.CAMERA_AREA_DEFAULT);
            }
            return null;
        }
        ArrayList<MeteringRectangle> meteringRectangleList = new ArrayList<MeteringRectangle>();
        for (MeteringRectangle rect : meteringRegions) {
            if (rect.getMeteringWeight() == 0) continue;
            meteringRectangleList.add(rect);
        }
        if (meteringRectangleList.size() == 0) {
            Log.w("LegacyRequestMapper", "Only received metering rectangles with weight 0.");
            return Arrays.asList(ParameterUtils.CAMERA_AREA_DEFAULT);
        }
        int countMeteringAreas = Math.min(maxNumMeteringAreas, meteringRectangleList.size());
        ArrayList<Camera.Area> meteringAreaList = new ArrayList<Camera.Area>(countMeteringAreas);
        for (int i = 0; i < countMeteringAreas; ++i) {
            MeteringRectangle rect;
            rect = (MeteringRectangle)meteringRectangleList.get(i);
            ParameterUtils.MeteringData meteringData = ParameterUtils.convertMeteringRectangleToLegacy(activeArray, rect, zoomData);
            meteringAreaList.add(meteringData.meteringArea);
        }
        if (maxNumMeteringAreas < meteringRectangleList.size()) {
            Log.w("LegacyRequestMapper", "convertMeteringRegionsToLegacy - Too many requested " + regionName + " regions, ignoring all beyond the first " + maxNumMeteringAreas);
        }
        return meteringAreaList;
    }

    private static final void $$robo$$android_hardware_camera2_legacy_LegacyRequestMapper$mapAeAndFlashMode(CaptureRequest r, Camera.Parameters p) {
        int flashMode = ParamsUtils.getOrDefault(r, CaptureRequest.FLASH_MODE, 0);
        int aeMode = ParamsUtils.getOrDefault(r, CaptureRequest.CONTROL_AE_MODE, 1);
        List<String> supportedFlashModes = p.getSupportedFlashModes();
        String flashModeSetting = null;
        if (ListUtils.listContains(supportedFlashModes, "off")) {
            flashModeSetting = "off";
        }
        if (aeMode == 1) {
            if (flashMode == 2) {
                if (ListUtils.listContains(supportedFlashModes, "torch")) {
                    flashModeSetting = "torch";
                } else {
                    Log.w("LegacyRequestMapper", "mapAeAndFlashMode - Ignore flash.mode == TORCH;camera does not support it");
                }
            } else if (flashMode == 1) {
                if (ListUtils.listContains(supportedFlashModes, "on")) {
                    flashModeSetting = "on";
                } else {
                    Log.w("LegacyRequestMapper", "mapAeAndFlashMode - Ignore flash.mode == SINGLE;camera does not support it");
                }
            }
        } else if (aeMode == 3) {
            if (ListUtils.listContains(supportedFlashModes, "on")) {
                flashModeSetting = "on";
            } else {
                Log.w("LegacyRequestMapper", "mapAeAndFlashMode - Ignore control.aeMode == ON_ALWAYS_FLASH;camera does not support it");
            }
        } else if (aeMode == 2) {
            if (ListUtils.listContains(supportedFlashModes, "auto")) {
                flashModeSetting = "auto";
            } else {
                Log.w("LegacyRequestMapper", "mapAeAndFlashMode - Ignore control.aeMode == ON_AUTO_FLASH;camera does not support it");
            }
        } else if (aeMode == 4) {
            if (ListUtils.listContains(supportedFlashModes, "red-eye")) {
                flashModeSetting = "red-eye";
            } else {
                Log.w("LegacyRequestMapper", "mapAeAndFlashMode - Ignore control.aeMode == ON_AUTO_FLASH_REDEYE;camera does not support it");
            }
        }
        if (flashModeSetting != null) {
            p.setFlashMode(flashModeSetting);
        }
    }

    private static final String $$robo$$android_hardware_camera2_legacy_LegacyRequestMapper$convertAeAntiBandingModeToLegacy(int mode) {
        switch (mode) {
            case 0: {
                return "off";
            }
            case 1: {
                return "50hz";
            }
            case 2: {
                return "60hz";
            }
            case 3: {
                return "auto";
            }
        }
        return null;
    }

    private static final int[] $$robo$$android_hardware_camera2_legacy_LegacyRequestMapper$convertAeFpsRangeToLegacy(Range<Integer> fpsRange) {
        int[] legacyFps = new int[]{fpsRange.getLower() * 1000, fpsRange.getUpper() * 1000};
        return legacyFps;
    }

    private static final String $$robo$$android_hardware_camera2_legacy_LegacyRequestMapper$convertAwbModeToLegacy(int mode) {
        switch (mode) {
            case 1: {
                return "auto";
            }
            case 2: {
                return "incandescent";
            }
            case 3: {
                return "fluorescent";
            }
            case 4: {
                return "warm-fluorescent";
            }
            case 5: {
                return "daylight";
            }
            case 6: {
                return "cloudy-daylight";
            }
            case 7: {
                return "twilight";
            }
            case 8: {
                return "shade";
            }
        }
        Log.w("LegacyRequestMapper", "convertAwbModeToLegacy - unrecognized control.awbMode" + mode);
        return "auto";
    }

    private static final <T> T $$robo$$android_hardware_camera2_legacy_LegacyRequestMapper$getIfSupported(CaptureRequest r, CaptureRequest.Key<T> key, T defaultValue, boolean isSupported, T allowedValue) {
        T val = ParamsUtils.getOrDefault(r, key, defaultValue);
        if (!isSupported) {
            if (!Objects.equals(val, allowedValue)) {
                Log.w("LegacyRequestMapper", key.getName() + " is not supported; ignoring requested value " + val);
            }
            return null;
        }
        return val;
    }

    private void __constructor__() {
        this.$$robo$$android_hardware_camera2_legacy_LegacyRequestMapper$__constructor__();
    }

    public LegacyRequestMapper() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_legacy_LegacyRequestMapper$__constructor__(), this);
    }

    public static void convertRequestMetadata(LegacyRequest legacyRequest) {
        InvokeDynamicSupport.bootstrapStatic("convertRequestMetadata", $$robo$$android_hardware_camera2_legacy_LegacyRequestMapper$convertRequestMetadata(android.hardware.camera2.legacy.LegacyRequest ), (LegacyRequest)legacyRequest);
    }

    private static boolean checkForCompleteGpsData(Location location) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("checkForCompleteGpsData", $$robo$$android_hardware_camera2_legacy_LegacyRequestMapper$checkForCompleteGpsData(android.location.Location ), (Location)location);
    }

    static int filterSupportedCaptureIntent(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("filterSupportedCaptureIntent", $$robo$$android_hardware_camera2_legacy_LegacyRequestMapper$filterSupportedCaptureIntent(int ), (int)n);
    }

    private static List<Camera.Area> convertMeteringRegionsToLegacy(Rect rect, ParameterUtils.ZoomData zoomData, MeteringRectangle[] meteringRectangleArray, int n, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("convertMeteringRegionsToLegacy", $$robo$$android_hardware_camera2_legacy_LegacyRequestMapper$convertMeteringRegionsToLegacy(android.graphics.Rect android.hardware.camera2.legacy.ParameterUtils$ZoomData android.hardware.camera2.params.MeteringRectangle[] int java.lang.String ), (Rect)rect, (ParameterUtils.ZoomData)zoomData, (MeteringRectangle[])meteringRectangleArray, (int)n, (String)string2);
    }

    private static void mapAeAndFlashMode(CaptureRequest captureRequest, Camera.Parameters parameters) {
        InvokeDynamicSupport.bootstrapStatic("mapAeAndFlashMode", $$robo$$android_hardware_camera2_legacy_LegacyRequestMapper$mapAeAndFlashMode(android.hardware.camera2.CaptureRequest android.hardware.Camera$Parameters ), (CaptureRequest)captureRequest, (Camera.Parameters)parameters);
    }

    private static String convertAeAntiBandingModeToLegacy(int n) {
        return InvokeDynamicSupport.bootstrapStatic("convertAeAntiBandingModeToLegacy", $$robo$$android_hardware_camera2_legacy_LegacyRequestMapper$convertAeAntiBandingModeToLegacy(int ), (int)n);
    }

    private static int[] convertAeFpsRangeToLegacy(Range<Integer> range) {
        return InvokeDynamicSupport.bootstrapStatic("convertAeFpsRangeToLegacy", $$robo$$android_hardware_camera2_legacy_LegacyRequestMapper$convertAeFpsRangeToLegacy(android.util.Range<java.lang.Integer> ), range);
    }

    private static String convertAwbModeToLegacy(int n) {
        return InvokeDynamicSupport.bootstrapStatic("convertAwbModeToLegacy", $$robo$$android_hardware_camera2_legacy_LegacyRequestMapper$convertAwbModeToLegacy(int ), (int)n);
    }

    private static <T> T getIfSupported(CaptureRequest captureRequest, CaptureRequest.Key<T> key, T t, boolean bl, T t2) {
        return (T)InvokeDynamicSupport.bootstrapStatic("getIfSupported", $$robo$$android_hardware_camera2_legacy_LegacyRequestMapper$getIfSupported(android.hardware.camera2.CaptureRequest android.hardware.camera2.CaptureRequest$Key<T> T boolean T ), (CaptureRequest)captureRequest, key, t, (boolean)bl, t2);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LegacyRequestMapper)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

