/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.params;

import android.graphics.Point;
import android.graphics.Rect;
import android.hardware.camera2.utils.HashCodeHelpers;
import android.util.Size;
import com.android.internal.util.Preconditions;
import com.google.errorprone.annotations.DoNotMock;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class MeteringRectangle
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    public static int METERING_WEIGHT_MIN = 0;
    public static int METERING_WEIGHT_MAX = 1000;
    public static int METERING_WEIGHT_DONT_CARE = 0;
    private int mX;
    private int mY;
    private int mWidth;
    private int mHeight;
    private int mWeight;

    private void $$robo$$android_hardware_camera2_params_MeteringRectangle$__constructor__(int x, int y, int width, int height, int meteringWeight) {
        this.mX = Preconditions.checkArgumentNonnegative(x, "x must be nonnegative");
        this.mY = Preconditions.checkArgumentNonnegative(y, "y must be nonnegative");
        this.mWidth = Preconditions.checkArgumentNonnegative(width, "width must be nonnegative");
        this.mHeight = Preconditions.checkArgumentNonnegative(height, "height must be nonnegative");
        this.mWeight = Preconditions.checkArgumentInRange(meteringWeight, 0, 1000, "meteringWeight");
    }

    private void $$robo$$android_hardware_camera2_params_MeteringRectangle$__constructor__(Point xy, Size dimensions, int meteringWeight) {
        Preconditions.checkNotNull(xy, "xy must not be null");
        Preconditions.checkNotNull(dimensions, "dimensions must not be null");
        this.mX = Preconditions.checkArgumentNonnegative(xy.x, "x must be nonnegative");
        this.mY = Preconditions.checkArgumentNonnegative(xy.y, "y must be nonnegative");
        this.mWidth = Preconditions.checkArgumentNonnegative(dimensions.getWidth(), "width must be nonnegative");
        this.mHeight = Preconditions.checkArgumentNonnegative(dimensions.getHeight(), "height must be nonnegative");
        this.mWeight = Preconditions.checkArgumentNonnegative(meteringWeight, "meteringWeight must be nonnegative");
    }

    private void $$robo$$android_hardware_camera2_params_MeteringRectangle$__constructor__(Rect rect, int meteringWeight) {
        Preconditions.checkNotNull(rect, "rect must not be null");
        this.mX = Preconditions.checkArgumentNonnegative(rect.left, "rect.left must be nonnegative");
        this.mY = Preconditions.checkArgumentNonnegative(rect.top, "rect.top must be nonnegative");
        this.mWidth = Preconditions.checkArgumentNonnegative(rect.width(), "rect.width must be nonnegative");
        this.mHeight = Preconditions.checkArgumentNonnegative(rect.height(), "rect.height must be nonnegative");
        this.mWeight = Preconditions.checkArgumentNonnegative(meteringWeight, "meteringWeight must be nonnegative");
    }

    private final int $$robo$$android_hardware_camera2_params_MeteringRectangle$getX() {
        return this.mX;
    }

    private final int $$robo$$android_hardware_camera2_params_MeteringRectangle$getY() {
        return this.mY;
    }

    private final int $$robo$$android_hardware_camera2_params_MeteringRectangle$getWidth() {
        return this.mWidth;
    }

    private final int $$robo$$android_hardware_camera2_params_MeteringRectangle$getHeight() {
        return this.mHeight;
    }

    private final int $$robo$$android_hardware_camera2_params_MeteringRectangle$getMeteringWeight() {
        return this.mWeight;
    }

    private final Point $$robo$$android_hardware_camera2_params_MeteringRectangle$getUpperLeftPoint() {
        return new Point(this.mX, this.mY);
    }

    private final Size $$robo$$android_hardware_camera2_params_MeteringRectangle$getSize() {
        return new Size(this.mWidth, this.mHeight);
    }

    private final Rect $$robo$$android_hardware_camera2_params_MeteringRectangle$getRect() {
        return new Rect(this.mX, this.mY, this.mX + this.mWidth, this.mY + this.mHeight);
    }

    private final boolean $$robo$$android_hardware_camera2_params_MeteringRectangle$equals(Object other) {
        return other instanceof MeteringRectangle && this.equals((MeteringRectangle)other);
    }

    private final boolean $$robo$$android_hardware_camera2_params_MeteringRectangle$equals(MeteringRectangle other) {
        if (other == null) {
            return false;
        }
        return this.mX == other.mX && this.mY == other.mY && this.mWidth == other.mWidth && this.mHeight == other.mHeight && this.mWeight == other.mWeight;
    }

    private final int $$robo$$android_hardware_camera2_params_MeteringRectangle$hashCode() {
        return HashCodeHelpers.hashCode(this.mX, this.mY, this.mWidth, this.mHeight, this.mWeight);
    }

    private final String $$robo$$android_hardware_camera2_params_MeteringRectangle$toString() {
        return String.format("(x:%d, y:%d, w:%d, h:%d, wt:%d)", this.mX, this.mY, this.mWidth, this.mHeight, this.mWeight);
    }

    private void __constructor__(int n, int n2, int n3, int n4, int n5) {
        this.$$robo$$android_hardware_camera2_params_MeteringRectangle$__constructor__(n, n2, n3, n4, n5);
    }

    public MeteringRectangle(int n, int n2, int n3, int n4, int n5) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_params_MeteringRectangle$__constructor__(int int int int int ), this, n, n2, n3, n4, n5);
    }

    private void __constructor__(Point point, Size size, int n) {
        this.$$robo$$android_hardware_camera2_params_MeteringRectangle$__constructor__(point, size, n);
    }

    public MeteringRectangle(Point point, Size size, int n) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_params_MeteringRectangle$__constructor__(android.graphics.Point android.util.Size int ), this, point, size, n);
    }

    private void __constructor__(Rect rect, int n) {
        this.$$robo$$android_hardware_camera2_params_MeteringRectangle$__constructor__(rect, n);
    }

    public MeteringRectangle(Rect rect, int n) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_params_MeteringRectangle$__constructor__(android.graphics.Rect int ), this, rect, n);
    }

    public int getX() {
        return (int)InvokeDynamicSupport.bootstrap("getX", $$robo$$android_hardware_camera2_params_MeteringRectangle$getX(), this);
    }

    public int getY() {
        return (int)InvokeDynamicSupport.bootstrap("getY", $$robo$$android_hardware_camera2_params_MeteringRectangle$getY(), this);
    }

    public int getWidth() {
        return (int)InvokeDynamicSupport.bootstrap("getWidth", $$robo$$android_hardware_camera2_params_MeteringRectangle$getWidth(), this);
    }

    public int getHeight() {
        return (int)InvokeDynamicSupport.bootstrap("getHeight", $$robo$$android_hardware_camera2_params_MeteringRectangle$getHeight(), this);
    }

    public int getMeteringWeight() {
        return (int)InvokeDynamicSupport.bootstrap("getMeteringWeight", $$robo$$android_hardware_camera2_params_MeteringRectangle$getMeteringWeight(), this);
    }

    public Point getUpperLeftPoint() {
        return InvokeDynamicSupport.bootstrap("getUpperLeftPoint", $$robo$$android_hardware_camera2_params_MeteringRectangle$getUpperLeftPoint(), this);
    }

    public Size getSize() {
        return InvokeDynamicSupport.bootstrap("getSize", $$robo$$android_hardware_camera2_params_MeteringRectangle$getSize(), this);
    }

    public Rect getRect() {
        return InvokeDynamicSupport.bootstrap("getRect", $$robo$$android_hardware_camera2_params_MeteringRectangle$getRect(), this);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_hardware_camera2_params_MeteringRectangle$equals(java.lang.Object ), this, object);
    }

    public boolean equals(MeteringRectangle meteringRectangle) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_hardware_camera2_params_MeteringRectangle$equals(android.hardware.camera2.params.MeteringRectangle ), this, meteringRectangle);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_hardware_camera2_params_MeteringRectangle$hashCode(), this);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_hardware_camera2_params_MeteringRectangle$toString(), this);
    }

    public /* synthetic */ MeteringRectangle() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MeteringRectangle)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

