/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.params;

import android.hardware.camera2.params.StreamConfigurationMap;
import android.hardware.camera2.utils.HashCodeHelpers;
import com.android.internal.util.Preconditions;
import com.google.errorprone.annotations.DoNotMock;
import java.util.Arrays;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class ReprocessFormatsMap
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private int[] mEntry;
    private int mInputCount;

    private void $$robo$$android_hardware_camera2_params_ReprocessFormatsMap$__constructor__(int[] entry) {
        Preconditions.checkNotNull(entry, "entry must not be null");
        int numInputs = 0;
        int left = entry.length;
        int i = 0;
        while (i < entry.length) {
            int inputFormat = StreamConfigurationMap.checkArgumentFormatInternal(entry[i]);
            ++i;
            if (--left < 1) {
                throw new IllegalArgumentException(String.format("Input %x had no output format length listed", inputFormat));
            }
            int length = entry[i];
            --left;
            ++i;
            for (int j = 0; j < length; ++j) {
                int outputFormat = entry[i + j];
                StreamConfigurationMap.checkArgumentFormatInternal(outputFormat);
            }
            if (length > 0) {
                if (left < length) {
                    throw new IllegalArgumentException(String.format("Input %x had too few output formats listed (actual: %d, expected: %d)", inputFormat, left, length));
                }
                i += length;
                left -= length;
            }
            ++numInputs;
        }
        this.mEntry = entry;
        this.mInputCount = numInputs;
    }

    private final int[] $$robo$$android_hardware_camera2_params_ReprocessFormatsMap$getInputs() {
        int[] inputs = new int[this.mInputCount];
        int left = this.mEntry.length;
        int i = 0;
        int j = 0;
        while (i < this.mEntry.length) {
            int format = this.mEntry[i];
            ++i;
            if (--left < 1) {
                throw new AssertionError((Object)String.format("Input %x had no output format length listed", format));
            }
            int length = this.mEntry[i];
            --left;
            ++i;
            if (length > 0) {
                if (left < length) {
                    throw new AssertionError((Object)String.format("Input %x had too few output formats listed (actual: %d, expected: %d)", format, left, length));
                }
                i += length;
                left -= length;
            }
            inputs[j] = format;
            ++j;
        }
        return StreamConfigurationMap.imageFormatToPublic(inputs);
    }

    private final int[] $$robo$$android_hardware_camera2_params_ReprocessFormatsMap$getOutputs(int format) {
        int left = this.mEntry.length;
        int i = 0;
        while (i < this.mEntry.length) {
            int inputFormat = this.mEntry[i];
            ++i;
            if (--left < 1) {
                throw new AssertionError((Object)String.format("Input %x had no output format length listed", format));
            }
            int length = this.mEntry[i];
            ++i;
            if (length > 0 && --left < length) {
                throw new AssertionError((Object)String.format("Input %x had too few output formats listed (actual: %d, expected: %d)", format, left, length));
            }
            if (inputFormat == format) {
                int[] outputs = new int[length];
                for (int k = 0; k < length; ++k) {
                    outputs[k] = this.mEntry[i + k];
                }
                return StreamConfigurationMap.imageFormatToPublic(outputs);
            }
            i += length;
            left -= length;
        }
        throw new IllegalArgumentException(String.format("Input format %x was not one in #getInputs", format));
    }

    private final boolean $$robo$$android_hardware_camera2_params_ReprocessFormatsMap$equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj instanceof ReprocessFormatsMap) {
            ReprocessFormatsMap other = (ReprocessFormatsMap)obj;
            return Arrays.equals(this.mEntry, other.mEntry);
        }
        return false;
    }

    private final int $$robo$$android_hardware_camera2_params_ReprocessFormatsMap$hashCode() {
        return HashCodeHelpers.hashCode(this.mEntry);
    }

    private void __constructor__(int[] nArray) {
        this.$$robo$$android_hardware_camera2_params_ReprocessFormatsMap$__constructor__(nArray);
    }

    public ReprocessFormatsMap(int[] nArray) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_params_ReprocessFormatsMap$__constructor__(int[] ), this, nArray);
    }

    public int[] getInputs() {
        return InvokeDynamicSupport.bootstrap("getInputs", $$robo$$android_hardware_camera2_params_ReprocessFormatsMap$getInputs(), this);
    }

    public int[] getOutputs(int n) {
        return InvokeDynamicSupport.bootstrap("getOutputs", $$robo$$android_hardware_camera2_params_ReprocessFormatsMap$getOutputs(int ), this, n);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_hardware_camera2_params_ReprocessFormatsMap$equals(java.lang.Object ), this, object);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_hardware_camera2_params_ReprocessFormatsMap$hashCode(), this);
    }

    public /* synthetic */ ReprocessFormatsMap() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ReprocessFormatsMap)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

