/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.display;

import android.hardware.display.WifiDisplay;
import android.hardware.display.WifiDisplaySessionInfo;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.errorprone.annotations.DoNotMock;
import java.util.Arrays;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class WifiDisplayStatus
implements Parcelable,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private int mFeatureState;
    private int mScanState;
    private int mActiveDisplayState;
    private WifiDisplay mActiveDisplay;
    private WifiDisplay[] mDisplays;
    private WifiDisplaySessionInfo mSessionInfo;
    public static int FEATURE_STATE_UNAVAILABLE = 0;
    public static int FEATURE_STATE_DISABLED = 1;
    public static int FEATURE_STATE_OFF = 2;
    public static int FEATURE_STATE_ON = 3;
    public static int SCAN_STATE_NOT_SCANNING = 0;
    public static int SCAN_STATE_SCANNING = 1;
    public static int DISPLAY_STATE_NOT_CONNECTED = 0;
    public static int DISPLAY_STATE_CONNECTING = 1;
    public static int DISPLAY_STATE_CONNECTED = 2;
    public static Parcelable.Creator<WifiDisplayStatus> CREATOR;

    private void $$robo$$android_hardware_display_WifiDisplayStatus$__constructor__() {
    }

    private void $$robo$$android_hardware_display_WifiDisplayStatus$__constructor__(int featureState, int scanState, int activeDisplayState, WifiDisplay activeDisplay, WifiDisplay[] displays, WifiDisplaySessionInfo sessionInfo) {
        if (displays == null) {
            throw new IllegalArgumentException("displays must not be null");
        }
        this.mFeatureState = featureState;
        this.mScanState = scanState;
        this.mActiveDisplayState = activeDisplayState;
        this.mActiveDisplay = activeDisplay;
        this.mDisplays = displays;
        this.mSessionInfo = sessionInfo != null ? sessionInfo : new WifiDisplaySessionInfo();
    }

    private final int $$robo$$android_hardware_display_WifiDisplayStatus$getFeatureState() {
        return this.mFeatureState;
    }

    private final int $$robo$$android_hardware_display_WifiDisplayStatus$getScanState() {
        return this.mScanState;
    }

    private final int $$robo$$android_hardware_display_WifiDisplayStatus$getActiveDisplayState() {
        return this.mActiveDisplayState;
    }

    private final WifiDisplay $$robo$$android_hardware_display_WifiDisplayStatus$getActiveDisplay() {
        return this.mActiveDisplay;
    }

    private final WifiDisplay[] $$robo$$android_hardware_display_WifiDisplayStatus$getDisplays() {
        return this.mDisplays;
    }

    private final WifiDisplaySessionInfo $$robo$$android_hardware_display_WifiDisplayStatus$getSessionInfo() {
        return this.mSessionInfo;
    }

    private final void $$robo$$android_hardware_display_WifiDisplayStatus$writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mFeatureState);
        dest.writeInt(this.mScanState);
        dest.writeInt(this.mActiveDisplayState);
        if (this.mActiveDisplay != null) {
            dest.writeInt(1);
            this.mActiveDisplay.writeToParcel(dest, flags);
        } else {
            dest.writeInt(0);
        }
        dest.writeInt(this.mDisplays.length);
        for (WifiDisplay display : this.mDisplays) {
            display.writeToParcel(dest, flags);
        }
        this.mSessionInfo.writeToParcel(dest, flags);
    }

    private final int $$robo$$android_hardware_display_WifiDisplayStatus$describeContents() {
        return 0;
    }

    private final String $$robo$$android_hardware_display_WifiDisplayStatus$toString() {
        return "WifiDisplayStatus{featureState=" + this.mFeatureState + ", scanState=" + this.mScanState + ", activeDisplayState=" + this.mActiveDisplayState + ", activeDisplay=" + this.mActiveDisplay + ", displays=" + Arrays.toString(this.mDisplays) + ", sessionInfo=" + this.mSessionInfo + "}";
    }

    static void __staticInitializer__() {
        CREATOR = new Parcelable.Creator<WifiDisplayStatus>(){
            public /* synthetic */ Object __robo_data__;

            private void $$robo$$android_hardware_display_WifiDisplayStatus_1$__constructor__() {
            }

            private final WifiDisplayStatus $$robo$$android_hardware_display_WifiDisplayStatus_1$createFromParcel(Parcel in) {
                int featureState = in.readInt();
                int scanState = in.readInt();
                int activeDisplayState = in.readInt();
                WifiDisplay activeDisplay = null;
                if (in.readInt() != 0) {
                    activeDisplay = WifiDisplay.CREATOR.createFromParcel(in);
                }
                WifiDisplay[] displays = WifiDisplay.CREATOR.newArray(in.readInt());
                for (int i = 0; i < displays.length; ++i) {
                    displays[i] = WifiDisplay.CREATOR.createFromParcel(in);
                }
                WifiDisplaySessionInfo sessionInfo = WifiDisplaySessionInfo.CREATOR.createFromParcel(in);
                return new WifiDisplayStatus(featureState, scanState, activeDisplayState, activeDisplay, displays, sessionInfo);
            }

            private final WifiDisplayStatus[] $$robo$$android_hardware_display_WifiDisplayStatus_1$newArray(int size) {
                return new WifiDisplayStatus[size];
            }

            private void __constructor__() {
                this.$$robo$$android_hardware_display_WifiDisplayStatus_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_display_WifiDisplayStatus_1$__constructor__(), this);
            }

            @Override
            public WifiDisplayStatus createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_hardware_display_WifiDisplayStatus_1$createFromParcel(android.os.Parcel ), this, parcel);
            }

            public WifiDisplayStatus[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_hardware_display_WifiDisplayStatus_1$newArray(int ), this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__() {
        this.$$robo$$android_hardware_display_WifiDisplayStatus$__constructor__();
    }

    public WifiDisplayStatus() {
        this(0, 0, 0, null, WifiDisplay.EMPTY_ARRAY, null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_display_WifiDisplayStatus$__constructor__(), this);
    }

    private void __constructor__(int n, int n2, int n3, WifiDisplay wifiDisplay, WifiDisplay[] wifiDisplayArray, WifiDisplaySessionInfo wifiDisplaySessionInfo) {
        this.$$robo$$android_hardware_display_WifiDisplayStatus$__constructor__(n, n2, n3, wifiDisplay, wifiDisplayArray, wifiDisplaySessionInfo);
    }

    public WifiDisplayStatus(int n, int n2, int n3, WifiDisplay wifiDisplay, WifiDisplay[] wifiDisplayArray, WifiDisplaySessionInfo wifiDisplaySessionInfo) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_display_WifiDisplayStatus$__constructor__(int int int android.hardware.display.WifiDisplay android.hardware.display.WifiDisplay[] android.hardware.display.WifiDisplaySessionInfo ), this, n, n2, n3, wifiDisplay, wifiDisplayArray, wifiDisplaySessionInfo);
    }

    public int getFeatureState() {
        return (int)InvokeDynamicSupport.bootstrap("getFeatureState", $$robo$$android_hardware_display_WifiDisplayStatus$getFeatureState(), this);
    }

    public int getScanState() {
        return (int)InvokeDynamicSupport.bootstrap("getScanState", $$robo$$android_hardware_display_WifiDisplayStatus$getScanState(), this);
    }

    public int getActiveDisplayState() {
        return (int)InvokeDynamicSupport.bootstrap("getActiveDisplayState", $$robo$$android_hardware_display_WifiDisplayStatus$getActiveDisplayState(), this);
    }

    public WifiDisplay getActiveDisplay() {
        return InvokeDynamicSupport.bootstrap("getActiveDisplay", $$robo$$android_hardware_display_WifiDisplayStatus$getActiveDisplay(), this);
    }

    public WifiDisplay[] getDisplays() {
        return InvokeDynamicSupport.bootstrap("getDisplays", $$robo$$android_hardware_display_WifiDisplayStatus$getDisplays(), this);
    }

    public WifiDisplaySessionInfo getSessionInfo() {
        return InvokeDynamicSupport.bootstrap("getSessionInfo", $$robo$$android_hardware_display_WifiDisplayStatus$getSessionInfo(), this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_hardware_display_WifiDisplayStatus$writeToParcel(android.os.Parcel int ), this, parcel, n);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_hardware_display_WifiDisplayStatus$describeContents(), this);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_hardware_display_WifiDisplayStatus$toString(), this);
    }

    static {
        RobolectricInternals.classInitializing(WifiDisplayStatus.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (WifiDisplayStatus)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

