/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.hdmi;

import android.hardware.hdmi.HdmiRecordSources;
import android.util.Log;
import com.google.errorprone.annotations.DoNotMock;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class HdmiTimerRecordSources
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "HdmiTimerRecordingSources";
    public static int RECORDING_SEQUENCE_REPEAT_ONCE_ONLY = 0;
    public static int RECORDING_SEQUENCE_REPEAT_SUNDAY = 1;
    public static int RECORDING_SEQUENCE_REPEAT_MONDAY = 2;
    public static int RECORDING_SEQUENCE_REPEAT_TUESDAY = 4;
    public static int RECORDING_SEQUENCE_REPEAT_WEDNESDAY = 8;
    public static int RECORDING_SEQUENCE_REPEAT_THURSDAY = 16;
    public static int RECORDING_SEQUENCE_REPEAT_FRIDAY = 32;
    public static int RECORDING_SEQUENCE_REPEAT_SATUREDAY = 64;
    private static int RECORDING_SEQUENCE_REPEAT_MASK = 127;
    private static int EXTERNAL_SOURCE_SPECIFIER_EXTERNAL_PLUG = 4;
    private static int EXTERNAL_SOURCE_SPECIFIER_EXTERNAL_PHYSICAL_ADDRESS = 5;

    private void $$robo$$android_hardware_hdmi_HdmiTimerRecordSources$__constructor__() {
    }

    private static final TimerRecordSource $$robo$$android_hardware_hdmi_HdmiTimerRecordSources$ofDigitalSource(TimerInfo timerInfo, HdmiRecordSources.DigitalServiceSource source) {
        HdmiTimerRecordSources.checkTimerRecordSourceInputs(timerInfo, source);
        return new TimerRecordSource(timerInfo, source, null);
    }

    private static final TimerRecordSource $$robo$$android_hardware_hdmi_HdmiTimerRecordSources$ofAnalogueSource(TimerInfo timerInfo, HdmiRecordSources.AnalogueServiceSource source) {
        HdmiTimerRecordSources.checkTimerRecordSourceInputs(timerInfo, source);
        return new TimerRecordSource(timerInfo, source, null);
    }

    private static final TimerRecordSource $$robo$$android_hardware_hdmi_HdmiTimerRecordSources$ofExternalPlug(TimerInfo timerInfo, HdmiRecordSources.ExternalPlugData source) {
        HdmiTimerRecordSources.checkTimerRecordSourceInputs(timerInfo, source);
        return new TimerRecordSource(timerInfo, new ExternalSourceDecorator(source, 4, null), null);
    }

    private static final TimerRecordSource $$robo$$android_hardware_hdmi_HdmiTimerRecordSources$ofExternalPhysicalAddress(TimerInfo timerInfo, HdmiRecordSources.ExternalPhysicalAddress source) {
        HdmiTimerRecordSources.checkTimerRecordSourceInputs(timerInfo, source);
        return new TimerRecordSource(timerInfo, new ExternalSourceDecorator(source, 5, null), null);
    }

    private static final void $$robo$$android_hardware_hdmi_HdmiTimerRecordSources$checkTimerRecordSourceInputs(TimerInfo timerInfo, HdmiRecordSources.RecordSource source) {
        if (timerInfo == null) {
            Log.w("HdmiTimerRecordingSources", "TimerInfo should not be null.");
            throw new IllegalArgumentException("TimerInfo should not be null.");
        }
        if (source == null) {
            Log.w("HdmiTimerRecordingSources", "source should not be null.");
            throw new IllegalArgumentException("source should not be null.");
        }
    }

    private static final Time $$robo$$android_hardware_hdmi_HdmiTimerRecordSources$timeOf(int hour, int minute) {
        HdmiTimerRecordSources.checkTimeValue(hour, minute);
        return new Time(hour, minute, null);
    }

    private static final void $$robo$$android_hardware_hdmi_HdmiTimerRecordSources$checkTimeValue(int hour, int minute) {
        if (hour < 0 || hour > 23) {
            throw new IllegalArgumentException("Hour should be in rage of [0, 23]:" + hour);
        }
        if (minute < 0 || minute > 59) {
            throw new IllegalArgumentException("Minute should be in rage of [0, 59]:" + minute);
        }
    }

    private static final Duration $$robo$$android_hardware_hdmi_HdmiTimerRecordSources$durationOf(int hour, int minute) {
        HdmiTimerRecordSources.checkDurationValue(hour, minute);
        return new Duration(hour, minute, null);
    }

    private static final void $$robo$$android_hardware_hdmi_HdmiTimerRecordSources$checkDurationValue(int hour, int minute) {
        if (hour < 0 || hour > 99) {
            throw new IllegalArgumentException("Hour should be in rage of [0, 99]:" + hour);
        }
        if (minute < 0 || minute > 59) {
            throw new IllegalArgumentException("minute should be in rage of [0, 59]:" + minute);
        }
    }

    private static final TimerInfo $$robo$$android_hardware_hdmi_HdmiTimerRecordSources$timerInfoOf(int dayOfMonth, int monthOfYear, Time startTime, Duration duration, int recordingSequence) {
        if (dayOfMonth < 0 || dayOfMonth > 31) {
            throw new IllegalArgumentException("Day of month should be in range of [0, 31]:" + dayOfMonth);
        }
        if (monthOfYear < 1 || monthOfYear > 12) {
            throw new IllegalArgumentException("Month of year should be in range of [1, 12]:" + monthOfYear);
        }
        HdmiTimerRecordSources.checkTimeValue(startTime.mHour, startTime.mMinute);
        HdmiTimerRecordSources.checkDurationValue(duration.mHour, duration.mMinute);
        if (recordingSequence != 0 && (recordingSequence & 0xFFFFFF80) != 0) {
            throw new IllegalArgumentException("Invalid reecording sequence value:" + recordingSequence);
        }
        return new TimerInfo(dayOfMonth, monthOfYear, startTime, duration, recordingSequence, null);
    }

    private static final boolean $$robo$$android_hardware_hdmi_HdmiTimerRecordSources$checkTimerRecordSource(int sourcetype, byte[] recordSource) {
        int recordSourceSize = recordSource.length - 7;
        switch (sourcetype) {
            case 1: {
                return 7 == recordSourceSize;
            }
            case 2: {
                return 4 == recordSourceSize;
            }
            case 3: {
                byte specifier = recordSource[7];
                if (specifier == 4) {
                    return 2 == recordSourceSize;
                }
                if (specifier == 5) {
                    return 3 == recordSourceSize;
                }
                return false;
            }
        }
        return false;
    }

    private void __constructor__() {
        this.$$robo$$android_hardware_hdmi_HdmiTimerRecordSources$__constructor__();
    }

    public HdmiTimerRecordSources() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_hdmi_HdmiTimerRecordSources$__constructor__(), this);
    }

    public static TimerRecordSource ofDigitalSource(TimerInfo timerInfo, HdmiRecordSources.DigitalServiceSource digitalServiceSource) {
        return InvokeDynamicSupport.bootstrapStatic("ofDigitalSource", $$robo$$android_hardware_hdmi_HdmiTimerRecordSources$ofDigitalSource(android.hardware.hdmi.HdmiTimerRecordSources$TimerInfo android.hardware.hdmi.HdmiRecordSources$DigitalServiceSource ), (TimerInfo)timerInfo, (HdmiRecordSources.DigitalServiceSource)digitalServiceSource);
    }

    public static TimerRecordSource ofAnalogueSource(TimerInfo timerInfo, HdmiRecordSources.AnalogueServiceSource analogueServiceSource) {
        return InvokeDynamicSupport.bootstrapStatic("ofAnalogueSource", $$robo$$android_hardware_hdmi_HdmiTimerRecordSources$ofAnalogueSource(android.hardware.hdmi.HdmiTimerRecordSources$TimerInfo android.hardware.hdmi.HdmiRecordSources$AnalogueServiceSource ), (TimerInfo)timerInfo, (HdmiRecordSources.AnalogueServiceSource)analogueServiceSource);
    }

    public static TimerRecordSource ofExternalPlug(TimerInfo timerInfo, HdmiRecordSources.ExternalPlugData externalPlugData) {
        return InvokeDynamicSupport.bootstrapStatic("ofExternalPlug", $$robo$$android_hardware_hdmi_HdmiTimerRecordSources$ofExternalPlug(android.hardware.hdmi.HdmiTimerRecordSources$TimerInfo android.hardware.hdmi.HdmiRecordSources$ExternalPlugData ), (TimerInfo)timerInfo, (HdmiRecordSources.ExternalPlugData)externalPlugData);
    }

    public static TimerRecordSource ofExternalPhysicalAddress(TimerInfo timerInfo, HdmiRecordSources.ExternalPhysicalAddress externalPhysicalAddress) {
        return InvokeDynamicSupport.bootstrapStatic("ofExternalPhysicalAddress", $$robo$$android_hardware_hdmi_HdmiTimerRecordSources$ofExternalPhysicalAddress(android.hardware.hdmi.HdmiTimerRecordSources$TimerInfo android.hardware.hdmi.HdmiRecordSources$ExternalPhysicalAddress ), (TimerInfo)timerInfo, (HdmiRecordSources.ExternalPhysicalAddress)externalPhysicalAddress);
    }

    private static void checkTimerRecordSourceInputs(TimerInfo timerInfo, HdmiRecordSources.RecordSource recordSource) {
        InvokeDynamicSupport.bootstrapStatic("checkTimerRecordSourceInputs", $$robo$$android_hardware_hdmi_HdmiTimerRecordSources$checkTimerRecordSourceInputs(android.hardware.hdmi.HdmiTimerRecordSources$TimerInfo android.hardware.hdmi.HdmiRecordSources$RecordSource ), (TimerInfo)timerInfo, (HdmiRecordSources.RecordSource)recordSource);
    }

    public static Time timeOf(int n, int n2) {
        return InvokeDynamicSupport.bootstrapStatic("timeOf", $$robo$$android_hardware_hdmi_HdmiTimerRecordSources$timeOf(int int ), (int)n, (int)n2);
    }

    private static void checkTimeValue(int n, int n2) {
        InvokeDynamicSupport.bootstrapStatic("checkTimeValue", $$robo$$android_hardware_hdmi_HdmiTimerRecordSources$checkTimeValue(int int ), (int)n, (int)n2);
    }

    public static Duration durationOf(int n, int n2) {
        return InvokeDynamicSupport.bootstrapStatic("durationOf", $$robo$$android_hardware_hdmi_HdmiTimerRecordSources$durationOf(int int ), (int)n, (int)n2);
    }

    private static void checkDurationValue(int n, int n2) {
        InvokeDynamicSupport.bootstrapStatic("checkDurationValue", $$robo$$android_hardware_hdmi_HdmiTimerRecordSources$checkDurationValue(int int ), (int)n, (int)n2);
    }

    public static TimerInfo timerInfoOf(int n, int n2, Time time, Duration duration, int n3) {
        return InvokeDynamicSupport.bootstrapStatic("timerInfoOf", $$robo$$android_hardware_hdmi_HdmiTimerRecordSources$timerInfoOf(int int android.hardware.hdmi.HdmiTimerRecordSources$Time android.hardware.hdmi.HdmiTimerRecordSources$Duration int ), (int)n, (int)n2, (Time)time, (Duration)duration, (int)n3);
    }

    public static boolean checkTimerRecordSource(int n, byte[] byArray) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("checkTimerRecordSource", $$robo$$android_hardware_hdmi_HdmiTimerRecordSources$checkTimerRecordSource(int byte[] ), (int)n, (byte[])byArray);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (HdmiTimerRecordSources)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class ExternalSourceDecorator
    extends HdmiRecordSources.RecordSource
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private HdmiRecordSources.RecordSource mRecordSource;
        private int mExternalSourceSpecifier;

        private void $$robo$$android_hardware_hdmi_HdmiTimerRecordSources_ExternalSourceDecorator$__constructor__(HdmiRecordSources.RecordSource recordSource, int externalSourceSpecifier) {
            this.mRecordSource = recordSource;
            this.mExternalSourceSpecifier = externalSourceSpecifier;
        }

        private final int $$robo$$android_hardware_hdmi_HdmiTimerRecordSources_ExternalSourceDecorator$extraParamToByteArray(byte[] data, int index) {
            data[index] = (byte)this.mExternalSourceSpecifier;
            this.mRecordSource.toByteArray(false, data, index + 1);
            return this.getDataSize(false);
        }

        private /* synthetic */ void $$robo$$android_hardware_hdmi_HdmiTimerRecordSources_ExternalSourceDecorator$__constructor__(HdmiRecordSources.RecordSource x0, int x1, 1 x2) {
        }

        private void __constructor__(HdmiRecordSources.RecordSource recordSource, int n) {
            this.$$robo$$android_hardware_hdmi_HdmiTimerRecordSources_ExternalSourceDecorator$__constructor__(recordSource, n);
        }

        public ExternalSourceDecorator(HdmiRecordSources.RecordSource recordSource, int n) {
            super(recordSource.mSourceType, recordSource.getDataSize(false) + 1);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_hdmi_HdmiTimerRecordSources_ExternalSourceDecorator$__constructor__(android.hardware.hdmi.HdmiRecordSources$RecordSource int ), this, recordSource, n);
        }

        @Override
        int extraParamToByteArray(byte[] byArray, int n) {
            return (int)InvokeDynamicSupport.bootstrap("extraParamToByteArray", $$robo$$android_hardware_hdmi_HdmiTimerRecordSources_ExternalSourceDecorator$extraParamToByteArray(byte[] int ), this, byArray, n);
        }

        private /* synthetic */ void __constructor__(HdmiRecordSources.RecordSource recordSource, int n, 1 var3_3) {
            this.$$robo$$android_hardware_hdmi_HdmiTimerRecordSources_ExternalSourceDecorator$__constructor__(recordSource, n, var3_3);
        }

        public /* synthetic */ ExternalSourceDecorator(HdmiRecordSources.RecordSource recordSource, int n, 1 var3_3) {
            this(recordSource, n);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_hdmi_HdmiTimerRecordSources_ExternalSourceDecorator$__constructor__(android.hardware.hdmi.HdmiRecordSources$RecordSource int android.hardware.hdmi.HdmiTimerRecordSources$1 ), this, recordSource, n, var3_3);
        }

        public /* synthetic */ ExternalSourceDecorator() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ExternalSourceDecorator)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class TimerRecordSource
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private HdmiRecordSources.RecordSource mRecordSource;
        private TimerInfo mTimerInfo;

        private void $$robo$$android_hardware_hdmi_HdmiTimerRecordSources_TimerRecordSource$__constructor__(TimerInfo timerInfo, HdmiRecordSources.RecordSource recordSource) {
            this.mTimerInfo = timerInfo;
            this.mRecordSource = recordSource;
        }

        private final int $$robo$$android_hardware_hdmi_HdmiTimerRecordSources_TimerRecordSource$getDataSize() {
            return this.mTimerInfo.getDataSize() + this.mRecordSource.getDataSize(false);
        }

        private final int $$robo$$android_hardware_hdmi_HdmiTimerRecordSources_TimerRecordSource$toByteArray(byte[] data, int index) {
            index += this.mTimerInfo.toByteArray(data, index);
            this.mRecordSource.toByteArray(false, data, index);
            return this.getDataSize();
        }

        private /* synthetic */ void $$robo$$android_hardware_hdmi_HdmiTimerRecordSources_TimerRecordSource$__constructor__(TimerInfo x0, HdmiRecordSources.RecordSource x1, 1 x2) {
        }

        private void __constructor__(TimerInfo timerInfo, HdmiRecordSources.RecordSource recordSource) {
            this.$$robo$$android_hardware_hdmi_HdmiTimerRecordSources_TimerRecordSource$__constructor__(timerInfo, recordSource);
        }

        public TimerRecordSource(TimerInfo timerInfo, HdmiRecordSources.RecordSource recordSource) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_hdmi_HdmiTimerRecordSources_TimerRecordSource$__constructor__(android.hardware.hdmi.HdmiTimerRecordSources$TimerInfo android.hardware.hdmi.HdmiRecordSources$RecordSource ), this, timerInfo, recordSource);
        }

        int getDataSize() {
            return (int)InvokeDynamicSupport.bootstrap("getDataSize", $$robo$$android_hardware_hdmi_HdmiTimerRecordSources_TimerRecordSource$getDataSize(), this);
        }

        int toByteArray(byte[] byArray, int n) {
            return (int)InvokeDynamicSupport.bootstrap("toByteArray", $$robo$$android_hardware_hdmi_HdmiTimerRecordSources_TimerRecordSource$toByteArray(byte[] int ), this, byArray, n);
        }

        private /* synthetic */ void __constructor__(TimerInfo timerInfo, HdmiRecordSources.RecordSource recordSource, 1 var3_3) {
            this.$$robo$$android_hardware_hdmi_HdmiTimerRecordSources_TimerRecordSource$__constructor__(timerInfo, recordSource, var3_3);
        }

        public /* synthetic */ TimerRecordSource(TimerInfo timerInfo, HdmiRecordSources.RecordSource recordSource, 1 var3_3) {
            this(timerInfo, recordSource);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_hdmi_HdmiTimerRecordSources_TimerRecordSource$__constructor__(android.hardware.hdmi.HdmiTimerRecordSources$TimerInfo android.hardware.hdmi.HdmiRecordSources$RecordSource android.hardware.hdmi.HdmiTimerRecordSources$1 ), this, timerInfo, recordSource, var3_3);
        }

        public /* synthetic */ TimerRecordSource() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TimerRecordSource)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class TimerInfo
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private static int DAY_OF_MONTH_SIZE = 1;
        private static int MONTH_OF_YEAR_SIZE = 1;
        private static int START_TIME_SIZE = 2;
        private static int DURATION_SIZE = 2;
        private static int RECORDING_SEQUENCE_SIZE = 1;
        private static int BASIC_INFO_SIZE = 7;
        private int mDayOfMonth;
        private int mMonthOfYear;
        private Time mStartTime;
        private Duration mDuration;
        private int mRecordingSequence;

        private void $$robo$$android_hardware_hdmi_HdmiTimerRecordSources_TimerInfo$__constructor__(int dayOfMonth, int monthOfYear, Time startTime, Duration duration, int recordingSequence) {
            this.mDayOfMonth = dayOfMonth;
            this.mMonthOfYear = monthOfYear;
            this.mStartTime = startTime;
            this.mDuration = duration;
            this.mRecordingSequence = recordingSequence;
        }

        private final int $$robo$$android_hardware_hdmi_HdmiTimerRecordSources_TimerInfo$toByteArray(byte[] data, int index) {
            data[index] = (byte)this.mDayOfMonth;
            data[++index] = (byte)this.mMonthOfYear;
            ++index;
            index += this.mStartTime.toByteArray(data, index);
            index += this.mDuration.toByteArray(data, index);
            data[index] = (byte)this.mRecordingSequence;
            return this.getDataSize();
        }

        private final int $$robo$$android_hardware_hdmi_HdmiTimerRecordSources_TimerInfo$getDataSize() {
            return 7;
        }

        private /* synthetic */ void $$robo$$android_hardware_hdmi_HdmiTimerRecordSources_TimerInfo$__constructor__(int x0, int x1, Time x2, Duration x3, int x4, 1 x5) {
        }

        private void __constructor__(int n, int n2, Time time, Duration duration, int n3) {
            this.$$robo$$android_hardware_hdmi_HdmiTimerRecordSources_TimerInfo$__constructor__(n, n2, time, duration, n3);
        }

        public TimerInfo(int n, int n2, Time time, Duration duration, int n3) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_hdmi_HdmiTimerRecordSources_TimerInfo$__constructor__(int int android.hardware.hdmi.HdmiTimerRecordSources$Time android.hardware.hdmi.HdmiTimerRecordSources$Duration int ), this, n, n2, time, duration, n3);
        }

        int toByteArray(byte[] byArray, int n) {
            return (int)InvokeDynamicSupport.bootstrap("toByteArray", $$robo$$android_hardware_hdmi_HdmiTimerRecordSources_TimerInfo$toByteArray(byte[] int ), this, byArray, n);
        }

        int getDataSize() {
            return (int)InvokeDynamicSupport.bootstrap("getDataSize", $$robo$$android_hardware_hdmi_HdmiTimerRecordSources_TimerInfo$getDataSize(), this);
        }

        private /* synthetic */ void __constructor__(int n, int n2, Time time, Duration duration, int n3, 1 var6_6) {
            this.$$robo$$android_hardware_hdmi_HdmiTimerRecordSources_TimerInfo$__constructor__(n, n2, time, duration, n3, var6_6);
        }

        public /* synthetic */ TimerInfo(int n, int n2, Time time, Duration duration, int n3, 1 var6_6) {
            this(n, n2, time, duration, n3);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_hdmi_HdmiTimerRecordSources_TimerInfo$__constructor__(int int android.hardware.hdmi.HdmiTimerRecordSources$Time android.hardware.hdmi.HdmiTimerRecordSources$Duration int android.hardware.hdmi.HdmiTimerRecordSources$1 ), this, n, n2, time, duration, n3, var6_6);
        }

        public /* synthetic */ TimerInfo() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TimerInfo)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class Duration
    extends TimeUnit
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;

        private void $$robo$$android_hardware_hdmi_HdmiTimerRecordSources_Duration$__constructor__(int hour, int minute) {
        }

        private /* synthetic */ void $$robo$$android_hardware_hdmi_HdmiTimerRecordSources_Duration$__constructor__(int x0, int x1, 1 x2) {
        }

        private void __constructor__(int n, int n2) {
            this.$$robo$$android_hardware_hdmi_HdmiTimerRecordSources_Duration$__constructor__(n, n2);
        }

        public Duration(int n, int n2) {
            super(n, n2);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_hdmi_HdmiTimerRecordSources_Duration$__constructor__(int int ), this, n, n2);
        }

        private /* synthetic */ void __constructor__(int n, int n2, 1 var3_3) {
            this.$$robo$$android_hardware_hdmi_HdmiTimerRecordSources_Duration$__constructor__(n, n2, var3_3);
        }

        public /* synthetic */ Duration(int n, int n2, 1 var3_3) {
            this(n, n2);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_hdmi_HdmiTimerRecordSources_Duration$__constructor__(int int android.hardware.hdmi.HdmiTimerRecordSources$1 ), this, n, n2, var3_3);
        }

        public /* synthetic */ Duration() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Duration)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class Time
    extends TimeUnit
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;

        private void $$robo$$android_hardware_hdmi_HdmiTimerRecordSources_Time$__constructor__(int hour, int minute) {
        }

        private /* synthetic */ void $$robo$$android_hardware_hdmi_HdmiTimerRecordSources_Time$__constructor__(int x0, int x1, 1 x2) {
        }

        private void __constructor__(int n, int n2) {
            this.$$robo$$android_hardware_hdmi_HdmiTimerRecordSources_Time$__constructor__(n, n2);
        }

        public Time(int n, int n2) {
            super(n, n2);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_hdmi_HdmiTimerRecordSources_Time$__constructor__(int int ), this, n, n2);
        }

        private /* synthetic */ void __constructor__(int n, int n2, 1 var3_3) {
            this.$$robo$$android_hardware_hdmi_HdmiTimerRecordSources_Time$__constructor__(n, n2, var3_3);
        }

        public /* synthetic */ Time(int n, int n2, 1 var3_3) {
            this(n, n2);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_hdmi_HdmiTimerRecordSources_Time$__constructor__(int int android.hardware.hdmi.HdmiTimerRecordSources$1 ), this, n, n2, var3_3);
        }

        public /* synthetic */ Time() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Time)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class TimeUnit
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        int mHour;
        int mMinute;

        private void $$robo$$android_hardware_hdmi_HdmiTimerRecordSources_TimeUnit$__constructor__(int hour, int minute) {
            this.mHour = hour;
            this.mMinute = minute;
        }

        private final int $$robo$$android_hardware_hdmi_HdmiTimerRecordSources_TimeUnit$toByteArray(byte[] data, int index) {
            data[index] = TimeUnit.toBcdByte(this.mHour);
            data[index + 1] = TimeUnit.toBcdByte(this.mMinute);
            return 2;
        }

        private static final byte $$robo$$android_hardware_hdmi_HdmiTimerRecordSources_TimeUnit$toBcdByte(int value) {
            int digitOfTen = value / 10 % 10;
            int digitOfOne = value % 10;
            return (byte)(digitOfTen << 4 | digitOfOne);
        }

        private void __constructor__(int n, int n2) {
            this.$$robo$$android_hardware_hdmi_HdmiTimerRecordSources_TimeUnit$__constructor__(n, n2);
        }

        public TimeUnit(int n, int n2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_hdmi_HdmiTimerRecordSources_TimeUnit$__constructor__(int int ), this, n, n2);
        }

        int toByteArray(byte[] byArray, int n) {
            return (int)InvokeDynamicSupport.bootstrap("toByteArray", $$robo$$android_hardware_hdmi_HdmiTimerRecordSources_TimeUnit$toByteArray(byte[] int ), this, byArray, n);
        }

        static byte toBcdByte(int n) {
            return (byte)InvokeDynamicSupport.bootstrapStatic("toBcdByte", $$robo$$android_hardware_hdmi_HdmiTimerRecordSources_TimeUnit$toBcdByte(int ), (int)n);
        }

        public /* synthetic */ TimeUnit() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TimeUnit)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

