/*
 * Decompiled with CFR 0.152.
 */
package android.icu.impl;

import android.icu.impl.ICUResourceBundle;
import android.icu.impl.SimpleCache;
import android.icu.lang.UCharacter;
import android.icu.math.BigDecimal;
import android.icu.text.NumberFormat;
import android.icu.util.ULocale;
import android.icu.util.UResourceBundle;
import com.google.errorprone.annotations.DoNotMock;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.math.BigInteger;
import java.text.FieldPosition;
import java.text.ParsePosition;
import java.util.Arrays;
import java.util.MissingResourceException;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class DateNumberFormat
extends NumberFormat
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static long serialVersionUID = -6315692826916346953L;
    private char[] digits;
    private char zeroDigit;
    private char minusSign;
    private boolean positiveOnly;
    private static int DECIMAL_BUF_SIZE = 20;
    private transient char[] decimalBuf;
    private static SimpleCache<ULocale, char[]> CACHE;
    private int maxIntDigits;
    private int minIntDigits;
    private static long PARSE_THRESHOLD = 0xCCCCCCCCCCCCCCBL;

    private void $$robo$$android_icu_impl_DateNumberFormat$__constructor__(ULocale loc, String digitString, String nsName) {
        this.positiveOnly = false;
        this.decimalBuf = new char[20];
        this.initialize(loc, digitString, nsName);
    }

    private void $$robo$$android_icu_impl_DateNumberFormat$__constructor__(ULocale loc, char zeroDigit, String nsName) {
        this.positiveOnly = false;
        this.decimalBuf = new char[20];
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < 10; ++i) {
            buf.append((char)(zeroDigit + i));
        }
        this.initialize(loc, buf.toString(), nsName);
    }

    private final void $$robo$$android_icu_impl_DateNumberFormat$initialize(ULocale loc, String digitString, String nsName) {
        char[] elems = CACHE.get(loc);
        if (elems == null) {
            String minusString;
            ICUResourceBundle rb = (ICUResourceBundle)UResourceBundle.getBundleInstance("android/icu/impl/data/icudt58b", loc);
            try {
                minusString = rb.getStringWithFallback("NumberElements/" + nsName + "/symbols/minusSign");
            }
            catch (MissingResourceException ex) {
                if (!nsName.equals("latn")) {
                    try {
                        minusString = rb.getStringWithFallback("NumberElements/latn/symbols/minusSign");
                    }
                    catch (MissingResourceException ex1) {
                        minusString = "-";
                    }
                }
                minusString = "-";
            }
            elems = new char[11];
            for (int i = 0; i < 10; ++i) {
                elems[i] = digitString.charAt(i);
            }
            elems[10] = minusString.charAt(0);
            CACHE.put(loc, elems);
        }
        this.digits = new char[10];
        InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (char[])elems, (int)0, (char[])this.digits, (int)0, (int)10);
        this.zeroDigit = this.digits[0];
        this.minusSign = elems[10];
    }

    private final void $$robo$$android_icu_impl_DateNumberFormat$setMaximumIntegerDigits(int newValue) {
        this.maxIntDigits = newValue;
    }

    private final int $$robo$$android_icu_impl_DateNumberFormat$getMaximumIntegerDigits() {
        return this.maxIntDigits;
    }

    private final void $$robo$$android_icu_impl_DateNumberFormat$setMinimumIntegerDigits(int newValue) {
        this.minIntDigits = newValue;
    }

    private final int $$robo$$android_icu_impl_DateNumberFormat$getMinimumIntegerDigits() {
        return this.minIntDigits;
    }

    private final void $$robo$$android_icu_impl_DateNumberFormat$setParsePositiveOnly(boolean isPositiveOnly) {
        this.positiveOnly = isPositiveOnly;
    }

    private final char $$robo$$android_icu_impl_DateNumberFormat$getZeroDigit() {
        return this.zeroDigit;
    }

    private final void $$robo$$android_icu_impl_DateNumberFormat$setZeroDigit(char zero) {
        this.zeroDigit = zero;
        if (this.digits == null) {
            this.digits = new char[10];
        }
        this.digits[0] = zero;
        for (int i = 1; i < 10; ++i) {
            this.digits[i] = (char)(zero + i);
        }
    }

    private final char[] $$robo$$android_icu_impl_DateNumberFormat$getDigits() {
        return (char[])this.digits.clone();
    }

    private final StringBuffer $$robo$$android_icu_impl_DateNumberFormat$format(double number, StringBuffer toAppendTo, FieldPosition pos) {
        throw new UnsupportedOperationException("StringBuffer format(double, StringBuffer, FieldPostion) is not implemented");
    }

    private final StringBuffer $$robo$$android_icu_impl_DateNumberFormat$format(long numberL, StringBuffer toAppendTo, FieldPosition pos) {
        if (numberL < 0L) {
            toAppendTo.append(this.minusSign);
            numberL = -numberL;
        }
        int number = (int)numberL;
        int limit = this.decimalBuf.length < this.maxIntDigits ? this.decimalBuf.length : this.maxIntDigits;
        int index = limit - 1;
        while (true) {
            this.decimalBuf[index] = this.digits[number % 10];
            if (index == 0 || (number /= 10) == 0) break;
            --index;
        }
        for (int padding = this.minIntDigits - (limit - index); padding > 0; --padding) {
            this.decimalBuf[--index] = this.digits[0];
        }
        int length = limit - index;
        toAppendTo.append(this.decimalBuf, index, length);
        pos.setBeginIndex(0);
        if (pos.getField() == 0) {
            pos.setEndIndex(length);
        } else {
            pos.setEndIndex(0);
        }
        return toAppendTo;
    }

    private final StringBuffer $$robo$$android_icu_impl_DateNumberFormat$format(BigInteger number, StringBuffer toAppendTo, FieldPosition pos) {
        throw new UnsupportedOperationException("StringBuffer format(BigInteger, StringBuffer, FieldPostion) is not implemented");
    }

    private final StringBuffer $$robo$$android_icu_impl_DateNumberFormat$format(java.math.BigDecimal number, StringBuffer toAppendTo, FieldPosition pos) {
        throw new UnsupportedOperationException("StringBuffer format(BigDecimal, StringBuffer, FieldPostion) is not implemented");
    }

    private final StringBuffer $$robo$$android_icu_impl_DateNumberFormat$format(BigDecimal number, StringBuffer toAppendTo, FieldPosition pos) {
        throw new UnsupportedOperationException("StringBuffer format(BigDecimal, StringBuffer, FieldPostion) is not implemented");
    }

    private final Number $$robo$$android_icu_impl_DateNumberFormat$parse(String text, ParsePosition parsePosition) {
        long num = 0L;
        boolean sawNumber = false;
        boolean negative = false;
        int base = parsePosition.getIndex();
        int offset = 0;
        while (base + offset < text.length()) {
            char ch = text.charAt(base + offset);
            if (offset == 0 && ch == this.minusSign) {
                if (this.positiveOnly) break;
                negative = true;
            } else {
                int digit = ch - this.digits[0];
                if (digit < 0 || 9 < digit) {
                    digit = UCharacter.digit(ch);
                }
                if (digit < 0 || 9 < digit) {
                    for (digit = 0; digit < 10 && ch != this.digits[digit]; ++digit) {
                    }
                }
                if (0 > digit || digit > 9 || num >= 0xCCCCCCCCCCCCCCBL) break;
                sawNumber = true;
                num = num * 10L + (long)digit;
            }
            ++offset;
        }
        Long result = null;
        if (sawNumber) {
            num = negative ? num * -1L : num;
            result = num;
            parsePosition.setIndex(base + offset);
        }
        return result;
    }

    private final boolean $$robo$$android_icu_impl_DateNumberFormat$equals(Object obj) {
        if (obj == null || !super.equals(obj) || !(obj instanceof DateNumberFormat)) {
            return false;
        }
        DateNumberFormat other = (DateNumberFormat)obj;
        return this.maxIntDigits == other.maxIntDigits && this.minIntDigits == other.minIntDigits && this.minusSign == other.minusSign && this.positiveOnly == other.positiveOnly && Arrays.equals(this.digits, other.digits);
    }

    private final int $$robo$$android_icu_impl_DateNumberFormat$hashCode() {
        return super.hashCode();
    }

    private final void $$robo$$android_icu_impl_DateNumberFormat$readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        if (this.digits == null) {
            this.setZeroDigit(this.zeroDigit);
        }
        this.decimalBuf = new char[20];
    }

    private final Object $$robo$$android_icu_impl_DateNumberFormat$clone() {
        DateNumberFormat dnfmt = (DateNumberFormat)super.clone();
        dnfmt.digits = (char[])this.digits.clone();
        dnfmt.decimalBuf = new char[20];
        return dnfmt;
    }

    static void __staticInitializer__() {
        CACHE = new SimpleCache();
    }

    private void __constructor__(ULocale uLocale, String string2, String string3) {
        this.$$robo$$android_icu_impl_DateNumberFormat$__constructor__(uLocale, string2, string3);
    }

    public DateNumberFormat(ULocale uLocale, String string2, String string3) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_DateNumberFormat$__constructor__(android.icu.util.ULocale java.lang.String java.lang.String ), this, uLocale, string2, string3);
    }

    private void __constructor__(ULocale uLocale, char c, String string2) {
        this.$$robo$$android_icu_impl_DateNumberFormat$__constructor__(uLocale, c, string2);
    }

    public DateNumberFormat(ULocale uLocale, char c, String string2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_DateNumberFormat$__constructor__(android.icu.util.ULocale char java.lang.String ), this, uLocale, c, string2);
    }

    private void initialize(ULocale uLocale, String string2, String string3) {
        InvokeDynamicSupport.bootstrap("initialize", $$robo$$android_icu_impl_DateNumberFormat$initialize(android.icu.util.ULocale java.lang.String java.lang.String ), this, uLocale, string2, string3);
    }

    @Override
    public void setMaximumIntegerDigits(int n) {
        InvokeDynamicSupport.bootstrap("setMaximumIntegerDigits", $$robo$$android_icu_impl_DateNumberFormat$setMaximumIntegerDigits(int ), this, n);
    }

    @Override
    public int getMaximumIntegerDigits() {
        return (int)InvokeDynamicSupport.bootstrap("getMaximumIntegerDigits", $$robo$$android_icu_impl_DateNumberFormat$getMaximumIntegerDigits(), this);
    }

    @Override
    public void setMinimumIntegerDigits(int n) {
        InvokeDynamicSupport.bootstrap("setMinimumIntegerDigits", $$robo$$android_icu_impl_DateNumberFormat$setMinimumIntegerDigits(int ), this, n);
    }

    @Override
    public int getMinimumIntegerDigits() {
        return (int)InvokeDynamicSupport.bootstrap("getMinimumIntegerDigits", $$robo$$android_icu_impl_DateNumberFormat$getMinimumIntegerDigits(), this);
    }

    public void setParsePositiveOnly(boolean bl) {
        InvokeDynamicSupport.bootstrap("setParsePositiveOnly", $$robo$$android_icu_impl_DateNumberFormat$setParsePositiveOnly(boolean ), this, bl);
    }

    public char getZeroDigit() {
        return (char)InvokeDynamicSupport.bootstrap("getZeroDigit", $$robo$$android_icu_impl_DateNumberFormat$getZeroDigit(), this);
    }

    public void setZeroDigit(char c) {
        InvokeDynamicSupport.bootstrap("setZeroDigit", $$robo$$android_icu_impl_DateNumberFormat$setZeroDigit(char ), this, c);
    }

    public char[] getDigits() {
        return InvokeDynamicSupport.bootstrap("getDigits", $$robo$$android_icu_impl_DateNumberFormat$getDigits(), this);
    }

    @Override
    public StringBuffer format(double d, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        return InvokeDynamicSupport.bootstrap("format", $$robo$$android_icu_impl_DateNumberFormat$format(double java.lang.StringBuffer java.text.FieldPosition ), this, d, stringBuffer, fieldPosition);
    }

    @Override
    public StringBuffer format(long l, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        return InvokeDynamicSupport.bootstrap("format", $$robo$$android_icu_impl_DateNumberFormat$format(long java.lang.StringBuffer java.text.FieldPosition ), this, l, stringBuffer, fieldPosition);
    }

    @Override
    public StringBuffer format(BigInteger bigInteger, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        return InvokeDynamicSupport.bootstrap("format", $$robo$$android_icu_impl_DateNumberFormat$format(java.math.BigInteger java.lang.StringBuffer java.text.FieldPosition ), this, bigInteger, stringBuffer, fieldPosition);
    }

    @Override
    public StringBuffer format(java.math.BigDecimal bigDecimal, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        return InvokeDynamicSupport.bootstrap("format", $$robo$$android_icu_impl_DateNumberFormat$format(java.math.BigDecimal java.lang.StringBuffer java.text.FieldPosition ), this, bigDecimal, stringBuffer, fieldPosition);
    }

    @Override
    public StringBuffer format(BigDecimal bigDecimal, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        return InvokeDynamicSupport.bootstrap("format", $$robo$$android_icu_impl_DateNumberFormat$format(android.icu.math.BigDecimal java.lang.StringBuffer java.text.FieldPosition ), this, bigDecimal, stringBuffer, fieldPosition);
    }

    @Override
    public Number parse(String string2, ParsePosition parsePosition) {
        return InvokeDynamicSupport.bootstrap("parse", $$robo$$android_icu_impl_DateNumberFormat$parse(java.lang.String java.text.ParsePosition ), this, string2, parsePosition);
    }

    @Override
    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_icu_impl_DateNumberFormat$equals(java.lang.Object ), this, object);
    }

    @Override
    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_icu_impl_DateNumberFormat$hashCode(), this);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        InvokeDynamicSupport.bootstrap("readObject", $$robo$$android_icu_impl_DateNumberFormat$readObject(java.io.ObjectInputStream ), this, objectInputStream);
    }

    @Override
    public Object clone() {
        return InvokeDynamicSupport.bootstrap("clone", $$robo$$android_icu_impl_DateNumberFormat$clone(), this);
    }

    static {
        RobolectricInternals.classInitializing(DateNumberFormat.class);
    }

    public /* synthetic */ DateNumberFormat() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DateNumberFormat)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

