/*
 * Decompiled with CFR 0.152.
 */
package android.icu.impl;

import android.icu.impl.ICUBinary;
import android.icu.impl.Trie;
import android.icu.text.UTF16;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class IntTrie
extends Trie
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private int m_initialValue_;
    private int[] m_data_;
    static /* synthetic */ boolean $assertionsDisabled;

    private void $$robo$$android_icu_impl_IntTrie$__constructor__(ByteBuffer bytes, Trie.DataManipulate dataManipulate) throws IOException {
        if (!this.isIntTrie()) {
            throw new IllegalArgumentException("Data given does not belong to a int trie.");
        }
    }

    private void $$robo$$android_icu_impl_IntTrie$__constructor__(int initialValue, int leadUnitValue, Trie.DataManipulate dataManipulate) {
        int i;
        int latin1Length = 256;
        int dataLength = 256;
        if (leadUnitValue != initialValue) {
            dataLength += 32;
        }
        this.m_data_ = new int[dataLength];
        this.m_dataLength_ = dataLength;
        this.m_initialValue_ = initialValue;
        for (i = 0; i < latin1Length; ++i) {
            this.m_data_[i] = initialValue;
        }
        if (leadUnitValue != initialValue) {
            char block = (char)(latin1Length >> 2);
            int limit = 1760;
            for (i = 1728; i < limit; ++i) {
                this.m_index_[i] = block;
            }
            limit = latin1Length + 32;
            for (i = latin1Length; i < limit; ++i) {
                this.m_data_[i] = leadUnitValue;
            }
        }
    }

    private final int $$robo$$android_icu_impl_IntTrie$getCodePointValue(int ch) {
        if (0 <= ch && ch < 55296) {
            int offset = (this.m_index_[ch >> 5] << 2) + (ch & 0x1F);
            return this.m_data_[offset];
        }
        int offset = this.getCodePointOffset(ch);
        return offset >= 0 ? this.m_data_[offset] : this.m_initialValue_;
    }

    private final int $$robo$$android_icu_impl_IntTrie$getLeadValue(char ch) {
        return this.m_data_[this.getLeadOffset(ch)];
    }

    private final int $$robo$$android_icu_impl_IntTrie$getBMPValue(char ch) {
        return this.m_data_[this.getBMPOffset(ch)];
    }

    private final int $$robo$$android_icu_impl_IntTrie$getSurrogateValue(char lead, char trail) {
        if (!UTF16.isLeadSurrogate(lead) || !UTF16.isTrailSurrogate(trail)) {
            throw new IllegalArgumentException("Argument characters do not form a supplementary character");
        }
        int offset = this.getSurrogateOffset(lead, trail);
        if (offset > 0) {
            return this.m_data_[offset];
        }
        return this.m_initialValue_;
    }

    private final int $$robo$$android_icu_impl_IntTrie$getTrailValue(int leadvalue, char trail) {
        if (this.m_dataManipulate_ == null) {
            throw new NullPointerException("The field DataManipulate in this Trie is null");
        }
        int offset = this.m_dataManipulate_.getFoldingOffset(leadvalue);
        if (offset > 0) {
            return this.m_data_[this.getRawOffset(offset, (char)(trail & 0x3FF))];
        }
        return this.m_initialValue_;
    }

    private final int $$robo$$android_icu_impl_IntTrie$getLatin1LinearValue(char ch) {
        return this.m_data_[32 + ch];
    }

    private final boolean $$robo$$android_icu_impl_IntTrie$equals(Object other) {
        boolean result = super.equals(other);
        if (result && other instanceof IntTrie) {
            IntTrie othertrie = (IntTrie)other;
            return this.m_initialValue_ == othertrie.m_initialValue_ && Arrays.equals(this.m_data_, othertrie.m_data_);
        }
        return false;
    }

    private final int $$robo$$android_icu_impl_IntTrie$hashCode() {
        if (!$assertionsDisabled) {
            throw new AssertionError((Object)"hashCode not designed");
        }
        return 42;
    }

    private final void $$robo$$android_icu_impl_IntTrie$unserialize(ByteBuffer bytes) {
        super.unserialize(bytes);
        this.m_data_ = ICUBinary.getInts(bytes, this.m_dataLength_, 0);
        this.m_initialValue_ = this.m_data_[0];
    }

    private final int $$robo$$android_icu_impl_IntTrie$getSurrogateOffset(char lead, char trail) {
        if (this.m_dataManipulate_ == null) {
            throw new NullPointerException("The field DataManipulate in this Trie is null");
        }
        int offset = this.m_dataManipulate_.getFoldingOffset(this.getLeadValue(lead));
        if (offset > 0) {
            return this.getRawOffset(offset, (char)(trail & 0x3FF));
        }
        return -1;
    }

    private final int $$robo$$android_icu_impl_IntTrie$getValue(int index) {
        return this.m_data_[index];
    }

    private final int $$robo$$android_icu_impl_IntTrie$getInitialValue() {
        return this.m_initialValue_;
    }

    private void $$robo$$android_icu_impl_IntTrie$__constructor__(char[] index, int[] data, int initialvalue, int options, Trie.DataManipulate datamanipulate) {
        this.m_data_ = data;
        this.m_dataLength_ = this.m_data_.length;
        this.m_initialValue_ = initialvalue;
    }

    static void __staticInitializer__() {
        $assertionsDisabled = !IntTrie.class.desiredAssertionStatus();
    }

    private void __constructor__(ByteBuffer byteBuffer, Trie.DataManipulate dataManipulate) throws IOException {
        this.$$robo$$android_icu_impl_IntTrie$__constructor__(byteBuffer, dataManipulate);
    }

    public IntTrie(ByteBuffer byteBuffer, Trie.DataManipulate dataManipulate) throws IOException {
        super(byteBuffer, dataManipulate);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_IntTrie$__constructor__(java.nio.ByteBuffer android.icu.impl.Trie$DataManipulate ), this, byteBuffer, dataManipulate);
    }

    private void __constructor__(int n, int n2, Trie.DataManipulate dataManipulate) {
        this.$$robo$$android_icu_impl_IntTrie$__constructor__(n, n2, dataManipulate);
    }

    public IntTrie(int n, int n2, Trie.DataManipulate dataManipulate) {
        super(new char[2080], 512, dataManipulate);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_IntTrie$__constructor__(int int android.icu.impl.Trie$DataManipulate ), this, n, n2, dataManipulate);
    }

    public int getCodePointValue(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getCodePointValue", $$robo$$android_icu_impl_IntTrie$getCodePointValue(int ), this, n);
    }

    public int getLeadValue(char c) {
        return (int)InvokeDynamicSupport.bootstrap("getLeadValue", $$robo$$android_icu_impl_IntTrie$getLeadValue(char ), this, c);
    }

    public int getBMPValue(char c) {
        return (int)InvokeDynamicSupport.bootstrap("getBMPValue", $$robo$$android_icu_impl_IntTrie$getBMPValue(char ), this, c);
    }

    public int getSurrogateValue(char c, char c2) {
        return (int)InvokeDynamicSupport.bootstrap("getSurrogateValue", $$robo$$android_icu_impl_IntTrie$getSurrogateValue(char char ), this, c, c2);
    }

    public int getTrailValue(int n, char c) {
        return (int)InvokeDynamicSupport.bootstrap("getTrailValue", $$robo$$android_icu_impl_IntTrie$getTrailValue(int char ), this, n, c);
    }

    public int getLatin1LinearValue(char c) {
        return (int)InvokeDynamicSupport.bootstrap("getLatin1LinearValue", $$robo$$android_icu_impl_IntTrie$getLatin1LinearValue(char ), this, c);
    }

    @Override
    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_icu_impl_IntTrie$equals(java.lang.Object ), this, object);
    }

    @Override
    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_icu_impl_IntTrie$hashCode(), this);
    }

    @Override
    protected void unserialize(ByteBuffer byteBuffer) {
        InvokeDynamicSupport.bootstrap("unserialize", $$robo$$android_icu_impl_IntTrie$unserialize(java.nio.ByteBuffer ), this, byteBuffer);
    }

    @Override
    protected int getSurrogateOffset(char c, char c2) {
        return (int)InvokeDynamicSupport.bootstrap("getSurrogateOffset", $$robo$$android_icu_impl_IntTrie$getSurrogateOffset(char char ), this, c, c2);
    }

    @Override
    protected int getValue(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getValue", $$robo$$android_icu_impl_IntTrie$getValue(int ), this, n);
    }

    @Override
    protected int getInitialValue() {
        return (int)InvokeDynamicSupport.bootstrap("getInitialValue", $$robo$$android_icu_impl_IntTrie$getInitialValue(), this);
    }

    private void __constructor__(char[] cArray, int[] nArray, int n, int n2, Trie.DataManipulate dataManipulate) {
        this.$$robo$$android_icu_impl_IntTrie$__constructor__(cArray, nArray, n, n2, dataManipulate);
    }

    public IntTrie(char[] cArray, int[] nArray, int n, int n2, Trie.DataManipulate dataManipulate) {
        super(cArray, n2, dataManipulate);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_IntTrie$__constructor__(char[] int[] int int android.icu.impl.Trie$DataManipulate ), this, cArray, nArray, n, n2, dataManipulate);
    }

    static {
        RobolectricInternals.classInitializing(IntTrie.class);
    }

    public /* synthetic */ IntTrie() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (IntTrie)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

