/*
 * Decompiled with CFR 0.152.
 */
package android.icu.impl;

import android.icu.impl.CurrencyData;
import android.icu.impl.ICUResourceBundle;
import android.icu.impl.ICUResourceTableAccess;
import android.icu.impl.SimpleFormatterImpl;
import android.icu.impl.UResource;
import android.icu.impl.locale.AsciiUtil;
import android.icu.lang.UCharacter;
import android.icu.lang.UScript;
import android.icu.text.BreakIterator;
import android.icu.text.DisplayContext;
import android.icu.text.LocaleDisplayNames;
import android.icu.util.ULocale;
import android.icu.util.UResourceBundle;
import com.google.errorprone.annotations.DoNotMock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class LocaleDisplayNamesImpl
extends LocaleDisplayNames
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private ULocale locale;
    private LocaleDisplayNames.DialectHandling dialectHandling;
    private DisplayContext capitalization;
    private DisplayContext nameLength;
    private DisplayContext substituteHandling;
    private DataTable langData;
    private DataTable regionData;
    private String separatorFormat;
    private String format;
    private String keyTypeFormat;
    private char formatOpenParen;
    private char formatReplaceOpenParen;
    private char formatCloseParen;
    private char formatReplaceCloseParen;
    private CurrencyData.CurrencyDisplayInfo currencyDisplayInfo;
    private static Cache cache;
    private boolean[] capitalizationUsage;
    private static Map<String, CapitalizationContextUsage> contextUsageTypeMap;
    private transient BreakIterator capitalizationBrkIter;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final LocaleDisplayNames $$robo$$android_icu_impl_LocaleDisplayNamesImpl$getInstance(ULocale locale, LocaleDisplayNames.DialectHandling dialectHandling) {
        Cache cache = LocaleDisplayNamesImpl.cache;
        synchronized (cache) {
            return LocaleDisplayNamesImpl.cache.get(locale, dialectHandling);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final LocaleDisplayNames $$robo$$android_icu_impl_LocaleDisplayNamesImpl$getInstance(ULocale locale, DisplayContext ... contexts) {
        Cache cache = LocaleDisplayNamesImpl.cache;
        synchronized (cache) {
            return LocaleDisplayNamesImpl.cache.get(locale, contexts);
        }
    }

    private void $$robo$$android_icu_impl_LocaleDisplayNamesImpl$__constructor__(ULocale locale, LocaleDisplayNames.DialectHandling dialectHandling) {
    }

    private void $$robo$$android_icu_impl_LocaleDisplayNamesImpl$__constructor__(ULocale locale, DisplayContext ... contexts) {
        this.capitalizationUsage = null;
        this.capitalizationBrkIter = null;
        LocaleDisplayNames.DialectHandling dialectHandling = LocaleDisplayNames.DialectHandling.STANDARD_NAMES;
        DisplayContext capitalization = DisplayContext.CAPITALIZATION_NONE;
        DisplayContext nameLength = DisplayContext.LENGTH_FULL;
        DisplayContext substituteHandling = DisplayContext.SUBSTITUTE;
        block8: for (DisplayContext contextItem : contexts) {
            switch (1.$SwitchMap$android$icu$text$DisplayContext$Type[contextItem.type().ordinal()]) {
                case 1: {
                    dialectHandling = contextItem.value() == DisplayContext.STANDARD_NAMES.value() ? LocaleDisplayNames.DialectHandling.STANDARD_NAMES : LocaleDisplayNames.DialectHandling.DIALECT_NAMES;
                    continue block8;
                }
                case 2: {
                    capitalization = contextItem;
                    continue block8;
                }
                case 3: {
                    nameLength = contextItem;
                    continue block8;
                }
                case 4: {
                    substituteHandling = contextItem;
                    continue block8;
                }
            }
        }
        this.dialectHandling = dialectHandling;
        this.capitalization = capitalization;
        this.nameLength = nameLength;
        this.substituteHandling = substituteHandling;
        this.langData = LangDataTables.impl.get(locale, substituteHandling == DisplayContext.NO_SUBSTITUTE);
        this.regionData = RegionDataTables.impl.get(locale, substituteHandling == DisplayContext.NO_SUBSTITUTE);
        this.locale = ULocale.ROOT.equals(this.langData.getLocale()) ? this.regionData.getLocale() : this.langData.getLocale();
        String sep = this.langData.get("localeDisplayPattern", "separator");
        if (sep == null || "separator".equals(sep)) {
            sep = "{0}, {1}";
        }
        StringBuilder sb = new StringBuilder();
        this.separatorFormat = SimpleFormatterImpl.compileToStringMinMaxArguments(sep, sb, 2, 2);
        String pattern = this.langData.get("localeDisplayPattern", "pattern");
        if (pattern == null || "pattern".equals(pattern)) {
            pattern = "{0} ({1})";
        }
        this.format = SimpleFormatterImpl.compileToStringMinMaxArguments(pattern, sb, 2, 2);
        if (pattern.contains("\uff08")) {
            this.formatOpenParen = (char)65288;
            this.formatCloseParen = (char)65289;
            this.formatReplaceOpenParen = (char)65339;
            this.formatReplaceCloseParen = (char)65341;
        } else {
            this.formatOpenParen = (char)40;
            this.formatCloseParen = (char)41;
            this.formatReplaceOpenParen = (char)91;
            this.formatReplaceCloseParen = (char)93;
        }
        String keyTypePattern = this.langData.get("localeDisplayPattern", "keyTypePattern");
        if (keyTypePattern == null || "keyTypePattern".equals(keyTypePattern)) {
            keyTypePattern = "{0}={1}";
        }
        this.keyTypeFormat = SimpleFormatterImpl.compileToStringMinMaxArguments(keyTypePattern, sb, 2, 2);
        boolean needBrkIter = false;
        if (capitalization == DisplayContext.CAPITALIZATION_FOR_UI_LIST_OR_MENU || capitalization == DisplayContext.CAPITALIZATION_FOR_STANDALONE) {
            this.capitalizationUsage = new boolean[CapitalizationContextUsage.values().length];
            ICUResourceBundle rb = (ICUResourceBundle)UResourceBundle.getBundleInstance("android/icu/impl/data/icudt58b", locale);
            CapitalizationContextSink sink = new CapitalizationContextSink(this, null);
            try {
                rb.getAllItemsWithFallback("contextTransforms", sink);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            needBrkIter = sink.hasCapitalizationUsage;
        }
        if (needBrkIter || capitalization == DisplayContext.CAPITALIZATION_FOR_BEGINNING_OF_SENTENCE) {
            this.capitalizationBrkIter = BreakIterator.getSentenceInstance(locale);
        }
        this.currencyDisplayInfo = CurrencyData.provider.getInstance(locale, false);
    }

    private final ULocale $$robo$$android_icu_impl_LocaleDisplayNamesImpl$getLocale() {
        return this.locale;
    }

    private final LocaleDisplayNames.DialectHandling $$robo$$android_icu_impl_LocaleDisplayNamesImpl$getDialectHandling() {
        return this.dialectHandling;
    }

    private final DisplayContext $$robo$$android_icu_impl_LocaleDisplayNamesImpl$getContext(DisplayContext.Type type) {
        DisplayContext result;
        switch (1.$SwitchMap$android$icu$text$DisplayContext$Type[type.ordinal()]) {
            case 1: {
                result = this.dialectHandling == LocaleDisplayNames.DialectHandling.STANDARD_NAMES ? DisplayContext.STANDARD_NAMES : DisplayContext.DIALECT_NAMES;
                break;
            }
            case 2: {
                result = this.capitalization;
                break;
            }
            case 3: {
                result = this.nameLength;
                break;
            }
            case 4: {
                result = this.substituteHandling;
                break;
            }
            default: {
                result = DisplayContext.STANDARD_NAMES;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String $$robo$$android_icu_impl_LocaleDisplayNamesImpl$adjustForUsageAndContext(CapitalizationContextUsage usage, String name) {
        if (name != null && name.length() > 0 && UCharacter.isLowerCase(name.codePointAt(0)) && (this.capitalization == DisplayContext.CAPITALIZATION_FOR_BEGINNING_OF_SENTENCE || this.capitalizationUsage != null && this.capitalizationUsage[usage.ordinal()])) {
            LocaleDisplayNamesImpl localeDisplayNamesImpl = this;
            synchronized (localeDisplayNamesImpl) {
                if (this.capitalizationBrkIter == null) {
                    this.capitalizationBrkIter = BreakIterator.getSentenceInstance(this.locale);
                }
                return UCharacter.toTitleCase(this.locale, name, this.capitalizationBrkIter, 768);
            }
        }
        return name;
    }

    private final String $$robo$$android_icu_impl_LocaleDisplayNamesImpl$localeDisplayName(ULocale locale) {
        return this.localeDisplayNameInternal(locale);
    }

    private final String $$robo$$android_icu_impl_LocaleDisplayNamesImpl$localeDisplayName(Locale locale) {
        return this.localeDisplayNameInternal(ULocale.forLocale(locale));
    }

    private final String $$robo$$android_icu_impl_LocaleDisplayNamesImpl$localeDisplayName(String localeId) {
        return this.localeDisplayNameInternal(new ULocale(localeId));
    }

    private final String $$robo$$android_icu_impl_LocaleDisplayNamesImpl$localeDisplayNameInternal(ULocale locale) {
        Iterator<String> keys;
        String result;
        boolean hasVariant;
        String resultName = null;
        String lang = locale.getLanguage();
        if (locale.getBaseName().length() == 0) {
            lang = "root";
        }
        String script = locale.getScript();
        String country = locale.getCountry();
        String variant = locale.getVariant();
        boolean hasScript = script.length() > 0;
        boolean hasCountry = country.length() > 0;
        boolean bl = hasVariant = variant.length() > 0;
        if (this.dialectHandling == LocaleDisplayNames.DialectHandling.DIALECT_NAMES) {
            String langCountry;
            String langScript;
            String langScriptCountry;
            if (hasScript && hasCountry && (result = this.localeIdName(langScriptCountry = lang + '_' + script + '_' + country)) != null && !result.equals(langScriptCountry)) {
                resultName = result;
                hasScript = false;
                hasCountry = false;
            } else if (hasScript && (result = this.localeIdName(langScript = lang + '_' + script)) != null && !result.equals(langScript)) {
                resultName = result;
                hasScript = false;
            } else if (hasCountry && (result = this.localeIdName(langCountry = lang + '_' + country)) != null && !result.equals(langCountry)) {
                resultName = result;
                hasCountry = false;
            }
        }
        if (resultName == null) {
            String result2 = this.localeIdName(lang);
            if (result2 == null) {
                return null;
            }
            resultName = result2.replace(this.formatOpenParen, this.formatReplaceOpenParen).replace(this.formatCloseParen, this.formatReplaceCloseParen);
        }
        StringBuilder buf = new StringBuilder();
        if (hasScript) {
            result = this.scriptDisplayNameInContext(script, true);
            if (result == null) {
                return null;
            }
            buf.append(result.replace(this.formatOpenParen, this.formatReplaceOpenParen).replace(this.formatCloseParen, this.formatReplaceCloseParen));
        }
        if (hasCountry) {
            result = this.regionDisplayName(country, true);
            if (result == null) {
                return null;
            }
            this.appendWithSep(result.replace(this.formatOpenParen, this.formatReplaceOpenParen).replace(this.formatCloseParen, this.formatReplaceCloseParen), buf);
        }
        if (hasVariant) {
            result = this.variantDisplayName(variant, true);
            if (result == null) {
                return null;
            }
            this.appendWithSep(result.replace(this.formatOpenParen, this.formatReplaceOpenParen).replace(this.formatCloseParen, this.formatReplaceCloseParen), buf);
        }
        if ((keys = locale.getKeywords()) != null) {
            while (keys.hasNext()) {
                String key = keys.next();
                String value = locale.getKeywordValue(key);
                String keyDisplayName = this.keyDisplayName(key, true);
                if (keyDisplayName == null) {
                    return null;
                }
                keyDisplayName = keyDisplayName.replace(this.formatOpenParen, this.formatReplaceOpenParen).replace(this.formatCloseParen, this.formatReplaceCloseParen);
                String valueDisplayName = this.keyValueDisplayName(key, value, true);
                if (valueDisplayName == null) {
                    return null;
                }
                if (!(valueDisplayName = valueDisplayName.replace(this.formatOpenParen, this.formatReplaceOpenParen).replace(this.formatCloseParen, this.formatReplaceCloseParen)).equals(value)) {
                    this.appendWithSep(valueDisplayName, buf);
                    continue;
                }
                if (!key.equals(keyDisplayName)) {
                    String keyValue = SimpleFormatterImpl.formatCompiledPattern(this.keyTypeFormat, keyDisplayName, valueDisplayName);
                    this.appendWithSep(keyValue, buf);
                    continue;
                }
                this.appendWithSep(keyDisplayName, buf).append("=").append(valueDisplayName);
            }
        }
        String resultRemainder = null;
        if (buf.length() > 0) {
            resultRemainder = buf.toString();
        }
        if (resultRemainder != null) {
            resultName = SimpleFormatterImpl.formatCompiledPattern(this.format, resultName, resultRemainder);
        }
        return this.adjustForUsageAndContext(CapitalizationContextUsage.LANGUAGE, resultName);
    }

    private final String $$robo$$android_icu_impl_LocaleDisplayNamesImpl$localeIdName(String localeId) {
        String locIdName;
        if (this.nameLength == DisplayContext.LENGTH_SHORT && (locIdName = this.langData.get("Languages%short", localeId)) != null && !locIdName.equals(localeId)) {
            return locIdName;
        }
        return this.langData.get("Languages", localeId);
    }

    private final String $$robo$$android_icu_impl_LocaleDisplayNamesImpl$languageDisplayName(String lang) {
        String langName;
        if (lang.equals("root") || lang.indexOf(95) != -1) {
            return this.substituteHandling == DisplayContext.SUBSTITUTE ? lang : null;
        }
        if (this.nameLength == DisplayContext.LENGTH_SHORT && (langName = this.langData.get("Languages%short", lang)) != null && !langName.equals(lang)) {
            return this.adjustForUsageAndContext(CapitalizationContextUsage.LANGUAGE, langName);
        }
        return this.adjustForUsageAndContext(CapitalizationContextUsage.LANGUAGE, this.langData.get("Languages", lang));
    }

    private final String $$robo$$android_icu_impl_LocaleDisplayNamesImpl$scriptDisplayName(String script) {
        String str = this.langData.get("Scripts%stand-alone", script);
        if (str == null || str.equals(script)) {
            if (this.nameLength == DisplayContext.LENGTH_SHORT && (str = this.langData.get("Scripts%short", script)) != null && !str.equals(script)) {
                return this.adjustForUsageAndContext(CapitalizationContextUsage.SCRIPT, str);
            }
            str = this.langData.get("Scripts", script);
        }
        return this.adjustForUsageAndContext(CapitalizationContextUsage.SCRIPT, str);
    }

    private final String $$robo$$android_icu_impl_LocaleDisplayNamesImpl$scriptDisplayNameInContext(String script, boolean skipAdjust) {
        String scriptName;
        if (this.nameLength == DisplayContext.LENGTH_SHORT && (scriptName = this.langData.get("Scripts%short", script)) != null && !scriptName.equals(script)) {
            return skipAdjust ? scriptName : this.adjustForUsageAndContext(CapitalizationContextUsage.SCRIPT, scriptName);
        }
        scriptName = this.langData.get("Scripts", script);
        return skipAdjust ? scriptName : this.adjustForUsageAndContext(CapitalizationContextUsage.SCRIPT, scriptName);
    }

    private final String $$robo$$android_icu_impl_LocaleDisplayNamesImpl$scriptDisplayNameInContext(String script) {
        return this.scriptDisplayNameInContext(script, false);
    }

    private final String $$robo$$android_icu_impl_LocaleDisplayNamesImpl$scriptDisplayName(int scriptCode) {
        return this.scriptDisplayName(UScript.getShortName(scriptCode));
    }

    private final String $$robo$$android_icu_impl_LocaleDisplayNamesImpl$regionDisplayName(String region, boolean skipAdjust) {
        String regionName;
        if (this.nameLength == DisplayContext.LENGTH_SHORT && (regionName = this.regionData.get("Countries%short", region)) != null && !regionName.equals(region)) {
            return skipAdjust ? regionName : this.adjustForUsageAndContext(CapitalizationContextUsage.TERRITORY, regionName);
        }
        regionName = this.regionData.get("Countries", region);
        return skipAdjust ? regionName : this.adjustForUsageAndContext(CapitalizationContextUsage.TERRITORY, regionName);
    }

    private final String $$robo$$android_icu_impl_LocaleDisplayNamesImpl$regionDisplayName(String region) {
        return this.regionDisplayName(region, false);
    }

    private final String $$robo$$android_icu_impl_LocaleDisplayNamesImpl$variantDisplayName(String variant, boolean skipAdjust) {
        String variantName = this.langData.get("Variants", variant);
        return skipAdjust ? variantName : this.adjustForUsageAndContext(CapitalizationContextUsage.VARIANT, variantName);
    }

    private final String $$robo$$android_icu_impl_LocaleDisplayNamesImpl$variantDisplayName(String variant) {
        return this.variantDisplayName(variant, false);
    }

    private final String $$robo$$android_icu_impl_LocaleDisplayNamesImpl$keyDisplayName(String key, boolean skipAdjust) {
        String keyName = this.langData.get("Keys", key);
        return skipAdjust ? keyName : this.adjustForUsageAndContext(CapitalizationContextUsage.KEY, keyName);
    }

    private final String $$robo$$android_icu_impl_LocaleDisplayNamesImpl$keyDisplayName(String key) {
        return this.keyDisplayName(key, false);
    }

    private final String $$robo$$android_icu_impl_LocaleDisplayNamesImpl$keyValueDisplayName(String key, String value, boolean skipAdjust) {
        String keyValueName = null;
        if (key.equals("currency")) {
            keyValueName = this.currencyDisplayInfo.getName(AsciiUtil.toUpperString(value));
            if (keyValueName == null) {
                keyValueName = value;
            }
        } else {
            String tmp;
            if (this.nameLength == DisplayContext.LENGTH_SHORT && (tmp = this.langData.get("Types%short", key, value)) != null && !tmp.equals(value)) {
                keyValueName = tmp;
            }
            if (keyValueName == null) {
                keyValueName = this.langData.get("Types", key, value);
            }
        }
        return skipAdjust ? keyValueName : this.adjustForUsageAndContext(CapitalizationContextUsage.KEYVALUE, keyValueName);
    }

    private final String $$robo$$android_icu_impl_LocaleDisplayNamesImpl$keyValueDisplayName(String key, String value) {
        return this.keyValueDisplayName(key, value, false);
    }

    private final List<LocaleDisplayNames.UiListItem> $$robo$$android_icu_impl_LocaleDisplayNamesImpl$getUiListCompareWholeItems(Set<ULocale> localeSet, Comparator<LocaleDisplayNames.UiListItem> comparator) {
        DisplayContext capContext = this.getContext(DisplayContext.Type.CAPITALIZATION);
        ArrayList<LocaleDisplayNames.UiListItem> result = new ArrayList<LocaleDisplayNames.UiListItem>();
        HashMap<ULocale, HashSet<ULocale>> baseToLocales = new HashMap<ULocale, HashSet<ULocale>>();
        ULocale.Builder builder = new ULocale.Builder();
        for (ULocale uLocale : localeSet) {
            builder.setLocale(uLocale);
            ULocale loc = ULocale.addLikelySubtags(uLocale);
            ULocale base = new ULocale(loc.getLanguage());
            HashSet<ULocale> locales = (HashSet<ULocale>)baseToLocales.get(base);
            if (locales == null) {
                locales = new HashSet<ULocale>();
                baseToLocales.put(base, locales);
            }
            locales.add(loc);
        }
        for (Map.Entry entry : baseToLocales.entrySet()) {
            ULocale base = (ULocale)entry.getKey();
            Set values = (Set)entry.getValue();
            if (values.size() == 1) {
                ULocale locale = (ULocale)values.iterator().next();
                result.add(this.newRow(ULocale.minimizeSubtags(locale, ULocale.Minimize.FAVOR_SCRIPT), capContext));
                continue;
            }
            HashSet<String> scripts = new HashSet<String>();
            HashSet<String> regions = new HashSet<String>();
            ULocale maxBase = ULocale.addLikelySubtags(base);
            scripts.add(maxBase.getScript());
            regions.add(maxBase.getCountry());
            for (ULocale locale : values) {
                scripts.add(locale.getScript());
                regions.add(locale.getCountry());
            }
            boolean hasScripts = scripts.size() > 1;
            boolean hasRegions = regions.size() > 1;
            for (ULocale locale : values) {
                ULocale.Builder modified = builder.setLocale(locale);
                if (!hasScripts) {
                    modified.setScript("");
                }
                if (!hasRegions) {
                    modified.setRegion("");
                }
                result.add(this.newRow(modified.build(), capContext));
            }
        }
        Collections.sort(result, comparator);
        return result;
    }

    private final LocaleDisplayNames.UiListItem $$robo$$android_icu_impl_LocaleDisplayNamesImpl$newRow(ULocale modified, DisplayContext capContext) {
        ULocale minimized = ULocale.minimizeSubtags(modified, ULocale.Minimize.FAVOR_SCRIPT);
        String tempName = modified.getDisplayName(this.locale);
        boolean titlecase = capContext == DisplayContext.CAPITALIZATION_FOR_UI_LIST_OR_MENU;
        String nameInDisplayLocale = titlecase ? UCharacter.toTitleFirst(this.locale, tempName) : tempName;
        tempName = modified.getDisplayName(modified);
        String nameInSelf = capContext == DisplayContext.CAPITALIZATION_FOR_UI_LIST_OR_MENU ? UCharacter.toTitleFirst(modified, tempName) : tempName;
        return new LocaleDisplayNames.UiListItem(minimized, modified, nameInDisplayLocale, nameInSelf);
    }

    private static final boolean $$robo$$android_icu_impl_LocaleDisplayNamesImpl$haveData(DataTableType type) {
        switch (1.$SwitchMap$android$icu$impl$LocaleDisplayNamesImpl$DataTableType[type.ordinal()]) {
            case 1: {
                return LangDataTables.impl instanceof ICUDataTables;
            }
            case 2: {
                return RegionDataTables.impl instanceof ICUDataTables;
            }
        }
        throw new IllegalArgumentException("unknown type: " + (Object)((Object)type));
    }

    private final StringBuilder $$robo$$android_icu_impl_LocaleDisplayNamesImpl$appendWithSep(String s, StringBuilder b) {
        if (b.length() == 0) {
            b.append(s);
        } else {
            SimpleFormatterImpl.formatAndReplace(this.separatorFormat, b, null, b, s);
        }
        return b;
    }

    static void __staticInitializer__() {
        cache = new Cache(null);
        contextUsageTypeMap = new HashMap<String, CapitalizationContextUsage>();
        contextUsageTypeMap.put("languages", CapitalizationContextUsage.LANGUAGE);
        contextUsageTypeMap.put("script", CapitalizationContextUsage.SCRIPT);
        contextUsageTypeMap.put("territory", CapitalizationContextUsage.TERRITORY);
        contextUsageTypeMap.put("variant", CapitalizationContextUsage.VARIANT);
        contextUsageTypeMap.put("key", CapitalizationContextUsage.KEY);
        contextUsageTypeMap.put("keyValue", CapitalizationContextUsage.KEYVALUE);
    }

    public static LocaleDisplayNames getInstance(ULocale uLocale, LocaleDisplayNames.DialectHandling dialectHandling) {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$android_icu_impl_LocaleDisplayNamesImpl$getInstance(android.icu.util.ULocale android.icu.text.LocaleDisplayNames$DialectHandling ), (ULocale)uLocale, (LocaleDisplayNames.DialectHandling)dialectHandling);
    }

    public static LocaleDisplayNames getInstance(ULocale uLocale, DisplayContext ... displayContextArray) {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$android_icu_impl_LocaleDisplayNamesImpl$getInstance(android.icu.util.ULocale android.icu.text.DisplayContext[] ), (ULocale)uLocale, (DisplayContext[])displayContextArray);
    }

    private void __constructor__(ULocale uLocale, LocaleDisplayNames.DialectHandling dialectHandling) {
        this.$$robo$$android_icu_impl_LocaleDisplayNamesImpl$__constructor__(uLocale, dialectHandling);
    }

    public LocaleDisplayNamesImpl(ULocale uLocale, LocaleDisplayNames.DialectHandling dialectHandling) {
        this(uLocale, dialectHandling == LocaleDisplayNames.DialectHandling.STANDARD_NAMES ? DisplayContext.STANDARD_NAMES : DisplayContext.DIALECT_NAMES, DisplayContext.CAPITALIZATION_NONE);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_LocaleDisplayNamesImpl$__constructor__(android.icu.util.ULocale android.icu.text.LocaleDisplayNames$DialectHandling ), this, uLocale, dialectHandling);
    }

    private void __constructor__(ULocale uLocale, DisplayContext ... displayContextArray) {
        this.$$robo$$android_icu_impl_LocaleDisplayNamesImpl$__constructor__(uLocale, displayContextArray);
    }

    public LocaleDisplayNamesImpl(ULocale uLocale, DisplayContext ... displayContextArray) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_LocaleDisplayNamesImpl$__constructor__(android.icu.util.ULocale android.icu.text.DisplayContext[] ), this, uLocale, displayContextArray);
    }

    @Override
    public ULocale getLocale() {
        return InvokeDynamicSupport.bootstrap("getLocale", $$robo$$android_icu_impl_LocaleDisplayNamesImpl$getLocale(), this);
    }

    @Override
    public LocaleDisplayNames.DialectHandling getDialectHandling() {
        return InvokeDynamicSupport.bootstrap("getDialectHandling", $$robo$$android_icu_impl_LocaleDisplayNamesImpl$getDialectHandling(), this);
    }

    @Override
    public DisplayContext getContext(DisplayContext.Type type) {
        return InvokeDynamicSupport.bootstrap("getContext", $$robo$$android_icu_impl_LocaleDisplayNamesImpl$getContext(android.icu.text.DisplayContext$Type ), this, type);
    }

    private String adjustForUsageAndContext(CapitalizationContextUsage capitalizationContextUsage, String string2) {
        return InvokeDynamicSupport.bootstrap("adjustForUsageAndContext", $$robo$$android_icu_impl_LocaleDisplayNamesImpl$adjustForUsageAndContext(android.icu.impl.LocaleDisplayNamesImpl$CapitalizationContextUsage java.lang.String ), this, capitalizationContextUsage, string2);
    }

    @Override
    public String localeDisplayName(ULocale uLocale) {
        return InvokeDynamicSupport.bootstrap("localeDisplayName", $$robo$$android_icu_impl_LocaleDisplayNamesImpl$localeDisplayName(android.icu.util.ULocale ), this, uLocale);
    }

    @Override
    public String localeDisplayName(Locale locale) {
        return InvokeDynamicSupport.bootstrap("localeDisplayName", $$robo$$android_icu_impl_LocaleDisplayNamesImpl$localeDisplayName(java.util.Locale ), this, locale);
    }

    @Override
    public String localeDisplayName(String string2) {
        return InvokeDynamicSupport.bootstrap("localeDisplayName", $$robo$$android_icu_impl_LocaleDisplayNamesImpl$localeDisplayName(java.lang.String ), this, string2);
    }

    private String localeDisplayNameInternal(ULocale uLocale) {
        return InvokeDynamicSupport.bootstrap("localeDisplayNameInternal", $$robo$$android_icu_impl_LocaleDisplayNamesImpl$localeDisplayNameInternal(android.icu.util.ULocale ), this, uLocale);
    }

    private String localeIdName(String string2) {
        return InvokeDynamicSupport.bootstrap("localeIdName", $$robo$$android_icu_impl_LocaleDisplayNamesImpl$localeIdName(java.lang.String ), this, string2);
    }

    @Override
    public String languageDisplayName(String string2) {
        return InvokeDynamicSupport.bootstrap("languageDisplayName", $$robo$$android_icu_impl_LocaleDisplayNamesImpl$languageDisplayName(java.lang.String ), this, string2);
    }

    @Override
    public String scriptDisplayName(String string2) {
        return InvokeDynamicSupport.bootstrap("scriptDisplayName", $$robo$$android_icu_impl_LocaleDisplayNamesImpl$scriptDisplayName(java.lang.String ), this, string2);
    }

    private String scriptDisplayNameInContext(String string2, boolean bl) {
        return InvokeDynamicSupport.bootstrap("scriptDisplayNameInContext", $$robo$$android_icu_impl_LocaleDisplayNamesImpl$scriptDisplayNameInContext(java.lang.String boolean ), this, string2, bl);
    }

    @Override
    public String scriptDisplayNameInContext(String string2) {
        return InvokeDynamicSupport.bootstrap("scriptDisplayNameInContext", $$robo$$android_icu_impl_LocaleDisplayNamesImpl$scriptDisplayNameInContext(java.lang.String ), this, string2);
    }

    @Override
    public String scriptDisplayName(int n) {
        return InvokeDynamicSupport.bootstrap("scriptDisplayName", $$robo$$android_icu_impl_LocaleDisplayNamesImpl$scriptDisplayName(int ), this, n);
    }

    private String regionDisplayName(String string2, boolean bl) {
        return InvokeDynamicSupport.bootstrap("regionDisplayName", $$robo$$android_icu_impl_LocaleDisplayNamesImpl$regionDisplayName(java.lang.String boolean ), this, string2, bl);
    }

    @Override
    public String regionDisplayName(String string2) {
        return InvokeDynamicSupport.bootstrap("regionDisplayName", $$robo$$android_icu_impl_LocaleDisplayNamesImpl$regionDisplayName(java.lang.String ), this, string2);
    }

    private String variantDisplayName(String string2, boolean bl) {
        return InvokeDynamicSupport.bootstrap("variantDisplayName", $$robo$$android_icu_impl_LocaleDisplayNamesImpl$variantDisplayName(java.lang.String boolean ), this, string2, bl);
    }

    @Override
    public String variantDisplayName(String string2) {
        return InvokeDynamicSupport.bootstrap("variantDisplayName", $$robo$$android_icu_impl_LocaleDisplayNamesImpl$variantDisplayName(java.lang.String ), this, string2);
    }

    private String keyDisplayName(String string2, boolean bl) {
        return InvokeDynamicSupport.bootstrap("keyDisplayName", $$robo$$android_icu_impl_LocaleDisplayNamesImpl$keyDisplayName(java.lang.String boolean ), this, string2, bl);
    }

    @Override
    public String keyDisplayName(String string2) {
        return InvokeDynamicSupport.bootstrap("keyDisplayName", $$robo$$android_icu_impl_LocaleDisplayNamesImpl$keyDisplayName(java.lang.String ), this, string2);
    }

    private String keyValueDisplayName(String string2, String string3, boolean bl) {
        return InvokeDynamicSupport.bootstrap("keyValueDisplayName", $$robo$$android_icu_impl_LocaleDisplayNamesImpl$keyValueDisplayName(java.lang.String java.lang.String boolean ), this, string2, string3, bl);
    }

    @Override
    public String keyValueDisplayName(String string2, String string3) {
        return InvokeDynamicSupport.bootstrap("keyValueDisplayName", $$robo$$android_icu_impl_LocaleDisplayNamesImpl$keyValueDisplayName(java.lang.String java.lang.String ), this, string2, string3);
    }

    @Override
    public List<LocaleDisplayNames.UiListItem> getUiListCompareWholeItems(Set<ULocale> set, Comparator<LocaleDisplayNames.UiListItem> comparator) {
        return InvokeDynamicSupport.bootstrap("getUiListCompareWholeItems", $$robo$$android_icu_impl_LocaleDisplayNamesImpl$getUiListCompareWholeItems(java.util.Set<android.icu.util.ULocale> java.util.Comparator<android.icu.text.LocaleDisplayNames$UiListItem> ), this, set, comparator);
    }

    private LocaleDisplayNames.UiListItem newRow(ULocale uLocale, DisplayContext displayContext) {
        return InvokeDynamicSupport.bootstrap("newRow", $$robo$$android_icu_impl_LocaleDisplayNamesImpl$newRow(android.icu.util.ULocale android.icu.text.DisplayContext ), this, uLocale, displayContext);
    }

    public static boolean haveData(DataTableType dataTableType) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("haveData", $$robo$$android_icu_impl_LocaleDisplayNamesImpl$haveData(android.icu.impl.LocaleDisplayNamesImpl$DataTableType ), (DataTableType)dataTableType);
    }

    private StringBuilder appendWithSep(String string2, StringBuilder stringBuilder) {
        return InvokeDynamicSupport.bootstrap("appendWithSep", $$robo$$android_icu_impl_LocaleDisplayNamesImpl$appendWithSep(java.lang.String java.lang.StringBuilder ), this, string2, stringBuilder);
    }

    static {
        RobolectricInternals.classInitializing(LocaleDisplayNamesImpl.class);
    }

    public /* synthetic */ LocaleDisplayNamesImpl() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LocaleDisplayNamesImpl)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class Cache
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private ULocale locale;
        private LocaleDisplayNames.DialectHandling dialectHandling;
        private DisplayContext capitalization;
        private DisplayContext nameLength;
        private DisplayContext substituteHandling;
        private LocaleDisplayNames cache;

        private void $$robo$$android_icu_impl_LocaleDisplayNamesImpl_Cache$__constructor__() {
        }

        private final LocaleDisplayNames $$robo$$android_icu_impl_LocaleDisplayNamesImpl_Cache$get(ULocale locale, LocaleDisplayNames.DialectHandling dialectHandling) {
            if (dialectHandling != this.dialectHandling || DisplayContext.CAPITALIZATION_NONE != this.capitalization || DisplayContext.LENGTH_FULL != this.nameLength || DisplayContext.SUBSTITUTE != this.substituteHandling || !locale.equals(this.locale)) {
                this.locale = locale;
                this.dialectHandling = dialectHandling;
                this.capitalization = DisplayContext.CAPITALIZATION_NONE;
                this.nameLength = DisplayContext.LENGTH_FULL;
                this.substituteHandling = DisplayContext.SUBSTITUTE;
                this.cache = new LocaleDisplayNamesImpl(locale, dialectHandling);
            }
            return this.cache;
        }

        private final LocaleDisplayNames $$robo$$android_icu_impl_LocaleDisplayNamesImpl_Cache$get(ULocale locale, DisplayContext ... contexts) {
            LocaleDisplayNames.DialectHandling dialectHandlingIn = LocaleDisplayNames.DialectHandling.STANDARD_NAMES;
            DisplayContext capitalizationIn = DisplayContext.CAPITALIZATION_NONE;
            DisplayContext nameLengthIn = DisplayContext.LENGTH_FULL;
            DisplayContext substituteHandling = DisplayContext.SUBSTITUTE;
            block6: for (DisplayContext contextItem : contexts) {
                switch (1.$SwitchMap$android$icu$text$DisplayContext$Type[contextItem.type().ordinal()]) {
                    case 1: {
                        dialectHandlingIn = contextItem.value() == DisplayContext.STANDARD_NAMES.value() ? LocaleDisplayNames.DialectHandling.STANDARD_NAMES : LocaleDisplayNames.DialectHandling.DIALECT_NAMES;
                        continue block6;
                    }
                    case 2: {
                        capitalizationIn = contextItem;
                        continue block6;
                    }
                    case 3: {
                        nameLengthIn = contextItem;
                        continue block6;
                    }
                    case 4: {
                        substituteHandling = contextItem;
                        continue block6;
                    }
                }
            }
            if (dialectHandlingIn != this.dialectHandling || capitalizationIn != this.capitalization || nameLengthIn != this.nameLength || substituteHandling != this.substituteHandling || !locale.equals(this.locale)) {
                this.locale = locale;
                this.dialectHandling = dialectHandlingIn;
                this.capitalization = capitalizationIn;
                this.nameLength = nameLengthIn;
                this.substituteHandling = substituteHandling;
                this.cache = new LocaleDisplayNamesImpl(locale, contexts);
            }
            return this.cache;
        }

        private /* synthetic */ void $$robo$$android_icu_impl_LocaleDisplayNamesImpl_Cache$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$android_icu_impl_LocaleDisplayNamesImpl_Cache$__constructor__();
        }

        public Cache() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_LocaleDisplayNamesImpl_Cache$__constructor__(), this);
        }

        public LocaleDisplayNames get(ULocale uLocale, LocaleDisplayNames.DialectHandling dialectHandling) {
            return InvokeDynamicSupport.bootstrap("get", $$robo$$android_icu_impl_LocaleDisplayNamesImpl_Cache$get(android.icu.util.ULocale android.icu.text.LocaleDisplayNames$DialectHandling ), this, uLocale, dialectHandling);
        }

        public LocaleDisplayNames get(ULocale uLocale, DisplayContext ... displayContextArray) {
            return InvokeDynamicSupport.bootstrap("get", $$robo$$android_icu_impl_LocaleDisplayNamesImpl_Cache$get(android.icu.util.ULocale android.icu.text.DisplayContext[] ), this, uLocale, displayContextArray);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_icu_impl_LocaleDisplayNamesImpl_Cache$__constructor__(var1_1);
        }

        public /* synthetic */ Cache(1 var1_1) {
            this();
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_LocaleDisplayNamesImpl_Cache$__constructor__(android.icu.impl.LocaleDisplayNamesImpl$1 ), this, var1_1);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Cache)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class DataTableType
    extends Enum<DataTableType> {
        public /* synthetic */ Object __robo_data__;
        public static /* enum */ DataTableType LANG;
        public static /* enum */ DataTableType REGION;
        private static /* synthetic */ DataTableType[] $VALUES;

        private static final DataTableType[] $$robo$$android_icu_impl_LocaleDisplayNamesImpl_DataTableType$values() {
            return (DataTableType[])$VALUES.clone();
        }

        private static final DataTableType $$robo$$android_icu_impl_LocaleDisplayNamesImpl_DataTableType$valueOf(String name) {
            return Enum.valueOf(DataTableType.class, name);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void $$robo$$android_icu_impl_LocaleDisplayNamesImpl_DataTableType$__constructor__(String string2, int n) {
        }

        static void __staticInitializer__() {
            LANG = new DataTableType();
            REGION = new DataTableType();
            $VALUES = new DataTableType[]{LANG, REGION};
        }

        public static DataTableType[] values() {
            return InvokeDynamicSupport.bootstrapStatic("values", $$robo$$android_icu_impl_LocaleDisplayNamesImpl_DataTableType$values());
        }

        public static DataTableType valueOf(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$android_icu_impl_LocaleDisplayNamesImpl_DataTableType$valueOf(java.lang.String ), (String)string2);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void __constructor__(String string2, int n) {
            this.$$robo$$android_icu_impl_LocaleDisplayNamesImpl_DataTableType$__constructor__(string2, n);
        }

        public DataTableType() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_LocaleDisplayNamesImpl_DataTableType$__constructor__(java.lang.String int ), this, string2, n);
        }

        static {
            RobolectricInternals.classInitializing(DataTableType.class);
        }

        public /* synthetic */ DataTableType() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DataTableType)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class RegionDataTables
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        static DataTables impl;

        private void $$robo$$android_icu_impl_LocaleDisplayNamesImpl_RegionDataTables$__constructor__() {
        }

        static void __staticInitializer__() {
            impl = DataTables.load("android.icu.impl.ICURegionDataTables");
        }

        private void __constructor__() {
            this.$$robo$$android_icu_impl_LocaleDisplayNamesImpl_RegionDataTables$__constructor__();
        }

        public RegionDataTables() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_LocaleDisplayNamesImpl_RegionDataTables$__constructor__(), this);
        }

        static {
            RobolectricInternals.classInitializing(RegionDataTables.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RegionDataTables)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class LangDataTables
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        static DataTables impl;

        private void $$robo$$android_icu_impl_LocaleDisplayNamesImpl_LangDataTables$__constructor__() {
        }

        static void __staticInitializer__() {
            impl = DataTables.load("android.icu.impl.ICULangDataTables");
        }

        private void __constructor__() {
            this.$$robo$$android_icu_impl_LocaleDisplayNamesImpl_LangDataTables$__constructor__();
        }

        public LangDataTables() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_LocaleDisplayNamesImpl_LangDataTables$__constructor__(), this);
        }

        static {
            RobolectricInternals.classInitializing(LangDataTables.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LangDataTables)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static abstract class ICUDataTables
    extends DataTables
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private String path;

        private void $$robo$$android_icu_impl_LocaleDisplayNamesImpl_ICUDataTables$__constructor__(String path) {
            this.path = path;
        }

        private final DataTable $$robo$$android_icu_impl_LocaleDisplayNamesImpl_ICUDataTables$get(ULocale locale, boolean nullIfNotFound) {
            return new ICUDataTable(this.path, locale, nullIfNotFound);
        }

        private void __constructor__(String string2) {
            this.$$robo$$android_icu_impl_LocaleDisplayNamesImpl_ICUDataTables$__constructor__(string2);
        }

        public ICUDataTables(String string2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_LocaleDisplayNamesImpl_ICUDataTables$__constructor__(java.lang.String ), this, string2);
        }

        @Override
        public DataTable get(ULocale uLocale, boolean bl) {
            return InvokeDynamicSupport.bootstrap("get", $$robo$$android_icu_impl_LocaleDisplayNamesImpl_ICUDataTables$get(android.icu.util.ULocale boolean ), this, uLocale, bl);
        }

        public /* synthetic */ ICUDataTables() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ICUDataTables)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static abstract class DataTables
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;

        private void $$robo$$android_icu_impl_LocaleDisplayNamesImpl_DataTables$__constructor__() {
        }

        public abstract DataTable get(ULocale var1, boolean var2);

        private static final DataTables $$robo$$android_icu_impl_LocaleDisplayNamesImpl_DataTables$load(String className) {
            try {
                return (DataTables)Class.forName(className).newInstance();
            }
            catch (Throwable t) {
                return new ShadowedObject(){
                    public /* synthetic */ Object __robo_data__;

                    private void $$robo$$android_icu_impl_LocaleDisplayNamesImpl_DataTables_1$__constructor__() {
                    }

                    private final DataTable $$robo$$android_icu_impl_LocaleDisplayNamesImpl_DataTables_1$get(ULocale locale, boolean nullIfNotFound) {
                        return new DataTable(nullIfNotFound);
                    }

                    @Override
                    private void __constructor__() {
                        this.$$robo$$android_icu_impl_LocaleDisplayNamesImpl_DataTables_1$__constructor__();
                    }
                    {
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_LocaleDisplayNamesImpl_DataTables_1$__constructor__(), this);
                    }

                    @Override
                    public DataTable get(ULocale uLocale, boolean bl) {
                        return InvokeDynamicSupport.bootstrap("get", $$robo$$android_icu_impl_LocaleDisplayNamesImpl_DataTables_1$get(android.icu.util.ULocale boolean ), this, uLocale, bl);
                    }

                    @Override
                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    @Override
                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                };
            }
        }

        private void __constructor__() {
            this.$$robo$$android_icu_impl_LocaleDisplayNamesImpl_DataTables$__constructor__();
        }

        public DataTables() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_LocaleDisplayNamesImpl_DataTables$__constructor__(), this);
        }

        public static DataTables load(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("load", $$robo$$android_icu_impl_LocaleDisplayNamesImpl_DataTables$load(java.lang.String ), (String)string2);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DataTables)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class ICUDataTable
    extends DataTable
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private ICUResourceBundle bundle;

        private void $$robo$$android_icu_impl_LocaleDisplayNamesImpl_ICUDataTable$__constructor__(String path, ULocale locale, boolean nullIfNotFound) {
            this.bundle = (ICUResourceBundle)UResourceBundle.getBundleInstance(path, locale.getBaseName());
        }

        private final ULocale $$robo$$android_icu_impl_LocaleDisplayNamesImpl_ICUDataTable$getLocale() {
            return this.bundle.getULocale();
        }

        private final String $$robo$$android_icu_impl_LocaleDisplayNamesImpl_ICUDataTable$get(String tableName, String subTableName, String code) {
            return ICUResourceTableAccess.getTableString(this.bundle, tableName, subTableName, code, this.nullIfNotFound ? null : code);
        }

        private void __constructor__(String string2, ULocale uLocale, boolean bl) {
            this.$$robo$$android_icu_impl_LocaleDisplayNamesImpl_ICUDataTable$__constructor__(string2, uLocale, bl);
        }

        public ICUDataTable(String string2, ULocale uLocale, boolean bl) {
            super(bl);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_LocaleDisplayNamesImpl_ICUDataTable$__constructor__(java.lang.String android.icu.util.ULocale boolean ), this, string2, uLocale, bl);
        }

        @Override
        public ULocale getLocale() {
            return InvokeDynamicSupport.bootstrap("getLocale", $$robo$$android_icu_impl_LocaleDisplayNamesImpl_ICUDataTable$getLocale(), this);
        }

        @Override
        public String get(String string2, String string3, String string4) {
            return InvokeDynamicSupport.bootstrap("get", $$robo$$android_icu_impl_LocaleDisplayNamesImpl_ICUDataTable$get(java.lang.String java.lang.String java.lang.String ), this, string2, string3, string4);
        }

        public /* synthetic */ ICUDataTable() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ICUDataTable)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class DataTable
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        boolean nullIfNotFound;

        private void $$robo$$android_icu_impl_LocaleDisplayNamesImpl_DataTable$__constructor__(boolean nullIfNotFound) {
            this.nullIfNotFound = nullIfNotFound;
        }

        private final ULocale $$robo$$android_icu_impl_LocaleDisplayNamesImpl_DataTable$getLocale() {
            return ULocale.ROOT;
        }

        private final String $$robo$$android_icu_impl_LocaleDisplayNamesImpl_DataTable$get(String tableName, String code) {
            return this.get(tableName, null, code);
        }

        private final String $$robo$$android_icu_impl_LocaleDisplayNamesImpl_DataTable$get(String tableName, String subTableName, String code) {
            return this.nullIfNotFound ? null : code;
        }

        private void __constructor__(boolean bl) {
            this.$$robo$$android_icu_impl_LocaleDisplayNamesImpl_DataTable$__constructor__(bl);
        }

        public DataTable(boolean bl) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_LocaleDisplayNamesImpl_DataTable$__constructor__(boolean ), this, bl);
        }

        ULocale getLocale() {
            return InvokeDynamicSupport.bootstrap("getLocale", $$robo$$android_icu_impl_LocaleDisplayNamesImpl_DataTable$getLocale(), this);
        }

        String get(String string2, String string3) {
            return InvokeDynamicSupport.bootstrap("get", $$robo$$android_icu_impl_LocaleDisplayNamesImpl_DataTable$get(java.lang.String java.lang.String ), this, string2, string3);
        }

        String get(String string2, String string3, String string4) {
            return InvokeDynamicSupport.bootstrap("get", $$robo$$android_icu_impl_LocaleDisplayNamesImpl_DataTable$get(java.lang.String java.lang.String java.lang.String ), this, string2, string3, string4);
        }

        public /* synthetic */ DataTable() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DataTable)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private final class CapitalizationContextSink
    extends UResource.Sink
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        boolean hasCapitalizationUsage;
        /* synthetic */ LocaleDisplayNamesImpl this$0;

        private void $$robo$$android_icu_impl_LocaleDisplayNamesImpl_CapitalizationContextSink$__constructor__(LocaleDisplayNamesImpl localeDisplayNamesImpl) {
            this.hasCapitalizationUsage = false;
        }

        private final void $$robo$$android_icu_impl_LocaleDisplayNamesImpl_CapitalizationContextSink$put(UResource.Key key, UResource.Value value, boolean noFallback) {
            UResource.Table contextsTable = value.getTable();
            int i = 0;
            while (contextsTable.getKeyAndValue(i, key, value)) {
                int[] intVector;
                CapitalizationContextUsage usage = (CapitalizationContextUsage)((Object)contextUsageTypeMap.get(key.toString()));
                if (usage != null && (intVector = value.getIntVector()).length >= 2) {
                    int titlecaseInt;
                    int n = titlecaseInt = this.this$0.capitalization == DisplayContext.CAPITALIZATION_FOR_UI_LIST_OR_MENU ? intVector[0] : intVector[1];
                    if (titlecaseInt != 0) {
                        ((LocaleDisplayNamesImpl)this.this$0).capitalizationUsage[usage.ordinal()] = true;
                        this.hasCapitalizationUsage = true;
                    }
                }
                ++i;
            }
        }

        private /* synthetic */ void $$robo$$android_icu_impl_LocaleDisplayNamesImpl_CapitalizationContextSink$__constructor__(LocaleDisplayNamesImpl x0, 1 x1) {
        }

        private void __constructor__(LocaleDisplayNamesImpl localeDisplayNamesImpl) {
            this.$$robo$$android_icu_impl_LocaleDisplayNamesImpl_CapitalizationContextSink$__constructor__(localeDisplayNamesImpl);
        }

        public CapitalizationContextSink(LocaleDisplayNamesImpl localeDisplayNamesImpl) {
            this.this$0 = localeDisplayNamesImpl;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_LocaleDisplayNamesImpl_CapitalizationContextSink$__constructor__(android.icu.impl.LocaleDisplayNamesImpl ), this, localeDisplayNamesImpl);
        }

        @Override
        public void put(UResource.Key key, UResource.Value value, boolean bl) {
            InvokeDynamicSupport.bootstrap("put", $$robo$$android_icu_impl_LocaleDisplayNamesImpl_CapitalizationContextSink$put(android.icu.impl.UResource$Key android.icu.impl.UResource$Value boolean ), this, key, value, bl);
        }

        private /* synthetic */ void __constructor__(LocaleDisplayNamesImpl localeDisplayNamesImpl, 1 var2_2) {
            this.$$robo$$android_icu_impl_LocaleDisplayNamesImpl_CapitalizationContextSink$__constructor__(localeDisplayNamesImpl, var2_2);
        }

        public /* synthetic */ CapitalizationContextSink(LocaleDisplayNamesImpl localeDisplayNamesImpl, 1 var2_2) {
            this(localeDisplayNamesImpl);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_LocaleDisplayNamesImpl_CapitalizationContextSink$__constructor__(android.icu.impl.LocaleDisplayNamesImpl android.icu.impl.LocaleDisplayNamesImpl$1 ), this, localeDisplayNamesImpl, var2_2);
        }

        public /* synthetic */ CapitalizationContextSink() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CapitalizationContextSink)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class CapitalizationContextUsage
    extends Enum<CapitalizationContextUsage> {
        public /* synthetic */ Object __robo_data__;
        public static /* enum */ CapitalizationContextUsage LANGUAGE;
        public static /* enum */ CapitalizationContextUsage SCRIPT;
        public static /* enum */ CapitalizationContextUsage TERRITORY;
        public static /* enum */ CapitalizationContextUsage VARIANT;
        public static /* enum */ CapitalizationContextUsage KEY;
        public static /* enum */ CapitalizationContextUsage KEYVALUE;
        private static /* synthetic */ CapitalizationContextUsage[] $VALUES;

        private static final CapitalizationContextUsage[] $$robo$$android_icu_impl_LocaleDisplayNamesImpl_CapitalizationContextUsage$values() {
            return (CapitalizationContextUsage[])$VALUES.clone();
        }

        private static final CapitalizationContextUsage $$robo$$android_icu_impl_LocaleDisplayNamesImpl_CapitalizationContextUsage$valueOf(String name) {
            return Enum.valueOf(CapitalizationContextUsage.class, name);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void $$robo$$android_icu_impl_LocaleDisplayNamesImpl_CapitalizationContextUsage$__constructor__(String string2, int n) {
        }

        static void __staticInitializer__() {
            LANGUAGE = new CapitalizationContextUsage();
            SCRIPT = new CapitalizationContextUsage();
            TERRITORY = new CapitalizationContextUsage();
            VARIANT = new CapitalizationContextUsage();
            KEY = new CapitalizationContextUsage();
            KEYVALUE = new CapitalizationContextUsage();
            $VALUES = new CapitalizationContextUsage[]{LANGUAGE, SCRIPT, TERRITORY, VARIANT, KEY, KEYVALUE};
        }

        public static CapitalizationContextUsage[] values() {
            return InvokeDynamicSupport.bootstrapStatic("values", $$robo$$android_icu_impl_LocaleDisplayNamesImpl_CapitalizationContextUsage$values());
        }

        public static CapitalizationContextUsage valueOf(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$android_icu_impl_LocaleDisplayNamesImpl_CapitalizationContextUsage$valueOf(java.lang.String ), (String)string2);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void __constructor__(String string2, int n) {
            this.$$robo$$android_icu_impl_LocaleDisplayNamesImpl_CapitalizationContextUsage$__constructor__(string2, n);
        }

        public CapitalizationContextUsage() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_LocaleDisplayNamesImpl_CapitalizationContextUsage$__constructor__(java.lang.String int ), this, string2, n);
        }

        static {
            RobolectricInternals.classInitializing(CapitalizationContextUsage.class);
        }

        public /* synthetic */ CapitalizationContextUsage() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CapitalizationContextUsage)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

