/*
 * Decompiled with CFR 0.152.
 */
package android.icu.impl.coll;

import android.icu.impl.Normalizer2Impl;
import android.icu.impl.Trie2_32;
import android.icu.impl.coll.Collation;
import android.icu.impl.coll.UVector32;
import android.icu.text.UnicodeSet;
import android.icu.util.ICUException;
import com.google.errorprone.annotations.DoNotMock;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class CollationData
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    static int REORDER_RESERVED_BEFORE_LATIN = 4110;
    static int REORDER_RESERVED_AFTER_LATIN = 4111;
    static int MAX_NUM_SPECIAL_REORDER_CODES = 8;
    private static int[] EMPTY_INT_ARRAY;
    static int JAMO_CE32S_LENGTH = 67;
    Trie2_32 trie;
    int[] ce32s;
    long[] ces;
    String contexts;
    public CollationData base;
    int[] jamoCE32s;
    public Normalizer2Impl nfcImpl;
    long numericPrimary;
    public boolean[] compressibleBytes;
    UnicodeSet unsafeBackwardSet;
    public char[] fastLatinTable;
    char[] fastLatinTableHeader;
    int numScripts;
    char[] scriptsIndex;
    char[] scriptStarts;
    public long[] rootElements;
    static /* synthetic */ boolean $assertionsDisabled;

    private void $$robo$$android_icu_impl_coll_CollationData$__constructor__(Normalizer2Impl nfc) {
        this.jamoCE32s = new int[67];
        this.numericPrimary = 0x12000000L;
        this.nfcImpl = nfc;
    }

    private final int $$robo$$android_icu_impl_coll_CollationData$getCE32(int c) {
        return this.trie.get(c);
    }

    private final int $$robo$$android_icu_impl_coll_CollationData$getCE32FromSupplementary(int c) {
        return this.trie.get(c);
    }

    private final boolean $$robo$$android_icu_impl_coll_CollationData$isDigit(int c) {
        return c < 1632 ? c <= 57 && 48 <= c : Collation.hasCE32Tag(this.getCE32(c), 10);
    }

    private final boolean $$robo$$android_icu_impl_coll_CollationData$isUnsafeBackward(int c, boolean numeric) {
        return this.unsafeBackwardSet.contains(c) || numeric && this.isDigit(c);
    }

    private final boolean $$robo$$android_icu_impl_coll_CollationData$isCompressibleLeadByte(int b) {
        return this.compressibleBytes[b];
    }

    private final boolean $$robo$$android_icu_impl_coll_CollationData$isCompressiblePrimary(long p) {
        return this.isCompressibleLeadByte((int)p >>> 24);
    }

    private final int $$robo$$android_icu_impl_coll_CollationData$getCE32FromContexts(int index) {
        return this.contexts.charAt(index) << 16 | this.contexts.charAt(index + 1);
    }

    private final int $$robo$$android_icu_impl_coll_CollationData$getIndirectCE32(int ce32) {
        if (!$assertionsDisabled && !Collation.isSpecialCE32(ce32)) {
            throw new AssertionError();
        }
        int tag = Collation.tagFromCE32(ce32);
        if (tag == 10) {
            ce32 = this.ce32s[Collation.indexFromCE32(ce32)];
        } else if (tag == 13) {
            ce32 = -1;
        } else if (tag == 11) {
            ce32 = this.ce32s[0];
        }
        return ce32;
    }

    private final int $$robo$$android_icu_impl_coll_CollationData$getFinalCE32(int ce32) {
        if (Collation.isSpecialCE32(ce32)) {
            ce32 = this.getIndirectCE32(ce32);
        }
        return ce32;
    }

    private final long $$robo$$android_icu_impl_coll_CollationData$getCEFromOffsetCE32(int c, int ce32) {
        long dataCE = this.ces[Collation.indexFromCE32(ce32)];
        return Collation.makeCE(Collation.getThreeBytePrimaryForOffsetData(c, dataCE));
    }

    private final long $$robo$$android_icu_impl_coll_CollationData$getSingleCE(int c) {
        CollationData d;
        int ce32 = this.getCE32(c);
        if (ce32 == 192) {
            d = this.base;
            ce32 = this.base.getCE32(c);
        } else {
            d = this;
        }
        while (Collation.isSpecialCE32(ce32)) {
            switch (Collation.tagFromCE32(ce32)) {
                case 4: 
                case 7: 
                case 8: 
                case 9: 
                case 12: 
                case 13: {
                    throw new UnsupportedOperationException(String.format("there is not exactly one collation element for U+%04X (CE32 0x%08x)", c, ce32));
                }
                case 0: 
                case 3: {
                    throw new AssertionError((Object)String.format("unexpected CE32 tag for U+%04X (CE32 0x%08x)", c, ce32));
                }
                case 1: {
                    return Collation.ceFromLongPrimaryCE32(ce32);
                }
                case 2: {
                    return Collation.ceFromLongSecondaryCE32(ce32);
                }
                case 5: {
                    if (Collation.lengthFromCE32(ce32) == 1) {
                        ce32 = d.ce32s[Collation.indexFromCE32(ce32)];
                        break;
                    }
                    throw new UnsupportedOperationException(String.format("there is not exactly one collation element for U+%04X (CE32 0x%08x)", c, ce32));
                }
                case 6: {
                    if (Collation.lengthFromCE32(ce32) == 1) {
                        return d.ces[Collation.indexFromCE32(ce32)];
                    }
                    throw new UnsupportedOperationException(String.format("there is not exactly one collation element for U+%04X (CE32 0x%08x)", c, ce32));
                }
                case 10: {
                    ce32 = d.ce32s[Collation.indexFromCE32(ce32)];
                    break;
                }
                case 11: {
                    if (!$assertionsDisabled && c != 0) {
                        throw new AssertionError();
                    }
                    ce32 = d.ce32s[0];
                    break;
                }
                case 14: {
                    return d.getCEFromOffsetCE32(c, ce32);
                }
                case 15: {
                    return Collation.unassignedCEFromCodePoint(c);
                }
            }
        }
        return Collation.ceFromSimpleCE32(ce32);
    }

    private final int $$robo$$android_icu_impl_coll_CollationData$getFCD16(int c) {
        return this.nfcImpl.getFCD16(c);
    }

    private final long $$robo$$android_icu_impl_coll_CollationData$getFirstPrimaryForGroup(int script) {
        int index = this.getScriptIndex(script);
        return index == 0 ? 0L : (long)this.scriptStarts[index] << 16;
    }

    private final long $$robo$$android_icu_impl_coll_CollationData$getLastPrimaryForGroup(int script) {
        int index = this.getScriptIndex(script);
        if (index == 0) {
            return 0L;
        }
        long limit = this.scriptStarts[index + 1];
        return (limit << 16) - 1L;
    }

    private final int $$robo$$android_icu_impl_coll_CollationData$getGroupForPrimary(long p) {
        int i;
        if ((p >>= 16) < (long)this.scriptStarts[1] || (long)this.scriptStarts[this.scriptStarts.length - 1] <= p) {
            return -1;
        }
        char index = '\u0001';
        while (p >= (long)this.scriptStarts[index + 1]) {
            ++index;
        }
        for (i = 0; i < this.numScripts; ++i) {
            if (this.scriptsIndex[i] != index) continue;
            return i;
        }
        for (i = 0; i < 8; ++i) {
            if (this.scriptsIndex[this.numScripts + i] != index) continue;
            return 4096 + i;
        }
        return -1;
    }

    private final int $$robo$$android_icu_impl_coll_CollationData$getScriptIndex(int script) {
        if (script < 0) {
            return 0;
        }
        if (script < this.numScripts) {
            return this.scriptsIndex[script];
        }
        if (script < 4096) {
            return 0;
        }
        if ((script -= 4096) < 8) {
            return this.scriptsIndex[this.numScripts + script];
        }
        return 0;
    }

    private final int[] $$robo$$android_icu_impl_coll_CollationData$getEquivalentScripts(int script) {
        int index = this.getScriptIndex(script);
        if (index == 0) {
            return EMPTY_INT_ARRAY;
        }
        if (script >= 4096) {
            return new int[]{script};
        }
        int length = 0;
        for (int i = 0; i < this.numScripts; ++i) {
            if (this.scriptsIndex[i] != index) continue;
            ++length;
        }
        int[] dest = new int[length];
        if (length == 1) {
            dest[0] = script;
            return dest;
        }
        length = 0;
        for (int i = 0; i < this.numScripts; ++i) {
            if (this.scriptsIndex[i] != index) continue;
            dest[length++] = i;
        }
        return dest;
    }

    private final void $$robo$$android_icu_impl_coll_CollationData$makeReorderRanges(int[] reorder, UVector32 ranges) {
        this.makeReorderRanges(reorder, false, ranges);
    }

    private final void $$robo$$android_icu_impl_coll_CollationData$makeReorderRanges(int[] reorder, boolean latinMustMove, UVector32 ranges) {
        char index;
        int i;
        ranges.removeAllElements();
        int length = reorder.length;
        if (length == 0 || length == 1 && reorder[0] == 103) {
            return;
        }
        short[] table = new short[this.scriptStarts.length - 1];
        char index2 = this.scriptsIndex[this.numScripts + 4110 - 4096];
        if (index2 != '\u0000') {
            table[index2] = 255;
        }
        if ((index2 = this.scriptsIndex[this.numScripts + 4111 - 4096]) != '\u0000') {
            table[index2] = 255;
        }
        if (!$assertionsDisabled && this.scriptStarts.length < 2) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.scriptStarts[0] != '\u0000') {
            throw new AssertionError();
        }
        int lowStart = this.scriptStarts[1];
        if (!$assertionsDisabled && lowStart != 768) {
            throw new AssertionError();
        }
        int highLimit = this.scriptStarts[this.scriptStarts.length - 1];
        if (!$assertionsDisabled && highLimit != 65280) {
            throw new AssertionError();
        }
        int specials = 0;
        for (i = 0; i < length; ++i) {
            int reorderCode = reorder[i] - 4096;
            if (0 > reorderCode || reorderCode >= 8) continue;
            specials |= 1 << reorderCode;
        }
        for (i = 0; i < 8; ++i) {
            index = this.scriptsIndex[this.numScripts + i];
            if (index == '\u0000' || (specials & 1 << i) != 0) continue;
            lowStart = this.addLowScriptRange(table, index, lowStart);
        }
        int skippedReserved = 0;
        if (specials == 0 && reorder[0] == 25 && !latinMustMove) {
            index = this.scriptsIndex[25];
            if (!$assertionsDisabled && index == '\u0000') {
                throw new AssertionError();
            }
            int start = this.scriptStarts[index];
            if (!$assertionsDisabled && lowStart > start) {
                throw new AssertionError();
            }
            skippedReserved = start - lowStart;
            lowStart = start;
        }
        boolean hasReorderToEnd = false;
        int i2 = 0;
        while (i2 < length) {
            int index3;
            int script;
            if ((script = reorder[i2++]) == 103) {
                hasReorderToEnd = true;
                while (i2 < length) {
                    if ((script = reorder[--length]) == 103) {
                        throw new IllegalArgumentException("setReorderCodes(): duplicate UScript.UNKNOWN");
                    }
                    if (script == -1) {
                        throw new IllegalArgumentException("setReorderCodes(): UScript.DEFAULT together with other scripts");
                    }
                    index3 = this.getScriptIndex(script);
                    if (index3 == 0) continue;
                    if (table[index3] != 0) {
                        throw new IllegalArgumentException("setReorderCodes(): duplicate or equivalent script " + CollationData.scriptCodeString(script));
                    }
                    highLimit = this.addHighScriptRange(table, index3, highLimit);
                }
                break;
            }
            if (script == -1) {
                throw new IllegalArgumentException("setReorderCodes(): UScript.DEFAULT together with other scripts");
            }
            index3 = this.getScriptIndex(script);
            if (index3 == 0) continue;
            if (table[index3] != 0) {
                throw new IllegalArgumentException("setReorderCodes(): duplicate or equivalent script " + CollationData.scriptCodeString(script));
            }
            lowStart = this.addLowScriptRange(table, index3, lowStart);
        }
        for (i2 = 1; i2 < this.scriptStarts.length - 1; ++i2) {
            short leadByte = table[i2];
            if (leadByte != 0) continue;
            int start = this.scriptStarts[i2];
            if (!hasReorderToEnd && start > lowStart) {
                lowStart = start;
            }
            lowStart = this.addLowScriptRange(table, i2, lowStart);
        }
        if (lowStart > highLimit) {
            if (lowStart - (skippedReserved & 0xFF00) <= highLimit) {
                this.makeReorderRanges(reorder, true, ranges);
                return;
            }
            throw new ICUException("setReorderCodes(): reordering too many partial-primary-lead-byte scripts");
        }
        int offset = 0;
        int i3 = 1;
        while (true) {
            short newLeadByte;
            int nextOffset = offset;
            while (i3 < this.scriptStarts.length - 1 && ((newLeadByte = table[i3]) == 255 || (nextOffset = newLeadByte - (this.scriptStarts[i3] >> 8)) == offset)) {
                ++i3;
            }
            if (offset != 0 || i3 < this.scriptStarts.length - 1) {
                ranges.addElement(this.scriptStarts[i3] << 16 | offset & 0xFFFF);
            }
            if (i3 == this.scriptStarts.length - 1) break;
            offset = nextOffset;
            ++i3;
        }
    }

    private final int $$robo$$android_icu_impl_coll_CollationData$addLowScriptRange(short[] table, int index, int lowStart) {
        char start = this.scriptStarts[index];
        if ((start & 0xFF) < (lowStart & 0xFF)) {
            lowStart += 256;
        }
        table[index] = (short)(lowStart >> 8);
        char limit = this.scriptStarts[index + 1];
        lowStart = (lowStart & 0xFF00) + ((limit & 0xFF00) - (start & 0xFF00)) | limit & 0xFF;
        return lowStart;
    }

    private final int $$robo$$android_icu_impl_coll_CollationData$addHighScriptRange(short[] table, int index, int highLimit) {
        char limit = this.scriptStarts[index + 1];
        if ((limit & 0xFF) > (highLimit & 0xFF)) {
            highLimit -= 256;
        }
        char start = this.scriptStarts[index];
        highLimit = (highLimit & 0xFF00) - ((limit & 0xFF00) - (start & 0xFF00)) | start & 0xFF;
        table[index] = (short)(highLimit >> 8);
        return highLimit;
    }

    private static final String $$robo$$android_icu_impl_coll_CollationData$scriptCodeString(int script) {
        return script < 4096 ? Integer.toString(script) : "0x" + Integer.toHexString(script);
    }

    static void __staticInitializer__() {
        $assertionsDisabled = !CollationData.class.desiredAssertionStatus();
        EMPTY_INT_ARRAY = new int[0];
    }

    private void __constructor__(Normalizer2Impl normalizer2Impl) {
        this.$$robo$$android_icu_impl_coll_CollationData$__constructor__(normalizer2Impl);
    }

    public CollationData(Normalizer2Impl normalizer2Impl) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_coll_CollationData$__constructor__(android.icu.impl.Normalizer2Impl ), this, normalizer2Impl);
    }

    public int getCE32(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getCE32", $$robo$$android_icu_impl_coll_CollationData$getCE32(int ), this, n);
    }

    int getCE32FromSupplementary(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getCE32FromSupplementary", $$robo$$android_icu_impl_coll_CollationData$getCE32FromSupplementary(int ), this, n);
    }

    boolean isDigit(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isDigit", $$robo$$android_icu_impl_coll_CollationData$isDigit(int ), this, n);
    }

    public boolean isUnsafeBackward(int n, boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("isUnsafeBackward", $$robo$$android_icu_impl_coll_CollationData$isUnsafeBackward(int boolean ), this, n, bl);
    }

    public boolean isCompressibleLeadByte(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isCompressibleLeadByte", $$robo$$android_icu_impl_coll_CollationData$isCompressibleLeadByte(int ), this, n);
    }

    public boolean isCompressiblePrimary(long l) {
        return (boolean)InvokeDynamicSupport.bootstrap("isCompressiblePrimary", $$robo$$android_icu_impl_coll_CollationData$isCompressiblePrimary(long ), this, l);
    }

    int getCE32FromContexts(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getCE32FromContexts", $$robo$$android_icu_impl_coll_CollationData$getCE32FromContexts(int ), this, n);
    }

    int getIndirectCE32(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getIndirectCE32", $$robo$$android_icu_impl_coll_CollationData$getIndirectCE32(int ), this, n);
    }

    int getFinalCE32(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getFinalCE32", $$robo$$android_icu_impl_coll_CollationData$getFinalCE32(int ), this, n);
    }

    long getCEFromOffsetCE32(int n, int n2) {
        return (long)InvokeDynamicSupport.bootstrap("getCEFromOffsetCE32", $$robo$$android_icu_impl_coll_CollationData$getCEFromOffsetCE32(int int ), this, n, n2);
    }

    long getSingleCE(int n) {
        return (long)InvokeDynamicSupport.bootstrap("getSingleCE", $$robo$$android_icu_impl_coll_CollationData$getSingleCE(int ), this, n);
    }

    int getFCD16(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getFCD16", $$robo$$android_icu_impl_coll_CollationData$getFCD16(int ), this, n);
    }

    long getFirstPrimaryForGroup(int n) {
        return (long)InvokeDynamicSupport.bootstrap("getFirstPrimaryForGroup", $$robo$$android_icu_impl_coll_CollationData$getFirstPrimaryForGroup(int ), this, n);
    }

    public long getLastPrimaryForGroup(int n) {
        return (long)InvokeDynamicSupport.bootstrap("getLastPrimaryForGroup", $$robo$$android_icu_impl_coll_CollationData$getLastPrimaryForGroup(int ), this, n);
    }

    public int getGroupForPrimary(long l) {
        return (int)InvokeDynamicSupport.bootstrap("getGroupForPrimary", $$robo$$android_icu_impl_coll_CollationData$getGroupForPrimary(long ), this, l);
    }

    private int getScriptIndex(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getScriptIndex", $$robo$$android_icu_impl_coll_CollationData$getScriptIndex(int ), this, n);
    }

    public int[] getEquivalentScripts(int n) {
        return InvokeDynamicSupport.bootstrap("getEquivalentScripts", $$robo$$android_icu_impl_coll_CollationData$getEquivalentScripts(int ), this, n);
    }

    void makeReorderRanges(int[] nArray, UVector32 uVector32) {
        InvokeDynamicSupport.bootstrap("makeReorderRanges", $$robo$$android_icu_impl_coll_CollationData$makeReorderRanges(int[] android.icu.impl.coll.UVector32 ), this, nArray, uVector32);
    }

    private void makeReorderRanges(int[] nArray, boolean bl, UVector32 uVector32) {
        InvokeDynamicSupport.bootstrap("makeReorderRanges", $$robo$$android_icu_impl_coll_CollationData$makeReorderRanges(int[] boolean android.icu.impl.coll.UVector32 ), this, nArray, bl, uVector32);
    }

    private int addLowScriptRange(short[] sArray, int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("addLowScriptRange", $$robo$$android_icu_impl_coll_CollationData$addLowScriptRange(short[] int int ), this, sArray, n, n2);
    }

    private int addHighScriptRange(short[] sArray, int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("addHighScriptRange", $$robo$$android_icu_impl_coll_CollationData$addHighScriptRange(short[] int int ), this, sArray, n, n2);
    }

    private static String scriptCodeString(int n) {
        return InvokeDynamicSupport.bootstrapStatic("scriptCodeString", $$robo$$android_icu_impl_coll_CollationData$scriptCodeString(int ), (int)n);
    }

    static {
        RobolectricInternals.classInitializing(CollationData.class);
    }

    public /* synthetic */ CollationData() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CollationData)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

