/*
 * Decompiled with CFR 0.152.
 */
package android.icu.impl.coll;

import android.icu.impl.ICUResourceBundle;
import android.icu.impl.coll.CollationDataReader;
import android.icu.impl.coll.CollationRoot;
import android.icu.impl.coll.CollationTailoring;
import android.icu.util.ICUUncheckedIOException;
import android.icu.util.Output;
import android.icu.util.ULocale;
import android.icu.util.UResourceBundle;
import com.google.errorprone.annotations.DoNotMock;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.MissingResourceException;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class CollationLoader
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static volatile String rootRules;

    private void $$robo$$android_icu_impl_coll_CollationLoader$__constructor__() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void $$robo$$android_icu_impl_coll_CollationLoader$loadRootRules() {
        if (rootRules != null) {
            return;
        }
        Class<CollationLoader> clazz = CollationLoader.class;
        synchronized (CollationLoader.class) {
            if (rootRules == null) {
                UResourceBundle rootBundle = UResourceBundle.getBundleInstance("android/icu/impl/data/icudt58b/coll", ULocale.ROOT);
                rootRules = rootBundle.getString("UCARules");
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private static final String $$robo$$android_icu_impl_coll_CollationLoader$getRootRules() {
        CollationLoader.loadRootRules();
        return rootRules;
    }

    private static final String $$robo$$android_icu_impl_coll_CollationLoader$loadRules(ULocale locale, String collationType) {
        UResourceBundle bundle = UResourceBundle.getBundleInstance("android/icu/impl/data/icudt58b/coll", locale);
        ICUResourceBundle data = ((ICUResourceBundle)bundle).getWithFallback("collations/" + ASCII.toLowerCase(collationType));
        String rules = data.getString("Sequence");
        return rules;
    }

    private static final UResourceBundle $$robo$$android_icu_impl_coll_CollationLoader$findWithFallback(UResourceBundle table, String entryName) {
        return ((ICUResourceBundle)table).findWithFallback(entryName);
    }

    private static final CollationTailoring $$robo$$android_icu_impl_coll_CollationLoader$loadTailoring(ULocale locale, Output<ULocale> outValidLocale) {
        UResourceBundle actualBundle;
        UResourceBundle data;
        UResourceBundle collations;
        CollationTailoring root = CollationRoot.getRoot();
        String localeName = locale.getName();
        if (localeName.length() == 0 || localeName.equals("root")) {
            outValidLocale.value = ULocale.ROOT;
            return root;
        }
        ICUResourceBundle bundle = null;
        try {
            bundle = ICUResourceBundle.getBundleInstance("android/icu/impl/data/icudt58b/coll", locale, ICUResourceBundle.OpenType.LOCALE_ROOT);
        }
        catch (MissingResourceException e) {
            outValidLocale.value = ULocale.ROOT;
            return root;
        }
        ULocale validLocale = ((UResourceBundle)bundle).getULocale();
        String validLocaleName = validLocale.getName();
        if (validLocaleName.length() == 0 || validLocaleName.equals("root")) {
            validLocale = ULocale.ROOT;
        }
        outValidLocale.value = validLocale;
        try {
            collations = bundle.get("collations");
            if (collations == null) {
                return root;
            }
        }
        catch (MissingResourceException ignored) {
            return root;
        }
        String type = locale.getKeywordValue("collation");
        String defaultType = "standard";
        String defT = ((ICUResourceBundle)collations).findStringWithFallback("default");
        if (defT != null) {
            defaultType = defT;
        }
        if ((data = CollationLoader.findWithFallback(collations, type = type == null || type.equals("default") ? defaultType : ASCII.toLowerCase(type))) == null && type.length() > 6 && type.startsWith("search")) {
            type = "search";
            data = CollationLoader.findWithFallback(collations, type);
        }
        if (data == null && !type.equals(defaultType)) {
            type = defaultType;
            data = CollationLoader.findWithFallback(collations, type);
        }
        if (data == null && !type.equals("standard")) {
            type = "standard";
            data = CollationLoader.findWithFallback(collations, type);
        }
        if (data == null) {
            return root;
        }
        ULocale actualLocale = data.getULocale();
        String actualLocaleName = actualLocale.getName();
        if (actualLocaleName.length() == 0 || actualLocaleName.equals("root")) {
            actualLocale = ULocale.ROOT;
            if (type.equals("standard")) {
                return root;
            }
        }
        CollationTailoring t = new CollationTailoring(root.settings);
        t.actualLocale = actualLocale;
        UResourceBundle binary = data.get("%%CollationBin");
        ByteBuffer inBytes = binary.getBinary();
        try {
            CollationDataReader.read(root, inBytes, t);
        }
        catch (IOException e) {
            throw new ICUUncheckedIOException("Failed to load collation tailoring data for locale:" + actualLocale + " type:" + type, e);
        }
        try {
            t.setRulesResource(data.get("Sequence"));
        }
        catch (MissingResourceException e) {
            // empty catch block
        }
        if (!type.equals(defaultType)) {
            outValidLocale.value = validLocale.setKeywordValue("collation", type);
        }
        if (!actualLocale.equals(validLocale) && (defT = ((ICUResourceBundle)(actualBundle = UResourceBundle.getBundleInstance("android/icu/impl/data/icudt58b/coll", actualLocale))).findStringWithFallback("collations/default")) != null) {
            defaultType = defT;
        }
        if (!type.equals(defaultType)) {
            t.actualLocale = t.actualLocale.setKeywordValue("collation", type);
        }
        return t;
    }

    static void __staticInitializer__() {
        rootRules = null;
    }

    private void __constructor__() {
        this.$$robo$$android_icu_impl_coll_CollationLoader$__constructor__();
    }

    public CollationLoader() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_coll_CollationLoader$__constructor__(), this);
    }

    private static void loadRootRules() {
        InvokeDynamicSupport.bootstrapStatic("loadRootRules", $$robo$$android_icu_impl_coll_CollationLoader$loadRootRules());
    }

    public static String getRootRules() {
        return InvokeDynamicSupport.bootstrapStatic("getRootRules", $$robo$$android_icu_impl_coll_CollationLoader$getRootRules());
    }

    static String loadRules(ULocale uLocale, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("loadRules", $$robo$$android_icu_impl_coll_CollationLoader$loadRules(android.icu.util.ULocale java.lang.String ), (ULocale)uLocale, (String)string2);
    }

    private static UResourceBundle findWithFallback(UResourceBundle uResourceBundle, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("findWithFallback", $$robo$$android_icu_impl_coll_CollationLoader$findWithFallback(android.icu.util.UResourceBundle java.lang.String ), (UResourceBundle)uResourceBundle, (String)string2);
    }

    public static CollationTailoring loadTailoring(ULocale uLocale, Output<ULocale> output) {
        return InvokeDynamicSupport.bootstrapStatic("loadTailoring", $$robo$$android_icu_impl_coll_CollationLoader$loadTailoring(android.icu.util.ULocale android.icu.util.Output<android.icu.util.ULocale> ), (ULocale)uLocale, output);
    }

    static {
        RobolectricInternals.classInitializing(CollationLoader.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CollationLoader)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class ASCII
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;

        private void $$robo$$android_icu_impl_coll_CollationLoader_ASCII$__constructor__() {
        }

        private static final String $$robo$$android_icu_impl_coll_CollationLoader_ASCII$toLowerCase(String s) {
            for (int i = 0; i < s.length(); ++i) {
                char c = s.charAt(i);
                if ('A' > c || c > 'Z') continue;
                StringBuilder sb = new StringBuilder(s.length());
                sb.append(s, 0, i).append((char)(c + 32));
                while (++i < s.length()) {
                    c = s.charAt(i);
                    if ('A' <= c && c <= 'Z') {
                        c = (char)(c + 32);
                    }
                    sb.append(c);
                }
                return sb.toString();
            }
            return s;
        }

        private void __constructor__() {
            this.$$robo$$android_icu_impl_coll_CollationLoader_ASCII$__constructor__();
        }

        public ASCII() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_coll_CollationLoader_ASCII$__constructor__(), this);
        }

        static String toLowerCase(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("toLowerCase", $$robo$$android_icu_impl_coll_CollationLoader_ASCII$toLowerCase(java.lang.String ), (String)string2);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ASCII)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

