/*
 * Decompiled with CFR 0.152.
 */
package android.icu.text;

import android.icu.impl.Assert;
import android.icu.impl.ICUBinary;
import android.icu.impl.ICULocaleService;
import android.icu.impl.ICUResourceBundle;
import android.icu.impl.ICUService;
import android.icu.text.BreakIterator;
import android.icu.text.FilteredBreakIteratorBuilder;
import android.icu.text.RuleBasedBreakIterator;
import android.icu.util.ULocale;
import com.google.errorprone.annotations.DoNotMock;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.text.StringCharacterIterator;
import java.util.Locale;
import java.util.MissingResourceException;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class BreakIteratorFactory
extends BreakIterator.BreakIteratorServiceShim
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    static ICULocaleService service;
    private static String[] KIND_NAMES;

    private void $$robo$$android_icu_text_BreakIteratorFactory$__constructor__() {
    }

    private final Object $$robo$$android_icu_text_BreakIteratorFactory$registerInstance(BreakIterator iter, ULocale locale, int kind) {
        iter.setText(new StringCharacterIterator(""));
        return service.registerObject((Object)iter, locale, kind);
    }

    private final boolean $$robo$$android_icu_text_BreakIteratorFactory$unregister(Object key) {
        if (service.isDefault()) {
            return false;
        }
        return service.unregisterFactory((ICUService.Factory)key);
    }

    private final Locale[] $$robo$$android_icu_text_BreakIteratorFactory$getAvailableLocales() {
        if (service == null) {
            return ICUResourceBundle.getAvailableLocales();
        }
        return service.getAvailableLocales();
    }

    private final ULocale[] $$robo$$android_icu_text_BreakIteratorFactory$getAvailableULocales() {
        if (service == null) {
            return ICUResourceBundle.getAvailableULocales();
        }
        return service.getAvailableULocales();
    }

    private final BreakIterator $$robo$$android_icu_text_BreakIteratorFactory$createBreakIterator(ULocale locale, int kind) {
        if (service.isDefault()) {
            return BreakIteratorFactory.createBreakInstance(locale, kind);
        }
        ULocale[] actualLoc = new ULocale[1];
        BreakIterator iter = (BreakIterator)service.get(locale, kind, actualLoc);
        iter.setLocale(actualLoc[0], actualLoc[0]);
        return iter;
    }

    private static final BreakIterator $$robo$$android_icu_text_BreakIteratorFactory$createBreakInstance(ULocale locale, int kind) {
        String ssKeyword;
        String lbKeyValue;
        RuleBasedBreakIterator iter = null;
        ICUResourceBundle rb = ICUResourceBundle.getBundleInstance("android/icu/impl/data/icudt58b/brkitr", locale, ICUResourceBundle.OpenType.LOCALE_ROOT);
        ByteBuffer bytes = null;
        String typeKeyExt = null;
        if (kind == 2 && (lbKeyValue = locale.getKeywordValue("lb")) != null && (lbKeyValue.equals("strict") || lbKeyValue.equals("normal") || lbKeyValue.equals("loose"))) {
            typeKeyExt = "_" + lbKeyValue;
        }
        try {
            String typeKey = typeKeyExt == null ? KIND_NAMES[kind] : KIND_NAMES[kind] + typeKeyExt;
            String brkfname = rb.getStringWithFallback("boundaries/" + typeKey);
            String rulesFileName = "brkitr/" + brkfname;
            bytes = ICUBinary.getData(rulesFileName);
        }
        catch (Exception e) {
            throw new MissingResourceException(e.toString(), "", "");
        }
        try {
            iter = RuleBasedBreakIterator.getInstanceFromCompiledRules(bytes);
        }
        catch (IOException e) {
            Assert.fail(e);
        }
        ULocale uloc = ULocale.forLocale(rb.getLocale());
        iter.setLocale(uloc, uloc);
        iter.setBreakType(kind);
        if (kind == 3 && (ssKeyword = locale.getKeywordValue("ss")) != null && ssKeyword.equals("standard")) {
            ULocale base = new ULocale(locale.getBaseName());
            return FilteredBreakIteratorBuilder.createInstance(base).build(iter);
        }
        return iter;
    }

    static void __staticInitializer__() {
        service = new BFService();
        KIND_NAMES = new String[]{"grapheme", "word", "line", "sentence", "title"};
    }

    private void __constructor__() {
        this.$$robo$$android_icu_text_BreakIteratorFactory$__constructor__();
    }

    public BreakIteratorFactory() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_BreakIteratorFactory$__constructor__(), this);
    }

    @Override
    public Object registerInstance(BreakIterator breakIterator, ULocale uLocale, int n) {
        return InvokeDynamicSupport.bootstrap("registerInstance", $$robo$$android_icu_text_BreakIteratorFactory$registerInstance(android.icu.text.BreakIterator android.icu.util.ULocale int ), this, breakIterator, uLocale, n);
    }

    @Override
    public boolean unregister(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("unregister", $$robo$$android_icu_text_BreakIteratorFactory$unregister(java.lang.Object ), this, object);
    }

    @Override
    public Locale[] getAvailableLocales() {
        return InvokeDynamicSupport.bootstrap("getAvailableLocales", $$robo$$android_icu_text_BreakIteratorFactory$getAvailableLocales(), this);
    }

    @Override
    public ULocale[] getAvailableULocales() {
        return InvokeDynamicSupport.bootstrap("getAvailableULocales", $$robo$$android_icu_text_BreakIteratorFactory$getAvailableULocales(), this);
    }

    @Override
    public BreakIterator createBreakIterator(ULocale uLocale, int n) {
        return InvokeDynamicSupport.bootstrap("createBreakIterator", $$robo$$android_icu_text_BreakIteratorFactory$createBreakIterator(android.icu.util.ULocale int ), this, uLocale, n);
    }

    private static BreakIterator createBreakInstance(ULocale uLocale, int n) {
        return InvokeDynamicSupport.bootstrapStatic("createBreakInstance", $$robo$$android_icu_text_BreakIteratorFactory$createBreakInstance(android.icu.util.ULocale int ), (ULocale)uLocale, (int)n);
    }

    static {
        RobolectricInternals.classInitializing(BreakIteratorFactory.class);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BreakIteratorFactory)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class BFService
    extends ICULocaleService
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;

        private void $$robo$$android_icu_text_BreakIteratorFactory_BFService$__constructor__() {
            public class RBBreakIteratorFactory
            extends ICULocaleService.ICUResourceBundleFactory
            implements ShadowedObject {
                public /* synthetic */ Object __robo_data__;
                /* synthetic */ BFService this$0;

                private void $$robo$$android_icu_text_BreakIteratorFactory_BFService_1RBBreakIteratorFactory$__constructor__(BFService this$0) {
                }

                private final Object $$robo$$android_icu_text_BreakIteratorFactory_BFService_1RBBreakIteratorFactory$handleCreate(ULocale loc, int kind, ICUService srvc) {
                    return BreakIteratorFactory.createBreakInstance(loc, kind);
                }

                private void __constructor__(BFService bFService) {
                    this.$$robo$$android_icu_text_BreakIteratorFactory_BFService_1RBBreakIteratorFactory$__constructor__(bFService);
                }

                public RBBreakIteratorFactory(BFService bFService) {
                    this.this$0 = bFService;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_BreakIteratorFactory_BFService_1RBBreakIteratorFactory$__constructor__(android.icu.text.BreakIteratorFactory$BFService ), this, bFService);
                }

                @Override
                protected Object handleCreate(ULocale uLocale, int n, ICUService iCUService) {
                    return InvokeDynamicSupport.bootstrap("handleCreate", $$robo$$android_icu_text_BreakIteratorFactory_BFService_1RBBreakIteratorFactory$handleCreate(android.icu.util.ULocale int android.icu.impl.ICUService ), this, uLocale, n, iCUService);
                }

                public /* synthetic */ RBBreakIteratorFactory() {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RBBreakIteratorFactory)this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            }
            this.registerFactory(new RBBreakIteratorFactory(this));
            this.markDefault();
        }

        private final String $$robo$$android_icu_text_BreakIteratorFactory_BFService$validateFallbackLocale() {
            return "";
        }

        private void __constructor__() {
            this.$$robo$$android_icu_text_BreakIteratorFactory_BFService$__constructor__();
        }

        public BFService() {
            super("BreakIterator");
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_BreakIteratorFactory_BFService$__constructor__(), this);
        }

        @Override
        public String validateFallbackLocale() {
            return InvokeDynamicSupport.bootstrap("validateFallbackLocale", $$robo$$android_icu_text_BreakIteratorFactory_BFService$validateFallbackLocale(), this);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BFService)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

