/*
 * Decompiled with CFR 0.152.
 */
package android.icu.text;

import android.icu.impl.CurrencyData;
import android.icu.text.NumberFormat;
import android.icu.text.PluralRules;
import android.icu.util.ICUCloneNotSupportedException;
import android.icu.util.ULocale;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class CurrencyPluralInfo
implements Cloneable,
Serializable,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static long serialVersionUID = 1L;
    private static char[] tripleCurrencySign;
    private static String tripleCurrencyStr;
    private static char[] defaultCurrencyPluralPatternChar;
    private static String defaultCurrencyPluralPattern;
    private Map<String, String> pluralCountToCurrencyUnitPattern;
    private PluralRules pluralRules;
    private ULocale ulocale;
    static /* synthetic */ boolean $assertionsDisabled;

    private void $$robo$$android_icu_text_CurrencyPluralInfo$__constructor__() {
        this.pluralCountToCurrencyUnitPattern = null;
        this.pluralRules = null;
        this.ulocale = null;
        this.initialize(ULocale.getDefault(ULocale.Category.FORMAT));
    }

    private void $$robo$$android_icu_text_CurrencyPluralInfo$__constructor__(Locale locale) {
        this.pluralCountToCurrencyUnitPattern = null;
        this.pluralRules = null;
        this.ulocale = null;
        this.initialize(ULocale.forLocale(locale));
    }

    private void $$robo$$android_icu_text_CurrencyPluralInfo$__constructor__(ULocale locale) {
        this.pluralCountToCurrencyUnitPattern = null;
        this.pluralRules = null;
        this.ulocale = null;
        this.initialize(locale);
    }

    private static final CurrencyPluralInfo $$robo$$android_icu_text_CurrencyPluralInfo$getInstance() {
        return new CurrencyPluralInfo();
    }

    private static final CurrencyPluralInfo $$robo$$android_icu_text_CurrencyPluralInfo$getInstance(Locale locale) {
        return new CurrencyPluralInfo(locale);
    }

    private static final CurrencyPluralInfo $$robo$$android_icu_text_CurrencyPluralInfo$getInstance(ULocale locale) {
        return new CurrencyPluralInfo(locale);
    }

    private final PluralRules $$robo$$android_icu_text_CurrencyPluralInfo$getPluralRules() {
        return this.pluralRules;
    }

    private final String $$robo$$android_icu_text_CurrencyPluralInfo$getCurrencyPluralPattern(String pluralCount) {
        String currencyPluralPattern = this.pluralCountToCurrencyUnitPattern.get(pluralCount);
        if (currencyPluralPattern == null) {
            if (!pluralCount.equals("other")) {
                currencyPluralPattern = this.pluralCountToCurrencyUnitPattern.get("other");
            }
            if (currencyPluralPattern == null) {
                currencyPluralPattern = defaultCurrencyPluralPattern;
            }
        }
        return currencyPluralPattern;
    }

    private final ULocale $$robo$$android_icu_text_CurrencyPluralInfo$getLocale() {
        return this.ulocale;
    }

    private final void $$robo$$android_icu_text_CurrencyPluralInfo$setPluralRules(String ruleDescription) {
        this.pluralRules = PluralRules.createRules(ruleDescription);
    }

    private final void $$robo$$android_icu_text_CurrencyPluralInfo$setCurrencyPluralPattern(String pluralCount, String pattern) {
        this.pluralCountToCurrencyUnitPattern.put(pluralCount, pattern);
    }

    private final void $$robo$$android_icu_text_CurrencyPluralInfo$setLocale(ULocale loc) {
        this.ulocale = loc;
        this.initialize(loc);
    }

    private final Object $$robo$$android_icu_text_CurrencyPluralInfo$clone() {
        try {
            CurrencyPluralInfo other = (CurrencyPluralInfo)super.clone();
            other.ulocale = (ULocale)this.ulocale.clone();
            other.pluralCountToCurrencyUnitPattern = new HashMap<String, String>();
            for (String pluralCount : this.pluralCountToCurrencyUnitPattern.keySet()) {
                String currencyPattern = this.pluralCountToCurrencyUnitPattern.get(pluralCount);
                other.pluralCountToCurrencyUnitPattern.put(pluralCount, currencyPattern);
            }
            return other;
        }
        catch (CloneNotSupportedException e) {
            throw new ICUCloneNotSupportedException(e);
        }
    }

    private final boolean $$robo$$android_icu_text_CurrencyPluralInfo$equals(Object a) {
        if (a instanceof CurrencyPluralInfo) {
            CurrencyPluralInfo other = (CurrencyPluralInfo)a;
            return this.pluralRules.equals(other.pluralRules) && this.pluralCountToCurrencyUnitPattern.equals(other.pluralCountToCurrencyUnitPattern);
        }
        return false;
    }

    @Deprecated
    private final int $$robo$$android_icu_text_CurrencyPluralInfo$hashCode() {
        if (!$assertionsDisabled) {
            throw new AssertionError((Object)"hashCode not designed");
        }
        return 42;
    }

    @Deprecated
    private final String $$robo$$android_icu_text_CurrencyPluralInfo$select(double number) {
        return this.pluralRules.select(number);
    }

    @Deprecated
    private final String $$robo$$android_icu_text_CurrencyPluralInfo$select(PluralRules.FixedDecimal numberInfo) {
        return this.pluralRules.select(numberInfo);
    }

    private final Iterator<String> $$robo$$android_icu_text_CurrencyPluralInfo$pluralPatternIterator() {
        return this.pluralCountToCurrencyUnitPattern.keySet().iterator();
    }

    private final void $$robo$$android_icu_text_CurrencyPluralInfo$initialize(ULocale uloc) {
        this.ulocale = uloc;
        this.pluralRules = PluralRules.forLocale(uloc);
        this.setupCurrencyPluralPattern(uloc);
    }

    private final void $$robo$$android_icu_text_CurrencyPluralInfo$setupCurrencyPluralPattern(ULocale uloc) {
        this.pluralCountToCurrencyUnitPattern = new HashMap<String, String>();
        String numberStylePattern = NumberFormat.getPattern(uloc, 0);
        int separatorIndex = numberStylePattern.indexOf(";");
        String negNumberPattern = null;
        if (separatorIndex != -1) {
            negNumberPattern = numberStylePattern.substring(separatorIndex + 1);
            numberStylePattern = numberStylePattern.substring(0, separatorIndex);
        }
        Map<String, String> map = CurrencyData.provider.getInstance(uloc, true).getUnitPatterns();
        for (Map.Entry<String, String> e : map.entrySet()) {
            String pluralCount = e.getKey();
            String pattern = e.getValue();
            String patternWithNumber = pattern.replace("{0}", numberStylePattern);
            String patternWithCurrencySign = patternWithNumber.replace("{1}", tripleCurrencyStr);
            if (separatorIndex != -1) {
                String negPattern = pattern;
                String negWithNumber = negPattern.replace("{0}", negNumberPattern);
                String negWithCurrSign = negWithNumber.replace("{1}", tripleCurrencyStr);
                StringBuilder posNegPatterns = new StringBuilder(patternWithCurrencySign);
                posNegPatterns.append(";");
                posNegPatterns.append(negWithCurrSign);
                patternWithCurrencySign = posNegPatterns.toString();
            }
            this.pluralCountToCurrencyUnitPattern.put(pluralCount, patternWithCurrencySign);
        }
    }

    static void __staticInitializer__() {
        $assertionsDisabled = !CurrencyPluralInfo.class.desiredAssertionStatus();
        tripleCurrencySign = new char[]{'\u00a4', '\u00a4', '\u00a4'};
        tripleCurrencyStr = new String(tripleCurrencySign);
        defaultCurrencyPluralPatternChar = new char[]{'\u0000', '.', '#', '#', ' ', '\u00a4', '\u00a4', '\u00a4'};
        defaultCurrencyPluralPattern = new String(defaultCurrencyPluralPatternChar);
    }

    private void __constructor__() {
        this.$$robo$$android_icu_text_CurrencyPluralInfo$__constructor__();
    }

    public CurrencyPluralInfo() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_CurrencyPluralInfo$__constructor__(), this);
    }

    private void __constructor__(Locale locale) {
        this.$$robo$$android_icu_text_CurrencyPluralInfo$__constructor__(locale);
    }

    public CurrencyPluralInfo(Locale locale) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_CurrencyPluralInfo$__constructor__(java.util.Locale ), this, locale);
    }

    private void __constructor__(ULocale uLocale) {
        this.$$robo$$android_icu_text_CurrencyPluralInfo$__constructor__(uLocale);
    }

    public CurrencyPluralInfo(ULocale uLocale) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_CurrencyPluralInfo$__constructor__(android.icu.util.ULocale ), this, uLocale);
    }

    public static CurrencyPluralInfo getInstance() {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$android_icu_text_CurrencyPluralInfo$getInstance());
    }

    public static CurrencyPluralInfo getInstance(Locale locale) {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$android_icu_text_CurrencyPluralInfo$getInstance(java.util.Locale ), (Locale)locale);
    }

    public static CurrencyPluralInfo getInstance(ULocale uLocale) {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$android_icu_text_CurrencyPluralInfo$getInstance(android.icu.util.ULocale ), (ULocale)uLocale);
    }

    public PluralRules getPluralRules() {
        return InvokeDynamicSupport.bootstrap("getPluralRules", $$robo$$android_icu_text_CurrencyPluralInfo$getPluralRules(), this);
    }

    public String getCurrencyPluralPattern(String string2) {
        return InvokeDynamicSupport.bootstrap("getCurrencyPluralPattern", $$robo$$android_icu_text_CurrencyPluralInfo$getCurrencyPluralPattern(java.lang.String ), this, string2);
    }

    public ULocale getLocale() {
        return InvokeDynamicSupport.bootstrap("getLocale", $$robo$$android_icu_text_CurrencyPluralInfo$getLocale(), this);
    }

    public void setPluralRules(String string2) {
        InvokeDynamicSupport.bootstrap("setPluralRules", $$robo$$android_icu_text_CurrencyPluralInfo$setPluralRules(java.lang.String ), this, string2);
    }

    public void setCurrencyPluralPattern(String string2, String string3) {
        InvokeDynamicSupport.bootstrap("setCurrencyPluralPattern", $$robo$$android_icu_text_CurrencyPluralInfo$setCurrencyPluralPattern(java.lang.String java.lang.String ), this, string2, string3);
    }

    public void setLocale(ULocale uLocale) {
        InvokeDynamicSupport.bootstrap("setLocale", $$robo$$android_icu_text_CurrencyPluralInfo$setLocale(android.icu.util.ULocale ), this, uLocale);
    }

    public Object clone() {
        return InvokeDynamicSupport.bootstrap("clone", $$robo$$android_icu_text_CurrencyPluralInfo$clone(), this);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_icu_text_CurrencyPluralInfo$equals(java.lang.Object ), this, object);
    }

    @Deprecated
    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_icu_text_CurrencyPluralInfo$hashCode(), this);
    }

    @Deprecated
    String select(double d) {
        return InvokeDynamicSupport.bootstrap("select", $$robo$$android_icu_text_CurrencyPluralInfo$select(double ), this, d);
    }

    @Deprecated
    String select(PluralRules.FixedDecimal fixedDecimal) {
        return InvokeDynamicSupport.bootstrap("select", $$robo$$android_icu_text_CurrencyPluralInfo$select(android.icu.text.PluralRules$FixedDecimal ), this, fixedDecimal);
    }

    Iterator<String> pluralPatternIterator() {
        return InvokeDynamicSupport.bootstrap("pluralPatternIterator", $$robo$$android_icu_text_CurrencyPluralInfo$pluralPatternIterator(), this);
    }

    private void initialize(ULocale uLocale) {
        InvokeDynamicSupport.bootstrap("initialize", $$robo$$android_icu_text_CurrencyPluralInfo$initialize(android.icu.util.ULocale ), this, uLocale);
    }

    private void setupCurrencyPluralPattern(ULocale uLocale) {
        InvokeDynamicSupport.bootstrap("setupCurrencyPluralPattern", $$robo$$android_icu_text_CurrencyPluralInfo$setupCurrencyPluralPattern(android.icu.util.ULocale ), this, uLocale);
    }

    static {
        RobolectricInternals.classInitializing(CurrencyPluralInfo.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CurrencyPluralInfo)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

