/*
 * Decompiled with CFR 0.152.
 */
package android.icu.text;

import android.icu.impl.ICUResourceBundle;
import android.icu.impl.RelativeDateFormat;
import android.icu.text.DateTimePatternGenerator;
import android.icu.text.DisplayContext;
import android.icu.text.NumberFormat;
import android.icu.text.SimpleDateFormat;
import android.icu.text.UFormat;
import android.icu.util.Calendar;
import android.icu.util.GregorianCalendar;
import android.icu.util.TimeZone;
import android.icu.util.ULocale;
import com.google.errorprone.annotations.DoNotMock;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Arrays;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class DateFormat
extends UFormat
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    protected Calendar calendar;
    protected NumberFormat numberFormat;
    public static int ERA_FIELD = 0;
    public static int YEAR_FIELD = 1;
    public static int MONTH_FIELD = 2;
    public static int DATE_FIELD = 3;
    public static int HOUR_OF_DAY1_FIELD = 4;
    public static int HOUR_OF_DAY0_FIELD = 5;
    public static int MINUTE_FIELD = 6;
    public static int SECOND_FIELD = 7;
    public static int FRACTIONAL_SECOND_FIELD = 8;
    public static int MILLISECOND_FIELD = 8;
    public static int DAY_OF_WEEK_FIELD = 9;
    public static int DAY_OF_YEAR_FIELD = 10;
    public static int DAY_OF_WEEK_IN_MONTH_FIELD = 11;
    public static int WEEK_OF_YEAR_FIELD = 12;
    public static int WEEK_OF_MONTH_FIELD = 13;
    public static int AM_PM_FIELD = 14;
    public static int HOUR1_FIELD = 15;
    public static int HOUR0_FIELD = 16;
    public static int TIMEZONE_FIELD = 17;
    public static int YEAR_WOY_FIELD = 18;
    public static int DOW_LOCAL_FIELD = 19;
    public static int EXTENDED_YEAR_FIELD = 20;
    public static int JULIAN_DAY_FIELD = 21;
    public static int MILLISECONDS_IN_DAY_FIELD = 22;
    public static int TIMEZONE_RFC_FIELD = 23;
    public static int TIMEZONE_GENERIC_FIELD = 24;
    public static int STANDALONE_DAY_FIELD = 25;
    public static int STANDALONE_MONTH_FIELD = 26;
    public static int QUARTER_FIELD = 27;
    public static int STANDALONE_QUARTER_FIELD = 28;
    public static int TIMEZONE_SPECIAL_FIELD = 29;
    public static int YEAR_NAME_FIELD = 30;
    public static int TIMEZONE_LOCALIZED_GMT_OFFSET_FIELD = 31;
    public static int TIMEZONE_ISO_FIELD = 32;
    public static int TIMEZONE_ISO_LOCAL_FIELD = 33;
    @Deprecated
    static int RELATED_YEAR = 34;
    static int AM_PM_MIDNIGHT_NOON_FIELD = 35;
    static int FLEXIBLE_DAY_PERIOD_FIELD = 36;
    @Deprecated
    public static int TIME_SEPARATOR = 37;
    @Deprecated
    public static int FIELD_COUNT = 38;
    private EnumSet<BooleanAttribute> booleanAttributes;
    private DisplayContext capitalizationSetting;
    static int currentSerialVersion = 1;
    private int serialVersionOnStream;
    private static long serialVersionUID = 7218322306649953788L;
    public static int NONE = -1;
    public static int FULL = 0;
    public static int LONG = 1;
    public static int MEDIUM = 2;
    public static int SHORT = 3;
    public static int DEFAULT = 2;
    public static int RELATIVE = 128;
    public static int RELATIVE_FULL = 128;
    public static int RELATIVE_LONG = 129;
    public static int RELATIVE_MEDIUM = 130;
    public static int RELATIVE_SHORT = 131;
    public static int RELATIVE_DEFAULT = 130;
    public static String YEAR = "y";
    public static String QUARTER = "QQQQ";
    public static String ABBR_QUARTER = "QQQ";
    public static String YEAR_QUARTER = "yQQQQ";
    public static String YEAR_ABBR_QUARTER = "yQQQ";
    public static String MONTH = "MMMM";
    public static String ABBR_MONTH = "MMM";
    public static String NUM_MONTH = "M";
    public static String YEAR_MONTH = "yMMMM";
    public static String YEAR_ABBR_MONTH = "yMMM";
    public static String YEAR_NUM_MONTH = "yM";
    public static String DAY = "d";
    public static String YEAR_MONTH_DAY = "yMMMMd";
    public static String YEAR_ABBR_MONTH_DAY = "yMMMd";
    public static String YEAR_NUM_MONTH_DAY = "yMd";
    public static String WEEKDAY = "EEEE";
    public static String ABBR_WEEKDAY = "E";
    public static String YEAR_MONTH_WEEKDAY_DAY = "yMMMMEEEEd";
    public static String YEAR_ABBR_MONTH_WEEKDAY_DAY = "yMMMEd";
    public static String YEAR_NUM_MONTH_WEEKDAY_DAY = "yMEd";
    public static String MONTH_DAY = "MMMMd";
    public static String ABBR_MONTH_DAY = "MMMd";
    public static String NUM_MONTH_DAY = "Md";
    public static String MONTH_WEEKDAY_DAY = "MMMMEEEEd";
    public static String ABBR_MONTH_WEEKDAY_DAY = "MMMEd";
    public static String NUM_MONTH_WEEKDAY_DAY = "MEd";
    @Deprecated
    public static List<String> DATE_SKELETONS;
    public static String HOUR = "j";
    public static String HOUR24 = "H";
    public static String MINUTE = "m";
    public static String HOUR_MINUTE = "jm";
    public static String HOUR24_MINUTE = "Hm";
    public static String SECOND = "s";
    public static String HOUR_MINUTE_SECOND = "jms";
    public static String HOUR24_MINUTE_SECOND = "Hms";
    public static String MINUTE_SECOND = "ms";
    @Deprecated
    public static List<String> TIME_SKELETONS;
    public static String LOCATION_TZ = "VVVV";
    public static String GENERIC_TZ = "vvvv";
    public static String ABBR_GENERIC_TZ = "v";
    public static String SPECIFIC_TZ = "zzzz";
    public static String ABBR_SPECIFIC_TZ = "z";
    public static String ABBR_UTC_TZ = "ZZZZ";
    @Deprecated
    public static List<String> ZONE_SKELETONS;
    @Deprecated
    public static String STANDALONE_MONTH = "LLLL";
    @Deprecated
    public static String ABBR_STANDALONE_MONTH = "LLL";
    @Deprecated
    public static String HOUR_MINUTE_GENERIC_TZ = "jmv";
    @Deprecated
    public static String HOUR_MINUTE_TZ = "jmz";
    @Deprecated
    public static String HOUR_GENERIC_TZ = "jv";
    @Deprecated
    public static String HOUR_TZ = "jz";

    private final StringBuffer $$robo$$android_icu_text_DateFormat$format(Object obj, StringBuffer toAppendTo, FieldPosition fieldPosition) {
        if (obj instanceof Calendar) {
            return this.format((Calendar)obj, toAppendTo, fieldPosition);
        }
        if (obj instanceof Date) {
            return this.format((Date)obj, toAppendTo, fieldPosition);
        }
        if (obj instanceof Number) {
            return this.format(new Date(((Number)obj).longValue()), toAppendTo, fieldPosition);
        }
        throw new IllegalArgumentException("Cannot format given Object (" + obj.getClass().getName() + ") as a Date");
    }

    public abstract StringBuffer format(Calendar var1, StringBuffer var2, FieldPosition var3);

    private final StringBuffer $$robo$$android_icu_text_DateFormat$format(Date date, StringBuffer toAppendTo, FieldPosition fieldPosition) {
        this.calendar.setTime(date);
        return this.format(this.calendar, toAppendTo, fieldPosition);
    }

    private final String $$robo$$android_icu_text_DateFormat$format(Date date) {
        return this.format(date, new StringBuffer(64), new FieldPosition(0)).toString();
    }

    private final Date $$robo$$android_icu_text_DateFormat$parse(String text) throws ParseException {
        ParsePosition pos = new ParsePosition(0);
        Date result = this.parse(text, pos);
        if (pos.getIndex() == 0) {
            throw new ParseException("Unparseable date: \"" + text + "\"", pos.getErrorIndex());
        }
        return result;
    }

    public abstract void parse(String var1, Calendar var2, ParsePosition var3);

    private final Date $$robo$$android_icu_text_DateFormat$parse(String text, ParsePosition pos) {
        Date result = null;
        int start = pos.getIndex();
        TimeZone tzsav = this.calendar.getTimeZone();
        this.calendar.clear();
        this.parse(text, this.calendar, pos);
        if (pos.getIndex() != start) {
            try {
                result = this.calendar.getTime();
            }
            catch (IllegalArgumentException e) {
                pos.setIndex(start);
                pos.setErrorIndex(start);
            }
        }
        this.calendar.setTimeZone(tzsav);
        return result;
    }

    private final Object $$robo$$android_icu_text_DateFormat$parseObject(String source, ParsePosition pos) {
        return this.parse(source, pos);
    }

    private static final DateFormat $$robo$$android_icu_text_DateFormat$getTimeInstance() {
        return DateFormat.get(-1, 2, ULocale.getDefault(ULocale.Category.FORMAT), null);
    }

    private static final DateFormat $$robo$$android_icu_text_DateFormat$getTimeInstance(int style2) {
        return DateFormat.get(-1, style2, ULocale.getDefault(ULocale.Category.FORMAT), null);
    }

    private static final DateFormat $$robo$$android_icu_text_DateFormat$getTimeInstance(int style2, Locale aLocale) {
        return DateFormat.get(-1, style2, ULocale.forLocale(aLocale), null);
    }

    private static final DateFormat $$robo$$android_icu_text_DateFormat$getTimeInstance(int style2, ULocale locale) {
        return DateFormat.get(-1, style2, locale, null);
    }

    private static final DateFormat $$robo$$android_icu_text_DateFormat$getDateInstance() {
        return DateFormat.get(2, -1, ULocale.getDefault(ULocale.Category.FORMAT), null);
    }

    private static final DateFormat $$robo$$android_icu_text_DateFormat$getDateInstance(int style2) {
        return DateFormat.get(style2, -1, ULocale.getDefault(ULocale.Category.FORMAT), null);
    }

    private static final DateFormat $$robo$$android_icu_text_DateFormat$getDateInstance(int style2, Locale aLocale) {
        return DateFormat.get(style2, -1, ULocale.forLocale(aLocale), null);
    }

    private static final DateFormat $$robo$$android_icu_text_DateFormat$getDateInstance(int style2, ULocale locale) {
        return DateFormat.get(style2, -1, locale, null);
    }

    private static final DateFormat $$robo$$android_icu_text_DateFormat$getDateTimeInstance() {
        return DateFormat.get(2, 2, ULocale.getDefault(ULocale.Category.FORMAT), null);
    }

    private static final DateFormat $$robo$$android_icu_text_DateFormat$getDateTimeInstance(int dateStyle, int timeStyle) {
        return DateFormat.get(dateStyle, timeStyle, ULocale.getDefault(ULocale.Category.FORMAT), null);
    }

    private static final DateFormat $$robo$$android_icu_text_DateFormat$getDateTimeInstance(int dateStyle, int timeStyle, Locale aLocale) {
        return DateFormat.get(dateStyle, timeStyle, ULocale.forLocale(aLocale), null);
    }

    private static final DateFormat $$robo$$android_icu_text_DateFormat$getDateTimeInstance(int dateStyle, int timeStyle, ULocale locale) {
        return DateFormat.get(dateStyle, timeStyle, locale, null);
    }

    private static final DateFormat $$robo$$android_icu_text_DateFormat$getInstance() {
        return DateFormat.getDateTimeInstance(3, 3);
    }

    private static final Locale[] $$robo$$android_icu_text_DateFormat$getAvailableLocales() {
        return ICUResourceBundle.getAvailableLocales();
    }

    private static final ULocale[] $$robo$$android_icu_text_DateFormat$getAvailableULocales() {
        return ICUResourceBundle.getAvailableULocales();
    }

    private final void $$robo$$android_icu_text_DateFormat$setCalendar(Calendar newCalendar) {
        this.calendar = newCalendar;
    }

    private final Calendar $$robo$$android_icu_text_DateFormat$getCalendar() {
        return this.calendar;
    }

    private final void $$robo$$android_icu_text_DateFormat$setNumberFormat(NumberFormat newNumberFormat) {
        this.numberFormat = newNumberFormat;
        this.numberFormat.setParseIntegerOnly(true);
    }

    private final NumberFormat $$robo$$android_icu_text_DateFormat$getNumberFormat() {
        return this.numberFormat;
    }

    private final void $$robo$$android_icu_text_DateFormat$setTimeZone(TimeZone zone) {
        this.calendar.setTimeZone(zone);
    }

    private final TimeZone $$robo$$android_icu_text_DateFormat$getTimeZone() {
        return this.calendar.getTimeZone();
    }

    private final void $$robo$$android_icu_text_DateFormat$setLenient(boolean lenient) {
        this.calendar.setLenient(lenient);
        this.setBooleanAttribute(BooleanAttribute.PARSE_ALLOW_NUMERIC, lenient);
        this.setBooleanAttribute(BooleanAttribute.PARSE_ALLOW_WHITESPACE, lenient);
    }

    private final boolean $$robo$$android_icu_text_DateFormat$isLenient() {
        return this.calendar.isLenient() && this.getBooleanAttribute(BooleanAttribute.PARSE_ALLOW_NUMERIC) && this.getBooleanAttribute(BooleanAttribute.PARSE_ALLOW_WHITESPACE);
    }

    private final void $$robo$$android_icu_text_DateFormat$setCalendarLenient(boolean lenient) {
        this.calendar.setLenient(lenient);
    }

    private final boolean $$robo$$android_icu_text_DateFormat$isCalendarLenient() {
        return this.calendar.isLenient();
    }

    private final DateFormat $$robo$$android_icu_text_DateFormat$setBooleanAttribute(BooleanAttribute key, boolean value) {
        if (key.equals((Object)BooleanAttribute.PARSE_PARTIAL_MATCH)) {
            key = BooleanAttribute.PARSE_PARTIAL_LITERAL_MATCH;
        }
        if (value) {
            this.booleanAttributes.add(key);
        } else {
            this.booleanAttributes.remove((Object)key);
        }
        return this;
    }

    private final boolean $$robo$$android_icu_text_DateFormat$getBooleanAttribute(BooleanAttribute key) {
        if (key == BooleanAttribute.PARSE_PARTIAL_MATCH) {
            key = BooleanAttribute.PARSE_PARTIAL_LITERAL_MATCH;
        }
        return this.booleanAttributes.contains((Object)key);
    }

    private final void $$robo$$android_icu_text_DateFormat$setContext(DisplayContext context) {
        if (context.type() == DisplayContext.Type.CAPITALIZATION) {
            this.capitalizationSetting = context;
        }
    }

    private final DisplayContext $$robo$$android_icu_text_DateFormat$getContext(DisplayContext.Type type) {
        return type == DisplayContext.Type.CAPITALIZATION && this.capitalizationSetting != null ? this.capitalizationSetting : DisplayContext.CAPITALIZATION_NONE;
    }

    private final int $$robo$$android_icu_text_DateFormat$hashCode() {
        return this.numberFormat.hashCode();
    }

    private final boolean $$robo$$android_icu_text_DateFormat$equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DateFormat other = (DateFormat)obj;
        return (this.calendar == null && other.calendar == null || this.calendar != null && other.calendar != null && this.calendar.isEquivalentTo(other.calendar)) && (this.numberFormat == null && other.numberFormat == null || this.numberFormat != null && other.numberFormat != null && this.numberFormat.equals(other.numberFormat)) && this.capitalizationSetting == other.capitalizationSetting;
    }

    private final Object $$robo$$android_icu_text_DateFormat$clone() {
        DateFormat other = (DateFormat)super.clone();
        other.calendar = (Calendar)this.calendar.clone();
        if (this.numberFormat != null) {
            other.numberFormat = (NumberFormat)this.numberFormat.clone();
        }
        return other;
    }

    private static final DateFormat $$robo$$android_icu_text_DateFormat$get(int dateStyle, int timeStyle, ULocale loc, Calendar cal) {
        if (timeStyle != -1 && (timeStyle & 0x80) > 0 || dateStyle != -1 && (dateStyle & 0x80) > 0) {
            RelativeDateFormat r = new RelativeDateFormat(timeStyle, dateStyle, loc, cal);
            return r;
        }
        if (timeStyle < -1 || timeStyle > 3) {
            throw new IllegalArgumentException("Illegal time style " + timeStyle);
        }
        if (dateStyle < -1 || dateStyle > 3) {
            throw new IllegalArgumentException("Illegal date style " + dateStyle);
        }
        if (cal == null) {
            cal = Calendar.getInstance(loc);
        }
        try {
            DateFormat result = cal.getDateTimeFormat(dateStyle, timeStyle, loc);
            result.setLocale(cal.getLocale(ULocale.VALID_LOCALE), cal.getLocale(ULocale.ACTUAL_LOCALE));
            return result;
        }
        catch (MissingResourceException e) {
            return new SimpleDateFormat("M/d/yy h:mm a");
        }
    }

    private final void $$robo$$android_icu_text_DateFormat$readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        if (this.serialVersionOnStream < 1) {
            this.capitalizationSetting = DisplayContext.CAPITALIZATION_NONE;
        }
        if (this.booleanAttributes == null) {
            this.booleanAttributes = EnumSet.allOf(BooleanAttribute.class);
        }
        this.serialVersionOnStream = 1;
    }

    private void $$robo$$android_icu_text_DateFormat$__constructor__() {
        this.booleanAttributes = EnumSet.allOf(BooleanAttribute.class);
        this.capitalizationSetting = DisplayContext.CAPITALIZATION_NONE;
        this.serialVersionOnStream = 1;
    }

    private static final DateFormat $$robo$$android_icu_text_DateFormat$getDateInstance(Calendar cal, int dateStyle, Locale locale) {
        return DateFormat.getDateTimeInstance(cal, dateStyle, -1, ULocale.forLocale(locale));
    }

    private static final DateFormat $$robo$$android_icu_text_DateFormat$getDateInstance(Calendar cal, int dateStyle, ULocale locale) {
        return DateFormat.getDateTimeInstance(cal, dateStyle, -1, locale);
    }

    private static final DateFormat $$robo$$android_icu_text_DateFormat$getTimeInstance(Calendar cal, int timeStyle, Locale locale) {
        return DateFormat.getDateTimeInstance(cal, -1, timeStyle, ULocale.forLocale(locale));
    }

    private static final DateFormat $$robo$$android_icu_text_DateFormat$getTimeInstance(Calendar cal, int timeStyle, ULocale locale) {
        return DateFormat.getDateTimeInstance(cal, -1, timeStyle, locale);
    }

    private static final DateFormat $$robo$$android_icu_text_DateFormat$getDateTimeInstance(Calendar cal, int dateStyle, int timeStyle, Locale locale) {
        return DateFormat.getDateTimeInstance(dateStyle, timeStyle, ULocale.forLocale(locale));
    }

    private static final DateFormat $$robo$$android_icu_text_DateFormat$getDateTimeInstance(Calendar cal, int dateStyle, int timeStyle, ULocale locale) {
        if (cal == null) {
            throw new IllegalArgumentException("Calendar must be supplied");
        }
        return DateFormat.get(dateStyle, timeStyle, locale, cal);
    }

    private static final DateFormat $$robo$$android_icu_text_DateFormat$getInstance(Calendar cal, Locale locale) {
        return DateFormat.getDateTimeInstance(cal, 3, 3, ULocale.forLocale(locale));
    }

    private static final DateFormat $$robo$$android_icu_text_DateFormat$getInstance(Calendar cal, ULocale locale) {
        return DateFormat.getDateTimeInstance(cal, 3, 3, locale);
    }

    private static final DateFormat $$robo$$android_icu_text_DateFormat$getInstance(Calendar cal) {
        return DateFormat.getInstance(cal, ULocale.getDefault(ULocale.Category.FORMAT));
    }

    private static final DateFormat $$robo$$android_icu_text_DateFormat$getDateInstance(Calendar cal, int dateStyle) {
        return DateFormat.getDateInstance(cal, dateStyle, ULocale.getDefault(ULocale.Category.FORMAT));
    }

    private static final DateFormat $$robo$$android_icu_text_DateFormat$getTimeInstance(Calendar cal, int timeStyle) {
        return DateFormat.getTimeInstance(cal, timeStyle, ULocale.getDefault(ULocale.Category.FORMAT));
    }

    private static final DateFormat $$robo$$android_icu_text_DateFormat$getDateTimeInstance(Calendar cal, int dateStyle, int timeStyle) {
        return DateFormat.getDateTimeInstance(cal, dateStyle, timeStyle, ULocale.getDefault(ULocale.Category.FORMAT));
    }

    private static final DateFormat $$robo$$android_icu_text_DateFormat$getInstanceForSkeleton(String skeleton) {
        return DateFormat.getPatternInstance(skeleton, ULocale.getDefault(ULocale.Category.FORMAT));
    }

    private static final DateFormat $$robo$$android_icu_text_DateFormat$getInstanceForSkeleton(String skeleton, Locale locale) {
        return DateFormat.getPatternInstance(skeleton, ULocale.forLocale(locale));
    }

    private static final DateFormat $$robo$$android_icu_text_DateFormat$getInstanceForSkeleton(String skeleton, ULocale locale) {
        DateTimePatternGenerator generator = DateTimePatternGenerator.getInstance(locale);
        String bestPattern = generator.getBestPattern(skeleton);
        return new SimpleDateFormat(bestPattern, locale);
    }

    private static final DateFormat $$robo$$android_icu_text_DateFormat$getInstanceForSkeleton(Calendar cal, String skeleton, Locale locale) {
        return DateFormat.getPatternInstance(cal, skeleton, ULocale.forLocale(locale));
    }

    private static final DateFormat $$robo$$android_icu_text_DateFormat$getInstanceForSkeleton(Calendar cal, String skeleton, ULocale locale) {
        DateTimePatternGenerator generator = DateTimePatternGenerator.getInstance(locale);
        String bestPattern = generator.getBestPattern(skeleton);
        SimpleDateFormat format = new SimpleDateFormat(bestPattern, locale);
        format.setCalendar(cal);
        return format;
    }

    private static final DateFormat $$robo$$android_icu_text_DateFormat$getPatternInstance(String skeleton) {
        return DateFormat.getInstanceForSkeleton(skeleton);
    }

    private static final DateFormat $$robo$$android_icu_text_DateFormat$getPatternInstance(String skeleton, Locale locale) {
        return DateFormat.getInstanceForSkeleton(skeleton, locale);
    }

    private static final DateFormat $$robo$$android_icu_text_DateFormat$getPatternInstance(String skeleton, ULocale locale) {
        return DateFormat.getInstanceForSkeleton(skeleton, locale);
    }

    private static final DateFormat $$robo$$android_icu_text_DateFormat$getPatternInstance(Calendar cal, String skeleton, Locale locale) {
        return DateFormat.getInstanceForSkeleton(cal, skeleton, locale);
    }

    private static final DateFormat $$robo$$android_icu_text_DateFormat$getPatternInstance(Calendar cal, String skeleton, ULocale locale) {
        return DateFormat.getInstanceForSkeleton(cal, skeleton, locale);
    }

    static void __staticInitializer__() {
        DATE_SKELETONS = Arrays.asList("y", "QQQQ", "QQQ", "yQQQQ", "yQQQ", "MMMM", "MMM", "M", "yMMMM", "yMMM", "yM", "d", "yMMMMd", "yMMMd", "yMd", "EEEE", "E", "yMMMMEEEEd", "yMMMEd", "yMEd", "MMMMd", "MMMd", "Md", "MMMMEEEEd", "MMMEd", "MEd");
        TIME_SKELETONS = Arrays.asList("j", "H", "m", "jm", "Hm", "s", "jms", "Hms", "ms");
        ZONE_SKELETONS = Arrays.asList("VVVV", "vvvv", "v", "zzzz", "z", "ZZZZ");
    }

    @Override
    public StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        return InvokeDynamicSupport.bootstrap("format", $$robo$$android_icu_text_DateFormat$format(java.lang.Object java.lang.StringBuffer java.text.FieldPosition ), this, object, stringBuffer, fieldPosition);
    }

    public StringBuffer format(Date date, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        return InvokeDynamicSupport.bootstrap("format", $$robo$$android_icu_text_DateFormat$format(java.util.Date java.lang.StringBuffer java.text.FieldPosition ), this, date, stringBuffer, fieldPosition);
    }

    public String format(Date date) {
        return InvokeDynamicSupport.bootstrap("format", $$robo$$android_icu_text_DateFormat$format(java.util.Date ), this, date);
    }

    public Date parse(String string2) throws ParseException {
        return InvokeDynamicSupport.bootstrap("parse", $$robo$$android_icu_text_DateFormat$parse(java.lang.String ), this, string2);
    }

    public Date parse(String string2, ParsePosition parsePosition) {
        return InvokeDynamicSupport.bootstrap("parse", $$robo$$android_icu_text_DateFormat$parse(java.lang.String java.text.ParsePosition ), this, string2, parsePosition);
    }

    @Override
    public Object parseObject(String string2, ParsePosition parsePosition) {
        return InvokeDynamicSupport.bootstrap("parseObject", $$robo$$android_icu_text_DateFormat$parseObject(java.lang.String java.text.ParsePosition ), this, string2, parsePosition);
    }

    public static DateFormat getTimeInstance() {
        return InvokeDynamicSupport.bootstrapStatic("getTimeInstance", $$robo$$android_icu_text_DateFormat$getTimeInstance());
    }

    public static DateFormat getTimeInstance(int n) {
        return InvokeDynamicSupport.bootstrapStatic("getTimeInstance", $$robo$$android_icu_text_DateFormat$getTimeInstance(int ), (int)n);
    }

    public static DateFormat getTimeInstance(int n, Locale locale) {
        return InvokeDynamicSupport.bootstrapStatic("getTimeInstance", $$robo$$android_icu_text_DateFormat$getTimeInstance(int java.util.Locale ), (int)n, (Locale)locale);
    }

    public static DateFormat getTimeInstance(int n, ULocale uLocale) {
        return InvokeDynamicSupport.bootstrapStatic("getTimeInstance", $$robo$$android_icu_text_DateFormat$getTimeInstance(int android.icu.util.ULocale ), (int)n, (ULocale)uLocale);
    }

    public static DateFormat getDateInstance() {
        return InvokeDynamicSupport.bootstrapStatic("getDateInstance", $$robo$$android_icu_text_DateFormat$getDateInstance());
    }

    public static DateFormat getDateInstance(int n) {
        return InvokeDynamicSupport.bootstrapStatic("getDateInstance", $$robo$$android_icu_text_DateFormat$getDateInstance(int ), (int)n);
    }

    public static DateFormat getDateInstance(int n, Locale locale) {
        return InvokeDynamicSupport.bootstrapStatic("getDateInstance", $$robo$$android_icu_text_DateFormat$getDateInstance(int java.util.Locale ), (int)n, (Locale)locale);
    }

    public static DateFormat getDateInstance(int n, ULocale uLocale) {
        return InvokeDynamicSupport.bootstrapStatic("getDateInstance", $$robo$$android_icu_text_DateFormat$getDateInstance(int android.icu.util.ULocale ), (int)n, (ULocale)uLocale);
    }

    public static DateFormat getDateTimeInstance() {
        return InvokeDynamicSupport.bootstrapStatic("getDateTimeInstance", $$robo$$android_icu_text_DateFormat$getDateTimeInstance());
    }

    public static DateFormat getDateTimeInstance(int n, int n2) {
        return InvokeDynamicSupport.bootstrapStatic("getDateTimeInstance", $$robo$$android_icu_text_DateFormat$getDateTimeInstance(int int ), (int)n, (int)n2);
    }

    public static DateFormat getDateTimeInstance(int n, int n2, Locale locale) {
        return InvokeDynamicSupport.bootstrapStatic("getDateTimeInstance", $$robo$$android_icu_text_DateFormat$getDateTimeInstance(int int java.util.Locale ), (int)n, (int)n2, (Locale)locale);
    }

    public static DateFormat getDateTimeInstance(int n, int n2, ULocale uLocale) {
        return InvokeDynamicSupport.bootstrapStatic("getDateTimeInstance", $$robo$$android_icu_text_DateFormat$getDateTimeInstance(int int android.icu.util.ULocale ), (int)n, (int)n2, (ULocale)uLocale);
    }

    public static DateFormat getInstance() {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$android_icu_text_DateFormat$getInstance());
    }

    public static Locale[] getAvailableLocales() {
        return InvokeDynamicSupport.bootstrapStatic("getAvailableLocales", $$robo$$android_icu_text_DateFormat$getAvailableLocales());
    }

    public static ULocale[] getAvailableULocales() {
        return InvokeDynamicSupport.bootstrapStatic("getAvailableULocales", $$robo$$android_icu_text_DateFormat$getAvailableULocales());
    }

    public void setCalendar(Calendar calendar) {
        InvokeDynamicSupport.bootstrap("setCalendar", $$robo$$android_icu_text_DateFormat$setCalendar(android.icu.util.Calendar ), this, calendar);
    }

    public Calendar getCalendar() {
        return InvokeDynamicSupport.bootstrap("getCalendar", $$robo$$android_icu_text_DateFormat$getCalendar(), this);
    }

    public void setNumberFormat(NumberFormat numberFormat) {
        InvokeDynamicSupport.bootstrap("setNumberFormat", $$robo$$android_icu_text_DateFormat$setNumberFormat(android.icu.text.NumberFormat ), this, numberFormat);
    }

    public NumberFormat getNumberFormat() {
        return InvokeDynamicSupport.bootstrap("getNumberFormat", $$robo$$android_icu_text_DateFormat$getNumberFormat(), this);
    }

    public void setTimeZone(TimeZone timeZone) {
        InvokeDynamicSupport.bootstrap("setTimeZone", $$robo$$android_icu_text_DateFormat$setTimeZone(android.icu.util.TimeZone ), this, timeZone);
    }

    public TimeZone getTimeZone() {
        return InvokeDynamicSupport.bootstrap("getTimeZone", $$robo$$android_icu_text_DateFormat$getTimeZone(), this);
    }

    public void setLenient(boolean bl) {
        InvokeDynamicSupport.bootstrap("setLenient", $$robo$$android_icu_text_DateFormat$setLenient(boolean ), this, bl);
    }

    public boolean isLenient() {
        return (boolean)InvokeDynamicSupport.bootstrap("isLenient", $$robo$$android_icu_text_DateFormat$isLenient(), this);
    }

    public void setCalendarLenient(boolean bl) {
        InvokeDynamicSupport.bootstrap("setCalendarLenient", $$robo$$android_icu_text_DateFormat$setCalendarLenient(boolean ), this, bl);
    }

    public boolean isCalendarLenient() {
        return (boolean)InvokeDynamicSupport.bootstrap("isCalendarLenient", $$robo$$android_icu_text_DateFormat$isCalendarLenient(), this);
    }

    public DateFormat setBooleanAttribute(BooleanAttribute booleanAttribute, boolean bl) {
        return InvokeDynamicSupport.bootstrap("setBooleanAttribute", $$robo$$android_icu_text_DateFormat$setBooleanAttribute(android.icu.text.DateFormat$BooleanAttribute boolean ), this, booleanAttribute, bl);
    }

    public boolean getBooleanAttribute(BooleanAttribute booleanAttribute) {
        return (boolean)InvokeDynamicSupport.bootstrap("getBooleanAttribute", $$robo$$android_icu_text_DateFormat$getBooleanAttribute(android.icu.text.DateFormat$BooleanAttribute ), this, booleanAttribute);
    }

    public void setContext(DisplayContext displayContext) {
        InvokeDynamicSupport.bootstrap("setContext", $$robo$$android_icu_text_DateFormat$setContext(android.icu.text.DisplayContext ), this, displayContext);
    }

    public DisplayContext getContext(DisplayContext.Type type) {
        return InvokeDynamicSupport.bootstrap("getContext", $$robo$$android_icu_text_DateFormat$getContext(android.icu.text.DisplayContext$Type ), this, type);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_icu_text_DateFormat$hashCode(), this);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_icu_text_DateFormat$equals(java.lang.Object ), this, object);
    }

    @Override
    public Object clone() {
        return InvokeDynamicSupport.bootstrap("clone", $$robo$$android_icu_text_DateFormat$clone(), this);
    }

    private static DateFormat get(int n, int n2, ULocale uLocale, Calendar calendar) {
        return InvokeDynamicSupport.bootstrapStatic("get", $$robo$$android_icu_text_DateFormat$get(int int android.icu.util.ULocale android.icu.util.Calendar ), (int)n, (int)n2, (ULocale)uLocale, (Calendar)calendar);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        InvokeDynamicSupport.bootstrap("readObject", $$robo$$android_icu_text_DateFormat$readObject(java.io.ObjectInputStream ), this, objectInputStream);
    }

    private void __constructor__() {
        this.$$robo$$android_icu_text_DateFormat$__constructor__();
    }

    public DateFormat() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_DateFormat$__constructor__(), this);
    }

    public static DateFormat getDateInstance(Calendar calendar, int n, Locale locale) {
        return InvokeDynamicSupport.bootstrapStatic("getDateInstance", $$robo$$android_icu_text_DateFormat$getDateInstance(android.icu.util.Calendar int java.util.Locale ), (Calendar)calendar, (int)n, (Locale)locale);
    }

    public static DateFormat getDateInstance(Calendar calendar, int n, ULocale uLocale) {
        return InvokeDynamicSupport.bootstrapStatic("getDateInstance", $$robo$$android_icu_text_DateFormat$getDateInstance(android.icu.util.Calendar int android.icu.util.ULocale ), (Calendar)calendar, (int)n, (ULocale)uLocale);
    }

    public static DateFormat getTimeInstance(Calendar calendar, int n, Locale locale) {
        return InvokeDynamicSupport.bootstrapStatic("getTimeInstance", $$robo$$android_icu_text_DateFormat$getTimeInstance(android.icu.util.Calendar int java.util.Locale ), (Calendar)calendar, (int)n, (Locale)locale);
    }

    public static DateFormat getTimeInstance(Calendar calendar, int n, ULocale uLocale) {
        return InvokeDynamicSupport.bootstrapStatic("getTimeInstance", $$robo$$android_icu_text_DateFormat$getTimeInstance(android.icu.util.Calendar int android.icu.util.ULocale ), (Calendar)calendar, (int)n, (ULocale)uLocale);
    }

    public static DateFormat getDateTimeInstance(Calendar calendar, int n, int n2, Locale locale) {
        return InvokeDynamicSupport.bootstrapStatic("getDateTimeInstance", $$robo$$android_icu_text_DateFormat$getDateTimeInstance(android.icu.util.Calendar int int java.util.Locale ), (Calendar)calendar, (int)n, (int)n2, (Locale)locale);
    }

    public static DateFormat getDateTimeInstance(Calendar calendar, int n, int n2, ULocale uLocale) {
        return InvokeDynamicSupport.bootstrapStatic("getDateTimeInstance", $$robo$$android_icu_text_DateFormat$getDateTimeInstance(android.icu.util.Calendar int int android.icu.util.ULocale ), (Calendar)calendar, (int)n, (int)n2, (ULocale)uLocale);
    }

    public static DateFormat getInstance(Calendar calendar, Locale locale) {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$android_icu_text_DateFormat$getInstance(android.icu.util.Calendar java.util.Locale ), (Calendar)calendar, (Locale)locale);
    }

    public static DateFormat getInstance(Calendar calendar, ULocale uLocale) {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$android_icu_text_DateFormat$getInstance(android.icu.util.Calendar android.icu.util.ULocale ), (Calendar)calendar, (ULocale)uLocale);
    }

    public static DateFormat getInstance(Calendar calendar) {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$android_icu_text_DateFormat$getInstance(android.icu.util.Calendar ), (Calendar)calendar);
    }

    public static DateFormat getDateInstance(Calendar calendar, int n) {
        return InvokeDynamicSupport.bootstrapStatic("getDateInstance", $$robo$$android_icu_text_DateFormat$getDateInstance(android.icu.util.Calendar int ), (Calendar)calendar, (int)n);
    }

    public static DateFormat getTimeInstance(Calendar calendar, int n) {
        return InvokeDynamicSupport.bootstrapStatic("getTimeInstance", $$robo$$android_icu_text_DateFormat$getTimeInstance(android.icu.util.Calendar int ), (Calendar)calendar, (int)n);
    }

    public static DateFormat getDateTimeInstance(Calendar calendar, int n, int n2) {
        return InvokeDynamicSupport.bootstrapStatic("getDateTimeInstance", $$robo$$android_icu_text_DateFormat$getDateTimeInstance(android.icu.util.Calendar int int ), (Calendar)calendar, (int)n, (int)n2);
    }

    public static DateFormat getInstanceForSkeleton(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("getInstanceForSkeleton", $$robo$$android_icu_text_DateFormat$getInstanceForSkeleton(java.lang.String ), (String)string2);
    }

    public static DateFormat getInstanceForSkeleton(String string2, Locale locale) {
        return InvokeDynamicSupport.bootstrapStatic("getInstanceForSkeleton", $$robo$$android_icu_text_DateFormat$getInstanceForSkeleton(java.lang.String java.util.Locale ), (String)string2, (Locale)locale);
    }

    public static DateFormat getInstanceForSkeleton(String string2, ULocale uLocale) {
        return InvokeDynamicSupport.bootstrapStatic("getInstanceForSkeleton", $$robo$$android_icu_text_DateFormat$getInstanceForSkeleton(java.lang.String android.icu.util.ULocale ), (String)string2, (ULocale)uLocale);
    }

    public static DateFormat getInstanceForSkeleton(Calendar calendar, String string2, Locale locale) {
        return InvokeDynamicSupport.bootstrapStatic("getInstanceForSkeleton", $$robo$$android_icu_text_DateFormat$getInstanceForSkeleton(android.icu.util.Calendar java.lang.String java.util.Locale ), (Calendar)calendar, (String)string2, (Locale)locale);
    }

    public static DateFormat getInstanceForSkeleton(Calendar calendar, String string2, ULocale uLocale) {
        return InvokeDynamicSupport.bootstrapStatic("getInstanceForSkeleton", $$robo$$android_icu_text_DateFormat$getInstanceForSkeleton(android.icu.util.Calendar java.lang.String android.icu.util.ULocale ), (Calendar)calendar, (String)string2, (ULocale)uLocale);
    }

    public static DateFormat getPatternInstance(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("getPatternInstance", $$robo$$android_icu_text_DateFormat$getPatternInstance(java.lang.String ), (String)string2);
    }

    public static DateFormat getPatternInstance(String string2, Locale locale) {
        return InvokeDynamicSupport.bootstrapStatic("getPatternInstance", $$robo$$android_icu_text_DateFormat$getPatternInstance(java.lang.String java.util.Locale ), (String)string2, (Locale)locale);
    }

    public static DateFormat getPatternInstance(String string2, ULocale uLocale) {
        return InvokeDynamicSupport.bootstrapStatic("getPatternInstance", $$robo$$android_icu_text_DateFormat$getPatternInstance(java.lang.String android.icu.util.ULocale ), (String)string2, (ULocale)uLocale);
    }

    public static DateFormat getPatternInstance(Calendar calendar, String string2, Locale locale) {
        return InvokeDynamicSupport.bootstrapStatic("getPatternInstance", $$robo$$android_icu_text_DateFormat$getPatternInstance(android.icu.util.Calendar java.lang.String java.util.Locale ), (Calendar)calendar, (String)string2, (Locale)locale);
    }

    public static DateFormat getPatternInstance(Calendar calendar, String string2, ULocale uLocale) {
        return InvokeDynamicSupport.bootstrapStatic("getPatternInstance", $$robo$$android_icu_text_DateFormat$getPatternInstance(android.icu.util.Calendar java.lang.String android.icu.util.ULocale ), (Calendar)calendar, (String)string2, (ULocale)uLocale);
    }

    static {
        RobolectricInternals.classInitializing(DateFormat.class);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DateFormat)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class Field
    extends Format.Field
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private static long serialVersionUID = -3627456821000730829L;
        private static int CAL_FIELD_COUNT;
        private static Field[] CAL_FIELDS;
        private static Map<String, Field> FIELD_NAME_MAP;
        public static Field AM_PM;
        public static Field DAY_OF_MONTH;
        public static Field DAY_OF_WEEK;
        public static Field DAY_OF_WEEK_IN_MONTH;
        public static Field DAY_OF_YEAR;
        public static Field ERA;
        public static Field HOUR_OF_DAY0;
        public static Field HOUR_OF_DAY1;
        public static Field HOUR0;
        public static Field HOUR1;
        public static Field MILLISECOND;
        public static Field MINUTE;
        public static Field MONTH;
        public static Field SECOND;
        public static Field TIME_ZONE;
        public static Field WEEK_OF_MONTH;
        public static Field WEEK_OF_YEAR;
        public static Field YEAR;
        public static Field DOW_LOCAL;
        public static Field EXTENDED_YEAR;
        public static Field JULIAN_DAY;
        public static Field MILLISECONDS_IN_DAY;
        public static Field YEAR_WOY;
        public static Field QUARTER;
        @Deprecated
        public static Field RELATED_YEAR;
        public static Field AM_PM_MIDNIGHT_NOON;
        public static Field FLEXIBLE_DAY_PERIOD;
        @Deprecated
        public static Field TIME_SEPARATOR;
        private int calendarField;

        private void $$robo$$android_icu_text_DateFormat_Field$__constructor__(String name, int calendarField) {
            this.calendarField = calendarField;
            if (this.getClass() == Field.class) {
                FIELD_NAME_MAP.put(name, this);
                if (calendarField >= 0 && calendarField < CAL_FIELD_COUNT) {
                    Field.CAL_FIELDS[calendarField] = this;
                }
            }
        }

        private static final Field $$robo$$android_icu_text_DateFormat_Field$ofCalendarField(int calendarField) {
            if (calendarField < 0 || calendarField >= CAL_FIELD_COUNT) {
                throw new IllegalArgumentException("Calendar field number is out of range");
            }
            return CAL_FIELDS[calendarField];
        }

        private final int $$robo$$android_icu_text_DateFormat_Field$getCalendarField() {
            return this.calendarField;
        }

        private final Object $$robo$$android_icu_text_DateFormat_Field$readResolve() throws InvalidObjectException {
            if (this.getClass() != Field.class) {
                throw new InvalidObjectException("A subclass of DateFormat.Field must implement readResolve.");
            }
            Field o = FIELD_NAME_MAP.get(this.getName());
            if (o == null) {
                throw new InvalidObjectException("Unknown attribute name.");
            }
            return o;
        }

        static void __staticInitializer__() {
            GregorianCalendar cal = new GregorianCalendar();
            CAL_FIELD_COUNT = cal.getFieldCount();
            CAL_FIELDS = new Field[CAL_FIELD_COUNT];
            FIELD_NAME_MAP = new HashMap<String, Field>(CAL_FIELD_COUNT);
            AM_PM = new Field("am pm", 9);
            DAY_OF_MONTH = new Field("day of month", 5);
            DAY_OF_WEEK = new Field("day of week", 7);
            DAY_OF_WEEK_IN_MONTH = new Field("day of week in month", 8);
            DAY_OF_YEAR = new Field("day of year", 6);
            ERA = new Field("era", 0);
            HOUR_OF_DAY0 = new Field("hour of day", 11);
            HOUR_OF_DAY1 = new Field("hour of day 1", -1);
            HOUR0 = new Field("hour", 10);
            HOUR1 = new Field("hour 1", -1);
            MILLISECOND = new Field("millisecond", 14);
            MINUTE = new Field("minute", 12);
            MONTH = new Field("month", 2);
            SECOND = new Field("second", 13);
            TIME_ZONE = new Field("time zone", -1);
            WEEK_OF_MONTH = new Field("week of month", 4);
            WEEK_OF_YEAR = new Field("week of year", 3);
            YEAR = new Field("year", 1);
            DOW_LOCAL = new Field("local day of week", 18);
            EXTENDED_YEAR = new Field("extended year", 19);
            JULIAN_DAY = new Field("Julian day", 20);
            MILLISECONDS_IN_DAY = new Field("milliseconds in day", 21);
            YEAR_WOY = new Field("year for week of year", 17);
            QUARTER = new Field("quarter", -1);
            RELATED_YEAR = new Field("related year", -1);
            AM_PM_MIDNIGHT_NOON = new Field("am/pm/midnight/noon", -1);
            FLEXIBLE_DAY_PERIOD = new Field("flexible day period", -1);
            TIME_SEPARATOR = new Field("time separator", -1);
        }

        private void __constructor__(String string2, int n) {
            this.$$robo$$android_icu_text_DateFormat_Field$__constructor__(string2, n);
        }

        public Field(String string2, int n) {
            super(string2);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_DateFormat_Field$__constructor__(java.lang.String int ), this, string2, n);
        }

        public static Field ofCalendarField(int n) {
            return InvokeDynamicSupport.bootstrapStatic("ofCalendarField", $$robo$$android_icu_text_DateFormat_Field$ofCalendarField(int ), (int)n);
        }

        public int getCalendarField() {
            return (int)InvokeDynamicSupport.bootstrap("getCalendarField", $$robo$$android_icu_text_DateFormat_Field$getCalendarField(), this);
        }

        @Override
        protected Object readResolve() throws InvalidObjectException {
            return InvokeDynamicSupport.bootstrap("readResolve", $$robo$$android_icu_text_DateFormat_Field$readResolve(), this);
        }

        static {
            RobolectricInternals.classInitializing(Field.class);
        }

        public /* synthetic */ Field() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Field)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class BooleanAttribute
    extends Enum<BooleanAttribute> {
        public /* synthetic */ Object __robo_data__;
        public static /* enum */ BooleanAttribute PARSE_ALLOW_WHITESPACE;
        public static /* enum */ BooleanAttribute PARSE_ALLOW_NUMERIC;
        public static /* enum */ BooleanAttribute PARSE_MULTIPLE_PATTERNS_FOR_MATCH;
        public static /* enum */ BooleanAttribute PARSE_PARTIAL_LITERAL_MATCH;
        @Deprecated
        public static /* enum */ BooleanAttribute PARSE_PARTIAL_MATCH;
        private static /* synthetic */ BooleanAttribute[] $VALUES;

        private static final BooleanAttribute[] $$robo$$android_icu_text_DateFormat_BooleanAttribute$values() {
            return (BooleanAttribute[])$VALUES.clone();
        }

        private static final BooleanAttribute $$robo$$android_icu_text_DateFormat_BooleanAttribute$valueOf(String name) {
            return Enum.valueOf(BooleanAttribute.class, name);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void $$robo$$android_icu_text_DateFormat_BooleanAttribute$__constructor__(String string2, int n) {
        }

        static void __staticInitializer__() {
            PARSE_ALLOW_WHITESPACE = new BooleanAttribute();
            PARSE_ALLOW_NUMERIC = new BooleanAttribute();
            PARSE_MULTIPLE_PATTERNS_FOR_MATCH = new BooleanAttribute();
            PARSE_PARTIAL_LITERAL_MATCH = new BooleanAttribute();
            PARSE_PARTIAL_MATCH = new BooleanAttribute();
            $VALUES = new BooleanAttribute[]{PARSE_ALLOW_WHITESPACE, PARSE_ALLOW_NUMERIC, PARSE_MULTIPLE_PATTERNS_FOR_MATCH, PARSE_PARTIAL_LITERAL_MATCH, PARSE_PARTIAL_MATCH};
        }

        public static BooleanAttribute[] values() {
            return InvokeDynamicSupport.bootstrapStatic("values", $$robo$$android_icu_text_DateFormat_BooleanAttribute$values());
        }

        public static BooleanAttribute valueOf(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$android_icu_text_DateFormat_BooleanAttribute$valueOf(java.lang.String ), (String)string2);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void __constructor__(String string2, int n) {
            this.$$robo$$android_icu_text_DateFormat_BooleanAttribute$__constructor__(string2, n);
        }

        public BooleanAttribute() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_DateFormat_BooleanAttribute$__constructor__(java.lang.String int ), this, string2, n);
        }

        static {
            RobolectricInternals.classInitializing(BooleanAttribute.class);
        }

        public /* synthetic */ BooleanAttribute() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BooleanAttribute)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

