/*
 * Decompiled with CFR 0.152.
 */
package android.icu.text;

import android.icu.impl.ICUCache;
import android.icu.impl.ICUResourceBundle;
import android.icu.impl.SimpleCache;
import android.icu.impl.UResource;
import android.icu.impl.Utility;
import android.icu.text.DateIntervalFormat;
import android.icu.util.Calendar;
import android.icu.util.Freezable;
import android.icu.util.ICUCloneNotSupportedException;
import android.icu.util.ICUException;
import android.icu.util.ULocale;
import android.icu.util.UResourceBundle;
import com.google.errorprone.annotations.DoNotMock;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class DateIntervalInfo
implements Cloneable,
Freezable<DateIntervalInfo>,
Serializable {
    public /* synthetic */ Object __robo_data__;
    static int currentSerialVersion = 1;
    static String[] CALENDAR_FIELD_TO_PATTERN_LETTER;
    private static long serialVersionUID = 1L;
    private static int MINIMUM_SUPPORTED_CALENDAR_FIELD = 13;
    private static String CALENDAR_KEY;
    private static String INTERVAL_FORMATS_KEY;
    private static String FALLBACK_STRING;
    private static String LATEST_FIRST_PREFIX;
    private static String EARLIEST_FIRST_PREFIX;
    private static ICUCache<String, DateIntervalInfo> DIICACHE;
    private String fFallbackIntervalPattern;
    private boolean fFirstDateInPtnIsLaterDate;
    private Map<String, Map<String, PatternInfo>> fIntervalPatterns;
    private volatile transient boolean frozen;
    private transient boolean fIntervalPatternsReadOnly;

    @Deprecated
    private void $$robo$$android_icu_text_DateIntervalInfo$__constructor__() {
        this.fFirstDateInPtnIsLaterDate = false;
        this.fIntervalPatterns = null;
        this.frozen = false;
        this.fIntervalPatternsReadOnly = false;
        this.fIntervalPatterns = new HashMap<String, Map<String, PatternInfo>>();
        this.fFallbackIntervalPattern = "{0} \u2013 {1}";
    }

    private void $$robo$$android_icu_text_DateIntervalInfo$__constructor__(ULocale locale) {
        this.fFirstDateInPtnIsLaterDate = false;
        this.fIntervalPatterns = null;
        this.frozen = false;
        this.fIntervalPatternsReadOnly = false;
        this.initializeData(locale);
    }

    private void $$robo$$android_icu_text_DateIntervalInfo$__constructor__(Locale locale) {
    }

    private final void $$robo$$android_icu_text_DateIntervalInfo$initializeData(ULocale locale) {
        String key = locale.toString();
        DateIntervalInfo dii = DIICACHE.get(key);
        if (dii == null) {
            this.setup(locale);
            this.fIntervalPatternsReadOnly = true;
            DIICACHE.put(key, (DateIntervalInfo)((DateIntervalInfo)this.clone()).freeze());
        } else {
            this.initializeFromReadOnlyPatterns(dii);
        }
    }

    private final void $$robo$$android_icu_text_DateIntervalInfo$initializeFromReadOnlyPatterns(DateIntervalInfo dii) {
        this.fFallbackIntervalPattern = dii.fFallbackIntervalPattern;
        this.fFirstDateInPtnIsLaterDate = dii.fFirstDateInPtnIsLaterDate;
        this.fIntervalPatterns = dii.fIntervalPatterns;
        this.fIntervalPatternsReadOnly = true;
    }

    private final void $$robo$$android_icu_text_DateIntervalInfo$setup(ULocale locale) {
        int DEFAULT_HASH_SIZE = 19;
        this.fIntervalPatterns = new HashMap<String, Map<String, PatternInfo>>(DEFAULT_HASH_SIZE);
        this.fFallbackIntervalPattern = "{0} \u2013 {1}";
        try {
            String calendarTypeToUse = locale.getKeywordValue("calendar");
            if (calendarTypeToUse == null) {
                String[] preferredCalendarTypes = Calendar.getKeywordValuesForLocale("calendar", locale, true);
                calendarTypeToUse = preferredCalendarTypes[0];
            }
            if (calendarTypeToUse == null) {
                calendarTypeToUse = "gregorian";
            }
            DateIntervalSink sink = new DateIntervalSink(this);
            ICUResourceBundle resource = (ICUResourceBundle)UResourceBundle.getBundleInstance("android/icu/impl/data/icudt58b", locale);
            String fallbackPattern = resource.getStringWithFallback(CALENDAR_KEY + "/" + calendarTypeToUse + "/" + INTERVAL_FORMATS_KEY + "/" + FALLBACK_STRING);
            this.setFallbackIntervalPattern(fallbackPattern);
            HashSet<String> loadedCalendarTypes = new HashSet<String>();
            while (calendarTypeToUse != null) {
                if (loadedCalendarTypes.contains(calendarTypeToUse)) {
                    throw new ICUException("Loop in calendar type fallback: " + calendarTypeToUse);
                }
                loadedCalendarTypes.add(calendarTypeToUse);
                String pathToIntervalFormats = CALENDAR_KEY + "/" + calendarTypeToUse;
                resource.getAllItemsWithFallback(pathToIntervalFormats, sink);
                calendarTypeToUse = sink.getAndResetNextCalendarType();
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
    }

    private static final int $$robo$$android_icu_text_DateIntervalInfo$splitPatternInto2Part(String intervalPattern) {
        int i;
        boolean inQuote = false;
        char prevCh = '\u0000';
        int count = 0;
        int[] patternRepeated = new int[58];
        int PATTERN_CHAR_BASE = 65;
        boolean foundRepetition = false;
        for (i = 0; i < intervalPattern.length(); ++i) {
            char ch = intervalPattern.charAt(i);
            if (ch != prevCh && count > 0) {
                int repeated = patternRepeated[prevCh - PATTERN_CHAR_BASE];
                if (repeated != 0) {
                    foundRepetition = true;
                    break;
                }
                patternRepeated[prevCh - PATTERN_CHAR_BASE] = 1;
                count = 0;
            }
            if (ch == '\'') {
                if (i + 1 < intervalPattern.length() && intervalPattern.charAt(i + 1) == '\'') {
                    ++i;
                    continue;
                }
                inQuote = !inQuote;
                continue;
            }
            if (inQuote || (ch < 'a' || ch > 'z') && (ch < 'A' || ch > 'Z')) continue;
            prevCh = ch;
            ++count;
        }
        if (count > 0 && !foundRepetition && patternRepeated[prevCh - PATTERN_CHAR_BASE] == 0) {
            count = 0;
        }
        return i - count;
    }

    private final void $$robo$$android_icu_text_DateIntervalInfo$setIntervalPattern(String skeleton, int lrgDiffCalUnit, String intervalPattern) {
        if (this.frozen) {
            throw new UnsupportedOperationException("no modification is allowed after DII is frozen");
        }
        if (lrgDiffCalUnit > 13) {
            throw new IllegalArgumentException("calendar field is larger than MINIMUM_SUPPORTED_CALENDAR_FIELD");
        }
        if (this.fIntervalPatternsReadOnly) {
            this.fIntervalPatterns = DateIntervalInfo.cloneIntervalPatterns(this.fIntervalPatterns);
            this.fIntervalPatternsReadOnly = false;
        }
        PatternInfo ptnInfo = this.setIntervalPatternInternally(skeleton, CALENDAR_FIELD_TO_PATTERN_LETTER[lrgDiffCalUnit], intervalPattern);
        if (lrgDiffCalUnit == 11) {
            this.setIntervalPattern(skeleton, CALENDAR_FIELD_TO_PATTERN_LETTER[9], ptnInfo);
            this.setIntervalPattern(skeleton, CALENDAR_FIELD_TO_PATTERN_LETTER[10], ptnInfo);
        } else if (lrgDiffCalUnit == 5 || lrgDiffCalUnit == 7) {
            this.setIntervalPattern(skeleton, CALENDAR_FIELD_TO_PATTERN_LETTER[5], ptnInfo);
        }
    }

    private final PatternInfo $$robo$$android_icu_text_DateIntervalInfo$setIntervalPatternInternally(String skeleton, String lrgDiffCalUnit, String intervalPattern) {
        Map<String, PatternInfo> patternsOfOneSkeleton = this.fIntervalPatterns.get(skeleton);
        boolean emptyHash = false;
        if (patternsOfOneSkeleton == null) {
            patternsOfOneSkeleton = new HashMap<String, PatternInfo>();
            emptyHash = true;
        }
        boolean order = this.fFirstDateInPtnIsLaterDate;
        if (intervalPattern.startsWith(LATEST_FIRST_PREFIX)) {
            order = true;
            int prefixLength = LATEST_FIRST_PREFIX.length();
            intervalPattern = intervalPattern.substring(prefixLength, intervalPattern.length());
        } else if (intervalPattern.startsWith(EARLIEST_FIRST_PREFIX)) {
            order = false;
            int earliestFirstLength = EARLIEST_FIRST_PREFIX.length();
            intervalPattern = intervalPattern.substring(earliestFirstLength, intervalPattern.length());
        }
        PatternInfo itvPtnInfo = DateIntervalInfo.genPatternInfo(intervalPattern, order);
        patternsOfOneSkeleton.put(lrgDiffCalUnit, itvPtnInfo);
        if (emptyHash) {
            this.fIntervalPatterns.put(skeleton, patternsOfOneSkeleton);
        }
        return itvPtnInfo;
    }

    private final void $$robo$$android_icu_text_DateIntervalInfo$setIntervalPattern(String skeleton, String lrgDiffCalUnit, PatternInfo ptnInfo) {
        Map<String, PatternInfo> patternsOfOneSkeleton = this.fIntervalPatterns.get(skeleton);
        patternsOfOneSkeleton.put(lrgDiffCalUnit, ptnInfo);
    }

    @Deprecated
    private static final PatternInfo $$robo$$android_icu_text_DateIntervalInfo$genPatternInfo(String intervalPattern, boolean laterDateFirst) {
        int splitPoint = DateIntervalInfo.splitPatternInto2Part(intervalPattern);
        String firstPart = intervalPattern.substring(0, splitPoint);
        String secondPart = null;
        if (splitPoint < intervalPattern.length()) {
            secondPart = intervalPattern.substring(splitPoint, intervalPattern.length());
        }
        return new PatternInfo(firstPart, secondPart, laterDateFirst);
    }

    private final PatternInfo $$robo$$android_icu_text_DateIntervalInfo$getIntervalPattern(String skeleton, int field) {
        PatternInfo intervalPattern;
        if (field > 13) {
            throw new IllegalArgumentException("no support for field less than SECOND");
        }
        Map<String, PatternInfo> patternsOfOneSkeleton = this.fIntervalPatterns.get(skeleton);
        if (patternsOfOneSkeleton != null && (intervalPattern = patternsOfOneSkeleton.get(CALENDAR_FIELD_TO_PATTERN_LETTER[field])) != null) {
            return intervalPattern;
        }
        return null;
    }

    private final String $$robo$$android_icu_text_DateIntervalInfo$getFallbackIntervalPattern() {
        return this.fFallbackIntervalPattern;
    }

    private final void $$robo$$android_icu_text_DateIntervalInfo$setFallbackIntervalPattern(String fallbackPattern) {
        if (this.frozen) {
            throw new UnsupportedOperationException("no modification is allowed after DII is frozen");
        }
        int firstPatternIndex = fallbackPattern.indexOf("{0}");
        int secondPatternIndex = fallbackPattern.indexOf("{1}");
        if (firstPatternIndex == -1 || secondPatternIndex == -1) {
            throw new IllegalArgumentException("no pattern {0} or pattern {1} in fallbackPattern");
        }
        if (firstPatternIndex > secondPatternIndex) {
            this.fFirstDateInPtnIsLaterDate = true;
        }
        this.fFallbackIntervalPattern = fallbackPattern;
    }

    private final boolean $$robo$$android_icu_text_DateIntervalInfo$getDefaultOrder() {
        return this.fFirstDateInPtnIsLaterDate;
    }

    private final Object $$robo$$android_icu_text_DateIntervalInfo$clone() {
        if (this.frozen) {
            return this;
        }
        return this.cloneUnfrozenDII();
    }

    private final Object $$robo$$android_icu_text_DateIntervalInfo$cloneUnfrozenDII() {
        try {
            DateIntervalInfo other = (DateIntervalInfo)super.clone();
            other.fFallbackIntervalPattern = this.fFallbackIntervalPattern;
            other.fFirstDateInPtnIsLaterDate = this.fFirstDateInPtnIsLaterDate;
            if (this.fIntervalPatternsReadOnly) {
                other.fIntervalPatterns = this.fIntervalPatterns;
                other.fIntervalPatternsReadOnly = true;
            } else {
                other.fIntervalPatterns = DateIntervalInfo.cloneIntervalPatterns(this.fIntervalPatterns);
                other.fIntervalPatternsReadOnly = false;
            }
            other.frozen = false;
            return other;
        }
        catch (CloneNotSupportedException e) {
            throw new ICUCloneNotSupportedException("clone is not supported", e);
        }
    }

    private static final Map<String, Map<String, PatternInfo>> $$robo$$android_icu_text_DateIntervalInfo$cloneIntervalPatterns(Map<String, Map<String, PatternInfo>> patterns) {
        HashMap<String, Map<String, PatternInfo>> result = new HashMap<String, Map<String, PatternInfo>>();
        for (Map.Entry<String, Map<String, PatternInfo>> skeletonEntry : patterns.entrySet()) {
            String skeleton = skeletonEntry.getKey();
            Map<String, PatternInfo> patternsOfOneSkeleton = skeletonEntry.getValue();
            HashMap<String, PatternInfo> oneSetPtn = new HashMap<String, PatternInfo>();
            for (Map.Entry<String, PatternInfo> calEntry : patternsOfOneSkeleton.entrySet()) {
                String calField = calEntry.getKey();
                PatternInfo value = calEntry.getValue();
                oneSetPtn.put(calField, value);
            }
            result.put(skeleton, oneSetPtn);
        }
        return result;
    }

    private final boolean $$robo$$android_icu_text_DateIntervalInfo$isFrozen() {
        return this.frozen;
    }

    private final DateIntervalInfo $$robo$$android_icu_text_DateIntervalInfo$freeze() {
        this.fIntervalPatternsReadOnly = true;
        this.frozen = true;
        return this;
    }

    private final DateIntervalInfo $$robo$$android_icu_text_DateIntervalInfo$cloneAsThawed() {
        DateIntervalInfo result = (DateIntervalInfo)this.cloneUnfrozenDII();
        return result;
    }

    private static final void $$robo$$android_icu_text_DateIntervalInfo$parseSkeleton(String skeleton, int[] skeletonFieldWidth) {
        int PATTERN_CHAR_BASE = 65;
        for (int i = 0; i < skeleton.length(); ++i) {
            int n = skeleton.charAt(i) - PATTERN_CHAR_BASE;
            skeletonFieldWidth[n] = skeletonFieldWidth[n] + 1;
        }
    }

    private static final boolean $$robo$$android_icu_text_DateIntervalInfo$stringNumeric(int fieldWidth, int anotherFieldWidth, char patternLetter) {
        return patternLetter == 'M' && (fieldWidth <= 2 && anotherFieldWidth > 2 || fieldWidth > 2 && anotherFieldWidth <= 2);
    }

    private final DateIntervalFormat.BestMatchInfo $$robo$$android_icu_text_DateIntervalInfo$getBestSkeleton(String inputSkeleton) {
        String bestSkeleton = inputSkeleton;
        int[] inputSkeletonFieldWidth = new int[58];
        int[] skeletonFieldWidth = new int[58];
        int DIFFERENT_FIELD = 4096;
        int STRING_NUMERIC_DIFFERENCE = 256;
        int BASE = 65;
        boolean replaceZWithV = false;
        if (inputSkeleton.indexOf(122) != -1) {
            inputSkeleton = inputSkeleton.replace('z', 'v');
            replaceZWithV = true;
        }
        DateIntervalInfo.parseSkeleton(inputSkeleton, inputSkeletonFieldWidth);
        int bestDistance = Integer.MAX_VALUE;
        int bestFieldDifference = 0;
        for (String skeleton : this.fIntervalPatterns.keySet()) {
            for (int i = 0; i < skeletonFieldWidth.length; ++i) {
                skeletonFieldWidth[i] = 0;
            }
            DateIntervalInfo.parseSkeleton(skeleton, skeletonFieldWidth);
            int distance = 0;
            int fieldDifference = 1;
            for (int i = 0; i < inputSkeletonFieldWidth.length; ++i) {
                int inputFieldWidth = inputSkeletonFieldWidth[i];
                int fieldWidth = skeletonFieldWidth[i];
                if (inputFieldWidth == fieldWidth) continue;
                if (inputFieldWidth == 0) {
                    fieldDifference = -1;
                    distance += 4096;
                    continue;
                }
                if (fieldWidth == 0) {
                    fieldDifference = -1;
                    distance += 4096;
                    continue;
                }
                if (DateIntervalInfo.stringNumeric(inputFieldWidth, fieldWidth, (char)(i + 65))) {
                    distance += 256;
                    continue;
                }
                distance += Math.abs(inputFieldWidth - fieldWidth);
            }
            if (distance < bestDistance) {
                bestSkeleton = skeleton;
                bestDistance = distance;
                bestFieldDifference = fieldDifference;
            }
            if (distance != 0) continue;
            bestFieldDifference = 0;
            break;
        }
        if (replaceZWithV && bestFieldDifference != -1) {
            bestFieldDifference = 2;
        }
        return new DateIntervalFormat.BestMatchInfo(bestSkeleton, bestFieldDifference);
    }

    private final boolean $$robo$$android_icu_text_DateIntervalInfo$equals(Object a) {
        if (a instanceof DateIntervalInfo) {
            DateIntervalInfo dtInfo = (DateIntervalInfo)a;
            return this.fIntervalPatterns.equals(dtInfo.fIntervalPatterns);
        }
        return false;
    }

    private final int $$robo$$android_icu_text_DateIntervalInfo$hashCode() {
        return this.fIntervalPatterns.hashCode();
    }

    @Deprecated
    private final Map<String, Set<String>> $$robo$$android_icu_text_DateIntervalInfo$getPatterns() {
        LinkedHashMap<String, Set<String>> result = new LinkedHashMap<String, Set<String>>();
        for (Map.Entry<String, Map<String, PatternInfo>> entry : this.fIntervalPatterns.entrySet()) {
            result.put(entry.getKey(), new LinkedHashSet<String>(entry.getValue().keySet()));
        }
        return result;
    }

    @Deprecated
    private final Map<String, Map<String, PatternInfo>> $$robo$$android_icu_text_DateIntervalInfo$getRawPatterns() {
        LinkedHashMap<String, Map<String, PatternInfo>> result = new LinkedHashMap<String, Map<String, PatternInfo>>();
        for (Map.Entry<String, Map<String, PatternInfo>> entry : this.fIntervalPatterns.entrySet()) {
            result.put(entry.getKey(), new LinkedHashMap<String, PatternInfo>(entry.getValue()));
        }
        return result;
    }

    static void __staticInitializer__() {
        CALENDAR_FIELD_TO_PATTERN_LETTER = new String[]{"G", "y", "M", "w", "W", "d", "D", "E", "F", "a", "h", "H", "m", "s", "S", "z", " ", "Y", "e", "u", "g", "A", " ", " "};
        CALENDAR_KEY = "calendar";
        INTERVAL_FORMATS_KEY = "intervalFormats";
        FALLBACK_STRING = "fallback";
        LATEST_FIRST_PREFIX = "latestFirst:";
        EARLIEST_FIRST_PREFIX = "earliestFirst:";
        DIICACHE = new SimpleCache<String, DateIntervalInfo>();
    }

    private void __constructor__() {
        this.$$robo$$android_icu_text_DateIntervalInfo$__constructor__();
    }

    public DateIntervalInfo() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_DateIntervalInfo$__constructor__(), this);
    }

    private void __constructor__(ULocale uLocale) {
        this.$$robo$$android_icu_text_DateIntervalInfo$__constructor__(uLocale);
    }

    public DateIntervalInfo(ULocale uLocale) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_DateIntervalInfo$__constructor__(android.icu.util.ULocale ), this, uLocale);
    }

    private void __constructor__(Locale locale) {
        this.$$robo$$android_icu_text_DateIntervalInfo$__constructor__(locale);
    }

    public DateIntervalInfo(Locale locale) {
        this(ULocale.forLocale(locale));
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_DateIntervalInfo$__constructor__(java.util.Locale ), this, locale);
    }

    private void initializeData(ULocale uLocale) {
        InvokeDynamicSupport.bootstrap("initializeData", $$robo$$android_icu_text_DateIntervalInfo$initializeData(android.icu.util.ULocale ), this, uLocale);
    }

    private void initializeFromReadOnlyPatterns(DateIntervalInfo dateIntervalInfo) {
        InvokeDynamicSupport.bootstrap("initializeFromReadOnlyPatterns", $$robo$$android_icu_text_DateIntervalInfo$initializeFromReadOnlyPatterns(android.icu.text.DateIntervalInfo ), this, dateIntervalInfo);
    }

    private void setup(ULocale uLocale) {
        InvokeDynamicSupport.bootstrap("setup", $$robo$$android_icu_text_DateIntervalInfo$setup(android.icu.util.ULocale ), this, uLocale);
    }

    private static int splitPatternInto2Part(String string2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("splitPatternInto2Part", $$robo$$android_icu_text_DateIntervalInfo$splitPatternInto2Part(java.lang.String ), (String)string2);
    }

    public void setIntervalPattern(String string2, int n, String string3) {
        InvokeDynamicSupport.bootstrap("setIntervalPattern", $$robo$$android_icu_text_DateIntervalInfo$setIntervalPattern(java.lang.String int java.lang.String ), this, string2, n, string3);
    }

    private PatternInfo setIntervalPatternInternally(String string2, String string3, String string4) {
        return InvokeDynamicSupport.bootstrap("setIntervalPatternInternally", $$robo$$android_icu_text_DateIntervalInfo$setIntervalPatternInternally(java.lang.String java.lang.String java.lang.String ), this, string2, string3, string4);
    }

    private void setIntervalPattern(String string2, String string3, PatternInfo patternInfo) {
        InvokeDynamicSupport.bootstrap("setIntervalPattern", $$robo$$android_icu_text_DateIntervalInfo$setIntervalPattern(java.lang.String java.lang.String android.icu.text.DateIntervalInfo$PatternInfo ), this, string2, string3, patternInfo);
    }

    @Deprecated
    public static PatternInfo genPatternInfo(String string2, boolean bl) {
        return InvokeDynamicSupport.bootstrapStatic("genPatternInfo", $$robo$$android_icu_text_DateIntervalInfo$genPatternInfo(java.lang.String boolean ), (String)string2, (boolean)bl);
    }

    public PatternInfo getIntervalPattern(String string2, int n) {
        return InvokeDynamicSupport.bootstrap("getIntervalPattern", $$robo$$android_icu_text_DateIntervalInfo$getIntervalPattern(java.lang.String int ), this, string2, n);
    }

    public String getFallbackIntervalPattern() {
        return InvokeDynamicSupport.bootstrap("getFallbackIntervalPattern", $$robo$$android_icu_text_DateIntervalInfo$getFallbackIntervalPattern(), this);
    }

    public void setFallbackIntervalPattern(String string2) {
        InvokeDynamicSupport.bootstrap("setFallbackIntervalPattern", $$robo$$android_icu_text_DateIntervalInfo$setFallbackIntervalPattern(java.lang.String ), this, string2);
    }

    public boolean getDefaultOrder() {
        return (boolean)InvokeDynamicSupport.bootstrap("getDefaultOrder", $$robo$$android_icu_text_DateIntervalInfo$getDefaultOrder(), this);
    }

    public Object clone() {
        return InvokeDynamicSupport.bootstrap("clone", $$robo$$android_icu_text_DateIntervalInfo$clone(), this);
    }

    private Object cloneUnfrozenDII() {
        return InvokeDynamicSupport.bootstrap("cloneUnfrozenDII", $$robo$$android_icu_text_DateIntervalInfo$cloneUnfrozenDII(), this);
    }

    private static Map<String, Map<String, PatternInfo>> cloneIntervalPatterns(Map<String, Map<String, PatternInfo>> map) {
        return InvokeDynamicSupport.bootstrapStatic("cloneIntervalPatterns", $$robo$$android_icu_text_DateIntervalInfo$cloneIntervalPatterns(java.util.Map<java.lang.String, java.util.Map<java.lang.String, android.icu.text.DateIntervalInfo$PatternInfo>> ), map);
    }

    @Override
    public boolean isFrozen() {
        return (boolean)InvokeDynamicSupport.bootstrap("isFrozen", $$robo$$android_icu_text_DateIntervalInfo$isFrozen(), this);
    }

    @Override
    public DateIntervalInfo freeze() {
        return InvokeDynamicSupport.bootstrap("freeze", $$robo$$android_icu_text_DateIntervalInfo$freeze(), this);
    }

    @Override
    public DateIntervalInfo cloneAsThawed() {
        return InvokeDynamicSupport.bootstrap("cloneAsThawed", $$robo$$android_icu_text_DateIntervalInfo$cloneAsThawed(), this);
    }

    static void parseSkeleton(String string2, int[] nArray) {
        InvokeDynamicSupport.bootstrapStatic("parseSkeleton", $$robo$$android_icu_text_DateIntervalInfo$parseSkeleton(java.lang.String int[] ), (String)string2, (int[])nArray);
    }

    private static boolean stringNumeric(int n, int n2, char c) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("stringNumeric", $$robo$$android_icu_text_DateIntervalInfo$stringNumeric(int int char ), (int)n, (int)n2, (char)c);
    }

    DateIntervalFormat.BestMatchInfo getBestSkeleton(String string2) {
        return InvokeDynamicSupport.bootstrap("getBestSkeleton", $$robo$$android_icu_text_DateIntervalInfo$getBestSkeleton(java.lang.String ), this, string2);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_icu_text_DateIntervalInfo$equals(java.lang.Object ), this, object);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_icu_text_DateIntervalInfo$hashCode(), this);
    }

    @Deprecated
    public Map<String, Set<String>> getPatterns() {
        return InvokeDynamicSupport.bootstrap("getPatterns", $$robo$$android_icu_text_DateIntervalInfo$getPatterns(), this);
    }

    @Deprecated
    public Map<String, Map<String, PatternInfo>> getRawPatterns() {
        return InvokeDynamicSupport.bootstrap("getRawPatterns", $$robo$$android_icu_text_DateIntervalInfo$getRawPatterns(), this);
    }

    static {
        RobolectricInternals.classInitializing(DateIntervalInfo.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DateIntervalInfo)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class DateIntervalSink
    extends UResource.Sink
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private static String ACCEPTED_PATTERN_LETTERS = "yMdahHms";
        DateIntervalInfo dateIntervalInfo;
        String nextCalendarType;
        private static String DATE_INTERVAL_PATH_PREFIX;
        private static String DATE_INTERVAL_PATH_SUFFIX;

        private void $$robo$$android_icu_text_DateIntervalInfo_DateIntervalSink$__constructor__(DateIntervalInfo dateIntervalInfo) {
            this.dateIntervalInfo = dateIntervalInfo;
        }

        private final void $$robo$$android_icu_text_DateIntervalInfo_DateIntervalSink$put(UResource.Key key, UResource.Value value, boolean noFallback) {
            UResource.Table dateIntervalData = value.getTable();
            int i = 0;
            while (dateIntervalData.getKeyAndValue(i, key, value)) {
                if (key.contentEquals(INTERVAL_FORMATS_KEY)) {
                    if (value.getType() == 3) {
                        this.nextCalendarType = this.getCalendarTypeFromPath(value.getAliasString());
                        break;
                    }
                    if (value.getType() == 2) {
                        UResource.Table skeletonData = value.getTable();
                        int j = 0;
                        while (skeletonData.getKeyAndValue(j, key, value)) {
                            if (value.getType() == 2) {
                                this.processSkeletonTable(key, value);
                            }
                            ++j;
                        }
                        break;
                    }
                }
                ++i;
            }
        }

        private final void $$robo$$android_icu_text_DateIntervalInfo_DateIntervalSink$processSkeletonTable(UResource.Key key, UResource.Value value) {
            String currentSkeleton = key.toString();
            UResource.Table patternData = value.getTable();
            int k = 0;
            while (patternData.getKeyAndValue(k, key, value)) {
                CharSequence patternLetter;
                if (value.getType() == 0 && (patternLetter = this.validateAndProcessPatternLetter(key)) != null) {
                    String lrgDiffCalUnit = patternLetter.toString();
                    this.setIntervalPatternIfAbsent(currentSkeleton, lrgDiffCalUnit, value);
                }
                ++k;
            }
        }

        private final String $$robo$$android_icu_text_DateIntervalInfo_DateIntervalSink$getAndResetNextCalendarType() {
            String tmpCalendarType = this.nextCalendarType;
            this.nextCalendarType = null;
            return tmpCalendarType;
        }

        private final String $$robo$$android_icu_text_DateIntervalInfo_DateIntervalSink$getCalendarTypeFromPath(String path) {
            if (path.startsWith(DATE_INTERVAL_PATH_PREFIX) && path.endsWith(DATE_INTERVAL_PATH_SUFFIX)) {
                return path.substring(DATE_INTERVAL_PATH_PREFIX.length(), path.length() - DATE_INTERVAL_PATH_SUFFIX.length());
            }
            throw new ICUException("Malformed 'intervalFormat' alias path: " + path);
        }

        private final CharSequence $$robo$$android_icu_text_DateIntervalInfo_DateIntervalSink$validateAndProcessPatternLetter(CharSequence patternLetter) {
            if (patternLetter.length() != 1) {
                return null;
            }
            char letter = patternLetter.charAt(0);
            if ("yMdahHms".indexOf(letter) < 0) {
                return null;
            }
            if (letter == CALENDAR_FIELD_TO_PATTERN_LETTER[11].charAt(0)) {
                patternLetter = CALENDAR_FIELD_TO_PATTERN_LETTER[10];
            }
            return patternLetter;
        }

        private final void $$robo$$android_icu_text_DateIntervalInfo_DateIntervalSink$setIntervalPatternIfAbsent(String currentSkeleton, String lrgDiffCalUnit, UResource.Value intervalPattern) {
            Map patternsOfOneSkeleton = (Map)this.dateIntervalInfo.fIntervalPatterns.get(currentSkeleton);
            if (patternsOfOneSkeleton == null || !patternsOfOneSkeleton.containsKey(lrgDiffCalUnit)) {
                this.dateIntervalInfo.setIntervalPatternInternally(currentSkeleton, lrgDiffCalUnit, intervalPattern.toString());
            }
        }

        static void __staticInitializer__() {
            DATE_INTERVAL_PATH_PREFIX = "/LOCALE/" + CALENDAR_KEY + "/";
            DATE_INTERVAL_PATH_SUFFIX = "/" + INTERVAL_FORMATS_KEY;
        }

        private void __constructor__(DateIntervalInfo dateIntervalInfo) {
            this.$$robo$$android_icu_text_DateIntervalInfo_DateIntervalSink$__constructor__(dateIntervalInfo);
        }

        public DateIntervalSink(DateIntervalInfo dateIntervalInfo) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_DateIntervalInfo_DateIntervalSink$__constructor__(android.icu.text.DateIntervalInfo ), this, dateIntervalInfo);
        }

        @Override
        public void put(UResource.Key key, UResource.Value value, boolean bl) {
            InvokeDynamicSupport.bootstrap("put", $$robo$$android_icu_text_DateIntervalInfo_DateIntervalSink$put(android.icu.impl.UResource$Key android.icu.impl.UResource$Value boolean ), this, key, value, bl);
        }

        public void processSkeletonTable(UResource.Key key, UResource.Value value) {
            InvokeDynamicSupport.bootstrap("processSkeletonTable", $$robo$$android_icu_text_DateIntervalInfo_DateIntervalSink$processSkeletonTable(android.icu.impl.UResource$Key android.icu.impl.UResource$Value ), this, key, value);
        }

        public String getAndResetNextCalendarType() {
            return InvokeDynamicSupport.bootstrap("getAndResetNextCalendarType", $$robo$$android_icu_text_DateIntervalInfo_DateIntervalSink$getAndResetNextCalendarType(), this);
        }

        private String getCalendarTypeFromPath(String string2) {
            return InvokeDynamicSupport.bootstrap("getCalendarTypeFromPath", $$robo$$android_icu_text_DateIntervalInfo_DateIntervalSink$getCalendarTypeFromPath(java.lang.String ), this, string2);
        }

        private CharSequence validateAndProcessPatternLetter(CharSequence charSequence) {
            return InvokeDynamicSupport.bootstrap("validateAndProcessPatternLetter", $$robo$$android_icu_text_DateIntervalInfo_DateIntervalSink$validateAndProcessPatternLetter(java.lang.CharSequence ), this, charSequence);
        }

        private void setIntervalPatternIfAbsent(String string2, String string3, UResource.Value value) {
            InvokeDynamicSupport.bootstrap("setIntervalPatternIfAbsent", $$robo$$android_icu_text_DateIntervalInfo_DateIntervalSink$setIntervalPatternIfAbsent(java.lang.String java.lang.String android.icu.impl.UResource$Value ), this, string2, string3, value);
        }

        static {
            RobolectricInternals.classInitializing(DateIntervalSink.class);
        }

        public /* synthetic */ DateIntervalSink() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DateIntervalSink)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class PatternInfo
    implements Cloneable,
    Serializable,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        static int currentSerialVersion = 1;
        private static long serialVersionUID = 1L;
        private String fIntervalPatternFirstPart;
        private String fIntervalPatternSecondPart;
        private boolean fFirstDateInPtnIsLaterDate;

        private void $$robo$$android_icu_text_DateIntervalInfo_PatternInfo$__constructor__(String firstPart, String secondPart, boolean firstDateInPtnIsLaterDate) {
            this.fIntervalPatternFirstPart = firstPart;
            this.fIntervalPatternSecondPart = secondPart;
            this.fFirstDateInPtnIsLaterDate = firstDateInPtnIsLaterDate;
        }

        private final String $$robo$$android_icu_text_DateIntervalInfo_PatternInfo$getFirstPart() {
            return this.fIntervalPatternFirstPart;
        }

        private final String $$robo$$android_icu_text_DateIntervalInfo_PatternInfo$getSecondPart() {
            return this.fIntervalPatternSecondPart;
        }

        private final boolean $$robo$$android_icu_text_DateIntervalInfo_PatternInfo$firstDateInPtnIsLaterDate() {
            return this.fFirstDateInPtnIsLaterDate;
        }

        private final boolean $$robo$$android_icu_text_DateIntervalInfo_PatternInfo$equals(Object a) {
            if (a instanceof PatternInfo) {
                PatternInfo patternInfo = (PatternInfo)a;
                return Utility.objectEquals(this.fIntervalPatternFirstPart, patternInfo.fIntervalPatternFirstPart) && Utility.objectEquals(this.fIntervalPatternSecondPart, patternInfo.fIntervalPatternSecondPart) && this.fFirstDateInPtnIsLaterDate == patternInfo.fFirstDateInPtnIsLaterDate;
            }
            return false;
        }

        private final int $$robo$$android_icu_text_DateIntervalInfo_PatternInfo$hashCode() {
            int hash;
            int n = hash = this.fIntervalPatternFirstPart != null ? this.fIntervalPatternFirstPart.hashCode() : 0;
            if (this.fIntervalPatternSecondPart != null) {
                hash ^= this.fIntervalPatternSecondPart.hashCode();
            }
            if (this.fFirstDateInPtnIsLaterDate) {
                hash ^= 0xFFFFFFFF;
            }
            return hash;
        }

        @Deprecated
        private final String $$robo$$android_icu_text_DateIntervalInfo_PatternInfo$toString() {
            return "{first=\u00ab" + this.fIntervalPatternFirstPart + "\u00bb, second=\u00ab" + this.fIntervalPatternSecondPart + "\u00bb, reversed:" + this.fFirstDateInPtnIsLaterDate + "}";
        }

        private void __constructor__(String string2, String string3, boolean bl) {
            this.$$robo$$android_icu_text_DateIntervalInfo_PatternInfo$__constructor__(string2, string3, bl);
        }

        public PatternInfo(String string2, String string3, boolean bl) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_DateIntervalInfo_PatternInfo$__constructor__(java.lang.String java.lang.String boolean ), this, string2, string3, bl);
        }

        public String getFirstPart() {
            return InvokeDynamicSupport.bootstrap("getFirstPart", $$robo$$android_icu_text_DateIntervalInfo_PatternInfo$getFirstPart(), this);
        }

        public String getSecondPart() {
            return InvokeDynamicSupport.bootstrap("getSecondPart", $$robo$$android_icu_text_DateIntervalInfo_PatternInfo$getSecondPart(), this);
        }

        public boolean firstDateInPtnIsLaterDate() {
            return (boolean)InvokeDynamicSupport.bootstrap("firstDateInPtnIsLaterDate", $$robo$$android_icu_text_DateIntervalInfo_PatternInfo$firstDateInPtnIsLaterDate(), this);
        }

        public boolean equals(Object object) {
            return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_icu_text_DateIntervalInfo_PatternInfo$equals(java.lang.Object ), this, object);
        }

        public int hashCode() {
            return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_icu_text_DateIntervalInfo_PatternInfo$hashCode(), this);
        }

        @Deprecated
        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_icu_text_DateIntervalInfo_PatternInfo$toString(), this);
        }

        public /* synthetic */ PatternInfo() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PatternInfo)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

