/*
 * Decompiled with CFR 0.152.
 */
package android.icu.text;

import android.icu.impl.PatternProps;
import android.icu.impl.Utility;
import android.icu.text.DecimalFormatSymbols;
import android.icu.text.NFRuleSet;
import android.icu.text.NFSubstitution;
import android.icu.text.PluralFormat;
import android.icu.text.PluralRules;
import android.icu.text.RbnfLenientScanner;
import android.icu.text.RuleBasedNumberFormat;
import com.google.errorprone.annotations.DoNotMock;
import java.text.FieldPosition;
import java.text.ParsePosition;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class NFRule
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    static int NEGATIVE_NUMBER_RULE = -1;
    static int IMPROPER_FRACTION_RULE = -2;
    static int PROPER_FRACTION_RULE = -3;
    static int MASTER_RULE = -4;
    static int INFINITY_RULE = -5;
    static int NAN_RULE = -6;
    static Long ZERO;
    private long baseValue;
    private int radix;
    private short exponent;
    private char decimalPoint;
    private String ruleText;
    private PluralFormat rulePatternFormat;
    private NFSubstitution sub1;
    private NFSubstitution sub2;
    private RuleBasedNumberFormat formatter;
    private static String[] RULE_PREFIXES;
    static /* synthetic */ boolean $assertionsDisabled;

    private static final void $$robo$$android_icu_text_NFRule$makeRules(String description, NFRuleSet owner, NFRule predecessor, RuleBasedNumberFormat ownersOwner, List<NFRule> returnList) {
        int brack2;
        NFRule rule1 = new NFRule(ownersOwner, description);
        description = rule1.ruleText;
        int brack1 = description.indexOf(91);
        int n = brack2 = brack1 < 0 ? -1 : description.indexOf(93);
        if (brack2 < 0 || brack1 > brack2 || rule1.baseValue == -3L || rule1.baseValue == -1L || rule1.baseValue == -5L || rule1.baseValue == -6L) {
            rule1.extractSubstitutions(owner, description, predecessor);
        } else {
            NFRule rule2 = null;
            StringBuilder sbuf = new StringBuilder();
            if (rule1.baseValue > 0L && rule1.baseValue % NFRule.power(rule1.radix, rule1.exponent) == 0L || rule1.baseValue == -2L || rule1.baseValue == -4L) {
                rule2 = new NFRule(ownersOwner, null);
                if (rule1.baseValue >= 0L) {
                    rule2.baseValue = rule1.baseValue++;
                    if (!owner.isFractionSet()) {
                        // empty if block
                    }
                } else if (rule1.baseValue == -2L) {
                    rule2.baseValue = -3L;
                } else if (rule1.baseValue == -4L) {
                    rule2.baseValue = rule1.baseValue;
                    rule1.baseValue = -2L;
                }
                rule2.radix = rule1.radix;
                rule2.exponent = rule1.exponent;
                sbuf.append(description.substring(0, brack1));
                if (brack2 + 1 < description.length()) {
                    sbuf.append(description.substring(brack2 + 1));
                }
                rule2.extractSubstitutions(owner, sbuf.toString(), predecessor);
            }
            sbuf.setLength(0);
            sbuf.append(description.substring(0, brack1));
            sbuf.append(description.substring(brack1 + 1, brack2));
            if (brack2 + 1 < description.length()) {
                sbuf.append(description.substring(brack2 + 1));
            }
            rule1.extractSubstitutions(owner, sbuf.toString(), predecessor);
            if (rule2 != null) {
                if (rule2.baseValue >= 0L) {
                    returnList.add(rule2);
                } else {
                    owner.setNonNumericalRule(rule2);
                }
            }
        }
        if (rule1.baseValue >= 0L) {
            returnList.add(rule1);
        } else {
            owner.setNonNumericalRule(rule1);
        }
    }

    private void $$robo$$android_icu_text_NFRule$__constructor__(RuleBasedNumberFormat formatter, String ruleText) {
        this.radix = 10;
        this.exponent = 0;
        this.decimalPoint = '\u0000';
        this.ruleText = null;
        this.rulePatternFormat = null;
        this.sub1 = null;
        this.sub2 = null;
        this.formatter = formatter;
        this.ruleText = ruleText == null ? null : this.parseRuleDescriptor(ruleText);
    }

    private final String $$robo$$android_icu_text_NFRule$parseRuleDescriptor(String description) {
        int p = description.indexOf(":");
        if (p != -1) {
            String descriptor = description.substring(0, p);
            ++p;
            while (p < description.length() && PatternProps.isWhiteSpace(description.charAt(p))) {
                ++p;
            }
            description = description.substring(p);
            int descriptorLength = descriptor.length();
            char firstChar = descriptor.charAt(0);
            char lastChar = descriptor.charAt(descriptorLength - 1);
            if (firstChar >= '0' && firstChar <= '9' && lastChar != 'x') {
                long tempValue = 0L;
                char c = '\u0000';
                for (p = 0; p < descriptorLength; ++p) {
                    c = descriptor.charAt(p);
                    if (c >= '0' && c <= '9') {
                        tempValue = tempValue * 10L + (long)(c - 48);
                        continue;
                    }
                    if (c == '/' || c == '>') break;
                    if (PatternProps.isWhiteSpace(c) || c == ',' || c == '.') continue;
                    throw new IllegalArgumentException("Illegal character " + c + " in rule descriptor");
                }
                this.setBaseValue(tempValue);
                if (c == '/') {
                    tempValue = 0L;
                    ++p;
                    while (p < descriptorLength) {
                        c = descriptor.charAt(p);
                        if (c >= '0' && c <= '9') {
                            tempValue = tempValue * 10L + (long)(c - 48);
                        } else {
                            if (c == '>') break;
                            if (!PatternProps.isWhiteSpace(c) && c != ',' && c != '.') {
                                throw new IllegalArgumentException("Illegal character " + c + " in rule descriptor");
                            }
                        }
                        ++p;
                    }
                    this.radix = (int)tempValue;
                    if (this.radix == 0) {
                        throw new IllegalArgumentException("Rule can't have radix of 0");
                    }
                    this.exponent = this.expectedExponent();
                }
                if (c == '>') {
                    while (p < descriptorLength) {
                        c = descriptor.charAt(p);
                        if (c != '>' || this.exponent <= 0) {
                            throw new IllegalArgumentException("Illegal character in rule descriptor");
                        }
                        this.exponent = (short)(this.exponent - 1);
                        ++p;
                    }
                }
            } else if (descriptor.equals("-x")) {
                this.setBaseValue(-1L);
            } else if (descriptorLength == 3) {
                if (firstChar == '0' && lastChar == 'x') {
                    this.setBaseValue(-3L);
                    this.decimalPoint = descriptor.charAt(1);
                } else if (firstChar == 'x' && lastChar == 'x') {
                    this.setBaseValue(-2L);
                    this.decimalPoint = descriptor.charAt(1);
                } else if (firstChar == 'x' && lastChar == '0') {
                    this.setBaseValue(-4L);
                    this.decimalPoint = descriptor.charAt(1);
                } else if (descriptor.equals("NaN")) {
                    this.setBaseValue(-6L);
                } else if (descriptor.equals("Inf")) {
                    this.setBaseValue(-5L);
                }
            }
        }
        if (description.length() > 0 && description.charAt(0) == '\'') {
            description = description.substring(1);
        }
        return description;
    }

    private final void $$robo$$android_icu_text_NFRule$extractSubstitutions(NFRuleSet owner, String ruleText, NFRule predecessor) {
        int pluralRuleEnd;
        this.ruleText = ruleText;
        this.sub1 = this.extractSubstitution(owner, predecessor);
        this.sub2 = this.sub1 == null ? null : this.extractSubstitution(owner, predecessor);
        ruleText = this.ruleText;
        int pluralRuleStart = ruleText.indexOf("$(");
        int n = pluralRuleEnd = pluralRuleStart >= 0 ? ruleText.indexOf(")$", pluralRuleStart) : -1;
        if (pluralRuleEnd >= 0) {
            PluralRules.PluralType pluralType;
            int endType = ruleText.indexOf(44, pluralRuleStart);
            if (endType < 0) {
                throw new IllegalArgumentException("Rule \"" + ruleText + "\" does not have a defined type");
            }
            String type = this.ruleText.substring(pluralRuleStart + 2, endType);
            if ("cardinal".equals(type)) {
                pluralType = PluralRules.PluralType.CARDINAL;
            } else if ("ordinal".equals(type)) {
                pluralType = PluralRules.PluralType.ORDINAL;
            } else {
                throw new IllegalArgumentException(type + " is an unknown type");
            }
            this.rulePatternFormat = this.formatter.createPluralFormat(pluralType, ruleText.substring(endType + 1, pluralRuleEnd));
        }
    }

    private final NFSubstitution $$robo$$android_icu_text_NFRule$extractSubstitution(NFRuleSet owner, NFRule predecessor) {
        int subEnd;
        int subStart = NFRule.indexOfAnyRulePrefix(this.ruleText);
        if (subStart == -1) {
            return null;
        }
        if (this.ruleText.startsWith(">>>", subStart)) {
            subEnd = subStart + 2;
        } else {
            char c = this.ruleText.charAt(subStart);
            subEnd = this.ruleText.indexOf(c, subStart + 1);
            if (c == '<' && subEnd != -1 && subEnd < this.ruleText.length() - 1 && this.ruleText.charAt(subEnd + 1) == c) {
                ++subEnd;
            }
        }
        if (subEnd == -1) {
            return null;
        }
        NFSubstitution result = NFSubstitution.makeSubstitution(subStart, this, predecessor, owner, this.formatter, this.ruleText.substring(subStart, subEnd + 1));
        this.ruleText = this.ruleText.substring(0, subStart) + this.ruleText.substring(subEnd + 1);
        return result;
    }

    private final void $$robo$$android_icu_text_NFRule$setBaseValue(long newBaseValue) {
        this.baseValue = newBaseValue;
        this.radix = 10;
        if (this.baseValue >= 1L) {
            this.exponent = this.expectedExponent();
            if (this.sub1 != null) {
                this.sub1.setDivisor(this.radix, this.exponent);
            }
            if (this.sub2 != null) {
                this.sub2.setDivisor(this.radix, this.exponent);
            }
        } else {
            this.exponent = 0;
        }
    }

    private final short $$robo$$android_icu_text_NFRule$expectedExponent() {
        if (this.radix == 0 || this.baseValue < 1L) {
            return 0;
        }
        short tempResult = (short)(Math.log(this.baseValue) / Math.log(this.radix));
        if (NFRule.power(this.radix, (short)(tempResult + 1)) <= this.baseValue) {
            return (short)(tempResult + 1);
        }
        return tempResult;
    }

    private static final int $$robo$$android_icu_text_NFRule$indexOfAnyRulePrefix(String ruleText) {
        int result = -1;
        if (ruleText.length() > 0) {
            for (String string2 : RULE_PREFIXES) {
                int pos = ruleText.indexOf(string2);
                if (pos == -1 || result != -1 && pos >= result) continue;
                result = pos;
            }
        }
        return result;
    }

    private final boolean $$robo$$android_icu_text_NFRule$equals(Object that) {
        if (that instanceof NFRule) {
            NFRule that2 = (NFRule)that;
            return this.baseValue == that2.baseValue && this.radix == that2.radix && this.exponent == that2.exponent && this.ruleText.equals(that2.ruleText) && Utility.objectEquals(this.sub1, that2.sub1) && Utility.objectEquals(this.sub2, that2.sub2);
        }
        return false;
    }

    private final int $$robo$$android_icu_text_NFRule$hashCode() {
        if (!$assertionsDisabled) {
            throw new AssertionError((Object)"hashCode not designed");
        }
        return 42;
    }

    private final String $$robo$$android_icu_text_NFRule$toString() {
        StringBuilder result = new StringBuilder();
        if (this.baseValue == -1L) {
            result.append("-x: ");
        } else if (this.baseValue == -2L) {
            result.append('x').append(this.decimalPoint == '\u0000' ? (char)'.' : (char)this.decimalPoint).append("x: ");
        } else if (this.baseValue == -3L) {
            result.append('0').append(this.decimalPoint == '\u0000' ? (char)'.' : (char)this.decimalPoint).append("x: ");
        } else if (this.baseValue == -4L) {
            result.append('x').append(this.decimalPoint == '\u0000' ? (char)'.' : (char)this.decimalPoint).append("0: ");
        } else if (this.baseValue == -5L) {
            result.append("Inf: ");
        } else if (this.baseValue == -6L) {
            result.append("NaN: ");
        } else {
            result.append(String.valueOf(this.baseValue));
            if (this.radix != 10) {
                result.append('/').append(this.radix);
            }
            int numCarets = this.expectedExponent() - this.exponent;
            for (int i = 0; i < numCarets; ++i) {
                result.append('>');
            }
            result.append(": ");
        }
        if (this.ruleText.startsWith(" ") && (this.sub1 == null || this.sub1.getPos() != 0)) {
            result.append('\'');
        }
        StringBuilder ruleTextCopy = new StringBuilder(this.ruleText);
        if (this.sub2 != null) {
            ruleTextCopy.insert(this.sub2.getPos(), this.sub2.toString());
        }
        if (this.sub1 != null) {
            ruleTextCopy.insert(this.sub1.getPos(), this.sub1.toString());
        }
        result.append(ruleTextCopy.toString());
        result.append(';');
        return result.toString();
    }

    private final char $$robo$$android_icu_text_NFRule$getDecimalPoint() {
        return this.decimalPoint;
    }

    private final long $$robo$$android_icu_text_NFRule$getBaseValue() {
        return this.baseValue;
    }

    private final long $$robo$$android_icu_text_NFRule$getDivisor() {
        return NFRule.power(this.radix, this.exponent);
    }

    private final void $$robo$$android_icu_text_NFRule$doFormat(long number, StringBuilder toInsertInto, int pos, int recursionCount) {
        int pluralRuleStart = this.ruleText.length();
        int lengthOffset = 0;
        if (this.rulePatternFormat == null) {
            toInsertInto.insert(pos, this.ruleText);
        } else {
            pluralRuleStart = this.ruleText.indexOf("$(");
            int pluralRuleEnd = this.ruleText.indexOf(")$", pluralRuleStart);
            int initialLength = toInsertInto.length();
            if (pluralRuleEnd < this.ruleText.length() - 1) {
                toInsertInto.insert(pos, this.ruleText.substring(pluralRuleEnd + 2));
            }
            toInsertInto.insert(pos, this.rulePatternFormat.format(number / NFRule.power(this.radix, this.exponent)));
            if (pluralRuleStart > 0) {
                toInsertInto.insert(pos, this.ruleText.substring(0, pluralRuleStart));
            }
            lengthOffset = this.ruleText.length() - (toInsertInto.length() - initialLength);
        }
        if (this.sub2 != null) {
            this.sub2.doSubstitution(number, toInsertInto, pos - (this.sub2.getPos() > pluralRuleStart ? lengthOffset : 0), recursionCount);
        }
        if (this.sub1 != null) {
            this.sub1.doSubstitution(number, toInsertInto, pos - (this.sub1.getPos() > pluralRuleStart ? lengthOffset : 0), recursionCount);
        }
    }

    private final void $$robo$$android_icu_text_NFRule$doFormat(double number, StringBuilder toInsertInto, int pos, int recursionCount) {
        int pluralRuleStart = this.ruleText.length();
        int lengthOffset = 0;
        if (this.rulePatternFormat == null) {
            toInsertInto.insert(pos, this.ruleText);
        } else {
            double pluralVal;
            pluralRuleStart = this.ruleText.indexOf("$(");
            int pluralRuleEnd = this.ruleText.indexOf(")$", pluralRuleStart);
            int initialLength = toInsertInto.length();
            if (pluralRuleEnd < this.ruleText.length() - 1) {
                toInsertInto.insert(pos, this.ruleText.substring(pluralRuleEnd + 2));
            }
            pluralVal = 0.0 <= (pluralVal = number) && pluralVal < 1.0 ? (double)Math.round(pluralVal * (double)NFRule.power(this.radix, this.exponent)) : (pluralVal /= (double)NFRule.power(this.radix, this.exponent));
            toInsertInto.insert(pos, this.rulePatternFormat.format((long)pluralVal));
            if (pluralRuleStart > 0) {
                toInsertInto.insert(pos, this.ruleText.substring(0, pluralRuleStart));
            }
            lengthOffset = this.ruleText.length() - (toInsertInto.length() - initialLength);
        }
        if (this.sub2 != null) {
            this.sub2.doSubstitution(number, toInsertInto, pos - (this.sub2.getPos() > pluralRuleStart ? lengthOffset : 0), recursionCount);
        }
        if (this.sub1 != null) {
            this.sub1.doSubstitution(number, toInsertInto, pos - (this.sub1.getPos() > pluralRuleStart ? lengthOffset : 0), recursionCount);
        }
    }

    private static final long $$robo$$android_icu_text_NFRule$power(long base, short exponent) {
        if (exponent < 0) {
            throw new IllegalArgumentException("Exponent can not be negative");
        }
        if (base < 0L) {
            throw new IllegalArgumentException("Base can not be negative");
        }
        long result = 1L;
        while (exponent > 0) {
            if ((exponent & 1) == 1) {
                result *= base;
            }
            base *= base;
            exponent = (short)(exponent >> 1);
        }
        return result;
    }

    private final boolean $$robo$$android_icu_text_NFRule$shouldRollBack(long number) {
        if (!(this.sub1 != null && this.sub1.isModulusSubstitution() || this.sub2 != null && this.sub2.isModulusSubstitution())) {
            return false;
        }
        long divisor = NFRule.power(this.radix, this.exponent);
        return number % divisor == 0L && this.baseValue % divisor != 0L;
    }

    private final Number $$robo$$android_icu_text_NFRule$doParse(String text, ParsePosition parsePosition, boolean isFractionRule, double upperBound) {
        ParsePosition pp = new ParsePosition(0);
        int sub1Pos = this.sub1 != null ? this.sub1.getPos() : this.ruleText.length();
        int sub2Pos = this.sub2 != null ? this.sub2.getPos() : this.ruleText.length();
        String workText = this.stripPrefix(text, this.ruleText.substring(0, sub1Pos), pp);
        int prefixLength = text.length() - workText.length();
        if (pp.getIndex() == 0 && sub1Pos != 0) {
            return ZERO;
        }
        if (this.baseValue == -5L) {
            parsePosition.setIndex(pp.getIndex());
            return Double.POSITIVE_INFINITY;
        }
        if (this.baseValue == -6L) {
            parsePosition.setIndex(pp.getIndex());
            return Double.NaN;
        }
        int highWaterMark = 0;
        double result = 0.0;
        int start = 0;
        double tempBaseValue = Math.max(0L, this.baseValue);
        do {
            pp.setIndex(0);
            double partialResult = this.matchToDelimiter(workText, start, tempBaseValue, this.ruleText.substring(sub1Pos, sub2Pos), this.rulePatternFormat, pp, this.sub1, upperBound).doubleValue();
            if (pp.getIndex() == 0 && this.sub1 != null) continue;
            start = pp.getIndex();
            String workText2 = workText.substring(pp.getIndex());
            ParsePosition pp2 = new ParsePosition(0);
            partialResult = this.matchToDelimiter(workText2, 0, partialResult, this.ruleText.substring(sub2Pos), this.rulePatternFormat, pp2, this.sub2, upperBound).doubleValue();
            if (pp2.getIndex() == 0 && this.sub2 != null || prefixLength + pp.getIndex() + pp2.getIndex() <= highWaterMark) continue;
            highWaterMark = prefixLength + pp.getIndex() + pp2.getIndex();
            result = partialResult;
        } while (sub1Pos != sub2Pos && pp.getIndex() > 0 && pp.getIndex() < workText.length() && pp.getIndex() != start);
        parsePosition.setIndex(highWaterMark);
        if (isFractionRule && highWaterMark > 0 && this.sub1 == null) {
            result = 1.0 / result;
        }
        if (result == (double)((long)result)) {
            return (long)result;
        }
        return new Double(result);
    }

    private final String $$robo$$android_icu_text_NFRule$stripPrefix(String text, String prefix, ParsePosition pp) {
        if (prefix.length() == 0) {
            return text;
        }
        int pfl = this.prefixLength(text, prefix);
        if (pfl != 0) {
            pp.setIndex(pp.getIndex() + pfl);
            return text.substring(pfl);
        }
        return text;
    }

    private final Number $$robo$$android_icu_text_NFRule$matchToDelimiter(String text, int startPos, double baseVal, String delimiter, PluralFormat pluralFormatDelimiter, ParsePosition pp, NFSubstitution sub, double upperBound) {
        if (!this.allIgnorable(delimiter)) {
            ParsePosition tempPP = new ParsePosition(0);
            int[] temp = this.findText(text, delimiter, pluralFormatDelimiter, startPos);
            int dPos = temp[0];
            int dLen = temp[1];
            while (dPos >= 0) {
                String subText = text.substring(0, dPos);
                if (subText.length() > 0) {
                    Number tempResult = sub.doParse(subText, tempPP, baseVal, upperBound, this.formatter.lenientParseEnabled());
                    if (tempPP.getIndex() == dPos) {
                        pp.setIndex(dPos + dLen);
                        return tempResult;
                    }
                }
                tempPP.setIndex(0);
                temp = this.findText(text, delimiter, pluralFormatDelimiter, dPos + dLen);
                dPos = temp[0];
                dLen = temp[1];
            }
            pp.setIndex(0);
            return ZERO;
        }
        if (sub == null) {
            return baseVal;
        }
        ParsePosition tempPP = new ParsePosition(0);
        Number result = ZERO;
        Number tempResult = sub.doParse(text, tempPP, baseVal, upperBound, this.formatter.lenientParseEnabled());
        if (tempPP.getIndex() != 0) {
            pp.setIndex(tempPP.getIndex());
            if (tempResult != null) {
                result = tempResult;
            }
        }
        return result;
    }

    private final int $$robo$$android_icu_text_NFRule$prefixLength(String str, String prefix) {
        if (prefix.length() == 0) {
            return 0;
        }
        RbnfLenientScanner scanner = this.formatter.getLenientScanner();
        if (scanner != null) {
            return scanner.prefixLength(str, prefix);
        }
        if (str.startsWith(prefix)) {
            return prefix.length();
        }
        return 0;
    }

    private final int[] $$robo$$android_icu_text_NFRule$findText(String str, String key, PluralFormat pluralFormatKey, int startingAt) {
        RbnfLenientScanner scanner = this.formatter.getLenientScanner();
        if (pluralFormatKey != null) {
            FieldPosition position = new FieldPosition(0);
            position.setBeginIndex(startingAt);
            pluralFormatKey.parseType(str, scanner, position);
            int start = position.getBeginIndex();
            if (start >= 0) {
                int pluralRuleStart = this.ruleText.indexOf("$(");
                int pluralRuleSuffix = this.ruleText.indexOf(")$", pluralRuleStart) + 2;
                int matchLen = position.getEndIndex() - start;
                String prefix = this.ruleText.substring(0, pluralRuleStart);
                String suffix = this.ruleText.substring(pluralRuleSuffix);
                if (str.regionMatches(start - prefix.length(), prefix, 0, prefix.length()) && str.regionMatches(start + matchLen, suffix, 0, suffix.length())) {
                    return new int[]{start - prefix.length(), matchLen + prefix.length() + suffix.length()};
                }
            }
            return new int[]{-1, 0};
        }
        if (scanner != null) {
            return scanner.findText(str, key, startingAt);
        }
        return new int[]{str.indexOf(key, startingAt), key.length()};
    }

    private final boolean $$robo$$android_icu_text_NFRule$allIgnorable(String str) {
        if (str == null || str.length() == 0) {
            return true;
        }
        RbnfLenientScanner scanner = this.formatter.getLenientScanner();
        return scanner != null && scanner.allIgnorable(str);
    }

    private final void $$robo$$android_icu_text_NFRule$setDecimalFormatSymbols(DecimalFormatSymbols newSymbols) {
        if (this.sub1 != null) {
            this.sub1.setDecimalFormatSymbols(newSymbols);
        }
        if (this.sub2 != null) {
            this.sub2.setDecimalFormatSymbols(newSymbols);
        }
    }

    static void __staticInitializer__() {
        $assertionsDisabled = !NFRule.class.desiredAssertionStatus();
        ZERO = 0L;
        RULE_PREFIXES = new String[]{"<<", "<%", "<#", "<0", ">>", ">%", ">#", ">0", "=%", "=#", "=0"};
    }

    public static void makeRules(String string2, NFRuleSet nFRuleSet, NFRule nFRule, RuleBasedNumberFormat ruleBasedNumberFormat, List<NFRule> list) {
        InvokeDynamicSupport.bootstrapStatic("makeRules", $$robo$$android_icu_text_NFRule$makeRules(java.lang.String android.icu.text.NFRuleSet android.icu.text.NFRule android.icu.text.RuleBasedNumberFormat java.util.List<android.icu.text.NFRule> ), (String)string2, (NFRuleSet)nFRuleSet, (NFRule)nFRule, (RuleBasedNumberFormat)ruleBasedNumberFormat, list);
    }

    private void __constructor__(RuleBasedNumberFormat ruleBasedNumberFormat, String string2) {
        this.$$robo$$android_icu_text_NFRule$__constructor__(ruleBasedNumberFormat, string2);
    }

    public NFRule(RuleBasedNumberFormat ruleBasedNumberFormat, String string2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_NFRule$__constructor__(android.icu.text.RuleBasedNumberFormat java.lang.String ), this, ruleBasedNumberFormat, string2);
    }

    private String parseRuleDescriptor(String string2) {
        return InvokeDynamicSupport.bootstrap("parseRuleDescriptor", $$robo$$android_icu_text_NFRule$parseRuleDescriptor(java.lang.String ), this, string2);
    }

    private void extractSubstitutions(NFRuleSet nFRuleSet, String string2, NFRule nFRule) {
        InvokeDynamicSupport.bootstrap("extractSubstitutions", $$robo$$android_icu_text_NFRule$extractSubstitutions(android.icu.text.NFRuleSet java.lang.String android.icu.text.NFRule ), this, nFRuleSet, string2, nFRule);
    }

    private NFSubstitution extractSubstitution(NFRuleSet nFRuleSet, NFRule nFRule) {
        return InvokeDynamicSupport.bootstrap("extractSubstitution", $$robo$$android_icu_text_NFRule$extractSubstitution(android.icu.text.NFRuleSet android.icu.text.NFRule ), this, nFRuleSet, nFRule);
    }

    void setBaseValue(long l) {
        InvokeDynamicSupport.bootstrap("setBaseValue", $$robo$$android_icu_text_NFRule$setBaseValue(long ), this, l);
    }

    private short expectedExponent() {
        return (short)InvokeDynamicSupport.bootstrap("expectedExponent", $$robo$$android_icu_text_NFRule$expectedExponent(), this);
    }

    private static int indexOfAnyRulePrefix(String string2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("indexOfAnyRulePrefix", $$robo$$android_icu_text_NFRule$indexOfAnyRulePrefix(java.lang.String ), (String)string2);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_icu_text_NFRule$equals(java.lang.Object ), this, object);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_icu_text_NFRule$hashCode(), this);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_icu_text_NFRule$toString(), this);
    }

    public char getDecimalPoint() {
        return (char)InvokeDynamicSupport.bootstrap("getDecimalPoint", $$robo$$android_icu_text_NFRule$getDecimalPoint(), this);
    }

    public long getBaseValue() {
        return (long)InvokeDynamicSupport.bootstrap("getBaseValue", $$robo$$android_icu_text_NFRule$getBaseValue(), this);
    }

    public long getDivisor() {
        return (long)InvokeDynamicSupport.bootstrap("getDivisor", $$robo$$android_icu_text_NFRule$getDivisor(), this);
    }

    public void doFormat(long l, StringBuilder stringBuilder, int n, int n2) {
        InvokeDynamicSupport.bootstrap("doFormat", $$robo$$android_icu_text_NFRule$doFormat(long java.lang.StringBuilder int int ), this, l, stringBuilder, n, n2);
    }

    public void doFormat(double d, StringBuilder stringBuilder, int n, int n2) {
        InvokeDynamicSupport.bootstrap("doFormat", $$robo$$android_icu_text_NFRule$doFormat(double java.lang.StringBuilder int int ), this, d, stringBuilder, n, n2);
    }

    static long power(long l, short s) {
        return (long)InvokeDynamicSupport.bootstrapStatic("power", $$robo$$android_icu_text_NFRule$power(long short ), (long)l, (short)s);
    }

    public boolean shouldRollBack(long l) {
        return (boolean)InvokeDynamicSupport.bootstrap("shouldRollBack", $$robo$$android_icu_text_NFRule$shouldRollBack(long ), this, l);
    }

    public Number doParse(String string2, ParsePosition parsePosition, boolean bl, double d) {
        return InvokeDynamicSupport.bootstrap("doParse", $$robo$$android_icu_text_NFRule$doParse(java.lang.String java.text.ParsePosition boolean double ), this, string2, parsePosition, bl, d);
    }

    private String stripPrefix(String string2, String string3, ParsePosition parsePosition) {
        return InvokeDynamicSupport.bootstrap("stripPrefix", $$robo$$android_icu_text_NFRule$stripPrefix(java.lang.String java.lang.String java.text.ParsePosition ), this, string2, string3, parsePosition);
    }

    private Number matchToDelimiter(String string2, int n, double d, String string3, PluralFormat pluralFormat, ParsePosition parsePosition, NFSubstitution nFSubstitution, double d2) {
        return InvokeDynamicSupport.bootstrap("matchToDelimiter", $$robo$$android_icu_text_NFRule$matchToDelimiter(java.lang.String int double java.lang.String android.icu.text.PluralFormat java.text.ParsePosition android.icu.text.NFSubstitution double ), this, string2, n, d, string3, pluralFormat, parsePosition, nFSubstitution, d2);
    }

    private int prefixLength(String string2, String string3) {
        return (int)InvokeDynamicSupport.bootstrap("prefixLength", $$robo$$android_icu_text_NFRule$prefixLength(java.lang.String java.lang.String ), this, string2, string3);
    }

    private int[] findText(String string2, String string3, PluralFormat pluralFormat, int n) {
        return InvokeDynamicSupport.bootstrap("findText", $$robo$$android_icu_text_NFRule$findText(java.lang.String java.lang.String android.icu.text.PluralFormat int ), this, string2, string3, pluralFormat, n);
    }

    private boolean allIgnorable(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("allIgnorable", $$robo$$android_icu_text_NFRule$allIgnorable(java.lang.String ), this, string2);
    }

    public void setDecimalFormatSymbols(DecimalFormatSymbols decimalFormatSymbols) {
        InvokeDynamicSupport.bootstrap("setDecimalFormatSymbols", $$robo$$android_icu_text_NFRule$setDecimalFormatSymbols(android.icu.text.DecimalFormatSymbols ), this, decimalFormatSymbols);
    }

    static {
        RobolectricInternals.classInitializing(NFRule.class);
    }

    public /* synthetic */ NFRule() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NFRule)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

