/*
 * Decompiled with CFR 0.152.
 */
package android.icu.text;

import android.icu.impl.CacheBase;
import android.icu.impl.ICUResourceBundle;
import android.icu.impl.SoftCache;
import android.icu.util.ULocale;
import android.icu.util.UResourceBundle;
import android.icu.util.UResourceBundleIterator;
import java.util.ArrayList;
import java.util.Locale;
import java.util.MissingResourceException;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class NumberingSystem
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String[] OTHER_NS_KEYWORDS;
    private String desc;
    private int radix;
    private boolean algorithmic;
    private String name;
    private static CacheBase<String, NumberingSystem, LocaleLookupData> cachedLocaleData;
    private static CacheBase<String, NumberingSystem, Void> cachedStringData;

    private void $$robo$$android_icu_text_NumberingSystem$__constructor__() {
        this.radix = 10;
        this.algorithmic = false;
        this.desc = "0123456789";
        this.name = "latn";
    }

    private static final NumberingSystem $$robo$$android_icu_text_NumberingSystem$getInstance(int radix_in, boolean isAlgorithmic_in, String desc_in) {
        return NumberingSystem.getInstance(null, radix_in, isAlgorithmic_in, desc_in);
    }

    private static final NumberingSystem $$robo$$android_icu_text_NumberingSystem$getInstance(String name_in, int radix_in, boolean isAlgorithmic_in, String desc_in) {
        if (radix_in < 2) {
            throw new IllegalArgumentException("Invalid radix for numbering system");
        }
        if (!(isAlgorithmic_in || desc_in.length() == radix_in && NumberingSystem.isValidDigitString(desc_in))) {
            throw new IllegalArgumentException("Invalid digit string for numbering system");
        }
        NumberingSystem ns = new NumberingSystem();
        ns.radix = radix_in;
        ns.algorithmic = isAlgorithmic_in;
        ns.desc = desc_in;
        ns.name = name_in;
        return ns;
    }

    private static final NumberingSystem $$robo$$android_icu_text_NumberingSystem$getInstance(Locale inLocale) {
        return NumberingSystem.getInstance(ULocale.forLocale(inLocale));
    }

    private static final NumberingSystem $$robo$$android_icu_text_NumberingSystem$getInstance(ULocale locale) {
        boolean nsResolved = true;
        String numbersKeyword = locale.getKeywordValue("numbers");
        if (numbersKeyword != null) {
            for (String keyword : OTHER_NS_KEYWORDS) {
                if (!numbersKeyword.equals(keyword)) continue;
                nsResolved = false;
                break;
            }
        } else {
            numbersKeyword = "default";
            nsResolved = false;
        }
        if (nsResolved) {
            NumberingSystem ns = NumberingSystem.getInstanceByName(numbersKeyword);
            if (ns != null) {
                return ns;
            }
            numbersKeyword = "default";
        }
        String baseName = locale.getBaseName();
        String key = baseName + "@numbers=" + numbersKeyword;
        LocaleLookupData localeLookupData = new LocaleLookupData(locale, numbersKeyword);
        return cachedLocaleData.getInstance(key, localeLookupData);
    }

    private static final NumberingSystem $$robo$$android_icu_text_NumberingSystem$lookupInstanceByLocale(LocaleLookupData localeLookupData) {
        ICUResourceBundle rb;
        ULocale locale = localeLookupData.locale;
        try {
            rb = (ICUResourceBundle)UResourceBundle.getBundleInstance("android/icu/impl/data/icudt58b", locale);
            rb = rb.getWithFallback("NumberElements");
        }
        catch (MissingResourceException ex) {
            return new NumberingSystem();
        }
        String numbersKeyword = localeLookupData.numbersKeyword;
        String resolvedNumberingSystem = null;
        while (true) {
            try {
                resolvedNumberingSystem = rb.getStringWithFallback(numbersKeyword);
            }
            catch (MissingResourceException ex) {
                if (numbersKeyword.equals("native") || numbersKeyword.equals("finance")) {
                    numbersKeyword = "default";
                    continue;
                }
                if (!numbersKeyword.equals("traditional")) break;
                numbersKeyword = "native";
                continue;
            }
            break;
        }
        NumberingSystem ns = null;
        if (resolvedNumberingSystem != null) {
            ns = NumberingSystem.getInstanceByName(resolvedNumberingSystem);
        }
        if (ns == null) {
            ns = new NumberingSystem();
        }
        return ns;
    }

    private static final NumberingSystem $$robo$$android_icu_text_NumberingSystem$getInstance() {
        return NumberingSystem.getInstance(ULocale.getDefault(ULocale.Category.FORMAT));
    }

    private static final NumberingSystem $$robo$$android_icu_text_NumberingSystem$getInstanceByName(String name) {
        return cachedStringData.getInstance(name, null);
    }

    private static final NumberingSystem $$robo$$android_icu_text_NumberingSystem$lookupInstanceByName(String name) {
        boolean isAlgorithmic;
        int radix;
        String description;
        try {
            UResourceBundle numberingSystemsInfo = UResourceBundle.getBundleInstance("android/icu/impl/data/icudt58b", "numberingSystems");
            UResourceBundle nsCurrent = numberingSystemsInfo.get("numberingSystems");
            UResourceBundle nsTop = nsCurrent.get(name);
            description = nsTop.getString("desc");
            UResourceBundle nsRadixBundle = nsTop.get("radix");
            UResourceBundle nsAlgBundle = nsTop.get("algorithmic");
            radix = nsRadixBundle.getInt();
            int algorithmic = nsAlgBundle.getInt();
            isAlgorithmic = algorithmic == 1;
        }
        catch (MissingResourceException ex) {
            return null;
        }
        return NumberingSystem.getInstance(name, radix, isAlgorithmic, description);
    }

    private static final String[] $$robo$$android_icu_text_NumberingSystem$getAvailableNames() {
        UResourceBundle numberingSystemsInfo = UResourceBundle.getBundleInstance("android/icu/impl/data/icudt58b", "numberingSystems");
        UResourceBundle nsCurrent = numberingSystemsInfo.get("numberingSystems");
        ArrayList<String> output = new ArrayList<String>();
        UResourceBundleIterator it = nsCurrent.getIterator();
        while (it.hasNext()) {
            UResourceBundle temp = it.next();
            String nsName = temp.getKey();
            output.add(nsName);
        }
        return output.toArray(new String[output.size()]);
    }

    private static final boolean $$robo$$android_icu_text_NumberingSystem$isValidDigitString(String str) {
        int numCodepoints = str.codePointCount(0, str.length());
        return numCodepoints == 10;
    }

    private final int $$robo$$android_icu_text_NumberingSystem$getRadix() {
        return this.radix;
    }

    private final String $$robo$$android_icu_text_NumberingSystem$getDescription() {
        return this.desc;
    }

    private final String $$robo$$android_icu_text_NumberingSystem$getName() {
        return this.name;
    }

    private final boolean $$robo$$android_icu_text_NumberingSystem$isAlgorithmic() {
        return this.algorithmic;
    }

    static void __staticInitializer__() {
        OTHER_NS_KEYWORDS = new String[]{"native", "traditional", "finance"};
        cachedLocaleData = new SoftCache<String, NumberingSystem, LocaleLookupData>(){
            public /* synthetic */ Object __robo_data__;

            private void $$robo$$android_icu_text_NumberingSystem_1$__constructor__() {
            }

            private final NumberingSystem $$robo$$android_icu_text_NumberingSystem_1$createInstance(String key, LocaleLookupData localeLookupData) {
                return NumberingSystem.lookupInstanceByLocale(localeLookupData);
            }

            private void __constructor__() {
                this.$$robo$$android_icu_text_NumberingSystem_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_NumberingSystem_1$__constructor__(), this);
            }

            @Override
            protected NumberingSystem createInstance(String string2, LocaleLookupData localeLookupData) {
                return InvokeDynamicSupport.bootstrap("createInstance", $$robo$$android_icu_text_NumberingSystem_1$createInstance(java.lang.String android.icu.text.NumberingSystem$LocaleLookupData ), this, string2, localeLookupData);
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        cachedStringData = new SoftCache<String, NumberingSystem, Void>(){
            public /* synthetic */ Object __robo_data__;

            private void $$robo$$android_icu_text_NumberingSystem_2$__constructor__() {
            }

            private final NumberingSystem $$robo$$android_icu_text_NumberingSystem_2$createInstance(String key, Void unused) {
                return NumberingSystem.lookupInstanceByName(key);
            }

            private void __constructor__() {
                this.$$robo$$android_icu_text_NumberingSystem_2$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_NumberingSystem_2$__constructor__(), this);
            }

            @Override
            protected NumberingSystem createInstance(String string2, Void void_) {
                return InvokeDynamicSupport.bootstrap("createInstance", $$robo$$android_icu_text_NumberingSystem_2$createInstance(java.lang.String java.lang.Void ), this, string2, void_);
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__() {
        this.$$robo$$android_icu_text_NumberingSystem$__constructor__();
    }

    public NumberingSystem() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_NumberingSystem$__constructor__(), this);
    }

    public static NumberingSystem getInstance(int n, boolean bl, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$android_icu_text_NumberingSystem$getInstance(int boolean java.lang.String ), (int)n, (boolean)bl, (String)string2);
    }

    private static NumberingSystem getInstance(String string2, int n, boolean bl, String string3) {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$android_icu_text_NumberingSystem$getInstance(java.lang.String int boolean java.lang.String ), (String)string2, (int)n, (boolean)bl, (String)string3);
    }

    public static NumberingSystem getInstance(Locale locale) {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$android_icu_text_NumberingSystem$getInstance(java.util.Locale ), (Locale)locale);
    }

    public static NumberingSystem getInstance(ULocale uLocale) {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$android_icu_text_NumberingSystem$getInstance(android.icu.util.ULocale ), (ULocale)uLocale);
    }

    static NumberingSystem lookupInstanceByLocale(LocaleLookupData localeLookupData) {
        return InvokeDynamicSupport.bootstrapStatic("lookupInstanceByLocale", $$robo$$android_icu_text_NumberingSystem$lookupInstanceByLocale(android.icu.text.NumberingSystem$LocaleLookupData ), (LocaleLookupData)localeLookupData);
    }

    public static NumberingSystem getInstance() {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$android_icu_text_NumberingSystem$getInstance());
    }

    public static NumberingSystem getInstanceByName(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("getInstanceByName", $$robo$$android_icu_text_NumberingSystem$getInstanceByName(java.lang.String ), (String)string2);
    }

    private static NumberingSystem lookupInstanceByName(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("lookupInstanceByName", $$robo$$android_icu_text_NumberingSystem$lookupInstanceByName(java.lang.String ), (String)string2);
    }

    public static String[] getAvailableNames() {
        return InvokeDynamicSupport.bootstrapStatic("getAvailableNames", $$robo$$android_icu_text_NumberingSystem$getAvailableNames());
    }

    public static boolean isValidDigitString(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isValidDigitString", $$robo$$android_icu_text_NumberingSystem$isValidDigitString(java.lang.String ), (String)string2);
    }

    public int getRadix() {
        return (int)InvokeDynamicSupport.bootstrap("getRadix", $$robo$$android_icu_text_NumberingSystem$getRadix(), this);
    }

    public String getDescription() {
        return InvokeDynamicSupport.bootstrap("getDescription", $$robo$$android_icu_text_NumberingSystem$getDescription(), this);
    }

    public String getName() {
        return InvokeDynamicSupport.bootstrap("getName", $$robo$$android_icu_text_NumberingSystem$getName(), this);
    }

    public boolean isAlgorithmic() {
        return (boolean)InvokeDynamicSupport.bootstrap("isAlgorithmic", $$robo$$android_icu_text_NumberingSystem$isAlgorithmic(), this);
    }

    static {
        RobolectricInternals.classInitializing(NumberingSystem.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NumberingSystem)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class LocaleLookupData
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public ULocale locale;
        public String numbersKeyword;

        private void $$robo$$android_icu_text_NumberingSystem_LocaleLookupData$__constructor__(ULocale locale, String numbersKeyword) {
            this.locale = locale;
            this.numbersKeyword = numbersKeyword;
        }

        private void __constructor__(ULocale uLocale, String string2) {
            this.$$robo$$android_icu_text_NumberingSystem_LocaleLookupData$__constructor__(uLocale, string2);
        }

        public LocaleLookupData(ULocale uLocale, String string2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_NumberingSystem_LocaleLookupData$__constructor__(android.icu.util.ULocale java.lang.String ), this, uLocale, string2);
        }

        public /* synthetic */ LocaleLookupData() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LocaleLookupData)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

