/*
 * Decompiled with CFR 0.152.
 */
package android.icu.util;

import android.icu.impl.CalendarAstronomer;
import android.icu.impl.CalendarCache;
import android.icu.text.DateFormat;
import android.icu.util.Calendar;
import android.icu.util.SimpleTimeZone;
import android.icu.util.TimeZone;
import android.icu.util.ULocale;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Date;
import java.util.Locale;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ChineseCalendar
extends Calendar
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static long serialVersionUID = 7312110751940929420L;
    private int epochYear;
    private TimeZone zoneAstro;
    private transient CalendarAstronomer astro;
    private transient CalendarCache winterSolsticeCache;
    private transient CalendarCache newYearCache;
    private transient boolean isLeapYear;
    private static int[][] LIMITS;
    static int[][][] CHINESE_DATE_PRECEDENCE;
    private static int CHINESE_EPOCH_YEAR = -2636;
    private static TimeZone CHINA_ZONE;
    private static int SYNODIC_GAP = 25;

    private void $$robo$$android_icu_util_ChineseCalendar$__constructor__() {
    }

    private void $$robo$$android_icu_util_ChineseCalendar$__constructor__(Date date) {
        this.setTime(date);
    }

    private void $$robo$$android_icu_util_ChineseCalendar$__constructor__(int year, int month, int isLeapMonth, int date) {
    }

    private void $$robo$$android_icu_util_ChineseCalendar$__constructor__(int year, int month, int isLeapMonth, int date, int hour, int minute, int second) {
        this.set(14, 0);
        this.set(1, year);
        this.set(2, month);
        this.set(22, isLeapMonth);
        this.set(5, date);
        this.set(11, hour);
        this.set(12, minute);
        this.set(13, second);
    }

    private void $$robo$$android_icu_util_ChineseCalendar$__constructor__(int era, int year, int month, int isLeapMonth, int date) {
    }

    private void $$robo$$android_icu_util_ChineseCalendar$__constructor__(int era, int year, int month, int isLeapMonth, int date, int hour, int minute, int second) {
        this.set(14, 0);
        this.set(0, era);
        this.set(1, year);
        this.set(2, month);
        this.set(22, isLeapMonth);
        this.set(5, date);
        this.set(11, hour);
        this.set(12, minute);
        this.set(13, second);
    }

    private void $$robo$$android_icu_util_ChineseCalendar$__constructor__(Locale aLocale) {
    }

    private void $$robo$$android_icu_util_ChineseCalendar$__constructor__(TimeZone zone) {
    }

    private void $$robo$$android_icu_util_ChineseCalendar$__constructor__(TimeZone zone, Locale aLocale) {
    }

    private void $$robo$$android_icu_util_ChineseCalendar$__constructor__(ULocale locale) {
    }

    private void $$robo$$android_icu_util_ChineseCalendar$__constructor__(TimeZone zone, ULocale locale) {
    }

    @Deprecated
    private void $$robo$$android_icu_util_ChineseCalendar$__constructor__(TimeZone zone, ULocale locale, int epochYear, TimeZone zoneAstroCalc) {
        this.astro = new CalendarAstronomer();
        this.winterSolsticeCache = new CalendarCache();
        this.newYearCache = new CalendarCache();
        this.epochYear = epochYear;
        this.zoneAstro = zoneAstroCalc;
        this.setTimeInMillis((long)InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System"));
    }

    private final int $$robo$$android_icu_util_ChineseCalendar$handleGetLimit(int field, int limitType) {
        return LIMITS[field][limitType];
    }

    private final int $$robo$$android_icu_util_ChineseCalendar$handleGetExtendedYear() {
        int year;
        if (this.newestStamp(0, 1, 0) <= this.getStamp(19)) {
            year = this.internalGet(19, 1);
        } else {
            int cycle = this.internalGet(0, 1) - 1;
            year = cycle * 60 + this.internalGet(1, 1) - (this.epochYear - -2636);
        }
        return year;
    }

    private final int $$robo$$android_icu_util_ChineseCalendar$handleGetMonthLength(int extendedYear, int month) {
        int thisStart = this.handleComputeMonthStart(extendedYear, month, true) - 2440588 + 1;
        int nextStart = this.newMoonNear(thisStart + 25, true);
        return nextStart - thisStart;
    }

    private final DateFormat $$robo$$android_icu_util_ChineseCalendar$handleGetDateFormat(String pattern, String override, ULocale locale) {
        return super.handleGetDateFormat(pattern, override, locale);
    }

    private final int[][][] $$robo$$android_icu_util_ChineseCalendar$getFieldResolutionTable() {
        return CHINESE_DATE_PRECEDENCE;
    }

    private final void $$robo$$android_icu_util_ChineseCalendar$offsetMonth(int newMoon, int dom, int delta) {
        newMoon += (int)(29.530588853 * ((double)delta - 0.5));
        newMoon = this.newMoonNear(newMoon, true);
        int jd = newMoon + 2440588 - 1 + dom;
        if (dom > 29) {
            this.set(20, jd - 1);
            this.complete();
            if (this.getActualMaximum(5) >= dom) {
                this.set(20, jd);
            }
        } else {
            this.set(20, jd);
        }
    }

    private final void $$robo$$android_icu_util_ChineseCalendar$add(int field, int amount) {
        switch (field) {
            case 2: {
                if (amount == 0) break;
                int dom = this.get(5);
                int day = this.get(20) - 2440588;
                int moon = day - dom + 1;
                this.offsetMonth(moon, dom, amount);
                break;
            }
            default: {
                super.add(field, amount);
            }
        }
    }

    private final void $$robo$$android_icu_util_ChineseCalendar$roll(int field, int amount) {
        switch (field) {
            case 2: {
                int n;
                int newM;
                if (amount == 0) break;
                int dom = this.get(5);
                int day = this.get(20) - 2440588;
                int moon = day - dom + 1;
                int m = this.get(2);
                if (this.isLeapYear) {
                    if (this.get(22) == 1) {
                        ++m;
                    } else {
                        int moon1 = moon - (int)(29.530588853 * ((double)m - 0.5));
                        if (this.isLeapMonthBetween(moon1 = this.newMoonNear(moon1, true), moon)) {
                            ++m;
                        }
                    }
                }
                if ((newM = (m + amount) % (n = this.isLeapYear ? 13 : 12)) < 0) {
                    newM += n;
                }
                if (newM == m) break;
                this.offsetMonth(moon, dom, newM - m);
                break;
            }
            default: {
                super.roll(field, amount);
            }
        }
    }

    private final long $$robo$$android_icu_util_ChineseCalendar$daysToMillis(int days) {
        long millis = (long)days * 86400000L;
        return millis - (long)this.zoneAstro.getOffset(millis);
    }

    private final int $$robo$$android_icu_util_ChineseCalendar$millisToDays(long millis) {
        return (int)ChineseCalendar.floorDivide(millis + (long)this.zoneAstro.getOffset(millis), 86400000L);
    }

    private final int $$robo$$android_icu_util_ChineseCalendar$winterSolstice(int gyear) {
        long cacheValue = this.winterSolsticeCache.get(gyear);
        if (cacheValue == CalendarCache.EMPTY) {
            long ms = this.daysToMillis(this.computeGregorianMonthStart(gyear, 11) + 1 - 2440588);
            this.astro.setTime(ms);
            long solarLong = this.astro.getSunTime(CalendarAstronomer.WINTER_SOLSTICE, true);
            cacheValue = this.millisToDays(solarLong);
            this.winterSolsticeCache.put(gyear, cacheValue);
        }
        return (int)cacheValue;
    }

    private final int $$robo$$android_icu_util_ChineseCalendar$newMoonNear(int days, boolean after) {
        this.astro.setTime(this.daysToMillis(days));
        long newMoon = this.astro.getMoonTime(CalendarAstronomer.NEW_MOON, after);
        return this.millisToDays(newMoon);
    }

    private final int $$robo$$android_icu_util_ChineseCalendar$synodicMonthsBetween(int day1, int day2) {
        return (int)Math.round((double)(day2 - day1) / 29.530588853);
    }

    private final int $$robo$$android_icu_util_ChineseCalendar$majorSolarTerm(int days) {
        this.astro.setTime(this.daysToMillis(days));
        int term = ((int)Math.floor(6.0 * this.astro.getSunLongitude() / Math.PI) + 2) % 12;
        if (term < 1) {
            term += 12;
        }
        return term;
    }

    private final boolean $$robo$$android_icu_util_ChineseCalendar$hasNoMajorSolarTerm(int newMoon) {
        int nmn;
        int mstt;
        int mst = this.majorSolarTerm(newMoon);
        return mst == (mstt = this.majorSolarTerm(nmn = this.newMoonNear(newMoon + 25, true)));
    }

    private final boolean $$robo$$android_icu_util_ChineseCalendar$isLeapMonthBetween(int newMoon1, int newMoon2) {
        if (this.synodicMonthsBetween(newMoon1, newMoon2) >= 50) {
            throw new IllegalArgumentException("isLeapMonthBetween(" + newMoon1 + ", " + newMoon2 + "): Invalid parameters");
        }
        return newMoon2 >= newMoon1 && (this.isLeapMonthBetween(newMoon1, this.newMoonNear(newMoon2 - 25, false)) || this.hasNoMajorSolarTerm(newMoon2));
    }

    private final void $$robo$$android_icu_util_ChineseCalendar$handleComputeFields(int julianDay) {
        this.computeChineseFields(julianDay - 2440588, this.getGregorianYear(), this.getGregorianMonth(), true);
    }

    private final void $$robo$$android_icu_util_ChineseCalendar$computeChineseFields(int days, int gyear, int gmonth, boolean setAllFields) {
        int solsticeBefore;
        int solsticeAfter = this.winterSolstice(gyear);
        if (days < solsticeAfter) {
            solsticeBefore = this.winterSolstice(gyear - 1);
        } else {
            solsticeBefore = solsticeAfter;
            solsticeAfter = this.winterSolstice(gyear + 1);
        }
        int firstMoon = this.newMoonNear(solsticeBefore + 1, true);
        int lastMoon = this.newMoonNear(solsticeAfter + 1, false);
        int thisMoon = this.newMoonNear(days + 1, false);
        this.isLeapYear = this.synodicMonthsBetween(firstMoon, lastMoon) == 12;
        int month = this.synodicMonthsBetween(firstMoon, thisMoon);
        if (this.isLeapYear && this.isLeapMonthBetween(firstMoon, thisMoon)) {
            --month;
        }
        if (month < 1) {
            month += 12;
        }
        boolean isLeapMonth = this.isLeapYear && this.hasNoMajorSolarTerm(thisMoon) && !this.isLeapMonthBetween(firstMoon, this.newMoonNear(thisMoon - 25, false));
        this.internalSet(2, month - 1);
        this.internalSet(22, isLeapMonth ? 1 : 0);
        if (setAllFields) {
            int extended_year = gyear - this.epochYear;
            int cycle_year = gyear - -2636;
            if (month < 11 || gmonth >= 6) {
                ++extended_year;
                ++cycle_year;
            }
            int dayOfMonth = days - thisMoon + 1;
            this.internalSet(19, extended_year);
            int[] yearOfCycle = new int[1];
            int cycle = ChineseCalendar.floorDivide(cycle_year - 1, 60, yearOfCycle);
            this.internalSet(0, cycle + 1);
            this.internalSet(1, yearOfCycle[0] + 1);
            this.internalSet(5, dayOfMonth);
            int newYear = this.newYear(gyear);
            if (days < newYear) {
                newYear = this.newYear(gyear - 1);
            }
            this.internalSet(6, days - newYear + 1);
        }
    }

    private final int $$robo$$android_icu_util_ChineseCalendar$newYear(int gyear) {
        long cacheValue = this.newYearCache.get(gyear);
        if (cacheValue == CalendarCache.EMPTY) {
            int solsticeBefore = this.winterSolstice(gyear - 1);
            int solsticeAfter = this.winterSolstice(gyear);
            int newMoon1 = this.newMoonNear(solsticeBefore + 1, true);
            int newMoon2 = this.newMoonNear(newMoon1 + 25, true);
            int newMoon11 = this.newMoonNear(solsticeAfter + 1, false);
            cacheValue = this.synodicMonthsBetween(newMoon1, newMoon11) == 12 && (this.hasNoMajorSolarTerm(newMoon1) || this.hasNoMajorSolarTerm(newMoon2)) ? (long)this.newMoonNear(newMoon2 + 25, true) : (long)newMoon2;
            this.newYearCache.put(gyear, cacheValue);
        }
        return (int)cacheValue;
    }

    private final int $$robo$$android_icu_util_ChineseCalendar$handleComputeMonthStart(int eyear, int month, boolean useMonth) {
        if (month < 0 || month > 11) {
            int[] rem = new int[1];
            eyear += ChineseCalendar.floorDivide(month, 12, rem);
            month = rem[0];
        }
        int gyear = eyear + this.epochYear - 1;
        int newYear = this.newYear(gyear);
        int newMoon = this.newMoonNear(newYear + month * 29, true);
        int julianDay = newMoon + 2440588;
        int saveMonth = this.internalGet(2);
        int saveIsLeapMonth = this.internalGet(22);
        int isLeapMonth = useMonth ? saveIsLeapMonth : 0;
        this.computeGregorianFields(julianDay);
        this.computeChineseFields(newMoon, this.getGregorianYear(), this.getGregorianMonth(), false);
        if (month != this.internalGet(2) || isLeapMonth != this.internalGet(22)) {
            newMoon = this.newMoonNear(newMoon + 25, true);
            julianDay = newMoon + 2440588;
        }
        this.internalSet(2, saveMonth);
        this.internalSet(22, saveIsLeapMonth);
        return julianDay - 1;
    }

    private final String $$robo$$android_icu_util_ChineseCalendar$getType() {
        return "chinese";
    }

    @Deprecated
    private final boolean $$robo$$android_icu_util_ChineseCalendar$haveDefaultCentury() {
        return false;
    }

    private final void $$robo$$android_icu_util_ChineseCalendar$readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        this.epochYear = -2636;
        this.zoneAstro = CHINA_ZONE;
        stream.defaultReadObject();
        this.astro = new CalendarAstronomer();
        this.winterSolsticeCache = new CalendarCache();
        this.newYearCache = new CalendarCache();
    }

    static void __staticInitializer__() {
        LIMITS = new int[][]{{1, 1, 83333, 83333}, {1, 1, 60, 60}, {0, 0, 11, 11}, {1, 1, 50, 55}, new int[0], {1, 1, 29, 30}, {1, 1, 353, 385}, new int[0], {-1, -1, 5, 5}, new int[0], new int[0], new int[0], new int[0], new int[0], new int[0], new int[0], new int[0], {-5000000, -5000000, 5000000, 5000000}, new int[0], {-5000000, -5000000, 5000000, 5000000}, new int[0], new int[0], {0, 0, 1, 1}};
        CHINESE_DATE_PRECEDENCE = new int[][][]{new int[][]{{5}, {3, 7}, {4, 7}, {8, 7}, {3, 18}, {4, 18}, {8, 18}, {6}, {37, 22}}, new int[][]{{3}, {4}, {8}, {40, 7}, {40, 18}}};
        CHINA_ZONE = new SimpleTimeZone(28800000, "CHINA_ZONE").freeze();
    }

    private void __constructor__() {
        this.$$robo$$android_icu_util_ChineseCalendar$__constructor__();
    }

    public ChineseCalendar() {
        this(TimeZone.getDefault(), ULocale.getDefault(ULocale.Category.FORMAT), -2636, CHINA_ZONE);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_util_ChineseCalendar$__constructor__(), this);
    }

    private void __constructor__(Date date) {
        this.$$robo$$android_icu_util_ChineseCalendar$__constructor__(date);
    }

    public ChineseCalendar(Date date) {
        this(TimeZone.getDefault(), ULocale.getDefault(ULocale.Category.FORMAT), -2636, CHINA_ZONE);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_util_ChineseCalendar$__constructor__(java.util.Date ), this, date);
    }

    private void __constructor__(int n, int n2, int n3, int n4) {
        this.$$robo$$android_icu_util_ChineseCalendar$__constructor__(n, n2, n3, n4);
    }

    public ChineseCalendar(int n, int n2, int n3, int n4) {
        this(n, n2, n3, n4, 0, 0, 0);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_util_ChineseCalendar$__constructor__(int int int int ), this, n, n2, n3, n4);
    }

    private void __constructor__(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        this.$$robo$$android_icu_util_ChineseCalendar$__constructor__(n, n2, n3, n4, n5, n6, n7);
    }

    public ChineseCalendar(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        this(TimeZone.getDefault(), ULocale.getDefault(ULocale.Category.FORMAT), -2636, CHINA_ZONE);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_util_ChineseCalendar$__constructor__(int int int int int int int ), this, n, n2, n3, n4, n5, n6, n7);
    }

    private void __constructor__(int n, int n2, int n3, int n4, int n5) {
        this.$$robo$$android_icu_util_ChineseCalendar$__constructor__(n, n2, n3, n4, n5);
    }

    public ChineseCalendar(int n, int n2, int n3, int n4, int n5) {
        this(n, n2, n3, n4, n5, 0, 0, 0);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_util_ChineseCalendar$__constructor__(int int int int int ), this, n, n2, n3, n4, n5);
    }

    private void __constructor__(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        this.$$robo$$android_icu_util_ChineseCalendar$__constructor__(n, n2, n3, n4, n5, n6, n7, n8);
    }

    public ChineseCalendar(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        this(TimeZone.getDefault(), ULocale.getDefault(ULocale.Category.FORMAT), -2636, CHINA_ZONE);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_util_ChineseCalendar$__constructor__(int int int int int int int int ), this, n, n2, n3, n4, n5, n6, n7, n8);
    }

    private void __constructor__(Locale locale) {
        this.$$robo$$android_icu_util_ChineseCalendar$__constructor__(locale);
    }

    public ChineseCalendar(Locale locale) {
        this(TimeZone.getDefault(), ULocale.forLocale(locale), -2636, CHINA_ZONE);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_util_ChineseCalendar$__constructor__(java.util.Locale ), this, locale);
    }

    private void __constructor__(TimeZone timeZone) {
        this.$$robo$$android_icu_util_ChineseCalendar$__constructor__(timeZone);
    }

    public ChineseCalendar(TimeZone timeZone) {
        this(timeZone, ULocale.getDefault(ULocale.Category.FORMAT), -2636, CHINA_ZONE);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_util_ChineseCalendar$__constructor__(android.icu.util.TimeZone ), this, timeZone);
    }

    private void __constructor__(TimeZone timeZone, Locale locale) {
        this.$$robo$$android_icu_util_ChineseCalendar$__constructor__(timeZone, locale);
    }

    public ChineseCalendar(TimeZone timeZone, Locale locale) {
        this(timeZone, ULocale.forLocale(locale), -2636, CHINA_ZONE);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_util_ChineseCalendar$__constructor__(android.icu.util.TimeZone java.util.Locale ), this, timeZone, locale);
    }

    private void __constructor__(ULocale uLocale) {
        this.$$robo$$android_icu_util_ChineseCalendar$__constructor__(uLocale);
    }

    public ChineseCalendar(ULocale uLocale) {
        this(TimeZone.getDefault(), uLocale, -2636, CHINA_ZONE);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_util_ChineseCalendar$__constructor__(android.icu.util.ULocale ), this, uLocale);
    }

    private void __constructor__(TimeZone timeZone, ULocale uLocale) {
        this.$$robo$$android_icu_util_ChineseCalendar$__constructor__(timeZone, uLocale);
    }

    public ChineseCalendar(TimeZone timeZone, ULocale uLocale) {
        this(timeZone, uLocale, -2636, CHINA_ZONE);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_util_ChineseCalendar$__constructor__(android.icu.util.TimeZone android.icu.util.ULocale ), this, timeZone, uLocale);
    }

    private void __constructor__(TimeZone timeZone, ULocale uLocale, int n, TimeZone timeZone2) {
        this.$$robo$$android_icu_util_ChineseCalendar$__constructor__(timeZone, uLocale, n, timeZone2);
    }

    public ChineseCalendar(TimeZone timeZone, ULocale uLocale, int n, TimeZone timeZone2) {
        super(timeZone, uLocale);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_util_ChineseCalendar$__constructor__(android.icu.util.TimeZone android.icu.util.ULocale int android.icu.util.TimeZone ), this, timeZone, uLocale, n, timeZone2);
    }

    @Override
    protected int handleGetLimit(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("handleGetLimit", $$robo$$android_icu_util_ChineseCalendar$handleGetLimit(int int ), this, n, n2);
    }

    @Override
    protected int handleGetExtendedYear() {
        return (int)InvokeDynamicSupport.bootstrap("handleGetExtendedYear", $$robo$$android_icu_util_ChineseCalendar$handleGetExtendedYear(), this);
    }

    @Override
    protected int handleGetMonthLength(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("handleGetMonthLength", $$robo$$android_icu_util_ChineseCalendar$handleGetMonthLength(int int ), this, n, n2);
    }

    @Override
    protected DateFormat handleGetDateFormat(String string2, String string3, ULocale uLocale) {
        return InvokeDynamicSupport.bootstrap("handleGetDateFormat", $$robo$$android_icu_util_ChineseCalendar$handleGetDateFormat(java.lang.String java.lang.String android.icu.util.ULocale ), this, string2, string3, uLocale);
    }

    @Override
    protected int[][][] getFieldResolutionTable() {
        return InvokeDynamicSupport.bootstrap("getFieldResolutionTable", $$robo$$android_icu_util_ChineseCalendar$getFieldResolutionTable(), this);
    }

    private void offsetMonth(int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrap("offsetMonth", $$robo$$android_icu_util_ChineseCalendar$offsetMonth(int int int ), this, n, n2, n3);
    }

    @Override
    public void add(int n, int n2) {
        InvokeDynamicSupport.bootstrap("add", $$robo$$android_icu_util_ChineseCalendar$add(int int ), this, n, n2);
    }

    @Override
    public void roll(int n, int n2) {
        InvokeDynamicSupport.bootstrap("roll", $$robo$$android_icu_util_ChineseCalendar$roll(int int ), this, n, n2);
    }

    private long daysToMillis(int n) {
        return (long)InvokeDynamicSupport.bootstrap("daysToMillis", $$robo$$android_icu_util_ChineseCalendar$daysToMillis(int ), this, n);
    }

    private int millisToDays(long l) {
        return (int)InvokeDynamicSupport.bootstrap("millisToDays", $$robo$$android_icu_util_ChineseCalendar$millisToDays(long ), this, l);
    }

    private int winterSolstice(int n) {
        return (int)InvokeDynamicSupport.bootstrap("winterSolstice", $$robo$$android_icu_util_ChineseCalendar$winterSolstice(int ), this, n);
    }

    private int newMoonNear(int n, boolean bl) {
        return (int)InvokeDynamicSupport.bootstrap("newMoonNear", $$robo$$android_icu_util_ChineseCalendar$newMoonNear(int boolean ), this, n, bl);
    }

    private int synodicMonthsBetween(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("synodicMonthsBetween", $$robo$$android_icu_util_ChineseCalendar$synodicMonthsBetween(int int ), this, n, n2);
    }

    private int majorSolarTerm(int n) {
        return (int)InvokeDynamicSupport.bootstrap("majorSolarTerm", $$robo$$android_icu_util_ChineseCalendar$majorSolarTerm(int ), this, n);
    }

    private boolean hasNoMajorSolarTerm(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("hasNoMajorSolarTerm", $$robo$$android_icu_util_ChineseCalendar$hasNoMajorSolarTerm(int ), this, n);
    }

    private boolean isLeapMonthBetween(int n, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrap("isLeapMonthBetween", $$robo$$android_icu_util_ChineseCalendar$isLeapMonthBetween(int int ), this, n, n2);
    }

    @Override
    protected void handleComputeFields(int n) {
        InvokeDynamicSupport.bootstrap("handleComputeFields", $$robo$$android_icu_util_ChineseCalendar$handleComputeFields(int ), this, n);
    }

    private void computeChineseFields(int n, int n2, int n3, boolean bl) {
        InvokeDynamicSupport.bootstrap("computeChineseFields", $$robo$$android_icu_util_ChineseCalendar$computeChineseFields(int int int boolean ), this, n, n2, n3, bl);
    }

    private int newYear(int n) {
        return (int)InvokeDynamicSupport.bootstrap("newYear", $$robo$$android_icu_util_ChineseCalendar$newYear(int ), this, n);
    }

    @Override
    protected int handleComputeMonthStart(int n, int n2, boolean bl) {
        return (int)InvokeDynamicSupport.bootstrap("handleComputeMonthStart", $$robo$$android_icu_util_ChineseCalendar$handleComputeMonthStart(int int boolean ), this, n, n2, bl);
    }

    @Override
    public String getType() {
        return InvokeDynamicSupport.bootstrap("getType", $$robo$$android_icu_util_ChineseCalendar$getType(), this);
    }

    @Override
    @Deprecated
    public boolean haveDefaultCentury() {
        return (boolean)InvokeDynamicSupport.bootstrap("haveDefaultCentury", $$robo$$android_icu_util_ChineseCalendar$haveDefaultCentury(), this);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        InvokeDynamicSupport.bootstrap("readObject", $$robo$$android_icu_util_ChineseCalendar$readObject(java.io.ObjectInputStream ), this, objectInputStream);
    }

    static {
        RobolectricInternals.classInitializing(ChineseCalendar.class);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ChineseCalendar)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

