/*
 * Decompiled with CFR 0.152.
 */
package android.icu.util;

import android.icu.impl.CacheBase;
import android.icu.impl.ICUCache;
import android.icu.impl.ICUDebug;
import android.icu.impl.ICUResourceBundle;
import android.icu.impl.SimpleCache;
import android.icu.impl.SoftCache;
import android.icu.impl.TextTrieMap;
import android.icu.text.CurrencyDisplayNames;
import android.icu.text.CurrencyMetaInfo;
import android.icu.util.MeasureUnit;
import android.icu.util.ULocale;
import android.icu.util.UResourceBundle;
import com.google.errorprone.annotations.DoNotMock;
import java.io.ObjectStreamException;
import java.lang.ref.SoftReference;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class Currency
extends MeasureUnit
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static long serialVersionUID = -5839973855554750484L;
    private static boolean DEBUG;
    private static ICUCache<ULocale, List<TextTrieMap<CurrencyStringInfo>>> CURRENCY_NAME_CACHE;
    public static int SYMBOL_NAME = 0;
    public static int LONG_NAME = 1;
    public static int PLURAL_LONG_NAME = 2;
    private static EquivalenceRelation<String> EQUIVALENT_CURRENCY_SYMBOLS;
    private static ServiceShim shim;
    private static String EUR_STR = "EUR";
    private static CacheBase<String, Currency, Void> regionCurrencyCache;
    private static ULocale UND;
    private static String[] EMPTY_STRING_ARRAY;
    private static int[] POW10;
    private static SoftReference<List<String>> ALL_TENDER_CODES;
    private static SoftReference<Set<String>> ALL_CODES_AS_SET;
    private String isoCode;

    private static final ServiceShim $$robo$$android_icu_util_Currency$getShim() {
        if (shim == null) {
            try {
                Class<?> cls = Class.forName("android.icu.util.CurrencyServiceShim");
                shim = (ServiceShim)cls.newInstance();
            }
            catch (Exception e) {
                if (DEBUG) {
                    e.printStackTrace();
                }
                throw new RuntimeException(e.getMessage());
            }
        }
        return shim;
    }

    private static final Currency $$robo$$android_icu_util_Currency$getInstance(Locale locale) {
        return Currency.getInstance(ULocale.forLocale(locale));
    }

    private static final Currency $$robo$$android_icu_util_Currency$getInstance(ULocale locale) {
        String currency = locale.getKeywordValue("currency");
        if (currency != null) {
            return Currency.getInstance(currency);
        }
        if (shim == null) {
            return Currency.createCurrency(locale);
        }
        return shim.createInstance(locale);
    }

    private static final String[] $$robo$$android_icu_util_Currency$getAvailableCurrencyCodes(ULocale loc, Date d) {
        String region = ULocale.getRegionForSupplementalData(loc, false);
        CurrencyMetaInfo.CurrencyFilter filter = CurrencyMetaInfo.CurrencyFilter.onDate(d).withRegion(region);
        List<String> list = Currency.getTenderCurrencies(filter);
        if (list.isEmpty()) {
            return null;
        }
        return list.toArray(new String[list.size()]);
    }

    private static final String[] $$robo$$android_icu_util_Currency$getAvailableCurrencyCodes(Locale loc, Date d) {
        return Currency.getAvailableCurrencyCodes(ULocale.forLocale(loc), d);
    }

    private static final Set<Currency> $$robo$$android_icu_util_Currency$getAvailableCurrencies() {
        CurrencyMetaInfo info = CurrencyMetaInfo.getInstance();
        List<String> list = info.currencies(CurrencyMetaInfo.CurrencyFilter.all());
        HashSet<Currency> resultSet = new HashSet<Currency>(list.size());
        for (String code : list) {
            resultSet.add(Currency.getInstance(code));
        }
        return resultSet;
    }

    private static final Currency $$robo$$android_icu_util_Currency$createCurrency(ULocale loc) {
        String variant = loc.getVariant();
        if ("EURO".equals(variant)) {
            return Currency.getInstance("EUR");
        }
        String key = ULocale.getRegionForSupplementalData(loc, false);
        if ("PREEURO".equals(variant)) {
            key = key + '-';
        }
        return regionCurrencyCache.getInstance(key, null);
    }

    private static final Currency $$robo$$android_icu_util_Currency$loadCurrency(String key) {
        boolean isPreEuro;
        String region;
        if (key.endsWith("-")) {
            region = key.substring(0, key.length() - 1);
            isPreEuro = true;
        } else {
            region = key;
            isPreEuro = false;
        }
        CurrencyMetaInfo info = CurrencyMetaInfo.getInstance();
        List<String> list = info.currencies(CurrencyMetaInfo.CurrencyFilter.onRegion(region));
        if (!list.isEmpty()) {
            String code = list.get(0);
            if (isPreEuro && "EUR".equals(code)) {
                if (list.size() < 2) {
                    return null;
                }
                code = list.get(1);
            }
            return Currency.getInstance(code);
        }
        return null;
    }

    private static final Currency $$robo$$android_icu_util_Currency$getInstance(String theISOCode) {
        if (theISOCode == null) {
            throw new NullPointerException("The input currency code is null.");
        }
        if (!Currency.isAlpha3Code(theISOCode)) {
            throw new IllegalArgumentException("The input currency code is not 3-letter alphabetic code.");
        }
        return (Currency)MeasureUnit.internalGetInstance("currency", theISOCode.toUpperCase(Locale.ENGLISH));
    }

    private static final boolean $$robo$$android_icu_util_Currency$isAlpha3Code(String code) {
        if (code.length() != 3) {
            return false;
        }
        for (int i = 0; i < 3; ++i) {
            char ch = code.charAt(i);
            if (ch >= 'A' && (ch <= 'Z' || ch >= 'a') && ch <= 'z') continue;
            return false;
        }
        return true;
    }

    private static final Object $$robo$$android_icu_util_Currency$registerInstance(Currency currency, ULocale locale) {
        return Currency.getShim().registerInstance(currency, locale);
    }

    private static final boolean $$robo$$android_icu_util_Currency$unregister(Object registryKey) {
        if (registryKey == null) {
            throw new IllegalArgumentException("registryKey must not be null");
        }
        if (shim == null) {
            return false;
        }
        return shim.unregister(registryKey);
    }

    private static final Locale[] $$robo$$android_icu_util_Currency$getAvailableLocales() {
        if (shim == null) {
            return ICUResourceBundle.getAvailableLocales();
        }
        return shim.getAvailableLocales();
    }

    private static final ULocale[] $$robo$$android_icu_util_Currency$getAvailableULocales() {
        if (shim == null) {
            return ICUResourceBundle.getAvailableULocales();
        }
        return shim.getAvailableULocales();
    }

    private static final String[] $$robo$$android_icu_util_Currency$getKeywordValuesForLocale(String key, ULocale locale, boolean commonlyUsed) {
        if (!"currency".equals(key)) {
            return EMPTY_STRING_ARRAY;
        }
        if (!commonlyUsed) {
            return Currency.getAllTenderCurrencies().toArray(new String[0]);
        }
        if (UND.equals(locale)) {
            return EMPTY_STRING_ARRAY;
        }
        String prefRegion = ULocale.getRegionForSupplementalData(locale, true);
        CurrencyMetaInfo.CurrencyFilter filter = CurrencyMetaInfo.CurrencyFilter.now().withRegion(prefRegion);
        List<String> result = Currency.getTenderCurrencies(filter);
        if (result.size() == 0) {
            return EMPTY_STRING_ARRAY;
        }
        return result.toArray(new String[result.size()]);
    }

    private final String $$robo$$android_icu_util_Currency$getCurrencyCode() {
        return this.subType;
    }

    private final int $$robo$$android_icu_util_Currency$getNumericCode() {
        int result = 0;
        try {
            UResourceBundle bundle = UResourceBundle.getBundleInstance("android/icu/impl/data/icudt58b", "currencyNumericCodes", ICUResourceBundle.ICU_DATA_CLASS_LOADER);
            UResourceBundle codeMap = bundle.get("codeMap");
            UResourceBundle numCode = codeMap.get(this.subType);
            result = numCode.getInt();
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return result;
    }

    private final String $$robo$$android_icu_util_Currency$getSymbol() {
        return this.getSymbol(ULocale.getDefault(ULocale.Category.DISPLAY));
    }

    private final String $$robo$$android_icu_util_Currency$getSymbol(Locale loc) {
        return this.getSymbol(ULocale.forLocale(loc));
    }

    private final String $$robo$$android_icu_util_Currency$getSymbol(ULocale uloc) {
        return this.getName(uloc, 0, new boolean[1]);
    }

    private final String $$robo$$android_icu_util_Currency$getName(Locale locale, int nameStyle, boolean[] isChoiceFormat) {
        return this.getName(ULocale.forLocale(locale), nameStyle, isChoiceFormat);
    }

    private final String $$robo$$android_icu_util_Currency$getName(ULocale locale, int nameStyle, boolean[] isChoiceFormat) {
        if (nameStyle != 0 && nameStyle != 1) {
            throw new IllegalArgumentException("bad name style: " + nameStyle);
        }
        if (isChoiceFormat != null) {
            isChoiceFormat[0] = false;
        }
        CurrencyDisplayNames names = CurrencyDisplayNames.getInstance(locale);
        return nameStyle == 0 ? names.getSymbol(this.subType) : names.getName(this.subType);
    }

    private final String $$robo$$android_icu_util_Currency$getName(Locale locale, int nameStyle, String pluralCount, boolean[] isChoiceFormat) {
        return this.getName(ULocale.forLocale(locale), nameStyle, pluralCount, isChoiceFormat);
    }

    private final String $$robo$$android_icu_util_Currency$getName(ULocale locale, int nameStyle, String pluralCount, boolean[] isChoiceFormat) {
        if (nameStyle != 2) {
            return this.getName(locale, nameStyle, isChoiceFormat);
        }
        if (isChoiceFormat != null) {
            isChoiceFormat[0] = false;
        }
        CurrencyDisplayNames names = CurrencyDisplayNames.getInstance(locale);
        return names.getPluralName(this.subType, pluralCount);
    }

    private final String $$robo$$android_icu_util_Currency$getDisplayName() {
        return this.getName(Locale.getDefault(), 1, null);
    }

    private final String $$robo$$android_icu_util_Currency$getDisplayName(Locale locale) {
        return this.getName(locale, 1, null);
    }

    @Deprecated
    private static final String $$robo$$android_icu_util_Currency$parse(ULocale locale, String text, int type, ParsePosition pos) {
        List<TextTrieMap<CurrencyStringInfo>> currencyTrieVec = CURRENCY_NAME_CACHE.get(locale);
        if (currencyTrieVec == null) {
            TextTrieMap currencyNameTrie = new TextTrieMap(true);
            TextTrieMap currencySymbolTrie = new TextTrieMap(false);
            currencyTrieVec = new ArrayList<TextTrieMap<CurrencyStringInfo>>();
            currencyTrieVec.add(currencySymbolTrie);
            currencyTrieVec.add(currencyNameTrie);
            Currency.setupCurrencyTrieVec(locale, currencyTrieVec);
            CURRENCY_NAME_CACHE.put(locale, currencyTrieVec);
        }
        int maxLength = 0;
        String isoResult = null;
        TextTrieMap<CurrencyStringInfo> currencyNameTrie = currencyTrieVec.get(1);
        CurrencyNameResultHandler handler = new CurrencyNameResultHandler(null);
        currencyNameTrie.find(text, pos.getIndex(), (TextTrieMap.ResultHandler<CurrencyStringInfo>)handler);
        isoResult = handler.getBestCurrencyISOCode();
        maxLength = handler.getBestMatchLength();
        if (type != 1) {
            TextTrieMap<CurrencyStringInfo> currencySymbolTrie = currencyTrieVec.get(0);
            handler = new CurrencyNameResultHandler(null);
            currencySymbolTrie.find(text, pos.getIndex(), (TextTrieMap.ResultHandler<CurrencyStringInfo>)handler);
            if (handler.getBestMatchLength() > maxLength) {
                isoResult = handler.getBestCurrencyISOCode();
                maxLength = handler.getBestMatchLength();
            }
        }
        int start = pos.getIndex();
        pos.setIndex(start + maxLength);
        return isoResult;
    }

    private static final void $$robo$$android_icu_util_Currency$setupCurrencyTrieVec(ULocale locale, List<TextTrieMap<CurrencyStringInfo>> trieVec) {
        String isoCode;
        TextTrieMap<CurrencyStringInfo> symTrie = trieVec.get(0);
        TextTrieMap<CurrencyStringInfo> trie = trieVec.get(1);
        CurrencyDisplayNames names = CurrencyDisplayNames.getInstance(locale);
        for (Map.Entry<String, String> e : names.symbolMap().entrySet()) {
            String symbol = e.getKey();
            isoCode = e.getValue();
            for (String equivalentSymbol : EQUIVALENT_CURRENCY_SYMBOLS.get(symbol)) {
                symTrie.put(equivalentSymbol, new CurrencyStringInfo(isoCode, symbol));
            }
        }
        for (Map.Entry<String, String> e : names.nameMap().entrySet()) {
            String name = e.getKey();
            isoCode = e.getValue();
            trie.put(name, new CurrencyStringInfo(isoCode, name));
        }
    }

    private final int $$robo$$android_icu_util_Currency$getDefaultFractionDigits() {
        return this.getDefaultFractionDigits(CurrencyUsage.STANDARD);
    }

    private final int $$robo$$android_icu_util_Currency$getDefaultFractionDigits(CurrencyUsage Usage2) {
        CurrencyMetaInfo info = CurrencyMetaInfo.getInstance();
        CurrencyMetaInfo.CurrencyDigits digits = info.currencyDigits(this.subType, Usage2);
        return digits.fractionDigits;
    }

    private final double $$robo$$android_icu_util_Currency$getRoundingIncrement() {
        return this.getRoundingIncrement(CurrencyUsage.STANDARD);
    }

    private final double $$robo$$android_icu_util_Currency$getRoundingIncrement(CurrencyUsage Usage2) {
        CurrencyMetaInfo info = CurrencyMetaInfo.getInstance();
        CurrencyMetaInfo.CurrencyDigits digits = info.currencyDigits(this.subType, Usage2);
        int data1 = digits.roundingIncrement;
        if (data1 == 0) {
            return 0.0;
        }
        int data0 = digits.fractionDigits;
        if (data0 < 0 || data0 >= POW10.length) {
            return 0.0;
        }
        return (double)data1 / (double)POW10[data0];
    }

    private final String $$robo$$android_icu_util_Currency$toString() {
        return this.subType;
    }

    private void $$robo$$android_icu_util_Currency$__constructor__(String theISOCode) {
        this.isoCode = theISOCode;
    }

    private static final synchronized List<String> $$robo$$android_icu_util_Currency$getAllTenderCurrencies() {
        List<String> all;
        List<String> list = all = ALL_TENDER_CODES == null ? null : ALL_TENDER_CODES.get();
        if (all == null) {
            CurrencyMetaInfo.CurrencyFilter filter = CurrencyMetaInfo.CurrencyFilter.all();
            all = Collections.unmodifiableList(Currency.getTenderCurrencies(filter));
            ALL_TENDER_CODES = new SoftReference<List<String>>(all);
        }
        return all;
    }

    private static final synchronized Set<String> $$robo$$android_icu_util_Currency$getAllCurrenciesAsSet() {
        Set<String> all;
        Set<String> set = all = ALL_CODES_AS_SET == null ? null : ALL_CODES_AS_SET.get();
        if (all == null) {
            CurrencyMetaInfo info = CurrencyMetaInfo.getInstance();
            all = Collections.unmodifiableSet(new HashSet<String>(info.currencies(CurrencyMetaInfo.CurrencyFilter.all())));
            ALL_CODES_AS_SET = new SoftReference<Set<String>>(all);
        }
        return all;
    }

    private static final boolean $$robo$$android_icu_util_Currency$isAvailable(String code, Date from, Date to) {
        if (!Currency.isAlpha3Code(code)) {
            return false;
        }
        if (from != null && to != null && from.after(to)) {
            throw new IllegalArgumentException("To is before from");
        }
        code = code.toUpperCase(Locale.ENGLISH);
        boolean isKnown = Currency.getAllCurrenciesAsSet().contains(code);
        if (!isKnown) {
            return false;
        }
        if (from == null && to == null) {
            return true;
        }
        CurrencyMetaInfo info = CurrencyMetaInfo.getInstance();
        List<String> allActive = info.currencies(CurrencyMetaInfo.CurrencyFilter.onDateRange(from, to).withCurrency(code));
        return allActive.contains(code);
    }

    private static final List<String> $$robo$$android_icu_util_Currency$getTenderCurrencies(CurrencyMetaInfo.CurrencyFilter filter) {
        CurrencyMetaInfo info = CurrencyMetaInfo.getInstance();
        return info.currencies(filter.withTender());
    }

    private final Object $$robo$$android_icu_util_Currency$writeReplace() throws ObjectStreamException {
        return new MeasureUnit.MeasureUnitProxy(this.type, this.subType);
    }

    private final Object $$robo$$android_icu_util_Currency$readResolve() throws ObjectStreamException {
        return Currency.getInstance(this.isoCode);
    }

    static void __staticInitializer__() {
        DEBUG = ICUDebug.enabled("currency");
        CURRENCY_NAME_CACHE = new SimpleCache<ULocale, List<TextTrieMap<CurrencyStringInfo>>>();
        EQUIVALENT_CURRENCY_SYMBOLS = new EquivalenceRelation<String>(null).add("\u00a5", "\uffe5").add((String[])new String[]{"$", "\ufe69", "\uff04"}).add((String[])new String[]{"\u20a8", "\u20b9"}).add((String[])new String[]{"\u00a3", "\u20a4"});
        regionCurrencyCache = new SoftCache<String, Currency, Void>(){
            public /* synthetic */ Object __robo_data__;

            private void $$robo$$android_icu_util_Currency_1$__constructor__() {
            }

            private final Currency $$robo$$android_icu_util_Currency_1$createInstance(String key, Void unused) {
                return Currency.loadCurrency(key);
            }

            private void __constructor__() {
                this.$$robo$$android_icu_util_Currency_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_util_Currency_1$__constructor__(), this);
            }

            @Override
            protected Currency createInstance(String string2, Void void_) {
                return InvokeDynamicSupport.bootstrap("createInstance", $$robo$$android_icu_util_Currency_1$createInstance(java.lang.String java.lang.Void ), this, string2, void_);
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        UND = new ULocale("und");
        EMPTY_STRING_ARRAY = new String[0];
        POW10 = new int[]{1, 10, 100, 1000, 10000, 100000, 1000000, 10000000, 100000000, 1000000000};
    }

    private static ServiceShim getShim() {
        return InvokeDynamicSupport.bootstrapStatic("getShim", $$robo$$android_icu_util_Currency$getShim());
    }

    public static Currency getInstance(Locale locale) {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$android_icu_util_Currency$getInstance(java.util.Locale ), (Locale)locale);
    }

    public static Currency getInstance(ULocale uLocale) {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$android_icu_util_Currency$getInstance(android.icu.util.ULocale ), (ULocale)uLocale);
    }

    public static String[] getAvailableCurrencyCodes(ULocale uLocale, Date date) {
        return InvokeDynamicSupport.bootstrapStatic("getAvailableCurrencyCodes", $$robo$$android_icu_util_Currency$getAvailableCurrencyCodes(android.icu.util.ULocale java.util.Date ), (ULocale)uLocale, (Date)date);
    }

    public static String[] getAvailableCurrencyCodes(Locale locale, Date date) {
        return InvokeDynamicSupport.bootstrapStatic("getAvailableCurrencyCodes", $$robo$$android_icu_util_Currency$getAvailableCurrencyCodes(java.util.Locale java.util.Date ), (Locale)locale, (Date)date);
    }

    public static Set<Currency> getAvailableCurrencies() {
        return InvokeDynamicSupport.bootstrapStatic("getAvailableCurrencies", $$robo$$android_icu_util_Currency$getAvailableCurrencies());
    }

    static Currency createCurrency(ULocale uLocale) {
        return InvokeDynamicSupport.bootstrapStatic("createCurrency", $$robo$$android_icu_util_Currency$createCurrency(android.icu.util.ULocale ), (ULocale)uLocale);
    }

    private static Currency loadCurrency(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("loadCurrency", $$robo$$android_icu_util_Currency$loadCurrency(java.lang.String ), (String)string2);
    }

    public static Currency getInstance(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$android_icu_util_Currency$getInstance(java.lang.String ), (String)string2);
    }

    private static boolean isAlpha3Code(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isAlpha3Code", $$robo$$android_icu_util_Currency$isAlpha3Code(java.lang.String ), (String)string2);
    }

    public static Object registerInstance(Currency currency, ULocale uLocale) {
        return InvokeDynamicSupport.bootstrapStatic("registerInstance", $$robo$$android_icu_util_Currency$registerInstance(android.icu.util.Currency android.icu.util.ULocale ), (Currency)currency, (ULocale)uLocale);
    }

    public static boolean unregister(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("unregister", $$robo$$android_icu_util_Currency$unregister(java.lang.Object ), (Object)object);
    }

    public static Locale[] getAvailableLocales() {
        return InvokeDynamicSupport.bootstrapStatic("getAvailableLocales", $$robo$$android_icu_util_Currency$getAvailableLocales());
    }

    public static ULocale[] getAvailableULocales() {
        return InvokeDynamicSupport.bootstrapStatic("getAvailableULocales", $$robo$$android_icu_util_Currency$getAvailableULocales());
    }

    public static String[] getKeywordValuesForLocale(String string2, ULocale uLocale, boolean bl) {
        return InvokeDynamicSupport.bootstrapStatic("getKeywordValuesForLocale", $$robo$$android_icu_util_Currency$getKeywordValuesForLocale(java.lang.String android.icu.util.ULocale boolean ), (String)string2, (ULocale)uLocale, (boolean)bl);
    }

    public String getCurrencyCode() {
        return InvokeDynamicSupport.bootstrap("getCurrencyCode", $$robo$$android_icu_util_Currency$getCurrencyCode(), this);
    }

    public int getNumericCode() {
        return (int)InvokeDynamicSupport.bootstrap("getNumericCode", $$robo$$android_icu_util_Currency$getNumericCode(), this);
    }

    public String getSymbol() {
        return InvokeDynamicSupport.bootstrap("getSymbol", $$robo$$android_icu_util_Currency$getSymbol(), this);
    }

    public String getSymbol(Locale locale) {
        return InvokeDynamicSupport.bootstrap("getSymbol", $$robo$$android_icu_util_Currency$getSymbol(java.util.Locale ), this, locale);
    }

    public String getSymbol(ULocale uLocale) {
        return InvokeDynamicSupport.bootstrap("getSymbol", $$robo$$android_icu_util_Currency$getSymbol(android.icu.util.ULocale ), this, uLocale);
    }

    public String getName(Locale locale, int n, boolean[] blArray) {
        return InvokeDynamicSupport.bootstrap("getName", $$robo$$android_icu_util_Currency$getName(java.util.Locale int boolean[] ), this, locale, n, blArray);
    }

    public String getName(ULocale uLocale, int n, boolean[] blArray) {
        return InvokeDynamicSupport.bootstrap("getName", $$robo$$android_icu_util_Currency$getName(android.icu.util.ULocale int boolean[] ), this, uLocale, n, blArray);
    }

    public String getName(Locale locale, int n, String string2, boolean[] blArray) {
        return InvokeDynamicSupport.bootstrap("getName", $$robo$$android_icu_util_Currency$getName(java.util.Locale int java.lang.String boolean[] ), this, locale, n, string2, blArray);
    }

    public String getName(ULocale uLocale, int n, String string2, boolean[] blArray) {
        return InvokeDynamicSupport.bootstrap("getName", $$robo$$android_icu_util_Currency$getName(android.icu.util.ULocale int java.lang.String boolean[] ), this, uLocale, n, string2, blArray);
    }

    public String getDisplayName() {
        return InvokeDynamicSupport.bootstrap("getDisplayName", $$robo$$android_icu_util_Currency$getDisplayName(), this);
    }

    public String getDisplayName(Locale locale) {
        return InvokeDynamicSupport.bootstrap("getDisplayName", $$robo$$android_icu_util_Currency$getDisplayName(java.util.Locale ), this, locale);
    }

    @Deprecated
    public static String parse(ULocale uLocale, String string2, int n, ParsePosition parsePosition) {
        return InvokeDynamicSupport.bootstrapStatic("parse", $$robo$$android_icu_util_Currency$parse(android.icu.util.ULocale java.lang.String int java.text.ParsePosition ), (ULocale)uLocale, (String)string2, (int)n, (ParsePosition)parsePosition);
    }

    private static void setupCurrencyTrieVec(ULocale uLocale, List<TextTrieMap<CurrencyStringInfo>> list) {
        InvokeDynamicSupport.bootstrapStatic("setupCurrencyTrieVec", $$robo$$android_icu_util_Currency$setupCurrencyTrieVec(android.icu.util.ULocale java.util.List<android.icu.impl.TextTrieMap<android.icu.util.Currency$CurrencyStringInfo>> ), (ULocale)uLocale, list);
    }

    public int getDefaultFractionDigits() {
        return (int)InvokeDynamicSupport.bootstrap("getDefaultFractionDigits", $$robo$$android_icu_util_Currency$getDefaultFractionDigits(), this);
    }

    public int getDefaultFractionDigits(CurrencyUsage currencyUsage) {
        return (int)InvokeDynamicSupport.bootstrap("getDefaultFractionDigits", $$robo$$android_icu_util_Currency$getDefaultFractionDigits(android.icu.util.Currency$CurrencyUsage ), this, currencyUsage);
    }

    public double getRoundingIncrement() {
        return (double)InvokeDynamicSupport.bootstrap("getRoundingIncrement", $$robo$$android_icu_util_Currency$getRoundingIncrement(), this);
    }

    public double getRoundingIncrement(CurrencyUsage currencyUsage) {
        return (double)InvokeDynamicSupport.bootstrap("getRoundingIncrement", $$robo$$android_icu_util_Currency$getRoundingIncrement(android.icu.util.Currency$CurrencyUsage ), this, currencyUsage);
    }

    @Override
    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_icu_util_Currency$toString(), this);
    }

    private void __constructor__(String string2) {
        this.$$robo$$android_icu_util_Currency$__constructor__(string2);
    }

    public Currency(String string2) {
        super("currency", string2);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_util_Currency$__constructor__(java.lang.String ), this, string2);
    }

    private static synchronized List<String> getAllTenderCurrencies() {
        return InvokeDynamicSupport.bootstrapStatic("getAllTenderCurrencies", $$robo$$android_icu_util_Currency$getAllTenderCurrencies());
    }

    private static synchronized Set<String> getAllCurrenciesAsSet() {
        return InvokeDynamicSupport.bootstrapStatic("getAllCurrenciesAsSet", $$robo$$android_icu_util_Currency$getAllCurrenciesAsSet());
    }

    public static boolean isAvailable(String string2, Date date, Date date2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isAvailable", $$robo$$android_icu_util_Currency$isAvailable(java.lang.String java.util.Date java.util.Date ), (String)string2, (Date)date, (Date)date2);
    }

    private static List<String> getTenderCurrencies(CurrencyMetaInfo.CurrencyFilter currencyFilter) {
        return InvokeDynamicSupport.bootstrapStatic("getTenderCurrencies", $$robo$$android_icu_util_Currency$getTenderCurrencies(android.icu.text.CurrencyMetaInfo$CurrencyFilter ), (CurrencyMetaInfo.CurrencyFilter)currencyFilter);
    }

    private Object writeReplace() throws ObjectStreamException {
        return InvokeDynamicSupport.bootstrap("writeReplace", $$robo$$android_icu_util_Currency$writeReplace(), this);
    }

    private Object readResolve() throws ObjectStreamException {
        return InvokeDynamicSupport.bootstrap("readResolve", $$robo$$android_icu_util_Currency$readResolve(), this);
    }

    static {
        RobolectricInternals.classInitializing(Currency.class);
    }

    public /* synthetic */ Currency() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Currency)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class EquivalenceRelation<T> {
        public /* synthetic */ Object __robo_data__;
        private Map<T, Set<T>> data;

        private void $$robo$$android_icu_util_Currency_EquivalenceRelation$__constructor__() {
            this.data = new HashMap<T, Set<T>>();
        }

        private final EquivalenceRelation<T> $$robo$$android_icu_util_Currency_EquivalenceRelation$add(T ... items) {
            HashSet<T> group = new HashSet<T>();
            for (T item : items) {
                if (this.data.containsKey(item)) {
                    throw new IllegalArgumentException("All groups passed to add must be disjoint.");
                }
                group.add(item);
            }
            for (T item : items) {
                this.data.put(item, group);
            }
            return this;
        }

        private final Set<T> $$robo$$android_icu_util_Currency_EquivalenceRelation$get(T item) {
            Set<T> result = this.data.get(item);
            if (result == null) {
                return Collections.singleton(item);
            }
            return Collections.unmodifiableSet(result);
        }

        private /* synthetic */ void $$robo$$android_icu_util_Currency_EquivalenceRelation$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$android_icu_util_Currency_EquivalenceRelation$__constructor__();
        }

        public EquivalenceRelation() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_util_Currency_EquivalenceRelation$__constructor__(), this);
        }

        public EquivalenceRelation<T> add(T ... TArray) {
            return InvokeDynamicSupport.bootstrap("add", $$robo$$android_icu_util_Currency_EquivalenceRelation$add(T[] ), this, TArray);
        }

        public Set<T> get(T t) {
            return InvokeDynamicSupport.bootstrap("get", $$robo$$android_icu_util_Currency_EquivalenceRelation$get(T ), this, t);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_icu_util_Currency_EquivalenceRelation$__constructor__(var1_1);
        }

        public /* synthetic */ EquivalenceRelation(1 var1_1) {
            this();
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_util_Currency_EquivalenceRelation$__constructor__(android.icu.util.Currency$1 ), this, var1_1);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (EquivalenceRelation)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class CurrencyNameResultHandler
    implements TextTrieMap.ResultHandler<CurrencyStringInfo> {
        public /* synthetic */ Object __robo_data__;
        private int bestMatchLength;
        private String bestCurrencyISOCode;

        private void $$robo$$android_icu_util_Currency_CurrencyNameResultHandler$__constructor__() {
        }

        private final boolean $$robo$$android_icu_util_Currency_CurrencyNameResultHandler$handlePrefixMatch(int matchLength, Iterator<CurrencyStringInfo> values) {
            if (values.hasNext()) {
                this.bestCurrencyISOCode = values.next().getISOCode();
                this.bestMatchLength = matchLength;
            }
            return true;
        }

        private final String $$robo$$android_icu_util_Currency_CurrencyNameResultHandler$getBestCurrencyISOCode() {
            return this.bestCurrencyISOCode;
        }

        private final int $$robo$$android_icu_util_Currency_CurrencyNameResultHandler$getBestMatchLength() {
            return this.bestMatchLength;
        }

        private /* synthetic */ void $$robo$$android_icu_util_Currency_CurrencyNameResultHandler$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$android_icu_util_Currency_CurrencyNameResultHandler$__constructor__();
        }

        public CurrencyNameResultHandler() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_util_Currency_CurrencyNameResultHandler$__constructor__(), this);
        }

        @Override
        public boolean handlePrefixMatch(int n, Iterator<CurrencyStringInfo> iterator) {
            return (boolean)InvokeDynamicSupport.bootstrap("handlePrefixMatch", $$robo$$android_icu_util_Currency_CurrencyNameResultHandler$handlePrefixMatch(int java.util.Iterator<android.icu.util.Currency$CurrencyStringInfo> ), this, n, iterator);
        }

        public String getBestCurrencyISOCode() {
            return InvokeDynamicSupport.bootstrap("getBestCurrencyISOCode", $$robo$$android_icu_util_Currency_CurrencyNameResultHandler$getBestCurrencyISOCode(), this);
        }

        public int getBestMatchLength() {
            return (int)InvokeDynamicSupport.bootstrap("getBestMatchLength", $$robo$$android_icu_util_Currency_CurrencyNameResultHandler$getBestMatchLength(), this);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_icu_util_Currency_CurrencyNameResultHandler$__constructor__(var1_1);
        }

        public /* synthetic */ CurrencyNameResultHandler(1 var1_1) {
            this();
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_util_Currency_CurrencyNameResultHandler$__constructor__(android.icu.util.Currency$1 ), this, var1_1);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CurrencyNameResultHandler)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class CurrencyStringInfo
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private String isoCode;
        private String currencyString;

        private void $$robo$$android_icu_util_Currency_CurrencyStringInfo$__constructor__(String isoCode, String currencyString) {
            this.isoCode = isoCode;
            this.currencyString = currencyString;
        }

        private final String $$robo$$android_icu_util_Currency_CurrencyStringInfo$getISOCode() {
            return this.isoCode;
        }

        private final String $$robo$$android_icu_util_Currency_CurrencyStringInfo$getCurrencyString() {
            return this.currencyString;
        }

        private void __constructor__(String string2, String string3) {
            this.$$robo$$android_icu_util_Currency_CurrencyStringInfo$__constructor__(string2, string3);
        }

        public CurrencyStringInfo(String string2, String string3) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_util_Currency_CurrencyStringInfo$__constructor__(java.lang.String java.lang.String ), this, string2, string3);
        }

        public String getISOCode() {
            return InvokeDynamicSupport.bootstrap("getISOCode", $$robo$$android_icu_util_Currency_CurrencyStringInfo$getISOCode(), this);
        }

        public String getCurrencyString() {
            return InvokeDynamicSupport.bootstrap("getCurrencyString", $$robo$$android_icu_util_Currency_CurrencyStringInfo$getCurrencyString(), this);
        }

        public /* synthetic */ CurrencyStringInfo() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CurrencyStringInfo)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static abstract class ServiceShim
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;

        private void $$robo$$android_icu_util_Currency_ServiceShim$__constructor__() {
        }

        abstract ULocale[] getAvailableULocales();

        abstract Locale[] getAvailableLocales();

        abstract Currency createInstance(ULocale var1);

        abstract Object registerInstance(Currency var1, ULocale var2);

        abstract boolean unregister(Object var1);

        private void __constructor__() {
            this.$$robo$$android_icu_util_Currency_ServiceShim$__constructor__();
        }

        public ServiceShim() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_util_Currency_ServiceShim$__constructor__(), this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ServiceShim)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class CurrencyUsage
    extends Enum<CurrencyUsage> {
        public /* synthetic */ Object __robo_data__;
        public static /* enum */ CurrencyUsage STANDARD;
        public static /* enum */ CurrencyUsage CASH;
        private static /* synthetic */ CurrencyUsage[] $VALUES;

        private static final CurrencyUsage[] $$robo$$android_icu_util_Currency_CurrencyUsage$values() {
            return (CurrencyUsage[])$VALUES.clone();
        }

        private static final CurrencyUsage $$robo$$android_icu_util_Currency_CurrencyUsage$valueOf(String name) {
            return Enum.valueOf(CurrencyUsage.class, name);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void $$robo$$android_icu_util_Currency_CurrencyUsage$__constructor__(String string2, int n) {
        }

        static void __staticInitializer__() {
            STANDARD = new CurrencyUsage();
            CASH = new CurrencyUsage();
            $VALUES = new CurrencyUsage[]{STANDARD, CASH};
        }

        public static CurrencyUsage[] values() {
            return InvokeDynamicSupport.bootstrapStatic("values", $$robo$$android_icu_util_Currency_CurrencyUsage$values());
        }

        public static CurrencyUsage valueOf(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$android_icu_util_Currency_CurrencyUsage$valueOf(java.lang.String ), (String)string2);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void __constructor__(String string2, int n) {
            this.$$robo$$android_icu_util_Currency_CurrencyUsage$__constructor__(string2, n);
        }

        public CurrencyUsage() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_util_Currency_CurrencyUsage$__constructor__(java.lang.String int ), this, string2, n);
        }

        static {
            RobolectricInternals.classInitializing(CurrencyUsage.class);
        }

        public /* synthetic */ CurrencyUsage() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CurrencyUsage)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

