/*
 * Decompiled with CFR 0.152.
 */
package android.icu.util;

import android.icu.util.Calendar;
import android.icu.util.TimeZone;
import android.icu.util.ULocale;
import java.util.Date;
import java.util.Locale;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class IndianCalendar
extends Calendar
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static long serialVersionUID = 3617859668165014834L;
    public static int CHAITRA = 0;
    public static int VAISAKHA = 1;
    public static int JYAISTHA = 2;
    public static int ASADHA = 3;
    public static int SRAVANA = 4;
    public static int BHADRA = 5;
    public static int ASVINA = 6;
    public static int KARTIKA = 7;
    public static int AGRAHAYANA = 8;
    public static int PAUSA = 9;
    public static int MAGHA = 10;
    public static int PHALGUNA = 11;
    public static int IE = 0;
    private static int INDIAN_ERA_START = 78;
    private static int INDIAN_YEAR_START = 80;
    private static int[][] LIMITS;

    private void $$robo$$android_icu_util_IndianCalendar$__constructor__() {
    }

    private void $$robo$$android_icu_util_IndianCalendar$__constructor__(TimeZone zone) {
    }

    private void $$robo$$android_icu_util_IndianCalendar$__constructor__(Locale aLocale) {
    }

    private void $$robo$$android_icu_util_IndianCalendar$__constructor__(ULocale locale) {
    }

    private void $$robo$$android_icu_util_IndianCalendar$__constructor__(TimeZone zone, Locale aLocale) {
        this.setTimeInMillis((long)InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System"));
    }

    private void $$robo$$android_icu_util_IndianCalendar$__constructor__(TimeZone zone, ULocale locale) {
        this.setTimeInMillis((long)InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System"));
    }

    private void $$robo$$android_icu_util_IndianCalendar$__constructor__(Date date) {
        this.setTime(date);
    }

    private void $$robo$$android_icu_util_IndianCalendar$__constructor__(int year, int month, int date) {
        this.set(1, year);
        this.set(2, month);
        this.set(5, date);
    }

    private void $$robo$$android_icu_util_IndianCalendar$__constructor__(int year, int month, int date, int hour, int minute, int second) {
        this.set(1, year);
        this.set(2, month);
        this.set(5, date);
        this.set(11, hour);
        this.set(12, minute);
        this.set(13, second);
    }

    private final int $$robo$$android_icu_util_IndianCalendar$handleGetExtendedYear() {
        int year = this.newerField(19, 1) == 19 ? this.internalGet(19, 1) : this.internalGet(1, 1);
        return year;
    }

    private final int $$robo$$android_icu_util_IndianCalendar$handleGetYearLength(int extendedYear) {
        return super.handleGetYearLength(extendedYear);
    }

    private final int $$robo$$android_icu_util_IndianCalendar$handleGetMonthLength(int extendedYear, int month) {
        if (month < 0 || month > 11) {
            int[] remainder = new int[1];
            extendedYear += IndianCalendar.floorDivide(month, 12, remainder);
            month = remainder[0];
        }
        if (IndianCalendar.isGregorianLeap(extendedYear + 78) && month == 0) {
            return 31;
        }
        if (month >= 1 && month <= 5) {
            return 31;
        }
        return 30;
    }

    private final void $$robo$$android_icu_util_IndianCalendar$handleComputeFields(int julianDay) {
        int IndianDayOfMonth;
        int IndianMonth;
        int leapMonth;
        int[] gregorianDay = IndianCalendar.jdToGregorian(julianDay);
        int IndianYear = gregorianDay[0] - 78;
        double jdAtStartOfGregYear = IndianCalendar.gregorianToJD(gregorianDay[0], 1, 1);
        int yday = (int)((double)julianDay - jdAtStartOfGregYear);
        if (yday < 80) {
            --IndianYear;
            leapMonth = IndianCalendar.isGregorianLeap(gregorianDay[0] - 1) ? 31 : 30;
            yday += leapMonth + 155 + 90 + 10;
        } else {
            leapMonth = IndianCalendar.isGregorianLeap(gregorianDay[0]) ? 31 : 30;
            yday -= 80;
        }
        if (yday < leapMonth) {
            IndianMonth = 0;
            IndianDayOfMonth = yday + 1;
        } else {
            int mday = yday - leapMonth;
            if (mday < 155) {
                IndianMonth = mday / 31 + 1;
                IndianDayOfMonth = mday % 31 + 1;
            } else {
                IndianMonth = (mday -= 155) / 30 + 6;
                IndianDayOfMonth = mday % 30 + 1;
            }
        }
        this.internalSet(0, 0);
        this.internalSet(19, IndianYear);
        this.internalSet(1, IndianYear);
        this.internalSet(2, IndianMonth);
        this.internalSet(5, IndianDayOfMonth);
        this.internalSet(6, yday + 1);
    }

    private final int $$robo$$android_icu_util_IndianCalendar$handleGetLimit(int field, int limitType) {
        return LIMITS[field][limitType];
    }

    private final int $$robo$$android_icu_util_IndianCalendar$handleComputeMonthStart(int year, int month, boolean useMonth) {
        if (month < 0 || month > 11) {
            year += month / 12;
            month %= 12;
        }
        int imonth = month + 1;
        double jd = IndianCalendar.IndianToJD(year, imonth, 1);
        return (int)jd;
    }

    private static final double $$robo$$android_icu_util_IndianCalendar$IndianToJD(int year, int month, int date) {
        double jd;
        double start;
        int leapMonth;
        int gyear = year + 78;
        if (IndianCalendar.isGregorianLeap(gyear)) {
            leapMonth = 31;
            start = IndianCalendar.gregorianToJD(gyear, 3, 21);
        } else {
            leapMonth = 30;
            start = IndianCalendar.gregorianToJD(gyear, 3, 22);
        }
        if (month == 1) {
            jd = start + (double)(date - 1);
        } else {
            jd = start + (double)leapMonth;
            int m = month - 2;
            m = Math.min(m, 5);
            jd += (double)(m * 31);
            if (month >= 8) {
                m = month - 7;
                jd += (double)(m * 30);
            }
            jd += (double)(date - 1);
        }
        return jd;
    }

    private static final double $$robo$$android_icu_util_IndianCalendar$gregorianToJD(int year, int month, int date) {
        double JULIAN_EPOCH = 1721425.5;
        int y = year - 1;
        int result = 365 * y + y / 4 - y / 100 + y / 400 + (367 * month - 362) / 12 + (month <= 2 ? 0 : (IndianCalendar.isGregorianLeap(year) ? -1 : -2)) + date;
        return (double)(result - 1) + JULIAN_EPOCH;
    }

    private static final int[] $$robo$$android_icu_util_IndianCalendar$jdToGregorian(double jd) {
        double JULIAN_EPOCH = 1721425.5;
        double wjd = Math.floor(jd - 0.5) + 0.5;
        double depoch = wjd - JULIAN_EPOCH;
        double quadricent = Math.floor(depoch / 146097.0);
        double dqc = depoch % 146097.0;
        double cent = Math.floor(dqc / 36524.0);
        double dcent = dqc % 36524.0;
        double quad = Math.floor(dcent / 1461.0);
        double dquad = dcent % 1461.0;
        double yindex = Math.floor(dquad / 365.0);
        int year = (int)(quadricent * 400.0 + cent * 100.0 + quad * 4.0 + yindex);
        if (cent != 4.0 && yindex != 4.0) {
            ++year;
        }
        double yearday = wjd - IndianCalendar.gregorianToJD(year, 1, 1);
        double leapadj = wjd < IndianCalendar.gregorianToJD(year, 3, 1) ? 0 : (IndianCalendar.isGregorianLeap(year) ? 1 : 2);
        int month = (int)Math.floor(((yearday + leapadj) * 12.0 + 373.0) / 367.0);
        int day = (int)(wjd - IndianCalendar.gregorianToJD(year, month, 1)) + 1;
        int[] julianDate = new int[]{year, month, day};
        return julianDate;
    }

    private static final boolean $$robo$$android_icu_util_IndianCalendar$isGregorianLeap(int year) {
        return year % 4 == 0 && (year % 100 != 0 || year % 400 == 0);
    }

    private final String $$robo$$android_icu_util_IndianCalendar$getType() {
        return "indian";
    }

    static void __staticInitializer__() {
        LIMITS = new int[][]{{0, 0, 0, 0}, {-5000000, -5000000, 5000000, 5000000}, {0, 0, 11, 11}, {1, 1, 52, 53}, new int[0], {1, 1, 30, 31}, {1, 1, 365, 366}, new int[0], {-1, -1, 5, 5}, new int[0], new int[0], new int[0], new int[0], new int[0], new int[0], new int[0], new int[0], {-5000000, -5000000, 5000000, 5000000}, new int[0], {-5000000, -5000000, 5000000, 5000000}, new int[0], new int[0]};
    }

    private void __constructor__() {
        this.$$robo$$android_icu_util_IndianCalendar$__constructor__();
    }

    public IndianCalendar() {
        this(TimeZone.getDefault(), ULocale.getDefault(ULocale.Category.FORMAT));
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_util_IndianCalendar$__constructor__(), this);
    }

    private void __constructor__(TimeZone timeZone) {
        this.$$robo$$android_icu_util_IndianCalendar$__constructor__(timeZone);
    }

    public IndianCalendar(TimeZone timeZone) {
        this(timeZone, ULocale.getDefault(ULocale.Category.FORMAT));
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_util_IndianCalendar$__constructor__(android.icu.util.TimeZone ), this, timeZone);
    }

    private void __constructor__(Locale locale) {
        this.$$robo$$android_icu_util_IndianCalendar$__constructor__(locale);
    }

    public IndianCalendar(Locale locale) {
        this(TimeZone.getDefault(), locale);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_util_IndianCalendar$__constructor__(java.util.Locale ), this, locale);
    }

    private void __constructor__(ULocale uLocale) {
        this.$$robo$$android_icu_util_IndianCalendar$__constructor__(uLocale);
    }

    public IndianCalendar(ULocale uLocale) {
        this(TimeZone.getDefault(), uLocale);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_util_IndianCalendar$__constructor__(android.icu.util.ULocale ), this, uLocale);
    }

    private void __constructor__(TimeZone timeZone, Locale locale) {
        this.$$robo$$android_icu_util_IndianCalendar$__constructor__(timeZone, locale);
    }

    public IndianCalendar(TimeZone timeZone, Locale locale) {
        super(timeZone, locale);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_util_IndianCalendar$__constructor__(android.icu.util.TimeZone java.util.Locale ), this, timeZone, locale);
    }

    private void __constructor__(TimeZone timeZone, ULocale uLocale) {
        this.$$robo$$android_icu_util_IndianCalendar$__constructor__(timeZone, uLocale);
    }

    public IndianCalendar(TimeZone timeZone, ULocale uLocale) {
        super(timeZone, uLocale);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_util_IndianCalendar$__constructor__(android.icu.util.TimeZone android.icu.util.ULocale ), this, timeZone, uLocale);
    }

    private void __constructor__(Date date) {
        this.$$robo$$android_icu_util_IndianCalendar$__constructor__(date);
    }

    public IndianCalendar(Date date) {
        super(TimeZone.getDefault(), ULocale.getDefault(ULocale.Category.FORMAT));
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_util_IndianCalendar$__constructor__(java.util.Date ), this, date);
    }

    private void __constructor__(int n, int n2, int n3) {
        this.$$robo$$android_icu_util_IndianCalendar$__constructor__(n, n2, n3);
    }

    public IndianCalendar(int n, int n2, int n3) {
        super(TimeZone.getDefault(), ULocale.getDefault(ULocale.Category.FORMAT));
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_util_IndianCalendar$__constructor__(int int int ), this, n, n2, n3);
    }

    private void __constructor__(int n, int n2, int n3, int n4, int n5, int n6) {
        this.$$robo$$android_icu_util_IndianCalendar$__constructor__(n, n2, n3, n4, n5, n6);
    }

    public IndianCalendar(int n, int n2, int n3, int n4, int n5, int n6) {
        super(TimeZone.getDefault(), ULocale.getDefault(ULocale.Category.FORMAT));
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_util_IndianCalendar$__constructor__(int int int int int int ), this, n, n2, n3, n4, n5, n6);
    }

    @Override
    protected int handleGetExtendedYear() {
        return (int)InvokeDynamicSupport.bootstrap("handleGetExtendedYear", $$robo$$android_icu_util_IndianCalendar$handleGetExtendedYear(), this);
    }

    @Override
    protected int handleGetYearLength(int n) {
        return (int)InvokeDynamicSupport.bootstrap("handleGetYearLength", $$robo$$android_icu_util_IndianCalendar$handleGetYearLength(int ), this, n);
    }

    @Override
    protected int handleGetMonthLength(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("handleGetMonthLength", $$robo$$android_icu_util_IndianCalendar$handleGetMonthLength(int int ), this, n, n2);
    }

    @Override
    protected void handleComputeFields(int n) {
        InvokeDynamicSupport.bootstrap("handleComputeFields", $$robo$$android_icu_util_IndianCalendar$handleComputeFields(int ), this, n);
    }

    @Override
    protected int handleGetLimit(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("handleGetLimit", $$robo$$android_icu_util_IndianCalendar$handleGetLimit(int int ), this, n, n2);
    }

    @Override
    protected int handleComputeMonthStart(int n, int n2, boolean bl) {
        return (int)InvokeDynamicSupport.bootstrap("handleComputeMonthStart", $$robo$$android_icu_util_IndianCalendar$handleComputeMonthStart(int int boolean ), this, n, n2, bl);
    }

    private static double IndianToJD(int n, int n2, int n3) {
        return (double)InvokeDynamicSupport.bootstrapStatic("IndianToJD", $$robo$$android_icu_util_IndianCalendar$IndianToJD(int int int ), (int)n, (int)n2, (int)n3);
    }

    private static double gregorianToJD(int n, int n2, int n3) {
        return (double)InvokeDynamicSupport.bootstrapStatic("gregorianToJD", $$robo$$android_icu_util_IndianCalendar$gregorianToJD(int int int ), (int)n, (int)n2, (int)n3);
    }

    private static int[] jdToGregorian(double d) {
        return InvokeDynamicSupport.bootstrapStatic("jdToGregorian", $$robo$$android_icu_util_IndianCalendar$jdToGregorian(double ), (double)d);
    }

    private static boolean isGregorianLeap(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isGregorianLeap", $$robo$$android_icu_util_IndianCalendar$isGregorianLeap(int ), (int)n);
    }

    @Override
    public String getType() {
        return InvokeDynamicSupport.bootstrap("getType", $$robo$$android_icu_util_IndianCalendar$getType(), this);
    }

    static {
        RobolectricInternals.classInitializing(IndianCalendar.class);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (IndianCalendar)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

