/*
 * Decompiled with CFR 0.152.
 */
package android.icu.util;

import com.google.errorprone.annotations.DoNotMock;
import java.util.ArrayList;
import java.util.HashMap;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class StringTrieBuilder
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private State state;
    @Deprecated
    protected StringBuilder strings;
    private Node root;
    private HashMap<Node, Node> nodes;
    private ValueNode lookupFinalValueNode;
    static /* synthetic */ boolean $assertionsDisabled;

    @Deprecated
    private void $$robo$$android_icu_util_StringTrieBuilder$__constructor__() {
        this.state = State.ADDING;
        this.strings = new StringBuilder();
        this.nodes = new HashMap();
        this.lookupFinalValueNode = new ValueNode();
    }

    @Deprecated
    private final void $$robo$$android_icu_util_StringTrieBuilder$addImpl(CharSequence s, int value) {
        if (this.state != State.ADDING) {
            throw new IllegalStateException("Cannot add (string, value) pairs after build().");
        }
        if (s.length() > 65535) {
            throw new IndexOutOfBoundsException("The maximum string length is 0xffff.");
        }
        this.root = this.root == null ? this.createSuffixNode(s, 0, value) : this.root.add(this, s, 0, value);
    }

    @Deprecated
    private final void $$robo$$android_icu_util_StringTrieBuilder$buildImpl(Option buildOption) {
        switch (1.$SwitchMap$android$icu$util$StringTrieBuilder$State[this.state.ordinal()]) {
            case 1: {
                if (this.root == null) {
                    throw new IndexOutOfBoundsException("No (string, value) pairs were added.");
                }
                if (buildOption == Option.FAST) {
                    this.state = State.BUILDING_FAST;
                    break;
                }
                this.state = State.BUILDING_SMALL;
                break;
            }
            case 2: 
            case 3: {
                throw new IllegalStateException("Builder failed and must be clear()ed.");
            }
            case 4: {
                return;
            }
        }
        this.root = this.root.register(this);
        this.root.markRightEdgesFirst(-1);
        this.root.write(this);
        this.state = State.BUILT;
    }

    @Deprecated
    private final void $$robo$$android_icu_util_StringTrieBuilder$clearImpl() {
        this.strings.setLength(0);
        this.nodes.clear();
        this.root = null;
        this.state = State.ADDING;
    }

    private final Node $$robo$$android_icu_util_StringTrieBuilder$registerNode(Node newNode) {
        if (this.state == State.BUILDING_FAST) {
            return newNode;
        }
        Node oldNode = this.nodes.get(newNode);
        if (oldNode != null) {
            return oldNode;
        }
        oldNode = this.nodes.put(newNode, newNode);
        if (!$assertionsDisabled && oldNode != null) {
            throw new AssertionError();
        }
        return newNode;
    }

    private final ValueNode $$robo$$android_icu_util_StringTrieBuilder$registerFinalValue(int value) {
        this.lookupFinalValueNode.setFinalValue(value);
        Node oldNode = this.nodes.get(this.lookupFinalValueNode);
        if (oldNode != null) {
            return (ValueNode)oldNode;
        }
        ValueNode newNode = new ValueNode(value);
        oldNode = this.nodes.put(newNode, newNode);
        if (!$assertionsDisabled && oldNode != null) {
            throw new AssertionError();
        }
        return newNode;
    }

    private final ValueNode $$robo$$android_icu_util_StringTrieBuilder$createSuffixNode(CharSequence s, int start, int sValue) {
        ValueNode node = this.registerFinalValue(sValue);
        if (start < s.length()) {
            int offset = this.strings.length();
            this.strings.append(s, start, s.length());
            node = new LinearMatchNode(this.strings, offset, s.length() - start, node);
        }
        return node;
    }

    @Deprecated
    protected abstract boolean matchNodesCanHaveValues();

    @Deprecated
    protected abstract int getMaxBranchLinearSubNodeLength();

    @Deprecated
    protected abstract int getMinLinearMatch();

    @Deprecated
    protected abstract int getMaxLinearMatchLength();

    @Deprecated
    protected abstract int write(int var1);

    @Deprecated
    protected abstract int write(int var1, int var2);

    @Deprecated
    protected abstract int writeValueAndFinal(int var1, boolean var2);

    @Deprecated
    protected abstract int writeValueAndType(boolean var1, int var2, int var3);

    @Deprecated
    protected abstract int writeDeltaTo(int var1);

    static void __staticInitializer__() {
        $assertionsDisabled = !StringTrieBuilder.class.desiredAssertionStatus();
    }

    private void __constructor__() {
        this.$$robo$$android_icu_util_StringTrieBuilder$__constructor__();
    }

    public StringTrieBuilder() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_util_StringTrieBuilder$__constructor__(), this);
    }

    @Deprecated
    protected void addImpl(CharSequence charSequence, int n) {
        InvokeDynamicSupport.bootstrap("addImpl", $$robo$$android_icu_util_StringTrieBuilder$addImpl(java.lang.CharSequence int ), this, charSequence, n);
    }

    @Deprecated
    protected void buildImpl(Option option) {
        InvokeDynamicSupport.bootstrap("buildImpl", $$robo$$android_icu_util_StringTrieBuilder$buildImpl(android.icu.util.StringTrieBuilder$Option ), this, option);
    }

    @Deprecated
    protected void clearImpl() {
        InvokeDynamicSupport.bootstrap("clearImpl", $$robo$$android_icu_util_StringTrieBuilder$clearImpl(), this);
    }

    private Node registerNode(Node node) {
        return InvokeDynamicSupport.bootstrap("registerNode", $$robo$$android_icu_util_StringTrieBuilder$registerNode(android.icu.util.StringTrieBuilder$Node ), this, node);
    }

    private ValueNode registerFinalValue(int n) {
        return InvokeDynamicSupport.bootstrap("registerFinalValue", $$robo$$android_icu_util_StringTrieBuilder$registerFinalValue(int ), this, n);
    }

    private ValueNode createSuffixNode(CharSequence charSequence, int n, int n2) {
        return InvokeDynamicSupport.bootstrap("createSuffixNode", $$robo$$android_icu_util_StringTrieBuilder$createSuffixNode(java.lang.CharSequence int int ), this, charSequence, n, n2);
    }

    static {
        RobolectricInternals.classInitializing(StringTrieBuilder.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (StringTrieBuilder)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class State
    extends Enum<State> {
        public /* synthetic */ Object __robo_data__;
        public static /* enum */ State ADDING;
        public static /* enum */ State BUILDING_FAST;
        public static /* enum */ State BUILDING_SMALL;
        public static /* enum */ State BUILT;
        private static /* synthetic */ State[] $VALUES;

        private static final State[] $$robo$$android_icu_util_StringTrieBuilder_State$values() {
            return (State[])$VALUES.clone();
        }

        private static final State $$robo$$android_icu_util_StringTrieBuilder_State$valueOf(String name) {
            return Enum.valueOf(State.class, name);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void $$robo$$android_icu_util_StringTrieBuilder_State$__constructor__(String string2, int n) {
        }

        static void __staticInitializer__() {
            ADDING = new State();
            BUILDING_FAST = new State();
            BUILDING_SMALL = new State();
            BUILT = new State();
            $VALUES = new State[]{ADDING, BUILDING_FAST, BUILDING_SMALL, BUILT};
        }

        public static State[] values() {
            return InvokeDynamicSupport.bootstrapStatic("values", $$robo$$android_icu_util_StringTrieBuilder_State$values());
        }

        public static State valueOf(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$android_icu_util_StringTrieBuilder_State$valueOf(java.lang.String ), (String)string2);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void __constructor__(String string2, int n) {
            this.$$robo$$android_icu_util_StringTrieBuilder_State$__constructor__(string2, n);
        }

        public State() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_util_StringTrieBuilder_State$__constructor__(java.lang.String int ), this, string2, n);
        }

        static {
            RobolectricInternals.classInitializing(State.class);
        }

        public /* synthetic */ State() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (State)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class BranchHeadNode
    extends ValueNode
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private int length;
        private Node next;

        private void $$robo$$android_icu_util_StringTrieBuilder_BranchHeadNode$__constructor__(int len, Node subNode) {
            this.length = len;
            this.next = subNode;
        }

        private final int $$robo$$android_icu_util_StringTrieBuilder_BranchHeadNode$hashCode() {
            return (0xECCCCBE + this.length) * 37 + this.next.hashCode();
        }

        private final boolean $$robo$$android_icu_util_StringTrieBuilder_BranchHeadNode$equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!super.equals(other)) {
                return false;
            }
            BranchHeadNode o = (BranchHeadNode)other;
            return this.length == o.length && this.next == o.next;
        }

        private final int $$robo$$android_icu_util_StringTrieBuilder_BranchHeadNode$markRightEdgesFirst(int edgeNumber) {
            if (this.offset == 0) {
                this.offset = edgeNumber = this.next.markRightEdgesFirst(edgeNumber);
            }
            return edgeNumber;
        }

        private final void $$robo$$android_icu_util_StringTrieBuilder_BranchHeadNode$write(StringTrieBuilder builder) {
            this.next.write(builder);
            if (this.length <= builder.getMinLinearMatch()) {
                this.offset = builder.writeValueAndType(this.hasValue, this.value, this.length - 1);
            } else {
                builder.write(this.length - 1);
                this.offset = builder.writeValueAndType(this.hasValue, this.value, 0);
            }
        }

        private void __constructor__(int n, Node node) {
            this.$$robo$$android_icu_util_StringTrieBuilder_BranchHeadNode$__constructor__(n, node);
        }

        public BranchHeadNode(int n, Node node) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_util_StringTrieBuilder_BranchHeadNode$__constructor__(int android.icu.util.StringTrieBuilder$Node ), this, n, node);
        }

        @Override
        public int hashCode() {
            return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_icu_util_StringTrieBuilder_BranchHeadNode$hashCode(), this);
        }

        @Override
        public boolean equals(Object object) {
            return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_icu_util_StringTrieBuilder_BranchHeadNode$equals(java.lang.Object ), this, object);
        }

        @Override
        public int markRightEdgesFirst(int n) {
            return (int)InvokeDynamicSupport.bootstrap("markRightEdgesFirst", $$robo$$android_icu_util_StringTrieBuilder_BranchHeadNode$markRightEdgesFirst(int ), this, n);
        }

        @Override
        public void write(StringTrieBuilder stringTrieBuilder) {
            InvokeDynamicSupport.bootstrap("write", $$robo$$android_icu_util_StringTrieBuilder_BranchHeadNode$write(android.icu.util.StringTrieBuilder ), this, stringTrieBuilder);
        }

        public /* synthetic */ BranchHeadNode() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BranchHeadNode)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class SplitBranchNode
    extends BranchNode
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private char unit;
        private Node lessThan;
        private Node greaterOrEqual;
        static /* synthetic */ boolean $assertionsDisabled;

        private void $$robo$$android_icu_util_StringTrieBuilder_SplitBranchNode$__constructor__(char middleUnit, Node lessThanNode, Node greaterOrEqualNode) {
            this.hash = ((206918985 + middleUnit) * 37 + lessThanNode.hashCode()) * 37 + greaterOrEqualNode.hashCode();
            this.unit = middleUnit;
            this.lessThan = lessThanNode;
            this.greaterOrEqual = greaterOrEqualNode;
        }

        private final boolean $$robo$$android_icu_util_StringTrieBuilder_SplitBranchNode$equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!super.equals(other)) {
                return false;
            }
            SplitBranchNode o = (SplitBranchNode)other;
            return this.unit == o.unit && this.lessThan == o.lessThan && this.greaterOrEqual == o.greaterOrEqual;
        }

        private final int $$robo$$android_icu_util_StringTrieBuilder_SplitBranchNode$hashCode() {
            return super.hashCode();
        }

        private final int $$robo$$android_icu_util_StringTrieBuilder_SplitBranchNode$markRightEdgesFirst(int edgeNumber) {
            if (this.offset == 0) {
                this.firstEdgeNumber = edgeNumber;
                edgeNumber = this.greaterOrEqual.markRightEdgesFirst(edgeNumber);
                this.offset = edgeNumber = this.lessThan.markRightEdgesFirst(edgeNumber - 1);
            }
            return edgeNumber;
        }

        private final void $$robo$$android_icu_util_StringTrieBuilder_SplitBranchNode$write(StringTrieBuilder builder) {
            this.lessThan.writeUnlessInsideRightEdge(this.firstEdgeNumber, this.greaterOrEqual.getOffset(), builder);
            this.greaterOrEqual.write(builder);
            if (!$assertionsDisabled && this.lessThan.getOffset() <= 0) {
                throw new AssertionError();
            }
            builder.writeDeltaTo(this.lessThan.getOffset());
            this.offset = builder.write(this.unit);
        }

        static void __staticInitializer__() {
            $assertionsDisabled = !StringTrieBuilder.class.desiredAssertionStatus();
        }

        private void __constructor__(char c, Node node, Node node2) {
            this.$$robo$$android_icu_util_StringTrieBuilder_SplitBranchNode$__constructor__(c, node, node2);
        }

        public SplitBranchNode(char c, Node node, Node node2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_util_StringTrieBuilder_SplitBranchNode$__constructor__(char android.icu.util.StringTrieBuilder$Node android.icu.util.StringTrieBuilder$Node ), this, c, node, node2);
        }

        @Override
        public boolean equals(Object object) {
            return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_icu_util_StringTrieBuilder_SplitBranchNode$equals(java.lang.Object ), this, object);
        }

        @Override
        public int hashCode() {
            return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_icu_util_StringTrieBuilder_SplitBranchNode$hashCode(), this);
        }

        @Override
        public int markRightEdgesFirst(int n) {
            return (int)InvokeDynamicSupport.bootstrap("markRightEdgesFirst", $$robo$$android_icu_util_StringTrieBuilder_SplitBranchNode$markRightEdgesFirst(int ), this, n);
        }

        @Override
        public void write(StringTrieBuilder stringTrieBuilder) {
            InvokeDynamicSupport.bootstrap("write", $$robo$$android_icu_util_StringTrieBuilder_SplitBranchNode$write(android.icu.util.StringTrieBuilder ), this, stringTrieBuilder);
        }

        static {
            RobolectricInternals.classInitializing(SplitBranchNode.class);
        }

        public /* synthetic */ SplitBranchNode() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SplitBranchNode)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class ListBranchNode
    extends BranchNode
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private Node[] equal;
        private int length;
        private int[] values;
        private char[] units;
        static /* synthetic */ boolean $assertionsDisabled;

        private void $$robo$$android_icu_util_StringTrieBuilder_ListBranchNode$__constructor__(int capacity) {
            this.hash = 0x9DDDDD4 + capacity;
            this.equal = new Node[capacity];
            this.values = new int[capacity];
            this.units = new char[capacity];
        }

        private final boolean $$robo$$android_icu_util_StringTrieBuilder_ListBranchNode$equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!super.equals(other)) {
                return false;
            }
            ListBranchNode o = (ListBranchNode)other;
            for (int i = 0; i < this.length; ++i) {
                if (this.units[i] == o.units[i] && this.values[i] == o.values[i] && this.equal[i] == o.equal[i]) continue;
                return false;
            }
            return true;
        }

        private final int $$robo$$android_icu_util_StringTrieBuilder_ListBranchNode$hashCode() {
            return super.hashCode();
        }

        private final int $$robo$$android_icu_util_StringTrieBuilder_ListBranchNode$markRightEdgesFirst(int edgeNumber) {
            if (this.offset == 0) {
                this.firstEdgeNumber = edgeNumber;
                int step = 0;
                int i = this.length;
                do {
                    Node edge;
                    if ((edge = this.equal[--i]) != null) {
                        edgeNumber = edge.markRightEdgesFirst(edgeNumber - step);
                    }
                    step = 1;
                } while (i > 0);
                this.offset = edgeNumber;
            }
            return edgeNumber;
        }

        private final void $$robo$$android_icu_util_StringTrieBuilder_ListBranchNode$write(StringTrieBuilder builder) {
            int rightEdgeNumber;
            int unitNumber = this.length - 1;
            Node rightEdge = this.equal[unitNumber];
            int n = rightEdgeNumber = rightEdge == null ? this.firstEdgeNumber : rightEdge.getOffset();
            do {
                if (this.equal[--unitNumber] == null) continue;
                this.equal[unitNumber].writeUnlessInsideRightEdge(this.firstEdgeNumber, rightEdgeNumber, builder);
            } while (unitNumber > 0);
            unitNumber = this.length - 1;
            if (rightEdge == null) {
                builder.writeValueAndFinal(this.values[unitNumber], true);
            } else {
                rightEdge.write(builder);
            }
            this.offset = builder.write(this.units[unitNumber]);
            while (--unitNumber >= 0) {
                boolean isFinal;
                int value;
                if (this.equal[unitNumber] == null) {
                    value = this.values[unitNumber];
                    isFinal = true;
                } else {
                    if (!$assertionsDisabled && this.equal[unitNumber].getOffset() <= 0) {
                        throw new AssertionError();
                    }
                    value = this.offset - this.equal[unitNumber].getOffset();
                    isFinal = false;
                }
                builder.writeValueAndFinal(value, isFinal);
                this.offset = builder.write(this.units[unitNumber]);
            }
        }

        private final void $$robo$$android_icu_util_StringTrieBuilder_ListBranchNode$add(int c, int value) {
            this.units[this.length] = (char)c;
            this.equal[this.length] = null;
            this.values[this.length] = value;
            ++this.length;
            this.hash = (this.hash * 37 + c) * 37 + value;
        }

        private final void $$robo$$android_icu_util_StringTrieBuilder_ListBranchNode$add(int c, Node node) {
            this.units[this.length] = (char)c;
            this.equal[this.length] = node;
            this.values[this.length] = 0;
            ++this.length;
            this.hash = (this.hash * 37 + c) * 37 + node.hashCode();
        }

        static void __staticInitializer__() {
            $assertionsDisabled = !StringTrieBuilder.class.desiredAssertionStatus();
        }

        private void __constructor__(int n) {
            this.$$robo$$android_icu_util_StringTrieBuilder_ListBranchNode$__constructor__(n);
        }

        public ListBranchNode(int n) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_util_StringTrieBuilder_ListBranchNode$__constructor__(int ), this, n);
        }

        @Override
        public boolean equals(Object object) {
            return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_icu_util_StringTrieBuilder_ListBranchNode$equals(java.lang.Object ), this, object);
        }

        @Override
        public int hashCode() {
            return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_icu_util_StringTrieBuilder_ListBranchNode$hashCode(), this);
        }

        @Override
        public int markRightEdgesFirst(int n) {
            return (int)InvokeDynamicSupport.bootstrap("markRightEdgesFirst", $$robo$$android_icu_util_StringTrieBuilder_ListBranchNode$markRightEdgesFirst(int ), this, n);
        }

        @Override
        public void write(StringTrieBuilder stringTrieBuilder) {
            InvokeDynamicSupport.bootstrap("write", $$robo$$android_icu_util_StringTrieBuilder_ListBranchNode$write(android.icu.util.StringTrieBuilder ), this, stringTrieBuilder);
        }

        public void add(int n, int n2) {
            InvokeDynamicSupport.bootstrap("add", $$robo$$android_icu_util_StringTrieBuilder_ListBranchNode$add(int int ), this, n, n2);
        }

        public void add(int n, Node node) {
            InvokeDynamicSupport.bootstrap("add", $$robo$$android_icu_util_StringTrieBuilder_ListBranchNode$add(int android.icu.util.StringTrieBuilder$Node ), this, n, node);
        }

        static {
            RobolectricInternals.classInitializing(ListBranchNode.class);
        }

        public /* synthetic */ ListBranchNode() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ListBranchNode)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static abstract class BranchNode
    extends Node
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        protected int hash;
        protected int firstEdgeNumber;

        private void $$robo$$android_icu_util_StringTrieBuilder_BranchNode$__constructor__() {
        }

        private final int $$robo$$android_icu_util_StringTrieBuilder_BranchNode$hashCode() {
            return this.hash;
        }

        private void __constructor__() {
            this.$$robo$$android_icu_util_StringTrieBuilder_BranchNode$__constructor__();
        }

        public BranchNode() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_util_StringTrieBuilder_BranchNode$__constructor__(), this);
        }

        @Override
        public int hashCode() {
            return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_icu_util_StringTrieBuilder_BranchNode$hashCode(), this);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BranchNode)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class DynamicBranchNode
    extends ValueNode
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private StringBuilder chars;
        private ArrayList<Node> equal;

        private void $$robo$$android_icu_util_StringTrieBuilder_DynamicBranchNode$__constructor__() {
            this.chars = new StringBuilder();
            this.equal = new ArrayList();
        }

        private final void $$robo$$android_icu_util_StringTrieBuilder_DynamicBranchNode$add(char c, Node node) {
            int i = this.find(c);
            this.chars.insert(i, c);
            this.equal.add(i, node);
        }

        private final Node $$robo$$android_icu_util_StringTrieBuilder_DynamicBranchNode$add(StringTrieBuilder builder, CharSequence s, int start, int sValue) {
            char c;
            int i;
            if (start == s.length()) {
                if (this.hasValue) {
                    throw new IllegalArgumentException("Duplicate string.");
                }
                this.setValue(sValue);
                return this;
            }
            if ((i = this.find(c = s.charAt(start++))) < this.chars.length() && c == this.chars.charAt(i)) {
                this.equal.set(i, this.equal.get(i).add(builder, s, start, sValue));
            } else {
                this.chars.insert(i, c);
                this.equal.add(i, builder.createSuffixNode(s, start, sValue));
            }
            return this;
        }

        private final Node $$robo$$android_icu_util_StringTrieBuilder_DynamicBranchNode$register(StringTrieBuilder builder) {
            BranchHeadNode head;
            Node subNode = this.register(builder, 0, this.chars.length());
            ValueNode result = head = new BranchHeadNode(this.chars.length(), subNode);
            if (this.hasValue) {
                if (builder.matchNodesCanHaveValues()) {
                    head.setValue(this.value);
                } else {
                    result = new IntermediateValueNode(this.value, builder.registerNode(head));
                }
            }
            return builder.registerNode(result);
        }

        private final Node $$robo$$android_icu_util_StringTrieBuilder_DynamicBranchNode$register(StringTrieBuilder builder, int start, int limit) {
            int length = limit - start;
            if (length > builder.getMaxBranchLinearSubNodeLength()) {
                int middle = start + length / 2;
                return builder.registerNode(new SplitBranchNode(this.chars.charAt(middle), this.register(builder, start, middle), this.register(builder, middle, limit)));
            }
            ListBranchNode listNode = new ListBranchNode(length);
            do {
                char c = this.chars.charAt(start);
                Node node = this.equal.get(start);
                if (node.getClass() == ValueNode.class) {
                    listNode.add((int)c, ((ValueNode)node).value);
                    continue;
                }
                listNode.add((int)c, node.register(builder));
            } while (++start < limit);
            return builder.registerNode(listNode);
        }

        private final int $$robo$$android_icu_util_StringTrieBuilder_DynamicBranchNode$find(char c) {
            int start = 0;
            int limit = this.chars.length();
            while (start < limit) {
                int i = (start + limit) / 2;
                char middleChar = this.chars.charAt(i);
                if (c < middleChar) {
                    limit = i;
                    continue;
                }
                if (c == middleChar) {
                    return i;
                }
                start = i + 1;
            }
            return start;
        }

        private void __constructor__() {
            this.$$robo$$android_icu_util_StringTrieBuilder_DynamicBranchNode$__constructor__();
        }

        public DynamicBranchNode() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_util_StringTrieBuilder_DynamicBranchNode$__constructor__(), this);
        }

        public void add(char c, Node node) {
            InvokeDynamicSupport.bootstrap("add", $$robo$$android_icu_util_StringTrieBuilder_DynamicBranchNode$add(char android.icu.util.StringTrieBuilder$Node ), this, c, node);
        }

        @Override
        public Node add(StringTrieBuilder stringTrieBuilder, CharSequence charSequence, int n, int n2) {
            return InvokeDynamicSupport.bootstrap("add", $$robo$$android_icu_util_StringTrieBuilder_DynamicBranchNode$add(android.icu.util.StringTrieBuilder java.lang.CharSequence int int ), this, stringTrieBuilder, charSequence, n, n2);
        }

        @Override
        public Node register(StringTrieBuilder stringTrieBuilder) {
            return InvokeDynamicSupport.bootstrap("register", $$robo$$android_icu_util_StringTrieBuilder_DynamicBranchNode$register(android.icu.util.StringTrieBuilder ), this, stringTrieBuilder);
        }

        private Node register(StringTrieBuilder stringTrieBuilder, int n, int n2) {
            return InvokeDynamicSupport.bootstrap("register", $$robo$$android_icu_util_StringTrieBuilder_DynamicBranchNode$register(android.icu.util.StringTrieBuilder int int ), this, stringTrieBuilder, n, n2);
        }

        private int find(char c) {
            return (int)InvokeDynamicSupport.bootstrap("find", $$robo$$android_icu_util_StringTrieBuilder_DynamicBranchNode$find(char ), this, c);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DynamicBranchNode)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class LinearMatchNode
    extends ValueNode
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private CharSequence strings;
        private int stringOffset;
        private int length;
        private Node next;
        private int hash;

        private void $$robo$$android_icu_util_StringTrieBuilder_LinearMatchNode$__constructor__(CharSequence builderStrings, int sOffset, int len, Node nextNode) {
            this.strings = builderStrings;
            this.stringOffset = sOffset;
            this.length = len;
            this.next = nextNode;
        }

        private final int $$robo$$android_icu_util_StringTrieBuilder_LinearMatchNode$hashCode() {
            return this.hash;
        }

        private final boolean $$robo$$android_icu_util_StringTrieBuilder_LinearMatchNode$equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!super.equals(other)) {
                return false;
            }
            LinearMatchNode o = (LinearMatchNode)other;
            if (this.length != o.length || this.next != o.next) {
                return false;
            }
            int i = this.stringOffset;
            int j = o.stringOffset;
            int limit = this.stringOffset + this.length;
            while (i < limit) {
                if (this.strings.charAt(i) != this.strings.charAt(j)) {
                    return false;
                }
                ++i;
                ++j;
            }
            return true;
        }

        private final Node $$robo$$android_icu_util_StringTrieBuilder_LinearMatchNode$add(StringTrieBuilder builder, CharSequence s, int start, int sValue) {
            if (start == s.length()) {
                if (this.hasValue) {
                    throw new IllegalArgumentException("Duplicate string.");
                }
                this.setValue(sValue);
                return this;
            }
            int limit = this.stringOffset + this.length;
            int i = this.stringOffset;
            while (i < limit) {
                char newChar;
                if (start == s.length()) {
                    int prefixLength = i - this.stringOffset;
                    LinearMatchNode suffixNode = new LinearMatchNode(this.strings, i, this.length - prefixLength, this.next);
                    suffixNode.setValue(sValue);
                    this.length = prefixLength;
                    this.next = suffixNode;
                    return this;
                }
                char thisChar = this.strings.charAt(i);
                if (thisChar != (newChar = s.charAt(start))) {
                    ValueNode result;
                    Node thisSuffixNode;
                    DynamicBranchNode branchNode = new DynamicBranchNode();
                    if (i == this.stringOffset) {
                        if (this.hasValue) {
                            branchNode.setValue(this.value);
                            this.value = 0;
                            this.hasValue = false;
                        }
                        ++this.stringOffset;
                        --this.length;
                        thisSuffixNode = this.length > 0 ? this : this.next;
                        result = branchNode;
                    } else if (i == limit - 1) {
                        --this.length;
                        thisSuffixNode = this.next;
                        this.next = branchNode;
                        result = this;
                    } else {
                        int prefixLength = i - this.stringOffset;
                        thisSuffixNode = new LinearMatchNode(this.strings, ++i, this.length - (prefixLength + 1), this.next);
                        this.length = prefixLength;
                        this.next = branchNode;
                        result = this;
                    }
                    ValueNode newSuffixNode = builder.createSuffixNode(s, start + 1, sValue);
                    branchNode.add(thisChar, thisSuffixNode);
                    branchNode.add(newChar, newSuffixNode);
                    return result;
                }
                ++i;
                ++start;
            }
            this.next = this.next.add(builder, s, start, sValue);
            return this;
        }

        private final Node $$robo$$android_icu_util_StringTrieBuilder_LinearMatchNode$register(StringTrieBuilder builder) {
            ValueNode result;
            this.next = this.next.register(builder);
            int maxLinearMatchLength = builder.getMaxLinearMatchLength();
            while (this.length > maxLinearMatchLength) {
                int nextOffset = this.stringOffset + this.length - maxLinearMatchLength;
                this.length -= maxLinearMatchLength;
                LinearMatchNode suffixNode = new LinearMatchNode(this.strings, nextOffset, maxLinearMatchLength, this.next);
                suffixNode.setHashCode();
                this.next = builder.registerNode(suffixNode);
            }
            if (this.hasValue && !builder.matchNodesCanHaveValues()) {
                int intermediateValue = this.value;
                this.value = 0;
                this.hasValue = false;
                this.setHashCode();
                result = new IntermediateValueNode(intermediateValue, builder.registerNode(this));
            } else {
                this.setHashCode();
                result = this;
            }
            return builder.registerNode(result);
        }

        private final int $$robo$$android_icu_util_StringTrieBuilder_LinearMatchNode$markRightEdgesFirst(int edgeNumber) {
            if (this.offset == 0) {
                this.offset = edgeNumber = this.next.markRightEdgesFirst(edgeNumber);
            }
            return edgeNumber;
        }

        private final void $$robo$$android_icu_util_StringTrieBuilder_LinearMatchNode$write(StringTrieBuilder builder) {
            this.next.write(builder);
            builder.write(this.stringOffset, this.length);
            this.offset = builder.writeValueAndType(this.hasValue, this.value, builder.getMinLinearMatch() + this.length - 1);
        }

        private final void $$robo$$android_icu_util_StringTrieBuilder_LinearMatchNode$setHashCode() {
            this.hash = (124151391 + this.length) * 37 + this.next.hashCode();
            if (this.hasValue) {
                this.hash = this.hash * 37 + this.value;
            }
            int limit = this.stringOffset + this.length;
            for (int i = this.stringOffset; i < limit; ++i) {
                this.hash = this.hash * 37 + this.strings.charAt(i);
            }
        }

        private void __constructor__(CharSequence charSequence, int n, int n2, Node node) {
            this.$$robo$$android_icu_util_StringTrieBuilder_LinearMatchNode$__constructor__(charSequence, n, n2, node);
        }

        public LinearMatchNode(CharSequence charSequence, int n, int n2, Node node) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_util_StringTrieBuilder_LinearMatchNode$__constructor__(java.lang.CharSequence int int android.icu.util.StringTrieBuilder$Node ), this, charSequence, n, n2, node);
        }

        @Override
        public int hashCode() {
            return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_icu_util_StringTrieBuilder_LinearMatchNode$hashCode(), this);
        }

        @Override
        public boolean equals(Object object) {
            return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_icu_util_StringTrieBuilder_LinearMatchNode$equals(java.lang.Object ), this, object);
        }

        @Override
        public Node add(StringTrieBuilder stringTrieBuilder, CharSequence charSequence, int n, int n2) {
            return InvokeDynamicSupport.bootstrap("add", $$robo$$android_icu_util_StringTrieBuilder_LinearMatchNode$add(android.icu.util.StringTrieBuilder java.lang.CharSequence int int ), this, stringTrieBuilder, charSequence, n, n2);
        }

        @Override
        public Node register(StringTrieBuilder stringTrieBuilder) {
            return InvokeDynamicSupport.bootstrap("register", $$robo$$android_icu_util_StringTrieBuilder_LinearMatchNode$register(android.icu.util.StringTrieBuilder ), this, stringTrieBuilder);
        }

        @Override
        public int markRightEdgesFirst(int n) {
            return (int)InvokeDynamicSupport.bootstrap("markRightEdgesFirst", $$robo$$android_icu_util_StringTrieBuilder_LinearMatchNode$markRightEdgesFirst(int ), this, n);
        }

        @Override
        public void write(StringTrieBuilder stringTrieBuilder) {
            InvokeDynamicSupport.bootstrap("write", $$robo$$android_icu_util_StringTrieBuilder_LinearMatchNode$write(android.icu.util.StringTrieBuilder ), this, stringTrieBuilder);
        }

        private void setHashCode() {
            InvokeDynamicSupport.bootstrap("setHashCode", $$robo$$android_icu_util_StringTrieBuilder_LinearMatchNode$setHashCode(), this);
        }

        public /* synthetic */ LinearMatchNode() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LinearMatchNode)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class IntermediateValueNode
    extends ValueNode
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private Node next;

        private void $$robo$$android_icu_util_StringTrieBuilder_IntermediateValueNode$__constructor__(int v, Node nextNode) {
            this.next = nextNode;
            this.setValue(v);
        }

        private final int $$robo$$android_icu_util_StringTrieBuilder_IntermediateValueNode$hashCode() {
            return (0x4EEEEEA + this.value) * 37 + this.next.hashCode();
        }

        private final boolean $$robo$$android_icu_util_StringTrieBuilder_IntermediateValueNode$equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!super.equals(other)) {
                return false;
            }
            IntermediateValueNode o = (IntermediateValueNode)other;
            return this.next == o.next;
        }

        private final int $$robo$$android_icu_util_StringTrieBuilder_IntermediateValueNode$markRightEdgesFirst(int edgeNumber) {
            if (this.offset == 0) {
                this.offset = edgeNumber = this.next.markRightEdgesFirst(edgeNumber);
            }
            return edgeNumber;
        }

        private final void $$robo$$android_icu_util_StringTrieBuilder_IntermediateValueNode$write(StringTrieBuilder builder) {
            this.next.write(builder);
            this.offset = builder.writeValueAndFinal(this.value, false);
        }

        private void __constructor__(int n, Node node) {
            this.$$robo$$android_icu_util_StringTrieBuilder_IntermediateValueNode$__constructor__(n, node);
        }

        public IntermediateValueNode(int n, Node node) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_util_StringTrieBuilder_IntermediateValueNode$__constructor__(int android.icu.util.StringTrieBuilder$Node ), this, n, node);
        }

        @Override
        public int hashCode() {
            return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_icu_util_StringTrieBuilder_IntermediateValueNode$hashCode(), this);
        }

        @Override
        public boolean equals(Object object) {
            return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_icu_util_StringTrieBuilder_IntermediateValueNode$equals(java.lang.Object ), this, object);
        }

        @Override
        public int markRightEdgesFirst(int n) {
            return (int)InvokeDynamicSupport.bootstrap("markRightEdgesFirst", $$robo$$android_icu_util_StringTrieBuilder_IntermediateValueNode$markRightEdgesFirst(int ), this, n);
        }

        @Override
        public void write(StringTrieBuilder stringTrieBuilder) {
            InvokeDynamicSupport.bootstrap("write", $$robo$$android_icu_util_StringTrieBuilder_IntermediateValueNode$write(android.icu.util.StringTrieBuilder ), this, stringTrieBuilder);
        }

        public /* synthetic */ IntermediateValueNode() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (IntermediateValueNode)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class ValueNode
    extends Node
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        protected boolean hasValue;
        protected int value;
        static /* synthetic */ boolean $assertionsDisabled;

        private void $$robo$$android_icu_util_StringTrieBuilder_ValueNode$__constructor__() {
        }

        private void $$robo$$android_icu_util_StringTrieBuilder_ValueNode$__constructor__(int v) {
            this.hasValue = true;
            this.value = v;
        }

        private final void $$robo$$android_icu_util_StringTrieBuilder_ValueNode$setValue(int v) {
            if (!$assertionsDisabled && this.hasValue) {
                throw new AssertionError();
            }
            this.hasValue = true;
            this.value = v;
        }

        private final void $$robo$$android_icu_util_StringTrieBuilder_ValueNode$setFinalValue(int v) {
            this.hasValue = true;
            this.value = v;
        }

        private final int $$robo$$android_icu_util_StringTrieBuilder_ValueNode$hashCode() {
            int hash = 0x111111;
            if (this.hasValue) {
                hash = hash * 37 + this.value;
            }
            return hash;
        }

        private final boolean $$robo$$android_icu_util_StringTrieBuilder_ValueNode$equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!super.equals(other)) {
                return false;
            }
            ValueNode o = (ValueNode)other;
            return this.hasValue == o.hasValue && (!this.hasValue || this.value == o.value);
        }

        private final Node $$robo$$android_icu_util_StringTrieBuilder_ValueNode$add(StringTrieBuilder builder, CharSequence s, int start, int sValue) {
            if (start == s.length()) {
                throw new IllegalArgumentException("Duplicate string.");
            }
            ValueNode node = builder.createSuffixNode(s, start, sValue);
            node.setValue(this.value);
            return node;
        }

        private final void $$robo$$android_icu_util_StringTrieBuilder_ValueNode$write(StringTrieBuilder builder) {
            this.offset = builder.writeValueAndFinal(this.value, true);
        }

        static void __staticInitializer__() {
            $assertionsDisabled = !StringTrieBuilder.class.desiredAssertionStatus();
        }

        private void __constructor__() {
            this.$$robo$$android_icu_util_StringTrieBuilder_ValueNode$__constructor__();
        }

        public ValueNode() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_util_StringTrieBuilder_ValueNode$__constructor__(), this);
        }

        private void __constructor__(int n) {
            this.$$robo$$android_icu_util_StringTrieBuilder_ValueNode$__constructor__(n);
        }

        public ValueNode(int n) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_util_StringTrieBuilder_ValueNode$__constructor__(int ), this, n);
        }

        public void setValue(int n) {
            InvokeDynamicSupport.bootstrap("setValue", $$robo$$android_icu_util_StringTrieBuilder_ValueNode$setValue(int ), this, n);
        }

        private void setFinalValue(int n) {
            InvokeDynamicSupport.bootstrap("setFinalValue", $$robo$$android_icu_util_StringTrieBuilder_ValueNode$setFinalValue(int ), this, n);
        }

        @Override
        public int hashCode() {
            return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_icu_util_StringTrieBuilder_ValueNode$hashCode(), this);
        }

        @Override
        public boolean equals(Object object) {
            return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_icu_util_StringTrieBuilder_ValueNode$equals(java.lang.Object ), this, object);
        }

        @Override
        public Node add(StringTrieBuilder stringTrieBuilder, CharSequence charSequence, int n, int n2) {
            return InvokeDynamicSupport.bootstrap("add", $$robo$$android_icu_util_StringTrieBuilder_ValueNode$add(android.icu.util.StringTrieBuilder java.lang.CharSequence int int ), this, stringTrieBuilder, charSequence, n, n2);
        }

        @Override
        public void write(StringTrieBuilder stringTrieBuilder) {
            InvokeDynamicSupport.bootstrap("write", $$robo$$android_icu_util_StringTrieBuilder_ValueNode$write(android.icu.util.StringTrieBuilder ), this, stringTrieBuilder);
        }

        static {
            RobolectricInternals.classInitializing(ValueNode.class);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ValueNode)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static abstract class Node
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        protected int offset;

        private void $$robo$$android_icu_util_StringTrieBuilder_Node$__constructor__() {
            this.offset = 0;
        }

        public abstract int hashCode();

        private final boolean $$robo$$android_icu_util_StringTrieBuilder_Node$equals(Object other) {
            return this == other || this.getClass() == other.getClass();
        }

        private final Node $$robo$$android_icu_util_StringTrieBuilder_Node$add(StringTrieBuilder builder, CharSequence s, int start, int sValue) {
            return this;
        }

        private final Node $$robo$$android_icu_util_StringTrieBuilder_Node$register(StringTrieBuilder builder) {
            return this;
        }

        private final int $$robo$$android_icu_util_StringTrieBuilder_Node$markRightEdgesFirst(int edgeNumber) {
            if (this.offset == 0) {
                this.offset = edgeNumber;
            }
            return edgeNumber;
        }

        public abstract void write(StringTrieBuilder var1);

        private final void $$robo$$android_icu_util_StringTrieBuilder_Node$writeUnlessInsideRightEdge(int firstRight, int lastRight, StringTrieBuilder builder) {
            if (this.offset < 0 && (this.offset < lastRight || firstRight < this.offset)) {
                this.write(builder);
            }
        }

        private final int $$robo$$android_icu_util_StringTrieBuilder_Node$getOffset() {
            return this.offset;
        }

        private void __constructor__() {
            this.$$robo$$android_icu_util_StringTrieBuilder_Node$__constructor__();
        }

        public Node() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_util_StringTrieBuilder_Node$__constructor__(), this);
        }

        public boolean equals(Object object) {
            return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_icu_util_StringTrieBuilder_Node$equals(java.lang.Object ), this, object);
        }

        public Node add(StringTrieBuilder stringTrieBuilder, CharSequence charSequence, int n, int n2) {
            return InvokeDynamicSupport.bootstrap("add", $$robo$$android_icu_util_StringTrieBuilder_Node$add(android.icu.util.StringTrieBuilder java.lang.CharSequence int int ), this, stringTrieBuilder, charSequence, n, n2);
        }

        public Node register(StringTrieBuilder stringTrieBuilder) {
            return InvokeDynamicSupport.bootstrap("register", $$robo$$android_icu_util_StringTrieBuilder_Node$register(android.icu.util.StringTrieBuilder ), this, stringTrieBuilder);
        }

        public int markRightEdgesFirst(int n) {
            return (int)InvokeDynamicSupport.bootstrap("markRightEdgesFirst", $$robo$$android_icu_util_StringTrieBuilder_Node$markRightEdgesFirst(int ), this, n);
        }

        public void writeUnlessInsideRightEdge(int n, int n2, StringTrieBuilder stringTrieBuilder) {
            InvokeDynamicSupport.bootstrap("writeUnlessInsideRightEdge", $$robo$$android_icu_util_StringTrieBuilder_Node$writeUnlessInsideRightEdge(int int android.icu.util.StringTrieBuilder ), this, n, n2, stringTrieBuilder);
        }

        public int getOffset() {
            return (int)InvokeDynamicSupport.bootstrap("getOffset", $$robo$$android_icu_util_StringTrieBuilder_Node$getOffset(), this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Node)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class Option
    extends Enum<Option> {
        public /* synthetic */ Object __robo_data__;
        public static /* enum */ Option FAST;
        public static /* enum */ Option SMALL;
        private static /* synthetic */ Option[] $VALUES;

        private static final Option[] $$robo$$android_icu_util_StringTrieBuilder_Option$values() {
            return (Option[])$VALUES.clone();
        }

        private static final Option $$robo$$android_icu_util_StringTrieBuilder_Option$valueOf(String name) {
            return Enum.valueOf(Option.class, name);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void $$robo$$android_icu_util_StringTrieBuilder_Option$__constructor__(String string2, int n) {
        }

        static void __staticInitializer__() {
            FAST = new Option();
            SMALL = new Option();
            $VALUES = new Option[]{FAST, SMALL};
        }

        public static Option[] values() {
            return InvokeDynamicSupport.bootstrapStatic("values", $$robo$$android_icu_util_StringTrieBuilder_Option$values());
        }

        public static Option valueOf(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$android_icu_util_StringTrieBuilder_Option$valueOf(java.lang.String ), (String)string2);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void __constructor__(String string2, int n) {
            this.$$robo$$android_icu_util_StringTrieBuilder_Option$__constructor__(string2, n);
        }

        public Option() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_util_StringTrieBuilder_Option$__constructor__(java.lang.String int ), this, string2, n);
        }

        static {
            RobolectricInternals.classInitializing(Option.class);
        }

        public /* synthetic */ Option() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Option)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

