/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.media.MediaCodecInfo;
import android.media.MediaFormat;
import android.util.Log;
import com.google.errorprone.annotations.DoNotMock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class MediaCodecList
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "MediaCodecList";
    private static Object sInitLock;
    private static MediaCodecInfo[] sAllCodecInfos;
    private static MediaCodecInfo[] sRegularCodecInfos;
    private static Map<String, Object> sGlobalSettings;
    public static int REGULAR_CODECS = 0;
    public static int ALL_CODECS = 1;
    private MediaCodecInfo[] mCodecInfos;

    private static final int $$robo$$android_media_MediaCodecList$getCodecCount() {
        MediaCodecList.initCodecList();
        return sRegularCodecInfos.length;
    }

    private static final int $$robo$$android_media_MediaCodecList$native_getCodecCount() {
        return 0;
    }

    private static final MediaCodecInfo $$robo$$android_media_MediaCodecList$getCodecInfoAt(int index) {
        MediaCodecList.initCodecList();
        if (index < 0 || index > sRegularCodecInfos.length) {
            throw new IllegalArgumentException();
        }
        return sRegularCodecInfos[index];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Map<String, Object> $$robo$$android_media_MediaCodecList$getGlobalSettings() {
        Object object = sInitLock;
        synchronized (object) {
            if (sGlobalSettings == null) {
                sGlobalSettings = MediaCodecList.native_getGlobalSettings();
            }
        }
        return sGlobalSettings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void $$robo$$android_media_MediaCodecList$initCodecList() {
        Object object = sInitLock;
        synchronized (object) {
            if (sRegularCodecInfos == null) {
                int count = MediaCodecList.native_getCodecCount();
                ArrayList<MediaCodecInfo> regulars = new ArrayList<MediaCodecInfo>();
                ArrayList<MediaCodecInfo> all = new ArrayList<MediaCodecInfo>();
                for (int index = 0; index < count; ++index) {
                    try {
                        MediaCodecInfo info = MediaCodecList.getNewCodecInfoAt(index);
                        all.add(info);
                        info = info.makeRegular();
                        if (info == null) continue;
                        regulars.add(info);
                        continue;
                    }
                    catch (Exception e) {
                        Log.e("MediaCodecList", "Could not get codec capabilities", e);
                    }
                }
                sRegularCodecInfos = regulars.toArray(new MediaCodecInfo[regulars.size()]);
                sAllCodecInfos = all.toArray(new MediaCodecInfo[all.size()]);
            }
        }
    }

    private static final MediaCodecInfo $$robo$$android_media_MediaCodecList$getNewCodecInfoAt(int index) {
        String[] supportedTypes = MediaCodecList.getSupportedTypes(index);
        MediaCodecInfo.CodecCapabilities[] caps = new MediaCodecInfo.CodecCapabilities[supportedTypes.length];
        int typeIx = 0;
        for (String type : supportedTypes) {
            caps[typeIx++] = MediaCodecList.getCodecCapabilities(index, type);
        }
        return new MediaCodecInfo(MediaCodecList.getCodecName(index), MediaCodecList.isEncoder(index), caps);
    }

    private static final String $$robo$$android_media_MediaCodecList$getCodecName(int n) {
        return null;
    }

    private static final boolean $$robo$$android_media_MediaCodecList$isEncoder(int n) {
        return false;
    }

    private static final String[] $$robo$$android_media_MediaCodecList$getSupportedTypes(int n) {
        return null;
    }

    private static final MediaCodecInfo.CodecCapabilities $$robo$$android_media_MediaCodecList$getCodecCapabilities(int n, String string2) {
        return null;
    }

    private static final Map<String, Object> $$robo$$android_media_MediaCodecList$native_getGlobalSettings() {
        return null;
    }

    private static final int $$robo$$android_media_MediaCodecList$findCodecByName(String string2) {
        return 0;
    }

    private static final MediaCodecInfo $$robo$$android_media_MediaCodecList$getInfoFor(String codec) {
        MediaCodecList.initCodecList();
        return sAllCodecInfos[MediaCodecList.findCodecByName(codec)];
    }

    private static final void $$robo$$android_media_MediaCodecList$native_init() {
    }

    private void $$robo$$android_media_MediaCodecList$__constructor__() {
    }

    private void $$robo$$android_media_MediaCodecList$__constructor__(int kind) {
        MediaCodecList.initCodecList();
        this.mCodecInfos = kind == 0 ? sRegularCodecInfos : sAllCodecInfos;
    }

    private final MediaCodecInfo[] $$robo$$android_media_MediaCodecList$getCodecInfos() {
        return Arrays.copyOf(this.mCodecInfos, this.mCodecInfos.length);
    }

    private final String $$robo$$android_media_MediaCodecList$findDecoderForFormat(MediaFormat format) {
        return this.findCodecForFormat(false, format);
    }

    private final String $$robo$$android_media_MediaCodecList$findEncoderForFormat(MediaFormat format) {
        return this.findCodecForFormat(true, format);
    }

    private final String $$robo$$android_media_MediaCodecList$findCodecForFormat(boolean encoder, MediaFormat format) {
        String mime = format.getString("mime");
        for (MediaCodecInfo info : this.mCodecInfos) {
            if (info.isEncoder() != encoder) continue;
            try {
                MediaCodecInfo.CodecCapabilities caps = info.getCapabilitiesForType(mime);
                if (caps == null || !caps.isFormatSupported(format)) continue;
                return info.getName();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return null;
    }

    static void __staticInitializer__() {
        sInitLock = new Object();
        InvokeDynamicSupport.bootstrapIntrinsic("loadLibrary", "java.lang.System", (String)"media_jni");
        MediaCodecList.native_init();
    }

    public static int getCodecCount() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getCodecCount", $$robo$$android_media_MediaCodecList$getCodecCount());
    }

    private static int native_getCodecCount() {
        return (int)InvokeDynamicSupport.bootstrapStatic("native_getCodecCount", $$robo$$android_media_MediaCodecList$native_getCodecCount());
    }

    public static MediaCodecInfo getCodecInfoAt(int n) {
        return InvokeDynamicSupport.bootstrapStatic("getCodecInfoAt", $$robo$$android_media_MediaCodecList$getCodecInfoAt(int ), (int)n);
    }

    static Map<String, Object> getGlobalSettings() {
        return InvokeDynamicSupport.bootstrapStatic("getGlobalSettings", $$robo$$android_media_MediaCodecList$getGlobalSettings());
    }

    private static void initCodecList() {
        InvokeDynamicSupport.bootstrapStatic("initCodecList", $$robo$$android_media_MediaCodecList$initCodecList());
    }

    private static MediaCodecInfo getNewCodecInfoAt(int n) {
        return InvokeDynamicSupport.bootstrapStatic("getNewCodecInfoAt", $$robo$$android_media_MediaCodecList$getNewCodecInfoAt(int ), (int)n);
    }

    static String getCodecName(int n) {
        return InvokeDynamicSupport.bootstrapStatic("getCodecName", $$robo$$android_media_MediaCodecList$getCodecName(int ), (int)n);
    }

    static boolean isEncoder(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isEncoder", $$robo$$android_media_MediaCodecList$isEncoder(int ), (int)n);
    }

    static String[] getSupportedTypes(int n) {
        return InvokeDynamicSupport.bootstrapStatic("getSupportedTypes", $$robo$$android_media_MediaCodecList$getSupportedTypes(int ), (int)n);
    }

    static MediaCodecInfo.CodecCapabilities getCodecCapabilities(int n, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("getCodecCapabilities", $$robo$$android_media_MediaCodecList$getCodecCapabilities(int java.lang.String ), (int)n, (String)string2);
    }

    static Map<String, Object> native_getGlobalSettings() {
        return InvokeDynamicSupport.bootstrapStatic("native_getGlobalSettings", $$robo$$android_media_MediaCodecList$native_getGlobalSettings());
    }

    static int findCodecByName(String string2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("findCodecByName", $$robo$$android_media_MediaCodecList$findCodecByName(java.lang.String ), (String)string2);
    }

    public static MediaCodecInfo getInfoFor(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("getInfoFor", $$robo$$android_media_MediaCodecList$getInfoFor(java.lang.String ), (String)string2);
    }

    private static void native_init() {
        InvokeDynamicSupport.bootstrapStatic("native_init", $$robo$$android_media_MediaCodecList$native_init());
    }

    private void __constructor__() {
        this.$$robo$$android_media_MediaCodecList$__constructor__();
    }

    public MediaCodecList() {
        this(0);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaCodecList$__constructor__(), this);
    }

    private void __constructor__(int n) {
        this.$$robo$$android_media_MediaCodecList$__constructor__(n);
    }

    public MediaCodecList(int n) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaCodecList$__constructor__(int ), this, n);
    }

    public MediaCodecInfo[] getCodecInfos() {
        return InvokeDynamicSupport.bootstrap("getCodecInfos", $$robo$$android_media_MediaCodecList$getCodecInfos(), this);
    }

    public String findDecoderForFormat(MediaFormat mediaFormat) {
        return InvokeDynamicSupport.bootstrap("findDecoderForFormat", $$robo$$android_media_MediaCodecList$findDecoderForFormat(android.media.MediaFormat ), this, mediaFormat);
    }

    public String findEncoderForFormat(MediaFormat mediaFormat) {
        return InvokeDynamicSupport.bootstrap("findEncoderForFormat", $$robo$$android_media_MediaCodecList$findEncoderForFormat(android.media.MediaFormat ), this, mediaFormat);
    }

    private String findCodecForFormat(boolean bl, MediaFormat mediaFormat) {
        return InvokeDynamicSupport.bootstrap("findCodecForFormat", $$robo$$android_media_MediaCodecList$findCodecForFormat(boolean android.media.MediaFormat ), this, bl, mediaFormat);
    }

    static {
        RobolectricInternals.classInitializing(MediaCodecList.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MediaCodecList)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

