/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.media.IDescrambler;
import android.media.MediaCas;
import android.media.MediaCasException;
import android.media.MediaCasStateException;
import android.media.MediaCodec;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.ServiceSpecificException;
import android.util.Log;
import com.google.errorprone.annotations.DoNotMock;
import java.nio.ByteBuffer;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class MediaDescrambler
implements AutoCloseable,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "MediaDescrambler";
    private IDescrambler mIDescrambler;
    private long mNativeContext;

    private final void $$robo$$android_media_MediaDescrambler$validateInternalStates() {
        if (this.mIDescrambler == null) {
            throw new IllegalStateException();
        }
    }

    private final void $$robo$$android_media_MediaDescrambler$cleanupAndRethrowIllegalState() {
        this.mIDescrambler = null;
        throw new IllegalStateException();
    }

    private void $$robo$$android_media_MediaDescrambler$__constructor__(int CA_system_id) throws MediaCasException.UnsupportedCasException {
        block5: {
            try {
                this.mIDescrambler = MediaCas.getService().createDescrambler(CA_system_id);
            }
            catch (Exception e) {
                Log.e("MediaDescrambler", "Failed to create descrambler: " + e);
                this.mIDescrambler = null;
            }
            finally {
                if (this.mIDescrambler != null) break block5;
                throw new MediaCasException.UnsupportedCasException("Unsupported CA_system_id " + CA_system_id);
            }
        }
        this.native_setup(this.mIDescrambler.asBinder());
    }

    private final IBinder $$robo$$android_media_MediaDescrambler$getBinder() {
        this.validateInternalStates();
        return this.mIDescrambler.asBinder();
    }

    private final boolean $$robo$$android_media_MediaDescrambler$requiresSecureDecoderComponent(String mime) {
        this.validateInternalStates();
        try {
            return this.mIDescrambler.requiresSecureDecoderComponent(mime);
        }
        catch (RemoteException e) {
            this.cleanupAndRethrowIllegalState();
            return true;
        }
    }

    private final void $$robo$$android_media_MediaDescrambler$setMediaCasSession(MediaCas.Session session) {
        this.validateInternalStates();
        try {
            this.mIDescrambler.setMediaCasSession(session.mSessionId);
        }
        catch (ServiceSpecificException e) {
            MediaCasStateException.throwExceptions(e);
        }
        catch (RemoteException e) {
            this.cleanupAndRethrowIllegalState();
        }
    }

    private final int $$robo$$android_media_MediaDescrambler$descramble(ByteBuffer srcBuf, ByteBuffer dstBuf, MediaCodec.CryptoInfo cryptoInfo) {
        this.validateInternalStates();
        if (cryptoInfo.numSubSamples <= 0) {
            throw new IllegalArgumentException("Invalid CryptoInfo: invalid numSubSamples=" + cryptoInfo.numSubSamples);
        }
        if (cryptoInfo.numBytesOfClearData == null && cryptoInfo.numBytesOfEncryptedData == null) {
            throw new IllegalArgumentException("Invalid CryptoInfo: clearData and encryptedData size arrays are both null!");
        }
        if (cryptoInfo.numBytesOfClearData != null && cryptoInfo.numBytesOfClearData.length < cryptoInfo.numSubSamples) {
            throw new IllegalArgumentException("Invalid CryptoInfo: numBytesOfClearData is too small!");
        }
        if (cryptoInfo.numBytesOfEncryptedData != null && cryptoInfo.numBytesOfEncryptedData.length < cryptoInfo.numSubSamples) {
            throw new IllegalArgumentException("Invalid CryptoInfo: numBytesOfEncryptedData is too small!");
        }
        if (cryptoInfo.key == null || cryptoInfo.key.length != 16) {
            throw new IllegalArgumentException("Invalid CryptoInfo: key array is invalid!");
        }
        try {
            return this.native_descramble(cryptoInfo.key[0], cryptoInfo.numSubSamples, cryptoInfo.numBytesOfClearData, cryptoInfo.numBytesOfEncryptedData, srcBuf, srcBuf.position(), srcBuf.limit(), dstBuf, dstBuf.position(), dstBuf.limit());
        }
        catch (ServiceSpecificException e) {
            MediaCasStateException.throwExceptions(e);
            return -1;
        }
    }

    private final void $$robo$$android_media_MediaDescrambler$close() {
        if (this.mIDescrambler != null) {
            try {
                this.mIDescrambler.release();
            }
            catch (RemoteException remoteException) {
            }
            finally {
                this.mIDescrambler = null;
            }
        }
        this.native_release();
    }

    private final void $$robo$$android_media_MediaDescrambler$finalize() {
        this.close();
    }

    private static final void $$robo$$android_media_MediaDescrambler$native_init() {
    }

    private final void $$robo$$android_media_MediaDescrambler$native_setup(IBinder iBinder) {
    }

    private final void $$robo$$android_media_MediaDescrambler$native_release() {
    }

    private final int $$robo$$android_media_MediaDescrambler$native_descramble(byte by, int n, int[] nArray, int[] nArray2, ByteBuffer byteBuffer, int n2, int n3, ByteBuffer byteBuffer2, int n4, int n5) {
        return 0;
    }

    static void __staticInitializer__() {
        InvokeDynamicSupport.bootstrapIntrinsic("loadLibrary", "java.lang.System", (String)"media_jni");
        MediaDescrambler.native_init();
    }

    private void validateInternalStates() {
        InvokeDynamicSupport.bootstrap("validateInternalStates", $$robo$$android_media_MediaDescrambler$validateInternalStates(), this);
    }

    private void cleanupAndRethrowIllegalState() {
        InvokeDynamicSupport.bootstrap("cleanupAndRethrowIllegalState", $$robo$$android_media_MediaDescrambler$cleanupAndRethrowIllegalState(), this);
    }

    private void __constructor__(int n) throws MediaCasException.UnsupportedCasException {
        this.$$robo$$android_media_MediaDescrambler$__constructor__(n);
    }

    public MediaDescrambler(int n) throws MediaCasException.UnsupportedCasException {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaDescrambler$__constructor__(int ), this, n);
    }

    IBinder getBinder() {
        return InvokeDynamicSupport.bootstrap("getBinder", $$robo$$android_media_MediaDescrambler$getBinder(), this);
    }

    public boolean requiresSecureDecoderComponent(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("requiresSecureDecoderComponent", $$robo$$android_media_MediaDescrambler$requiresSecureDecoderComponent(java.lang.String ), this, string2);
    }

    public void setMediaCasSession(MediaCas.Session session) {
        InvokeDynamicSupport.bootstrap("setMediaCasSession", $$robo$$android_media_MediaDescrambler$setMediaCasSession(android.media.MediaCas$Session ), this, session);
    }

    public int descramble(ByteBuffer byteBuffer, ByteBuffer byteBuffer2, MediaCodec.CryptoInfo cryptoInfo) {
        return (int)InvokeDynamicSupport.bootstrap("descramble", $$robo$$android_media_MediaDescrambler$descramble(java.nio.ByteBuffer java.nio.ByteBuffer android.media.MediaCodec$CryptoInfo ), this, byteBuffer, byteBuffer2, cryptoInfo);
    }

    @Override
    public void close() {
        InvokeDynamicSupport.bootstrap("close", $$robo$$android_media_MediaDescrambler$close(), this);
    }

    protected void finalize() {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_media_MediaDescrambler$finalize(), this);
    }

    private static void native_init() {
        InvokeDynamicSupport.bootstrapStatic("native_init", $$robo$$android_media_MediaDescrambler$native_init());
    }

    private void native_setup(IBinder iBinder) {
        InvokeDynamicSupport.bootstrap("native_setup", $$robo$$android_media_MediaDescrambler$native_setup(android.os.IBinder ), this, iBinder);
    }

    private void native_release() {
        InvokeDynamicSupport.bootstrap("native_release", $$robo$$android_media_MediaDescrambler$native_release(), this);
    }

    private int native_descramble(byte by, int n, int[] nArray, int[] nArray2, ByteBuffer byteBuffer, int n2, int n3, ByteBuffer byteBuffer2, int n4, int n5) {
        return (int)InvokeDynamicSupport.bootstrap("native_descramble", $$robo$$android_media_MediaDescrambler$native_descramble(byte int int[] int[] java.nio.ByteBuffer int int java.nio.ByteBuffer int int ), this, by, n, nArray, nArray2, byteBuffer, n2, n3, byteBuffer2, n4, n5);
    }

    static {
        RobolectricInternals.classInitializing(MediaDescrambler.class);
    }

    public /* synthetic */ MediaDescrambler() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MediaDescrambler)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class DescrambleInfo
    implements Parcelable,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public static Parcelable.Creator<DescrambleInfo> CREATOR;

        private void $$robo$$android_media_MediaDescrambler_DescrambleInfo$__constructor__() {
        }

        private void $$robo$$android_media_MediaDescrambler_DescrambleInfo$__constructor__(Parcel in) {
        }

        private final int $$robo$$android_media_MediaDescrambler_DescrambleInfo$describeContents() {
            return 0;
        }

        private final void $$robo$$android_media_MediaDescrambler_DescrambleInfo$writeToParcel(Parcel dest, int flags) {
        }

        private /* synthetic */ void $$robo$$android_media_MediaDescrambler_DescrambleInfo$__constructor__(Parcel x0, 1 x1) {
        }

        static void __staticInitializer__() {
            CREATOR = new Parcelable.Creator<DescrambleInfo>(){
                public /* synthetic */ Object __robo_data__;

                private void $$robo$$android_media_MediaDescrambler_DescrambleInfo_1$__constructor__() {
                }

                private final DescrambleInfo $$robo$$android_media_MediaDescrambler_DescrambleInfo_1$createFromParcel(Parcel in) {
                    return new DescrambleInfo(in, null);
                }

                private final DescrambleInfo[] $$robo$$android_media_MediaDescrambler_DescrambleInfo_1$newArray(int size) {
                    return new DescrambleInfo[size];
                }

                private void __constructor__() {
                    this.$$robo$$android_media_MediaDescrambler_DescrambleInfo_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaDescrambler_DescrambleInfo_1$__constructor__(), this);
                }

                @Override
                public DescrambleInfo createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_media_MediaDescrambler_DescrambleInfo_1$createFromParcel(android.os.Parcel ), this, parcel);
                }

                public DescrambleInfo[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_media_MediaDescrambler_DescrambleInfo_1$newArray(int ), this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private void __constructor__() {
            this.$$robo$$android_media_MediaDescrambler_DescrambleInfo$__constructor__();
        }

        public DescrambleInfo() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaDescrambler_DescrambleInfo$__constructor__(), this);
        }

        private void __constructor__(Parcel parcel) {
            this.$$robo$$android_media_MediaDescrambler_DescrambleInfo$__constructor__(parcel);
        }

        public DescrambleInfo(Parcel parcel) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaDescrambler_DescrambleInfo$__constructor__(android.os.Parcel ), this, parcel);
        }

        @Override
        public int describeContents() {
            return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_media_MediaDescrambler_DescrambleInfo$describeContents(), this);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_media_MediaDescrambler_DescrambleInfo$writeToParcel(android.os.Parcel int ), this, parcel, n);
        }

        private /* synthetic */ void __constructor__(Parcel parcel, 1 var2_2) {
            this.$$robo$$android_media_MediaDescrambler_DescrambleInfo$__constructor__(parcel, var2_2);
        }

        public /* synthetic */ DescrambleInfo(Parcel parcel, 1 var2_2) {
            this(parcel);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaDescrambler_DescrambleInfo$__constructor__(android.os.Parcel android.media.MediaDescrambler$1 ), this, parcel, var2_2);
        }

        static {
            RobolectricInternals.classInitializing(DescrambleInfo.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DescrambleInfo)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

