/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.media.AudioTrack;
import android.media.MediaTimestamp;
import android.media.PlaybackParams;
import android.media.SyncParams;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import android.view.Surface;
import com.google.errorprone.annotations.DoNotMock;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class MediaSync
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    public static int MEDIASYNC_ERROR_AUDIOTRACK_FAIL = 1;
    public static int MEDIASYNC_ERROR_SURFACE_FAIL = 2;
    private static String TAG = "MediaSync";
    private static int EVENT_CALLBACK = 1;
    private static int EVENT_SET_CALLBACK = 2;
    private static int CB_RETURN_AUDIO_BUFFER = 1;
    private Object mCallbackLock;
    private Handler mCallbackHandler;
    private Callback mCallback;
    private Object mOnErrorListenerLock;
    private Handler mOnErrorListenerHandler;
    private OnErrorListener mOnErrorListener;
    private Thread mAudioThread;
    private Handler mAudioHandler;
    private Looper mAudioLooper;
    private Object mAudioLock;
    private AudioTrack mAudioTrack;
    private List<AudioBuffer> mAudioBuffers;
    private float mPlaybackRate;
    private long mNativeContext;

    private void $$robo$$android_media_MediaSync$__constructor__() {
        this.mCallbackLock = new Object();
        this.mCallbackHandler = null;
        this.mCallback = null;
        this.mOnErrorListenerLock = new Object();
        this.mOnErrorListenerHandler = null;
        this.mOnErrorListener = null;
        this.mAudioThread = null;
        this.mAudioHandler = null;
        this.mAudioLooper = null;
        this.mAudioLock = new Object();
        this.mAudioTrack = null;
        this.mAudioBuffers = new LinkedList<AudioBuffer>();
        this.mPlaybackRate = 0.0f;
        this.native_setup();
    }

    private final void $$robo$$android_media_MediaSync$native_setup() {
    }

    private final void $$robo$$android_media_MediaSync$finalize() {
        this.native_finalize();
    }

    private final void $$robo$$android_media_MediaSync$native_finalize() {
    }

    private final void $$robo$$android_media_MediaSync$release() {
        this.returnAudioBuffers();
        if (this.mAudioThread != null && this.mAudioLooper != null) {
            this.mAudioLooper.quit();
        }
        this.setCallback(null, null);
        this.native_release();
    }

    private final void $$robo$$android_media_MediaSync$native_release() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_MediaSync$setCallback(Callback cb, Handler handler) {
        Object object = this.mCallbackLock;
        synchronized (object) {
            if (handler != null) {
                this.mCallbackHandler = handler;
            } else {
                Looper looper = Looper.myLooper();
                if (looper == null) {
                    looper = Looper.getMainLooper();
                }
                this.mCallbackHandler = looper == null ? null : new Handler(looper);
            }
            this.mCallback = cb;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_MediaSync$setOnErrorListener(OnErrorListener listener, Handler handler) {
        Object object = this.mOnErrorListenerLock;
        synchronized (object) {
            if (handler != null) {
                this.mOnErrorListenerHandler = handler;
            } else {
                Looper looper = Looper.myLooper();
                if (looper == null) {
                    looper = Looper.getMainLooper();
                }
                this.mOnErrorListenerHandler = looper == null ? null : new Handler(looper);
            }
            this.mOnErrorListener = listener;
        }
    }

    private final void $$robo$$android_media_MediaSync$setSurface(Surface surface) {
        this.native_setSurface(surface);
    }

    private final void $$robo$$android_media_MediaSync$native_setSurface(Surface surface) {
    }

    private final void $$robo$$android_media_MediaSync$setAudioTrack(AudioTrack audioTrack) {
        this.native_setAudioTrack(audioTrack);
        this.mAudioTrack = audioTrack;
        if (audioTrack != null && this.mAudioThread == null) {
            this.createAudioThread();
        }
    }

    private final void $$robo$$android_media_MediaSync$native_setAudioTrack(AudioTrack audioTrack) {
    }

    private final Surface $$robo$$android_media_MediaSync$createInputSurface() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_MediaSync$setPlaybackParams(PlaybackParams params) {
        Object object = this.mAudioLock;
        synchronized (object) {
            this.mPlaybackRate = this.native_setPlaybackParams(params);
        }
        if ((double)this.mPlaybackRate != 0.0 && this.mAudioThread != null) {
            this.postRenderAudio(0L);
        }
    }

    private final PlaybackParams $$robo$$android_media_MediaSync$getPlaybackParams() {
        return null;
    }

    private final float $$robo$$android_media_MediaSync$native_setPlaybackParams(PlaybackParams playbackParams) {
        return 0.0f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_MediaSync$setSyncParams(SyncParams params) {
        Object object = this.mAudioLock;
        synchronized (object) {
            this.mPlaybackRate = this.native_setSyncParams(params);
        }
        if ((double)this.mPlaybackRate != 0.0 && this.mAudioThread != null) {
            this.postRenderAudio(0L);
        }
    }

    private final float $$robo$$android_media_MediaSync$native_setSyncParams(SyncParams syncParams) {
        return 0.0f;
    }

    private final SyncParams $$robo$$android_media_MediaSync$getSyncParams() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_MediaSync$flush() {
        Object object = this.mAudioLock;
        synchronized (object) {
            this.mAudioBuffers.clear();
            this.mCallbackHandler.removeCallbacksAndMessages(null);
        }
        if (this.mAudioTrack != null) {
            this.mAudioTrack.pause();
            this.mAudioTrack.flush();
            this.mAudioTrack.stop();
        }
        this.native_flush();
    }

    private final void $$robo$$android_media_MediaSync$native_flush() {
    }

    private final MediaTimestamp $$robo$$android_media_MediaSync$getTimestamp() {
        try {
            MediaTimestamp timestamp = new MediaTimestamp();
            if (this.native_getTimestamp(timestamp)) {
                return timestamp;
            }
            return null;
        }
        catch (IllegalStateException e) {
            return null;
        }
    }

    private final boolean $$robo$$android_media_MediaSync$native_getTimestamp(MediaTimestamp mediaTimestamp) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_MediaSync$queueAudio(ByteBuffer audioData, int bufferId, long presentationTimeUs) {
        if (this.mAudioTrack == null || this.mAudioThread == null) {
            throw new IllegalStateException("AudioTrack is NOT set or audio thread is not created");
        }
        Object object = this.mAudioLock;
        synchronized (object) {
            this.mAudioBuffers.add(new AudioBuffer(audioData, bufferId, presentationTimeUs));
        }
        if ((double)this.mPlaybackRate != 0.0) {
            this.postRenderAudio(0L);
        }
    }

    private final void $$robo$$android_media_MediaSync$postRenderAudio(long delayMillis) {
        this.mAudioHandler.postDelayed(new Runnable(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ MediaSync this$0;

            private void $$robo$$android_media_MediaSync_1$__constructor__(MediaSync this$0) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_media_MediaSync_1$run() {
                Object object = this.this$0.mAudioLock;
                synchronized (object) {
                    int sizeWritten;
                    if ((double)this.this$0.mPlaybackRate == 0.0) {
                        return;
                    }
                    if (this.this$0.mAudioBuffers.isEmpty()) {
                        return;
                    }
                    AudioBuffer audioBuffer = (AudioBuffer)this.this$0.mAudioBuffers.get(0);
                    int size = audioBuffer.mByteBuffer.remaining();
                    if (size > 0 && this.this$0.mAudioTrack.getPlayState() != 3) {
                        try {
                            this.this$0.mAudioTrack.play();
                        }
                        catch (IllegalStateException e) {
                            Log.w("MediaSync", "could not start audio track");
                        }
                    }
                    if ((sizeWritten = this.this$0.mAudioTrack.write(audioBuffer.mByteBuffer, size, 1)) > 0) {
                        if (audioBuffer.mPresentationTimeUs != -1L) {
                            this.this$0.native_updateQueuedAudioData(size, audioBuffer.mPresentationTimeUs);
                            audioBuffer.mPresentationTimeUs = -1L;
                        }
                        if (sizeWritten == size) {
                            this.this$0.postReturnByteBuffer(audioBuffer);
                            this.this$0.mAudioBuffers.remove(0);
                            if (!this.this$0.mAudioBuffers.isEmpty()) {
                                this.this$0.postRenderAudio(0L);
                            }
                            return;
                        }
                    }
                    long pendingTimeMs = TimeUnit.MICROSECONDS.toMillis(this.this$0.native_getPlayTimeForPendingAudioFrames());
                    this.this$0.postRenderAudio(pendingTimeMs / 2L);
                }
            }

            private void __constructor__(MediaSync mediaSync) {
                this.$$robo$$android_media_MediaSync_1$__constructor__(mediaSync);
            }
            {
                this.this$0 = mediaSync;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaSync_1$__constructor__(android.media.MediaSync ), this, mediaSync);
            }

            @Override
            public void run() {
                InvokeDynamicSupport.bootstrap("run", $$robo$$android_media_MediaSync_1$run(), this);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }, delayMillis);
    }

    private final void $$robo$$android_media_MediaSync$native_updateQueuedAudioData(int n, long l) {
    }

    private final long $$robo$$android_media_MediaSync$native_getPlayTimeForPendingAudioFrames() {
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_MediaSync$postReturnByteBuffer(AudioBuffer audioBuffer) {
        Object object = this.mCallbackLock;
        synchronized (object) {
            if (this.mCallbackHandler != null) {
                MediaSync sync = this;
                this.mCallbackHandler.post(new Runnable(this, sync, audioBuffer){
                    public /* synthetic */ Object __robo_data__;
                    /* synthetic */ MediaSync val$sync;
                    /* synthetic */ AudioBuffer val$audioBuffer;
                    /* synthetic */ MediaSync this$0;

                    private void $$robo$$android_media_MediaSync_2$__constructor__(MediaSync this$0, MediaSync mediaSync, AudioBuffer audioBuffer) {
                        this.val$sync = mediaSync;
                        this.val$audioBuffer = audioBuffer;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    private final void $$robo$$android_media_MediaSync_2$run() {
                        Callback callback;
                        Object object = this.this$0.mCallbackLock;
                        synchronized (object) {
                            callback = this.this$0.mCallback;
                            if (this.this$0.mCallbackHandler == null || this.this$0.mCallbackHandler.getLooper().getThread() != Thread.currentThread()) {
                                return;
                            }
                        }
                        if (callback != null) {
                            callback.onAudioBufferConsumed(this.val$sync, this.val$audioBuffer.mByteBuffer, this.val$audioBuffer.mBufferIndex);
                        }
                    }

                    private void __constructor__(MediaSync mediaSync, MediaSync mediaSync2, AudioBuffer audioBuffer) {
                        this.$$robo$$android_media_MediaSync_2$__constructor__(mediaSync, mediaSync2, audioBuffer);
                    }
                    {
                        this.this$0 = mediaSync;
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaSync_2$__constructor__(android.media.MediaSync android.media.MediaSync android.media.MediaSync$AudioBuffer ), this, mediaSync, mediaSync2, audioBuffer);
                    }

                    @Override
                    public void run() {
                        InvokeDynamicSupport.bootstrap("run", $$robo$$android_media_MediaSync_2$run(), this);
                    }
                    {
                        this.$$robo$init();
                    }

                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_MediaSync$returnAudioBuffers() {
        Object object = this.mAudioLock;
        synchronized (object) {
            for (AudioBuffer audioBuffer : this.mAudioBuffers) {
                this.postReturnByteBuffer(audioBuffer);
            }
            this.mAudioBuffers.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_MediaSync$createAudioThread() {
        this.mAudioThread = new ShadowedObject(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ MediaSync this$0;

            private void $$robo$$android_media_MediaSync_3$__constructor__(MediaSync this$0) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_media_MediaSync_3$run() {
                Looper.prepare();
                Object object = this.this$0.mAudioLock;
                synchronized (object) {
                    this.this$0.mAudioLooper = Looper.myLooper();
                    this.this$0.mAudioHandler = new Handler();
                    this.this$0.mAudioLock.notify();
                }
                Looper.loop();
            }

            private void __constructor__(MediaSync mediaSync) {
                this.$$robo$$android_media_MediaSync_3$__constructor__(mediaSync);
            }
            {
                this.this$0 = mediaSync;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaSync_3$__constructor__(android.media.MediaSync ), this, mediaSync);
            }

            @Override
            public void run() {
                InvokeDynamicSupport.bootstrap("run", $$robo$$android_media_MediaSync_3$run(), this);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mAudioThread.start();
        Object object = this.mAudioLock;
        synchronized (object) {
            try {
                this.mAudioLock.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private static final void $$robo$$android_media_MediaSync$native_init() {
    }

    static void __staticInitializer__() {
        InvokeDynamicSupport.bootstrapIntrinsic("loadLibrary", "java.lang.System", (String)"media_jni");
        MediaSync.native_init();
    }

    private void __constructor__() {
        this.$$robo$$android_media_MediaSync$__constructor__();
    }

    public MediaSync() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaSync$__constructor__(), this);
    }

    private void native_setup() {
        InvokeDynamicSupport.bootstrap("native_setup", $$robo$$android_media_MediaSync$native_setup(), this);
    }

    protected void finalize() {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_media_MediaSync$finalize(), this);
    }

    private void native_finalize() {
        InvokeDynamicSupport.bootstrap("native_finalize", $$robo$$android_media_MediaSync$native_finalize(), this);
    }

    public void release() {
        InvokeDynamicSupport.bootstrap("release", $$robo$$android_media_MediaSync$release(), this);
    }

    private void native_release() {
        InvokeDynamicSupport.bootstrap("native_release", $$robo$$android_media_MediaSync$native_release(), this);
    }

    public void setCallback(Callback callback, Handler handler) {
        InvokeDynamicSupport.bootstrap("setCallback", $$robo$$android_media_MediaSync$setCallback(android.media.MediaSync$Callback android.os.Handler ), this, callback, handler);
    }

    public void setOnErrorListener(OnErrorListener onErrorListener, Handler handler) {
        InvokeDynamicSupport.bootstrap("setOnErrorListener", $$robo$$android_media_MediaSync$setOnErrorListener(android.media.MediaSync$OnErrorListener android.os.Handler ), this, onErrorListener, handler);
    }

    public void setSurface(Surface surface) {
        InvokeDynamicSupport.bootstrap("setSurface", $$robo$$android_media_MediaSync$setSurface(android.view.Surface ), this, surface);
    }

    private void native_setSurface(Surface surface) {
        InvokeDynamicSupport.bootstrap("native_setSurface", $$robo$$android_media_MediaSync$native_setSurface(android.view.Surface ), this, surface);
    }

    public void setAudioTrack(AudioTrack audioTrack) {
        InvokeDynamicSupport.bootstrap("setAudioTrack", $$robo$$android_media_MediaSync$setAudioTrack(android.media.AudioTrack ), this, audioTrack);
    }

    private void native_setAudioTrack(AudioTrack audioTrack) {
        InvokeDynamicSupport.bootstrap("native_setAudioTrack", $$robo$$android_media_MediaSync$native_setAudioTrack(android.media.AudioTrack ), this, audioTrack);
    }

    public Surface createInputSurface() {
        return InvokeDynamicSupport.bootstrap("createInputSurface", $$robo$$android_media_MediaSync$createInputSurface(), this);
    }

    public void setPlaybackParams(PlaybackParams playbackParams) {
        InvokeDynamicSupport.bootstrap("setPlaybackParams", $$robo$$android_media_MediaSync$setPlaybackParams(android.media.PlaybackParams ), this, playbackParams);
    }

    public PlaybackParams getPlaybackParams() {
        return InvokeDynamicSupport.bootstrap("getPlaybackParams", $$robo$$android_media_MediaSync$getPlaybackParams(), this);
    }

    private float native_setPlaybackParams(PlaybackParams playbackParams) {
        return (float)InvokeDynamicSupport.bootstrap("native_setPlaybackParams", $$robo$$android_media_MediaSync$native_setPlaybackParams(android.media.PlaybackParams ), this, playbackParams);
    }

    public void setSyncParams(SyncParams syncParams) {
        InvokeDynamicSupport.bootstrap("setSyncParams", $$robo$$android_media_MediaSync$setSyncParams(android.media.SyncParams ), this, syncParams);
    }

    private float native_setSyncParams(SyncParams syncParams) {
        return (float)InvokeDynamicSupport.bootstrap("native_setSyncParams", $$robo$$android_media_MediaSync$native_setSyncParams(android.media.SyncParams ), this, syncParams);
    }

    public SyncParams getSyncParams() {
        return InvokeDynamicSupport.bootstrap("getSyncParams", $$robo$$android_media_MediaSync$getSyncParams(), this);
    }

    public void flush() {
        InvokeDynamicSupport.bootstrap("flush", $$robo$$android_media_MediaSync$flush(), this);
    }

    private void native_flush() {
        InvokeDynamicSupport.bootstrap("native_flush", $$robo$$android_media_MediaSync$native_flush(), this);
    }

    public MediaTimestamp getTimestamp() {
        return InvokeDynamicSupport.bootstrap("getTimestamp", $$robo$$android_media_MediaSync$getTimestamp(), this);
    }

    private boolean native_getTimestamp(MediaTimestamp mediaTimestamp) {
        return (boolean)InvokeDynamicSupport.bootstrap("native_getTimestamp", $$robo$$android_media_MediaSync$native_getTimestamp(android.media.MediaTimestamp ), this, mediaTimestamp);
    }

    public void queueAudio(ByteBuffer byteBuffer, int n, long l) {
        InvokeDynamicSupport.bootstrap("queueAudio", $$robo$$android_media_MediaSync$queueAudio(java.nio.ByteBuffer int long ), this, byteBuffer, n, l);
    }

    private void postRenderAudio(long l) {
        InvokeDynamicSupport.bootstrap("postRenderAudio", $$robo$$android_media_MediaSync$postRenderAudio(long ), this, l);
    }

    private void native_updateQueuedAudioData(int n, long l) {
        InvokeDynamicSupport.bootstrap("native_updateQueuedAudioData", $$robo$$android_media_MediaSync$native_updateQueuedAudioData(int long ), this, n, l);
    }

    private long native_getPlayTimeForPendingAudioFrames() {
        return (long)InvokeDynamicSupport.bootstrap("native_getPlayTimeForPendingAudioFrames", $$robo$$android_media_MediaSync$native_getPlayTimeForPendingAudioFrames(), this);
    }

    private void postReturnByteBuffer(AudioBuffer audioBuffer) {
        InvokeDynamicSupport.bootstrap("postReturnByteBuffer", $$robo$$android_media_MediaSync$postReturnByteBuffer(android.media.MediaSync$AudioBuffer ), this, audioBuffer);
    }

    private void returnAudioBuffers() {
        InvokeDynamicSupport.bootstrap("returnAudioBuffers", $$robo$$android_media_MediaSync$returnAudioBuffers(), this);
    }

    private void createAudioThread() {
        InvokeDynamicSupport.bootstrap("createAudioThread", $$robo$$android_media_MediaSync$createAudioThread(), this);
    }

    private static void native_init() {
        InvokeDynamicSupport.bootstrapStatic("native_init", $$robo$$android_media_MediaSync$native_init());
    }

    static {
        RobolectricInternals.classInitializing(MediaSync.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MediaSync)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class AudioBuffer
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public ByteBuffer mByteBuffer;
        public int mBufferIndex;
        long mPresentationTimeUs;

        private void $$robo$$android_media_MediaSync_AudioBuffer$__constructor__(ByteBuffer byteBuffer, int bufferId, long presentationTimeUs) {
            this.mByteBuffer = byteBuffer;
            this.mBufferIndex = bufferId;
            this.mPresentationTimeUs = presentationTimeUs;
        }

        private void __constructor__(ByteBuffer byteBuffer, int n, long l) {
            this.$$robo$$android_media_MediaSync_AudioBuffer$__constructor__(byteBuffer, n, l);
        }

        public AudioBuffer(ByteBuffer byteBuffer, int n, long l) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaSync_AudioBuffer$__constructor__(java.nio.ByteBuffer int long ), this, byteBuffer, n, l);
        }

        public /* synthetic */ AudioBuffer() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AudioBuffer)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface OnErrorListener
    extends InstrumentedInterface {
        public void onError(MediaSync var1, int var2, int var3);
    }

    public static abstract class Callback
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;

        private void $$robo$$android_media_MediaSync_Callback$__constructor__() {
        }

        public abstract void onAudioBufferConsumed(MediaSync var1, ByteBuffer var2, int var3);

        private void __constructor__() {
            this.$$robo$$android_media_MediaSync_Callback$__constructor__();
        }

        public Callback() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaSync_Callback$__constructor__(), this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Callback)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

