/*
 * Decompiled with CFR 0.152.
 */
package android.media.audiofx;

import android.app.ActivityThread;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import com.google.errorprone.annotations.DoNotMock;
import java.lang.ref.WeakReference;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class Visualizer
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "Visualizer-JAVA";
    public static int STATE_UNINITIALIZED = 0;
    public static int STATE_INITIALIZED = 1;
    public static int STATE_ENABLED = 2;
    public static int SCALING_MODE_NORMALIZED = 0;
    public static int SCALING_MODE_AS_PLAYED = 1;
    public static int MEASUREMENT_MODE_NONE = 0;
    public static int MEASUREMENT_MODE_PEAK_RMS = 1;
    private static int NATIVE_EVENT_PCM_CAPTURE = 0;
    private static int NATIVE_EVENT_FFT_CAPTURE = 1;
    private static int NATIVE_EVENT_SERVER_DIED = 2;
    public static int SUCCESS = 0;
    public static int ERROR = -1;
    public static int ALREADY_EXISTS = -2;
    public static int ERROR_NO_INIT = -3;
    public static int ERROR_BAD_VALUE = -4;
    public static int ERROR_INVALID_OPERATION = -5;
    public static int ERROR_NO_MEMORY = -6;
    public static int ERROR_DEAD_OBJECT = -7;
    private int mState;
    private Object mStateLock;
    private int mId;
    private Object mListenerLock;
    private NativeEventHandler mNativeEventHandler;
    private OnDataCaptureListener mCaptureListener;
    private OnServerDiedListener mServerDiedListener;
    private long mNativeVisualizer;
    private long mJniData;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void $$robo$$android_media_audiofx_Visualizer$__constructor__(int audioSession) throws UnsupportedOperationException, RuntimeException {
        this.mState = 0;
        this.mStateLock = new Object();
        this.mListenerLock = new Object();
        this.mNativeEventHandler = null;
        this.mCaptureListener = null;
        this.mServerDiedListener = null;
        int[] id2 = new int[1];
        Object object = this.mStateLock;
        synchronized (object) {
            this.mState = 0;
            int result = this.native_setup(new WeakReference<Visualizer>(this), audioSession, id2, ActivityThread.currentOpPackageName());
            if (result != 0 && result != -2) {
                Log.e("Visualizer-JAVA", "Error code " + result + " when initializing Visualizer.");
                switch (result) {
                    case -5: {
                        throw new UnsupportedOperationException("Effect library not loaded");
                    }
                }
                throw new RuntimeException("Cannot initialize Visualizer engine, error: " + result);
            }
            this.mId = id2[0];
            this.mState = this.native_getEnabled() ? 2 : 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_audiofx_Visualizer$release() {
        Object object = this.mStateLock;
        synchronized (object) {
            this.native_release();
            this.mState = 0;
        }
    }

    private final void $$robo$$android_media_audiofx_Visualizer$finalize() {
        this.native_finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_media_audiofx_Visualizer$setEnabled(boolean enabled) throws IllegalStateException {
        Object object = this.mStateLock;
        synchronized (object) {
            if (this.mState == 0) {
                throw new IllegalStateException("setEnabled() called in wrong state: " + this.mState);
            }
            int status = 0;
            if ((enabled && this.mState == 1 || !enabled && this.mState == 2) && (status = this.native_setEnabled(enabled)) == 0) {
                this.mState = enabled ? 2 : 1;
            }
            return status;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_media_audiofx_Visualizer$getEnabled() {
        Object object = this.mStateLock;
        synchronized (object) {
            if (this.mState == 0) {
                throw new IllegalStateException("getEnabled() called in wrong state: " + this.mState);
            }
            return this.native_getEnabled();
        }
    }

    private static final int[] $$robo$$android_media_audiofx_Visualizer$getCaptureSizeRange() {
        return null;
    }

    private static final int $$robo$$android_media_audiofx_Visualizer$getMaxCaptureRate() {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_media_audiofx_Visualizer$setCaptureSize(int size) throws IllegalStateException {
        Object object = this.mStateLock;
        synchronized (object) {
            if (this.mState != 1) {
                throw new IllegalStateException("setCaptureSize() called in wrong state: " + this.mState);
            }
            return this.native_setCaptureSize(size);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_media_audiofx_Visualizer$getCaptureSize() throws IllegalStateException {
        Object object = this.mStateLock;
        synchronized (object) {
            if (this.mState == 0) {
                throw new IllegalStateException("getCaptureSize() called in wrong state: " + this.mState);
            }
            return this.native_getCaptureSize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_media_audiofx_Visualizer$setScalingMode(int mode) throws IllegalStateException {
        Object object = this.mStateLock;
        synchronized (object) {
            if (this.mState == 0) {
                throw new IllegalStateException("setScalingMode() called in wrong state: " + this.mState);
            }
            return this.native_setScalingMode(mode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_media_audiofx_Visualizer$getScalingMode() throws IllegalStateException {
        Object object = this.mStateLock;
        synchronized (object) {
            if (this.mState == 0) {
                throw new IllegalStateException("getScalingMode() called in wrong state: " + this.mState);
            }
            return this.native_getScalingMode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_media_audiofx_Visualizer$setMeasurementMode(int mode) throws IllegalStateException {
        Object object = this.mStateLock;
        synchronized (object) {
            if (this.mState == 0) {
                throw new IllegalStateException("setMeasurementMode() called in wrong state: " + this.mState);
            }
            return this.native_setMeasurementMode(mode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_media_audiofx_Visualizer$getMeasurementMode() throws IllegalStateException {
        Object object = this.mStateLock;
        synchronized (object) {
            if (this.mState == 0) {
                throw new IllegalStateException("getMeasurementMode() called in wrong state: " + this.mState);
            }
            return this.native_getMeasurementMode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_media_audiofx_Visualizer$getSamplingRate() throws IllegalStateException {
        Object object = this.mStateLock;
        synchronized (object) {
            if (this.mState == 0) {
                throw new IllegalStateException("getSamplingRate() called in wrong state: " + this.mState);
            }
            return this.native_getSamplingRate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_media_audiofx_Visualizer$getWaveForm(byte[] waveform) throws IllegalStateException {
        Object object = this.mStateLock;
        synchronized (object) {
            if (this.mState != 2) {
                throw new IllegalStateException("getWaveForm() called in wrong state: " + this.mState);
            }
            return this.native_getWaveForm(waveform);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_media_audiofx_Visualizer$getFft(byte[] fft) throws IllegalStateException {
        Object object = this.mStateLock;
        synchronized (object) {
            if (this.mState != 2) {
                throw new IllegalStateException("getFft() called in wrong state: " + this.mState);
            }
            return this.native_getFft(fft);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_media_audiofx_Visualizer$getMeasurementPeakRms(MeasurementPeakRms measurement) {
        if (measurement == null) {
            Log.e("Visualizer-JAVA", "Cannot store measurements in a null object");
            return -4;
        }
        Object object = this.mStateLock;
        synchronized (object) {
            if (this.mState != 2) {
                throw new IllegalStateException("getMeasurementPeakRms() called in wrong state: " + this.mState);
            }
            return this.native_getPeakRms(measurement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_media_audiofx_Visualizer$setDataCaptureListener(OnDataCaptureListener listener, int rate, boolean waveform, boolean fft) {
        int status;
        Object object = this.mListenerLock;
        synchronized (object) {
            this.mCaptureListener = listener;
        }
        if (listener == null) {
            waveform = false;
            fft = false;
        }
        if ((status = this.native_setPeriodicCapture(rate, waveform, fft)) == 0 && listener != null && this.mNativeEventHandler == null) {
            Looper looper = Looper.myLooper();
            if (looper != null) {
                this.mNativeEventHandler = new NativeEventHandler(this, this, looper);
            } else {
                looper = Looper.getMainLooper();
                if (looper != null) {
                    this.mNativeEventHandler = new NativeEventHandler(this, this, looper);
                } else {
                    this.mNativeEventHandler = null;
                    status = -3;
                }
            }
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_media_audiofx_Visualizer$setServerDiedListener(OnServerDiedListener listener) {
        Object object = this.mListenerLock;
        synchronized (object) {
            this.mServerDiedListener = listener;
        }
        return 0;
    }

    private static final void $$robo$$android_media_audiofx_Visualizer$native_init() {
    }

    private final int $$robo$$android_media_audiofx_Visualizer$native_setup(Object object, int n, int[] nArray, String string2) {
        return 0;
    }

    private final void $$robo$$android_media_audiofx_Visualizer$native_finalize() {
    }

    private final void $$robo$$android_media_audiofx_Visualizer$native_release() {
    }

    private final int $$robo$$android_media_audiofx_Visualizer$native_setEnabled(boolean bl) {
        return 0;
    }

    private final boolean $$robo$$android_media_audiofx_Visualizer$native_getEnabled() {
        return false;
    }

    private final int $$robo$$android_media_audiofx_Visualizer$native_setCaptureSize(int n) {
        return 0;
    }

    private final int $$robo$$android_media_audiofx_Visualizer$native_getCaptureSize() {
        return 0;
    }

    private final int $$robo$$android_media_audiofx_Visualizer$native_setScalingMode(int n) {
        return 0;
    }

    private final int $$robo$$android_media_audiofx_Visualizer$native_getScalingMode() {
        return 0;
    }

    private final int $$robo$$android_media_audiofx_Visualizer$native_setMeasurementMode(int n) {
        return 0;
    }

    private final int $$robo$$android_media_audiofx_Visualizer$native_getMeasurementMode() {
        return 0;
    }

    private final int $$robo$$android_media_audiofx_Visualizer$native_getSamplingRate() {
        return 0;
    }

    private final int $$robo$$android_media_audiofx_Visualizer$native_getWaveForm(byte[] byArray) {
        return 0;
    }

    private final int $$robo$$android_media_audiofx_Visualizer$native_getFft(byte[] byArray) {
        return 0;
    }

    private final int $$robo$$android_media_audiofx_Visualizer$native_getPeakRms(MeasurementPeakRms measurementPeakRms) {
        return 0;
    }

    private final int $$robo$$android_media_audiofx_Visualizer$native_setPeriodicCapture(int n, boolean bl, boolean bl2) {
        return 0;
    }

    private static final void $$robo$$android_media_audiofx_Visualizer$postEventFromNative(Object effect_ref, int what, int arg1, int arg2, Object obj) {
        Visualizer visu = (Visualizer)((WeakReference)effect_ref).get();
        if (visu == null) {
            return;
        }
        if (visu.mNativeEventHandler != null) {
            Message m = visu.mNativeEventHandler.obtainMessage(what, arg1, arg2, obj);
            visu.mNativeEventHandler.sendMessage(m);
        }
    }

    static void __staticInitializer__() {
        InvokeDynamicSupport.bootstrapIntrinsic("loadLibrary", "java.lang.System", (String)"audioeffect_jni");
        Visualizer.native_init();
    }

    private void __constructor__(int n) throws UnsupportedOperationException, RuntimeException {
        this.$$robo$$android_media_audiofx_Visualizer$__constructor__(n);
    }

    public Visualizer(int n) throws UnsupportedOperationException, RuntimeException {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_audiofx_Visualizer$__constructor__(int ), this, n);
    }

    public void release() {
        InvokeDynamicSupport.bootstrap("release", $$robo$$android_media_audiofx_Visualizer$release(), this);
    }

    protected void finalize() {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_media_audiofx_Visualizer$finalize(), this);
    }

    public int setEnabled(boolean bl) throws IllegalStateException {
        return (int)InvokeDynamicSupport.bootstrap("setEnabled", $$robo$$android_media_audiofx_Visualizer$setEnabled(boolean ), this, bl);
    }

    public boolean getEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("getEnabled", $$robo$$android_media_audiofx_Visualizer$getEnabled(), this);
    }

    public static int[] getCaptureSizeRange() {
        return InvokeDynamicSupport.bootstrapStatic("getCaptureSizeRange", $$robo$$android_media_audiofx_Visualizer$getCaptureSizeRange());
    }

    public static int getMaxCaptureRate() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getMaxCaptureRate", $$robo$$android_media_audiofx_Visualizer$getMaxCaptureRate());
    }

    public int setCaptureSize(int n) throws IllegalStateException {
        return (int)InvokeDynamicSupport.bootstrap("setCaptureSize", $$robo$$android_media_audiofx_Visualizer$setCaptureSize(int ), this, n);
    }

    public int getCaptureSize() throws IllegalStateException {
        return (int)InvokeDynamicSupport.bootstrap("getCaptureSize", $$robo$$android_media_audiofx_Visualizer$getCaptureSize(), this);
    }

    public int setScalingMode(int n) throws IllegalStateException {
        return (int)InvokeDynamicSupport.bootstrap("setScalingMode", $$robo$$android_media_audiofx_Visualizer$setScalingMode(int ), this, n);
    }

    public int getScalingMode() throws IllegalStateException {
        return (int)InvokeDynamicSupport.bootstrap("getScalingMode", $$robo$$android_media_audiofx_Visualizer$getScalingMode(), this);
    }

    public int setMeasurementMode(int n) throws IllegalStateException {
        return (int)InvokeDynamicSupport.bootstrap("setMeasurementMode", $$robo$$android_media_audiofx_Visualizer$setMeasurementMode(int ), this, n);
    }

    public int getMeasurementMode() throws IllegalStateException {
        return (int)InvokeDynamicSupport.bootstrap("getMeasurementMode", $$robo$$android_media_audiofx_Visualizer$getMeasurementMode(), this);
    }

    public int getSamplingRate() throws IllegalStateException {
        return (int)InvokeDynamicSupport.bootstrap("getSamplingRate", $$robo$$android_media_audiofx_Visualizer$getSamplingRate(), this);
    }

    public int getWaveForm(byte[] byArray) throws IllegalStateException {
        return (int)InvokeDynamicSupport.bootstrap("getWaveForm", $$robo$$android_media_audiofx_Visualizer$getWaveForm(byte[] ), this, byArray);
    }

    public int getFft(byte[] byArray) throws IllegalStateException {
        return (int)InvokeDynamicSupport.bootstrap("getFft", $$robo$$android_media_audiofx_Visualizer$getFft(byte[] ), this, byArray);
    }

    public int getMeasurementPeakRms(MeasurementPeakRms measurementPeakRms) {
        return (int)InvokeDynamicSupport.bootstrap("getMeasurementPeakRms", $$robo$$android_media_audiofx_Visualizer$getMeasurementPeakRms(android.media.audiofx.Visualizer$MeasurementPeakRms ), this, measurementPeakRms);
    }

    public int setDataCaptureListener(OnDataCaptureListener onDataCaptureListener, int n, boolean bl, boolean bl2) {
        return (int)InvokeDynamicSupport.bootstrap("setDataCaptureListener", $$robo$$android_media_audiofx_Visualizer$setDataCaptureListener(android.media.audiofx.Visualizer$OnDataCaptureListener int boolean boolean ), this, onDataCaptureListener, n, bl, bl2);
    }

    public int setServerDiedListener(OnServerDiedListener onServerDiedListener) {
        return (int)InvokeDynamicSupport.bootstrap("setServerDiedListener", $$robo$$android_media_audiofx_Visualizer$setServerDiedListener(android.media.audiofx.Visualizer$OnServerDiedListener ), this, onServerDiedListener);
    }

    private static void native_init() {
        InvokeDynamicSupport.bootstrapStatic("native_init", $$robo$$android_media_audiofx_Visualizer$native_init());
    }

    private int native_setup(Object object, int n, int[] nArray, String string2) {
        return (int)InvokeDynamicSupport.bootstrap("native_setup", $$robo$$android_media_audiofx_Visualizer$native_setup(java.lang.Object int int[] java.lang.String ), this, object, n, nArray, string2);
    }

    private void native_finalize() {
        InvokeDynamicSupport.bootstrap("native_finalize", $$robo$$android_media_audiofx_Visualizer$native_finalize(), this);
    }

    private void native_release() {
        InvokeDynamicSupport.bootstrap("native_release", $$robo$$android_media_audiofx_Visualizer$native_release(), this);
    }

    private int native_setEnabled(boolean bl) {
        return (int)InvokeDynamicSupport.bootstrap("native_setEnabled", $$robo$$android_media_audiofx_Visualizer$native_setEnabled(boolean ), this, bl);
    }

    private boolean native_getEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("native_getEnabled", $$robo$$android_media_audiofx_Visualizer$native_getEnabled(), this);
    }

    private int native_setCaptureSize(int n) {
        return (int)InvokeDynamicSupport.bootstrap("native_setCaptureSize", $$robo$$android_media_audiofx_Visualizer$native_setCaptureSize(int ), this, n);
    }

    private int native_getCaptureSize() {
        return (int)InvokeDynamicSupport.bootstrap("native_getCaptureSize", $$robo$$android_media_audiofx_Visualizer$native_getCaptureSize(), this);
    }

    private int native_setScalingMode(int n) {
        return (int)InvokeDynamicSupport.bootstrap("native_setScalingMode", $$robo$$android_media_audiofx_Visualizer$native_setScalingMode(int ), this, n);
    }

    private int native_getScalingMode() {
        return (int)InvokeDynamicSupport.bootstrap("native_getScalingMode", $$robo$$android_media_audiofx_Visualizer$native_getScalingMode(), this);
    }

    private int native_setMeasurementMode(int n) {
        return (int)InvokeDynamicSupport.bootstrap("native_setMeasurementMode", $$robo$$android_media_audiofx_Visualizer$native_setMeasurementMode(int ), this, n);
    }

    private int native_getMeasurementMode() {
        return (int)InvokeDynamicSupport.bootstrap("native_getMeasurementMode", $$robo$$android_media_audiofx_Visualizer$native_getMeasurementMode(), this);
    }

    private int native_getSamplingRate() {
        return (int)InvokeDynamicSupport.bootstrap("native_getSamplingRate", $$robo$$android_media_audiofx_Visualizer$native_getSamplingRate(), this);
    }

    private int native_getWaveForm(byte[] byArray) {
        return (int)InvokeDynamicSupport.bootstrap("native_getWaveForm", $$robo$$android_media_audiofx_Visualizer$native_getWaveForm(byte[] ), this, byArray);
    }

    private int native_getFft(byte[] byArray) {
        return (int)InvokeDynamicSupport.bootstrap("native_getFft", $$robo$$android_media_audiofx_Visualizer$native_getFft(byte[] ), this, byArray);
    }

    private int native_getPeakRms(MeasurementPeakRms measurementPeakRms) {
        return (int)InvokeDynamicSupport.bootstrap("native_getPeakRms", $$robo$$android_media_audiofx_Visualizer$native_getPeakRms(android.media.audiofx.Visualizer$MeasurementPeakRms ), this, measurementPeakRms);
    }

    private int native_setPeriodicCapture(int n, boolean bl, boolean bl2) {
        return (int)InvokeDynamicSupport.bootstrap("native_setPeriodicCapture", $$robo$$android_media_audiofx_Visualizer$native_setPeriodicCapture(int boolean boolean ), this, n, bl, bl2);
    }

    private static void postEventFromNative(Object object, int n, int n2, int n3, Object object2) {
        InvokeDynamicSupport.bootstrapStatic("postEventFromNative", $$robo$$android_media_audiofx_Visualizer$postEventFromNative(java.lang.Object int int int java.lang.Object ), (Object)object, (int)n, (int)n2, (int)n3, (Object)object2);
    }

    static {
        RobolectricInternals.classInitializing(Visualizer.class);
    }

    public /* synthetic */ Visualizer() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Visualizer)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private class NativeEventHandler
    extends Handler
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private Visualizer mVisualizer;
        /* synthetic */ Visualizer this$0;

        private void $$robo$$android_media_audiofx_Visualizer_NativeEventHandler$__constructor__(Visualizer visualizer, Visualizer v, Looper looper) {
            this.mVisualizer = v;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_media_audiofx_Visualizer_NativeEventHandler$handleCaptureMessage(Message msg) {
            OnDataCaptureListener l = null;
            Object object = this.this$0.mListenerLock;
            synchronized (object) {
                l = this.mVisualizer.mCaptureListener;
            }
            if (l != null) {
                byte[] data = (byte[])msg.obj;
                int samplingRate = msg.arg1;
                switch (msg.what) {
                    case 0: {
                        l.onWaveFormDataCapture(this.mVisualizer, data, samplingRate);
                        break;
                    }
                    case 1: {
                        l.onFftDataCapture(this.mVisualizer, data, samplingRate);
                        break;
                    }
                    default: {
                        Log.e("Visualizer-JAVA", "Unknown native event in handleCaptureMessge: " + msg.what);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_media_audiofx_Visualizer_NativeEventHandler$handleServerDiedMessage(Message msg) {
            OnServerDiedListener l = null;
            Object object = this.this$0.mListenerLock;
            synchronized (object) {
                l = this.mVisualizer.mServerDiedListener;
            }
            if (l != null) {
                l.onServerDied();
            }
        }

        private final void $$robo$$android_media_audiofx_Visualizer_NativeEventHandler$handleMessage(Message msg) {
            if (this.mVisualizer == null) {
                return;
            }
            switch (msg.what) {
                case 0: 
                case 1: {
                    this.handleCaptureMessage(msg);
                    break;
                }
                case 2: {
                    this.handleServerDiedMessage(msg);
                    break;
                }
                default: {
                    Log.e("Visualizer-JAVA", "Unknown native event: " + msg.what);
                }
            }
        }

        private void __constructor__(Visualizer visualizer, Visualizer visualizer2, Looper looper) {
            this.$$robo$$android_media_audiofx_Visualizer_NativeEventHandler$__constructor__(visualizer, visualizer2, looper);
        }

        public NativeEventHandler(Visualizer visualizer, Visualizer visualizer2, Looper looper) {
            this.this$0 = visualizer;
            super(looper);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_audiofx_Visualizer_NativeEventHandler$__constructor__(android.media.audiofx.Visualizer android.media.audiofx.Visualizer android.os.Looper ), this, visualizer, visualizer2, looper);
        }

        private void handleCaptureMessage(Message message) {
            InvokeDynamicSupport.bootstrap("handleCaptureMessage", $$robo$$android_media_audiofx_Visualizer_NativeEventHandler$handleCaptureMessage(android.os.Message ), this, message);
        }

        private void handleServerDiedMessage(Message message) {
            InvokeDynamicSupport.bootstrap("handleServerDiedMessage", $$robo$$android_media_audiofx_Visualizer_NativeEventHandler$handleServerDiedMessage(android.os.Message ), this, message);
        }

        @Override
        public void handleMessage(Message message) {
            InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_media_audiofx_Visualizer_NativeEventHandler$handleMessage(android.os.Message ), this, message);
        }

        public /* synthetic */ NativeEventHandler() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NativeEventHandler)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface OnServerDiedListener
    extends InstrumentedInterface {
        public void onServerDied();
    }

    public static interface OnDataCaptureListener
    extends InstrumentedInterface {
        public void onWaveFormDataCapture(Visualizer var1, byte[] var2, int var3);

        public void onFftDataCapture(Visualizer var1, byte[] var2, int var3);
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class MeasurementPeakRms
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public int mPeak;
        public int mRms;

        private void $$robo$$android_media_audiofx_Visualizer_MeasurementPeakRms$__constructor__() {
        }

        private void __constructor__() {
            this.$$robo$$android_media_audiofx_Visualizer_MeasurementPeakRms$__constructor__();
        }

        public MeasurementPeakRms() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_audiofx_Visualizer_MeasurementPeakRms$__constructor__(), this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MeasurementPeakRms)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

