/*
 * Decompiled with CFR 0.152.
 */
package android.media.tv;

import android.annotation.IntDef;
import android.annotation.StringDef;
import android.content.ComponentName;
import android.content.ContentUris;
import android.content.Context;
import android.media.tv.TvInputManager;
import android.net.Uri;
import android.provider.BaseColumns;
import android.text.TextUtils;
import android.util.ArraySet;
import com.google.errorprone.annotations.DoNotMock;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class TvContract
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    public static String AUTHORITY = "android.media.tv";
    public static String PERMISSION_READ_TV_LISTINGS = "android.permission.READ_TV_LISTINGS";
    private static String PATH_CHANNEL = "channel";
    private static String PATH_PROGRAM = "program";
    private static String PATH_RECORDED_PROGRAM = "recorded_program";
    private static String PATH_PREVIEW_PROGRAM = "preview_program";
    private static String PATH_WATCH_NEXT_PROGRAM = "watch_next_program";
    private static String PATH_PASSTHROUGH = "passthrough";
    public static String ACTION_CHANNEL_BROWSABLE_REQUESTED = "android.media.tv.action.CHANNEL_BROWSABLE_REQUESTED";
    public static String ACTION_REQUEST_CHANNEL_BROWSABLE = "android.media.tv.action.REQUEST_CHANNEL_BROWSABLE";
    public static String ACTION_PREVIEW_PROGRAM_BROWSABLE_DISABLED = "android.media.tv.action.PREVIEW_PROGRAM_BROWSABLE_DISABLED";
    public static String ACTION_WATCH_NEXT_PROGRAM_BROWSABLE_DISABLED = "android.media.tv.action.WATCH_NEXT_PROGRAM_BROWSABLE_DISABLED";
    public static String ACTION_PREVIEW_PROGRAM_ADDED_TO_WATCH_NEXT = "android.media.tv.action.PREVIEW_PROGRAM_ADDED_TO_WATCH_NEXT";
    public static String ACTION_INITIALIZE_PROGRAMS = "android.media.tv.action.INITIALIZE_PROGRAMS";
    public static String EXTRA_CHANNEL_ID = "android.media.tv.extra.CHANNEL_ID";
    public static String EXTRA_PACKAGE_NAME = "android.media.tv.extra.PACKAGE_NAME";
    public static String EXTRA_PREVIEW_PROGRAM_ID = "android.media.tv.extra.PREVIEW_PROGRAM_ID";
    public static String EXTRA_WATCH_NEXT_PROGRAM_ID = "android.media.tv.extra.WATCH_NEXT_PROGRAM_ID";
    public static String EXTRA_RESULT_CODE = "android.media.tv.extra.RESULT_CODE";
    public static int RESULT_OK = 0;
    public static int RESULT_ERROR_IO = 1;
    public static int RESULT_ERROR_INVALID_ARGUMENT = 2;
    public static String METHOD_GET_COLUMNS = "get_columns";
    public static String METHOD_ADD_COLUMN = "add_column";
    public static String METHOD_GET_BLOCKED_PACKAGES = "get_blocked_packages";
    public static String METHOD_BLOCK_PACKAGE = "block_package";
    public static String METHOD_UNBLOCK_PACKAGE = "unblock_package";
    public static String EXTRA_EXISTING_COLUMN_NAMES = "android.media.tv.extra.EXISTING_COLUMN_NAMES";
    public static String EXTRA_COLUMN_NAME = "android.media.tv.extra.COLUMN_NAME";
    public static String EXTRA_DATA_TYPE = "android.media.tv.extra.DATA_TYPE";
    public static String EXTRA_DEFAULT_VALUE = "android.media.tv.extra.DEFAULT_VALUE";
    public static String EXTRA_BLOCKED_PACKAGES = "android.media.tv.extra.BLOCKED_PACKAGES";
    public static String PARAM_INPUT = "input";
    public static String PARAM_CHANNEL = "channel";
    public static String PARAM_START_TIME = "start_time";
    public static String PARAM_END_TIME = "end_time";
    public static String PARAM_BROWSABLE_ONLY = "browsable_only";
    public static String PARAM_CANONICAL_GENRE = "canonical_genre";
    public static String PARAM_PREVIEW = "preview";
    public static String PARAM_PACKAGE = "package";

    private static final String $$robo$$android_media_tv_TvContract$buildInputId(ComponentName name) {
        return name.flattenToShortString();
    }

    private static final Uri $$robo$$android_media_tv_TvContract$buildChannelUri(long channelId) {
        return ContentUris.withAppendedId(Channels.CONTENT_URI, channelId);
    }

    private static final Uri $$robo$$android_media_tv_TvContract$buildChannelUriForPassthroughInput(String inputId) {
        return new Uri.Builder().scheme("content").authority("android.media.tv").appendPath("passthrough").appendPath(inputId).build();
    }

    private static final Uri $$robo$$android_media_tv_TvContract$buildChannelLogoUri(long channelId) {
        return TvContract.buildChannelLogoUri(TvContract.buildChannelUri(channelId));
    }

    private static final Uri $$robo$$android_media_tv_TvContract$buildChannelLogoUri(Uri channelUri) {
        if (!TvContract.isChannelUriForTunerInput(channelUri)) {
            throw new IllegalArgumentException("Not a channel: " + channelUri);
        }
        return Uri.withAppendedPath(channelUri, "logo");
    }

    private static final Uri $$robo$$android_media_tv_TvContract$buildChannelsUriForInput(String inputId) {
        return TvContract.buildChannelsUriForInput(inputId, false);
    }

    private static final Uri $$robo$$android_media_tv_TvContract$buildChannelsUriForInput(String inputId, boolean browsableOnly) {
        Uri.Builder builder = Channels.CONTENT_URI.buildUpon();
        if (inputId != null) {
            builder.appendQueryParameter("input", inputId);
        }
        return builder.appendQueryParameter("browsable_only", String.valueOf(browsableOnly)).build();
    }

    private static final Uri $$robo$$android_media_tv_TvContract$buildChannelsUriForInput(String inputId, String genre, boolean browsableOnly) {
        if (genre == null) {
            return TvContract.buildChannelsUriForInput(inputId, browsableOnly);
        }
        if (!Programs.Genres.isCanonical(genre)) {
            throw new IllegalArgumentException("Not a canonical genre: '" + genre + "'");
        }
        return TvContract.buildChannelsUriForInput(inputId, browsableOnly).buildUpon().appendQueryParameter("canonical_genre", genre).build();
    }

    private static final Uri $$robo$$android_media_tv_TvContract$buildProgramUri(long programId) {
        return ContentUris.withAppendedId(Programs.CONTENT_URI, programId);
    }

    private static final Uri $$robo$$android_media_tv_TvContract$buildProgramsUriForChannel(long channelId) {
        return Programs.CONTENT_URI.buildUpon().appendQueryParameter("channel", String.valueOf(channelId)).build();
    }

    private static final Uri $$robo$$android_media_tv_TvContract$buildProgramsUriForChannel(Uri channelUri) {
        if (!TvContract.isChannelUriForTunerInput(channelUri)) {
            throw new IllegalArgumentException("Not a channel: " + channelUri);
        }
        return TvContract.buildProgramsUriForChannel(ContentUris.parseId(channelUri));
    }

    private static final Uri $$robo$$android_media_tv_TvContract$buildProgramsUriForChannel(long channelId, long startTime, long endTime) {
        Uri uri = TvContract.buildProgramsUriForChannel(channelId);
        return uri.buildUpon().appendQueryParameter("start_time", String.valueOf(startTime)).appendQueryParameter("end_time", String.valueOf(endTime)).build();
    }

    private static final Uri $$robo$$android_media_tv_TvContract$buildProgramsUriForChannel(Uri channelUri, long startTime, long endTime) {
        if (!TvContract.isChannelUriForTunerInput(channelUri)) {
            throw new IllegalArgumentException("Not a channel: " + channelUri);
        }
        return TvContract.buildProgramsUriForChannel(ContentUris.parseId(channelUri), startTime, endTime);
    }

    private static final Uri $$robo$$android_media_tv_TvContract$buildRecordedProgramUri(long recordedProgramId) {
        return ContentUris.withAppendedId(RecordedPrograms.CONTENT_URI, recordedProgramId);
    }

    private static final Uri $$robo$$android_media_tv_TvContract$buildPreviewProgramUri(long previewProgramId) {
        return ContentUris.withAppendedId(PreviewPrograms.CONTENT_URI, previewProgramId);
    }

    private static final Uri $$robo$$android_media_tv_TvContract$buildPreviewProgramsUriForChannel(long channelId) {
        return PreviewPrograms.CONTENT_URI.buildUpon().appendQueryParameter("channel", String.valueOf(channelId)).build();
    }

    private static final Uri $$robo$$android_media_tv_TvContract$buildPreviewProgramsUriForChannel(Uri channelUri) {
        if (!TvContract.isChannelUriForTunerInput(channelUri)) {
            throw new IllegalArgumentException("Not a channel: " + channelUri);
        }
        return TvContract.buildPreviewProgramsUriForChannel(ContentUris.parseId(channelUri));
    }

    private static final Uri $$robo$$android_media_tv_TvContract$buildWatchNextProgramUri(long watchNextProgramId) {
        return ContentUris.withAppendedId(WatchNextPrograms.CONTENT_URI, watchNextProgramId);
    }

    private static final Uri $$robo$$android_media_tv_TvContract$buildWatchedProgramUri(long watchedProgramId) {
        return ContentUris.withAppendedId(WatchedPrograms.CONTENT_URI, watchedProgramId);
    }

    private static final boolean $$robo$$android_media_tv_TvContract$isTvUri(Uri uri) {
        return uri != null && "content".equals(uri.getScheme()) && "android.media.tv".equals(uri.getAuthority());
    }

    private static final boolean $$robo$$android_media_tv_TvContract$isTwoSegmentUriStartingWith(Uri uri, String pathSegment) {
        List<String> pathSegments = uri.getPathSegments();
        return pathSegments.size() == 2 && pathSegment.equals(pathSegments.get(0));
    }

    private static final boolean $$robo$$android_media_tv_TvContract$isChannelUri(Uri uri) {
        return TvContract.isChannelUriForTunerInput(uri) || TvContract.isChannelUriForPassthroughInput(uri);
    }

    private static final boolean $$robo$$android_media_tv_TvContract$isChannelUriForTunerInput(Uri uri) {
        return TvContract.isTvUri(uri) && TvContract.isTwoSegmentUriStartingWith(uri, "channel");
    }

    private static final boolean $$robo$$android_media_tv_TvContract$isChannelUriForPassthroughInput(Uri uri) {
        return TvContract.isTvUri(uri) && TvContract.isTwoSegmentUriStartingWith(uri, "passthrough");
    }

    private static final boolean $$robo$$android_media_tv_TvContract$isProgramUri(Uri uri) {
        return TvContract.isTvUri(uri) && TvContract.isTwoSegmentUriStartingWith(uri, "program");
    }

    private static final void $$robo$$android_media_tv_TvContract$requestChannelBrowsable(Context context, long channelId) {
        TvInputManager manager = (TvInputManager)context.getSystemService("tv_input");
        if (manager != null) {
            manager.requestChannelBrowsable(TvContract.buildChannelUri(channelId));
        }
    }

    private void $$robo$$android_media_tv_TvContract$__constructor__() {
    }

    public static String buildInputId(ComponentName componentName) {
        return InvokeDynamicSupport.bootstrapStatic("buildInputId", $$robo$$android_media_tv_TvContract$buildInputId(android.content.ComponentName ), (ComponentName)componentName);
    }

    public static Uri buildChannelUri(long l) {
        return InvokeDynamicSupport.bootstrapStatic("buildChannelUri", $$robo$$android_media_tv_TvContract$buildChannelUri(long ), (long)l);
    }

    public static Uri buildChannelUriForPassthroughInput(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("buildChannelUriForPassthroughInput", $$robo$$android_media_tv_TvContract$buildChannelUriForPassthroughInput(java.lang.String ), (String)string2);
    }

    public static Uri buildChannelLogoUri(long l) {
        return InvokeDynamicSupport.bootstrapStatic("buildChannelLogoUri", $$robo$$android_media_tv_TvContract$buildChannelLogoUri(long ), (long)l);
    }

    public static Uri buildChannelLogoUri(Uri uri) {
        return InvokeDynamicSupport.bootstrapStatic("buildChannelLogoUri", $$robo$$android_media_tv_TvContract$buildChannelLogoUri(android.net.Uri ), (Uri)uri);
    }

    public static Uri buildChannelsUriForInput(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("buildChannelsUriForInput", $$robo$$android_media_tv_TvContract$buildChannelsUriForInput(java.lang.String ), (String)string2);
    }

    public static Uri buildChannelsUriForInput(String string2, boolean bl) {
        return InvokeDynamicSupport.bootstrapStatic("buildChannelsUriForInput", $$robo$$android_media_tv_TvContract$buildChannelsUriForInput(java.lang.String boolean ), (String)string2, (boolean)bl);
    }

    public static Uri buildChannelsUriForInput(String string2, String string3, boolean bl) {
        return InvokeDynamicSupport.bootstrapStatic("buildChannelsUriForInput", $$robo$$android_media_tv_TvContract$buildChannelsUriForInput(java.lang.String java.lang.String boolean ), (String)string2, (String)string3, (boolean)bl);
    }

    public static Uri buildProgramUri(long l) {
        return InvokeDynamicSupport.bootstrapStatic("buildProgramUri", $$robo$$android_media_tv_TvContract$buildProgramUri(long ), (long)l);
    }

    public static Uri buildProgramsUriForChannel(long l) {
        return InvokeDynamicSupport.bootstrapStatic("buildProgramsUriForChannel", $$robo$$android_media_tv_TvContract$buildProgramsUriForChannel(long ), (long)l);
    }

    public static Uri buildProgramsUriForChannel(Uri uri) {
        return InvokeDynamicSupport.bootstrapStatic("buildProgramsUriForChannel", $$robo$$android_media_tv_TvContract$buildProgramsUriForChannel(android.net.Uri ), (Uri)uri);
    }

    public static Uri buildProgramsUriForChannel(long l, long l2, long l3) {
        return InvokeDynamicSupport.bootstrapStatic("buildProgramsUriForChannel", $$robo$$android_media_tv_TvContract$buildProgramsUriForChannel(long long long ), (long)l, (long)l2, (long)l3);
    }

    public static Uri buildProgramsUriForChannel(Uri uri, long l, long l2) {
        return InvokeDynamicSupport.bootstrapStatic("buildProgramsUriForChannel", $$robo$$android_media_tv_TvContract$buildProgramsUriForChannel(android.net.Uri long long ), (Uri)uri, (long)l, (long)l2);
    }

    public static Uri buildRecordedProgramUri(long l) {
        return InvokeDynamicSupport.bootstrapStatic("buildRecordedProgramUri", $$robo$$android_media_tv_TvContract$buildRecordedProgramUri(long ), (long)l);
    }

    public static Uri buildPreviewProgramUri(long l) {
        return InvokeDynamicSupport.bootstrapStatic("buildPreviewProgramUri", $$robo$$android_media_tv_TvContract$buildPreviewProgramUri(long ), (long)l);
    }

    public static Uri buildPreviewProgramsUriForChannel(long l) {
        return InvokeDynamicSupport.bootstrapStatic("buildPreviewProgramsUriForChannel", $$robo$$android_media_tv_TvContract$buildPreviewProgramsUriForChannel(long ), (long)l);
    }

    public static Uri buildPreviewProgramsUriForChannel(Uri uri) {
        return InvokeDynamicSupport.bootstrapStatic("buildPreviewProgramsUriForChannel", $$robo$$android_media_tv_TvContract$buildPreviewProgramsUriForChannel(android.net.Uri ), (Uri)uri);
    }

    public static Uri buildWatchNextProgramUri(long l) {
        return InvokeDynamicSupport.bootstrapStatic("buildWatchNextProgramUri", $$robo$$android_media_tv_TvContract$buildWatchNextProgramUri(long ), (long)l);
    }

    public static Uri buildWatchedProgramUri(long l) {
        return InvokeDynamicSupport.bootstrapStatic("buildWatchedProgramUri", $$robo$$android_media_tv_TvContract$buildWatchedProgramUri(long ), (long)l);
    }

    private static boolean isTvUri(Uri uri) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isTvUri", $$robo$$android_media_tv_TvContract$isTvUri(android.net.Uri ), (Uri)uri);
    }

    private static boolean isTwoSegmentUriStartingWith(Uri uri, String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isTwoSegmentUriStartingWith", $$robo$$android_media_tv_TvContract$isTwoSegmentUriStartingWith(android.net.Uri java.lang.String ), (Uri)uri, (String)string2);
    }

    public static boolean isChannelUri(Uri uri) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isChannelUri", $$robo$$android_media_tv_TvContract$isChannelUri(android.net.Uri ), (Uri)uri);
    }

    public static boolean isChannelUriForTunerInput(Uri uri) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isChannelUriForTunerInput", $$robo$$android_media_tv_TvContract$isChannelUriForTunerInput(android.net.Uri ), (Uri)uri);
    }

    public static boolean isChannelUriForPassthroughInput(Uri uri) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isChannelUriForPassthroughInput", $$robo$$android_media_tv_TvContract$isChannelUriForPassthroughInput(android.net.Uri ), (Uri)uri);
    }

    public static boolean isProgramUri(Uri uri) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isProgramUri", $$robo$$android_media_tv_TvContract$isProgramUri(android.net.Uri ), (Uri)uri);
    }

    public static void requestChannelBrowsable(Context context, long l) {
        InvokeDynamicSupport.bootstrapStatic("requestChannelBrowsable", $$robo$$android_media_tv_TvContract$requestChannelBrowsable(android.content.Context long ), (Context)context, (long)l);
    }

    private void __constructor__() {
        this.$$robo$$android_media_tv_TvContract$__constructor__();
    }

    public TvContract() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_tv_TvContract$__constructor__(), this);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TvContract)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class WatchedPrograms
    implements BaseTvColumns,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public static Uri CONTENT_URI;
        public static String CONTENT_TYPE = "vnd.android.cursor.dir/watched_program";
        public static String CONTENT_ITEM_TYPE = "vnd.android.cursor.item/watched_program";
        public static String COLUMN_WATCH_START_TIME_UTC_MILLIS = "watch_start_time_utc_millis";
        public static String COLUMN_WATCH_END_TIME_UTC_MILLIS = "watch_end_time_utc_millis";
        public static String COLUMN_CHANNEL_ID = "channel_id";
        public static String COLUMN_TITLE = "title";
        public static String COLUMN_START_TIME_UTC_MILLIS = "start_time_utc_millis";
        public static String COLUMN_END_TIME_UTC_MILLIS = "end_time_utc_millis";
        public static String COLUMN_DESCRIPTION = "description";
        public static String COLUMN_INTERNAL_TUNE_PARAMS = "tune_params";
        public static String COLUMN_INTERNAL_SESSION_TOKEN = "session_token";

        private void $$robo$$android_media_tv_TvContract_WatchedPrograms$__constructor__() {
        }

        static void __staticInitializer__() {
            CONTENT_URI = Uri.parse("content://android.media.tv/watched_program");
        }

        private void __constructor__() {
            this.$$robo$$android_media_tv_TvContract_WatchedPrograms$__constructor__();
        }

        public WatchedPrograms() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_tv_TvContract_WatchedPrograms$__constructor__(), this);
        }

        static {
            RobolectricInternals.classInitializing(WatchedPrograms.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (WatchedPrograms)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class WatchNextPrograms
    implements BaseTvColumns,
    ProgramColumns,
    PreviewProgramColumns,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public static Uri CONTENT_URI;
        public static String CONTENT_TYPE = "vnd.android.cursor.dir/watch_next_program";
        public static String CONTENT_ITEM_TYPE = "vnd.android.cursor.item/watch_next_program";
        public static int WATCH_NEXT_TYPE_CONTINUE = 0;
        public static int WATCH_NEXT_TYPE_NEXT = 1;
        public static int WATCH_NEXT_TYPE_NEW = 2;
        public static int WATCH_NEXT_TYPE_WATCHLIST = 3;
        public static String COLUMN_WATCH_NEXT_TYPE = "watch_next_type";
        public static String COLUMN_LAST_ENGAGEMENT_TIME_UTC_MILLIS = "last_engagement_time_utc_millis";

        private void $$robo$$android_media_tv_TvContract_WatchNextPrograms$__constructor__() {
        }

        static void __staticInitializer__() {
            CONTENT_URI = Uri.parse("content://android.media.tv/watch_next_program");
        }

        private void __constructor__() {
            this.$$robo$$android_media_tv_TvContract_WatchNextPrograms$__constructor__();
        }

        public WatchNextPrograms() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_tv_TvContract_WatchNextPrograms$__constructor__(), this);
        }

        static {
            RobolectricInternals.classInitializing(WatchNextPrograms.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (WatchNextPrograms)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        @Retention(value=RetentionPolicy.SOURCE)
        @IntDef(value={0L, 1L, 2L, 3L})
        public static @interface WatchNextType {
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class PreviewPrograms
    implements BaseTvColumns,
    ProgramColumns,
    PreviewProgramColumns,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public static Uri CONTENT_URI;
        public static String CONTENT_TYPE = "vnd.android.cursor.dir/preview_program";
        public static String CONTENT_ITEM_TYPE = "vnd.android.cursor.item/preview_program";
        public static String COLUMN_CHANNEL_ID = "channel_id";
        public static String COLUMN_WEIGHT = "weight";

        private void $$robo$$android_media_tv_TvContract_PreviewPrograms$__constructor__() {
        }

        static void __staticInitializer__() {
            CONTENT_URI = Uri.parse("content://android.media.tv/preview_program");
        }

        private void __constructor__() {
            this.$$robo$$android_media_tv_TvContract_PreviewPrograms$__constructor__();
        }

        public PreviewPrograms() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_tv_TvContract_PreviewPrograms$__constructor__(), this);
        }

        static {
            RobolectricInternals.classInitializing(PreviewPrograms.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PreviewPrograms)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class RecordedPrograms
    implements BaseTvColumns,
    ProgramColumns,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public static Uri CONTENT_URI;
        public static String CONTENT_TYPE = "vnd.android.cursor.dir/recorded_program";
        public static String CONTENT_ITEM_TYPE = "vnd.android.cursor.item/recorded_program";
        public static String COLUMN_CHANNEL_ID = "channel_id";
        public static String COLUMN_INPUT_ID = "input_id";
        public static String COLUMN_START_TIME_UTC_MILLIS = "start_time_utc_millis";
        public static String COLUMN_END_TIME_UTC_MILLIS = "end_time_utc_millis";
        public static String COLUMN_BROADCAST_GENRE = "broadcast_genre";
        public static String COLUMN_RECORDING_DATA_URI = "recording_data_uri";
        public static String COLUMN_RECORDING_DATA_BYTES = "recording_data_bytes";
        public static String COLUMN_RECORDING_DURATION_MILLIS = "recording_duration_millis";
        public static String COLUMN_RECORDING_EXPIRE_TIME_UTC_MILLIS = "recording_expire_time_utc_millis";

        private void $$robo$$android_media_tv_TvContract_RecordedPrograms$__constructor__() {
        }

        static void __staticInitializer__() {
            CONTENT_URI = Uri.parse("content://android.media.tv/recorded_program");
        }

        private void __constructor__() {
            this.$$robo$$android_media_tv_TvContract_RecordedPrograms$__constructor__();
        }

        public RecordedPrograms() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_tv_TvContract_RecordedPrograms$__constructor__(), this);
        }

        static {
            RobolectricInternals.classInitializing(RecordedPrograms.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RecordedPrograms)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class Programs
    implements BaseTvColumns,
    ProgramColumns,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public static Uri CONTENT_URI;
        public static String CONTENT_TYPE = "vnd.android.cursor.dir/program";
        public static String CONTENT_ITEM_TYPE = "vnd.android.cursor.item/program";
        public static String COLUMN_CHANNEL_ID = "channel_id";
        @Deprecated
        public static String COLUMN_SEASON_NUMBER = "season_number";
        @Deprecated
        public static String COLUMN_EPISODE_NUMBER = "episode_number";
        public static String COLUMN_START_TIME_UTC_MILLIS = "start_time_utc_millis";
        public static String COLUMN_END_TIME_UTC_MILLIS = "end_time_utc_millis";
        public static String COLUMN_BROADCAST_GENRE = "broadcast_genre";
        public static String COLUMN_RECORDING_PROHIBITED = "recording_prohibited";

        private void $$robo$$android_media_tv_TvContract_Programs$__constructor__() {
        }

        static void __staticInitializer__() {
            CONTENT_URI = Uri.parse("content://android.media.tv/program");
        }

        private void __constructor__() {
            this.$$robo$$android_media_tv_TvContract_Programs$__constructor__();
        }

        public Programs() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_tv_TvContract_Programs$__constructor__(), this);
        }

        static {
            RobolectricInternals.classInitializing(Programs.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Programs)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
        public static final class Genres
        implements ShadowedObject {
            public /* synthetic */ Object __robo_data__;
            public static String FAMILY_KIDS = "FAMILY_KIDS";
            public static String SPORTS = "SPORTS";
            public static String SHOPPING = "SHOPPING";
            public static String MOVIES = "MOVIES";
            public static String COMEDY = "COMEDY";
            public static String TRAVEL = "TRAVEL";
            public static String DRAMA = "DRAMA";
            public static String EDUCATION = "EDUCATION";
            public static String ANIMAL_WILDLIFE = "ANIMAL_WILDLIFE";
            public static String NEWS = "NEWS";
            public static String GAMING = "GAMING";
            public static String ARTS = "ARTS";
            public static String ENTERTAINMENT = "ENTERTAINMENT";
            public static String LIFE_STYLE = "LIFE_STYLE";
            public static String MUSIC = "MUSIC";
            public static String PREMIER = "PREMIER";
            public static String TECH_SCIENCE = "TECH_SCIENCE";
            private static ArraySet<String> CANONICAL_GENRES;
            private static char DOUBLE_QUOTE = '\"';
            private static char COMMA = ',';
            private static String DELIMITER = ",";
            private static String[] EMPTY_STRING_ARRAY;

            private void $$robo$$android_media_tv_TvContract_Programs_Genres$__constructor__() {
            }

            private static final String $$robo$$android_media_tv_TvContract_Programs_Genres$encode(String ... genres) {
                if (genres == null) {
                    return null;
                }
                StringBuilder sb = new StringBuilder();
                String separator = "";
                for (String genre : genres) {
                    sb.append(separator).append(Genres.encodeToCsv(genre));
                    separator = ",";
                }
                return sb.toString();
            }

            private static final String $$robo$$android_media_tv_TvContract_Programs_Genres$encodeToCsv(String genre) {
                StringBuilder sb = new StringBuilder();
                int length = genre.length();
                for (int i = 0; i < length; ++i) {
                    char c = genre.charAt(i);
                    switch (c) {
                        case '\"': {
                            sb.append('\"');
                            break;
                        }
                        case ',': {
                            sb.append('\"');
                        }
                    }
                    sb.append(c);
                }
                return sb.toString();
            }

            /*
             * Enabled aggressive block sorting
             */
            private static final String[] $$robo$$android_media_tv_TvContract_Programs_Genres$decode(String genres) {
                if (TextUtils.isEmpty(genres)) {
                    return EMPTY_STRING_ARRAY;
                }
                if (genres.indexOf(44) == -1 && genres.indexOf(34) == -1) {
                    return new String[]{genres.trim()};
                }
                StringBuilder sb = new StringBuilder();
                ArrayList<String> results = new ArrayList<String>();
                int length = genres.length();
                boolean escape = false;
                block4: for (int i = 0; i < length; ++i) {
                    char c = genres.charAt(i);
                    switch (c) {
                        case '\"': {
                            if (escape) break;
                            escape = true;
                            continue block4;
                        }
                        case ',': {
                            if (escape) break;
                            String string2 = sb.toString().trim();
                            if (string2.length() > 0) {
                                results.add(string2);
                            }
                            sb = new StringBuilder();
                            continue block4;
                        }
                    }
                    sb.append(c);
                    escape = false;
                }
                String string3 = sb.toString().trim();
                if (string3.length() > 0) {
                    results.add(string3);
                }
                return results.toArray(new String[results.size()]);
            }

            private static final boolean $$robo$$android_media_tv_TvContract_Programs_Genres$isCanonical(String genre) {
                return CANONICAL_GENRES.contains(genre);
            }

            static void __staticInitializer__() {
                CANONICAL_GENRES = new ArraySet();
                CANONICAL_GENRES.add("FAMILY_KIDS");
                CANONICAL_GENRES.add("SPORTS");
                CANONICAL_GENRES.add("SHOPPING");
                CANONICAL_GENRES.add("MOVIES");
                CANONICAL_GENRES.add("COMEDY");
                CANONICAL_GENRES.add("TRAVEL");
                CANONICAL_GENRES.add("DRAMA");
                CANONICAL_GENRES.add("EDUCATION");
                CANONICAL_GENRES.add("ANIMAL_WILDLIFE");
                CANONICAL_GENRES.add("NEWS");
                CANONICAL_GENRES.add("GAMING");
                CANONICAL_GENRES.add("ARTS");
                CANONICAL_GENRES.add("ENTERTAINMENT");
                CANONICAL_GENRES.add("LIFE_STYLE");
                CANONICAL_GENRES.add("MUSIC");
                CANONICAL_GENRES.add("PREMIER");
                CANONICAL_GENRES.add("TECH_SCIENCE");
                EMPTY_STRING_ARRAY = new String[0];
            }

            private void __constructor__() {
                this.$$robo$$android_media_tv_TvContract_Programs_Genres$__constructor__();
            }

            public Genres() {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_tv_TvContract_Programs_Genres$__constructor__(), this);
            }

            public static String encode(String ... stringArray) {
                return InvokeDynamicSupport.bootstrapStatic("encode", $$robo$$android_media_tv_TvContract_Programs_Genres$encode(java.lang.String[] ), (String[])stringArray);
            }

            private static String encodeToCsv(String string2) {
                return InvokeDynamicSupport.bootstrapStatic("encodeToCsv", $$robo$$android_media_tv_TvContract_Programs_Genres$encodeToCsv(java.lang.String ), (String)string2);
            }

            public static String[] decode(String string2) {
                return InvokeDynamicSupport.bootstrapStatic("decode", $$robo$$android_media_tv_TvContract_Programs_Genres$decode(java.lang.String ), (String)string2);
            }

            public static boolean isCanonical(String string2) {
                return (boolean)InvokeDynamicSupport.bootstrapStatic("isCanonical", $$robo$$android_media_tv_TvContract_Programs_Genres$isCanonical(java.lang.String ), (String)string2);
            }

            static {
                RobolectricInternals.classInitializing(Genres.class);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Genres)this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }

            @Retention(value=RetentionPolicy.SOURCE)
            @StringDef(value={"FAMILY_KIDS", "SPORTS", "SHOPPING", "MOVIES", "COMEDY", "TRAVEL", "DRAMA", "EDUCATION", "ANIMAL_WILDLIFE", "NEWS", "GAMING", "ARTS", "ENTERTAINMENT", "LIFE_STYLE", "MUSIC", "PREMIER", "TECH_SCIENCE"})
            public static @interface Genre {
            }
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class Channels
    implements BaseTvColumns,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public static Uri CONTENT_URI;
        public static String CONTENT_TYPE = "vnd.android.cursor.dir/channel";
        public static String CONTENT_ITEM_TYPE = "vnd.android.cursor.item/channel";
        public static String TYPE_OTHER = "TYPE_OTHER";
        public static String TYPE_NTSC = "TYPE_NTSC";
        public static String TYPE_PAL = "TYPE_PAL";
        public static String TYPE_SECAM = "TYPE_SECAM";
        public static String TYPE_DVB_T = "TYPE_DVB_T";
        public static String TYPE_DVB_T2 = "TYPE_DVB_T2";
        public static String TYPE_DVB_S = "TYPE_DVB_S";
        public static String TYPE_DVB_S2 = "TYPE_DVB_S2";
        public static String TYPE_DVB_C = "TYPE_DVB_C";
        public static String TYPE_DVB_C2 = "TYPE_DVB_C2";
        public static String TYPE_DVB_H = "TYPE_DVB_H";
        public static String TYPE_DVB_SH = "TYPE_DVB_SH";
        public static String TYPE_ATSC_T = "TYPE_ATSC_T";
        public static String TYPE_ATSC_C = "TYPE_ATSC_C";
        public static String TYPE_ATSC_M_H = "TYPE_ATSC_M_H";
        public static String TYPE_ISDB_T = "TYPE_ISDB_T";
        public static String TYPE_ISDB_TB = "TYPE_ISDB_TB";
        public static String TYPE_ISDB_S = "TYPE_ISDB_S";
        public static String TYPE_ISDB_C = "TYPE_ISDB_C";
        public static String TYPE_1SEG = "TYPE_1SEG";
        public static String TYPE_DTMB = "TYPE_DTMB";
        public static String TYPE_CMMB = "TYPE_CMMB";
        public static String TYPE_T_DMB = "TYPE_T_DMB";
        public static String TYPE_S_DMB = "TYPE_S_DMB";
        public static String TYPE_PREVIEW = "TYPE_PREVIEW";
        public static String SERVICE_TYPE_OTHER = "SERVICE_TYPE_OTHER";
        public static String SERVICE_TYPE_AUDIO_VIDEO = "SERVICE_TYPE_AUDIO_VIDEO";
        public static String SERVICE_TYPE_AUDIO = "SERVICE_TYPE_AUDIO";
        public static String VIDEO_FORMAT_240P = "VIDEO_FORMAT_240P";
        public static String VIDEO_FORMAT_360P = "VIDEO_FORMAT_360P";
        public static String VIDEO_FORMAT_480I = "VIDEO_FORMAT_480I";
        public static String VIDEO_FORMAT_480P = "VIDEO_FORMAT_480P";
        public static String VIDEO_FORMAT_576I = "VIDEO_FORMAT_576I";
        public static String VIDEO_FORMAT_576P = "VIDEO_FORMAT_576P";
        public static String VIDEO_FORMAT_720P = "VIDEO_FORMAT_720P";
        public static String VIDEO_FORMAT_1080I = "VIDEO_FORMAT_1080I";
        public static String VIDEO_FORMAT_1080P = "VIDEO_FORMAT_1080P";
        public static String VIDEO_FORMAT_2160P = "VIDEO_FORMAT_2160P";
        public static String VIDEO_FORMAT_4320P = "VIDEO_FORMAT_4320P";
        public static String VIDEO_RESOLUTION_SD = "VIDEO_RESOLUTION_SD";
        public static String VIDEO_RESOLUTION_ED = "VIDEO_RESOLUTION_ED";
        public static String VIDEO_RESOLUTION_HD = "VIDEO_RESOLUTION_HD";
        public static String VIDEO_RESOLUTION_FHD = "VIDEO_RESOLUTION_FHD";
        public static String VIDEO_RESOLUTION_UHD = "VIDEO_RESOLUTION_UHD";
        private static Map<String, String> VIDEO_FORMAT_TO_RESOLUTION_MAP;
        public static String COLUMN_INPUT_ID = "input_id";
        public static String COLUMN_TYPE = "type";
        public static String COLUMN_SERVICE_TYPE = "service_type";
        public static String COLUMN_ORIGINAL_NETWORK_ID = "original_network_id";
        public static String COLUMN_TRANSPORT_STREAM_ID = "transport_stream_id";
        public static String COLUMN_SERVICE_ID = "service_id";
        public static String COLUMN_DISPLAY_NUMBER = "display_number";
        public static String COLUMN_DISPLAY_NAME = "display_name";
        public static String COLUMN_NETWORK_AFFILIATION = "network_affiliation";
        public static String COLUMN_DESCRIPTION = "description";
        public static String COLUMN_VIDEO_FORMAT = "video_format";
        public static String COLUMN_BROWSABLE = "browsable";
        public static String COLUMN_SEARCHABLE = "searchable";
        public static String COLUMN_LOCKED = "locked";
        public static String COLUMN_APP_LINK_ICON_URI = "app_link_icon_uri";
        public static String COLUMN_APP_LINK_POSTER_ART_URI = "app_link_poster_art_uri";
        public static String COLUMN_APP_LINK_TEXT = "app_link_text";
        public static String COLUMN_APP_LINK_COLOR = "app_link_color";
        public static String COLUMN_APP_LINK_INTENT_URI = "app_link_intent_uri";
        public static String COLUMN_INTERNAL_PROVIDER_ID = "internal_provider_id";
        public static String COLUMN_INTERNAL_PROVIDER_DATA = "internal_provider_data";
        public static String COLUMN_INTERNAL_PROVIDER_FLAG1 = "internal_provider_flag1";
        public static String COLUMN_INTERNAL_PROVIDER_FLAG2 = "internal_provider_flag2";
        public static String COLUMN_INTERNAL_PROVIDER_FLAG3 = "internal_provider_flag3";
        public static String COLUMN_INTERNAL_PROVIDER_FLAG4 = "internal_provider_flag4";
        public static String COLUMN_VERSION_NUMBER = "version_number";
        public static String COLUMN_TRANSIENT = "transient";

        private static final String $$robo$$android_media_tv_TvContract_Channels$getVideoResolution(String videoFormat) {
            return VIDEO_FORMAT_TO_RESOLUTION_MAP.get(videoFormat);
        }

        private void $$robo$$android_media_tv_TvContract_Channels$__constructor__() {
        }

        static void __staticInitializer__() {
            CONTENT_URI = Uri.parse("content://android.media.tv/channel");
            VIDEO_FORMAT_TO_RESOLUTION_MAP = new HashMap<String, String>();
            VIDEO_FORMAT_TO_RESOLUTION_MAP.put("VIDEO_FORMAT_480I", "VIDEO_RESOLUTION_SD");
            VIDEO_FORMAT_TO_RESOLUTION_MAP.put("VIDEO_FORMAT_480P", "VIDEO_RESOLUTION_ED");
            VIDEO_FORMAT_TO_RESOLUTION_MAP.put("VIDEO_FORMAT_576I", "VIDEO_RESOLUTION_SD");
            VIDEO_FORMAT_TO_RESOLUTION_MAP.put("VIDEO_FORMAT_576P", "VIDEO_RESOLUTION_ED");
            VIDEO_FORMAT_TO_RESOLUTION_MAP.put("VIDEO_FORMAT_720P", "VIDEO_RESOLUTION_HD");
            VIDEO_FORMAT_TO_RESOLUTION_MAP.put("VIDEO_FORMAT_1080I", "VIDEO_RESOLUTION_HD");
            VIDEO_FORMAT_TO_RESOLUTION_MAP.put("VIDEO_FORMAT_1080P", "VIDEO_RESOLUTION_FHD");
            VIDEO_FORMAT_TO_RESOLUTION_MAP.put("VIDEO_FORMAT_2160P", "VIDEO_RESOLUTION_UHD");
            VIDEO_FORMAT_TO_RESOLUTION_MAP.put("VIDEO_FORMAT_4320P", "VIDEO_RESOLUTION_UHD");
        }

        public static String getVideoResolution(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("getVideoResolution", $$robo$$android_media_tv_TvContract_Channels$getVideoResolution(java.lang.String ), (String)string2);
        }

        private void __constructor__() {
            this.$$robo$$android_media_tv_TvContract_Channels$__constructor__();
        }

        public Channels() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_tv_TvContract_Channels$__constructor__(), this);
        }

        static {
            RobolectricInternals.classInitializing(Channels.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Channels)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
        public static final class Logo
        implements ShadowedObject {
            public /* synthetic */ Object __robo_data__;
            public static String CONTENT_DIRECTORY = "logo";

            private void $$robo$$android_media_tv_TvContract_Channels_Logo$__constructor__() {
            }

            private void __constructor__() {
                this.$$robo$$android_media_tv_TvContract_Channels_Logo$__constructor__();
            }

            public Logo() {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_tv_TvContract_Channels_Logo$__constructor__(), this);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Logo)this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }

        @Retention(value=RetentionPolicy.SOURCE)
        @StringDef(value={"VIDEO_RESOLUTION_SD", "VIDEO_RESOLUTION_ED", "VIDEO_RESOLUTION_HD", "VIDEO_RESOLUTION_FHD", "VIDEO_RESOLUTION_UHD"})
        public static @interface VideoResolution {
        }

        @Retention(value=RetentionPolicy.SOURCE)
        @StringDef(value={"VIDEO_FORMAT_240P", "VIDEO_FORMAT_360P", "VIDEO_FORMAT_480I", "VIDEO_FORMAT_576I", "VIDEO_FORMAT_576P", "VIDEO_FORMAT_720P", "VIDEO_FORMAT_1080I", "VIDEO_FORMAT_1080P", "VIDEO_FORMAT_2160P", "VIDEO_FORMAT_4320P"})
        public static @interface VideoFormat {
        }

        @Retention(value=RetentionPolicy.SOURCE)
        @StringDef(value={"SERVICE_TYPE_OTHER", "SERVICE_TYPE_AUDIO_VIDEO", "SERVICE_TYPE_AUDIO"})
        public static @interface ServiceType {
        }

        @Retention(value=RetentionPolicy.SOURCE)
        @StringDef(value={"TYPE_OTHER", "TYPE_NTSC", "TYPE_PAL", "TYPE_SECAM", "TYPE_DVB_T", "TYPE_DVB_T2", "TYPE_DVB_S", "TYPE_DVB_S2", "TYPE_DVB_C", "TYPE_DVB_C2", "TYPE_DVB_H", "TYPE_DVB_SH", "TYPE_ATSC_T", "TYPE_ATSC_C", "TYPE_ATSC_M_H", "TYPE_ISDB_T", "TYPE_ISDB_TB", "TYPE_ISDB_S", "TYPE_ISDB_C", "TYPE_1SEG", "TYPE_DTMB", "TYPE_CMMB", "TYPE_T_DMB", "TYPE_S_DMB", "TYPE_PREVIEW"})
        public static @interface Type {
        }
    }

    static interface PreviewProgramColumns
    extends InstrumentedInterface {
        public static final int TYPE_MOVIE = 0;
        public static final int TYPE_TV_SERIES = 1;
        public static final int TYPE_TV_SEASON = 2;
        public static final int TYPE_TV_EPISODE = 3;
        public static final int TYPE_CLIP = 4;
        public static final int TYPE_EVENT = 5;
        public static final int TYPE_CHANNEL = 6;
        public static final int TYPE_TRACK = 7;
        public static final int TYPE_ALBUM = 8;
        public static final int TYPE_ARTIST = 9;
        public static final int TYPE_PLAYLIST = 10;
        public static final int TYPE_STATION = 11;
        public static final int ASPECT_RATIO_16_9 = 0;
        public static final int ASPECT_RATIO_3_2 = 1;
        public static final int ASPECT_RATIO_4_3 = 2;
        public static final int ASPECT_RATIO_1_1 = 3;
        public static final int ASPECT_RATIO_2_3 = 4;
        public static final int AVAILABILITY_AVAILABLE = 0;
        public static final int AVAILABILITY_FREE_WITH_SUBSCRIPTION = 1;
        public static final int AVAILABILITY_PAID_CONTENT = 2;
        public static final int INTERACTION_TYPE_VIEWS = 0;
        public static final int INTERACTION_TYPE_LISTENS = 1;
        public static final int INTERACTION_TYPE_FOLLOWERS = 2;
        public static final int INTERACTION_TYPE_FANS = 3;
        public static final int INTERACTION_TYPE_LIKES = 4;
        public static final int INTERACTION_TYPE_THUMBS = 5;
        public static final int INTERACTION_TYPE_VIEWERS = 6;
        public static final String COLUMN_TYPE = "type";
        public static final String COLUMN_POSTER_ART_ASPECT_RATIO = "poster_art_aspect_ratio";
        public static final String COLUMN_THUMBNAIL_ASPECT_RATIO = "poster_thumbnail_aspect_ratio";
        public static final String COLUMN_LOGO_URI = "logo_uri";
        public static final String COLUMN_AVAILABILITY = "availability";
        public static final String COLUMN_STARTING_PRICE = "starting_price";
        public static final String COLUMN_OFFER_PRICE = "offer_price";
        public static final String COLUMN_RELEASE_DATE = "release_date";
        public static final String COLUMN_ITEM_COUNT = "item_count";
        public static final String COLUMN_LIVE = "live";
        public static final String COLUMN_INTERNAL_PROVIDER_ID = "internal_provider_id";
        public static final String COLUMN_PREVIEW_VIDEO_URI = "preview_video_uri";
        public static final String COLUMN_LAST_PLAYBACK_POSITION_MILLIS = "last_playback_position_millis";
        public static final String COLUMN_DURATION_MILLIS = "duration_millis";
        public static final String COLUMN_INTENT_URI = "intent_uri";
        public static final String COLUMN_TRANSIENT = "transient";
        public static final String COLUMN_INTERACTION_TYPE = "interaction_type";
        public static final String COLUMN_INTERACTION_COUNT = "interaction_count";
        public static final String COLUMN_AUTHOR = "author";
        public static final String COLUMN_BROWSABLE = "browsable";
        public static final String COLUMN_CONTENT_ID = "content_id";

        @Retention(value=RetentionPolicy.SOURCE)
        @IntDef(value={0L, 1L, 2L, 3L, 4L, 5L, 6L})
        public static @interface InteractionType {
        }

        @Retention(value=RetentionPolicy.SOURCE)
        @IntDef(value={0L, 1L, 2L})
        public static @interface Availability {
        }

        @Retention(value=RetentionPolicy.SOURCE)
        @IntDef(value={0L, 1L, 3L, 4L, 2L})
        public static @interface AspectRatio {
        }

        @Retention(value=RetentionPolicy.SOURCE)
        @IntDef(value={0L, 1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 10L, 11L})
        public static @interface Type {
        }
    }

    static interface ProgramColumns
    extends InstrumentedInterface {
        public static final int REVIEW_RATING_STYLE_STARS = 0;
        public static final int REVIEW_RATING_STYLE_THUMBS_UP_DOWN = 1;
        public static final int REVIEW_RATING_STYLE_PERCENTAGE = 2;
        public static final String COLUMN_TITLE = "title";
        public static final String COLUMN_SEASON_DISPLAY_NUMBER = "season_display_number";
        public static final String COLUMN_SEASON_TITLE = "season_title";
        public static final String COLUMN_EPISODE_DISPLAY_NUMBER = "episode_display_number";
        public static final String COLUMN_EPISODE_TITLE = "episode_title";
        public static final String COLUMN_CANONICAL_GENRE = "canonical_genre";
        public static final String COLUMN_SHORT_DESCRIPTION = "short_description";
        public static final String COLUMN_LONG_DESCRIPTION = "long_description";
        public static final String COLUMN_VIDEO_WIDTH = "video_width";
        public static final String COLUMN_VIDEO_HEIGHT = "video_height";
        public static final String COLUMN_AUDIO_LANGUAGE = "audio_language";
        public static final String COLUMN_CONTENT_RATING = "content_rating";
        public static final String COLUMN_POSTER_ART_URI = "poster_art_uri";
        public static final String COLUMN_THUMBNAIL_URI = "thumbnail_uri";
        public static final String COLUMN_SEARCHABLE = "searchable";
        public static final String COLUMN_INTERNAL_PROVIDER_DATA = "internal_provider_data";
        public static final String COLUMN_INTERNAL_PROVIDER_FLAG1 = "internal_provider_flag1";
        public static final String COLUMN_INTERNAL_PROVIDER_FLAG2 = "internal_provider_flag2";
        public static final String COLUMN_INTERNAL_PROVIDER_FLAG3 = "internal_provider_flag3";
        public static final String COLUMN_INTERNAL_PROVIDER_FLAG4 = "internal_provider_flag4";
        public static final String COLUMN_VERSION_NUMBER = "version_number";
        public static final String COLUMN_REVIEW_RATING_STYLE = "review_rating_style";
        public static final String COLUMN_REVIEW_RATING = "review_rating";

        @Retention(value=RetentionPolicy.SOURCE)
        @IntDef(value={0L, 1L, 2L})
        public static @interface ReviewRatingStyle {
        }
    }

    public static interface BaseTvColumns
    extends BaseColumns,
    InstrumentedInterface {
        public static final String COLUMN_PACKAGE_NAME = "package_name";
    }
}

