/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.annotation.StringDef;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.errorprone.annotations.DoNotMock;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class IpSecAlgorithm
implements Parcelable,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    public static String CRYPT_AES_CBC = "cbc(aes)";
    public static String AUTH_HMAC_MD5 = "hmac(md5)";
    public static String AUTH_HMAC_SHA1 = "hmac(sha1)";
    public static String AUTH_HMAC_SHA256 = "hmac(sha256)";
    public static String AUTH_HMAC_SHA384 = "hmac(sha384)";
    public static String AUTH_HMAC_SHA512 = "hmac(sha512)";
    private String mName;
    private byte[] mKey;
    private int mTruncLenBits;
    public static Parcelable.Creator<IpSecAlgorithm> CREATOR;

    private void $$robo$$android_net_IpSecAlgorithm$__constructor__(String algorithm, byte[] key) {
    }

    private void $$robo$$android_net_IpSecAlgorithm$__constructor__(String algoName, byte[] key, int truncLenBits) {
        if (!IpSecAlgorithm.isTruncationLengthValid(algoName, truncLenBits)) {
            throw new IllegalArgumentException("Unknown algorithm or invalid length");
        }
        this.mName = algoName;
        this.mKey = (byte[])key.clone();
        this.mTruncLenBits = Math.min(truncLenBits, key.length * 8);
    }

    private final String $$robo$$android_net_IpSecAlgorithm$getName() {
        return this.mName;
    }

    private final byte[] $$robo$$android_net_IpSecAlgorithm$getKey() {
        return (byte[])this.mKey.clone();
    }

    private final int $$robo$$android_net_IpSecAlgorithm$getTruncationLengthBits() {
        return this.mTruncLenBits;
    }

    private final int $$robo$$android_net_IpSecAlgorithm$describeContents() {
        return 0;
    }

    private final void $$robo$$android_net_IpSecAlgorithm$writeToParcel(Parcel out, int flags) {
        out.writeString(this.mName);
        out.writeByteArray(this.mKey);
        out.writeInt(this.mTruncLenBits);
    }

    private void $$robo$$android_net_IpSecAlgorithm$__constructor__(Parcel in) {
        this.mName = in.readString();
        this.mKey = in.createByteArray();
        this.mTruncLenBits = in.readInt();
    }

    private static final boolean $$robo$$android_net_IpSecAlgorithm$isTruncationLengthValid(String algo, int truncLenBits) {
        switch (algo) {
            case "cbc(aes)": {
                return truncLenBits == 128 || truncLenBits == 192 || truncLenBits == 256;
            }
            case "hmac(md5)": {
                return truncLenBits >= 96 && truncLenBits <= 128;
            }
            case "hmac(sha1)": {
                return truncLenBits >= 96 && truncLenBits <= 160;
            }
            case "hmac(sha256)": {
                return truncLenBits >= 96 && truncLenBits <= 256;
            }
            case "hmac(sha384)": {
                return truncLenBits >= 192 && truncLenBits <= 384;
            }
            case "hmac(sha512)": {
                return truncLenBits >= 256 && truncLenBits <= 512;
            }
        }
        return false;
    }

    private /* synthetic */ void $$robo$$android_net_IpSecAlgorithm$__constructor__(Parcel x0, 1 x1) {
    }

    static void __staticInitializer__() {
        CREATOR = new Parcelable.Creator<IpSecAlgorithm>(){
            public /* synthetic */ Object __robo_data__;

            private void $$robo$$android_net_IpSecAlgorithm_1$__constructor__() {
            }

            private final IpSecAlgorithm $$robo$$android_net_IpSecAlgorithm_1$createFromParcel(Parcel in) {
                return new IpSecAlgorithm(in, null);
            }

            private final IpSecAlgorithm[] $$robo$$android_net_IpSecAlgorithm_1$newArray(int size) {
                return new IpSecAlgorithm[size];
            }

            private void __constructor__() {
                this.$$robo$$android_net_IpSecAlgorithm_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_IpSecAlgorithm_1$__constructor__(), this);
            }

            @Override
            public IpSecAlgorithm createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_net_IpSecAlgorithm_1$createFromParcel(android.os.Parcel ), this, parcel);
            }

            public IpSecAlgorithm[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_net_IpSecAlgorithm_1$newArray(int ), this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__(String string2, byte[] byArray) {
        this.$$robo$$android_net_IpSecAlgorithm$__constructor__(string2, byArray);
    }

    public IpSecAlgorithm(String string2, byte[] byArray) {
        this(string2, byArray, byArray.length * 8);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_IpSecAlgorithm$__constructor__(java.lang.String byte[] ), this, string2, byArray);
    }

    private void __constructor__(String string2, byte[] byArray, int n) {
        this.$$robo$$android_net_IpSecAlgorithm$__constructor__(string2, byArray, n);
    }

    public IpSecAlgorithm(String string2, byte[] byArray, int n) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_IpSecAlgorithm$__constructor__(java.lang.String byte[] int ), this, string2, byArray, n);
    }

    public String getName() {
        return InvokeDynamicSupport.bootstrap("getName", $$robo$$android_net_IpSecAlgorithm$getName(), this);
    }

    public byte[] getKey() {
        return InvokeDynamicSupport.bootstrap("getKey", $$robo$$android_net_IpSecAlgorithm$getKey(), this);
    }

    public int getTruncationLengthBits() {
        return (int)InvokeDynamicSupport.bootstrap("getTruncationLengthBits", $$robo$$android_net_IpSecAlgorithm$getTruncationLengthBits(), this);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_net_IpSecAlgorithm$describeContents(), this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_net_IpSecAlgorithm$writeToParcel(android.os.Parcel int ), this, parcel, n);
    }

    private void __constructor__(Parcel parcel) {
        this.$$robo$$android_net_IpSecAlgorithm$__constructor__(parcel);
    }

    public IpSecAlgorithm(Parcel parcel) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_IpSecAlgorithm$__constructor__(android.os.Parcel ), this, parcel);
    }

    private static boolean isTruncationLengthValid(String string2, int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isTruncationLengthValid", $$robo$$android_net_IpSecAlgorithm$isTruncationLengthValid(java.lang.String int ), (String)string2, (int)n);
    }

    private /* synthetic */ void __constructor__(Parcel parcel, 1 var2_2) {
        this.$$robo$$android_net_IpSecAlgorithm$__constructor__(parcel, var2_2);
    }

    public /* synthetic */ IpSecAlgorithm(Parcel parcel, 1 var2_2) {
        this(parcel);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_IpSecAlgorithm$__constructor__(android.os.Parcel android.net.IpSecAlgorithm$1 ), this, parcel, var2_2);
    }

    static {
        RobolectricInternals.classInitializing(IpSecAlgorithm.class);
    }

    public /* synthetic */ IpSecAlgorithm() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (IpSecAlgorithm)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @StringDef(value={"cbc(aes)", "hmac(md5)", "hmac(sha1)", "hmac(sha256)", "hmac(sha512)"})
    public static @interface AlgorithmName {
    }
}

