/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.net.NetworkUtils;
import android.os.Parcel;
import android.os.Parcelable;
import android.system.OsConstants;
import android.util.Pair;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.UnknownHostException;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class LinkAddress
implements Parcelable,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private InetAddress address;
    private int prefixLength;
    private int flags;
    private int scope;
    public static Parcelable.Creator<LinkAddress> CREATOR;

    private static final int $$robo$$android_net_LinkAddress$scopeForUnicastAddress(InetAddress addr) {
        if (addr.isAnyLocalAddress()) {
            return OsConstants.RT_SCOPE_HOST;
        }
        if (addr.isLoopbackAddress() || addr.isLinkLocalAddress()) {
            return OsConstants.RT_SCOPE_LINK;
        }
        if (!(addr instanceof Inet4Address) && addr.isSiteLocalAddress()) {
            return OsConstants.RT_SCOPE_SITE;
        }
        return OsConstants.RT_SCOPE_UNIVERSE;
    }

    private final boolean $$robo$$android_net_LinkAddress$isIPv6ULA() {
        if (this.address != null && this.address instanceof Inet6Address) {
            byte[] bytes = this.address.getAddress();
            return (bytes[0] & 0xFFFFFFFE) == -4;
        }
        return false;
    }

    private final void $$robo$$android_net_LinkAddress$init(InetAddress address, int prefixLength, int flags, int scope) {
        if (address == null || address.isMulticastAddress() || prefixLength < 0 || address instanceof Inet4Address && prefixLength > 32 || prefixLength > 128) {
            throw new IllegalArgumentException("Bad LinkAddress params " + address + "/" + prefixLength);
        }
        this.address = address;
        this.prefixLength = prefixLength;
        this.flags = flags;
        this.scope = scope;
    }

    private void $$robo$$android_net_LinkAddress$__constructor__(InetAddress address, int prefixLength, int flags, int scope) {
        this.init(address, prefixLength, flags, scope);
    }

    private void $$robo$$android_net_LinkAddress$__constructor__(InetAddress address, int prefixLength) {
        this.scope = LinkAddress.scopeForUnicastAddress(address);
    }

    private void $$robo$$android_net_LinkAddress$__constructor__(InterfaceAddress interfaceAddress) {
    }

    private void $$robo$$android_net_LinkAddress$__constructor__(String address) {
        this.scope = LinkAddress.scopeForUnicastAddress(this.address);
    }

    private void $$robo$$android_net_LinkAddress$__constructor__(String address, int flags, int scope) {
        Pair<InetAddress, Integer> ipAndMask = NetworkUtils.parseIpAndMask(address);
        this.init((InetAddress)ipAndMask.first, (Integer)ipAndMask.second, flags, scope);
    }

    private final String $$robo$$android_net_LinkAddress$toString() {
        return this.address.getHostAddress() + "/" + this.prefixLength;
    }

    private final boolean $$robo$$android_net_LinkAddress$equals(Object obj) {
        if (!(obj instanceof LinkAddress)) {
            return false;
        }
        LinkAddress linkAddress = (LinkAddress)obj;
        return this.address.equals(linkAddress.address) && this.prefixLength == linkAddress.prefixLength && this.flags == linkAddress.flags && this.scope == linkAddress.scope;
    }

    private final int $$robo$$android_net_LinkAddress$hashCode() {
        return this.address.hashCode() + 11 * this.prefixLength + 19 * this.flags + 43 * this.scope;
    }

    private final boolean $$robo$$android_net_LinkAddress$isSameAddressAs(LinkAddress other) {
        return this.address.equals(other.address) && this.prefixLength == other.prefixLength;
    }

    private final InetAddress $$robo$$android_net_LinkAddress$getAddress() {
        return this.address;
    }

    private final int $$robo$$android_net_LinkAddress$getPrefixLength() {
        return this.prefixLength;
    }

    private final int $$robo$$android_net_LinkAddress$getNetworkPrefixLength() {
        return this.getPrefixLength();
    }

    private final int $$robo$$android_net_LinkAddress$getFlags() {
        return this.flags;
    }

    private final int $$robo$$android_net_LinkAddress$getScope() {
        return this.scope;
    }

    private final boolean $$robo$$android_net_LinkAddress$isGlobalPreferred() {
        return this.scope == OsConstants.RT_SCOPE_UNIVERSE && !this.isIPv6ULA() && (long)(this.flags & (OsConstants.IFA_F_DADFAILED | OsConstants.IFA_F_DEPRECATED)) == 0L && ((long)(this.flags & OsConstants.IFA_F_TENTATIVE) == 0L || (long)(this.flags & OsConstants.IFA_F_OPTIMISTIC) != 0L);
    }

    private final int $$robo$$android_net_LinkAddress$describeContents() {
        return 0;
    }

    private final void $$robo$$android_net_LinkAddress$writeToParcel(Parcel dest, int flags) {
        dest.writeByteArray(this.address.getAddress());
        dest.writeInt(this.prefixLength);
        dest.writeInt(this.flags);
        dest.writeInt(this.scope);
    }

    static void __staticInitializer__() {
        CREATOR = new Parcelable.Creator<LinkAddress>(){
            public /* synthetic */ Object __robo_data__;

            private void $$robo$$android_net_LinkAddress_1$__constructor__() {
            }

            private final LinkAddress $$robo$$android_net_LinkAddress_1$createFromParcel(Parcel in) {
                InetAddress address = null;
                try {
                    address = InetAddress.getByAddress(in.createByteArray());
                }
                catch (UnknownHostException unknownHostException) {
                    // empty catch block
                }
                int prefixLength = in.readInt();
                int flags = in.readInt();
                int scope = in.readInt();
                return new LinkAddress(address, prefixLength, flags, scope);
            }

            private final LinkAddress[] $$robo$$android_net_LinkAddress_1$newArray(int size) {
                return new LinkAddress[size];
            }

            private void __constructor__() {
                this.$$robo$$android_net_LinkAddress_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_LinkAddress_1$__constructor__(), this);
            }

            @Override
            public LinkAddress createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_net_LinkAddress_1$createFromParcel(android.os.Parcel ), this, parcel);
            }

            public LinkAddress[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_net_LinkAddress_1$newArray(int ), this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    static int scopeForUnicastAddress(InetAddress inetAddress) {
        return (int)InvokeDynamicSupport.bootstrapStatic("scopeForUnicastAddress", $$robo$$android_net_LinkAddress$scopeForUnicastAddress(java.net.InetAddress ), (InetAddress)inetAddress);
    }

    private boolean isIPv6ULA() {
        return (boolean)InvokeDynamicSupport.bootstrap("isIPv6ULA", $$robo$$android_net_LinkAddress$isIPv6ULA(), this);
    }

    private void init(InetAddress inetAddress, int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrap("init", $$robo$$android_net_LinkAddress$init(java.net.InetAddress int int int ), this, inetAddress, n, n2, n3);
    }

    private void __constructor__(InetAddress inetAddress, int n, int n2, int n3) {
        this.$$robo$$android_net_LinkAddress$__constructor__(inetAddress, n, n2, n3);
    }

    public LinkAddress(InetAddress inetAddress, int n, int n2, int n3) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_LinkAddress$__constructor__(java.net.InetAddress int int int ), this, inetAddress, n, n2, n3);
    }

    private void __constructor__(InetAddress inetAddress, int n) {
        this.$$robo$$android_net_LinkAddress$__constructor__(inetAddress, n);
    }

    public LinkAddress(InetAddress inetAddress, int n) {
        this(inetAddress, n, 0, 0);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_LinkAddress$__constructor__(java.net.InetAddress int ), this, inetAddress, n);
    }

    private void __constructor__(InterfaceAddress interfaceAddress) {
        this.$$robo$$android_net_LinkAddress$__constructor__(interfaceAddress);
    }

    public LinkAddress(InterfaceAddress interfaceAddress) {
        this(interfaceAddress.getAddress(), interfaceAddress.getNetworkPrefixLength());
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_LinkAddress$__constructor__(java.net.InterfaceAddress ), this, interfaceAddress);
    }

    private void __constructor__(String string2) {
        this.$$robo$$android_net_LinkAddress$__constructor__(string2);
    }

    public LinkAddress(String string2) {
        this(string2, 0, 0);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_LinkAddress$__constructor__(java.lang.String ), this, string2);
    }

    private void __constructor__(String string2, int n, int n2) {
        this.$$robo$$android_net_LinkAddress$__constructor__(string2, n, n2);
    }

    public LinkAddress(String string2, int n, int n2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_LinkAddress$__constructor__(java.lang.String int int ), this, string2, n, n2);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_net_LinkAddress$toString(), this);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_net_LinkAddress$equals(java.lang.Object ), this, object);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_net_LinkAddress$hashCode(), this);
    }

    public boolean isSameAddressAs(LinkAddress linkAddress) {
        return (boolean)InvokeDynamicSupport.bootstrap("isSameAddressAs", $$robo$$android_net_LinkAddress$isSameAddressAs(android.net.LinkAddress ), this, linkAddress);
    }

    public InetAddress getAddress() {
        return InvokeDynamicSupport.bootstrap("getAddress", $$robo$$android_net_LinkAddress$getAddress(), this);
    }

    public int getPrefixLength() {
        return (int)InvokeDynamicSupport.bootstrap("getPrefixLength", $$robo$$android_net_LinkAddress$getPrefixLength(), this);
    }

    public int getNetworkPrefixLength() {
        return (int)InvokeDynamicSupport.bootstrap("getNetworkPrefixLength", $$robo$$android_net_LinkAddress$getNetworkPrefixLength(), this);
    }

    public int getFlags() {
        return (int)InvokeDynamicSupport.bootstrap("getFlags", $$robo$$android_net_LinkAddress$getFlags(), this);
    }

    public int getScope() {
        return (int)InvokeDynamicSupport.bootstrap("getScope", $$robo$$android_net_LinkAddress$getScope(), this);
    }

    public boolean isGlobalPreferred() {
        return (boolean)InvokeDynamicSupport.bootstrap("isGlobalPreferred", $$robo$$android_net_LinkAddress$isGlobalPreferred(), this);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_net_LinkAddress$describeContents(), this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_net_LinkAddress$writeToParcel(android.os.Parcel int ), this, parcel, n);
    }

    static {
        RobolectricInternals.classInitializing(LinkAddress.class);
    }

    public /* synthetic */ LinkAddress() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LinkAddress)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

