/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.net.ConnectivityManager;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.errorprone.annotations.DoNotMock;
import java.util.EnumMap;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class NetworkInfo
implements Parcelable,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static EnumMap<DetailedState, State> stateMap;
    private int mNetworkType;
    private int mSubtype;
    private String mTypeName;
    private String mSubtypeName;
    private State mState;
    private DetailedState mDetailedState;
    private String mReason;
    private String mExtraInfo;
    private boolean mIsFailover;
    private boolean mIsAvailable;
    private boolean mIsRoaming;
    private boolean mIsMetered;
    public static Parcelable.Creator<NetworkInfo> CREATOR;

    private void $$robo$$android_net_NetworkInfo$__constructor__(int type, int subtype, String typeName, String subtypeName) {
        if (!ConnectivityManager.isNetworkTypeValid(type)) {
            throw new IllegalArgumentException("Invalid network type: " + type);
        }
        this.mNetworkType = type;
        this.mSubtype = subtype;
        this.mTypeName = typeName;
        this.mSubtypeName = subtypeName;
        this.setDetailedState(DetailedState.IDLE, null, null);
        this.mState = State.UNKNOWN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void $$robo$$android_net_NetworkInfo$__constructor__(NetworkInfo source) {
        if (source != null) {
            NetworkInfo networkInfo = source;
            synchronized (networkInfo) {
                this.mNetworkType = source.mNetworkType;
                this.mSubtype = source.mSubtype;
                this.mTypeName = source.mTypeName;
                this.mSubtypeName = source.mSubtypeName;
                this.mState = source.mState;
                this.mDetailedState = source.mDetailedState;
                this.mReason = source.mReason;
                this.mExtraInfo = source.mExtraInfo;
                this.mIsFailover = source.mIsFailover;
                this.mIsAvailable = source.mIsAvailable;
                this.mIsRoaming = source.mIsRoaming;
                this.mIsMetered = source.mIsMetered;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_net_NetworkInfo$getType() {
        NetworkInfo networkInfo = this;
        synchronized (networkInfo) {
            return this.mNetworkType;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_net_NetworkInfo$setType(int type) {
        NetworkInfo networkInfo = this;
        synchronized (networkInfo) {
            this.mNetworkType = type;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_net_NetworkInfo$getSubtype() {
        NetworkInfo networkInfo = this;
        synchronized (networkInfo) {
            return this.mSubtype;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_net_NetworkInfo$setSubtype(int subtype, String subtypeName) {
        NetworkInfo networkInfo = this;
        synchronized (networkInfo) {
            this.mSubtype = subtype;
            this.mSubtypeName = subtypeName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String $$robo$$android_net_NetworkInfo$getTypeName() {
        NetworkInfo networkInfo = this;
        synchronized (networkInfo) {
            return this.mTypeName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String $$robo$$android_net_NetworkInfo$getSubtypeName() {
        NetworkInfo networkInfo = this;
        synchronized (networkInfo) {
            return this.mSubtypeName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_net_NetworkInfo$isConnectedOrConnecting() {
        NetworkInfo networkInfo = this;
        synchronized (networkInfo) {
            return this.mState == State.CONNECTED || this.mState == State.CONNECTING;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_net_NetworkInfo$isConnected() {
        NetworkInfo networkInfo = this;
        synchronized (networkInfo) {
            return this.mState == State.CONNECTED;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_net_NetworkInfo$isAvailable() {
        NetworkInfo networkInfo = this;
        synchronized (networkInfo) {
            return this.mIsAvailable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_net_NetworkInfo$setIsAvailable(boolean isAvailable) {
        NetworkInfo networkInfo = this;
        synchronized (networkInfo) {
            this.mIsAvailable = isAvailable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_net_NetworkInfo$isFailover() {
        NetworkInfo networkInfo = this;
        synchronized (networkInfo) {
            return this.mIsFailover;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_net_NetworkInfo$setFailover(boolean isFailover) {
        NetworkInfo networkInfo = this;
        synchronized (networkInfo) {
            this.mIsFailover = isFailover;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_net_NetworkInfo$isRoaming() {
        NetworkInfo networkInfo = this;
        synchronized (networkInfo) {
            return this.mIsRoaming;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_net_NetworkInfo$setRoaming(boolean isRoaming) {
        NetworkInfo networkInfo = this;
        synchronized (networkInfo) {
            this.mIsRoaming = isRoaming;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_net_NetworkInfo$isMetered() {
        NetworkInfo networkInfo = this;
        synchronized (networkInfo) {
            return this.mIsMetered;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_net_NetworkInfo$setMetered(boolean isMetered) {
        NetworkInfo networkInfo = this;
        synchronized (networkInfo) {
            this.mIsMetered = isMetered;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final State $$robo$$android_net_NetworkInfo$getState() {
        NetworkInfo networkInfo = this;
        synchronized (networkInfo) {
            return this.mState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final DetailedState $$robo$$android_net_NetworkInfo$getDetailedState() {
        NetworkInfo networkInfo = this;
        synchronized (networkInfo) {
            return this.mDetailedState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_net_NetworkInfo$setDetailedState(DetailedState detailedState, String reason, String extraInfo) {
        NetworkInfo networkInfo = this;
        synchronized (networkInfo) {
            this.mDetailedState = detailedState;
            this.mState = stateMap.get((Object)detailedState);
            this.mReason = reason;
            this.mExtraInfo = extraInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_net_NetworkInfo$setExtraInfo(String extraInfo) {
        NetworkInfo networkInfo = this;
        synchronized (networkInfo) {
            this.mExtraInfo = extraInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String $$robo$$android_net_NetworkInfo$getReason() {
        NetworkInfo networkInfo = this;
        synchronized (networkInfo) {
            return this.mReason;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String $$robo$$android_net_NetworkInfo$getExtraInfo() {
        NetworkInfo networkInfo = this;
        synchronized (networkInfo) {
            return this.mExtraInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String $$robo$$android_net_NetworkInfo$toString() {
        NetworkInfo networkInfo = this;
        synchronized (networkInfo) {
            StringBuilder builder = new StringBuilder("[");
            builder.append("type: ").append(this.getTypeName()).append("[").append(this.getSubtypeName()).append("], state: ").append((Object)this.mState).append("/").append((Object)this.mDetailedState).append(", reason: ").append(this.mReason == null ? "(unspecified)" : this.mReason).append(", extra: ").append(this.mExtraInfo == null ? "(none)" : this.mExtraInfo).append(", failover: ").append(this.mIsFailover).append(", available: ").append(this.mIsAvailable).append(", roaming: ").append(this.mIsRoaming).append(", metered: ").append(this.mIsMetered).append("]");
            return builder.toString();
        }
    }

    private final int $$robo$$android_net_NetworkInfo$describeContents() {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_net_NetworkInfo$writeToParcel(Parcel dest, int flags) {
        NetworkInfo networkInfo = this;
        synchronized (networkInfo) {
            dest.writeInt(this.mNetworkType);
            dest.writeInt(this.mSubtype);
            dest.writeString(this.mTypeName);
            dest.writeString(this.mSubtypeName);
            dest.writeString(this.mState.name());
            dest.writeString(this.mDetailedState.name());
            dest.writeInt(this.mIsFailover ? 1 : 0);
            dest.writeInt(this.mIsAvailable ? 1 : 0);
            dest.writeInt(this.mIsRoaming ? 1 : 0);
            dest.writeInt(this.mIsMetered ? 1 : 0);
            dest.writeString(this.mReason);
            dest.writeString(this.mExtraInfo);
        }
    }

    static void __staticInitializer__() {
        stateMap = new EnumMap(DetailedState.class);
        stateMap.put(DetailedState.IDLE, State.DISCONNECTED);
        stateMap.put(DetailedState.SCANNING, State.DISCONNECTED);
        stateMap.put(DetailedState.CONNECTING, State.CONNECTING);
        stateMap.put(DetailedState.AUTHENTICATING, State.CONNECTING);
        stateMap.put(DetailedState.OBTAINING_IPADDR, State.CONNECTING);
        stateMap.put(DetailedState.VERIFYING_POOR_LINK, State.CONNECTING);
        stateMap.put(DetailedState.CAPTIVE_PORTAL_CHECK, State.CONNECTING);
        stateMap.put(DetailedState.CONNECTED, State.CONNECTED);
        stateMap.put(DetailedState.SUSPENDED, State.SUSPENDED);
        stateMap.put(DetailedState.DISCONNECTING, State.DISCONNECTING);
        stateMap.put(DetailedState.DISCONNECTED, State.DISCONNECTED);
        stateMap.put(DetailedState.FAILED, State.DISCONNECTED);
        stateMap.put(DetailedState.BLOCKED, State.DISCONNECTED);
        CREATOR = new Parcelable.Creator<NetworkInfo>(){
            public /* synthetic */ Object __robo_data__;

            private void $$robo$$android_net_NetworkInfo_1$__constructor__() {
            }

            private final NetworkInfo $$robo$$android_net_NetworkInfo_1$createFromParcel(Parcel in) {
                int netType = in.readInt();
                int subtype = in.readInt();
                String typeName = in.readString();
                String subtypeName = in.readString();
                NetworkInfo netInfo = new NetworkInfo(netType, subtype, typeName, subtypeName);
                netInfo.mState = State.valueOf(in.readString());
                netInfo.mDetailedState = DetailedState.valueOf(in.readString());
                netInfo.mIsFailover = in.readInt() != 0;
                netInfo.mIsAvailable = in.readInt() != 0;
                netInfo.mIsRoaming = in.readInt() != 0;
                netInfo.mIsMetered = in.readInt() != 0;
                netInfo.mReason = in.readString();
                netInfo.mExtraInfo = in.readString();
                return netInfo;
            }

            private final NetworkInfo[] $$robo$$android_net_NetworkInfo_1$newArray(int size) {
                return new NetworkInfo[size];
            }

            private void __constructor__() {
                this.$$robo$$android_net_NetworkInfo_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_NetworkInfo_1$__constructor__(), this);
            }

            @Override
            public NetworkInfo createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_net_NetworkInfo_1$createFromParcel(android.os.Parcel ), this, parcel);
            }

            public NetworkInfo[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_net_NetworkInfo_1$newArray(int ), this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__(int n, int n2, String string2, String string3) {
        this.$$robo$$android_net_NetworkInfo$__constructor__(n, n2, string2, string3);
    }

    public NetworkInfo(int n, int n2, String string2, String string3) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_NetworkInfo$__constructor__(int int java.lang.String java.lang.String ), this, n, n2, string2, string3);
    }

    private void __constructor__(NetworkInfo networkInfo) {
        this.$$robo$$android_net_NetworkInfo$__constructor__(networkInfo);
    }

    public NetworkInfo(NetworkInfo networkInfo) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_NetworkInfo$__constructor__(android.net.NetworkInfo ), this, networkInfo);
    }

    public int getType() {
        return (int)InvokeDynamicSupport.bootstrap("getType", $$robo$$android_net_NetworkInfo$getType(), this);
    }

    public void setType(int n) {
        InvokeDynamicSupport.bootstrap("setType", $$robo$$android_net_NetworkInfo$setType(int ), this, n);
    }

    public int getSubtype() {
        return (int)InvokeDynamicSupport.bootstrap("getSubtype", $$robo$$android_net_NetworkInfo$getSubtype(), this);
    }

    public void setSubtype(int n, String string2) {
        InvokeDynamicSupport.bootstrap("setSubtype", $$robo$$android_net_NetworkInfo$setSubtype(int java.lang.String ), this, n, string2);
    }

    public String getTypeName() {
        return InvokeDynamicSupport.bootstrap("getTypeName", $$robo$$android_net_NetworkInfo$getTypeName(), this);
    }

    public String getSubtypeName() {
        return InvokeDynamicSupport.bootstrap("getSubtypeName", $$robo$$android_net_NetworkInfo$getSubtypeName(), this);
    }

    public boolean isConnectedOrConnecting() {
        return (boolean)InvokeDynamicSupport.bootstrap("isConnectedOrConnecting", $$robo$$android_net_NetworkInfo$isConnectedOrConnecting(), this);
    }

    public boolean isConnected() {
        return (boolean)InvokeDynamicSupport.bootstrap("isConnected", $$robo$$android_net_NetworkInfo$isConnected(), this);
    }

    public boolean isAvailable() {
        return (boolean)InvokeDynamicSupport.bootstrap("isAvailable", $$robo$$android_net_NetworkInfo$isAvailable(), this);
    }

    public void setIsAvailable(boolean bl) {
        InvokeDynamicSupport.bootstrap("setIsAvailable", $$robo$$android_net_NetworkInfo$setIsAvailable(boolean ), this, bl);
    }

    public boolean isFailover() {
        return (boolean)InvokeDynamicSupport.bootstrap("isFailover", $$robo$$android_net_NetworkInfo$isFailover(), this);
    }

    public void setFailover(boolean bl) {
        InvokeDynamicSupport.bootstrap("setFailover", $$robo$$android_net_NetworkInfo$setFailover(boolean ), this, bl);
    }

    public boolean isRoaming() {
        return (boolean)InvokeDynamicSupport.bootstrap("isRoaming", $$robo$$android_net_NetworkInfo$isRoaming(), this);
    }

    public void setRoaming(boolean bl) {
        InvokeDynamicSupport.bootstrap("setRoaming", $$robo$$android_net_NetworkInfo$setRoaming(boolean ), this, bl);
    }

    public boolean isMetered() {
        return (boolean)InvokeDynamicSupport.bootstrap("isMetered", $$robo$$android_net_NetworkInfo$isMetered(), this);
    }

    public void setMetered(boolean bl) {
        InvokeDynamicSupport.bootstrap("setMetered", $$robo$$android_net_NetworkInfo$setMetered(boolean ), this, bl);
    }

    public State getState() {
        return InvokeDynamicSupport.bootstrap("getState", $$robo$$android_net_NetworkInfo$getState(), this);
    }

    public DetailedState getDetailedState() {
        return InvokeDynamicSupport.bootstrap("getDetailedState", $$robo$$android_net_NetworkInfo$getDetailedState(), this);
    }

    public void setDetailedState(DetailedState detailedState, String string2, String string3) {
        InvokeDynamicSupport.bootstrap("setDetailedState", $$robo$$android_net_NetworkInfo$setDetailedState(android.net.NetworkInfo$DetailedState java.lang.String java.lang.String ), this, detailedState, string2, string3);
    }

    public void setExtraInfo(String string2) {
        InvokeDynamicSupport.bootstrap("setExtraInfo", $$robo$$android_net_NetworkInfo$setExtraInfo(java.lang.String ), this, string2);
    }

    public String getReason() {
        return InvokeDynamicSupport.bootstrap("getReason", $$robo$$android_net_NetworkInfo$getReason(), this);
    }

    public String getExtraInfo() {
        return InvokeDynamicSupport.bootstrap("getExtraInfo", $$robo$$android_net_NetworkInfo$getExtraInfo(), this);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_net_NetworkInfo$toString(), this);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_net_NetworkInfo$describeContents(), this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_net_NetworkInfo$writeToParcel(android.os.Parcel int ), this, parcel, n);
    }

    static {
        RobolectricInternals.classInitializing(NetworkInfo.class);
    }

    public /* synthetic */ NetworkInfo() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NetworkInfo)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class DetailedState
    extends Enum<DetailedState> {
        public /* synthetic */ Object __robo_data__;
        public static /* enum */ DetailedState IDLE;
        public static /* enum */ DetailedState SCANNING;
        public static /* enum */ DetailedState CONNECTING;
        public static /* enum */ DetailedState AUTHENTICATING;
        public static /* enum */ DetailedState OBTAINING_IPADDR;
        public static /* enum */ DetailedState CONNECTED;
        public static /* enum */ DetailedState SUSPENDED;
        public static /* enum */ DetailedState DISCONNECTING;
        public static /* enum */ DetailedState DISCONNECTED;
        public static /* enum */ DetailedState FAILED;
        public static /* enum */ DetailedState BLOCKED;
        public static /* enum */ DetailedState VERIFYING_POOR_LINK;
        public static /* enum */ DetailedState CAPTIVE_PORTAL_CHECK;
        private static /* synthetic */ DetailedState[] $VALUES;

        private static final DetailedState[] $$robo$$android_net_NetworkInfo_DetailedState$values() {
            return (DetailedState[])$VALUES.clone();
        }

        private static final DetailedState $$robo$$android_net_NetworkInfo_DetailedState$valueOf(String name) {
            return Enum.valueOf(DetailedState.class, name);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void $$robo$$android_net_NetworkInfo_DetailedState$__constructor__(String string2, int n) {
        }

        static void __staticInitializer__() {
            IDLE = new DetailedState();
            SCANNING = new DetailedState();
            CONNECTING = new DetailedState();
            AUTHENTICATING = new DetailedState();
            OBTAINING_IPADDR = new DetailedState();
            CONNECTED = new DetailedState();
            SUSPENDED = new DetailedState();
            DISCONNECTING = new DetailedState();
            DISCONNECTED = new DetailedState();
            FAILED = new DetailedState();
            BLOCKED = new DetailedState();
            VERIFYING_POOR_LINK = new DetailedState();
            CAPTIVE_PORTAL_CHECK = new DetailedState();
            $VALUES = new DetailedState[]{IDLE, SCANNING, CONNECTING, AUTHENTICATING, OBTAINING_IPADDR, CONNECTED, SUSPENDED, DISCONNECTING, DISCONNECTED, FAILED, BLOCKED, VERIFYING_POOR_LINK, CAPTIVE_PORTAL_CHECK};
        }

        public static DetailedState[] values() {
            return InvokeDynamicSupport.bootstrapStatic("values", $$robo$$android_net_NetworkInfo_DetailedState$values());
        }

        public static DetailedState valueOf(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$android_net_NetworkInfo_DetailedState$valueOf(java.lang.String ), (String)string2);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void __constructor__(String string2, int n) {
            this.$$robo$$android_net_NetworkInfo_DetailedState$__constructor__(string2, n);
        }

        public DetailedState() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_NetworkInfo_DetailedState$__constructor__(java.lang.String int ), this, string2, n);
        }

        static {
            RobolectricInternals.classInitializing(DetailedState.class);
        }

        public /* synthetic */ DetailedState() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DetailedState)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class State
    extends Enum<State> {
        public /* synthetic */ Object __robo_data__;
        public static /* enum */ State CONNECTING;
        public static /* enum */ State CONNECTED;
        public static /* enum */ State SUSPENDED;
        public static /* enum */ State DISCONNECTING;
        public static /* enum */ State DISCONNECTED;
        public static /* enum */ State UNKNOWN;
        private static /* synthetic */ State[] $VALUES;

        private static final State[] $$robo$$android_net_NetworkInfo_State$values() {
            return (State[])$VALUES.clone();
        }

        private static final State $$robo$$android_net_NetworkInfo_State$valueOf(String name) {
            return Enum.valueOf(State.class, name);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void $$robo$$android_net_NetworkInfo_State$__constructor__(String string2, int n) {
        }

        static void __staticInitializer__() {
            CONNECTING = new State();
            CONNECTED = new State();
            SUSPENDED = new State();
            DISCONNECTING = new State();
            DISCONNECTED = new State();
            UNKNOWN = new State();
            $VALUES = new State[]{CONNECTING, CONNECTED, SUSPENDED, DISCONNECTING, DISCONNECTED, UNKNOWN};
        }

        public static State[] values() {
            return InvokeDynamicSupport.bootstrapStatic("values", $$robo$$android_net_NetworkInfo_State$values());
        }

        public static State valueOf(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$android_net_NetworkInfo_State$valueOf(java.lang.String ), (String)string2);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void __constructor__(String string2, int n) {
            this.$$robo$$android_net_NetworkInfo_State$__constructor__(string2, n);
        }

        public State() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_NetworkInfo_State$__constructor__(java.lang.String int ), this, string2, n);
        }

        static {
            RobolectricInternals.classInitializing(State.class);
        }

        public /* synthetic */ State() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (State)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

