/*
 * Decompiled with CFR 0.152.
 */
package android.net.dhcp;

import android.content.Context;
import android.net.DhcpResults;
import android.net.NetworkUtils;
import android.net.TrafficStats;
import android.net.dhcp.DhcpAckPacket;
import android.net.dhcp.DhcpNakPacket;
import android.net.dhcp.DhcpOfferPacket;
import android.net.dhcp.DhcpPacket;
import android.net.metrics.DhcpClientEvent;
import android.net.metrics.DhcpErrorEvent;
import android.net.metrics.IpConnectivityLog;
import android.os.Message;
import android.os.Parcelable;
import android.os.SystemClock;
import android.system.ErrnoException;
import android.system.Os;
import android.system.OsConstants;
import android.system.PacketSocketAddress;
import android.util.EventLog;
import android.util.Log;
import android.util.SparseArray;
import android.util.TimeUtils;
import com.android.internal.util.HexDump;
import com.android.internal.util.MessageUtils;
import com.android.internal.util.State;
import com.android.internal.util.StateMachine;
import com.android.internal.util.WakeupMessage;
import java.io.FileDescriptor;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Random;
import libcore.io.IoBridge;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class DhcpClient
extends StateMachine
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "DhcpClient";
    private static boolean DBG = true;
    private static boolean STATE_DBG = false;
    private static boolean MSG_DBG = false;
    private static boolean PACKET_DBG = false;
    private static int SECONDS = 1000;
    private static int FIRST_TIMEOUT_MS = 2000;
    private static int MAX_TIMEOUT_MS = 128000;
    private static int DHCP_TIMEOUT_MS = 36000;
    private static int PUBLIC_BASE = 196608;
    public static int CMD_START_DHCP = 196609;
    public static int CMD_STOP_DHCP = 196610;
    public static int CMD_PRE_DHCP_ACTION = 196611;
    public static int CMD_POST_DHCP_ACTION = 196612;
    public static int CMD_ON_QUIT = 196613;
    public static int CMD_PRE_DHCP_ACTION_COMPLETE = 196614;
    public static int CMD_CLEAR_LINKADDRESS = 196615;
    public static int CMD_CONFIGURE_LINKADDRESS = 196616;
    public static int EVENT_LINKADDRESS_CONFIGURED = 196617;
    public static int DHCP_SUCCESS = 1;
    public static int DHCP_FAILURE = 2;
    private static int PRIVATE_BASE = 196708;
    private static int CMD_KICK = 196709;
    private static int CMD_RECEIVED_PACKET = 196710;
    private static int CMD_TIMEOUT = 196711;
    private static int CMD_RENEW_DHCP = 196712;
    private static int CMD_REBIND_DHCP = 196713;
    private static int CMD_EXPIRE_DHCP = 196714;
    private static Class[] sMessageClasses;
    private static SparseArray<String> sMessageNames;
    static byte[] REQUESTED_PARAMS;
    private static boolean DO_UNICAST = false;
    private Context mContext;
    private Random mRandom;
    private IpConnectivityLog mMetricsLog;
    private FileDescriptor mPacketSock;
    private FileDescriptor mUdpSock;
    private ReceiveThread mReceiveThread;
    private StateMachine mController;
    private WakeupMessage mKickAlarm;
    private WakeupMessage mTimeoutAlarm;
    private WakeupMessage mRenewAlarm;
    private WakeupMessage mRebindAlarm;
    private WakeupMessage mExpiryAlarm;
    private String mIfaceName;
    private boolean mRegisteredForPreDhcpNotification;
    private NetworkInterface mIface;
    private byte[] mHwAddr;
    private PacketSocketAddress mInterfaceBroadcastAddr;
    private int mTransactionId;
    private long mTransactionStartMillis;
    private DhcpResults mDhcpLease;
    private long mDhcpLeaseExpiry;
    private DhcpResults mOffer;
    private long mLastInitEnterTime;
    private long mLastBoundExitTime;
    private State mStoppedState;
    private State mDhcpState;
    private State mDhcpInitState;
    private State mDhcpSelectingState;
    private State mDhcpRequestingState;
    private State mDhcpHaveLeaseState;
    private State mConfiguringInterfaceState;
    private State mDhcpBoundState;
    private State mDhcpRenewingState;
    private State mDhcpRebindingState;
    private State mDhcpInitRebootState;
    private State mDhcpRebootingState;
    private State mWaitBeforeStartState;
    private State mWaitBeforeRenewalState;

    private final WakeupMessage $$robo$$android_net_dhcp_DhcpClient$makeWakeupMessage(String cmdName, int cmd) {
        cmdName = DhcpClient.class.getSimpleName() + "." + this.mIfaceName + "." + cmdName;
        return new WakeupMessage(this.mContext, this.getHandler(), cmdName, cmd);
    }

    private void $$robo$$android_net_dhcp_DhcpClient$__constructor__(Context context, StateMachine controller, String iface) {
        this.mMetricsLog = new IpConnectivityLog();
        this.mStoppedState = new StoppedState(this);
        this.mDhcpState = new DhcpState(this);
        this.mDhcpInitState = new DhcpInitState(this);
        this.mDhcpSelectingState = new DhcpSelectingState(this);
        this.mDhcpRequestingState = new DhcpRequestingState(this);
        this.mDhcpHaveLeaseState = new DhcpHaveLeaseState(this);
        this.mConfiguringInterfaceState = new ConfiguringInterfaceState(this);
        this.mDhcpBoundState = new DhcpBoundState(this);
        this.mDhcpRenewingState = new DhcpRenewingState(this);
        this.mDhcpRebindingState = new DhcpRebindingState(this);
        this.mDhcpInitRebootState = new DhcpInitRebootState(this);
        this.mDhcpRebootingState = new DhcpRebootingState(this);
        this.mWaitBeforeStartState = new WaitBeforeStartState(this, this.mDhcpInitState);
        this.mWaitBeforeRenewalState = new WaitBeforeRenewalState(this, this.mDhcpRenewingState);
        this.mContext = context;
        this.mController = controller;
        this.mIfaceName = iface;
        this.addState(this.mStoppedState);
        this.addState(this.mDhcpState);
        this.addState(this.mDhcpInitState, this.mDhcpState);
        this.addState(this.mWaitBeforeStartState, this.mDhcpState);
        this.addState(this.mDhcpSelectingState, this.mDhcpState);
        this.addState(this.mDhcpRequestingState, this.mDhcpState);
        this.addState(this.mDhcpHaveLeaseState, this.mDhcpState);
        this.addState(this.mConfiguringInterfaceState, this.mDhcpHaveLeaseState);
        this.addState(this.mDhcpBoundState, this.mDhcpHaveLeaseState);
        this.addState(this.mWaitBeforeRenewalState, this.mDhcpHaveLeaseState);
        this.addState(this.mDhcpRenewingState, this.mDhcpHaveLeaseState);
        this.addState(this.mDhcpRebindingState, this.mDhcpHaveLeaseState);
        this.addState(this.mDhcpInitRebootState, this.mDhcpState);
        this.addState(this.mDhcpRebootingState, this.mDhcpState);
        this.setInitialState(this.mStoppedState);
        this.mRandom = new Random();
        this.mKickAlarm = this.makeWakeupMessage("KICK", 196709);
        this.mTimeoutAlarm = this.makeWakeupMessage("TIMEOUT", 196711);
        this.mRenewAlarm = this.makeWakeupMessage("RENEW", 196712);
        this.mRebindAlarm = this.makeWakeupMessage("REBIND", 196713);
        this.mExpiryAlarm = this.makeWakeupMessage("EXPIRY", 196714);
    }

    private final void $$robo$$android_net_dhcp_DhcpClient$registerForPreDhcpNotification() {
        this.mRegisteredForPreDhcpNotification = true;
    }

    private static final DhcpClient $$robo$$android_net_dhcp_DhcpClient$makeDhcpClient(Context context, StateMachine controller, String intf) {
        DhcpClient client = new DhcpClient(context, controller, intf);
        client.start();
        return client;
    }

    private final boolean $$robo$$android_net_dhcp_DhcpClient$initInterface() {
        try {
            this.mIface = NetworkInterface.getByName(this.mIfaceName);
            this.mHwAddr = this.mIface.getHardwareAddress();
            this.mInterfaceBroadcastAddr = new PacketSocketAddress(this.mIface.getIndex(), DhcpPacket.ETHER_BROADCAST);
            return true;
        }
        catch (NullPointerException | SocketException e) {
            Log.e("DhcpClient", "Can't determine ifindex or MAC address for " + this.mIfaceName, e);
            return false;
        }
    }

    private final void $$robo$$android_net_dhcp_DhcpClient$startNewTransaction() {
        this.mTransactionId = this.mRandom.nextInt();
        this.mTransactionStartMillis = SystemClock.elapsedRealtime();
    }

    private final boolean $$robo$$android_net_dhcp_DhcpClient$initSockets() {
        return this.initPacketSocket() && this.initUdpSocket();
    }

    private final boolean $$robo$$android_net_dhcp_DhcpClient$initPacketSocket() {
        try {
            this.mPacketSock = Os.socket(OsConstants.AF_PACKET, OsConstants.SOCK_RAW, OsConstants.ETH_P_IP);
            PacketSocketAddress addr = new PacketSocketAddress((short)OsConstants.ETH_P_IP, this.mIface.getIndex());
            Os.bind(this.mPacketSock, addr);
            NetworkUtils.attachDhcpFilter(this.mPacketSock);
        }
        catch (ErrnoException | SocketException e) {
            Log.e("DhcpClient", "Error creating packet socket", e);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_net_dhcp_DhcpClient$initUdpSocket() {
        int oldTag = TrafficStats.getAndSetThreadStatsTag(-251);
        try {
            this.mUdpSock = Os.socket(OsConstants.AF_INET, OsConstants.SOCK_DGRAM, OsConstants.IPPROTO_UDP);
            Os.setsockoptInt(this.mUdpSock, OsConstants.SOL_SOCKET, OsConstants.SO_REUSEADDR, 1);
            Os.setsockoptIfreq(this.mUdpSock, OsConstants.SOL_SOCKET, OsConstants.SO_BINDTODEVICE, this.mIfaceName);
            Os.setsockoptInt(this.mUdpSock, OsConstants.SOL_SOCKET, OsConstants.SO_BROADCAST, 1);
            Os.setsockoptInt(this.mUdpSock, OsConstants.SOL_SOCKET, OsConstants.SO_RCVBUF, 0);
            Os.bind(this.mUdpSock, Inet4Address.ANY, 68);
            NetworkUtils.protectFromVpn(this.mUdpSock);
        }
        catch (ErrnoException | SocketException e) {
            Log.e("DhcpClient", "Error creating UDP socket", e);
            boolean bl = false;
            return bl;
        }
        finally {
            TrafficStats.setThreadStatsTag(oldTag);
        }
        return true;
    }

    private final boolean $$robo$$android_net_dhcp_DhcpClient$connectUdpSock(Inet4Address to) {
        try {
            Os.connect(this.mUdpSock, to, 67);
            return true;
        }
        catch (ErrnoException | SocketException e) {
            Log.e("DhcpClient", "Error connecting UDP socket", e);
            return false;
        }
    }

    private static final void $$robo$$android_net_dhcp_DhcpClient$closeQuietly(FileDescriptor fd) {
        try {
            IoBridge.closeAndSignalBlockedThreads(fd);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private final void $$robo$$android_net_dhcp_DhcpClient$closeSockets() {
        DhcpClient.closeQuietly(this.mUdpSock);
        DhcpClient.closeQuietly(this.mPacketSock);
    }

    private final short $$robo$$android_net_dhcp_DhcpClient$getSecs() {
        return (short)((SystemClock.elapsedRealtime() - this.mTransactionStartMillis) / 1000L);
    }

    private final boolean $$robo$$android_net_dhcp_DhcpClient$transmitPacket(ByteBuffer buf, String description, int encap, Inet4Address to) {
        try {
            if (encap == 0) {
                Log.d("DhcpClient", "Broadcasting " + description);
                Os.sendto(this.mPacketSock, buf.array(), 0, buf.limit(), 0, this.mInterfaceBroadcastAddr);
            } else if (encap == 2 && to.equals(DhcpPacket.INADDR_BROADCAST)) {
                Log.d("DhcpClient", "Broadcasting " + description);
                Os.sendto(this.mUdpSock, buf, 0, to, 67);
            } else {
                Log.d("DhcpClient", String.format("Unicasting %s to %s", description, Os.getpeername(this.mUdpSock)));
                Os.write(this.mUdpSock, buf);
            }
        }
        catch (ErrnoException | IOException e) {
            Log.e("DhcpClient", "Can't send packet: ", e);
            return false;
        }
        return true;
    }

    private final boolean $$robo$$android_net_dhcp_DhcpClient$sendDiscoverPacket() {
        ByteBuffer packet = DhcpPacket.buildDiscoverPacket(0, this.mTransactionId, this.getSecs(), this.mHwAddr, false, REQUESTED_PARAMS);
        return this.transmitPacket(packet, "DHCPDISCOVER", 0, DhcpPacket.INADDR_BROADCAST);
    }

    private final boolean $$robo$$android_net_dhcp_DhcpClient$sendRequestPacket(Inet4Address clientAddress, Inet4Address requestedAddress, Inet4Address serverAddress, Inet4Address to) {
        int encap = DhcpPacket.INADDR_ANY.equals(clientAddress) ? 0 : 2;
        ByteBuffer packet = DhcpPacket.buildRequestPacket(encap, this.mTransactionId, this.getSecs(), clientAddress, false, this.mHwAddr, requestedAddress, serverAddress, REQUESTED_PARAMS, null);
        String serverStr = serverAddress != null ? serverAddress.getHostAddress() : null;
        String description = "DHCPREQUEST ciaddr=" + clientAddress.getHostAddress() + " request=" + requestedAddress.getHostAddress() + " serverid=" + serverStr;
        return this.transmitPacket(packet, description, encap, to);
    }

    private final void $$robo$$android_net_dhcp_DhcpClient$scheduleLeaseTimers() {
        if (this.mDhcpLeaseExpiry == 0L) {
            Log.d("DhcpClient", "Infinite lease, no timer scheduling needed");
            return;
        }
        long now = SystemClock.elapsedRealtime();
        long remainingDelay = this.mDhcpLeaseExpiry - now;
        long renewDelay = remainingDelay / 2L;
        long rebindDelay = remainingDelay * 7L / 8L;
        this.mRenewAlarm.schedule(now + renewDelay);
        this.mRebindAlarm.schedule(now + rebindDelay);
        this.mExpiryAlarm.schedule(now + remainingDelay);
        Log.d("DhcpClient", "Scheduling renewal in " + renewDelay / 1000L + "s");
        Log.d("DhcpClient", "Scheduling rebind in " + rebindDelay / 1000L + "s");
        Log.d("DhcpClient", "Scheduling expiry in " + remainingDelay / 1000L + "s");
    }

    private final void $$robo$$android_net_dhcp_DhcpClient$notifySuccess() {
        this.mController.sendMessage(196612, 1, 0, new DhcpResults(this.mDhcpLease));
    }

    private final void $$robo$$android_net_dhcp_DhcpClient$notifyFailure() {
        this.mController.sendMessage(196612, 2, 0, null);
    }

    private final void $$robo$$android_net_dhcp_DhcpClient$acceptDhcpResults(DhcpResults results, String msg) {
        this.mDhcpLease = results;
        this.mOffer = null;
        Log.d("DhcpClient", msg + " lease: " + this.mDhcpLease);
        this.notifySuccess();
    }

    private final void $$robo$$android_net_dhcp_DhcpClient$clearDhcpState() {
        this.mDhcpLease = null;
        this.mDhcpLeaseExpiry = 0L;
        this.mOffer = null;
    }

    private final void $$robo$$android_net_dhcp_DhcpClient$doQuit() {
        Log.d("DhcpClient", "doQuit");
        this.quit();
    }

    private final void $$robo$$android_net_dhcp_DhcpClient$onQuitting() {
        Log.d("DhcpClient", "onQuitting");
        this.mController.sendMessage(196613);
    }

    private final boolean $$robo$$android_net_dhcp_DhcpClient$isValidPacket(DhcpPacket packet) {
        int xid = packet.getTransactionId();
        if (xid != this.mTransactionId) {
            Log.d("DhcpClient", "Unexpected transaction ID " + xid + ", expected " + this.mTransactionId);
            return false;
        }
        if (!Arrays.equals(packet.getClientMac(), this.mHwAddr)) {
            Log.d("DhcpClient", "MAC addr mismatch: got " + HexDump.toHexString(packet.getClientMac()) + ", expected " + HexDump.toHexString(packet.getClientMac()));
            return false;
        }
        return true;
    }

    private final void $$robo$$android_net_dhcp_DhcpClient$setDhcpLeaseExpiry(DhcpPacket packet) {
        long leaseTimeMillis = packet.getLeaseTimeMillis();
        this.mDhcpLeaseExpiry = leaseTimeMillis > 0L ? SystemClock.elapsedRealtime() + leaseTimeMillis : 0L;
    }

    private final void $$robo$$android_net_dhcp_DhcpClient$logError(int errorCode) {
        this.mMetricsLog.log(this.mIfaceName, (Parcelable)new DhcpErrorEvent(errorCode));
    }

    private final void $$robo$$android_net_dhcp_DhcpClient$logState(String name, int durationMs) {
        this.mMetricsLog.log(this.mIfaceName, (Parcelable)new DhcpClientEvent(name, durationMs));
    }

    static void __staticInitializer__() {
        sMessageClasses = new Class[]{DhcpClient.class};
        sMessageNames = MessageUtils.findMessageNames(sMessageClasses);
        REQUESTED_PARAMS = new byte[]{1, 3, 6, 15, 26, 28, 51, 58, 59, 43};
    }

    private WakeupMessage makeWakeupMessage(String string2, int n) {
        return InvokeDynamicSupport.bootstrap("makeWakeupMessage", $$robo$$android_net_dhcp_DhcpClient$makeWakeupMessage(java.lang.String int ), this, string2, n);
    }

    private void __constructor__(Context context, StateMachine stateMachine, String string2) {
        this.$$robo$$android_net_dhcp_DhcpClient$__constructor__(context, stateMachine, string2);
    }

    public DhcpClient(Context context, StateMachine stateMachine, String string2) {
        super("DhcpClient");
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_dhcp_DhcpClient$__constructor__(android.content.Context com.android.internal.util.StateMachine java.lang.String ), this, context, stateMachine, string2);
    }

    public void registerForPreDhcpNotification() {
        InvokeDynamicSupport.bootstrap("registerForPreDhcpNotification", $$robo$$android_net_dhcp_DhcpClient$registerForPreDhcpNotification(), this);
    }

    public static DhcpClient makeDhcpClient(Context context, StateMachine stateMachine, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("makeDhcpClient", $$robo$$android_net_dhcp_DhcpClient$makeDhcpClient(android.content.Context com.android.internal.util.StateMachine java.lang.String ), (Context)context, (StateMachine)stateMachine, (String)string2);
    }

    private boolean initInterface() {
        return (boolean)InvokeDynamicSupport.bootstrap("initInterface", $$robo$$android_net_dhcp_DhcpClient$initInterface(), this);
    }

    private void startNewTransaction() {
        InvokeDynamicSupport.bootstrap("startNewTransaction", $$robo$$android_net_dhcp_DhcpClient$startNewTransaction(), this);
    }

    private boolean initSockets() {
        return (boolean)InvokeDynamicSupport.bootstrap("initSockets", $$robo$$android_net_dhcp_DhcpClient$initSockets(), this);
    }

    private boolean initPacketSocket() {
        return (boolean)InvokeDynamicSupport.bootstrap("initPacketSocket", $$robo$$android_net_dhcp_DhcpClient$initPacketSocket(), this);
    }

    private boolean initUdpSocket() {
        return (boolean)InvokeDynamicSupport.bootstrap("initUdpSocket", $$robo$$android_net_dhcp_DhcpClient$initUdpSocket(), this);
    }

    private boolean connectUdpSock(Inet4Address inet4Address) {
        return (boolean)InvokeDynamicSupport.bootstrap("connectUdpSock", $$robo$$android_net_dhcp_DhcpClient$connectUdpSock(java.net.Inet4Address ), this, inet4Address);
    }

    private static void closeQuietly(FileDescriptor fileDescriptor) {
        InvokeDynamicSupport.bootstrapStatic("closeQuietly", $$robo$$android_net_dhcp_DhcpClient$closeQuietly(java.io.FileDescriptor ), (FileDescriptor)fileDescriptor);
    }

    private void closeSockets() {
        InvokeDynamicSupport.bootstrap("closeSockets", $$robo$$android_net_dhcp_DhcpClient$closeSockets(), this);
    }

    private short getSecs() {
        return (short)InvokeDynamicSupport.bootstrap("getSecs", $$robo$$android_net_dhcp_DhcpClient$getSecs(), this);
    }

    private boolean transmitPacket(ByteBuffer byteBuffer, String string2, int n, Inet4Address inet4Address) {
        return (boolean)InvokeDynamicSupport.bootstrap("transmitPacket", $$robo$$android_net_dhcp_DhcpClient$transmitPacket(java.nio.ByteBuffer java.lang.String int java.net.Inet4Address ), this, byteBuffer, string2, n, inet4Address);
    }

    private boolean sendDiscoverPacket() {
        return (boolean)InvokeDynamicSupport.bootstrap("sendDiscoverPacket", $$robo$$android_net_dhcp_DhcpClient$sendDiscoverPacket(), this);
    }

    private boolean sendRequestPacket(Inet4Address inet4Address, Inet4Address inet4Address2, Inet4Address inet4Address3, Inet4Address inet4Address4) {
        return (boolean)InvokeDynamicSupport.bootstrap("sendRequestPacket", $$robo$$android_net_dhcp_DhcpClient$sendRequestPacket(java.net.Inet4Address java.net.Inet4Address java.net.Inet4Address java.net.Inet4Address ), this, inet4Address, inet4Address2, inet4Address3, inet4Address4);
    }

    private void scheduleLeaseTimers() {
        InvokeDynamicSupport.bootstrap("scheduleLeaseTimers", $$robo$$android_net_dhcp_DhcpClient$scheduleLeaseTimers(), this);
    }

    private void notifySuccess() {
        InvokeDynamicSupport.bootstrap("notifySuccess", $$robo$$android_net_dhcp_DhcpClient$notifySuccess(), this);
    }

    private void notifyFailure() {
        InvokeDynamicSupport.bootstrap("notifyFailure", $$robo$$android_net_dhcp_DhcpClient$notifyFailure(), this);
    }

    private void acceptDhcpResults(DhcpResults dhcpResults, String string2) {
        InvokeDynamicSupport.bootstrap("acceptDhcpResults", $$robo$$android_net_dhcp_DhcpClient$acceptDhcpResults(android.net.DhcpResults java.lang.String ), this, dhcpResults, string2);
    }

    private void clearDhcpState() {
        InvokeDynamicSupport.bootstrap("clearDhcpState", $$robo$$android_net_dhcp_DhcpClient$clearDhcpState(), this);
    }

    public void doQuit() {
        InvokeDynamicSupport.bootstrap("doQuit", $$robo$$android_net_dhcp_DhcpClient$doQuit(), this);
    }

    @Override
    protected void onQuitting() {
        InvokeDynamicSupport.bootstrap("onQuitting", $$robo$$android_net_dhcp_DhcpClient$onQuitting(), this);
    }

    public boolean isValidPacket(DhcpPacket dhcpPacket) {
        return (boolean)InvokeDynamicSupport.bootstrap("isValidPacket", $$robo$$android_net_dhcp_DhcpClient$isValidPacket(android.net.dhcp.DhcpPacket ), this, dhcpPacket);
    }

    public void setDhcpLeaseExpiry(DhcpPacket dhcpPacket) {
        InvokeDynamicSupport.bootstrap("setDhcpLeaseExpiry", $$robo$$android_net_dhcp_DhcpClient$setDhcpLeaseExpiry(android.net.dhcp.DhcpPacket ), this, dhcpPacket);
    }

    private void logError(int n) {
        InvokeDynamicSupport.bootstrap("logError", $$robo$$android_net_dhcp_DhcpClient$logError(int ), this, n);
    }

    private void logState(String string2, int n) {
        InvokeDynamicSupport.bootstrap("logState", $$robo$$android_net_dhcp_DhcpClient$logState(java.lang.String int ), this, string2, n);
    }

    static {
        RobolectricInternals.classInitializing(DhcpClient.class);
    }

    public /* synthetic */ DhcpClient() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DhcpClient)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public class DhcpRebootingState
    extends LoggingState
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        /* synthetic */ DhcpClient this$0;

        private void $$robo$$android_net_dhcp_DhcpClient_DhcpRebootingState$__constructor__(DhcpClient this$0) {
        }

        private void __constructor__(DhcpClient dhcpClient) {
            this.$$robo$$android_net_dhcp_DhcpClient_DhcpRebootingState$__constructor__(dhcpClient);
        }

        public DhcpRebootingState(DhcpClient dhcpClient) {
            this.this$0 = dhcpClient;
            super(dhcpClient);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_dhcp_DhcpClient_DhcpRebootingState$__constructor__(android.net.dhcp.DhcpClient ), this, dhcpClient);
        }

        public /* synthetic */ DhcpRebootingState() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DhcpRebootingState)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public class DhcpInitRebootState
    extends LoggingState
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        /* synthetic */ DhcpClient this$0;

        private void $$robo$$android_net_dhcp_DhcpClient_DhcpInitRebootState$__constructor__(DhcpClient this$0) {
        }

        private void __constructor__(DhcpClient dhcpClient) {
            this.$$robo$$android_net_dhcp_DhcpClient_DhcpInitRebootState$__constructor__(dhcpClient);
        }

        public DhcpInitRebootState(DhcpClient dhcpClient) {
            this.this$0 = dhcpClient;
            super(dhcpClient);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_dhcp_DhcpClient_DhcpInitRebootState$__constructor__(android.net.dhcp.DhcpClient ), this, dhcpClient);
        }

        public /* synthetic */ DhcpInitRebootState() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DhcpInitRebootState)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public class DhcpRebindingState
    extends DhcpReacquiringState
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        /* synthetic */ DhcpClient this$0;

        private void $$robo$$android_net_dhcp_DhcpClient_DhcpRebindingState$__constructor__(DhcpClient this$0) {
            this.mLeaseMsg = "Rebound";
        }

        private final void $$robo$$android_net_dhcp_DhcpClient_DhcpRebindingState$enter() {
            super.enter();
            DhcpClient.closeQuietly(this.this$0.mUdpSock);
            if (!this.this$0.initUdpSocket()) {
                Log.e("DhcpClient", "Failed to recreate UDP socket");
                this.this$0.transitionTo(this.this$0.mDhcpInitState);
            }
        }

        private final Inet4Address $$robo$$android_net_dhcp_DhcpClient_DhcpRebindingState$packetDestination() {
            return DhcpPacket.INADDR_BROADCAST;
        }

        private void __constructor__(DhcpClient dhcpClient) {
            this.$$robo$$android_net_dhcp_DhcpClient_DhcpRebindingState$__constructor__(dhcpClient);
        }

        public DhcpRebindingState(DhcpClient dhcpClient) {
            this.this$0 = dhcpClient;
            super(dhcpClient);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_dhcp_DhcpClient_DhcpRebindingState$__constructor__(android.net.dhcp.DhcpClient ), this, dhcpClient);
        }

        @Override
        public void enter() {
            InvokeDynamicSupport.bootstrap("enter", $$robo$$android_net_dhcp_DhcpClient_DhcpRebindingState$enter(), this);
        }

        @Override
        protected Inet4Address packetDestination() {
            return InvokeDynamicSupport.bootstrap("packetDestination", $$robo$$android_net_dhcp_DhcpClient_DhcpRebindingState$packetDestination(), this);
        }

        public /* synthetic */ DhcpRebindingState() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DhcpRebindingState)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public class DhcpRenewingState
    extends DhcpReacquiringState
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        /* synthetic */ DhcpClient this$0;

        private void $$robo$$android_net_dhcp_DhcpClient_DhcpRenewingState$__constructor__(DhcpClient this$0) {
            this.mLeaseMsg = "Renewed";
        }

        private final boolean $$robo$$android_net_dhcp_DhcpClient_DhcpRenewingState$processMessage(Message message) {
            if (super.processMessage(message)) {
                return true;
            }
            switch (message.what) {
                case 196713: {
                    this.this$0.transitionTo(this.this$0.mDhcpRebindingState);
                    return true;
                }
            }
            return false;
        }

        private final Inet4Address $$robo$$android_net_dhcp_DhcpClient_DhcpRenewingState$packetDestination() {
            return ((DhcpClient)this.this$0).mDhcpLease.serverAddress != null ? ((DhcpClient)this.this$0).mDhcpLease.serverAddress : DhcpPacket.INADDR_BROADCAST;
        }

        private void __constructor__(DhcpClient dhcpClient) {
            this.$$robo$$android_net_dhcp_DhcpClient_DhcpRenewingState$__constructor__(dhcpClient);
        }

        public DhcpRenewingState(DhcpClient dhcpClient) {
            this.this$0 = dhcpClient;
            super(dhcpClient);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_dhcp_DhcpClient_DhcpRenewingState$__constructor__(android.net.dhcp.DhcpClient ), this, dhcpClient);
        }

        @Override
        public boolean processMessage(Message message) {
            return (boolean)InvokeDynamicSupport.bootstrap("processMessage", $$robo$$android_net_dhcp_DhcpClient_DhcpRenewingState$processMessage(android.os.Message ), this, message);
        }

        @Override
        protected Inet4Address packetDestination() {
            return InvokeDynamicSupport.bootstrap("packetDestination", $$robo$$android_net_dhcp_DhcpClient_DhcpRenewingState$packetDestination(), this);
        }

        public /* synthetic */ DhcpRenewingState() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DhcpRenewingState)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public abstract class DhcpReacquiringState
    extends PacketRetransmittingState
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        protected String mLeaseMsg;
        /* synthetic */ DhcpClient this$0;

        private void $$robo$$android_net_dhcp_DhcpClient_DhcpReacquiringState$__constructor__(DhcpClient this$0) {
        }

        private final void $$robo$$android_net_dhcp_DhcpClient_DhcpReacquiringState$enter() {
            super.enter();
            this.this$0.startNewTransaction();
        }

        protected abstract Inet4Address packetDestination();

        private final boolean $$robo$$android_net_dhcp_DhcpClient_DhcpReacquiringState$sendPacket() {
            return this.this$0.sendRequestPacket((Inet4Address)((DhcpClient)this.this$0).mDhcpLease.ipAddress.getAddress(), DhcpPacket.INADDR_ANY, null, this.packetDestination());
        }

        private final void $$robo$$android_net_dhcp_DhcpClient_DhcpReacquiringState$receivePacket(DhcpPacket packet) {
            if (!this.this$0.isValidPacket(packet)) {
                return;
            }
            if (packet instanceof DhcpAckPacket) {
                DhcpResults results = packet.toDhcpResults();
                if (results != null) {
                    if (!((DhcpClient)this.this$0).mDhcpLease.ipAddress.equals(results.ipAddress)) {
                        Log.d("DhcpClient", "Renewed lease not for our current IP address!");
                        this.this$0.notifyFailure();
                        this.this$0.transitionTo(this.this$0.mDhcpInitState);
                    }
                    this.this$0.setDhcpLeaseExpiry(packet);
                    this.this$0.acceptDhcpResults(results, this.mLeaseMsg);
                    this.this$0.transitionTo(this.this$0.mDhcpBoundState);
                }
            } else if (packet instanceof DhcpNakPacket) {
                Log.d("DhcpClient", "Received NAK, returning to INIT");
                this.this$0.notifyFailure();
                this.this$0.transitionTo(this.this$0.mDhcpInitState);
            }
        }

        private void __constructor__(DhcpClient dhcpClient) {
            this.$$robo$$android_net_dhcp_DhcpClient_DhcpReacquiringState$__constructor__(dhcpClient);
        }

        public DhcpReacquiringState(DhcpClient dhcpClient) {
            this.this$0 = dhcpClient;
            super(dhcpClient);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_dhcp_DhcpClient_DhcpReacquiringState$__constructor__(android.net.dhcp.DhcpClient ), this, dhcpClient);
        }

        @Override
        public void enter() {
            InvokeDynamicSupport.bootstrap("enter", $$robo$$android_net_dhcp_DhcpClient_DhcpReacquiringState$enter(), this);
        }

        @Override
        protected boolean sendPacket() {
            return (boolean)InvokeDynamicSupport.bootstrap("sendPacket", $$robo$$android_net_dhcp_DhcpClient_DhcpReacquiringState$sendPacket(), this);
        }

        @Override
        protected void receivePacket(DhcpPacket dhcpPacket) {
            InvokeDynamicSupport.bootstrap("receivePacket", $$robo$$android_net_dhcp_DhcpClient_DhcpReacquiringState$receivePacket(android.net.dhcp.DhcpPacket ), this, dhcpPacket);
        }

        public /* synthetic */ DhcpReacquiringState() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DhcpReacquiringState)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public class DhcpBoundState
    extends LoggingState
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        /* synthetic */ DhcpClient this$0;

        private void $$robo$$android_net_dhcp_DhcpClient_DhcpBoundState$__constructor__(DhcpClient this$0) {
        }

        private final void $$robo$$android_net_dhcp_DhcpClient_DhcpBoundState$enter() {
            super.enter();
            if (((DhcpClient)this.this$0).mDhcpLease.serverAddress != null && !this.this$0.connectUdpSock(((DhcpClient)this.this$0).mDhcpLease.serverAddress)) {
                this.this$0.notifyFailure();
                this.this$0.transitionTo(this.this$0.mStoppedState);
            }
            this.this$0.scheduleLeaseTimers();
            this.logTimeToBoundState();
        }

        private final void $$robo$$android_net_dhcp_DhcpClient_DhcpBoundState$exit() {
            super.exit();
            this.this$0.mLastBoundExitTime = SystemClock.elapsedRealtime();
        }

        private final boolean $$robo$$android_net_dhcp_DhcpClient_DhcpBoundState$processMessage(Message message) {
            super.processMessage(message);
            switch (message.what) {
                case 196712: {
                    if (this.this$0.mRegisteredForPreDhcpNotification) {
                        this.this$0.transitionTo(this.this$0.mWaitBeforeRenewalState);
                    } else {
                        this.this$0.transitionTo(this.this$0.mDhcpRenewingState);
                    }
                    return true;
                }
            }
            return false;
        }

        private final void $$robo$$android_net_dhcp_DhcpClient_DhcpBoundState$logTimeToBoundState() {
            long now = SystemClock.elapsedRealtime();
            if (this.this$0.mLastBoundExitTime > this.this$0.mLastInitEnterTime) {
                this.this$0.logState("RenewingBoundState", (int)(now - this.this$0.mLastBoundExitTime));
            } else {
                this.this$0.logState("InitialBoundState", (int)(now - this.this$0.mLastInitEnterTime));
            }
        }

        private void __constructor__(DhcpClient dhcpClient) {
            this.$$robo$$android_net_dhcp_DhcpClient_DhcpBoundState$__constructor__(dhcpClient);
        }

        public DhcpBoundState(DhcpClient dhcpClient) {
            this.this$0 = dhcpClient;
            super(dhcpClient);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_dhcp_DhcpClient_DhcpBoundState$__constructor__(android.net.dhcp.DhcpClient ), this, dhcpClient);
        }

        @Override
        public void enter() {
            InvokeDynamicSupport.bootstrap("enter", $$robo$$android_net_dhcp_DhcpClient_DhcpBoundState$enter(), this);
        }

        @Override
        public void exit() {
            InvokeDynamicSupport.bootstrap("exit", $$robo$$android_net_dhcp_DhcpClient_DhcpBoundState$exit(), this);
        }

        @Override
        public boolean processMessage(Message message) {
            return (boolean)InvokeDynamicSupport.bootstrap("processMessage", $$robo$$android_net_dhcp_DhcpClient_DhcpBoundState$processMessage(android.os.Message ), this, message);
        }

        private void logTimeToBoundState() {
            InvokeDynamicSupport.bootstrap("logTimeToBoundState", $$robo$$android_net_dhcp_DhcpClient_DhcpBoundState$logTimeToBoundState(), this);
        }

        public /* synthetic */ DhcpBoundState() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DhcpBoundState)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public class ConfiguringInterfaceState
    extends LoggingState
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        /* synthetic */ DhcpClient this$0;

        private void $$robo$$android_net_dhcp_DhcpClient_ConfiguringInterfaceState$__constructor__(DhcpClient this$0) {
        }

        private final void $$robo$$android_net_dhcp_DhcpClient_ConfiguringInterfaceState$enter() {
            super.enter();
            this.this$0.mController.sendMessage(196616, ((DhcpClient)this.this$0).mDhcpLease.ipAddress);
        }

        private final boolean $$robo$$android_net_dhcp_DhcpClient_ConfiguringInterfaceState$processMessage(Message message) {
            super.processMessage(message);
            switch (message.what) {
                case 196617: {
                    this.this$0.transitionTo(this.this$0.mDhcpBoundState);
                    return true;
                }
            }
            return false;
        }

        private void __constructor__(DhcpClient dhcpClient) {
            this.$$robo$$android_net_dhcp_DhcpClient_ConfiguringInterfaceState$__constructor__(dhcpClient);
        }

        public ConfiguringInterfaceState(DhcpClient dhcpClient) {
            this.this$0 = dhcpClient;
            super(dhcpClient);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_dhcp_DhcpClient_ConfiguringInterfaceState$__constructor__(android.net.dhcp.DhcpClient ), this, dhcpClient);
        }

        @Override
        public void enter() {
            InvokeDynamicSupport.bootstrap("enter", $$robo$$android_net_dhcp_DhcpClient_ConfiguringInterfaceState$enter(), this);
        }

        @Override
        public boolean processMessage(Message message) {
            return (boolean)InvokeDynamicSupport.bootstrap("processMessage", $$robo$$android_net_dhcp_DhcpClient_ConfiguringInterfaceState$processMessage(android.os.Message ), this, message);
        }

        public /* synthetic */ ConfiguringInterfaceState() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ConfiguringInterfaceState)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public class DhcpHaveLeaseState
    extends State
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        /* synthetic */ DhcpClient this$0;

        private void $$robo$$android_net_dhcp_DhcpClient_DhcpHaveLeaseState$__constructor__(DhcpClient this$0) {
        }

        private final boolean $$robo$$android_net_dhcp_DhcpClient_DhcpHaveLeaseState$processMessage(Message message) {
            switch (message.what) {
                case 196714: {
                    Log.d("DhcpClient", "Lease expired!");
                    this.this$0.notifyFailure();
                    this.this$0.transitionTo(this.this$0.mDhcpInitState);
                    return true;
                }
            }
            return false;
        }

        private final void $$robo$$android_net_dhcp_DhcpClient_DhcpHaveLeaseState$exit() {
            this.this$0.mRenewAlarm.cancel();
            this.this$0.mRebindAlarm.cancel();
            this.this$0.mExpiryAlarm.cancel();
            this.this$0.clearDhcpState();
            this.this$0.mController.sendMessage(196615);
        }

        private void __constructor__(DhcpClient dhcpClient) {
            this.$$robo$$android_net_dhcp_DhcpClient_DhcpHaveLeaseState$__constructor__(dhcpClient);
        }

        public DhcpHaveLeaseState(DhcpClient dhcpClient) {
            this.this$0 = dhcpClient;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_dhcp_DhcpClient_DhcpHaveLeaseState$__constructor__(android.net.dhcp.DhcpClient ), this, dhcpClient);
        }

        @Override
        public boolean processMessage(Message message) {
            return (boolean)InvokeDynamicSupport.bootstrap("processMessage", $$robo$$android_net_dhcp_DhcpClient_DhcpHaveLeaseState$processMessage(android.os.Message ), this, message);
        }

        @Override
        public void exit() {
            InvokeDynamicSupport.bootstrap("exit", $$robo$$android_net_dhcp_DhcpClient_DhcpHaveLeaseState$exit(), this);
        }

        public /* synthetic */ DhcpHaveLeaseState() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DhcpHaveLeaseState)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public class DhcpRequestingState
    extends PacketRetransmittingState
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        /* synthetic */ DhcpClient this$0;

        private void $$robo$$android_net_dhcp_DhcpClient_DhcpRequestingState$__constructor__(DhcpClient this$0) {
            this.mTimeout = 18000;
        }

        private final boolean $$robo$$android_net_dhcp_DhcpClient_DhcpRequestingState$sendPacket() {
            return this.this$0.sendRequestPacket(DhcpPacket.INADDR_ANY, (Inet4Address)((DhcpClient)this.this$0).mOffer.ipAddress.getAddress(), ((DhcpClient)this.this$0).mOffer.serverAddress, DhcpPacket.INADDR_BROADCAST);
        }

        private final void $$robo$$android_net_dhcp_DhcpClient_DhcpRequestingState$receivePacket(DhcpPacket packet) {
            if (!this.this$0.isValidPacket(packet)) {
                return;
            }
            if (packet instanceof DhcpAckPacket) {
                DhcpResults results = packet.toDhcpResults();
                if (results != null) {
                    this.this$0.setDhcpLeaseExpiry(packet);
                    this.this$0.acceptDhcpResults(results, "Confirmed");
                    this.this$0.transitionTo(this.this$0.mConfiguringInterfaceState);
                }
            } else if (packet instanceof DhcpNakPacket) {
                Log.d("DhcpClient", "Received NAK, returning to INIT");
                this.this$0.mOffer = null;
                this.this$0.transitionTo(this.this$0.mDhcpInitState);
            }
        }

        private final void $$robo$$android_net_dhcp_DhcpClient_DhcpRequestingState$timeout() {
            this.this$0.transitionTo(this.this$0.mDhcpInitState);
        }

        private void __constructor__(DhcpClient dhcpClient) {
            this.$$robo$$android_net_dhcp_DhcpClient_DhcpRequestingState$__constructor__(dhcpClient);
        }

        public DhcpRequestingState(DhcpClient dhcpClient) {
            this.this$0 = dhcpClient;
            super(dhcpClient);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_dhcp_DhcpClient_DhcpRequestingState$__constructor__(android.net.dhcp.DhcpClient ), this, dhcpClient);
        }

        @Override
        protected boolean sendPacket() {
            return (boolean)InvokeDynamicSupport.bootstrap("sendPacket", $$robo$$android_net_dhcp_DhcpClient_DhcpRequestingState$sendPacket(), this);
        }

        @Override
        protected void receivePacket(DhcpPacket dhcpPacket) {
            InvokeDynamicSupport.bootstrap("receivePacket", $$robo$$android_net_dhcp_DhcpClient_DhcpRequestingState$receivePacket(android.net.dhcp.DhcpPacket ), this, dhcpPacket);
        }

        @Override
        protected void timeout() {
            InvokeDynamicSupport.bootstrap("timeout", $$robo$$android_net_dhcp_DhcpClient_DhcpRequestingState$timeout(), this);
        }

        public /* synthetic */ DhcpRequestingState() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DhcpRequestingState)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public class DhcpSelectingState
    extends LoggingState
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        /* synthetic */ DhcpClient this$0;

        private void $$robo$$android_net_dhcp_DhcpClient_DhcpSelectingState$__constructor__(DhcpClient this$0) {
        }

        private void __constructor__(DhcpClient dhcpClient) {
            this.$$robo$$android_net_dhcp_DhcpClient_DhcpSelectingState$__constructor__(dhcpClient);
        }

        public DhcpSelectingState(DhcpClient dhcpClient) {
            this.this$0 = dhcpClient;
            super(dhcpClient);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_dhcp_DhcpClient_DhcpSelectingState$__constructor__(android.net.dhcp.DhcpClient ), this, dhcpClient);
        }

        public /* synthetic */ DhcpSelectingState() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DhcpSelectingState)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public class DhcpInitState
    extends PacketRetransmittingState
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        /* synthetic */ DhcpClient this$0;

        private void $$robo$$android_net_dhcp_DhcpClient_DhcpInitState$__constructor__(DhcpClient this$0) {
        }

        private final void $$robo$$android_net_dhcp_DhcpClient_DhcpInitState$enter() {
            super.enter();
            this.this$0.startNewTransaction();
            this.this$0.mLastInitEnterTime = SystemClock.elapsedRealtime();
        }

        private final boolean $$robo$$android_net_dhcp_DhcpClient_DhcpInitState$sendPacket() {
            return this.this$0.sendDiscoverPacket();
        }

        private final void $$robo$$android_net_dhcp_DhcpClient_DhcpInitState$receivePacket(DhcpPacket packet) {
            if (!this.this$0.isValidPacket(packet)) {
                return;
            }
            if (!(packet instanceof DhcpOfferPacket)) {
                return;
            }
            this.this$0.mOffer = packet.toDhcpResults();
            if (this.this$0.mOffer != null) {
                Log.d("DhcpClient", "Got pending lease: " + this.this$0.mOffer);
                this.this$0.transitionTo(this.this$0.mDhcpRequestingState);
            }
        }

        private void __constructor__(DhcpClient dhcpClient) {
            this.$$robo$$android_net_dhcp_DhcpClient_DhcpInitState$__constructor__(dhcpClient);
        }

        public DhcpInitState(DhcpClient dhcpClient) {
            this.this$0 = dhcpClient;
            super(dhcpClient);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_dhcp_DhcpClient_DhcpInitState$__constructor__(android.net.dhcp.DhcpClient ), this, dhcpClient);
        }

        @Override
        public void enter() {
            InvokeDynamicSupport.bootstrap("enter", $$robo$$android_net_dhcp_DhcpClient_DhcpInitState$enter(), this);
        }

        @Override
        protected boolean sendPacket() {
            return (boolean)InvokeDynamicSupport.bootstrap("sendPacket", $$robo$$android_net_dhcp_DhcpClient_DhcpInitState$sendPacket(), this);
        }

        @Override
        protected void receivePacket(DhcpPacket dhcpPacket) {
            InvokeDynamicSupport.bootstrap("receivePacket", $$robo$$android_net_dhcp_DhcpClient_DhcpInitState$receivePacket(android.net.dhcp.DhcpPacket ), this, dhcpPacket);
        }

        public /* synthetic */ DhcpInitState() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DhcpInitState)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public abstract class PacketRetransmittingState
    extends LoggingState
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private int mTimer;
        protected int mTimeout;
        /* synthetic */ DhcpClient this$0;

        private void $$robo$$android_net_dhcp_DhcpClient_PacketRetransmittingState$__constructor__(DhcpClient this$0) {
            this.mTimeout = 0;
        }

        private final void $$robo$$android_net_dhcp_DhcpClient_PacketRetransmittingState$enter() {
            super.enter();
            this.initTimer();
            this.maybeInitTimeout();
            this.this$0.sendMessage(196709);
        }

        private final boolean $$robo$$android_net_dhcp_DhcpClient_PacketRetransmittingState$processMessage(Message message) {
            super.processMessage(message);
            switch (message.what) {
                case 196709: {
                    this.sendPacket();
                    this.scheduleKick();
                    return true;
                }
                case 196710: {
                    this.receivePacket((DhcpPacket)message.obj);
                    return true;
                }
                case 196711: {
                    this.timeout();
                    return true;
                }
            }
            return false;
        }

        private final void $$robo$$android_net_dhcp_DhcpClient_PacketRetransmittingState$exit() {
            super.exit();
            this.this$0.mKickAlarm.cancel();
            this.this$0.mTimeoutAlarm.cancel();
        }

        protected abstract boolean sendPacket();

        protected abstract void receivePacket(DhcpPacket var1);

        private final void $$robo$$android_net_dhcp_DhcpClient_PacketRetransmittingState$timeout() {
        }

        private final void $$robo$$android_net_dhcp_DhcpClient_PacketRetransmittingState$initTimer() {
            this.mTimer = 2000;
        }

        private final int $$robo$$android_net_dhcp_DhcpClient_PacketRetransmittingState$jitterTimer(int baseTimer) {
            int maxJitter = baseTimer / 10;
            int jitter = this.this$0.mRandom.nextInt(2 * maxJitter) - maxJitter;
            return baseTimer + jitter;
        }

        private final void $$robo$$android_net_dhcp_DhcpClient_PacketRetransmittingState$scheduleKick() {
            long now = SystemClock.elapsedRealtime();
            long timeout = this.jitterTimer(this.mTimer);
            long alarmTime = now + timeout;
            this.this$0.mKickAlarm.schedule(alarmTime);
            this.mTimer *= 2;
            if (this.mTimer > 128000) {
                this.mTimer = 128000;
            }
        }

        private final void $$robo$$android_net_dhcp_DhcpClient_PacketRetransmittingState$maybeInitTimeout() {
            if (this.mTimeout > 0) {
                long alarmTime = SystemClock.elapsedRealtime() + (long)this.mTimeout;
                this.this$0.mTimeoutAlarm.schedule(alarmTime);
            }
        }

        private void __constructor__(DhcpClient dhcpClient) {
            this.$$robo$$android_net_dhcp_DhcpClient_PacketRetransmittingState$__constructor__(dhcpClient);
        }

        public PacketRetransmittingState(DhcpClient dhcpClient) {
            this.this$0 = dhcpClient;
            super(dhcpClient);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_dhcp_DhcpClient_PacketRetransmittingState$__constructor__(android.net.dhcp.DhcpClient ), this, dhcpClient);
        }

        @Override
        public void enter() {
            InvokeDynamicSupport.bootstrap("enter", $$robo$$android_net_dhcp_DhcpClient_PacketRetransmittingState$enter(), this);
        }

        @Override
        public boolean processMessage(Message message) {
            return (boolean)InvokeDynamicSupport.bootstrap("processMessage", $$robo$$android_net_dhcp_DhcpClient_PacketRetransmittingState$processMessage(android.os.Message ), this, message);
        }

        @Override
        public void exit() {
            InvokeDynamicSupport.bootstrap("exit", $$robo$$android_net_dhcp_DhcpClient_PacketRetransmittingState$exit(), this);
        }

        protected void timeout() {
            InvokeDynamicSupport.bootstrap("timeout", $$robo$$android_net_dhcp_DhcpClient_PacketRetransmittingState$timeout(), this);
        }

        protected void initTimer() {
            InvokeDynamicSupport.bootstrap("initTimer", $$robo$$android_net_dhcp_DhcpClient_PacketRetransmittingState$initTimer(), this);
        }

        protected int jitterTimer(int n) {
            return (int)InvokeDynamicSupport.bootstrap("jitterTimer", $$robo$$android_net_dhcp_DhcpClient_PacketRetransmittingState$jitterTimer(int ), this, n);
        }

        protected void scheduleKick() {
            InvokeDynamicSupport.bootstrap("scheduleKick", $$robo$$android_net_dhcp_DhcpClient_PacketRetransmittingState$scheduleKick(), this);
        }

        protected void maybeInitTimeout() {
            InvokeDynamicSupport.bootstrap("maybeInitTimeout", $$robo$$android_net_dhcp_DhcpClient_PacketRetransmittingState$maybeInitTimeout(), this);
        }

        public /* synthetic */ PacketRetransmittingState() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PacketRetransmittingState)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public class DhcpState
    extends State
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        /* synthetic */ DhcpClient this$0;

        private void $$robo$$android_net_dhcp_DhcpClient_DhcpState$__constructor__(DhcpClient this$0) {
        }

        private final void $$robo$$android_net_dhcp_DhcpClient_DhcpState$enter() {
            this.this$0.clearDhcpState();
            if (this.this$0.initInterface() && this.this$0.initSockets()) {
                this.this$0.mReceiveThread = new ReceiveThread(this.this$0);
                this.this$0.mReceiveThread.start();
            } else {
                this.this$0.notifyFailure();
                this.this$0.transitionTo(this.this$0.mStoppedState);
            }
        }

        private final void $$robo$$android_net_dhcp_DhcpClient_DhcpState$exit() {
            if (this.this$0.mReceiveThread != null) {
                this.this$0.mReceiveThread.halt();
                this.this$0.mReceiveThread = null;
            }
            this.this$0.clearDhcpState();
        }

        private final boolean $$robo$$android_net_dhcp_DhcpClient_DhcpState$processMessage(Message message) {
            super.processMessage(message);
            switch (message.what) {
                case 196610: {
                    this.this$0.transitionTo(this.this$0.mStoppedState);
                    return true;
                }
            }
            return false;
        }

        private void __constructor__(DhcpClient dhcpClient) {
            this.$$robo$$android_net_dhcp_DhcpClient_DhcpState$__constructor__(dhcpClient);
        }

        public DhcpState(DhcpClient dhcpClient) {
            this.this$0 = dhcpClient;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_dhcp_DhcpClient_DhcpState$__constructor__(android.net.dhcp.DhcpClient ), this, dhcpClient);
        }

        @Override
        public void enter() {
            InvokeDynamicSupport.bootstrap("enter", $$robo$$android_net_dhcp_DhcpClient_DhcpState$enter(), this);
        }

        @Override
        public void exit() {
            InvokeDynamicSupport.bootstrap("exit", $$robo$$android_net_dhcp_DhcpClient_DhcpState$exit(), this);
        }

        @Override
        public boolean processMessage(Message message) {
            return (boolean)InvokeDynamicSupport.bootstrap("processMessage", $$robo$$android_net_dhcp_DhcpClient_DhcpState$processMessage(android.os.Message ), this, message);
        }

        public /* synthetic */ DhcpState() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DhcpState)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public class WaitBeforeRenewalState
    extends WaitBeforeOtherState
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        /* synthetic */ DhcpClient this$0;

        private void $$robo$$android_net_dhcp_DhcpClient_WaitBeforeRenewalState$__constructor__(DhcpClient this$0, State otherState) {
            this.mOtherState = otherState;
        }

        private void __constructor__(DhcpClient dhcpClient, State state) {
            this.$$robo$$android_net_dhcp_DhcpClient_WaitBeforeRenewalState$__constructor__(dhcpClient, state);
        }

        public WaitBeforeRenewalState(DhcpClient dhcpClient, State state) {
            this.this$0 = dhcpClient;
            super(dhcpClient);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_dhcp_DhcpClient_WaitBeforeRenewalState$__constructor__(android.net.dhcp.DhcpClient com.android.internal.util.State ), this, dhcpClient, state);
        }

        public /* synthetic */ WaitBeforeRenewalState() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (WaitBeforeRenewalState)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public class WaitBeforeStartState
    extends WaitBeforeOtherState
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        /* synthetic */ DhcpClient this$0;

        private void $$robo$$android_net_dhcp_DhcpClient_WaitBeforeStartState$__constructor__(DhcpClient this$0, State otherState) {
            this.mOtherState = otherState;
        }

        private void __constructor__(DhcpClient dhcpClient, State state) {
            this.$$robo$$android_net_dhcp_DhcpClient_WaitBeforeStartState$__constructor__(dhcpClient, state);
        }

        public WaitBeforeStartState(DhcpClient dhcpClient, State state) {
            this.this$0 = dhcpClient;
            super(dhcpClient);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_dhcp_DhcpClient_WaitBeforeStartState$__constructor__(android.net.dhcp.DhcpClient com.android.internal.util.State ), this, dhcpClient, state);
        }

        public /* synthetic */ WaitBeforeStartState() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (WaitBeforeStartState)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public class StoppedState
    extends State
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        /* synthetic */ DhcpClient this$0;

        private void $$robo$$android_net_dhcp_DhcpClient_StoppedState$__constructor__(DhcpClient this$0) {
        }

        private final boolean $$robo$$android_net_dhcp_DhcpClient_StoppedState$processMessage(Message message) {
            switch (message.what) {
                case 196609: {
                    if (this.this$0.mRegisteredForPreDhcpNotification) {
                        this.this$0.transitionTo(this.this$0.mWaitBeforeStartState);
                    } else {
                        this.this$0.transitionTo(this.this$0.mDhcpInitState);
                    }
                    return true;
                }
            }
            return false;
        }

        private void __constructor__(DhcpClient dhcpClient) {
            this.$$robo$$android_net_dhcp_DhcpClient_StoppedState$__constructor__(dhcpClient);
        }

        public StoppedState(DhcpClient dhcpClient) {
            this.this$0 = dhcpClient;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_dhcp_DhcpClient_StoppedState$__constructor__(android.net.dhcp.DhcpClient ), this, dhcpClient);
        }

        @Override
        public boolean processMessage(Message message) {
            return (boolean)InvokeDynamicSupport.bootstrap("processMessage", $$robo$$android_net_dhcp_DhcpClient_StoppedState$processMessage(android.os.Message ), this, message);
        }

        public /* synthetic */ StoppedState() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (StoppedState)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public abstract class WaitBeforeOtherState
    extends LoggingState
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        protected State mOtherState;
        /* synthetic */ DhcpClient this$0;

        private void $$robo$$android_net_dhcp_DhcpClient_WaitBeforeOtherState$__constructor__(DhcpClient this$0) {
        }

        private final void $$robo$$android_net_dhcp_DhcpClient_WaitBeforeOtherState$enter() {
            super.enter();
            this.this$0.mController.sendMessage(196611);
        }

        private final boolean $$robo$$android_net_dhcp_DhcpClient_WaitBeforeOtherState$processMessage(Message message) {
            super.processMessage(message);
            switch (message.what) {
                case 196614: {
                    this.this$0.transitionTo(this.mOtherState);
                    return true;
                }
            }
            return false;
        }

        private void __constructor__(DhcpClient dhcpClient) {
            this.$$robo$$android_net_dhcp_DhcpClient_WaitBeforeOtherState$__constructor__(dhcpClient);
        }

        public WaitBeforeOtherState(DhcpClient dhcpClient) {
            this.this$0 = dhcpClient;
            super(dhcpClient);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_dhcp_DhcpClient_WaitBeforeOtherState$__constructor__(android.net.dhcp.DhcpClient ), this, dhcpClient);
        }

        @Override
        public void enter() {
            InvokeDynamicSupport.bootstrap("enter", $$robo$$android_net_dhcp_DhcpClient_WaitBeforeOtherState$enter(), this);
        }

        @Override
        public boolean processMessage(Message message) {
            return (boolean)InvokeDynamicSupport.bootstrap("processMessage", $$robo$$android_net_dhcp_DhcpClient_WaitBeforeOtherState$processMessage(android.os.Message ), this, message);
        }

        public /* synthetic */ WaitBeforeOtherState() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (WaitBeforeOtherState)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public abstract class LoggingState
    extends State
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private long mEnterTimeMs;
        /* synthetic */ DhcpClient this$0;

        private void $$robo$$android_net_dhcp_DhcpClient_LoggingState$__constructor__(DhcpClient this$0) {
        }

        private final void $$robo$$android_net_dhcp_DhcpClient_LoggingState$enter() {
            this.mEnterTimeMs = SystemClock.elapsedRealtime();
        }

        private final void $$robo$$android_net_dhcp_DhcpClient_LoggingState$exit() {
            long durationMs = SystemClock.elapsedRealtime() - this.mEnterTimeMs;
            this.this$0.logState(this.getName(), (int)durationMs);
        }

        private final String $$robo$$android_net_dhcp_DhcpClient_LoggingState$messageName(int what) {
            return sMessageNames.get(what, Integer.toString(what));
        }

        private final String $$robo$$android_net_dhcp_DhcpClient_LoggingState$messageToString(Message message) {
            long now = SystemClock.uptimeMillis();
            StringBuilder b = new StringBuilder(" ");
            TimeUtils.formatDuration(message.getWhen() - now, b);
            b.append(" ").append(this.messageName(message.what)).append(" ").append(message.arg1).append(" ").append(message.arg2).append(" ").append(message.obj);
            return b.toString();
        }

        private final boolean $$robo$$android_net_dhcp_DhcpClient_LoggingState$processMessage(Message message) {
            return false;
        }

        private final String $$robo$$android_net_dhcp_DhcpClient_LoggingState$getName() {
            return this.getClass().getSimpleName();
        }

        private void __constructor__(DhcpClient dhcpClient) {
            this.$$robo$$android_net_dhcp_DhcpClient_LoggingState$__constructor__(dhcpClient);
        }

        public LoggingState(DhcpClient dhcpClient) {
            this.this$0 = dhcpClient;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_dhcp_DhcpClient_LoggingState$__constructor__(android.net.dhcp.DhcpClient ), this, dhcpClient);
        }

        @Override
        public void enter() {
            InvokeDynamicSupport.bootstrap("enter", $$robo$$android_net_dhcp_DhcpClient_LoggingState$enter(), this);
        }

        @Override
        public void exit() {
            InvokeDynamicSupport.bootstrap("exit", $$robo$$android_net_dhcp_DhcpClient_LoggingState$exit(), this);
        }

        private String messageName(int n) {
            return InvokeDynamicSupport.bootstrap("messageName", $$robo$$android_net_dhcp_DhcpClient_LoggingState$messageName(int ), this, n);
        }

        private String messageToString(Message message) {
            return InvokeDynamicSupport.bootstrap("messageToString", $$robo$$android_net_dhcp_DhcpClient_LoggingState$messageToString(android.os.Message ), this, message);
        }

        @Override
        public boolean processMessage(Message message) {
            return (boolean)InvokeDynamicSupport.bootstrap("processMessage", $$robo$$android_net_dhcp_DhcpClient_LoggingState$processMessage(android.os.Message ), this, message);
        }

        @Override
        public String getName() {
            return InvokeDynamicSupport.bootstrap("getName", $$robo$$android_net_dhcp_DhcpClient_LoggingState$getName(), this);
        }

        public /* synthetic */ LoggingState() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LoggingState)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public class ReceiveThread
    extends Thread
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private byte[] mPacket;
        private volatile boolean mStopped;
        /* synthetic */ DhcpClient this$0;

        private void $$robo$$android_net_dhcp_DhcpClient_ReceiveThread$__constructor__(DhcpClient this$0) {
            this.mPacket = new byte[1500];
            this.mStopped = false;
        }

        private final void $$robo$$android_net_dhcp_DhcpClient_ReceiveThread$halt() {
            this.mStopped = true;
            this.this$0.closeSockets();
        }

        private final void $$robo$$android_net_dhcp_DhcpClient_ReceiveThread$run() {
            Log.d("DhcpClient", "Receive thread started");
            while (!this.mStopped) {
                int length = 0;
                try {
                    length = Os.read(this.this$0.mPacketSock, this.mPacket, 0, this.mPacket.length);
                    DhcpPacket packet = null;
                    packet = DhcpPacket.decodeFullPacket(this.mPacket, length, 0);
                    Log.d("DhcpClient", "Received packet: " + packet);
                    this.this$0.sendMessage(196710, packet);
                }
                catch (ErrnoException | IOException e) {
                    if (this.mStopped) continue;
                    Log.e("DhcpClient", "Read error", e);
                    this.this$0.logError(DhcpErrorEvent.RECEIVE_ERROR);
                }
                catch (DhcpPacket.ParseException e) {
                    Log.e("DhcpClient", "Can't parse packet: " + e.getMessage());
                    if (e.errorCode == DhcpErrorEvent.DHCP_NO_COOKIE) {
                        int snetTagId = 1397638484;
                        String bugId = "31850211";
                        int uid = -1;
                        String data = DhcpPacket.ParseException.class.getName();
                        EventLog.writeEvent(snetTagId, bugId, uid, data);
                    }
                    this.this$0.logError(e.errorCode);
                }
            }
            Log.d("DhcpClient", "Receive thread stopped");
        }

        private void __constructor__(DhcpClient dhcpClient) {
            this.$$robo$$android_net_dhcp_DhcpClient_ReceiveThread$__constructor__(dhcpClient);
        }

        public ReceiveThread(DhcpClient dhcpClient) {
            this.this$0 = dhcpClient;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_dhcp_DhcpClient_ReceiveThread$__constructor__(android.net.dhcp.DhcpClient ), this, dhcpClient);
        }

        public void halt() {
            InvokeDynamicSupport.bootstrap("halt", $$robo$$android_net_dhcp_DhcpClient_ReceiveThread$halt(), this);
        }

        @Override
        public void run() {
            InvokeDynamicSupport.bootstrap("run", $$robo$$android_net_dhcp_DhcpClient_ReceiveThread$run(), this);
        }

        public /* synthetic */ ReceiveThread() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ReceiveThread)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

