/*
 * Decompiled with CFR 0.152.
 */
package android.net.http;

import android.content.Context;
import android.os.Bundle;
import android.text.format.DateFormat;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.TextView;
import com.android.internal.util.HexDump;
import com.android.org.bouncycastle.asn1.x509.X509Name;
import java.io.ByteArrayInputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class SslCertificate
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String ISO_8601_DATE_FORMAT;
    private DName mIssuedTo;
    private DName mIssuedBy;
    private Date mValidNotBefore;
    private Date mValidNotAfter;
    private X509Certificate mX509Certificate;
    private static String ISSUED_TO = "issued-to";
    private static String ISSUED_BY = "issued-by";
    private static String VALID_NOT_BEFORE = "valid-not-before";
    private static String VALID_NOT_AFTER = "valid-not-after";
    private static String X509_CERTIFICATE = "x509-certificate";

    private static final Bundle $$robo$$android_net_http_SslCertificate$saveState(SslCertificate certificate) {
        if (certificate == null) {
            return null;
        }
        Bundle bundle = new Bundle();
        bundle.putString("issued-to", certificate.getIssuedTo().getDName());
        bundle.putString("issued-by", certificate.getIssuedBy().getDName());
        bundle.putString("valid-not-before", certificate.getValidNotBefore());
        bundle.putString("valid-not-after", certificate.getValidNotAfter());
        X509Certificate x509Certificate = certificate.mX509Certificate;
        if (x509Certificate != null) {
            try {
                bundle.putByteArray("x509-certificate", x509Certificate.getEncoded());
            }
            catch (CertificateEncodingException certificateEncodingException) {
                // empty catch block
            }
        }
        return bundle;
    }

    private static final SslCertificate $$robo$$android_net_http_SslCertificate$restoreState(Bundle bundle) {
        X509Certificate x509Certificate;
        if (bundle == null) {
            return null;
        }
        byte[] bytes = bundle.getByteArray("x509-certificate");
        if (bytes == null) {
            x509Certificate = null;
        } else {
            try {
                CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
                Certificate cert = certFactory.generateCertificate(new ByteArrayInputStream(bytes));
                x509Certificate = (X509Certificate)cert;
            }
            catch (CertificateException e) {
                x509Certificate = null;
            }
        }
        return new SslCertificate(bundle.getString("issued-to"), bundle.getString("issued-by"), SslCertificate.parseDate(bundle.getString("valid-not-before")), SslCertificate.parseDate(bundle.getString("valid-not-after")), x509Certificate);
    }

    @Deprecated
    private void $$robo$$android_net_http_SslCertificate$__constructor__(String issuedTo, String issuedBy, String validNotBefore, String validNotAfter) {
    }

    @Deprecated
    private void $$robo$$android_net_http_SslCertificate$__constructor__(String issuedTo, String issuedBy, Date validNotBefore, Date validNotAfter) {
    }

    private void $$robo$$android_net_http_SslCertificate$__constructor__(X509Certificate certificate) {
    }

    private void $$robo$$android_net_http_SslCertificate$__constructor__(String issuedTo, String issuedBy, Date validNotBefore, Date validNotAfter, X509Certificate x509Certificate) {
        this.mIssuedTo = new DName(this, issuedTo);
        this.mIssuedBy = new DName(this, issuedBy);
        this.mValidNotBefore = SslCertificate.cloneDate(validNotBefore);
        this.mValidNotAfter = SslCertificate.cloneDate(validNotAfter);
        this.mX509Certificate = x509Certificate;
    }

    private final Date $$robo$$android_net_http_SslCertificate$getValidNotBeforeDate() {
        return SslCertificate.cloneDate(this.mValidNotBefore);
    }

    @Deprecated
    private final String $$robo$$android_net_http_SslCertificate$getValidNotBefore() {
        return SslCertificate.formatDate(this.mValidNotBefore);
    }

    private final Date $$robo$$android_net_http_SslCertificate$getValidNotAfterDate() {
        return SslCertificate.cloneDate(this.mValidNotAfter);
    }

    @Deprecated
    private final String $$robo$$android_net_http_SslCertificate$getValidNotAfter() {
        return SslCertificate.formatDate(this.mValidNotAfter);
    }

    private final DName $$robo$$android_net_http_SslCertificate$getIssuedTo() {
        return this.mIssuedTo;
    }

    private final DName $$robo$$android_net_http_SslCertificate$getIssuedBy() {
        return this.mIssuedBy;
    }

    private static final String $$robo$$android_net_http_SslCertificate$getSerialNumber(X509Certificate x509Certificate) {
        if (x509Certificate == null) {
            return "";
        }
        BigInteger serialNumber = x509Certificate.getSerialNumber();
        if (serialNumber == null) {
            return "";
        }
        return SslCertificate.fingerprint(serialNumber.toByteArray());
    }

    private static final String $$robo$$android_net_http_SslCertificate$getDigest(X509Certificate x509Certificate, String algorithm) {
        if (x509Certificate == null) {
            return "";
        }
        try {
            byte[] bytes = x509Certificate.getEncoded();
            MessageDigest md = MessageDigest.getInstance(algorithm);
            byte[] digest = md.digest(bytes);
            return SslCertificate.fingerprint(digest);
        }
        catch (CertificateEncodingException ignored) {
            return "";
        }
        catch (NoSuchAlgorithmException ignored) {
            return "";
        }
    }

    private static final String $$robo$$android_net_http_SslCertificate$fingerprint(byte[] bytes) {
        if (bytes == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            byte b = bytes[i];
            HexDump.appendByteAsHex(sb, b, true);
            if (i + 1 == bytes.length) continue;
            sb.append(':');
        }
        return sb.toString();
    }

    private final String $$robo$$android_net_http_SslCertificate$toString() {
        return "Issued to: " + this.mIssuedTo.getDName() + ";\nIssued by: " + this.mIssuedBy.getDName() + ";\n";
    }

    private static final Date $$robo$$android_net_http_SslCertificate$parseDate(String string2) {
        try {
            return new SimpleDateFormat(ISO_8601_DATE_FORMAT).parse(string2);
        }
        catch (ParseException e) {
            return null;
        }
    }

    private static final String $$robo$$android_net_http_SslCertificate$formatDate(Date date) {
        if (date == null) {
            return "";
        }
        return new SimpleDateFormat(ISO_8601_DATE_FORMAT).format(date);
    }

    private static final Date $$robo$$android_net_http_SslCertificate$cloneDate(Date date) {
        if (date == null) {
            return null;
        }
        return (Date)date.clone();
    }

    private final View $$robo$$android_net_http_SslCertificate$inflateCertificateView(Context context) {
        LayoutInflater factory = LayoutInflater.from(context);
        View certificateView = factory.inflate(17367273, null);
        DName issuedTo = this.getIssuedTo();
        if (issuedTo != null) {
            ((TextView)certificateView.findViewById(16909373)).setText(issuedTo.getCName());
            ((TextView)certificateView.findViewById(16909375)).setText(issuedTo.getOName());
            ((TextView)certificateView.findViewById(16909377)).setText(issuedTo.getUName());
        }
        ((TextView)certificateView.findViewById(16909249)).setText(SslCertificate.getSerialNumber(this.mX509Certificate));
        DName issuedBy = this.getIssuedBy();
        if (issuedBy != null) {
            ((TextView)certificateView.findViewById(16908762)).setText(issuedBy.getCName());
            ((TextView)certificateView.findViewById(16908764)).setText(issuedBy.getOName());
            ((TextView)certificateView.findViewById(16908766)).setText(issuedBy.getUName());
        }
        String issuedOn = this.formatCertificateDate(context, this.getValidNotBeforeDate());
        ((TextView)certificateView.findViewById(16908982)).setText(issuedOn);
        String expiresOn = this.formatCertificateDate(context, this.getValidNotAfterDate());
        ((TextView)certificateView.findViewById(16908852)).setText(expiresOn);
        ((TextView)certificateView.findViewById(16909256)).setText(SslCertificate.getDigest(this.mX509Certificate, "SHA256"));
        ((TextView)certificateView.findViewById(16909254)).setText(SslCertificate.getDigest(this.mX509Certificate, "SHA1"));
        return certificateView;
    }

    private final String $$robo$$android_net_http_SslCertificate$formatCertificateDate(Context context, Date certificateDate) {
        if (certificateDate == null) {
            return "";
        }
        return DateFormat.getMediumDateFormat(context).format(certificateDate);
    }

    static void __staticInitializer__() {
        ISO_8601_DATE_FORMAT = "yyyy-MM-dd HH:mm:ssZ";
    }

    public static Bundle saveState(SslCertificate sslCertificate) {
        return InvokeDynamicSupport.bootstrapStatic("saveState", $$robo$$android_net_http_SslCertificate$saveState(android.net.http.SslCertificate ), (SslCertificate)sslCertificate);
    }

    public static SslCertificate restoreState(Bundle bundle) {
        return InvokeDynamicSupport.bootstrapStatic("restoreState", $$robo$$android_net_http_SslCertificate$restoreState(android.os.Bundle ), (Bundle)bundle);
    }

    private void __constructor__(String string2, String string3, String string4, String string5) {
        this.$$robo$$android_net_http_SslCertificate$__constructor__(string2, string3, string4, string5);
    }

    public SslCertificate(String string2, String string3, String string4, String string5) {
        this(string2, string3, SslCertificate.parseDate(string4), SslCertificate.parseDate(string5), null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_http_SslCertificate$__constructor__(java.lang.String java.lang.String java.lang.String java.lang.String ), this, string2, string3, string4, string5);
    }

    private void __constructor__(String string2, String string3, Date date, Date date2) {
        this.$$robo$$android_net_http_SslCertificate$__constructor__(string2, string3, date, date2);
    }

    public SslCertificate(String string2, String string3, Date date, Date date2) {
        this(string2, string3, date, date2, null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_http_SslCertificate$__constructor__(java.lang.String java.lang.String java.util.Date java.util.Date ), this, string2, string3, date, date2);
    }

    private void __constructor__(X509Certificate x509Certificate) {
        this.$$robo$$android_net_http_SslCertificate$__constructor__(x509Certificate);
    }

    public SslCertificate(X509Certificate x509Certificate) {
        this(x509Certificate.getSubjectDN().getName(), x509Certificate.getIssuerDN().getName(), x509Certificate.getNotBefore(), x509Certificate.getNotAfter(), x509Certificate);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_http_SslCertificate$__constructor__(java.security.cert.X509Certificate ), this, x509Certificate);
    }

    private void __constructor__(String string2, String string3, Date date, Date date2, X509Certificate x509Certificate) {
        this.$$robo$$android_net_http_SslCertificate$__constructor__(string2, string3, date, date2, x509Certificate);
    }

    public SslCertificate(String string2, String string3, Date date, Date date2, X509Certificate x509Certificate) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_http_SslCertificate$__constructor__(java.lang.String java.lang.String java.util.Date java.util.Date java.security.cert.X509Certificate ), this, string2, string3, date, date2, x509Certificate);
    }

    public Date getValidNotBeforeDate() {
        return InvokeDynamicSupport.bootstrap("getValidNotBeforeDate", $$robo$$android_net_http_SslCertificate$getValidNotBeforeDate(), this);
    }

    @Deprecated
    public String getValidNotBefore() {
        return InvokeDynamicSupport.bootstrap("getValidNotBefore", $$robo$$android_net_http_SslCertificate$getValidNotBefore(), this);
    }

    public Date getValidNotAfterDate() {
        return InvokeDynamicSupport.bootstrap("getValidNotAfterDate", $$robo$$android_net_http_SslCertificate$getValidNotAfterDate(), this);
    }

    @Deprecated
    public String getValidNotAfter() {
        return InvokeDynamicSupport.bootstrap("getValidNotAfter", $$robo$$android_net_http_SslCertificate$getValidNotAfter(), this);
    }

    public DName getIssuedTo() {
        return InvokeDynamicSupport.bootstrap("getIssuedTo", $$robo$$android_net_http_SslCertificate$getIssuedTo(), this);
    }

    public DName getIssuedBy() {
        return InvokeDynamicSupport.bootstrap("getIssuedBy", $$robo$$android_net_http_SslCertificate$getIssuedBy(), this);
    }

    private static String getSerialNumber(X509Certificate x509Certificate) {
        return InvokeDynamicSupport.bootstrapStatic("getSerialNumber", $$robo$$android_net_http_SslCertificate$getSerialNumber(java.security.cert.X509Certificate ), (X509Certificate)x509Certificate);
    }

    private static String getDigest(X509Certificate x509Certificate, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("getDigest", $$robo$$android_net_http_SslCertificate$getDigest(java.security.cert.X509Certificate java.lang.String ), (X509Certificate)x509Certificate, (String)string2);
    }

    private static String fingerprint(byte[] byArray) {
        return InvokeDynamicSupport.bootstrapStatic("fingerprint", $$robo$$android_net_http_SslCertificate$fingerprint(byte[] ), (byte[])byArray);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_net_http_SslCertificate$toString(), this);
    }

    private static Date parseDate(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("parseDate", $$robo$$android_net_http_SslCertificate$parseDate(java.lang.String ), (String)string2);
    }

    private static String formatDate(Date date) {
        return InvokeDynamicSupport.bootstrapStatic("formatDate", $$robo$$android_net_http_SslCertificate$formatDate(java.util.Date ), (Date)date);
    }

    private static Date cloneDate(Date date) {
        return InvokeDynamicSupport.bootstrapStatic("cloneDate", $$robo$$android_net_http_SslCertificate$cloneDate(java.util.Date ), (Date)date);
    }

    public View inflateCertificateView(Context context) {
        return InvokeDynamicSupport.bootstrap("inflateCertificateView", $$robo$$android_net_http_SslCertificate$inflateCertificateView(android.content.Context ), this, context);
    }

    private String formatCertificateDate(Context context, Date date) {
        return InvokeDynamicSupport.bootstrap("formatCertificateDate", $$robo$$android_net_http_SslCertificate$formatCertificateDate(android.content.Context java.util.Date ), this, context, date);
    }

    static {
        RobolectricInternals.classInitializing(SslCertificate.class);
    }

    public /* synthetic */ SslCertificate() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SslCertificate)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public class DName
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private String mDName;
        private String mCName;
        private String mOName;
        private String mUName;
        /* synthetic */ SslCertificate this$0;

        private void $$robo$$android_net_http_SslCertificate_DName$__constructor__(SslCertificate this$0, String dName) {
            if (dName != null) {
                this.mDName = dName;
                try {
                    X509Name x509Name = new X509Name(dName);
                    Vector val = x509Name.getValues();
                    Vector oid = x509Name.getOIDs();
                    for (int i = 0; i < oid.size(); ++i) {
                        if (oid.elementAt(i).equals(X509Name.CN)) {
                            if (this.mCName != null) continue;
                            this.mCName = (String)val.elementAt(i);
                            continue;
                        }
                        if (oid.elementAt(i).equals(X509Name.O) && this.mOName == null) {
                            this.mOName = (String)val.elementAt(i);
                            continue;
                        }
                        if (!oid.elementAt(i).equals(X509Name.OU) || this.mUName != null) continue;
                        this.mUName = (String)val.elementAt(i);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }

        private final String $$robo$$android_net_http_SslCertificate_DName$getDName() {
            return this.mDName != null ? this.mDName : "";
        }

        private final String $$robo$$android_net_http_SslCertificate_DName$getCName() {
            return this.mCName != null ? this.mCName : "";
        }

        private final String $$robo$$android_net_http_SslCertificate_DName$getOName() {
            return this.mOName != null ? this.mOName : "";
        }

        private final String $$robo$$android_net_http_SslCertificate_DName$getUName() {
            return this.mUName != null ? this.mUName : "";
        }

        private void __constructor__(SslCertificate sslCertificate, String string2) {
            this.$$robo$$android_net_http_SslCertificate_DName$__constructor__(sslCertificate, string2);
        }

        public DName(SslCertificate sslCertificate, String string2) {
            this.this$0 = sslCertificate;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_http_SslCertificate_DName$__constructor__(android.net.http.SslCertificate java.lang.String ), this, sslCertificate, string2);
        }

        public String getDName() {
            return InvokeDynamicSupport.bootstrap("getDName", $$robo$$android_net_http_SslCertificate_DName$getDName(), this);
        }

        public String getCName() {
            return InvokeDynamicSupport.bootstrap("getCName", $$robo$$android_net_http_SslCertificate_DName$getCName(), this);
        }

        public String getOName() {
            return InvokeDynamicSupport.bootstrap("getOName", $$robo$$android_net_http_SslCertificate_DName$getOName(), this);
        }

        public String getUName() {
            return InvokeDynamicSupport.bootstrap("getUName", $$robo$$android_net_http_SslCertificate_DName$getUName(), this);
        }

        public /* synthetic */ DName() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DName)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

