/*
 * Decompiled with CFR 0.152.
 */
package android.net.metrics;

import android.net.NetworkCapabilities;
import android.system.OsConstants;
import android.util.IntArray;
import android.util.SparseIntArray;
import com.android.internal.util.BitUtils;
import com.android.internal.util.TokenBucket;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ConnectStats
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static int EALREADY;
    private static int EINPROGRESS;
    public int netId;
    public long transports;
    public SparseIntArray errnos;
    public IntArray latencies;
    public TokenBucket mLatencyTb;
    public int mMaxLatencyRecords;
    public int connectCount;
    public int connectBlockingCount;
    public int ipv6ConnectCount;

    private void $$robo$$android_net_metrics_ConnectStats$__constructor__(int netId, long transports, TokenBucket tb, int maxLatencyRecords) {
        this.errnos = new SparseIntArray();
        this.latencies = new IntArray();
        this.connectCount = 0;
        this.connectBlockingCount = 0;
        this.ipv6ConnectCount = 0;
        this.netId = netId;
        this.transports = transports;
        this.mLatencyTb = tb;
        this.mMaxLatencyRecords = maxLatencyRecords;
    }

    private final void $$robo$$android_net_metrics_ConnectStats$addEvent(int errno, int latencyMs, String ipAddr) {
        if (ConnectStats.isSuccess(errno)) {
            this.countConnect(errno, ipAddr);
            this.countLatency(errno, latencyMs);
        } else {
            this.countError(errno);
        }
    }

    private final void $$robo$$android_net_metrics_ConnectStats$countConnect(int errno, String ipAddr) {
        ++this.connectCount;
        if (!ConnectStats.isNonBlocking(errno)) {
            ++this.connectBlockingCount;
        }
        if (ConnectStats.isIPv6(ipAddr)) {
            ++this.ipv6ConnectCount;
        }
    }

    private final void $$robo$$android_net_metrics_ConnectStats$countLatency(int errno, int ms) {
        if (ConnectStats.isNonBlocking(errno)) {
            return;
        }
        if (!this.mLatencyTb.get()) {
            return;
        }
        if (this.latencies.size() >= this.mMaxLatencyRecords) {
            return;
        }
        this.latencies.add(ms);
    }

    private final void $$robo$$android_net_metrics_ConnectStats$countError(int errno) {
        int newcount = this.errnos.get(errno, 0) + 1;
        this.errnos.put(errno, newcount);
    }

    private static final boolean $$robo$$android_net_metrics_ConnectStats$isSuccess(int errno) {
        return errno == 0 || ConnectStats.isNonBlocking(errno);
    }

    private static final boolean $$robo$$android_net_metrics_ConnectStats$isNonBlocking(int errno) {
        return errno == EINPROGRESS || errno == EALREADY;
    }

    private static final boolean $$robo$$android_net_metrics_ConnectStats$isIPv6(String ipAddr) {
        return ipAddr.contains(":");
    }

    private final String $$robo$$android_net_metrics_ConnectStats$toString() {
        StringBuilder builder = new StringBuilder("ConnectStats(").append(this.netId).append(", ");
        for (int t : BitUtils.unpackBits(this.transports)) {
            builder.append(NetworkCapabilities.transportNameOf(t)).append(", ");
        }
        builder.append(String.format("%d success, ", this.connectCount));
        builder.append(String.format("%d blocking, ", this.connectBlockingCount));
        builder.append(String.format("%d IPv6 dst", this.ipv6ConnectCount));
        for (int i = 0; i < this.errnos.size(); ++i) {
            String errno = OsConstants.errnoName(this.errnos.keyAt(i));
            int count = this.errnos.valueAt(i);
            builder.append(String.format(", %s: %d", errno, count));
        }
        return builder.append(")").toString();
    }

    static void __staticInitializer__() {
        EALREADY = OsConstants.EALREADY;
        EINPROGRESS = OsConstants.EINPROGRESS;
    }

    private void __constructor__(int n, long l, TokenBucket tokenBucket, int n2) {
        this.$$robo$$android_net_metrics_ConnectStats$__constructor__(n, l, tokenBucket, n2);
    }

    public ConnectStats(int n, long l, TokenBucket tokenBucket, int n2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_metrics_ConnectStats$__constructor__(int long com.android.internal.util.TokenBucket int ), this, n, l, tokenBucket, n2);
    }

    public void addEvent(int n, int n2, String string2) {
        InvokeDynamicSupport.bootstrap("addEvent", $$robo$$android_net_metrics_ConnectStats$addEvent(int int java.lang.String ), this, n, n2, string2);
    }

    private void countConnect(int n, String string2) {
        InvokeDynamicSupport.bootstrap("countConnect", $$robo$$android_net_metrics_ConnectStats$countConnect(int java.lang.String ), this, n, string2);
    }

    private void countLatency(int n, int n2) {
        InvokeDynamicSupport.bootstrap("countLatency", $$robo$$android_net_metrics_ConnectStats$countLatency(int int ), this, n, n2);
    }

    private void countError(int n) {
        InvokeDynamicSupport.bootstrap("countError", $$robo$$android_net_metrics_ConnectStats$countError(int ), this, n);
    }

    private static boolean isSuccess(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isSuccess", $$robo$$android_net_metrics_ConnectStats$isSuccess(int ), (int)n);
    }

    private static boolean isNonBlocking(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isNonBlocking", $$robo$$android_net_metrics_ConnectStats$isNonBlocking(int ), (int)n);
    }

    private static boolean isIPv6(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isIPv6", $$robo$$android_net_metrics_ConnectStats$isIPv6(java.lang.String ), (String)string2);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_net_metrics_ConnectStats$toString(), this);
    }

    static {
        RobolectricInternals.classInitializing(ConnectStats.class);
    }

    public /* synthetic */ ConnectStats() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ConnectStats)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

