/*
 * Decompiled with CFR 0.152.
 */
package android.net.netlink;

import android.net.netlink.NetlinkConstants;
import android.net.netlink.NetlinkMessage;
import android.net.netlink.StructNdMsg;
import android.net.netlink.StructNdaCacheInfo;
import android.net.netlink.StructNlAttr;
import android.net.netlink.StructNlMsgHdr;
import android.system.OsConstants;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class RtNetlinkNeighborMessage
extends NetlinkMessage
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    public static short NDA_UNSPEC = 0;
    public static short NDA_DST = 1;
    public static short NDA_LLADDR = 2;
    public static short NDA_CACHEINFO = 3;
    public static short NDA_PROBES = 4;
    public static short NDA_VLAN = 5;
    public static short NDA_PORT = 6;
    public static short NDA_VNI = 7;
    public static short NDA_IFINDEX = 8;
    public static short NDA_MASTER = 9;
    private StructNdMsg mNdmsg;
    private InetAddress mDestination;
    private byte[] mLinkLayerAddr;
    private int mNumProbes;
    private StructNdaCacheInfo mCacheInfo;

    private static final StructNlAttr $$robo$$android_net_netlink_RtNetlinkNeighborMessage$findNextAttrOfType(short attrType, ByteBuffer byteBuffer) {
        StructNlAttr nlAttr;
        while (byteBuffer != null && byteBuffer.remaining() > 0 && (nlAttr = StructNlAttr.peek(byteBuffer)) != null) {
            if (nlAttr.nla_type == attrType) {
                return StructNlAttr.parse(byteBuffer);
            }
            if (byteBuffer.remaining() < nlAttr.getAlignedLength()) break;
            byteBuffer.position(byteBuffer.position() + nlAttr.getAlignedLength());
        }
        return null;
    }

    private static final RtNetlinkNeighborMessage $$robo$$android_net_netlink_RtNetlinkNeighborMessage$parse(StructNlMsgHdr header, ByteBuffer byteBuffer) {
        RtNetlinkNeighborMessage neighMsg = new RtNetlinkNeighborMessage(header);
        neighMsg.mNdmsg = StructNdMsg.parse(byteBuffer);
        if (neighMsg.mNdmsg == null) {
            return null;
        }
        int baseOffset = byteBuffer.position();
        StructNlAttr nlAttr = RtNetlinkNeighborMessage.findNextAttrOfType((short)1, byteBuffer);
        if (nlAttr != null) {
            neighMsg.mDestination = nlAttr.getValueAsInetAddress();
        }
        byteBuffer.position(baseOffset);
        nlAttr = RtNetlinkNeighborMessage.findNextAttrOfType((short)2, byteBuffer);
        if (nlAttr != null) {
            neighMsg.mLinkLayerAddr = nlAttr.nla_value;
        }
        byteBuffer.position(baseOffset);
        nlAttr = RtNetlinkNeighborMessage.findNextAttrOfType((short)4, byteBuffer);
        if (nlAttr != null) {
            neighMsg.mNumProbes = nlAttr.getValueAsInt(0);
        }
        byteBuffer.position(baseOffset);
        nlAttr = RtNetlinkNeighborMessage.findNextAttrOfType((short)3, byteBuffer);
        if (nlAttr != null) {
            neighMsg.mCacheInfo = StructNdaCacheInfo.parse(nlAttr.getValueAsByteBuffer());
        }
        int kMinConsumed = 28;
        int kAdditionalSpace = NetlinkConstants.alignedLengthOf(neighMsg.mHeader.nlmsg_len - 28);
        if (byteBuffer.remaining() < kAdditionalSpace) {
            byteBuffer.position(byteBuffer.limit());
        } else {
            byteBuffer.position(baseOffset + kAdditionalSpace);
        }
        return neighMsg;
    }

    private static final byte[] $$robo$$android_net_netlink_RtNetlinkNeighborMessage$newGetNeighborsRequest(int seqNo) {
        int length = 28;
        byte[] bytes = new byte[28];
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
        byteBuffer.order(ByteOrder.nativeOrder());
        StructNlMsgHdr nlmsghdr = new StructNlMsgHdr();
        nlmsghdr.nlmsg_len = 28;
        nlmsghdr.nlmsg_type = (short)30;
        nlmsghdr.nlmsg_flags = (short)769;
        nlmsghdr.nlmsg_seq = seqNo;
        nlmsghdr.pack(byteBuffer);
        StructNdMsg ndmsg = new StructNdMsg();
        ndmsg.pack(byteBuffer);
        return bytes;
    }

    private static final byte[] $$robo$$android_net_netlink_RtNetlinkNeighborMessage$newNewNeighborMessage(int seqNo, InetAddress ip, short nudState, int ifIndex, byte[] llAddr) {
        StructNlMsgHdr nlmsghdr = new StructNlMsgHdr();
        nlmsghdr.nlmsg_type = (short)28;
        nlmsghdr.nlmsg_flags = (short)261;
        nlmsghdr.nlmsg_seq = seqNo;
        RtNetlinkNeighborMessage msg = new RtNetlinkNeighborMessage(nlmsghdr);
        (msg.mNdmsg = new StructNdMsg()).ndm_family = (byte)(ip instanceof Inet6Address ? OsConstants.AF_INET6 : OsConstants.AF_INET);
        msg.mNdmsg.ndm_ifindex = ifIndex;
        msg.mNdmsg.ndm_state = nudState;
        msg.mDestination = ip;
        msg.mLinkLayerAddr = llAddr;
        byte[] bytes = new byte[msg.getRequiredSpace()];
        nlmsghdr.nlmsg_len = bytes.length;
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
        byteBuffer.order(ByteOrder.nativeOrder());
        msg.pack(byteBuffer);
        return bytes;
    }

    private void $$robo$$android_net_netlink_RtNetlinkNeighborMessage$__constructor__(StructNlMsgHdr header) {
        this.mNdmsg = null;
        this.mDestination = null;
        this.mLinkLayerAddr = null;
        this.mNumProbes = 0;
        this.mCacheInfo = null;
    }

    private final StructNdMsg $$robo$$android_net_netlink_RtNetlinkNeighborMessage$getNdHeader() {
        return this.mNdmsg;
    }

    private final InetAddress $$robo$$android_net_netlink_RtNetlinkNeighborMessage$getDestination() {
        return this.mDestination;
    }

    private final byte[] $$robo$$android_net_netlink_RtNetlinkNeighborMessage$getLinkLayerAddress() {
        return this.mLinkLayerAddr;
    }

    private final int $$robo$$android_net_netlink_RtNetlinkNeighborMessage$getProbes() {
        return this.mNumProbes;
    }

    private final StructNdaCacheInfo $$robo$$android_net_netlink_RtNetlinkNeighborMessage$getCacheInfo() {
        return this.mCacheInfo;
    }

    private final int $$robo$$android_net_netlink_RtNetlinkNeighborMessage$getRequiredSpace() {
        int spaceRequired = 28;
        if (this.mDestination != null) {
            spaceRequired += NetlinkConstants.alignedLengthOf(4 + this.mDestination.getAddress().length);
        }
        if (this.mLinkLayerAddr != null) {
            spaceRequired += NetlinkConstants.alignedLengthOf(4 + this.mLinkLayerAddr.length);
        }
        return spaceRequired;
    }

    private static final void $$robo$$android_net_netlink_RtNetlinkNeighborMessage$packNlAttr(short nlType, byte[] nlValue, ByteBuffer byteBuffer) {
        StructNlAttr nlAttr = new StructNlAttr();
        nlAttr.nla_type = nlType;
        nlAttr.nla_value = nlValue;
        nlAttr.nla_len = (short)(4 + nlAttr.nla_value.length);
        nlAttr.pack(byteBuffer);
    }

    private final void $$robo$$android_net_netlink_RtNetlinkNeighborMessage$pack(ByteBuffer byteBuffer) {
        this.getHeader().pack(byteBuffer);
        this.mNdmsg.pack(byteBuffer);
        if (this.mDestination != null) {
            RtNetlinkNeighborMessage.packNlAttr((short)1, this.mDestination.getAddress(), byteBuffer);
        }
        if (this.mLinkLayerAddr != null) {
            RtNetlinkNeighborMessage.packNlAttr((short)2, this.mLinkLayerAddr, byteBuffer);
        }
    }

    private final String $$robo$$android_net_netlink_RtNetlinkNeighborMessage$toString() {
        String ipLiteral = this.mDestination == null ? "" : this.mDestination.getHostAddress();
        return "RtNetlinkNeighborMessage{ nlmsghdr{" + (this.mHeader == null ? "" : this.mHeader.toString()) + "}, ndmsg{" + (this.mNdmsg == null ? "" : this.mNdmsg.toString()) + "}, destination{" + ipLiteral + "} linklayeraddr{" + NetlinkConstants.hexify(this.mLinkLayerAddr) + "} probes{" + this.mNumProbes + "} cacheinfo{" + (this.mCacheInfo == null ? "" : this.mCacheInfo.toString()) + "} }";
    }

    private static StructNlAttr findNextAttrOfType(short s, ByteBuffer byteBuffer) {
        return InvokeDynamicSupport.bootstrapStatic("findNextAttrOfType", $$robo$$android_net_netlink_RtNetlinkNeighborMessage$findNextAttrOfType(short java.nio.ByteBuffer ), (short)s, (ByteBuffer)byteBuffer);
    }

    public static RtNetlinkNeighborMessage parse(StructNlMsgHdr structNlMsgHdr, ByteBuffer byteBuffer) {
        return InvokeDynamicSupport.bootstrapStatic("parse", $$robo$$android_net_netlink_RtNetlinkNeighborMessage$parse(android.net.netlink.StructNlMsgHdr java.nio.ByteBuffer ), (StructNlMsgHdr)structNlMsgHdr, (ByteBuffer)byteBuffer);
    }

    public static byte[] newGetNeighborsRequest(int n) {
        return InvokeDynamicSupport.bootstrapStatic("newGetNeighborsRequest", $$robo$$android_net_netlink_RtNetlinkNeighborMessage$newGetNeighborsRequest(int ), (int)n);
    }

    public static byte[] newNewNeighborMessage(int n, InetAddress inetAddress, short s, int n2, byte[] byArray) {
        return InvokeDynamicSupport.bootstrapStatic("newNewNeighborMessage", $$robo$$android_net_netlink_RtNetlinkNeighborMessage$newNewNeighborMessage(int java.net.InetAddress short int byte[] ), (int)n, (InetAddress)inetAddress, (short)s, (int)n2, (byte[])byArray);
    }

    private void __constructor__(StructNlMsgHdr structNlMsgHdr) {
        this.$$robo$$android_net_netlink_RtNetlinkNeighborMessage$__constructor__(structNlMsgHdr);
    }

    public RtNetlinkNeighborMessage(StructNlMsgHdr structNlMsgHdr) {
        super(structNlMsgHdr);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_netlink_RtNetlinkNeighborMessage$__constructor__(android.net.netlink.StructNlMsgHdr ), this, structNlMsgHdr);
    }

    public StructNdMsg getNdHeader() {
        return InvokeDynamicSupport.bootstrap("getNdHeader", $$robo$$android_net_netlink_RtNetlinkNeighborMessage$getNdHeader(), this);
    }

    public InetAddress getDestination() {
        return InvokeDynamicSupport.bootstrap("getDestination", $$robo$$android_net_netlink_RtNetlinkNeighborMessage$getDestination(), this);
    }

    public byte[] getLinkLayerAddress() {
        return InvokeDynamicSupport.bootstrap("getLinkLayerAddress", $$robo$$android_net_netlink_RtNetlinkNeighborMessage$getLinkLayerAddress(), this);
    }

    public int getProbes() {
        return (int)InvokeDynamicSupport.bootstrap("getProbes", $$robo$$android_net_netlink_RtNetlinkNeighborMessage$getProbes(), this);
    }

    public StructNdaCacheInfo getCacheInfo() {
        return InvokeDynamicSupport.bootstrap("getCacheInfo", $$robo$$android_net_netlink_RtNetlinkNeighborMessage$getCacheInfo(), this);
    }

    public int getRequiredSpace() {
        return (int)InvokeDynamicSupport.bootstrap("getRequiredSpace", $$robo$$android_net_netlink_RtNetlinkNeighborMessage$getRequiredSpace(), this);
    }

    private static void packNlAttr(short s, byte[] byArray, ByteBuffer byteBuffer) {
        InvokeDynamicSupport.bootstrapStatic("packNlAttr", $$robo$$android_net_netlink_RtNetlinkNeighborMessage$packNlAttr(short byte[] java.nio.ByteBuffer ), (short)s, (byte[])byArray, (ByteBuffer)byteBuffer);
    }

    public void pack(ByteBuffer byteBuffer) {
        InvokeDynamicSupport.bootstrap("pack", $$robo$$android_net_netlink_RtNetlinkNeighborMessage$pack(java.nio.ByteBuffer ), this, byteBuffer);
    }

    @Override
    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_net_netlink_RtNetlinkNeighborMessage$toString(), this);
    }

    public /* synthetic */ RtNetlinkNeighborMessage() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RtNetlinkNeighborMessage)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

