/*
 * Decompiled with CFR 0.152.
 */
package android.net.util;

import android.net.INetd;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.util.Log;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class NetdService
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG;
    private static String NETD_SERVICE_NAME = "netd";
    private static long BASE_TIMEOUT_MS = 100L;
    private static long MAX_TIMEOUT_MS = 1000L;

    private void $$robo$$android_net_util_NetdService$__constructor__() {
    }

    private static final INetd $$robo$$android_net_util_NetdService$getInstance() {
        INetd netdInstance = INetd.Stub.asInterface(ServiceManager.getService("netd"));
        if (netdInstance == null) {
            Log.w(TAG, "WARNING: returning null INetd instance.");
        }
        return netdInstance;
    }

    private static final INetd $$robo$$android_net_util_NetdService$get(long maxTimeoutMs) {
        if (maxTimeoutMs == 0L) {
            return NetdService.getInstance();
        }
        long stop = maxTimeoutMs > 0L ? SystemClock.elapsedRealtime() + maxTimeoutMs : Long.MAX_VALUE;
        long timeoutMs = 0L;
        while (true) {
            INetd netdInstance;
            if ((netdInstance = NetdService.getInstance()) != null) {
                return netdInstance;
            }
            long remaining = stop - SystemClock.elapsedRealtime();
            if (remaining <= 0L) break;
            timeoutMs = Math.min(timeoutMs + 100L, 1000L);
            timeoutMs = Math.min(timeoutMs, remaining);
            try {
                Thread.sleep(timeoutMs);
            }
            catch (InterruptedException interruptedException) {}
        }
        return null;
    }

    private static final INetd $$robo$$android_net_util_NetdService$get() {
        return NetdService.get(-1L);
    }

    private static final void $$robo$$android_net_util_NetdService$run(NetdCommand cmd) {
        while (true) {
            try {
                cmd.run(NetdService.get());
                return;
            }
            catch (RemoteException re) {
                Log.e(TAG, "error communicating with netd: " + re);
                continue;
            }
            break;
        }
    }

    static void __staticInitializer__() {
        TAG = NetdService.class.getSimpleName();
    }

    private void __constructor__() {
        this.$$robo$$android_net_util_NetdService$__constructor__();
    }

    public NetdService() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_util_NetdService$__constructor__(), this);
    }

    public static INetd getInstance() {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$android_net_util_NetdService$getInstance());
    }

    public static INetd get(long l) {
        return InvokeDynamicSupport.bootstrapStatic("get", $$robo$$android_net_util_NetdService$get(long ), (long)l);
    }

    public static INetd get() {
        return InvokeDynamicSupport.bootstrapStatic("get", $$robo$$android_net_util_NetdService$get());
    }

    public static void run(NetdCommand netdCommand) {
        InvokeDynamicSupport.bootstrapStatic("run", $$robo$$android_net_util_NetdService$run(android.net.util.NetdService$NetdCommand ), (NetdCommand)netdCommand);
    }

    static {
        RobolectricInternals.classInitializing(NetdService.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NetdService)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static interface NetdCommand
    extends InstrumentedInterface {
        public void run(INetd var1) throws RemoteException;
    }
}

